/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (vec2(-0.1, -1.2) * 0.0) => vec2(-0.0, -0.0)
 * (vec2(-0.1, -1.2) * -1.33) => vec2(0.133, 1.5960001)
 * (vec2(-0.1, -1.2) * 0.85000002) => vec2(-0.085000001, -1.0200001)
 * (vec2(-0.41999999, 0.47999999) * 0.0) => vec2(-0.0, 0.0)
 * (vec2(-0.41999999, 0.47999999) * -1.33) => vec2(0.55860001, -0.63840002)
 * (vec2(-0.41999999, 0.47999999) * 0.85000002) => vec2(-0.35699999, 0.40799999)
 */
#version 120

void main()
{
  float[distance((vec2(-0.1, -1.2) * 0.0), vec2(-0.0, -0.0)) <= 0.0 ? 1 : -1] array0;
  float[distance((vec2(-0.1, -1.2) * -1.33), vec2(0.133, 1.5960001)) <= 1.6015321e-05 ? 1 : -1] array1;
  float[distance((vec2(-0.1, -1.2) * 0.85000002), vec2(-0.085000001, -1.0200001)) <= 1.0235356e-05 ? 1 : -1] array2;
  float[distance((vec2(-0.41999999, 0.47999999) * 0.0), vec2(-0.0, 0.0)) <= 0.0 ? 1 : -1] array3;
  float[distance((vec2(-0.41999999, 0.47999999) * -1.33), vec2(0.55860001, -0.63840002)) <= 8.4828562e-06 ? 1 : -1] array4;
  float[distance((vec2(-0.41999999, 0.47999999) * 0.85000002), vec2(-0.35699999, 0.40799999)) <= 5.4213742e-06 ? 1 : -1] array5;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length());
}
