/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * trunc(vec2(-2.0, -1.4285715)) => vec2(-2.0, -1.0)
 * trunc(vec2(-0.85714287, -0.2857143)) => vec2(-0.0, -0.0)
 * trunc(vec2(0.2857143, 0.85714287)) => vec2(0.0, 0.0)
 * trunc(vec2(1.4285715, 2.0)) => vec2(1.0, 2.0)
 * trunc(vec2(0.0, 45027112.0)) => vec2(0.0, 45027112.0)
 * trunc(vec2(-45027112.0, 1.9584199e+10)) => vec2(-45027112.0, 1.9584199e+10)
 * trunc(vec2(-1.9584199e+10, 4.5027112e+19)) => vec2(-1.9584199e+10, 4.5027112e+19)
 * trunc(vec2(-4.5027112e+19, -2.0)) => vec2(-4.5027112e+19, -2.0)
 */
#version 130

void main()
{
  float[distance(trunc(vec2(-2.0, -1.4285715)), vec2(-2.0, -1.0)) <= 2.236068e-05 ? 1 : -1] array0;
  float[distance(trunc(vec2(-0.85714287, -0.2857143)), vec2(-0.0, -0.0)) <= 0.0 ? 1 : -1] array1;
  float[distance(trunc(vec2(0.2857143, 0.85714287)), vec2(0.0, 0.0)) <= 0.0 ? 1 : -1] array2;
  float[distance(trunc(vec2(1.4285715, 2.0)), vec2(1.0, 2.0)) <= 2.236068e-05 ? 1 : -1] array3;
  float[distance(trunc(vec2(0.0, 45027112.0)), vec2(0.0, 45027112.0)) <= 450.27112 ? 1 : -1] array4;
  float[distance(trunc(vec2(-45027112.0, 1.9584199e+10)), vec2(-45027112.0, 1.9584199e+10)) <= 195842.5 ? 1 : -1] array5;
  float[distance(trunc(vec2(-1.9584199e+10, 4.5027112e+19)), vec2(-1.9584199e+10, 4.5027112e+19)) <= 4.5027112e+14 ? 1 : -1] array6;
  float[distance(trunc(vec2(-4.5027112e+19, -2.0)), vec2(-4.5027112e+19, -2.0)) <= 4.5027112e+14 ? 1 : -1] array7;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length());
}
