/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * asinh(vec4(0.0, 1e-10, -1e-10, 0.1)) => vec4(0.0, 1e-10, -1e-10, 0.099834077)
 * asinh(vec4(-0.1, 1.0, -1.0, 10.0)) => vec4(-0.099834077, 0.88137358, -0.88137358, 2.9982231)
 * asinh(vec4(-10.0, 1e+10, -1e+10, 0.0)) => vec4(-2.9982231, 23.718998, -23.718998, 0.0)
 */
#version 150

void main()
{
  float[distance(asinh(vec4(0.0, 1e-10, -1e-10, 0.1)), vec4(0.0, 1e-10, -1e-10, 0.099834077)) <= 0.00019999999 ? 1 : -1] array0;
  float[distance(asinh(vec4(-0.1, 1.0, -1.0, 10.0)), vec4(-0.099834077, 0.88137358, -0.88137358, 2.9982231)) <= 0.0032485351 ? 1 : -1] array1;
  float[distance(asinh(vec4(-10.0, 1e+10, -1e+10, 0.0)), vec4(-2.9982231, 23.718998, -23.718998, 0.0)) <= 0.033677604 ? 1 : -1] array2;
  gl_Position = vec4(array0.length() + array1.length() + array2.length());
}
