/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * ceil(-2.0) => -2.0
 * ceil(-0.66666669) => -0.0
 * ceil(0.66666669) => 1.0
 * ceil(2.0) => 2.0
 */
#version 150

void main()
{
  float[distance(ceil(-2.0), -2.0) <= 1.9999999e-05 ? 1 : -1] array0;
  float[distance(ceil(-0.66666669), -0.0) <= 0.0 ? 1 : -1] array1;
  float[distance(ceil(0.66666669), 1.0) <= 9.9999997e-06 ? 1 : -1] array2;
  float[distance(ceil(2.0), 2.0) <= 1.9999999e-05 ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
