/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * clamp(-2.0, -1.5, -1.5) => -1.5
 * clamp(-2.0, -1.5, 0.0) => -1.5
 * clamp(-2.0, -1.5, 1.5) => -1.5
 * clamp(-2.0, 0.0, 0.0) => 0.0
 * clamp(-2.0, 0.0, 1.5) => 0.0
 * clamp(-2.0, 1.5, 1.5) => 1.5
 * clamp(-0.66666669, -1.5, -1.5) => -1.5
 * clamp(-0.66666669, -1.5, 0.0) => -0.66666669
 * clamp(-0.66666669, -1.5, 1.5) => -0.66666669
 * clamp(-0.66666669, 0.0, 0.0) => 0.0
 * clamp(-0.66666669, 0.0, 1.5) => 0.0
 * clamp(-0.66666669, 1.5, 1.5) => 1.5
 * clamp(0.66666669, -1.5, -1.5) => -1.5
 * clamp(0.66666669, -1.5, 0.0) => 0.0
 * clamp(0.66666669, -1.5, 1.5) => 0.66666669
 * clamp(0.66666669, 0.0, 0.0) => 0.0
 * clamp(0.66666669, 0.0, 1.5) => 0.66666669
 * clamp(0.66666669, 1.5, 1.5) => 1.5
 * clamp(2.0, -1.5, -1.5) => -1.5
 * clamp(2.0, -1.5, 0.0) => 0.0
 * clamp(2.0, -1.5, 1.5) => 1.5
 * clamp(2.0, 0.0, 0.0) => 0.0
 * clamp(2.0, 0.0, 1.5) => 1.5
 * clamp(2.0, 1.5, 1.5) => 1.5
 */
#version 150

void main()
{
  float[distance(clamp(-2.0, -1.5, -1.5), -1.5) <= 1.5e-05 ? 1 : -1] array0;
  float[distance(clamp(-2.0, -1.5, 0.0), -1.5) <= 1.5e-05 ? 1 : -1] array1;
  float[distance(clamp(-2.0, -1.5, 1.5), -1.5) <= 1.5e-05 ? 1 : -1] array2;
  float[distance(clamp(-2.0, 0.0, 0.0), 0.0) <= 0.0 ? 1 : -1] array3;
  float[distance(clamp(-2.0, 0.0, 1.5), 0.0) <= 0.0 ? 1 : -1] array4;
  float[distance(clamp(-2.0, 1.5, 1.5), 1.5) <= 1.5e-05 ? 1 : -1] array5;
  float[distance(clamp(-0.66666669, -1.5, -1.5), -1.5) <= 1.5e-05 ? 1 : -1] array6;
  float[distance(clamp(-0.66666669, -1.5, 0.0), -0.66666669) <= 6.6666666e-06 ? 1 : -1] array7;
  float[distance(clamp(-0.66666669, -1.5, 1.5), -0.66666669) <= 6.6666666e-06 ? 1 : -1] array8;
  float[distance(clamp(-0.66666669, 0.0, 0.0), 0.0) <= 0.0 ? 1 : -1] array9;
  float[distance(clamp(-0.66666669, 0.0, 1.5), 0.0) <= 0.0 ? 1 : -1] array10;
  float[distance(clamp(-0.66666669, 1.5, 1.5), 1.5) <= 1.5e-05 ? 1 : -1] array11;
  float[distance(clamp(0.66666669, -1.5, -1.5), -1.5) <= 1.5e-05 ? 1 : -1] array12;
  float[distance(clamp(0.66666669, -1.5, 0.0), 0.0) <= 0.0 ? 1 : -1] array13;
  float[distance(clamp(0.66666669, -1.5, 1.5), 0.66666669) <= 6.6666666e-06 ? 1 : -1] array14;
  float[distance(clamp(0.66666669, 0.0, 0.0), 0.0) <= 0.0 ? 1 : -1] array15;
  float[distance(clamp(0.66666669, 0.0, 1.5), 0.66666669) <= 6.6666666e-06 ? 1 : -1] array16;
  float[distance(clamp(0.66666669, 1.5, 1.5), 1.5) <= 1.5e-05 ? 1 : -1] array17;
  float[distance(clamp(2.0, -1.5, -1.5), -1.5) <= 1.5e-05 ? 1 : -1] array18;
  float[distance(clamp(2.0, -1.5, 0.0), 0.0) <= 0.0 ? 1 : -1] array19;
  float[distance(clamp(2.0, -1.5, 1.5), 1.5) <= 1.5e-05 ? 1 : -1] array20;
  float[distance(clamp(2.0, 0.0, 0.0), 0.0) <= 0.0 ? 1 : -1] array21;
  float[distance(clamp(2.0, 0.0, 1.5), 1.5) <= 1.5e-05 ? 1 : -1] array22;
  float[distance(clamp(2.0, 1.5, 1.5), 1.5) <= 1.5e-05 ? 1 : -1] array23;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length() + array20.length() + array21.length() + array22.length() + array23.length());
}
