/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (vec2(-0.1, -1.2) / -1.33) => vec2(0.075187966, 0.90225565)
 * (vec2(-0.1, -1.2) / 0.85000002) => vec2(-0.11764706, -1.4117647)
 * (vec2(-0.41999999, 0.47999999) / -1.33) => vec2(0.31578946, -0.36090225)
 * (vec2(-0.41999999, 0.47999999) / 0.85000002) => vec2(-0.49411762, 0.56470585)
 */
#version 150

void main()
{
  float[distance((vec2(-0.1, -1.2) / -1.33), vec2(0.075187966, 0.90225565)) <= 9.0538306e-06 ? 1 : -1] array0;
  float[distance((vec2(-0.1, -1.2) / 0.85000002), vec2(-0.11764706, -1.4117647)) <= 1.4166582e-05 ? 1 : -1] array1;
  float[distance((vec2(-0.41999999, 0.47999999) / -1.33), vec2(0.31578946, -0.36090225)) <= 4.7955541e-06 ? 1 : -1] array2;
  float[distance((vec2(-0.41999999, 0.47999999) / 0.85000002), vec2(-0.49411762, 0.56470585)) <= 7.5036319e-06 ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
