/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * refract(-1.0, -1.0, 0.5) => 1.0
 * refract(-1.0, -1.0, 2.0) => 1.0
 * refract(-1.0, 1.0, 0.5) => -1.0
 * refract(-1.0, 1.0, 2.0) => -1.0
 * refract(1.0, -1.0, 0.5) => 1.0
 * refract(1.0, -1.0, 2.0) => 1.0
 * refract(1.0, 1.0, 0.5) => -1.0
 * refract(1.0, 1.0, 2.0) => -1.0
 */
#version 150

void main()
{
  float[distance(refract(-1.0, -1.0, 0.5), 1.0) <= 9.9999997e-06 ? 1 : -1] array0;
  float[distance(refract(-1.0, -1.0, 2.0), 1.0) <= 9.9999997e-06 ? 1 : -1] array1;
  float[distance(refract(-1.0, 1.0, 0.5), -1.0) <= 9.9999997e-06 ? 1 : -1] array2;
  float[distance(refract(-1.0, 1.0, 2.0), -1.0) <= 9.9999997e-06 ? 1 : -1] array3;
  float[distance(refract(1.0, -1.0, 0.5), 1.0) <= 9.9999997e-06 ? 1 : -1] array4;
  float[distance(refract(1.0, -1.0, 2.0), 1.0) <= 9.9999997e-06 ? 1 : -1] array5;
  float[distance(refract(1.0, 1.0, 0.5), -1.0) <= 9.9999997e-06 ? 1 : -1] array6;
  float[distance(refract(1.0, 1.0, 2.0), -1.0) <= 9.9999997e-06 ? 1 : -1] array7;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length());
}
