/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * sin(-3.1415927) => 8.7422777e-08
 * sin(-1.0471976) => -0.86602545
 * sin(1.0471976) => 0.86602545
 * sin(3.1415927) => -8.7422777e-08
 */
#version 150

void main()
{
  float[distance(sin(-3.1415927), 8.7422777e-08) <= 9.9999997e-05 ? 1 : -1] array0;
  float[distance(sin(-1.0471976), -0.86602545) <= 0.0008660254 ? 1 : -1] array1;
  float[distance(sin(1.0471976), 0.86602545) <= 0.0008660254 ? 1 : -1] array2;
  float[distance(sin(3.1415927), -8.7422777e-08) <= 9.9999997e-05 ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
