/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * trunc(-2.0) => -2.0
 * trunc(-1.4285715) => -1.0
 * trunc(-0.85714287) => -0.0
 * trunc(-0.2857143) => -0.0
 * trunc(0.2857143) => 0.0
 * trunc(0.85714287) => 0.0
 * trunc(1.4285715) => 1.0
 * trunc(2.0) => 2.0
 * trunc(0.0) => 0.0
 * trunc(45027112.0) => 45027112.0
 * trunc(-45027112.0) => -45027112.0
 * trunc(1.9584199e+10) => 1.9584199e+10
 * trunc(-1.9584199e+10) => -1.9584199e+10
 * trunc(4.5027112e+19) => 4.5027112e+19
 * trunc(-4.5027112e+19) => -4.5027112e+19
 */
#version 150

void main()
{
  float[distance(trunc(-2.0), -2.0) <= 1.9999999e-05 ? 1 : -1] array0;
  float[distance(trunc(-1.4285715), -1.0) <= 9.9999997e-06 ? 1 : -1] array1;
  float[distance(trunc(-0.85714287), -0.0) <= 0.0 ? 1 : -1] array2;
  float[distance(trunc(-0.2857143), -0.0) <= 0.0 ? 1 : -1] array3;
  float[distance(trunc(0.2857143), 0.0) <= 0.0 ? 1 : -1] array4;
  float[distance(trunc(0.85714287), 0.0) <= 0.0 ? 1 : -1] array5;
  float[distance(trunc(1.4285715), 1.0) <= 9.9999997e-06 ? 1 : -1] array6;
  float[distance(trunc(2.0), 2.0) <= 1.9999999e-05 ? 1 : -1] array7;
  float[distance(trunc(0.0), 0.0) <= 0.0 ? 1 : -1] array8;
  float[distance(trunc(45027112.0), 45027112.0) <= 450.27112 ? 1 : -1] array9;
  float[distance(trunc(-45027112.0), -45027112.0) <= 450.27112 ? 1 : -1] array10;
  float[distance(trunc(1.9584199e+10), 1.9584199e+10) <= 195841.98 ? 1 : -1] array11;
  float[distance(trunc(-1.9584199e+10), -1.9584199e+10) <= 195841.98 ? 1 : -1] array12;
  float[distance(trunc(4.5027112e+19), 4.5027112e+19) <= 4.5027112e+14 ? 1 : -1] array13;
  float[distance(trunc(-4.5027112e+19), -4.5027112e+19) <= 4.5027112e+14 ? 1 : -1] array14;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length());
}
