/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0.0lf + dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf)) => dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf)
 * (0.0lf + dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf)) => dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf)
 * (-1.3333333333333333lf + dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf)) => dmat4(-2.333333333333333lf, 0.43666666666666676lf, -1.2433333333333332lf, -2.2433333333333332lf, -1.8833333333333333lf, -0.71333333333333326lf, -2.043333333333333lf, -3.1533333333333333lf, -2.4133333333333331lf, -0.85333333333333328lf, -2.7233333333333332lf, -2.7633333333333332lf, 0.45666666666666678lf, -2.6833333333333336lf, -2.543333333333333lf, -0.61333333333333329lf)
 * (-1.3333333333333333lf + dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf)) => dmat4(-1.2733333333333332lf, 0.26666666666666683lf, -0.083333333333333259lf, -1.4933333333333332lf, -0.023333333333333206lf, -1.6533333333333333lf, -0.8833333333333333lf, -0.8833333333333333lf, 0.18666666666666676lf, -0.82333333333333325lf, 0.56666666666666665lf, -2.2133333333333334lf, -3.293333333333333lf, -3.1733333333333333lf, -2.0533333333333332lf, -0.94333333333333325lf)
 * (0.84999999999999998lf + dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf)) => dmat4(-0.15000000000000002lf, 2.6200000000000001lf, 0.93999999999999995lf, -0.060000000000000053lf, 0.29999999999999993lf, 1.47lf, 0.14000000000000001lf, -0.97000000000000008lf, -0.23000000000000009lf, 1.3300000000000001lf, -0.53999999999999992lf, -0.57999999999999996lf, 2.6400000000000001lf, -0.50000000000000011lf, -0.35999999999999999lf, 1.5699999999999998lf)
 * (0.84999999999999998lf + dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf)) => dmat4(0.90999999999999992lf, 2.4500000000000002lf, 2.1000000000000001lf, 0.68999999999999995lf, 2.1600000000000001lf, 0.53000000000000003lf, 1.3lf, 1.3lf, 2.3700000000000001lf, 1.3599999999999999lf, 2.75lf, -0.030000000000000027lf, -1.1099999999999999lf, -0.9900000000000001lf, 0.13lf, 1.24lf)
 */
#version 400

void main()
{
  double[(distance((0.0lf + dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[0], dvec4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf)) * distance((0.0lf + dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[0], dvec4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf))) + (distance((0.0lf + dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[1], dvec4(-0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf)) * distance((0.0lf + dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[1], dvec4(-0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf))) + (distance((0.0lf + dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[2], dvec4(-1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf)) * distance((0.0lf + dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[2], dvec4(-1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf))) + (distance((0.0lf + dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[3], dvec4(1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf)) * distance((0.0lf + dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[3], dvec4(1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))) <= 2.1855399999999999e-09lf ? 1 : -1] array0;
  double[(distance((0.0lf + dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[0], dvec4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf)) * distance((0.0lf + dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[0], dvec4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf))) + (distance((0.0lf + dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[1], dvec4(1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf)) * distance((0.0lf + dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[1], dvec4(1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf))) + (distance((0.0lf + dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[2], dvec4(1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf)) * distance((0.0lf + dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[2], dvec4(1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf))) + (distance((0.0lf + dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[3], dvec4(-1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf)) * distance((0.0lf + dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[3], dvec4(-1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))) <= 2.1227800000000004e-09lf ? 1 : -1] array1;
  double[(distance((-1.3333333333333333lf + dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[0], dvec4(-2.333333333333333lf, 0.43666666666666676lf, -1.2433333333333332lf, -2.2433333333333332lf)) * distance((-1.3333333333333333lf + dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[0], dvec4(-2.333333333333333lf, 0.43666666666666676lf, -1.2433333333333332lf, -2.2433333333333332lf))) + (distance((-1.3333333333333333lf + dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[1], dvec4(-1.8833333333333333lf, -0.71333333333333326lf, -2.043333333333333lf, -3.1533333333333333lf)) * distance((-1.3333333333333333lf + dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[1], dvec4(-1.8833333333333333lf, -0.71333333333333326lf, -2.043333333333333lf, -3.1533333333333333lf))) + (distance((-1.3333333333333333lf + dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[2], dvec4(-2.4133333333333331lf, -0.85333333333333328lf, -2.7233333333333332lf, -2.7633333333333332lf)) * distance((-1.3333333333333333lf + dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[2], dvec4(-2.4133333333333331lf, -0.85333333333333328lf, -2.7233333333333332lf, -2.7633333333333332lf))) + (distance((-1.3333333333333333lf + dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[3], dvec4(0.45666666666666678lf, -2.6833333333333336lf, -2.543333333333333lf, -0.61333333333333329lf)) * distance((-1.3333333333333333lf + dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[3], dvec4(0.45666666666666678lf, -2.6833333333333336lf, -2.543333333333333lf, -0.61333333333333329lf))) <= 6.6246511111111137e-09lf ? 1 : -1] array2;
  double[(distance((-1.3333333333333333lf + dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[0], dvec4(-1.2733333333333332lf, 0.26666666666666683lf, -0.083333333333333259lf, -1.4933333333333332lf)) * distance((-1.3333333333333333lf + dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[0], dvec4(-1.2733333333333332lf, 0.26666666666666683lf, -0.083333333333333259lf, -1.4933333333333332lf))) + (distance((-1.3333333333333333lf + dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[1], dvec4(-0.023333333333333206lf, -1.6533333333333333lf, -0.8833333333333333lf, -0.8833333333333333lf)) * distance((-1.3333333333333333lf + dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[1], dvec4(-0.023333333333333206lf, -1.6533333333333333lf, -0.8833333333333333lf, -0.8833333333333333lf))) + (distance((-1.3333333333333333lf + dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[2], dvec4(0.18666666666666676lf, -0.82333333333333325lf, 0.56666666666666665lf, -2.2133333333333334lf)) * distance((-1.3333333333333333lf + dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[2], dvec4(0.18666666666666676lf, -0.82333333333333325lf, 0.56666666666666665lf, -2.2133333333333334lf))) + (distance((-1.3333333333333333lf + dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[3], dvec4(-3.293333333333333lf, -3.1733333333333333lf, -2.0533333333333332lf, -0.94333333333333325lf)) * distance((-1.3333333333333333lf + dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[3], dvec4(-3.293333333333333lf, -3.1733333333333333lf, -2.0533333333333332lf, -0.94333333333333325lf))) <= 4.0178911111111102e-09lf ? 1 : -1] array3;
  double[(distance((0.84999999999999998lf + dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[0], dvec4(-0.15000000000000002lf, 2.6200000000000001lf, 0.93999999999999995lf, -0.060000000000000053lf)) * distance((0.84999999999999998lf + dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[0], dvec4(-0.15000000000000002lf, 2.6200000000000001lf, 0.93999999999999995lf, -0.060000000000000053lf))) + (distance((0.84999999999999998lf + dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[1], dvec4(0.29999999999999993lf, 1.47lf, 0.14000000000000001lf, -0.97000000000000008lf)) * distance((0.84999999999999998lf + dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[1], dvec4(0.29999999999999993lf, 1.47lf, 0.14000000000000001lf, -0.97000000000000008lf))) + (distance((0.84999999999999998lf + dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[2], dvec4(-0.23000000000000009lf, 1.3300000000000001lf, -0.53999999999999992lf, -0.57999999999999996lf)) * distance((0.84999999999999998lf + dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[2], dvec4(-0.23000000000000009lf, 1.3300000000000001lf, -0.53999999999999992lf, -0.57999999999999996lf))) + (distance((0.84999999999999998lf + dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[3], dvec4(2.6400000000000001lf, -0.50000000000000011lf, -0.35999999999999999lf, 1.5699999999999998lf)) * distance((0.84999999999999998lf + dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[3], dvec4(2.6400000000000001lf, -0.50000000000000011lf, -0.35999999999999999lf, 1.5699999999999998lf))) <= 2.32494e-09lf ? 1 : -1] array4;
  double[(distance((0.84999999999999998lf + dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[0], dvec4(0.90999999999999992lf, 2.4500000000000002lf, 2.1000000000000001lf, 0.68999999999999995lf)) * distance((0.84999999999999998lf + dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[0], dvec4(0.90999999999999992lf, 2.4500000000000002lf, 2.1000000000000001lf, 0.68999999999999995lf))) + (distance((0.84999999999999998lf + dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[1], dvec4(2.1600000000000001lf, 0.53000000000000003lf, 1.3lf, 1.3lf)) * distance((0.84999999999999998lf + dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[1], dvec4(2.1600000000000001lf, 0.53000000000000003lf, 1.3lf, 1.3lf))) + (distance((0.84999999999999998lf + dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[2], dvec4(2.3700000000000001lf, 1.3599999999999999lf, 2.75lf, -0.030000000000000027lf)) * distance((0.84999999999999998lf + dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[2], dvec4(2.3700000000000001lf, 1.3599999999999999lf, 2.75lf, -0.030000000000000027lf))) + (distance((0.84999999999999998lf + dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[3], dvec4(-1.1099999999999999lf, -0.9900000000000001lf, 0.13lf, 1.24lf)) * distance((0.84999999999999998lf + dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[3], dvec4(-1.1099999999999999lf, -0.9900000000000001lf, 0.13lf, 1.24lf))) <= 3.8839800000000005e-09lf ? 1 : -1] array5;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length());
}
