/*
 * Decompiled with CFR 0.152.
 */
package com.projity.server.data.mspdi;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import net.sf.mpxj.Duration;

public final class XsdDuration {
    private boolean m_hasTime;
    private int m_years;
    private int m_months;
    private int m_days;
    private int m_hours;
    private int m_minutes;
    private double m_seconds;
    private static final DecimalFormatSymbols SYMBOLS = new DecimalFormatSymbols();
    private static final DecimalFormat FORMAT;

    XsdDuration(String string) {
        int n;
        if (string != null && (n = string.length()) > 0) {
            boolean bl;
            int n2;
            if (string.charAt(0) != 'P' && (n < 2 || string.charAt(0) != '-' && string.charAt(1) != 'P')) {
                throw new IllegalArgumentException(string);
            }
            if (string.charAt(0) == '-') {
                n2 = 2;
                bl = true;
            } else {
                n2 = 1;
                bl = false;
            }
            while (n2 < n) {
                n2 = this.readComponent(string, n2, n);
            }
            if (bl) {
                this.m_years = -this.m_years;
                this.m_months = -this.m_months;
                this.m_days = -this.m_days;
                this.m_hours = -this.m_hours;
                this.m_minutes = -this.m_minutes;
                this.m_seconds = -this.m_seconds;
            }
        }
    }

    public XsdDuration(Duration duration) {
        double d;
        if (duration != null && (d = duration.getDuration()) != 0.0) {
            switch (duration.getUnits()) {
                case MINUTES: 
                case ELAPSED_MINUTES: {
                    this.m_minutes = (int)d;
                    this.m_seconds = d * 60.0 - (double)(this.m_minutes * 60);
                    break;
                }
                case HOURS: 
                case ELAPSED_HOURS: {
                    this.m_hours = (int)d;
                    d = d * 60.0 - (double)(this.m_hours * 60);
                    this.m_minutes = (int)d;
                    this.m_seconds = d * 60.0 - (double)(this.m_minutes * 60);
                    break;
                }
                case DAYS: 
                case ELAPSED_DAYS: {
                    this.m_days = (int)d;
                    d = d * 24.0 - (double)(this.m_days * 24);
                    this.m_hours = (int)d;
                    d = d * 60.0 - (double)(this.m_hours * 60);
                    this.m_minutes = (int)d;
                    this.m_seconds = d * 60.0 - (double)(this.m_minutes * 60);
                    break;
                }
                case WEEKS: 
                case ELAPSED_WEEKS: {
                    this.m_days = (int)(d *= 7.0);
                    d = d * 24.0 - (double)(this.m_days * 24);
                    this.m_hours = (int)d;
                    d = d * 60.0 - (double)(this.m_hours * 60);
                    this.m_minutes = (int)d;
                    this.m_seconds = d * 60.0 - (double)(this.m_minutes * 60);
                    break;
                }
                case MONTHS: 
                case ELAPSED_MONTHS: {
                    this.m_months = (int)d;
                    d = d * 28.0 - (double)(this.m_months * 28);
                    this.m_days = (int)d;
                    d = d * 24.0 - (double)(this.m_days * 24);
                    this.m_hours = (int)d;
                    d = d * 60.0 - (double)(this.m_hours * 60);
                    this.m_minutes = (int)d;
                    this.m_seconds = d * 60.0 - (double)(this.m_minutes * 60);
                    break;
                }
                case YEARS: 
                case ELAPSED_YEARS: {
                    this.m_years = (int)d;
                    d = d * 12.0 - (double)(this.m_years * 12);
                    this.m_months = (int)d;
                    d = d * 28.0 - (double)(this.m_months * 28);
                    this.m_days = (int)d;
                    d = d * 24.0 - (double)(this.m_days * 24);
                    this.m_hours = (int)d;
                    d = d * 60.0 - (double)(this.m_hours * 60);
                    this.m_minutes = (int)d;
                    this.m_seconds = d * 60.0 - (double)(this.m_minutes * 60);
                }
            }
        }
    }

    public static long millis(String string) {
        if (string == null || string.equals("0") || string.equals("PT0H0M0S")) {
            return 0L;
        }
        if (string.equals("PT8H0M0S")) {
            return 28800000L;
        }
        return new XsdDuration(string).getMillis();
    }

    private int readComponent2(String string, int n, int n2) {
        char c = '\u0000';
        StringBuffer stringBuffer = new StringBuffer();
        while (n < n2 && (Character.isDigit(c = (char)string.charAt(n)) || c == '.')) {
            stringBuffer.append(c);
            ++n;
        }
        switch (c) {
            case 'Y': {
                this.m_years = Integer.parseInt(stringBuffer.toString());
                break;
            }
            case 'M': {
                if (!this.m_hasTime) {
                    this.m_months = Integer.parseInt(stringBuffer.toString());
                    break;
                }
                this.m_minutes = Integer.parseInt(stringBuffer.toString());
                break;
            }
            case 'D': {
                this.m_days = Integer.parseInt(stringBuffer.toString());
                break;
            }
            case 'T': {
                this.m_hasTime = true;
                break;
            }
            case 'H': {
                this.m_hours = Integer.parseInt(stringBuffer.toString());
                break;
            }
            case 'S': {
                this.m_seconds = Double.parseDouble(stringBuffer.toString());
                break;
            }
            default: {
                throw new IllegalArgumentException(string);
            }
        }
        return ++n;
    }

    public int getDays() {
        return this.m_days;
    }

    public int getHours() {
        return this.m_hours;
    }

    public int getMinutes() {
        return this.m_minutes;
    }

    public int getMonths() {
        return this.m_months;
    }

    public double getSeconds() {
        return this.m_seconds;
    }

    public int getYears() {
        return this.m_years;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("P");
        boolean bl = false;
        if (this.m_years != 0 || this.m_months != 0 || this.m_days != 0) {
            if (this.m_years < 0) {
                bl = true;
                stringBuffer.append(-this.m_years);
            } else {
                stringBuffer.append(this.m_years);
            }
            stringBuffer.append("Y");
            if (this.m_months < 0) {
                bl = true;
                stringBuffer.append(-this.m_months);
            } else {
                stringBuffer.append(this.m_months);
            }
            stringBuffer.append("M");
            if (this.m_days < 0) {
                bl = true;
                stringBuffer.append(-this.m_days);
            } else {
                stringBuffer.append(this.m_days);
            }
            stringBuffer.append("D");
        }
        stringBuffer.append("T");
        if (this.m_hours < 0) {
            bl = true;
            stringBuffer.append(-this.m_hours);
        } else {
            stringBuffer.append(this.m_hours);
        }
        stringBuffer.append("H");
        if (this.m_minutes < 0) {
            bl = true;
            stringBuffer.append(-this.m_minutes);
        } else {
            stringBuffer.append(this.m_minutes);
        }
        stringBuffer.append("M");
        if (this.m_seconds < 0.0) {
            bl = true;
            stringBuffer.append(FORMAT.format(-this.m_seconds));
        } else {
            stringBuffer.append(FORMAT.format(this.m_seconds));
        }
        stringBuffer.append("S");
        if (bl) {
            stringBuffer.insert(0, '-');
        }
        return stringBuffer.toString();
    }

    public long getMillis() {
        return 1000L * ((long)this.m_seconds + 60L * ((long)this.m_minutes + 60L * ((long)this.m_hours + 24L * ((long)this.m_days + (28L * (long)this.m_months + 365L * (long)this.m_years)))));
    }

    private int readComponent(String string, int n, int n2) {
        char c = '\u0000';
        StringBuffer stringBuffer = new StringBuffer();
        while (n < n2 && (Character.isDigit(c = (char)string.charAt(n)) || c == '.')) {
            stringBuffer.append(c);
            ++n;
        }
        switch (c) {
            case 'Y': {
                this.m_years = (int)Math.floor(Double.parseDouble(stringBuffer.toString()));
                break;
            }
            case 'M': {
                if (!this.m_hasTime) {
                    this.m_months = (int)Math.floor(Double.parseDouble(stringBuffer.toString()));
                    break;
                }
                this.m_minutes = (int)((double)this.m_minutes + Math.floor(Double.parseDouble(stringBuffer.toString())));
                break;
            }
            case 'D': {
                this.m_days = (int)Math.floor(Double.parseDouble(stringBuffer.toString()));
                break;
            }
            case 'T': {
                this.m_hasTime = true;
                break;
            }
            case 'H': {
                double d = Double.parseDouble(stringBuffer.toString());
                if ((double)Math.round(d) != d) {
                    this.m_hours = (int)Math.floor(d);
                    double d2 = (d - (double)this.m_hours) * 60.0;
                    this.m_minutes += (int)Math.floor(d2);
                    double d3 = (d2 - (double)this.m_minutes) * 60.0;
                    this.m_seconds += (double)Math.round(d3);
                    break;
                }
                this.m_hours = (int)d;
                break;
            }
            case 'S': {
                this.m_seconds += Double.parseDouble(stringBuffer.toString());
                break;
            }
            default: {
                throw new IllegalArgumentException(string);
            }
        }
        return ++n;
    }

    static {
        SYMBOLS.setDecimalSeparator('.');
        FORMAT = new DecimalFormat("#", SYMBOLS);
    }
}

