/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpx;

import java.io.IOException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.Locale;
import net.sf.mpxj.AccrueType;
import net.sf.mpxj.CodePage;
import net.sf.mpxj.CurrencySymbolPosition;
import net.sf.mpxj.DateOrder;
import net.sf.mpxj.Duration;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectDateFormat;
import net.sf.mpxj.ProjectTimeFormat;
import net.sf.mpxj.Rate;
import net.sf.mpxj.ScheduleFrom;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.Tokenizer;
import net.sf.mpxj.mpx.AccrueTypeUtility;
import net.sf.mpxj.mpx.DurationUtility;
import net.sf.mpxj.mpx.MPXJFormats;
import net.sf.mpxj.mpx.TimeUnitUtility;

final class Record {
    private Locale m_locale;
    private String m_recordNumber;
    private String[] m_fields;
    private MPXJFormats m_formats;

    Record(Locale locale, Tokenizer tokenizer, MPXJFormats mPXJFormats) throws MPXJException {
        try {
            this.m_locale = locale;
            this.m_formats = mPXJFormats;
            LinkedList<String> linkedList = new LinkedList<String>();
            while (tokenizer.nextToken() == -3) {
                linkedList.add(tokenizer.getToken());
            }
            if (linkedList.size() > 0) {
                this.m_recordNumber = (String)linkedList.remove(0);
                this.m_fields = linkedList.toArray(new String[linkedList.size()]);
            }
        }
        catch (IOException iOException) {
            throw new MPXJException("Invalid record", iOException);
        }
    }

    public String getRecordNumber() {
        return this.m_recordNumber;
    }

    public String getString(int n) {
        String string;
        if (n < this.m_fields.length) {
            string = this.m_fields[n];
            if (string != null) {
                string = string.replace('\u007f', '\n');
            }
        } else {
            string = null;
        }
        return string;
    }

    public Character getCharacter(int n) {
        Character c = n < this.m_fields.length && this.m_fields[n].length() != 0 ? Character.valueOf(this.m_fields[n].charAt(0)) : null;
        return c;
    }

    public Number getFloat(int n) throws MPXJException {
        try {
            Number number = n < this.m_fields.length && this.m_fields[n].length() != 0 ? (Number)this.m_formats.getDecimalFormat().parse(this.m_fields[n]) : (Number)null;
            return number;
        }
        catch (ParseException parseException) {
            throw new MPXJException("Failed to parse float", parseException);
        }
    }

    public Integer getInteger(int n) {
        Integer n2 = n < this.m_fields.length && this.m_fields[n].length() != 0 ? Integer.valueOf(this.m_fields[n]) : null;
        return n2;
    }

    public Date getDateTime(int n) throws MPXJException {
        Date date = null;
        if (n < this.m_fields.length && this.m_fields[n].length() != 0) {
            try {
                date = this.m_formats.getDateTimeFormat().parse(this.m_fields[n]);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            if (date == null) {
                try {
                    date = this.m_formats.getDateFormat().parse(this.m_fields[n]);
                }
                catch (ParseException parseException) {
                    throw new MPXJException("Failed to parse date time", parseException);
                }
            }
        }
        return date;
    }

    public Date getDate(int n) throws MPXJException {
        try {
            Date date = n < this.m_fields.length && this.m_fields[n].length() != 0 ? this.m_formats.getDateFormat().parse(this.m_fields[n]) : null;
            return date;
        }
        catch (ParseException parseException) {
            throw new MPXJException("Failed to parse date", parseException);
        }
    }

    public Date getTime(int n) throws MPXJException {
        try {
            Date date = n < this.m_fields.length && this.m_fields[n].length() != 0 ? this.m_formats.getTimeFormat().parse(this.m_fields[n]) : null;
            return date;
        }
        catch (ParseException parseException) {
            throw new MPXJException("Failed to parse time", parseException);
        }
    }

    public boolean getNumericBoolean(int n) {
        boolean bl = false;
        if (n < this.m_fields.length && this.m_fields[n].length() != 0) {
            bl = Integer.parseInt(this.m_fields[n]) == 1;
        }
        return bl;
    }

    public Rate getRate(int n) throws MPXJException {
        Rate rate;
        if (n < this.m_fields.length && this.m_fields[n].length() != 0) {
            try {
                TimeUnit timeUnit;
                double d;
                String string = this.m_fields[n];
                int n2 = string.indexOf(47);
                if (n2 == -1) {
                    d = this.m_formats.getCurrencyFormat().parse(string).doubleValue();
                    timeUnit = TimeUnit.HOURS;
                } else {
                    d = this.m_formats.getCurrencyFormat().parse(string.substring(0, n2)).doubleValue();
                    timeUnit = TimeUnitUtility.getInstance(string.substring(n2 + 1), this.m_locale);
                }
                rate = new Rate(d, timeUnit);
            }
            catch (ParseException parseException) {
                throw new MPXJException("Failed to parse rate", parseException);
            }
        } else {
            rate = null;
        }
        return rate;
    }

    public Number getCurrency(int n) throws MPXJException {
        Number number;
        if (n < this.m_fields.length && this.m_fields[n].length() != 0) {
            try {
                number = this.m_formats.getCurrencyFormat().parse(this.m_fields[n]);
            }
            catch (ParseException parseException) {
                throw new MPXJException("Failed to parse currency", parseException);
            }
        } else {
            number = null;
        }
        return number;
    }

    public Number getPercentage(int n) throws MPXJException {
        Number number;
        if (n < this.m_fields.length && this.m_fields[n].length() != 0) {
            try {
                number = this.m_formats.getPercentageDecimalFormat().parse(this.m_fields[n]);
            }
            catch (ParseException parseException) {
                throw new MPXJException("Failed to parse percentage", parseException);
            }
        } else {
            number = null;
        }
        return number;
    }

    public Duration getDuration(int n) throws MPXJException {
        Duration duration = n < this.m_fields.length && this.m_fields[n].length() != 0 ? DurationUtility.getInstance(this.m_fields[n], this.m_formats.getDurationDecimalFormat(), this.m_locale) : null;
        return duration;
    }

    public Number getUnits(int n) throws MPXJException {
        Double d;
        if (n < this.m_fields.length && this.m_fields[n].length() != 0) {
            try {
                d = this.m_formats.getUnitsDecimalFormat().parse(this.m_fields[n]).doubleValue() * 100.0;
            }
            catch (ParseException parseException) {
                throw new MPXJException("Failed to parse units", parseException);
            }
        } else {
            d = null;
        }
        return d;
    }

    public TimeUnit getTimeUnit(int n) {
        TimeUnit timeUnit = n < this.m_fields.length && this.m_fields[n].length() != 0 ? TimeUnit.getInstance(Integer.parseInt(this.m_fields[n])) : TimeUnit.DAYS;
        return timeUnit;
    }

    public ProjectTimeFormat getTimeFormat(int n) {
        ProjectTimeFormat projectTimeFormat = n < this.m_fields.length && this.m_fields[n].length() != 0 ? ProjectTimeFormat.getInstance(Integer.parseInt(this.m_fields[n])) : ProjectTimeFormat.TWELVE_HOUR;
        return projectTimeFormat;
    }

    public ScheduleFrom getScheduleFrom(int n) {
        ScheduleFrom scheduleFrom = n < this.m_fields.length && this.m_fields[n].length() != 0 ? ScheduleFrom.getInstance(Integer.parseInt(this.m_fields[n])) : ScheduleFrom.START;
        return scheduleFrom;
    }

    public DateOrder getDateOrder(int n) {
        DateOrder dateOrder = n < this.m_fields.length && this.m_fields[n].length() != 0 ? DateOrder.getInstance(Integer.parseInt(this.m_fields[n])) : DateOrder.MDY;
        return dateOrder;
    }

    public CurrencySymbolPosition getCurrencySymbolPosition(int n) {
        CurrencySymbolPosition currencySymbolPosition = n < this.m_fields.length && this.m_fields[n].length() != 0 ? CurrencySymbolPosition.getInstance(Integer.parseInt(this.m_fields[n])) : CurrencySymbolPosition.BEFORE;
        return currencySymbolPosition;
    }

    public ProjectDateFormat getDateFormat(int n) {
        ProjectDateFormat projectDateFormat = null;
        projectDateFormat = n < this.m_fields.length && this.m_fields[n].length() != 0 ? ProjectDateFormat.getInstance(Integer.parseInt(this.m_fields[n])) : ProjectDateFormat.DD_MM_YY;
        return projectDateFormat;
    }

    public CodePage getCodePage(int n) {
        CodePage codePage = n < this.m_fields.length && this.m_fields[n].length() != 0 ? CodePage.getInstance(this.m_fields[n]) : CodePage.getInstance(null);
        return codePage;
    }

    public AccrueType getAccrueType(int n) {
        AccrueType accrueType = n < this.m_fields.length && this.m_fields[n].length() != 0 ? AccrueTypeUtility.getInstance(this.m_fields[n], this.m_locale) : null;
        return accrueType;
    }

    public Boolean getBoolean(int n, String string) {
        Boolean bl = n < this.m_fields.length && this.m_fields[n].length() != 0 ? (this.m_fields[n].equalsIgnoreCase(string) ? Boolean.FALSE : Boolean.TRUE) : null;
        return bl;
    }

    public int getLength() {
        return this.m_fields.length;
    }

    public String toString() {
        return Arrays.toString(this.m_fields);
    }
}

