/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.primavera;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.CurrencySymbolPosition;
import net.sf.mpxj.CustomField;
import net.sf.mpxj.CustomFieldContainer;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.Duration;
import net.sf.mpxj.FieldContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.FieldTypeClass;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.FieldTypeHelper;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.primavera.DatatypeConverter;
import net.sf.mpxj.primavera.UserFieldDataType;
import net.sf.mpxj.primavera.schema.APIBusinessObjects;
import net.sf.mpxj.primavera.schema.ActivityType;
import net.sf.mpxj.primavera.schema.CalendarType;
import net.sf.mpxj.primavera.schema.CurrencyType;
import net.sf.mpxj.primavera.schema.ObjectFactory;
import net.sf.mpxj.primavera.schema.ProjectType;
import net.sf.mpxj.primavera.schema.RelationshipType;
import net.sf.mpxj.primavera.schema.ResourceAssignmentType;
import net.sf.mpxj.primavera.schema.UDFAssignmentType;
import net.sf.mpxj.primavera.schema.UDFTypeType;
import net.sf.mpxj.primavera.schema.WBSType;
import net.sf.mpxj.primavera.schema.WorkTimeType;
import net.sf.mpxj.writer.AbstractProjectWriter;
import org.xml.sax.ContentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PrimaveraPMFileWriter
extends AbstractProjectWriter {
    private static JAXBContext CONTEXT;
    private static JAXBException CONTEXT_EXCEPTION;
    private static final String NILLABLE_STYLESHEET = "<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><xsl:output method=\"xml\" indent=\"yes\"/><xsl:template match=\"node()[not(@xsi:nil = 'true')]|@*\"><xsl:copy><xsl:apply-templates select=\"node()|@*\"/></xsl:copy></xsl:template></xsl:stylesheet>";
    private static final Integer PROJECT_OBJECT_ID;
    private static final String PROJECT_ID = "PROJECT";
    private static final String RESOURCE_ID_PREFIX = "RESOURCE-";
    private static final String DEFAULT_WBS_CODE = "WBS";
    private static final Integer DEFAULT_CURRENCY_ID;
    private static final String[] DAY_NAMES;
    private static final Map<RelationType, String> RELATION_TYPE_MAP;
    private static final Map<ConstraintType, String> CONSTRAINT_TYPE_MAP;
    private ProjectFile m_projectFile;
    private ObjectFactory m_factory;
    private APIBusinessObjects m_apibo;
    private ProjectType m_project;
    private int m_wbsSequence;
    private int m_relationshipObjectID;
    private Calendar m_calendar;
    private TaskField m_activityIDField = TaskField.WBS;

    public void setActivityIdField(TaskField taskField) {
        this.m_activityIDField = taskField;
    }

    public TaskField getActivityIdField() {
        return this.m_activityIDField;
    }

    @Override
    public void write(ProjectFile projectFile, OutputStream outputStream) throws IOException {
        try {
            if (CONTEXT == null) {
                throw CONTEXT_EXCEPTION;
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            TransformerHandler transformerHandler = ((SAXTransformerFactory)transformerFactory).newTransformerHandler(new StreamSource(new ByteArrayInputStream(NILLABLE_STYLESHEET.getBytes())));
            transformerHandler.setResult(new StreamResult(outputStream));
            Transformer transformer = transformerHandler.getTransformer();
            try {
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_projectFile = projectFile;
            this.m_calendar = Calendar.getInstance();
            Marshaller marshaller = CONTEXT.createMarshaller();
            marshaller.setProperty("jaxb.schemaLocation", (Object)"");
            this.m_factory = new ObjectFactory();
            this.m_apibo = this.m_factory.createAPIBusinessObjects();
            this.writeCurrency();
            this.writeUserFieldDefinitions();
            this.writeProjectProperties();
            this.writeCalendars();
            this.writeResources();
            this.writeTasks();
            this.writeAssignments();
            DatatypeConverter.setParentFile(this.m_projectFile);
            marshaller.marshal((Object)this.m_apibo, (ContentHandler)transformerHandler);
        }
        catch (JAXBException jAXBException) {
            throw new IOException(jAXBException.toString());
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new IOException(transformerConfigurationException.toString());
        }
        finally {
            this.m_projectFile = null;
            this.m_factory = null;
            this.m_apibo = null;
            this.m_project = null;
            this.m_wbsSequence = 0;
            this.m_relationshipObjectID = 0;
            this.m_calendar = null;
        }
    }

    private void writeCurrency() {
        ProjectProperties projectProperties = this.m_projectFile.getProjectProperties();
        CurrencyType currencyType = this.m_factory.createCurrencyType();
        this.m_apibo.getCurrency().add(currencyType);
        String string = this.getCurrencyFormat(projectProperties.getSymbolPosition());
        String string2 = "(" + string + ")";
        currencyType.setDecimalPlaces(projectProperties.getCurrencyDigits());
        currencyType.setDecimalSymbol(this.getSymbolName(projectProperties.getDecimalSeparator()));
        currencyType.setDigitGroupingSymbol(this.getSymbolName(projectProperties.getThousandsSeparator()));
        currencyType.setExchangeRate(1.0);
        currencyType.setId("CUR");
        currencyType.setName("Default Currency");
        currencyType.setNegativeSymbol(string2);
        currencyType.setObjectId(DEFAULT_CURRENCY_ID);
        currencyType.setPositiveSymbol(string);
        currencyType.setSymbol(projectProperties.getCurrencySymbol());
    }

    private String getSymbolName(char c) {
        String string = null;
        switch (c) {
            case ',': {
                string = "Comma";
                break;
            }
            case '.': {
                string = "Period";
            }
        }
        return string;
    }

    private String getCurrencyFormat(CurrencySymbolPosition currencySymbolPosition) {
        String string;
        switch (currencySymbolPosition) {
            case AFTER: {
                string = "1.1#";
                break;
            }
            case AFTER_WITH_SPACE: {
                string = "1.1 #";
                break;
            }
            case BEFORE_WITH_SPACE: {
                string = "# 1.1";
                break;
            }
            default: {
                string = "#1.1";
            }
        }
        return string;
    }

    private void writeUserFieldDefinitions() {
        for (CustomField customField : this.m_projectFile.getCustomFields()) {
            if (customField.getFieldType() == null || customField.getFieldType().getDataType() == null) continue;
            UDFTypeType uDFTypeType = this.m_factory.createUDFTypeType();
            uDFTypeType.setObjectId(FieldTypeHelper.getFieldID(customField.getFieldType()));
            uDFTypeType.setDataType(UserFieldDataType.inferUserFieldDataType(customField.getFieldType().getDataType()));
            uDFTypeType.setSubjectArea(UserFieldDataType.inferUserFieldSubjectArea(customField.getFieldType()));
            uDFTypeType.setTitle(customField.getAlias());
            this.m_apibo.getUDFType().add(uDFTypeType);
        }
    }

    private void writeProjectProperties() {
        this.m_project = this.m_factory.createProjectType();
        this.m_apibo.getProject().add(this.m_project);
        ProjectProperties projectProperties = this.m_projectFile.getProjectProperties();
        Task task = this.m_projectFile.getTaskByUniqueID(0);
        UUID uUID = task == null ? null : task.getGUID();
        this.m_project.setActivityDefaultActivityType("Task Dependent");
        this.m_project.setActivityDefaultCalendarObjectId(this.getCalendarUniqueID(this.m_projectFile.getDefaultCalendar()));
        this.m_project.setActivityDefaultDurationType("Fixed Duration and Units");
        this.m_project.setActivityDefaultPercentCompleteType("Duration");
        this.m_project.setActivityDefaultPricePerUnit(NumberHelper.DOUBLE_ZERO);
        this.m_project.setActivityIdBasedOnSelectedActivity(Boolean.TRUE);
        this.m_project.setActivityIdIncrement(10);
        this.m_project.setActivityIdPrefix("A");
        this.m_project.setActivityIdSuffix(1000);
        this.m_project.setActivityPercentCompleteBasedOnActivitySteps(Boolean.FALSE);
        this.m_project.setAddActualToRemaining(Boolean.FALSE);
        this.m_project.setAllowNegativeActualUnitsFlag(Boolean.FALSE);
        this.m_project.setAssignmentDefaultDrivingFlag(Boolean.TRUE);
        this.m_project.setAssignmentDefaultRateType("Price / Unit");
        this.m_project.setCheckOutStatus(Boolean.FALSE);
        this.m_project.setCostQuantityRecalculateFlag(Boolean.FALSE);
        this.m_project.setCreateDate(projectProperties.getCreationDate());
        this.m_project.setCriticalActivityFloatLimit(NumberHelper.DOUBLE_ZERO);
        this.m_project.setCriticalActivityPathType("Critical Float");
        this.m_project.setDataDate(this.m_projectFile.getProjectProperties().getStatusDate());
        this.m_project.setDefaultPriceTimeUnits("Hour");
        this.m_project.setDiscountApplicationPeriod("Month");
        this.m_project.setEarnedValueComputeType("Activity Percent Complete");
        this.m_project.setEarnedValueETCComputeType("ETC = Remaining Cost for Activity");
        this.m_project.setEarnedValueETCUserValue(0.88);
        this.m_project.setEarnedValueUserPercent(0.06);
        this.m_project.setEnableSummarization(Boolean.TRUE);
        this.m_project.setFiscalYearStartMonth(1);
        this.m_project.setFinishDate(projectProperties.getFinishDate());
        this.m_project.setGUID(DatatypeConverter.printUUID(uUID));
        this.m_project.setId(PROJECT_ID);
        this.m_project.setLastUpdateDate(projectProperties.getLastSaved());
        this.m_project.setLevelingPriority(10);
        this.m_project.setLinkActualToActualThisPeriod(Boolean.TRUE);
        this.m_project.setLinkPercentCompleteWithActual(Boolean.TRUE);
        this.m_project.setLinkPlannedAndAtCompletionFlag(Boolean.TRUE);
        this.m_project.setName(projectProperties.getName() == null ? PROJECT_ID : projectProperties.getName());
        this.m_project.setObjectId(PROJECT_OBJECT_ID);
        this.m_project.setPlannedStartDate(projectProperties.getStartDate());
        this.m_project.setPrimaryResourcesCanMarkActivitiesAsCompleted(Boolean.TRUE);
        this.m_project.setResetPlannedToRemainingFlag(Boolean.FALSE);
        this.m_project.setResourceCanBeAssignedToSameActivityMoreThanOnce(Boolean.TRUE);
        this.m_project.setResourcesCanAssignThemselvesToActivities(Boolean.TRUE);
        this.m_project.setResourcesCanEditAssignmentPercentComplete(Boolean.FALSE);
        this.m_project.setResourcesCanMarkAssignmentAsCompleted(Boolean.FALSE);
        this.m_project.setResourcesCanViewInactiveActivities(Boolean.FALSE);
        this.m_project.setRiskLevel("Medium");
        this.m_project.setStartDate(projectProperties.getStartDate());
        this.m_project.setStatus("Active");
        this.m_project.setStrategicPriority(500);
        this.m_project.setSummarizeToWBSLevel(2);
        this.m_project.setSummaryLevel("Assignment Level");
        this.m_project.setUseProjectBaselineForEarnedValue(Boolean.TRUE);
        this.m_project.setWBSCodeSeparator(".");
        this.m_project.getUDF().addAll(this.writeUDFType(FieldTypeClass.PROJECT, projectProperties));
    }

    private void writeCalendars() {
        for (ProjectCalendar projectCalendar : this.m_projectFile.getCalendars()) {
            this.writeCalendar(projectCalendar);
        }
    }

    private void writeCalendar(ProjectCalendar projectCalendar) {
        CalendarType calendarType = this.m_factory.createCalendarType();
        this.m_apibo.getCalendar().add(calendarType);
        String string = projectCalendar.getResource() == null ? "Global" : "Resource";
        calendarType.setBaseCalendarObjectId(this.getCalendarUniqueID(projectCalendar.getParent()));
        calendarType.setIsPersonal(projectCalendar.getResource() == null ? Boolean.FALSE : Boolean.TRUE);
        calendarType.setName(projectCalendar.getName());
        calendarType.setObjectId(projectCalendar.getUniqueID());
        calendarType.setType(string);
        CalendarType.StandardWorkWeek standardWorkWeek = this.m_factory.createCalendarTypeStandardWorkWeek();
        calendarType.setStandardWorkWeek(standardWorkWeek);
        for (Day object2 : EnumSet.allOf(Day.class)) {
            CalendarType.StandardWorkWeek.StandardWorkHours standardWorkHours = this.m_factory.createCalendarTypeStandardWorkWeekStandardWorkHours();
            standardWorkWeek.getStandardWorkHours().add(standardWorkHours);
            standardWorkHours.setDayOfWeek(this.getDayName(object2));
            for (Object object : projectCalendar.getHours(object2)) {
                Object object3 = this.m_factory.createWorkTimeType();
                standardWorkHours.getWorkTime().add((WorkTimeType)object3);
                ((WorkTimeType)object3).setStart(((DateRange)object).getStart());
                ((WorkTimeType)object3).setFinish(this.getEndTime(((DateRange)object).getEnd()));
            }
        }
        CalendarType.HolidayOrExceptions holidayOrExceptions = this.m_factory.createCalendarTypeHolidayOrExceptions();
        calendarType.setHolidayOrExceptions(holidayOrExceptions);
        if (!projectCalendar.getCalendarExceptions().isEmpty()) {
            for (ProjectCalendarException projectCalendarException : projectCalendar.getCalendarExceptions()) {
                this.m_calendar.setTime(projectCalendarException.getFromDate());
                while (this.m_calendar.getTimeInMillis() < projectCalendarException.getToDate().getTime()) {
                    CalendarType.HolidayOrExceptions.HolidayOrException holidayOrException = this.m_factory.createCalendarTypeHolidayOrExceptionsHolidayOrException();
                    holidayOrExceptions.getHolidayOrException().add(holidayOrException);
                    holidayOrException.setDate(this.m_calendar.getTime());
                    for (Object object3 : projectCalendarException) {
                        WorkTimeType workTimeType = this.m_factory.createWorkTimeType();
                        holidayOrException.getWorkTime().add(workTimeType);
                        workTimeType.setStart(((DateRange)object3).getStart());
                        if (((DateRange)object3).getEnd() == null) continue;
                        workTimeType.setFinish(this.getEndTime(((DateRange)object3).getEnd()));
                    }
                    this.m_calendar.add(6, 1);
                }
            }
        }
    }

    private void writeResources() {
        for (Resource resource : this.m_projectFile.getAllResources()) {
            if (resource.getUniqueID() == 0) continue;
            this.writeResource(resource);
        }
    }

    private void writeResource(Resource resource) {
        net.sf.mpxj.primavera.schema.ResourceType resourceType = this.m_factory.createResourceType();
        this.m_apibo.getResource().add(resourceType);
        resourceType.setAutoComputeActuals(Boolean.TRUE);
        resourceType.setCalculateCostFromUnits(Boolean.TRUE);
        resourceType.setCalendarObjectId(this.getCalendarUniqueID(resource.getResourceCalendar()));
        resourceType.setCurrencyObjectId(DEFAULT_CURRENCY_ID);
        resourceType.setDefaultUnitsPerTime(1.0);
        resourceType.setEmailAddress(resource.getEmailAddress());
        resourceType.setGUID(DatatypeConverter.printUUID(resource.getGUID()));
        resourceType.setId(RESOURCE_ID_PREFIX + resource.getUniqueID());
        resourceType.setIsActive(Boolean.TRUE);
        resourceType.setMaxUnitsPerTime(this.getPercentage(resource.getMaxUnits()));
        resourceType.setName(resource.getName());
        resourceType.setObjectId(resource.getUniqueID());
        resourceType.setParentObjectId(resource.getParentID());
        resourceType.setResourceNotes(resource.getNotes());
        resourceType.setResourceType(this.getResourceType(resource));
        resourceType.getUDF().addAll(this.writeUDFType(FieldTypeClass.RESOURCE, resource));
    }

    private void writeTasks() {
        for (Task task : this.m_projectFile.getChildTasks()) {
            this.writeTask(task);
        }
    }

    private void writeChildTasks(Task task) {
        for (Task task2 : task.getChildTasks()) {
            this.writeTask(task2);
        }
    }

    private void writeTask(Task task) {
        if (!task.getNull()) {
            if (task.getSummary()) {
                this.writeWBS(task);
            } else {
                this.writeActivity(task);
            }
        }
    }

    private void writeWBS(Task task) {
        if (task.getUniqueID() != 0) {
            WBSType wBSType = this.m_factory.createWBSType();
            this.m_project.getWBS().add(wBSType);
            String string = task.getWBS();
            string = string == null || string.length() == 0 ? DEFAULT_WBS_CODE : string;
            Task task2 = task.getParentTask();
            Integer n = task2 == null ? null : task2.getUniqueID();
            wBSType.setCode(string);
            wBSType.setGUID(DatatypeConverter.printUUID(task.getGUID()));
            wBSType.setName(task.getName());
            wBSType.setObjectId(task.getUniqueID());
            wBSType.setParentObjectId(n);
            wBSType.setProjectObjectId(PROJECT_OBJECT_ID);
            wBSType.setSequenceNumber(this.m_wbsSequence++);
            wBSType.setStatus("Active");
        }
        this.writeChildTasks(task);
    }

    private void writeActivity(Task task) {
        ActivityType activityType = this.m_factory.createActivityType();
        this.m_project.getActivity().add(activityType);
        Task task2 = task.getParentTask();
        Integer n = task2 == null ? null : task2.getUniqueID();
        activityType.setActualStartDate(task.getActualStart());
        activityType.setActualFinishDate(task.getActualFinish());
        activityType.setAtCompletionDuration(this.getDuration(task.getDuration()));
        activityType.setCalendarObjectId(this.getCalendarUniqueID(task.getCalendar()));
        activityType.setDurationPercentComplete(this.getPercentage(task.getPercentageComplete()));
        activityType.setDurationType("Fixed Units/Time");
        activityType.setFinishDate(task.getFinish());
        activityType.setGUID(DatatypeConverter.printUUID(task.getGUID()));
        activityType.setId(this.getActivityID(task));
        activityType.setName(task.getName());
        activityType.setObjectId(task.getUniqueID());
        activityType.setPercentComplete(this.getPercentage(task.getPercentageComplete()));
        activityType.setPercentCompleteType("Duration");
        activityType.setPrimaryConstraintType(CONSTRAINT_TYPE_MAP.get(task.getConstraintType()));
        activityType.setPrimaryConstraintDate(task.getConstraintDate());
        activityType.setPlannedDuration(this.getDuration(task.getDuration()));
        activityType.setPlannedFinishDate(task.getFinish());
        activityType.setPlannedStartDate(task.getStart());
        activityType.setProjectObjectId(PROJECT_OBJECT_ID);
        activityType.setRemainingDuration(this.getDuration(task.getRemainingDuration()));
        activityType.setRemainingEarlyFinishDate(task.getEarlyFinish());
        activityType.setRemainingEarlyStartDate(task.getResume());
        activityType.setRemainingLaborCost(NumberHelper.DOUBLE_ZERO);
        activityType.setRemainingLaborUnits(NumberHelper.DOUBLE_ZERO);
        activityType.setRemainingNonLaborCost(NumberHelper.DOUBLE_ZERO);
        activityType.setRemainingNonLaborUnits(NumberHelper.DOUBLE_ZERO);
        activityType.setStartDate(task.getStart());
        activityType.setStatus(this.getActivityStatus(task));
        activityType.setType("Resource Dependent");
        activityType.setWBSObjectId(n);
        activityType.getUDF().addAll(this.writeUDFType(FieldTypeClass.TASK, task));
        this.writePredecessors(task);
    }

    private void writeAssignments() {
        for (ResourceAssignment resourceAssignment : this.m_projectFile.getAllResourceAssignments()) {
            Task task;
            Resource resource = resourceAssignment.getResource();
            if (resource == null || (task = resourceAssignment.getTask()) == null || task.getUniqueID() == 0 || task.getSummary()) continue;
            this.writeAssignment(resourceAssignment);
        }
    }

    private void writeAssignment(ResourceAssignment resourceAssignment) {
        ResourceAssignmentType resourceAssignmentType = this.m_factory.createResourceAssignmentType();
        this.m_project.getResourceAssignment().add(resourceAssignmentType);
        Task task = resourceAssignment.getTask();
        Task task2 = task.getParentTask();
        Integer n = task2 == null ? null : task2.getUniqueID();
        resourceAssignmentType.setActivityObjectId(resourceAssignment.getTaskUniqueID());
        resourceAssignmentType.setActualCost(this.getDouble(resourceAssignment.getActualCost()));
        resourceAssignmentType.setActualFinishDate(resourceAssignment.getActualFinish());
        resourceAssignmentType.setActualOvertimeUnits(this.getDuration(resourceAssignment.getActualOvertimeWork()));
        resourceAssignmentType.setActualRegularUnits(this.getDuration(resourceAssignment.getActualWork()));
        resourceAssignmentType.setActualStartDate(resourceAssignment.getActualStart());
        resourceAssignmentType.setActualUnits(this.getDuration(resourceAssignment.getActualWork()));
        resourceAssignmentType.setAtCompletionUnits(this.getDuration(resourceAssignment.getRemainingWork()));
        resourceAssignmentType.setPlannedCost(this.getDouble(resourceAssignment.getActualCost()));
        resourceAssignmentType.setFinishDate(resourceAssignment.getFinish());
        resourceAssignmentType.setGUID(DatatypeConverter.printUUID(resourceAssignment.getGUID()));
        resourceAssignmentType.setObjectId(resourceAssignment.getUniqueID());
        resourceAssignmentType.setPlannedDuration(this.getDuration(resourceAssignment.getWork()));
        resourceAssignmentType.setPlannedFinishDate(resourceAssignment.getFinish());
        resourceAssignmentType.setPlannedStartDate(resourceAssignment.getStart());
        resourceAssignmentType.setPlannedUnits(this.getDuration(resourceAssignment.getWork()));
        resourceAssignmentType.setPlannedUnitsPerTime(this.getPercentage(resourceAssignment.getUnits()));
        resourceAssignmentType.setProjectObjectId(PROJECT_OBJECT_ID);
        resourceAssignmentType.setRateSource("Resource");
        resourceAssignmentType.setRemainingCost(this.getDouble(resourceAssignment.getActualCost()));
        resourceAssignmentType.setRemainingDuration(this.getDuration(resourceAssignment.getRemainingWork()));
        resourceAssignmentType.setRemainingFinishDate(resourceAssignment.getFinish());
        resourceAssignmentType.setRemainingStartDate(resourceAssignment.getStart());
        resourceAssignmentType.setRemainingUnits(this.getDuration(resourceAssignment.getRemainingWork()));
        resourceAssignmentType.setRemainingUnitsPerTime(this.getPercentage(resourceAssignment.getUnits()));
        resourceAssignmentType.setResourceObjectId(resourceAssignment.getResourceUniqueID());
        resourceAssignmentType.setStartDate(resourceAssignment.getStart());
        resourceAssignmentType.setWBSObjectId(n);
        resourceAssignmentType.getUDF().addAll(this.writeUDFType(FieldTypeClass.ASSIGNMENT, resourceAssignment));
    }

    private void writePredecessors(Task task) {
        List<Relation> list = task.getPredecessors();
        for (Relation relation : list) {
            RelationshipType relationshipType = this.m_factory.createRelationshipType();
            this.m_project.getRelationship().add(relationshipType);
            relationshipType.setLag(this.getDuration(relation.getLag()));
            relationshipType.setObjectId(++this.m_relationshipObjectID);
            relationshipType.setPredecessorActivityObjectId(relation.getTargetTask().getUniqueID());
            relationshipType.setSuccessorActivityObjectId(relation.getSourceTask().getUniqueID());
            relationshipType.setPredecessorProjectObjectId(PROJECT_OBJECT_ID);
            relationshipType.setSuccessorProjectObjectId(PROJECT_OBJECT_ID);
            relationshipType.setType(RELATION_TYPE_MAP.get(relation.getType()));
        }
    }

    private List<UDFAssignmentType> writeUDFType(FieldTypeClass fieldTypeClass, FieldContainer fieldContainer) {
        CustomFieldContainer customFieldContainer = this.m_projectFile.getCustomFields();
        ArrayList<UDFAssignmentType> arrayList = new ArrayList<UDFAssignmentType>(customFieldContainer.size());
        for (CustomField customField : customFieldContainer) {
            FieldType fieldType = customField.getFieldType();
            if (fieldType == null || fieldTypeClass != fieldType.getFieldTypeClass()) continue;
            UDFAssignmentType uDFAssignmentType = this.m_factory.createUDFAssignmentType();
            uDFAssignmentType.setTypeObjectId(FieldTypeHelper.getFieldID(fieldType));
            UDFAssignmentType.setUserFieldValue(uDFAssignmentType, fieldType.getDataType(), fieldContainer.getCachedValue(fieldType));
            arrayList.add(uDFAssignmentType);
        }
        return arrayList;
    }

    private Double getDuration(Duration duration) {
        Double d;
        if (duration == null) {
            d = null;
        } else {
            if (duration.getUnits() != TimeUnit.HOURS) {
                duration = duration.convertUnits(TimeUnit.HOURS, this.m_projectFile.getProjectProperties());
            }
            d = duration.getDuration();
        }
        return d;
    }

    private String getDayName(Day day) {
        return DAY_NAMES[day.getValue() - 1];
    }

    private String getResourceType(Resource resource) {
        String string;
        ResourceType resourceType = resource.getType();
        if (resourceType == null) {
            resourceType = ResourceType.WORK;
        }
        switch (resourceType) {
            case MATERIAL: {
                string = "Material";
                break;
            }
            case COST: {
                string = "Nonlabor";
                break;
            }
            default: {
                string = "Labor";
            }
        }
        return string;
    }

    private Double getPercentage(Number number) {
        Double d = null;
        if (number != null) {
            d = number.doubleValue() / 100.0;
        }
        return d;
    }

    private Double getDouble(Number number) {
        Double d = null;
        if (number != null) {
            d = number.doubleValue();
        }
        return d;
    }

    private Date getEndTime(Date date) {
        return new Date(date.getTime() - 60000L);
    }

    private Integer getCalendarUniqueID(ProjectCalendar projectCalendar) {
        return projectCalendar == null ? null : projectCalendar.getUniqueID();
    }

    private String getActivityStatus(Task task) {
        String string = task.getActualStart() == null ? "Not Started" : (task.getActualFinish() == null ? "In Progress" : "Completed");
        return string;
    }

    private String getActivityID(Task task) {
        Object object;
        String string = null;
        if (this.m_activityIDField != null && (object = task.getCachedValue(this.m_activityIDField)) != null) {
            string = object.toString();
        }
        return string;
    }

    ProjectFile getProjectFile() {
        return this.m_projectFile;
    }

    static {
        try {
            System.setProperty("com.sun.xml.bind.v2.runtime.JAXBContextImpl.fastBoot", "true");
            CONTEXT = JAXBContext.newInstance((String)"net.sf.mpxj.primavera.schema", (ClassLoader)PrimaveraPMFileWriter.class.getClassLoader());
        }
        catch (JAXBException jAXBException) {
            CONTEXT_EXCEPTION = jAXBException;
            CONTEXT = null;
        }
        PROJECT_OBJECT_ID = 1;
        DEFAULT_CURRENCY_ID = 1;
        DAY_NAMES = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
        RELATION_TYPE_MAP = new HashMap<RelationType, String>();
        RELATION_TYPE_MAP.put(RelationType.FINISH_START, "Finish to Start");
        RELATION_TYPE_MAP.put(RelationType.FINISH_FINISH, "Finish to Finish");
        RELATION_TYPE_MAP.put(RelationType.START_START, "Start to Start");
        RELATION_TYPE_MAP.put(RelationType.START_FINISH, "Start to Finish");
        CONSTRAINT_TYPE_MAP = new HashMap<ConstraintType, String>();
        CONSTRAINT_TYPE_MAP.put(ConstraintType.START_NO_LATER_THAN, "Start On or Before");
        CONSTRAINT_TYPE_MAP.put(ConstraintType.START_NO_EARLIER_THAN, "Start On or After");
        CONSTRAINT_TYPE_MAP.put(ConstraintType.MUST_FINISH_ON, "Finish On");
        CONSTRAINT_TYPE_MAP.put(ConstraintType.FINISH_NO_LATER_THAN, "Finish On or Before");
        CONSTRAINT_TYPE_MAP.put(ConstraintType.FINISH_NO_EARLIER_THAN, "Finish On or After");
        CONSTRAINT_TYPE_MAP.put(ConstraintType.AS_LATE_AS_POSSIBLE, "As Late As Possible");
        CONSTRAINT_TYPE_MAP.put(ConstraintType.MUST_START_ON, "Mandatory Start");
        CONSTRAINT_TYPE_MAP.put(ConstraintType.MUST_FINISH_ON, "Mandatory Finish");
    }
}

