/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnUtil;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;

public class SvnBindException
extends VcsException {
    public static final int ERROR_BASE = 120000;
    public static final int CATEGORY_SIZE = 5000;
    public static final String ERROR_MESSAGE_FORMAT = "svn: E%d: %s";
    @NotNull
    private final MultiMap<Integer, String> errors;
    @NotNull
    private final MultiMap<Integer, String> warnings;

    public SvnBindException(@NotNull SVNErrorCode code, @NotNull String message) {
        if (code == null) {
            SvnBindException.$$$reportNull$$$0(0);
        }
        if (message == null) {
            SvnBindException.$$$reportNull$$$0(1);
        }
        super(String.format(ERROR_MESSAGE_FORMAT, code.getCode(), message));
        this.errors = MultiMap.create();
        this.warnings = MultiMap.create();
        this.errors.putValue((Object)code.getCode(), (Object)this.getMessage());
    }

    public SvnBindException(@Nullable String message) {
        this(message, null);
    }

    public SvnBindException(@Nullable Throwable cause) {
        this(null, cause);
    }

    public SvnBindException(@Nullable String message, @Nullable Throwable cause) {
        super((String)ObjectUtils.chooseNotNull((Object)message, (Object)SvnBindException.getMessage((Throwable)cause)), cause);
        this.errors = MultiMap.create();
        this.warnings = MultiMap.create();
        this.init(message);
        this.init(cause);
    }

    private void init(@Nullable Throwable throwable) {
        if (throwable instanceof SVNException) {
            SVNException e = (SVNException)throwable;
            int code = e.getErrorMessage().getErrorCode().getCode();
            int type = e.getErrorMessage().getType();
            (type == 0 ? this.errors : this.warnings).putValue((Object)code, (Object)e.getMessage());
        }
    }

    private void init(@Nullable String message) {
        if (!StringUtil.isEmpty((String)message)) {
            SvnBindException.parse(message, SvnUtil.ERROR_PATTERN, this.errors);
            SvnBindException.parse(message, SvnUtil.WARNING_PATTERN, this.warnings);
        }
    }

    public boolean contains(int code) {
        return this.errors.containsKey((Object)code) || this.warnings.containsKey((Object)code);
    }

    public boolean contains(@NotNull SVNErrorCode code) {
        if (code == null) {
            SvnBindException.$$$reportNull$$$0(2);
        }
        return this.contains(code.getCode());
    }

    public boolean containsCategory(int category) {
        int categoryCode = SvnBindException.getCategoryCode(category);
        Condition belongsToCategoryCondition = code -> SvnBindException.getCategoryCode(code) == categoryCode;
        return ContainerUtil.exists((Iterable)this.errors.keySet(), (Condition)belongsToCategoryCondition) || ContainerUtil.exists((Iterable)this.warnings.keySet(), (Condition)belongsToCategoryCondition);
    }

    private static int getCategoryCode(int category) {
        return (category - 120000) / 5000;
    }

    private static void parse(@NotNull String message, @NotNull Pattern pattern, @NotNull MultiMap<Integer, String> map) {
        if (message == null) {
            SvnBindException.$$$reportNull$$$0(3);
        }
        if (pattern == null) {
            SvnBindException.$$$reportNull$$$0(4);
        }
        if (map == null) {
            SvnBindException.$$$reportNull$$$0(5);
        }
        Matcher matcher = pattern.matcher(message);
        while (matcher.find()) {
            map.putValue((Object)Integer.valueOf(matcher.group(2)), (Object)matcher.group());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "code";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/svn/commandLine/SvnBindException";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "contains";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "parse";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

