/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.vcs.VcsException;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.diff.DiffOptions;
import org.jetbrains.idea.svn.integrate.MergeClient;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.SVNDiffClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNRevisionRange;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnKitMergeClient
extends BaseSvnClient
implements MergeClient {
    private static final List<SVNRevisionRange> ALL_REVISIONS_RANGE = Collections.singletonList(new SVNRevisionRange(SVNRevision.create((long)1L), SVNRevision.HEAD));

    @Override
    public void merge(@NotNull SvnTarget source, @NotNull File destination, boolean dryRun, boolean reintegrate, @Nullable DiffOptions diffOptions, @Nullable ProgressTracker handler) throws VcsException {
        if (source == null) {
            SvnKitMergeClient.$$$reportNull$$$0(0);
        }
        if (destination == null) {
            SvnKitMergeClient.$$$reportNull$$$0(1);
        }
        this.assertUrl(source);
        SVNDiffClient client = this.createClient(diffOptions, handler);
        try {
            if (reintegrate) {
                client.doMergeReIntegrate(source.getURL(), source.getPegRevision(), destination, dryRun);
            } else {
                client.doMerge(source.getURL(), source.getPegRevision(), ALL_REVISIONS_RANGE, destination, SVNDepth.UNKNOWN, true, false, dryRun, false);
            }
        }
        catch (SVNException e) {
            throw new VcsException((Throwable)e);
        }
    }

    @Override
    public void merge(@NotNull SvnTarget source, @NotNull SVNRevisionRange range, @NotNull File destination, @Nullable Depth depth, boolean dryRun, boolean recordOnly, boolean force, @Nullable DiffOptions diffOptions, @Nullable ProgressTracker handler) throws VcsException {
        if (source == null) {
            SvnKitMergeClient.$$$reportNull$$$0(2);
        }
        if (range == null) {
            SvnKitMergeClient.$$$reportNull$$$0(3);
        }
        if (destination == null) {
            SvnKitMergeClient.$$$reportNull$$$0(4);
        }
        this.assertUrl(source);
        try {
            this.createClient(diffOptions, handler).doMerge(source.getURL(), source.getPegRevision(), Collections.singletonList(range), destination, SvnKitMergeClient.toDepth(depth), true, force, dryRun, recordOnly);
        }
        catch (SVNException e) {
            throw new VcsException((Throwable)e);
        }
    }

    @Override
    public void merge(@NotNull SvnTarget source1, @NotNull SvnTarget source2, @NotNull File destination, @Nullable Depth depth, boolean useAncestry, boolean dryRun, boolean recordOnly, boolean force, @Nullable DiffOptions diffOptions, @Nullable ProgressTracker handler) throws VcsException {
        if (source1 == null) {
            SvnKitMergeClient.$$$reportNull$$$0(5);
        }
        if (source2 == null) {
            SvnKitMergeClient.$$$reportNull$$$0(6);
        }
        if (destination == null) {
            SvnKitMergeClient.$$$reportNull$$$0(7);
        }
        this.assertUrl(source1);
        this.assertUrl(source2);
        try {
            this.createClient(diffOptions, handler).doMerge(source1.getURL(), source1.getPegRevision(), source2.getURL(), source2.getPegRevision(), destination, SvnKitMergeClient.toDepth(depth), useAncestry, force, dryRun, recordOnly);
        }
        catch (SVNException e) {
            throw new VcsException((Throwable)e);
        }
    }

    @NotNull
    private SVNDiffClient createClient(@Nullable DiffOptions diffOptions, @Nullable ProgressTracker handler) {
        SVNDiffClient client = this.myVcs.getSvnKitManager().createDiffClient();
        client.setMergeOptions(SvnKitMergeClient.toDiffOptions(diffOptions));
        client.setEventHandler(SvnKitMergeClient.toEventHandler(handler));
        SVNDiffClient sVNDiffClient = client;
        if (sVNDiffClient == null) {
            SvnKitMergeClient.$$$reportNull$$$0(8);
        }
        return sVNDiffClient;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destination";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source1";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source2";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/integrate/SvnKitMergeClient";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/integrate/SvnKitMergeClient";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createClient";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

