/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ipnb.configuration;

import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Transient;
import com.sun.javafx.application.PlatformImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="IpnbSettings")
public class IpnbSettings
implements PersistentStateComponent<IpnbSettings> {
    private static final String IPNB_PASSWORD_KEY = "IPNB_SSH_SETTINGS_PASSWORD_KEY";
    private String myUsername;
    private boolean hasFx = true;

    public static IpnbSettings getInstance(@NotNull Project project) {
        if (project == null) {
            IpnbSettings.$$$reportNull$$$0(0);
        }
        return (IpnbSettings)ServiceManager.getService((Project)project, IpnbSettings.class);
    }

    @NotNull
    public String getUsername() {
        String string = StringUtil.notNullize((String)this.myUsername);
        if (string == null) {
            IpnbSettings.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void setUsername(@Nullable String username) {
        this.myUsername = username;
    }

    public boolean hasFx() {
        if (this.hasFx) {
            try {
                PlatformImpl.setImplicitExit((boolean)false);
            }
            catch (NoClassDefFoundError e) {
                this.hasFx = false;
            }
        }
        return this.hasFx;
    }

    public void setHasFx(boolean hasFx) {
        this.hasFx = hasFx;
    }

    @Transient
    @NotNull
    public String getPassword(@NotNull String projectPathHash) {
        if (projectPathHash == null) {
            IpnbSettings.$$$reportNull$$$0(2);
        }
        String username = this.getUsername();
        String url = "";
        String accountName = IpnbSettings.createAccountName(username, "", projectPathHash);
        String newStylePassword = PasswordSafe.getInstance().getPassword(IpnbSettings.class, accountName);
        String string = StringUtil.notNullize((String)(newStylePassword == null ? PasswordSafe.getInstance().getPassword(IpnbSettings.class, username) : newStylePassword));
        if (string == null) {
            IpnbSettings.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Transient
    public void setPassword(@NotNull String password, @NotNull String projectPathHash) {
        if (password == null) {
            IpnbSettings.$$$reportNull$$$0(4);
        }
        if (projectPathHash == null) {
            IpnbSettings.$$$reportNull$$$0(5);
        }
        String username = this.getUsername();
        String url = "";
        String accountName = IpnbSettings.createAccountName(username, "", projectPathHash);
        PasswordSafe.getInstance().setPassword(IpnbSettings.class, accountName, password);
    }

    private static String createAccountName(@NotNull String username, @NotNull String url, @NotNull String projectPath) {
        if (username == null) {
            IpnbSettings.$$$reportNull$$$0(6);
        }
        if (url == null) {
            IpnbSettings.$$$reportNull$$$0(7);
        }
        if (projectPath == null) {
            IpnbSettings.$$$reportNull$$$0(8);
        }
        return IPNB_PASSWORD_KEY + url + username + projectPath;
    }

    public IpnbSettings getState() {
        return this;
    }

    public void loadState(IpnbSettings state) {
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ipnb/configuration/IpnbSettings";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPathHash";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "password";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "username";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ipnb/configuration/IpnbSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsername";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPassword";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPassword";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setPassword";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createAccountName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

