/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.config;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.impl.TaskManagerImpl;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializer;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.jdom.Element;

@State(name="RecentTaskRepositories", storages={@Storage(value="other.xml")})
public class RecentTaskRepositories
implements PersistentStateComponent<Element> {
    private final Set<TaskRepository> myRepositories = new THashSet(HASHING_STRATEGY);
    private static final TObjectHashingStrategy<TaskRepository> HASHING_STRATEGY = new TObjectHashingStrategy<TaskRepository>(){

        public int computeHashCode(TaskRepository object) {
            return object.getUrl() == null ? 0 : object.getUrl().hashCode();
        }

        public boolean equals(TaskRepository o1, TaskRepository o2) {
            return Comparing.equal((String)o1.getUrl(), (String)o2.getUrl());
        }
    };

    public static RecentTaskRepositories getInstance() {
        return (RecentTaskRepositories)ServiceManager.getService(RecentTaskRepositories.class);
    }

    public Set<TaskRepository> getRepositories() {
        return new THashSet((Collection)ContainerUtil.findAll(this.myRepositories, repository -> !StringUtil.isEmptyOrSpaces((String)repository.getUrl())), HASHING_STRATEGY);
    }

    public void addRepositories(Collection<TaskRepository> repositories) {
        ArrayList<TaskRepository> old = new ArrayList<TaskRepository>(this.myRepositories);
        this.myRepositories.clear();
        if (this.doAddReps(repositories)) {
            return;
        }
        this.doAddReps(old);
    }

    private boolean doAddReps(Collection<TaskRepository> repositories) {
        for (TaskRepository repository : repositories) {
            if (StringUtil.isEmptyOrSpaces((String)repository.getUrl())) continue;
            if (this.myRepositories.size() == 10) {
                return true;
            }
            this.myRepositories.add(repository);
        }
        return false;
    }

    public Element getState() {
        return XmlSerializer.serialize((Object)this.myRepositories.toArray(new TaskRepository[this.myRepositories.size()]));
    }

    public void loadState(Element state) {
        this.myRepositories.clear();
        this.myRepositories.addAll(TaskManagerImpl.loadRepositories((Element)state));
    }
}

