/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.youtrack.lang;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.tasks.youtrack.lang.YouTrackFile;
import com.intellij.tasks.youtrack.lang.YouTrackLanguage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YouTrackParserDefinition
implements ParserDefinition {
    private static final Logger LOG = Logger.getInstance(YouTrackParserDefinition.class);
    public static final IElementType ANY_TEXT = new IElementType("ANY_TEXT", (Language)YouTrackLanguage.INSTANCE);
    public static final IElementType QUERY = new IElementType("QUERY", (Language)YouTrackLanguage.INSTANCE);
    public static final IFileElementType FILE = new IFileElementType((Language)YouTrackLanguage.INSTANCE);

    @NotNull
    public Lexer createLexer(Project project) {
        YouTrackMockLexer youTrackMockLexer = new YouTrackMockLexer();
        if (youTrackMockLexer == null) {
            YouTrackParserDefinition.$$$reportNull$$$0(0);
        }
        return youTrackMockLexer;
    }

    public PsiParser createParser(Project project) {
        return new YouTrackMockParser();
    }

    public IFileElementType getFileNodeType() {
        return FILE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = TokenSet.EMPTY;
        if (tokenSet == null) {
            YouTrackParserDefinition.$$$reportNull$$$0(1);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = TokenSet.EMPTY;
        if (tokenSet == null) {
            YouTrackParserDefinition.$$$reportNull$$$0(2);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = TokenSet.EMPTY;
        if (tokenSet == null) {
            YouTrackParserDefinition.$$$reportNull$$$0(3);
        }
        return tokenSet;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        assert (node.getElementType() == QUERY);
        YouTrackQueryElement youTrackQueryElement = new YouTrackQueryElement(node);
        if (youTrackQueryElement == null) {
            YouTrackParserDefinition.$$$reportNull$$$0(4);
        }
        return youTrackQueryElement;
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        return new YouTrackFile(viewProvider);
    }

    public ParserDefinition.SpaceRequirements spaceExistanceTypeBetweenTokens(ASTNode left, ASTNode right) {
        return ParserDefinition.SpaceRequirements.MAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/tasks/youtrack/lang/YouTrackParserDefinition";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createLexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getWhitespaceTokens";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentTokens";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringLiteralElements";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createElement";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class YouTrackMockParser
    implements PsiParser {
        private YouTrackMockParser() {
        }

        @NotNull
        public ASTNode parse(IElementType root, PsiBuilder builder) {
            PsiBuilder.Marker rootMarker = builder.mark();
            PsiBuilder.Marker queryMarker = builder.mark();
            assert (builder.getTokenType() == null || builder.getTokenType() == ANY_TEXT);
            builder.advanceLexer();
            queryMarker.done(QUERY);
            assert (builder.eof());
            rootMarker.done(root);
            ASTNode aSTNode = builder.getTreeBuilt();
            if (aSTNode == null) {
                YouTrackMockParser.$$$reportNull$$$0(0);
            }
            return aSTNode;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/youtrack/lang/YouTrackParserDefinition$YouTrackMockParser", "parse"));
        }
    }

    private static class YouTrackMockLexer
    extends LexerBase {
        private int myStart;
        private int myEnd;
        private CharSequence myBuffer;

        private YouTrackMockLexer() {
        }

        public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
            if (buffer == null) {
                YouTrackMockLexer.$$$reportNull$$$0(0);
            }
            this.myBuffer = buffer;
            this.myStart = startOffset;
            this.myEnd = endOffset;
        }

        public int getState() {
            return 0;
        }

        @Nullable
        public IElementType getTokenType() {
            return this.myStart >= this.myEnd ? null : ANY_TEXT;
        }

        public int getTokenStart() {
            return this.myStart;
        }

        public int getTokenEnd() {
            return this.myEnd;
        }

        public void advance() {
            this.myStart = this.myEnd;
        }

        @NotNull
        public CharSequence getBufferSequence() {
            CharSequence charSequence = this.myBuffer;
            if (charSequence == null) {
                YouTrackMockLexer.$$$reportNull$$$0(1);
            }
            return charSequence;
        }

        public int getBufferEnd() {
            return this.myEnd;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buffer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/tasks/youtrack/lang/YouTrackParserDefinition$YouTrackMockLexer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/tasks/youtrack/lang/YouTrackParserDefinition$YouTrackMockLexer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBufferSequence";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "start";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class YouTrackQueryElement
    extends ASTWrapperPsiElement {
        YouTrackQueryElement(@NotNull ASTNode node) {
            if (node == null) {
                YouTrackQueryElement.$$$reportNull$$$0(0);
            }
            super(node);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/tasks/youtrack/lang/YouTrackParserDefinition$YouTrackQueryElement", "<init>"));
        }
    }
}

