/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.editor.XmlHighlighterColors;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.xml.SchemaPrefixReference;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class XmlNsPrefixAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            XmlNsPrefixAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            XmlNsPrefixAnnotator.$$$reportNull$$$0(1);
        }
        if (PsiUtilCore.getElementType((PsiElement)element) != XmlTokenType.XML_NAME) {
            return;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof XmlTag) && !(parent instanceof XmlAttribute)) {
            return;
        }
        TextRange elementRange = element.getTextRange();
        List references = ContainerUtil.findAll((Object[])parent.getReferences(), SchemaPrefixReference.class);
        for (SchemaPrefixReference ref : references) {
            TextRange range;
            TextRange rangeInElement = ref.getRangeInElement();
            if (rangeInElement.isEmpty() || !(range = rangeInElement.shiftRight(((XmlElement)ref.getElement()).getTextRange().getStartOffset())).intersects(elementRange)) continue;
            holder.createInfoAnnotation(range, null).setTextAttributes(XmlHighlighterColors.XML_NS_PREFIX);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/daemon/impl/analysis/XmlNsPrefixAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

