/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.ide.DataManager;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.properties.charset.Native2AsciiCharset;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.ChangeFileEncodingAction;
import com.intellij.openapi.vfs.encoding.EncodingUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LossyEncodingInspection
extends LocalInspectionTool {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.LossyEncodingInspection");
    private static final LocalQuickFix CHANGE_ENCODING_FIX = new ChangeEncodingFix();
    private static final LocalQuickFix RELOAD_ENCODING_FIX = new ReloadInAnotherEncodingFix();

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = InspectionsBundle.message((String)"group.names.internationalization.issues", (Object[])new Object[0]);
        if (string == null) {
            LossyEncodingInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"lossy.encoding", (Object[])new Object[0]);
        if (string == null) {
            LossyEncodingInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("LossyEncoding" == null) {
            LossyEncodingInspection.$$$reportNull$$$0(2);
        }
        return "LossyEncoding";
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file2 == null) {
            LossyEncodingInspection.$$$reportNull$$$0(3);
        }
        if (manager == null) {
            LossyEncodingInspection.$$$reportNull$$$0(4);
        }
        if (InjectedLanguageManager.getInstance((Project)file2.getProject()).isInjectedFragment(file2)) {
            return null;
        }
        if (!file2.isPhysical()) {
            return null;
        }
        FileViewProvider viewProvider = file2.getViewProvider();
        if (viewProvider.getBaseLanguage() != file2.getLanguage()) {
            return null;
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        if (!virtualFile.isInLocalFileSystem()) {
            return null;
        }
        CharSequence text = viewProvider.getContents();
        Charset charset = LoadTextUtil.extractCharsetFromFileContent(file2.getProject(), virtualFile, text);
        if (charset instanceof Native2AsciiCharset) {
            return null;
        }
        SmartList descriptors = new SmartList();
        boolean ok2 = LossyEncodingInspection.checkFileLoadedInWrongEncoding(file2, manager, isOnTheFly, virtualFile, charset, (List<ProblemDescriptor>)descriptors);
        if (ok2) {
            LossyEncodingInspection.checkIfCharactersWillBeLostAfterSave(file2, manager, isOnTheFly, text, charset, (List<ProblemDescriptor>)descriptors);
        }
        return descriptors.toArray(new ProblemDescriptor[descriptors.size()]);
    }

    private static boolean checkFileLoadedInWrongEncoding(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean isOnTheFly, @NotNull VirtualFile virtualFile, @NotNull Charset charset, @NotNull List<ProblemDescriptor> descriptors) {
        if (file2 == null) {
            LossyEncodingInspection.$$$reportNull$$$0(5);
        }
        if (manager == null) {
            LossyEncodingInspection.$$$reportNull$$$0(6);
        }
        if (virtualFile == null) {
            LossyEncodingInspection.$$$reportNull$$$0(7);
        }
        if (charset == null) {
            LossyEncodingInspection.$$$reportNull$$$0(8);
        }
        if (descriptors == null) {
            LossyEncodingInspection.$$$reportNull$$$0(9);
        }
        if (FileDocumentManager.getInstance().isFileModified(virtualFile) || !EncodingUtil.canReload(virtualFile)) {
            return true;
        }
        if (!LossyEncodingInspection.isGoodCharset(virtualFile, charset)) {
            descriptors.add(manager.createProblemDescriptor((PsiElement)file2, "File was loaded in the wrong encoding: '" + charset + "'", RELOAD_ENCODING_FIX, ProblemHighlightType.GENERIC_ERROR, isOnTheFly));
            return false;
        }
        return true;
    }

    private static boolean isGoodCharset(@NotNull VirtualFile virtualFile, @NotNull Charset charset) {
        boolean equals;
        byte[] bytesToSave;
        byte[] loadedBytes;
        FileDocumentManager documentManager;
        Document document;
        if (virtualFile == null) {
            LossyEncodingInspection.$$$reportNull$$$0(10);
        }
        if (charset == null) {
            LossyEncodingInspection.$$$reportNull$$$0(11);
        }
        if ((document = (documentManager = FileDocumentManager.getInstance()).getDocument(virtualFile)) == null) {
            return true;
        }
        try {
            loadedBytes = virtualFile.contentsToByteArray();
            bytesToSave = new String(loadedBytes, charset).getBytes(charset);
        }
        catch (Exception e) {
            return true;
        }
        if (loadedBytes.length == 0 && bytesToSave.length == 0) {
            return true;
        }
        byte[] bom = virtualFile.getBOM();
        if (bom != null && !ArrayUtil.startsWith((byte[])bytesToSave, (byte[])bom)) {
            bytesToSave = ArrayUtil.mergeArrays((byte[])bom, (byte[])bytesToSave);
        }
        if (!(equals = Arrays.equals(bytesToSave, loadedBytes)) && LOG.isDebugEnabled()) {
            try {
                String tempDir = FileUtil.getTempDirectory();
                FileUtil.writeToFile((File)new File(tempDir, "lossy-bytes-to-save"), (byte[])bytesToSave);
                FileUtil.writeToFile((File)new File(tempDir, "lossy-loaded-bytes"), (byte[])loadedBytes);
                LOG.debug("lossy bytes dumped into " + tempDir);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return equals;
    }

    private static void checkIfCharactersWillBeLostAfterSave(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean isOnTheFly, @NotNull CharSequence text, @NotNull Charset charset, @NotNull List<ProblemDescriptor> descriptors) {
        if (file2 == null) {
            LossyEncodingInspection.$$$reportNull$$$0(12);
        }
        if (manager == null) {
            LossyEncodingInspection.$$$reportNull$$$0(13);
        }
        if (text == null) {
            LossyEncodingInspection.$$$reportNull$$$0(14);
        }
        if (charset == null) {
            LossyEncodingInspection.$$$reportNull$$$0(15);
        }
        if (descriptors == null) {
            LossyEncodingInspection.$$$reportNull$$$0(16);
        }
        int errorCount = 0;
        int start = -1;
        CharBuffer buffer = CharBuffer.wrap(text);
        for (int i = 0; i <= text.length(); ++i) {
            int end;
            char c = i >= text.length() ? (char)'\u0000' : text.charAt(i);
            int n = end = Character.isHighSurrogate(c) && i < text.length() - 1 ? i + 2 : i + 1;
            if (i == text.length() || LossyEncodingInspection.isRepresentable(buffer, i, end, charset)) {
                if (start != -1) {
                    TextRange range = new TextRange(start, i);
                    String message = InspectionsBundle.message((String)"unsupported.character.for.the.charset", (Object[])new Object[]{charset});
                    ProblemDescriptor descriptor2 = manager.createProblemDescriptor((PsiElement)file2, range, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, new LocalQuickFix[]{CHANGE_ENCODING_FIX});
                    descriptors.add(descriptor2);
                    start = -1;
                    if (errorCount++ > 200) {
                        break;
                    }
                }
            } else if (start == -1) {
                start = i;
            }
            if (end == i + 1) continue;
            ++i;
        }
    }

    private static boolean isRepresentable(@NotNull CharBuffer srcBuffer, int start, int end, @NotNull Charset charset) {
        if (srcBuffer == null) {
            LossyEncodingInspection.$$$reportNull$$$0(17);
        }
        if (charset == null) {
            LossyEncodingInspection.$$$reportNull$$$0(18);
        }
        srcBuffer.position(start);
        srcBuffer.limit(end);
        ByteBuffer out = charset.encode(srcBuffer);
        CharBuffer buffer = charset.decode(out);
        srcBuffer.position(start);
        return buffer.equals(srcBuffer);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/LossyEncodingInspection";
                break;
            }
            case 3: 
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 8: 
            case 11: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 9: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcBuffer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/LossyEncodingInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkFileLoadedInWrongEncoding";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isGoodCharset";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "checkIfCharactersWillBeLostAfterSave";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isRepresentable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ChangeEncodingFix
    implements LocalQuickFix {
        private ChangeEncodingFix() {
        }

        @NotNull
        public String getFamilyName() {
            if ("Change file encoding" == null) {
                ChangeEncodingFix.$$$reportNull$$$0(0);
            }
            return "Change file encoding";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Editor editor;
            if (project == null) {
                ChangeEncodingFix.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                ChangeEncodingFix.$$$reportNull$$$0(2);
            }
            PsiFile psiFile = descriptor2.getPsiElement().getContainingFile();
            VirtualFile virtualFile = psiFile.getVirtualFile();
            DataContext dataContext = ChangeEncodingFix.createDataContext(editor, (editor = PsiUtilBase.findEditor((PsiElement)psiFile)) == null ? null : editor.getComponent(), virtualFile, project);
            ListPopup popup2 = new ChangeFileEncodingAction().createPopup(dataContext);
            if (popup2 != null) {
                popup2.showInBestPositionFor(dataContext);
            }
        }

        @NotNull
        static DataContext createDataContext(Editor editor, Component component, VirtualFile selectedFile, Project project) {
            DataContext parent = DataManager.getInstance().getDataContext(component);
            DataContext context = SimpleDataContext.getSimpleContext(PlatformDataKeys.CONTEXT_COMPONENT.getName(), editor == null ? null : editor.getComponent(), parent);
            DataContext projectContext = SimpleDataContext.getSimpleContext(CommonDataKeys.PROJECT.getName(), project, context);
            DataContext dataContext = SimpleDataContext.getSimpleContext(CommonDataKeys.VIRTUAL_FILE.getName(), selectedFile, projectContext);
            if (dataContext == null) {
                ChangeEncodingFix.$$$reportNull$$$0(3);
            }
            return dataContext;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/LossyEncodingInspection$ChangeEncodingFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/LossyEncodingInspection$ChangeEncodingFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createDataContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ReloadInAnotherEncodingFix
    extends ChangeEncodingFix {
        private ReloadInAnotherEncodingFix() {
        }

        @NotNull
        public String getName() {
            if ("Reload in another encoding" == null) {
                ReloadInAnotherEncodingFix.$$$reportNull$$$0(0);
            }
            return "Reload in another encoding";
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                ReloadInAnotherEncodingFix.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                ReloadInAnotherEncodingFix.$$$reportNull$$$0(2);
            }
            if (FileDocumentManager.getInstance().isFileModified(descriptor2.getPsiElement().getContainingFile().getVirtualFile())) {
                return;
            }
            super.applyFix(project, descriptor2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/LossyEncodingInspection$ReloadInAnotherEncodingFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/LossyEncodingInspection$ReloadInAnotherEncodingFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

