/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.PerformFixesModalTask;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ClickListener;
import com.intellij.util.Consumer;
import com.intellij.util.SequentialModalProgressTask;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class QuickFixAction
extends AnAction
implements CustomComponentAction {
    private static final Logger LOG = Logger.getInstance(QuickFixAction.class);
    public static final QuickFixAction[] EMPTY = new QuickFixAction[0];
    protected final InspectionToolWrapper myToolWrapper;

    protected static InspectionResultsView getInvoker(AnActionEvent e) {
        return (InspectionResultsView)InspectionResultsView.DATA_KEY.getData(e.getDataContext());
    }

    protected QuickFixAction(String text, @NotNull InspectionToolWrapper toolWrapper) {
        if (toolWrapper == null) {
            QuickFixAction.$$$reportNull$$$0(0);
        }
        this(text, AllIcons.Actions.CreateFromUsage, null, toolWrapper);
    }

    protected QuickFixAction(String text, Icon icon, KeyStroke keyStroke, @NotNull InspectionToolWrapper toolWrapper) {
        if (toolWrapper == null) {
            QuickFixAction.$$$reportNull$$$0(1);
        }
        super(text, null, icon);
        this.myToolWrapper = toolWrapper;
        if (keyStroke != null) {
            this.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(keyStroke), null);
        }
    }

    public void update(AnActionEvent e) {
        InspectionResultsView view = QuickFixAction.getInvoker(e);
        if (view == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        e.getPresentation().setVisible(false);
        e.getPresentation().setEnabled(false);
        InspectionTree tree = view.getTree();
        InspectionToolWrapper toolWrapper = tree.getSelectedToolWrapper(true);
        if (!view.isSingleToolInSelection() || toolWrapper != this.myToolWrapper) {
            return;
        }
        if (!this.isProblemDescriptorsAcceptable() && tree.getSelectedElements().length > 0 || this.isProblemDescriptorsAcceptable() && tree.getSelectedDescriptors().length > 0) {
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(true);
        }
    }

    protected boolean isProblemDescriptorsAcceptable() {
        return false;
    }

    public String getText() {
        return this.getTemplatePresentation().getText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(AnActionEvent e) {
        InspectionResultsView view = QuickFixAction.getInvoker(e);
        InspectionTree tree = view.getTree();
        try {
            Ref descriptors = Ref.create();
            THashSet readOnlyFiles = new THashSet();
            if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> QuickFixAction.lambda$actionPerformed$1(descriptors, tree, (Set)readOnlyFiles), InspectionsBundle.message((String)"preparing.for.apply.fix", (Object[])new Object[0]), true, e.getProject())) {
                return;
            }
            if (this.isProblemDescriptorsAcceptable() && ((CommonProblemDescriptor[])descriptors.get()).length > 0) {
                this.doApplyFix(view.getProject(), (CommonProblemDescriptor[])descriptors.get(), (Set<VirtualFile>)readOnlyFiles, tree.getContext());
            } else {
                this.doApplyFix(QuickFixAction.getSelectedElements(view), view);
            }
        }
        finally {
            view.setApplyingFix(false);
        }
    }

    protected void applyFix(@NotNull Project project, @NotNull GlobalInspectionContextImpl context, @NotNull CommonProblemDescriptor[] descriptors, @NotNull Set<PsiElement> ignoredElements) {
        if (project == null) {
            QuickFixAction.$$$reportNull$$$0(2);
        }
        if (context == null) {
            QuickFixAction.$$$reportNull$$$0(3);
        }
        if (descriptors == null) {
            QuickFixAction.$$$reportNull$$$0(4);
        }
        if (ignoredElements == null) {
            QuickFixAction.$$$reportNull$$$0(5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doApplyFix(@NotNull Project project, @NotNull CommonProblemDescriptor[] descriptors, @NotNull Set<VirtualFile> readOnlyFiles, @NotNull GlobalInspectionContextImpl context) {
        if (project == null) {
            QuickFixAction.$$$reportNull$$$0(6);
        }
        if (descriptors == null) {
            QuickFixAction.$$$reportNull$$$0(7);
        }
        if (readOnlyFiles == null) {
            QuickFixAction.$$$reportNull$$$0(8);
        }
        if (context == null) {
            QuickFixAction.$$$reportNull$$$0(9);
        }
        if (!FileModificationService.getInstance().prepareVirtualFilesForWrite(project, readOnlyFiles)) {
            return;
        }
        RefManagerImpl refManager = (RefManagerImpl)context.getRefManager();
        boolean initial = refManager.isInProcess();
        refManager.inspectionReadActionFinished();
        try {
            HashSet<PsiElement> resolvedElements = new HashSet<PsiElement>();
            this.performFixesInBatch(project, descriptors, context, resolvedElements);
            QuickFixAction.refreshViews(project, resolvedElements, this.myToolWrapper);
        }
        finally {
            if (initial) {
                refManager.inspectionReadActionStarted();
            }
        }
    }

    protected boolean startInWriteAction() {
        return false;
    }

    protected void performFixesInBatch(@NotNull Project project, @NotNull CommonProblemDescriptor[] descriptors, @NotNull GlobalInspectionContextImpl context, Set<PsiElement> ignoredElements) {
        if (project == null) {
            QuickFixAction.$$$reportNull$$$0(10);
        }
        if (descriptors == null) {
            QuickFixAction.$$$reportNull$$$0(11);
        }
        if (context == null) {
            QuickFixAction.$$$reportNull$$$0(12);
        }
        String templatePresentationText = this.getTemplatePresentation().getText();
        assert (templatePresentationText != null);
        CommandProcessor.getInstance().executeCommand(project, () -> {
            if (project == null) {
                QuickFixAction.$$$reportNull$$$0(30);
            }
            if (descriptors == null) {
                QuickFixAction.$$$reportNull$$$0(31);
            }
            if (context == null) {
                QuickFixAction.$$$reportNull$$$0(32);
            }
            CommandProcessor.getInstance().markCurrentCommandAsGlobal(project);
            boolean startInWriteAction = this.startInWriteAction();
            PerformFixesTask performFixesTask = new PerformFixesTask(project, descriptors, ignoredElements, context);
            if (startInWriteAction) {
                ((ApplicationImpl)ApplicationManager.getApplication()).runWriteActionWithProgressInDispatchThread(templatePresentationText, project, null, null, (Consumer<ProgressIndicator>)((Consumer)performFixesTask::doRun));
            } else {
                SequentialModalProgressTask progressTask = new SequentialModalProgressTask(project, templatePresentationText, true);
                progressTask.setMinIterationTime(200L);
                progressTask.setTask(performFixesTask);
                ProgressManager.getInstance().run((Task)progressTask);
            }
        }, templatePresentationText, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doApplyFix(@NotNull RefEntity[] refElements, @NotNull InspectionResultsView view) {
        if (refElements == null) {
            QuickFixAction.$$$reportNull$$$0(13);
        }
        if (view == null) {
            QuickFixAction.$$$reportNull$$$0(14);
        }
        RefManagerImpl refManager = (RefManagerImpl)view.getGlobalInspectionContext().getRefManager();
        boolean initial = refManager.isInProcess();
        refManager.inspectionReadActionFinished();
        try {
            boolean[] refreshNeeded = new boolean[]{false};
            if (refElements.length > 0) {
                Project project = refElements[0].getRefManager().getProject();
                CommandProcessor.getInstance().executeCommand(project, () -> {
                    if (refElements == null) {
                        QuickFixAction.$$$reportNull$$$0(28);
                    }
                    CommandProcessor.getInstance().markCurrentCommandAsGlobal(project);
                    ApplicationManager.getApplication().runWriteAction(() -> {
                        if (refElements == null) {
                            QuickFixAction.$$$reportNull$$$0(29);
                        }
                        refreshNeeded[0] = this.applyFix(refElements);
                    });
                }, this.getTemplatePresentation().getText(), null);
            }
            if (refreshNeeded[0]) {
                QuickFixAction.refreshViews(view.getProject(), refElements, this.myToolWrapper);
            }
        }
        finally {
            if (initial) {
                refManager.inspectionReadActionStarted();
            }
        }
    }

    public static void removeElements(@NotNull RefEntity[] refElements, @NotNull Project project, @NotNull InspectionToolWrapper toolWrapper) {
        if (refElements == null) {
            QuickFixAction.$$$reportNull$$$0(15);
        }
        if (project == null) {
            QuickFixAction.$$$reportNull$$$0(16);
        }
        if (toolWrapper == null) {
            QuickFixAction.$$$reportNull$$$0(17);
        }
        QuickFixAction.refreshViews(project, refElements, toolWrapper);
        ArrayList deletedRefs = new ArrayList(1);
        for (RefEntity refElement : refElements) {
            if (!(refElement instanceof RefElement)) continue;
            refElement.getRefManager().removeRefElement((RefElement)refElement, deletedRefs);
        }
    }

    private static Set<VirtualFile> getReadOnlyFiles(@NotNull RefEntity[] refElements) {
        if (refElements == null) {
            QuickFixAction.$$$reportNull$$$0(18);
        }
        THashSet readOnlyFiles = new THashSet();
        for (RefEntity refElement : refElements) {
            PsiElement psiElement;
            PsiElement psiElement2 = psiElement = refElement instanceof RefElement ? ((RefElement)refElement).getElement() : null;
            if (psiElement == null || psiElement.getContainingFile() == null) continue;
            readOnlyFiles.add(psiElement.getContainingFile().getVirtualFile());
        }
        return readOnlyFiles;
    }

    @NotNull
    private static RefEntity[] getSelectedElements(InspectionResultsView view) {
        if (view == null) {
            RefElement[] refElementArray = new RefElement[]{};
            if (refElementArray == null) {
                QuickFixAction.$$$reportNull$$$0(19);
            }
            return refElementArray;
        }
        ArrayList<RefEntity> selection = new ArrayList<RefEntity>(Arrays.asList(view.getTree().getSelectedElements()));
        PsiDocumentManager.getInstance((Project)view.getProject()).commitAllDocuments();
        Collections.sort(selection, (o1, o2) -> {
            if (o1 instanceof RefElement && o2 instanceof RefElement) {
                PsiFile containingFile2;
                RefElement r1 = (RefElement)o1;
                RefElement r2 = (RefElement)o2;
                PsiElement element1 = r1.getElement();
                PsiElement element2 = r2.getElement();
                PsiFile containingFile1 = element1.getContainingFile();
                if (containingFile1 == (containingFile2 = element2.getContainingFile())) {
                    int i1 = element1.getTextOffset();
                    int i2 = element2.getTextOffset();
                    return Integer.compare(i2, i1);
                }
                return containingFile1.getName().compareTo(containingFile2.getName());
            }
            if (o1 instanceof RefElement) {
                return 1;
            }
            if (o2 instanceof RefElement) {
                return -1;
            }
            return o1.getName().compareTo(o2.getName());
        });
        RefEntity[] refEntityArray = selection.toArray(new RefEntity[selection.size()]);
        if (refEntityArray == null) {
            QuickFixAction.$$$reportNull$$$0(20);
        }
        return refEntityArray;
    }

    private static void refreshViews(@NotNull Project project, @NotNull Set<PsiElement> resolvedElements, @NotNull InspectionToolWrapper toolWrapper) {
        if (project == null) {
            QuickFixAction.$$$reportNull$$$0(21);
        }
        if (resolvedElements == null) {
            QuickFixAction.$$$reportNull$$$0(22);
        }
        if (toolWrapper == null) {
            QuickFixAction.$$$reportNull$$$0(23);
        }
        InspectionManagerEx managerEx = (InspectionManagerEx)InspectionManager.getInstance((Project)project);
        Set<GlobalInspectionContextImpl> runningContexts = managerEx.getRunningContexts();
        for (GlobalInspectionContextImpl context : runningContexts) {
            for (PsiElement element : resolvedElements) {
                context.resolveElement(toolWrapper.getTool(), element);
            }
            context.refreshViews();
        }
    }

    protected static void refreshViews(@NotNull Project project, @NotNull RefEntity[] resolvedElements, @NotNull InspectionToolWrapper toolWrapper) {
        if (project == null) {
            QuickFixAction.$$$reportNull$$$0(24);
        }
        if (resolvedElements == null) {
            QuickFixAction.$$$reportNull$$$0(25);
        }
        if (toolWrapper == null) {
            QuickFixAction.$$$reportNull$$$0(26);
        }
        HashSet<PsiElement> ignoredElements = new HashSet<PsiElement>();
        for (RefEntity element : resolvedElements) {
            PsiElement psiElement;
            PsiElement psiElement2 = psiElement = element instanceof RefElement ? ((RefElement)element).getElement() : null;
            if (psiElement == null || !psiElement.isValid()) continue;
            ignoredElements.add(psiElement);
        }
        QuickFixAction.refreshViews(project, ignoredElements, toolWrapper);
    }

    protected boolean applyFix(@NotNull RefEntity[] refElements) {
        Project project;
        ReadonlyStatusHandler.OperationStatus operationStatus;
        Set<VirtualFile> readOnlyFiles;
        if (refElements == null) {
            QuickFixAction.$$$reportNull$$$0(27);
        }
        return (readOnlyFiles = QuickFixAction.getReadOnlyFiles(refElements)).isEmpty() || !(operationStatus = ReadonlyStatusHandler.getInstance((Project)(project = refElements[0].getRefManager().getProject())).ensureFilesWritable(VfsUtilCore.toVirtualFileArray(readOnlyFiles))).hasReadonlyFiles();
    }

    public JComponent createCustomComponent(Presentation presentation) {
        final JButton button = new JButton(presentation.getText());
        Icon icon = presentation.getIcon();
        if (icon == null) {
            icon = AllIcons.Actions.CreateFromUsage;
        }
        button.setEnabled(presentation.isEnabled());
        button.setIcon(IconLoader.getTransparentIcon((Icon)icon, (float)0.75f));
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                ActionToolbar toolbar;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                QuickFixAction.this.actionPerformed(AnActionEvent.createFromAnAction((AnAction)QuickFixAction.this, (InputEvent)event, (String)"unknown", (DataContext)((toolbar = (ActionToolbar)UIUtil.getParentOfType(ActionToolbar.class, (Component)button)) == null ? DataManager.getInstance().getDataContext((Component)button) : toolbar.getToolbarDataContext())));
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInspection/ex/QuickFixAction$1", "onClick"));
            }
        }.installOn((Component)button);
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BoxLayout(panel2, 2));
        panel2.setBorder((Border)JBUI.Borders.empty((int)7, (int)0, (int)8, (int)0));
        panel2.add(button);
        return panel2;
    }

    private static /* synthetic */ void lambda$actionPerformed$1(Ref descriptors, InspectionTree tree, Set readOnlyFiles) {
        ReadAction.run(() -> {
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            indicator.setText("Checking problem descriptors...");
            descriptors.set((Object)tree.getSelectedDescriptors(true, readOnlyFiles, false, false));
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 16: 
            case 21: 
            case 24: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 9: 
            case 12: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoredElements";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "readOnlyFiles";
                break;
            }
            case 13: 
            case 15: 
            case 18: 
            case 27: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElements";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ex/QuickFixAction";
                break;
            }
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ex/QuickFixAction";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doApplyFix";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "performFixesInBatch";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "removeElements";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getReadOnlyFiles";
                break;
            }
            case 19: 
            case 20: {
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "refreshViews";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doApplyFix$4";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$3";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "lambda$performFixesInBatch$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class PerformFixesTask
    extends PerformFixesModalTask {
        @NotNull
        private final GlobalInspectionContextImpl myContext;
        @NotNull
        private final Set<PsiElement> myIgnoredElements;

        PerformFixesTask(@NotNull Project project, @NotNull CommonProblemDescriptor[] descriptors, @NotNull Set<PsiElement> ignoredElements, GlobalInspectionContextImpl context) {
            if (project == null) {
                PerformFixesTask.$$$reportNull$$$0(0);
            }
            if (descriptors == null) {
                PerformFixesTask.$$$reportNull$$$0(1);
            }
            if (ignoredElements == null) {
                PerformFixesTask.$$$reportNull$$$0(2);
            }
            if (context == null) {
                PerformFixesTask.$$$reportNull$$$0(3);
            }
            super(project, descriptors);
            this.myContext = context;
            this.myIgnoredElements = ignoredElements;
        }

        @Override
        protected void applyFix(Project project, CommonProblemDescriptor descriptor2) {
            if (descriptor2 instanceof ProblemDescriptor && ((ProblemDescriptor)descriptor2).getStartElement() == null && ((ProblemDescriptor)descriptor2).getEndElement() == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Invalidated psi for " + descriptor2);
                }
                return;
            }
            try {
                QuickFixAction.this.applyFix(this.myProject, this.myContext, new CommonProblemDescriptor[]{descriptor2}, this.myIgnoredElements);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "descriptors";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "ignoredElements";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/ex/QuickFixAction$PerformFixesTask";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

