/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.compound;

import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.compound.CompoundRunConfiguration;
import com.intellij.execution.compound.ConfigurationSelectionUtil;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunConfigurationBeforeRunProvider;
import com.intellij.execution.impl.RunConfigurationSelector;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.ide.DataManager;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SortedListModel;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class CompoundRunConfigurationSettingsEditor
extends SettingsEditor<CompoundRunConfiguration> {
    private final Project myProject;
    private final JBList myList;
    private final RunManagerImpl myRunManager;
    private final SortedListModel<Pair<RunConfiguration, ExecutionTarget>> myModel;
    private CompoundRunConfiguration mySnapshot;

    public CompoundRunConfigurationSettingsEditor(@NotNull Project project) {
        if (project == null) {
            CompoundRunConfigurationSettingsEditor.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myRunManager = RunManagerImpl.getInstanceImpl(project);
        this.myModel = new SortedListModel((o1, o2) -> CompoundRunConfiguration.COMPARATOR.compare((RunConfiguration)o1.first, (RunConfiguration)o2.first));
        this.myList = new JBList(this.myModel);
        this.myList.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer(){

            protected void customizeCellRenderer(@NotNull JList list2, Object value, int index, boolean selected, boolean hasFocus) {
                if (list2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                RunConfiguration configuration = (RunConfiguration)((Pair)((CompoundRunConfigurationSettingsEditor)CompoundRunConfigurationSettingsEditor.this).myModel.get((int)index)).first;
                ExecutionTarget target2 = (ExecutionTarget)((Pair)((CompoundRunConfigurationSettingsEditor)CompoundRunConfigurationSettingsEditor.this).myModel.get((int)index)).second;
                this.setIcon(configuration.getType().getIcon());
                this.append(ConfigurationSelectionUtil.getDisplayText(configuration, target2));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/execution/compound/CompoundRunConfigurationSettingsEditor$1", "customizeCellRenderer"));
            }
        });
        this.myList.setVisibleRowCount(15);
    }

    private boolean canBeAdded(@NotNull RunConfiguration candidate, @NotNull CompoundRunConfiguration root) {
        if (candidate == null) {
            CompoundRunConfigurationSettingsEditor.$$$reportNull$$$0(1);
        }
        if (root == null) {
            CompoundRunConfigurationSettingsEditor.$$$reportNull$$$0(2);
        }
        if (candidate.getType() == root.getType() && candidate.getName().equals(root.getName())) {
            return false;
        }
        List<BeforeRunTask<?>> tasks = this.myRunManager.getBeforeRunTasks(candidate);
        for (BeforeRunTask<?> task2 : tasks) {
            RunConfigurationBeforeRunProvider.RunConfigurableBeforeRunTask runTask;
            RunnerAndConfigurationSettings settings;
            if (!(task2 instanceof RunConfigurationBeforeRunProvider.RunConfigurableBeforeRunTask) || (settings = (runTask = (RunConfigurationBeforeRunProvider.RunConfigurableBeforeRunTask)task2).getSettings()) == null || this.canBeAdded(settings.getConfiguration(), root)) continue;
            return false;
        }
        if (candidate instanceof CompoundRunConfiguration) {
            for (RunConfiguration configuration : ((CompoundRunConfiguration)candidate).getConfigurationsWithTargets().keySet()) {
                if (this.canBeAdded(configuration, root)) continue;
                return false;
            }
        }
        return true;
    }

    protected void resetEditorFrom(@NotNull CompoundRunConfiguration compoundRunConfiguration) {
        if (compoundRunConfiguration == null) {
            CompoundRunConfigurationSettingsEditor.$$$reportNull$$$0(3);
        }
        this.myModel.clear();
        this.myModel.addAll((Collection)ContainerUtil.map2List(compoundRunConfiguration.getConfigurationsWithTargets()));
        this.mySnapshot = compoundRunConfiguration;
    }

    protected void applyEditorTo(@NotNull CompoundRunConfiguration compoundConfiguration) throws ConfigurationException {
        if (compoundConfiguration == null) {
            CompoundRunConfigurationSettingsEditor.$$$reportNull$$$0(4);
        }
        THashMap checked = new THashMap();
        for (int i = 0; i < this.myModel.getSize(); ++i) {
            Pair configurationAndTarget = (Pair)this.myModel.get(i);
            RunConfiguration configuration = (RunConfiguration)configurationAndTarget.first;
            String message = LangBundle.message("compound.run.configuration.cycle", configuration.getType().getDisplayName(), configuration.getName());
            if (!this.canBeAdded(configuration, compoundConfiguration)) {
                throw new ConfigurationException(message);
            }
            checked.put(configuration, configurationAndTarget.second);
        }
        compoundConfiguration.setConfigurationsWithTargets((Map<RunConfiguration, ? extends ExecutionTarget>)checked);
    }

    @NotNull
    protected JComponent createEditor() {
        final ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JList)this.myList);
        JPanel jPanel = decorator.disableUpDownActions().setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                ArrayList<RunConfiguration> all = new ArrayList<RunConfiguration>();
                for (ConfigurationType type : CompoundRunConfigurationSettingsEditor.this.myRunManager.getConfigurationFactoriesWithoutUnknown()) {
                    for (RunnerAndConfigurationSettings settings : CompoundRunConfigurationSettingsEditor.this.myRunManager.getConfigurationSettingsList(type)) {
                        all.add(settings.getConfiguration());
                    }
                }
                List configurations = ContainerUtil.filter(all, configuration -> !CompoundRunConfigurationSettingsEditor.this.mySnapshot.getConfigurationsWithTargets().keySet().contains(configuration) && CompoundRunConfigurationSettingsEditor.this.canBeAdded(configuration, CompoundRunConfigurationSettingsEditor.this.mySnapshot));
                ConfigurationSelectionUtil.createPopup(CompoundRunConfigurationSettingsEditor.this.myProject, CompoundRunConfigurationSettingsEditor.this.myRunManager, configurations, (selectedConfigs, selectedTarget) -> {
                    for (RunConfiguration each : selectedConfigs) {
                        CompoundRunConfigurationSettingsEditor.this.myModel.add((Object)Pair.create((Object)each, (Object)selectedTarget));
                    }
                }).showUnderneathOf((Component)decorator.getActionsPanel());
            }
        }).setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                int index = CompoundRunConfigurationSettingsEditor.this.myList.getSelectedIndex();
                if (index == -1) {
                    return;
                }
                RunConfiguration configuration = (RunConfiguration)((Pair)((CompoundRunConfigurationSettingsEditor)CompoundRunConfigurationSettingsEditor.this).myModel.get((int)index)).first;
                RunConfigurationSelector selector = (RunConfigurationSelector)RunConfigurationSelector.KEY.getData(DataManager.getInstance().getDataContext((Component)button.getContextComponent()));
                if (selector != null) {
                    selector.select(configuration);
                }
            }
        }).setToolbarPosition(ActionToolbarPosition.TOP).createPanel();
        if (jPanel == null) {
            CompoundRunConfigurationSettingsEditor.$$$reportNull$$$0(5);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compoundRunConfiguration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compoundConfiguration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/compound/CompoundRunConfigurationSettingsEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/compound/CompoundRunConfigurationSettingsEditor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canBeAdded";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

