/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui.layout.impl;

import com.intellij.execution.ui.layout.LayoutAttractionPolicy;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.execution.ui.layout.Tab;
import com.intellij.execution.ui.layout.impl.TabImpl;
import com.intellij.execution.ui.layout.impl.ViewImpl;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.content.Content;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunnerLayout {
    public static final Key<Integer> DEFAULT_INDEX = Key.create((String)"RunnerLayoutDefaultIndex");
    public static final Key<Integer> DROP_INDEX = Key.create((String)"RunnerLayoutDropIndex");
    private final String myID;
    protected Map<String, ViewImpl> myViews;
    private final Map<String, ViewImpl.Default> myDefaultViews;
    protected Set<TabImpl> myTabs;
    private final Map<Integer, TabImpl.Default> myDefaultTabs;
    protected General myGeneral;
    private final Map<String, Pair<String, LayoutAttractionPolicy>> myDefaultFocus;
    private Set<String> myLightWeightIds;

    public RunnerLayout(@NotNull String ID2) {
        if (ID2 == null) {
            RunnerLayout.$$$reportNull$$$0(0);
        }
        this.myViews = new LinkedHashMap();
        this.myDefaultViews = new HashMap<String, ViewImpl.Default>();
        this.myTabs = new TreeSet<TabImpl>(Comparator.comparingInt(TabImpl::getIndex));
        this.myDefaultTabs = new HashMap<Integer, TabImpl.Default>();
        this.myGeneral = new General();
        this.myDefaultFocus = new HashMap<String, Pair<String, LayoutAttractionPolicy>>();
        this.myLightWeightIds = null;
        this.myID = ID2;
    }

    @Nullable
    public String getDefaultDisplayName(int defaultIndex) {
        TabImpl.Default tab = this.myDefaultTabs.get(defaultIndex);
        return tab != null ? tab.myDisplayName : null;
    }

    @NotNull
    public TabImpl getOrCreateTab(int index) {
        if (index < 0) {
            TabImpl tabImpl = this.createNewTab();
            if (tabImpl == null) {
                RunnerLayout.$$$reportNull$$$0(1);
            }
            return tabImpl;
        }
        TabImpl tab = this.findTab(index);
        if (tab != null) {
            TabImpl tabImpl = tab;
            if (tabImpl == null) {
                RunnerLayout.$$$reportNull$$$0(2);
            }
            return tabImpl;
        }
        TabImpl tabImpl = tab = this.createNewTab(index);
        if (tabImpl == null) {
            RunnerLayout.$$$reportNull$$$0(3);
        }
        return tabImpl;
    }

    @NotNull
    private TabImpl createNewTab(int index) {
        TabImpl.Default defaultTab = this.getOrCreateDefaultTab(index);
        TabImpl tab = defaultTab.createTab();
        this.myTabs.add(tab);
        TabImpl tabImpl = tab;
        if (tabImpl == null) {
            RunnerLayout.$$$reportNull$$$0(4);
        }
        return tabImpl;
    }

    @NotNull
    private TabImpl.Default getOrCreateDefaultTab(int index) {
        TabImpl.Default tab = this.myDefaultTabs.get(index);
        if (tab == null) {
            tab = new TabImpl.Default(index, null, null);
            this.myDefaultTabs.put(index, tab);
        }
        TabImpl.Default default_ = tab;
        if (default_ == null) {
            RunnerLayout.$$$reportNull$$$0(5);
        }
        return default_;
    }

    @NotNull
    public TabImpl createNewTab() {
        int index = this.myTabs.stream().mapToInt(x -> x.getIndex()).max().orElse(-1) + 1;
        TabImpl tabImpl = this.createNewTab(index);
        if (tabImpl == null) {
            RunnerLayout.$$$reportNull$$$0(6);
        }
        return tabImpl;
    }

    private boolean isUsed(@NotNull TabImpl tab) {
        if (tab == null) {
            RunnerLayout.$$$reportNull$$$0(7);
        }
        for (ViewImpl each : this.myViews.values()) {
            if (each.getTab() != tab) continue;
            return true;
        }
        return false;
    }

    @Nullable
    protected TabImpl findTab(int index) {
        for (TabImpl each : this.myTabs) {
            if (index != each.getIndex()) continue;
            return each;
        }
        return null;
    }

    @NotNull
    public Element getState() {
        Element element = this.write(new Element("layout"));
        if (element == null) {
            RunnerLayout.$$$reportNull$$$0(8);
        }
        return element;
    }

    public void loadState(@NotNull Element state2) {
        if (state2 == null) {
            RunnerLayout.$$$reportNull$$$0(9);
        }
        this.read(state2);
    }

    @NotNull
    public Element read(@NotNull Element parentNode) {
        if (parentNode == null) {
            RunnerLayout.$$$reportNull$$$0(10);
        }
        List tabs = parentNode.getChildren(StringUtil.getShortName((String)TabImpl.class.getName()));
        for (Element eachTabElement : tabs) {
            TabImpl eachTab = (TabImpl)XmlSerializer.deserialize((Element)eachTabElement, TabImpl.class);
            XmlSerializer.deserializeInto((Object)this.getOrCreateTab(eachTab.getIndex()), (Element)eachTabElement);
        }
        List views = parentNode.getChildren(StringUtil.getShortName((String)ViewImpl.class.getName()));
        for (Object content : views) {
            ViewImpl state2 = new ViewImpl(this, (Element)content);
            this.myViews.put(state2.getID(), state2);
        }
        XmlSerializer.deserializeInto((Object)this.myGeneral, (Element)parentNode.getChild(StringUtil.getShortName((String)this.myGeneral.getClass().getName(), (char)'$')));
        Element element = parentNode;
        if (element == null) {
            RunnerLayout.$$$reportNull$$$0(11);
        }
        return element;
    }

    @NotNull
    public Element write(@NotNull Element parentNode) {
        if (parentNode == null) {
            RunnerLayout.$$$reportNull$$$0(12);
        }
        for (ViewImpl eachState : this.myViews.values()) {
            if (this.myLightWeightIds != null && this.myLightWeightIds.contains(eachState.getID())) continue;
            parentNode.addContent(XmlSerializer.serialize((Object)eachState));
        }
        SkipDefaultValuesSerializationFilters filter2 = new SkipDefaultValuesSerializationFilters();
        for (TabImpl eachTab : this.myTabs) {
            if (!this.isUsed(eachTab)) continue;
            parentNode.addContent(XmlSerializer.serialize((Object)eachTab, (SerializationFilter)filter2));
        }
        parentNode.addContent(XmlSerializer.serialize((Object)this.myGeneral, (SerializationFilter)filter2));
        Element element = parentNode;
        if (element == null) {
            RunnerLayout.$$$reportNull$$$0(13);
        }
        return element;
    }

    public void resetToDefault() {
        this.myViews.clear();
        this.myTabs.clear();
    }

    public boolean isToolbarHorizontal() {
        return false;
    }

    public void setToolbarHorizontal(boolean horizontal) {
        this.myGeneral.horizontalToolbar = horizontal;
    }

    @NotNull
    public ViewImpl getStateFor(@NotNull Content content) {
        if (content == null) {
            RunnerLayout.$$$reportNull$$$0(14);
        }
        ViewImpl viewImpl = this.getOrCreateView(RunnerLayout.getOrCreateContentId(content));
        if (viewImpl == null) {
            RunnerLayout.$$$reportNull$$$0(15);
        }
        return viewImpl;
    }

    public void clearStateFor(@NotNull Content content) {
        Tab tab;
        if (content == null) {
            RunnerLayout.$$$reportNull$$$0(16);
        }
        String id = RunnerLayout.getOrCreateContentId(content);
        this.myDefaultViews.remove(id);
        ViewImpl view = this.myViews.remove(id);
        if (view != null && (tab = view.getTab()) instanceof TabImpl) {
            this.myTabs.remove(tab);
        }
    }

    @NotNull
    private static String getOrCreateContentId(@NotNull Content content) {
        String id;
        if (content == null) {
            RunnerLayout.$$$reportNull$$$0(17);
        }
        if ((id = (String)content.getUserData(ViewImpl.ID)) == null) {
            id = "UnknownView-" + content.getDisplayName();
            content.putUserData(ViewImpl.ID, (Object)id);
        }
        String string = id;
        if (string == null) {
            RunnerLayout.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    private ViewImpl getOrCreateView(@NotNull String id) {
        ViewImpl view;
        if (id == null) {
            RunnerLayout.$$$reportNull$$$0(19);
        }
        if ((view = this.myViews.get(id)) == null) {
            view = this.getOrCreateDefault(id).createView(this);
            this.myViews.put(id, view);
        }
        ViewImpl viewImpl = view;
        if (viewImpl == null) {
            RunnerLayout.$$$reportNull$$$0(20);
        }
        return viewImpl;
    }

    @NotNull
    private ViewImpl.Default getOrCreateDefault(@NotNull String id) {
        if (id == null) {
            RunnerLayout.$$$reportNull$$$0(21);
        }
        if (this.myDefaultViews.containsKey(id)) {
            ViewImpl.Default default_ = this.myDefaultViews.get(id);
            if (default_ == null) {
                RunnerLayout.$$$reportNull$$$0(22);
            }
            return default_;
        }
        ViewImpl.Default default_ = this.setDefault(id, Integer.MAX_VALUE, PlaceInGrid.bottom, false);
        if (default_ == null) {
            RunnerLayout.$$$reportNull$$$0(23);
        }
        return default_;
    }

    @NotNull
    public TabImpl.Default setDefault(int tabID, String displayName, Icon icon) {
        TabImpl.Default tab = new TabImpl.Default(tabID, displayName, icon);
        this.myDefaultTabs.put(tabID, tab);
        TabImpl.Default default_ = tab;
        if (default_ == null) {
            RunnerLayout.$$$reportNull$$$0(24);
        }
        return default_;
    }

    @NotNull
    public ViewImpl.Default setDefault(@NotNull String id, int tabIndex, @NotNull PlaceInGrid placeInGrid, boolean isMinimized) {
        if (id == null) {
            RunnerLayout.$$$reportNull$$$0(25);
        }
        if (placeInGrid == null) {
            RunnerLayout.$$$reportNull$$$0(26);
        }
        ViewImpl.Default view = new ViewImpl.Default(id, tabIndex, placeInGrid, isMinimized);
        this.myDefaultViews.put(id, view);
        ViewImpl.Default default_ = view;
        if (default_ == null) {
            RunnerLayout.$$$reportNull$$$0(27);
        }
        return default_;
    }

    @NotNull
    public PlaceInGrid getDefaultGridPlace(@NotNull Content content) {
        if (content == null) {
            RunnerLayout.$$$reportNull$$$0(28);
        }
        PlaceInGrid placeInGrid = this.getOrCreateDefault(RunnerLayout.getOrCreateContentId(content)).getPlaceInGrid();
        if (placeInGrid == null) {
            RunnerLayout.$$$reportNull$$$0(29);
        }
        return placeInGrid;
    }

    public boolean isToFocus(String id, @NotNull String condition) {
        if (condition == null) {
            RunnerLayout.$$$reportNull$$$0(30);
        }
        return Comparing.equal((String)id, (String)this.getToFocus(condition));
    }

    public void setToFocus(String id, @NotNull String condition) {
        if (condition == null) {
            RunnerLayout.$$$reportNull$$$0(31);
        }
        this.myGeneral.focusOnCondition.put(condition, id);
    }

    public void setDefaultToFocus(@NotNull String id, @NotNull String condition, @NotNull LayoutAttractionPolicy policy) {
        if (id == null) {
            RunnerLayout.$$$reportNull$$$0(32);
        }
        if (condition == null) {
            RunnerLayout.$$$reportNull$$$0(33);
        }
        if (policy == null) {
            RunnerLayout.$$$reportNull$$$0(34);
        }
        this.myDefaultFocus.put(condition, (Pair<String, LayoutAttractionPolicy>)Pair.create((Object)id, (Object)policy));
    }

    @Nullable
    public String getToFocus(@NotNull String condition) {
        if (condition == null) {
            RunnerLayout.$$$reportNull$$$0(35);
        }
        return this.myGeneral.focusOnCondition.containsKey(condition) ? this.myGeneral.focusOnCondition.get(condition) : (this.myDefaultFocus.containsKey(condition) ? (String)this.myDefaultFocus.get(condition).getFirst() : null);
    }

    @NotNull
    public LayoutAttractionPolicy getAttractionPolicy(@NotNull String condition) {
        Pair<String, LayoutAttractionPolicy> pair;
        if (condition == null) {
            RunnerLayout.$$$reportNull$$$0(36);
        }
        Object object = (pair = this.myDefaultFocus.get(condition)) == null ? new LayoutAttractionPolicy.FocusOnce() : (LayoutAttractionPolicy)pair.getSecond();
        if (object == null) {
            RunnerLayout.$$$reportNull$$$0(37);
        }
        return object;
    }

    public void setLightWeight(Content content) {
        if (this.myLightWeightIds == null) {
            this.myLightWeightIds = new HashSet<String>();
        }
        this.myLightWeightIds.add(RunnerLayout.getOrCreateContentId(content));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 29: 
            case 37: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 29: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ID";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 29: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/ui/layout/impl/RunnerLayout";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tab";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 14: 
            case 16: 
            case 17: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 19: 
            case 21: 
            case 25: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeInGrid";
                break;
            }
            case 30: 
            case 31: 
            case 33: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/ui/layout/impl/RunnerLayout";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateTab";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewTab";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateDefaultTab";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "read";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "write";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getStateFor";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateContentId";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateView";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateDefault";
                break;
            }
            case 24: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "setDefault";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultGridPlace";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttractionPolicy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 29: 
            case 37: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isUsed";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "write";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getStateFor";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "clearStateFor";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateContentId";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateView";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateDefault";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setDefault";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultGridPlace";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isToFocus";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "setToFocus";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultToFocus";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getToFocus";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getAttractionPolicy";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 29: 
            case 37: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class General {
        public volatile boolean horizontalToolbar = false;
        public volatile Map<String, String> focusOnCondition = new HashMap<String, String>();
    }
}

