/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.FileColorManager;
import com.intellij.ui.popup.HintUpdateSupply;
import com.intellij.ui.tabs.FileColorManagerImpl;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectViewTree
extends DnDAwareTree {
    private final Project myProject;

    protected ProjectViewTree(Project project, TreeModel model) {
        super(model);
        this.myProject = project;
        NodeRenderer cellRenderer = new NodeRenderer(){

            protected void doPaint(Graphics2D g) {
                super.doPaint(g);
                this.setOpaque(false);
            }
        };
        cellRenderer.setOpaque(false);
        cellRenderer.setIconOpaque(false);
        this.setCellRenderer((TreeCellRenderer)cellRenderer);
        cellRenderer.setTransparentIconBackground(true);
        HintUpdateSupply.installDataContextHintUpdateSupply((JComponent)((Object)this));
    }

    @Deprecated
    public DefaultMutableTreeNode getSelectedNode() {
        TreePath path = TreeUtil.getSelectedPathIfOne((JTree)((Object)this));
        return path == null ? null : (DefaultMutableTreeNode)ObjectUtils.tryCast((Object)path.getLastPathComponent(), DefaultMutableTreeNode.class);
    }

    public Project getProject() {
        return this.myProject;
    }

    public final int getToggleClickCount() {
        NodeDescriptor descriptor2;
        Object object;
        TreePath path = this.getSelectionPath();
        Object object2 = object = path == null ? null : TreeUtil.getUserObject((Object)path.getLastPathComponent());
        if (object instanceof NodeDescriptor && !(descriptor2 = (NodeDescriptor)object).expandOnDoubleClick()) {
            return -1;
        }
        return super.getToggleClickCount();
    }

    public boolean isFileColorsEnabled() {
        return ProjectViewTree.isFileColorsEnabledFor((JTree)((Object)this));
    }

    public static boolean isFileColorsEnabledFor(JTree tree) {
        boolean enabled = FileColorManagerImpl._isEnabled() && FileColorManagerImpl._isEnabledForProjectView();
        boolean opaque = tree.isOpaque();
        if (enabled && opaque) {
            tree.setOpaque(false);
        } else if (!enabled && !opaque) {
            tree.setOpaque(true);
        }
        return enabled;
    }

    @Nullable
    public Color getFileColorFor(Object object) {
        return ProjectViewTree.getColorForObject(object, this.getProject(), object1 -> {
            Object element;
            if (object1 instanceof AbstractTreeNode && (element = ((AbstractTreeNode)object1).getValue()) instanceof PsiElement) {
                return (PsiElement)element;
            }
            return null;
        });
    }

    @Nullable
    public static <T> Color getColorForObject(T object, Project project, @NotNull Function<T, PsiElement> converter2) {
        if (converter2 == null) {
            ProjectViewTree.$$$reportNull$$$0(0);
        }
        Color color = null;
        PsiElement psi = (PsiElement)converter2.fun(object);
        if (psi != null) {
            if (!psi.isValid()) {
                return null;
            }
            VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)psi);
            if (file2 != null) {
                color = FileColorManager.getInstance((Project)project).getFileColor(file2);
            } else if (psi instanceof PsiDirectory) {
                color = FileColorManager.getInstance((Project)project).getFileColor(((PsiDirectory)psi).getVirtualFile());
            } else if (psi instanceof PsiDirectoryContainer) {
                PsiDirectory[] dirs;
                for (PsiDirectory dir : dirs = ((PsiDirectoryContainer)psi).getDirectories()) {
                    Color c = FileColorManager.getInstance((Project)project).getFileColor(dir.getVirtualFile());
                    if (c != null && color == null) {
                        color = c;
                        continue;
                    }
                    if (c == null) continue;
                    color = null;
                    break;
                }
            }
        }
        return color == null ? null : ColorUtil.softer(color);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "converter", "com/intellij/ide/projectView/impl/ProjectViewTree", "getColorForObject"));
    }
}

