/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.ui.ErrorBorderCapable;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComboBox;
import javax.swing.border.Border;
import javax.swing.plaf.InsetsUIResource;

public class DarculaEditorTextFieldBorder
implements Border,
ErrorBorderCapable {
    public DarculaEditorTextFieldBorder() {
        this(null, null);
    }

    public DarculaEditorTextFieldBorder(final EditorTextField editorTextField, EditorEx editor) {
        if (editorTextField != null && editor != null) {
            editor.addFocusListener(new FocusChangeListener(){

                @Override
                public void focusGained(Editor editor) {
                    editorTextField.repaint();
                }

                @Override
                public void focusLost(Editor editor) {
                    editorTextField.repaint();
                }
            });
        }
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (DarculaEditorTextFieldBorder.isComboBoxEditor(c)) {
            g.setColor(c.getBackground());
            g.fillRect(x, y, width, height);
            return;
        }
        EditorTextField editorTextField = (EditorTextField)UIUtil.getParentOfType(EditorTextField.class, (Component)c);
        if (editorTextField == null) {
            return;
        }
        Rectangle r = new Rectangle(x + 1, y + 1, width - 2, height - 2);
        if (c.isOpaque()) {
            g.setColor(UIUtil.getPanelBackground());
            g.fillRect(x, y, width, height);
        }
        g.setColor(c.getBackground());
        g.fillRect(r.x, r.y, r.width, r.height);
        if (!editorTextField.isEnabled()) {
            ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, 0.4f));
        }
        boolean hasFocus = editorTextField.getFocusTarget().hasFocus();
        Object op = editorTextField.getClientProperty("JComponent.outline");
        if (op != null) {
            g.translate(x, y);
            DarculaUIUtil.paintOutlineBorder((Graphics2D)g, width, height, 0.0f, true, hasFocus, DarculaUIUtil.Outline.valueOf(op.toString()));
        } else if (editorTextField.isEnabled() && editorTextField.isVisible() && hasFocus) {
            DarculaUIUtil.paintFocusRing(g, new Rectangle(r.x + 1, r.y + 1, r.width - 2, r.height - 2));
        } else {
            g.setColor((Color)new JBColor((Color)Gray._150, (Color)Gray._100));
            g.drawRect(r.x, r.y, r.width, r.height);
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        if (DarculaEditorTextFieldBorder.isComboBoxEditor(c)) {
            return new InsetsUIResource(2, 3, 2, 3);
        }
        return new InsetsUIResource(4, 7, 4, 7);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    public static boolean isComboBoxEditor(Component c) {
        return UIUtil.getParentOfType(JComboBox.class, (Component)c) != null;
    }
}

