/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ide.ui.laf.darcula.ui.TextFieldWithPopupHandlerUI;
import com.intellij.openapi.ui.ErrorBorderCapable;
import com.intellij.ui.ColorPanel;
import com.intellij.ui.Gray;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;

public class MacIntelliJTextBorder
implements Border,
UIResource,
ErrorBorderCapable {
    @Override
    public Insets getBorderInsets(Component c) {
        if (c instanceof JTextField && c.getParent() instanceof ColorPanel) {
            return JBUI.insets((int)3, (int)3, (int)2, (int)2).asUIResource();
        }
        JBInsets.JBInsetsUIResource insets = JBUI.insets((int)4, (int)8).asUIResource();
        TextFieldWithPopupHandlerUI.updateBorderInsets(c, (Insets)insets);
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (TextFieldWithPopupHandlerUI.isSearchField(c)) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            g2.translate(x, y);
            Path2D.Double border = new Path2D.Double(0);
            double lw = JBUI.scale((float)(UIUtil.isRetina((Graphics2D)g2) ? 0.5f : 1.0f));
            border.append(new Rectangle2D.Double(JBUI.scale((int)3), JBUI.scale((int)3), c.getWidth() - JBUI.scale((int)3) * 2, c.getHeight() - JBUI.scale((int)3) * 2), false);
            border.append(new Rectangle2D.Double((double)JBUI.scale((int)3) + lw, (double)JBUI.scale((int)3) + lw, (double)c.getWidth() - ((double)JBUI.scale((int)3) + lw) * 2.0, (double)c.getHeight() - ((double)JBUI.scale((int)3) + lw) * 2.0), false);
            g2.setColor((Color)Gray.xBC);
            g2.fill(border);
            if (c.getParent() instanceof JComboBox) {
                return;
            }
            this.paint(c, g2, width, height, 0.0f);
        }
        finally {
            g2.dispose();
        }
    }

    public void paint(Component c, Graphics2D g2, int width, int height, float arc) {
        this.clipForBorder(c, g2, width, height);
        Object op = ((JComponent)c).getClientProperty("JComponent.outline");
        if (op != null) {
            DarculaUIUtil.paintOutlineBorder(g2, width, height, arc, this.isSymmetric(), this.isFocused(c), DarculaUIUtil.Outline.valueOf(op.toString()));
        } else if (this.isFocused(c)) {
            DarculaUIUtil.paintFocusBorder(g2, width, height, arc, this.isSymmetric());
        }
    }

    boolean isFocused(Component c) {
        return c instanceof JScrollPane ? ((JScrollPane)c).getViewport().getView().hasFocus() : c.hasFocus();
    }

    void clipForBorder(Component c, Graphics2D g2, int width, int height) {
        Area area = new Area(new Rectangle2D.Double(0.0, 0.0, width, height));
        double lw = JBUI.scale((float)(UIUtil.isRetina((Graphics2D)g2) ? 0.5f : 1.0f));
        area.subtract(new Area(new Rectangle2D.Double((double)JBUI.scale((int)3) + lw, (double)JBUI.scale((int)3) + lw, (double)width - ((double)JBUI.scale((int)3) + lw) * 2.0, (double)height - ((double)JBUI.scale((int)3) + lw) * 2.0)));
        area.intersect(new Area(g2.getClip()));
        g2.setClip(area);
    }

    boolean isSymmetric() {
        return true;
    }
}

