/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.PatchEP;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.CommitContext;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class BaseRevisionTextPatchEP
implements PatchEP {
    public static final Key<Boolean> ourPutBaseRevisionTextKey = Key.create((String)"com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP.ourPutBaseRevisionTextKey");
    public static final Key<List<FilePath>> ourBaseRevisionPaths = Key.create((String)"com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP.ourBaseRevisionPaths");
    public static final Key<Map<String, String>> ourStoredTexts = Key.create((String)"com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP.ourStoredTexts");
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP");
    private final Project myProject;
    private final ChangeListManager myChangeListManager;
    private final String myBaseDir;

    public BaseRevisionTextPatchEP(Project project) {
        this.myProject = project;
        this.myBaseDir = this.myProject.getBaseDir().getPath();
        this.myChangeListManager = ChangeListManager.getInstance((Project)this.myProject);
    }

    @NotNull
    public String getName() {
        if ("com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP" == null) {
            BaseRevisionTextPatchEP.$$$reportNull$$$0(0);
        }
        return "com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP";
    }

    public CharSequence provideContent(@NotNull String path, CommitContext commitContext) {
        if (path == null) {
            BaseRevisionTextPatchEP.$$$reportNull$$$0(1);
        }
        if (commitContext == null) {
            return null;
        }
        if (Boolean.TRUE.equals(commitContext.getUserData(ourPutBaseRevisionTextKey))) {
            File file2 = new File(this.myBaseDir, path);
            FilePath filePathOn = VcsContextFactory.SERVICE.getInstance().createFilePathOn(file2);
            Change change = this.myChangeListManager.getChange(filePathOn);
            List paths = (List)commitContext.getUserData(ourBaseRevisionPaths);
            if (change == null || change.getBeforeRevision() == null || paths == null || !paths.contains(filePathOn)) {
                return null;
            }
            try {
                String content = change.getBeforeRevision().getContent();
                return content;
            }
            catch (VcsException e) {
                LOG.info((Throwable)e);
            }
        } else {
            Map map2 = (Map)commitContext.getUserData(ourStoredTexts);
            if (map2 != null) {
                File file3 = new File(this.myBaseDir, path);
                return (CharSequence)map2.get(file3.getPath());
            }
        }
        return null;
    }

    public void consumeContent(@NotNull String path, @NotNull CharSequence content, CommitContext commitContext) {
        if (path == null) {
            BaseRevisionTextPatchEP.$$$reportNull$$$0(2);
        }
        if (content == null) {
            BaseRevisionTextPatchEP.$$$reportNull$$$0(3);
        }
    }

    public void consumeContentBeforePatchApplied(@NotNull String path, @NotNull CharSequence content, CommitContext commitContext) {
        if (path == null) {
            BaseRevisionTextPatchEP.$$$reportNull$$$0(4);
        }
        if (content == null) {
            BaseRevisionTextPatchEP.$$$reportNull$$$0(5);
        }
        if (commitContext == null) {
            return;
        }
        HashMap<String, String> map2 = (HashMap<String, String>)commitContext.getUserData(ourStoredTexts);
        if (map2 == null) {
            map2 = new HashMap<String, String>();
            commitContext.putUserData(ourStoredTexts, map2);
        }
        File file2 = new File(this.myBaseDir, path);
        map2.put(file2.getPath(), content.toString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/patch/BaseRevisionTextPatchEP";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/patch/BaseRevisionTextPatchEP";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "provideContent";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "consumeContent";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "consumeContentBeforePatchApplied";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

