/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.diagnostic.VMOptions;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DataManager;
import com.intellij.ide.TreeExpander;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AbbreviationManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.actionSystem.ex.QuickListsManager;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.KeyboardSettingsExternalizable;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.impl.ActionShortcutRestrictions;
import com.intellij.openapi.keymap.impl.KeymapImpl;
import com.intellij.openapi.keymap.impl.ShortcutRestrictions;
import com.intellij.openapi.keymap.impl.ui.ActionsTree;
import com.intellij.openapi.keymap.impl.ui.KeyboardShortcutDialog;
import com.intellij.openapi.keymap.impl.ui.KeymapListener;
import com.intellij.openapi.keymap.impl.ui.KeymapSchemeManager;
import com.intellij.openapi.keymap.impl.ui.KeymapSelector;
import com.intellij.openapi.keymap.impl.ui.MouseShortcutDialog;
import com.intellij.openapi.keymap.impl.ui.ShortcutFilteringPanel;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.packageDependencies.ui.TreeExpansionMonitor;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.FilterComponent;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Alarm;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeymapPanel
extends JPanel
implements SearchableConfigurable,
Configurable.NoScroll,
KeymapListener,
Disposable {
    private JCheckBox preferKeyPositionOverCharOption;
    private final KeymapSchemeManager myManager = new KeymapSelector(this::currentKeymapChanged).getManager();
    private final ActionsTree myActionsTree = new ActionsTree();
    private FilterComponent myFilterComponent;
    private TreeExpansionMonitor myTreeExpansionMonitor;
    private final ShortcutFilteringPanel myFilteringPanel = new ShortcutFilteringPanel();
    private boolean myQuickListsModified = false;
    private QuickList[] myQuickLists = QuickListsManager.getInstance().getAllQuickLists();

    public KeymapPanel() {
        this.setLayout(new BorderLayout());
        JPanel keymapPanel = new JPanel(new BorderLayout());
        keymapPanel.add(this.myManager.getSchemesPanel(), "North");
        keymapPanel.add((Component)this.createKeymapSettingsPanel(), "Center");
        IdeFrame ideFrame = IdeFocusManager.getGlobalInstance().getLastFocusedFrame();
        if (ideFrame != null && KeyboardSettingsExternalizable.isSupportedKeyboardLayout((Component)ideFrame.getComponent())) {
            this.preferKeyPositionOverCharOption = new JCheckBox(new AbstractAction(" " + KeyMapBundle.message((String)"prefer.key.position", (Object[])new Object[0])){

                @Override
                public void actionPerformed(ActionEvent e) {
                    KeyboardSettingsExternalizable.getInstance().setPreferKeyPositionOverCharOption(KeymapPanel.this.preferKeyPositionOverCharOption.isSelected());
                    VMOptions.writeOption("com.jetbrains.use.old.keyevent.processing", "=", Boolean.toString(KeyboardSettingsExternalizable.getInstance().isPreferKeyPositionOverCharOption()));
                    ApplicationManager.getApplication().invokeLater(() -> ApplicationManager.getApplication().restart(), ModalityState.NON_MODAL);
                }
            });
            this.preferKeyPositionOverCharOption.setBorder((Border)JBUI.Borders.empty());
            keymapPanel.add((Component)this.preferKeyPositionOverCharOption, "South");
        }
        this.add((Component)keymapPanel, "Center");
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(@NotNull PropertyChangeEvent evt) {
                if (evt == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (evt.getPropertyName().equals("ancestor") && evt.getNewValue() != null && evt.getOldValue() == null && KeymapPanel.this.myQuickListsModified) {
                    KeymapPanel.this.currentKeymapChanged();
                    KeymapPanel.this.myQuickListsModified = false;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evt", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$2", "propertyChange"));
            }
        });
        this.myFilteringPanel.addPropertyChangeListener("shortcut", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                KeymapPanel.this.filterTreeByShortcut(KeymapPanel.this.myFilteringPanel.getShortcut());
            }
        });
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.myFilteringPanel != null) {
            SwingUtilities.updateComponentTreeUI(this.myFilteringPanel);
        }
    }

    @Override
    public void quickListRenamed(QuickList oldQuickList, QuickList newQuickList) {
        this.myManager.visitMutableKeymaps(keymap -> {
            String actionId = oldQuickList.getActionId();
            Shortcut[] shortcuts = keymap.getShortcuts(actionId);
            if (shortcuts.length != 0) {
                String newActionId = newQuickList.getActionId();
                for (Shortcut shortcut : shortcuts) {
                    keymap.removeShortcut(actionId, shortcut);
                    keymap.addShortcut(newActionId, shortcut);
                }
            }
        });
        this.myQuickListsModified = true;
    }

    public Runnable enableSearch(String option) {
        return () -> this.showOption(option);
    }

    @Override
    public void processCurrentKeymapChanged() {
        this.currentKeymapChanged();
    }

    @Override
    public void processCurrentKeymapChanged(@NotNull QuickList[] ids) {
        if (ids == null) {
            KeymapPanel.$$$reportNull$$$0(0);
        }
        this.myQuickLists = ids;
        this.currentKeymapChanged();
    }

    private void currentKeymapChanged() {
        this.currentKeymapChanged(this.myManager.getSelectedKeymap());
    }

    private void currentKeymapChanged(Keymap selectedKeymap) {
        if (selectedKeymap == null) {
            selectedKeymap = new KeymapImpl();
        }
        this.myActionsTree.reset(selectedKeymap, this.myQuickLists);
    }

    private JPanel createKeymapSettingsPanel() {
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BorderLayout());
        panel2.add((Component)this.createToolbarPanel(), "North");
        panel2.add((Component)this.myActionsTree.getComponent(), "Center");
        this.myTreeExpansionMonitor = TreeExpansionMonitor.install(this.myActionsTree.getTree());
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                KeymapPanel.this.editSelection(e, true);
                return true;
            }
        }.installOn((Component)this.myActionsTree.getTree());
        this.myActionsTree.getTree().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(@NotNull MouseEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (e.isPopupTrigger()) {
                    KeymapPanel.this.editSelection(e, false);
                    e.consume();
                }
            }

            @Override
            public void mouseReleased(@NotNull MouseEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(1);
                }
                if (e.isPopupTrigger()) {
                    KeymapPanel.this.editSelection(e, false);
                    e.consume();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/openapi/keymap/impl/ui/KeymapPanel$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "mousePressed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "mouseReleased";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return panel2;
    }

    private JPanel createToolbarPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        DefaultActionGroup group = new DefaultActionGroup();
        JComponent toolbar = ActionManager.getInstance().createActionToolbar("KeymapEdit", (ActionGroup)group, true).getComponent();
        CommonActionsManager commonActionsManager = CommonActionsManager.getInstance();
        TreeExpander treeExpander = KeymapPanel.createTreeExpander(this.myActionsTree);
        group.add(commonActionsManager.createExpandAllAction(treeExpander, (JComponent)this.myActionsTree.getTree()));
        group.add(commonActionsManager.createCollapseAllAction(treeExpander, (JComponent)this.myActionsTree.getTree()));
        group.add(new AnAction("Edit Shortcut", "Edit Shortcut", AllIcons.ToolbarDecorator.Edit){
            {
                this.registerCustomShortcutSet(CommonShortcuts.ENTER, KeymapPanel.this.myActionsTree.getTree());
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(0);
                }
                String actionId = KeymapPanel.this.myActionsTree.getSelectedActionId();
                e.getPresentation().setEnabled(actionId != null);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(1);
                }
                KeymapPanel.this.editSelection(e.getInputEvent(), false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/openapi/keymap/impl/ui/KeymapPanel$6";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        panel2.add((Component)toolbar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, (Insets)JBUI.insetsTop((int)8), 0, 0));
        group = new DefaultActionGroup();
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("Keymap", (ActionGroup)group, true);
        actionToolbar.setReservePlaceAutoPopupIcon(false);
        final JComponent searchToolbar = actionToolbar.getComponent();
        final Alarm alarm = new Alarm();
        this.myFilterComponent = new FilterComponent("KEYMAP", 5){

            public void filter() {
                alarm.cancelAllRequests();
                alarm.addRequest(() -> {
                    if (!KeymapPanel.this.myFilterComponent.isShowing()) {
                        return;
                    }
                    KeymapPanel.this.myTreeExpansionMonitor.freeze();
                    KeymapPanel.this.myFilteringPanel.setShortcut(null);
                    String filter2 = this.getFilter();
                    KeymapPanel.this.myActionsTree.filter(filter2, KeymapPanel.this.myQuickLists);
                    JTree tree = KeymapPanel.this.myActionsTree.getTree();
                    TreeUtil.expandAll((JTree)tree);
                    if (filter2 == null || filter2.length() == 0) {
                        TreeUtil.collapseAll((JTree)tree, (int)0);
                        KeymapPanel.this.myTreeExpansionMonitor.restore();
                    } else {
                        KeymapPanel.this.myTreeExpansionMonitor.unfreeze();
                    }
                }, 300);
            }
        };
        this.myFilterComponent.reset();
        panel2.add((Component)this.myFilterComponent, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, (Insets)JBUI.insetsTop((int)8), 0, 0));
        group.add((AnAction)new DumbAwareAction(KeyMapBundle.message((String)"filter.shortcut.action.text", (Object[])new Object[0]), KeyMapBundle.message((String)"filter.shortcut.action.text", (Object[])new Object[0]), AllIcons.Actions.ShortcutFilter){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    8.$$$reportNull$$$0(0);
                }
                KeymapPanel.this.myFilterComponent.reset();
                KeymapPanel.this.currentKeymapChanged();
                KeymapPanel.this.myFilteringPanel.showPopup(searchToolbar);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$8", "actionPerformed"));
            }
        });
        group.add((AnAction)new DumbAwareAction(KeyMapBundle.message((String)"filter.clear.action.text", (Object[])new Object[0]), KeyMapBundle.message((String)"filter.clear.action.text", (Object[])new Object[0]), AllIcons.Actions.GC){

            public void update(AnActionEvent event) {
                boolean enabled = null != KeymapPanel.this.myFilteringPanel.getShortcut();
                Presentation presentation = event.getPresentation();
                presentation.setEnabled(enabled);
                presentation.setIcon(enabled ? AllIcons.Actions.Cancel : EmptyIcon.ICON_16);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    9.$$$reportNull$$$0(0);
                }
                KeymapPanel.this.myTreeExpansionMonitor.freeze();
                KeymapPanel.this.myFilteringPanel.setShortcut(null);
                KeymapPanel.this.myActionsTree.filter(null, KeymapPanel.this.myQuickLists);
                TreeUtil.collapseAll((JTree)KeymapPanel.this.myActionsTree.getTree(), (int)0);
                KeymapPanel.this.myTreeExpansionMonitor.restore();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$9", "actionPerformed"));
            }
        });
        panel2.add((Component)searchToolbar, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, (Insets)JBUI.insetsTop((int)8), 0, 0));
        return panel2;
    }

    @NotNull
    public static TreeExpander createTreeExpander(final ActionsTree actionsTree) {
        TreeExpander treeExpander = new TreeExpander(){

            public void expandAll() {
                TreeUtil.expandAll((JTree)actionsTree.getTree());
            }

            public boolean canExpand() {
                return true;
            }

            public void collapseAll() {
                TreeUtil.collapseAll((JTree)actionsTree.getTree(), (int)0);
            }

            public boolean canCollapse() {
                return true;
            }
        };
        if (treeExpander == null) {
            KeymapPanel.$$$reportNull$$$0(1);
        }
        return treeExpander;
    }

    private void filterTreeByShortcut(Shortcut shortcut) {
        this.myTreeExpansionMonitor.freeze();
        this.myActionsTree.filterTree(shortcut, this.myQuickLists);
        JTree tree = this.myActionsTree.getTree();
        TreeUtil.expandAll((JTree)tree);
        this.myTreeExpansionMonitor.restore();
    }

    public void showOption(String option) {
        this.currentKeymapChanged();
        this.myFilterComponent.setFilter(option);
        this.myFilteringPanel.setShortcut(null);
        this.myActionsTree.filter(option, this.myQuickLists);
    }

    public static void addKeyboardShortcut(@NotNull String actionId, @NotNull ShortcutRestrictions restrictions, @NotNull Keymap keymapSelected, @NotNull Component parent, QuickList ... quickLists) {
        Shortcut[] shortcuts;
        if (actionId == null) {
            KeymapPanel.$$$reportNull$$$0(2);
        }
        if (restrictions == null) {
            KeymapPanel.$$$reportNull$$$0(3);
        }
        if (keymapSelected == null) {
            KeymapPanel.$$$reportNull$$$0(4);
        }
        if (parent == null) {
            KeymapPanel.$$$reportNull$$$0(5);
        }
        if (quickLists == null) {
            KeymapPanel.$$$reportNull$$$0(6);
        }
        if (!restrictions.allowKeyboardShortcut) {
            return;
        }
        KeyboardShortcutDialog dialog2 = new KeyboardShortcutDialog(parent, restrictions.allowKeyboardSecondStroke);
        KeyboardShortcut keyboardShortcut = (KeyboardShortcut)dialog2.showAndGet(actionId, keymapSelected, quickLists);
        if (keyboardShortcut == null) {
            return;
        }
        Keymap keymap = null;
        if (dialog2.hasConflicts()) {
            int result2 = KeymapPanel.showConfirmationDialog(parent);
            if (result2 == 0) {
                keymap = KeymapPanel.createKeymapCopyIfNeededAndPossible(parent, keymapSelected);
                Map conflicts = keymap.getConflicts(actionId, keyboardShortcut);
                for (String id : conflicts.keySet()) {
                    for (KeyboardShortcut s : (List)conflicts.get(id)) {
                        keymap.removeShortcut(id, (Shortcut)s);
                    }
                }
            } else if (result2 != 1) {
                return;
            }
        }
        if (keymap == null) {
            keymap = KeymapPanel.createKeymapCopyIfNeededAndPossible(parent, keymapSelected);
        }
        for (Shortcut s : shortcuts = keymap.getShortcuts(actionId)) {
            if (!s.equals(keyboardShortcut)) continue;
            return;
        }
        keymap.addShortcut(actionId, (Shortcut)keyboardShortcut);
        if (StringUtil.startsWithChar((CharSequence)actionId, (char)'$')) {
            keymap.addShortcut(KeyMapBundle.message((String)"editor.shortcut", (Object[])new Object[]{actionId.substring(1)}), (Shortcut)keyboardShortcut);
        }
    }

    private static void addMouseShortcut(@NotNull String actionId, @NotNull ShortcutRestrictions restrictions, @NotNull Keymap keymapSelected, @NotNull Component parent, QuickList ... quickLists) {
        Shortcut[] shortcuts;
        if (actionId == null) {
            KeymapPanel.$$$reportNull$$$0(7);
        }
        if (restrictions == null) {
            KeymapPanel.$$$reportNull$$$0(8);
        }
        if (keymapSelected == null) {
            KeymapPanel.$$$reportNull$$$0(9);
        }
        if (parent == null) {
            KeymapPanel.$$$reportNull$$$0(10);
        }
        if (quickLists == null) {
            KeymapPanel.$$$reportNull$$$0(11);
        }
        if (!restrictions.allowMouseShortcut) {
            return;
        }
        MouseShortcutDialog dialog2 = new MouseShortcutDialog(parent, restrictions.allowMouseDoubleClick);
        MouseShortcut mouseShortcut = (MouseShortcut)dialog2.showAndGet(actionId, keymapSelected, quickLists);
        if (mouseShortcut == null) {
            return;
        }
        Keymap keymap = null;
        if (dialog2.hasConflicts()) {
            int result2 = KeymapPanel.showConfirmationDialog(parent);
            if (result2 == 0) {
                String[] actionIds;
                keymap = KeymapPanel.createKeymapCopyIfNeededAndPossible(parent, keymapSelected);
                String[] stringArray = actionIds = keymap.getActionIds(mouseShortcut);
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String id = stringArray[i];
                    keymap.removeShortcut(id, (Shortcut)mouseShortcut);
                }
            } else if (result2 != 1) {
                return;
            }
        }
        if (keymap == null) {
            keymap = KeymapPanel.createKeymapCopyIfNeededAndPossible(parent, keymapSelected);
        }
        for (Shortcut shortcut1 : shortcuts = keymap.getShortcuts(actionId)) {
            if (!shortcut1.equals(mouseShortcut)) continue;
            return;
        }
        keymap.addShortcut(actionId, (Shortcut)mouseShortcut);
        if (StringUtil.startsWithChar((CharSequence)actionId, (char)'$')) {
            keymap.addShortcut(KeyMapBundle.message((String)"editor.shortcut", (Object[])new Object[]{actionId.substring(1)}), (Shortcut)mouseShortcut);
        }
    }

    private void repaintLists() {
        this.myActionsTree.getComponent().repaint();
    }

    @NotNull
    private static Keymap createKeymapCopyIfNeededAndPossible(Component parent, Keymap keymap) {
        if (parent instanceof KeymapPanel) {
            KeymapPanel panel2 = (KeymapPanel)parent;
            Keymap keymap2 = panel2.myManager.getMutableKeymap(keymap);
            if (keymap2 == null) {
                KeymapPanel.$$$reportNull$$$0(12);
            }
            return keymap2;
        }
        Keymap keymap3 = keymap;
        if (keymap3 == null) {
            KeymapPanel.$$$reportNull$$$0(13);
        }
        return keymap3;
    }

    @NotNull
    public String getId() {
        if ("preferences.keymap" == null) {
            KeymapPanel.$$$reportNull$$$0(14);
        }
        return "preferences.keymap";
    }

    public void reset() {
        if (this.preferKeyPositionOverCharOption != null) {
            this.preferKeyPositionOverCharOption.setSelected(KeyboardSettingsExternalizable.getInstance().isPreferKeyPositionOverCharOption());
        }
        this.myManager.reset();
    }

    public void apply() throws ConfigurationException {
        String error = this.myManager.apply();
        if (error != null) {
            throw new ConfigurationException(error);
        }
        ActionToolbarImpl.updateAllToolbarsImmediately();
    }

    public boolean isModified() {
        return this.myManager.isModified();
    }

    public void selectAction(String actionId) {
        this.myActionsTree.selectAction(actionId);
    }

    @Nls
    public String getDisplayName() {
        return KeyMapBundle.message((String)"keymap.display.name", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return "preferences.keymap";
    }

    public JComponent createComponent() {
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(CHANGE_TOPIC, (Object)this);
        return this;
    }

    public void disposeUIResources() {
        this.myFilteringPanel.hidePopup();
        if (this.myFilterComponent != null) {
            this.myFilterComponent.dispose();
        }
        Disposer.dispose((Disposable)this);
    }

    public void dispose() {
    }

    @Nullable
    public Shortcut[] getCurrentShortcuts(@NotNull String actionId) {
        Keymap keymap;
        if (actionId == null) {
            KeymapPanel.$$$reportNull$$$0(15);
        }
        return (keymap = this.myManager.getSelectedKeymap()) == null ? null : keymap.getShortcuts(actionId);
    }

    private void editSelection(InputEvent e, boolean isDoubleClick) {
        String actionId = this.myActionsTree.getSelectedActionId();
        if (actionId == null) {
            return;
        }
        Keymap selectedKeymap = this.myManager.getSelectedKeymap();
        if (selectedKeymap == null) {
            return;
        }
        DefaultActionGroup group = this.createEditActionGroup(actionId, selectedKeymap);
        if (e instanceof MouseEvent && ((MouseEvent)e).isPopupTrigger()) {
            ActionManager.getInstance().createActionPopupMenu("unknown", (ActionGroup)group).getComponent().show(e.getComponent(), ((MouseEvent)e).getX(), ((MouseEvent)e).getY());
        } else if (!isDoubleClick || !ActionManager.getInstance().isGroup(actionId)) {
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)this);
            ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup("Edit Shortcuts", (ActionGroup)group, dataContext, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true);
            if (e instanceof MouseEvent) {
                popup2.show(new RelativePoint((MouseEvent)e));
            } else {
                popup2.showInBestPositionFor(dataContext);
            }
        }
    }

    @NotNull
    private DefaultActionGroup createEditActionGroup(final @NotNull String actionId, final Keymap selectedKeymap) {
        if (actionId == null) {
            KeymapPanel.$$$reportNull$$$0(16);
        }
        DefaultActionGroup group = new DefaultActionGroup();
        final ShortcutRestrictions restrictions = ActionShortcutRestrictions.getInstance().getForActionId(actionId);
        if (restrictions.allowKeyboardShortcut) {
            group.add((AnAction)new DumbAwareAction("Add Keyboard Shortcut"){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        11.$$$reportNull$$$0(0);
                    }
                    KeymapPanel.addKeyboardShortcut(actionId, restrictions, selectedKeymap, KeymapPanel.this, KeymapPanel.this.myQuickLists);
                    KeymapPanel.this.currentKeymapChanged();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$11", "actionPerformed"));
                }
            });
        }
        if (restrictions.allowMouseShortcut) {
            group.add((AnAction)new DumbAwareAction("Add Mouse Shortcut"){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        12.$$$reportNull$$$0(0);
                    }
                    KeymapPanel.addMouseShortcut(actionId, restrictions, selectedKeymap, KeymapPanel.this, KeymapPanel.this.myQuickLists);
                    KeymapPanel.this.currentKeymapChanged();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$12", "actionPerformed"));
                }
            });
        }
        if (Registry.is((String)"actionSystem.enableAbbreviations") && restrictions.allowAbbreviation) {
            group.add((AnAction)new DumbAwareAction("Add Abbreviation"){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    String abbr;
                    if (e == null) {
                        13.$$$reportNull$$$0(0);
                    }
                    if ((abbr = Messages.showInputDialog((String)"Enter new abbreviation:", (String)"Abbreviation", null)) != null) {
                        AbbreviationManager.getInstance().register(abbr, actionId);
                        KeymapPanel.this.repaintLists();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$13", "actionPerformed"));
                }
            });
        }
        group.addSeparator();
        for (final Shortcut shortcut : selectedKeymap.getShortcuts(actionId)) {
            group.add((AnAction)new DumbAwareAction("Remove " + KeymapUtil.getShortcutText((Shortcut)shortcut)){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        14.$$$reportNull$$$0(0);
                    }
                    Keymap keymap = KeymapPanel.this.myManager.getMutableKeymap(selectedKeymap);
                    keymap.removeShortcut(actionId, shortcut);
                    if (StringUtil.startsWithChar((CharSequence)actionId, (char)'$')) {
                        keymap.removeShortcut(KeyMapBundle.message((String)"editor.shortcut", (Object[])new Object[]{actionId.substring(1)}), shortcut);
                    }
                    KeymapPanel.this.currentKeymapChanged();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$14", "actionPerformed"));
                }
            });
        }
        if (Registry.is((String)"actionSystem.enableAbbreviations")) {
            for (final String abbreviation : AbbreviationManager.getInstance().getAbbreviations(actionId)) {
                group.addAction((AnAction)new DumbAwareAction("Remove Abbreviation '" + abbreviation + "'"){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            15.$$$reportNull$$$0(0);
                        }
                        AbbreviationManager.getInstance().remove(abbreviation, actionId);
                        KeymapPanel.this.repaintLists();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$15", "actionPerformed"));
                    }
                });
            }
        }
        if (this.myManager.canResetActionInKeymap(selectedKeymap, actionId)) {
            group.add((AnAction)new Separator());
            group.add((AnAction)new DumbAwareAction("Reset Shortcuts"){

                public void actionPerformed(@NotNull AnActionEvent event) {
                    if (event == null) {
                        16.$$$reportNull$$$0(0);
                    }
                    KeymapPanel.this.myManager.resetActionInKeymap(selectedKeymap, actionId);
                    KeymapPanel.this.repaintLists();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$16", "actionPerformed"));
                }
            });
        }
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            KeymapPanel.$$$reportNull$$$0(17);
        }
        return defaultActionGroup;
    }

    private static int showConfirmationDialog(Component parent) {
        return Messages.showYesNoCancelDialog((Component)parent, (String)KeyMapBundle.message((String)"conflict.shortcut.dialog.message", (Object[])new Object[0]), (String)KeyMapBundle.message((String)"conflict.shortcut.dialog.title", (Object[])new Object[0]), (String)KeyMapBundle.message((String)"conflict.shortcut.dialog.remove.button", (Object[])new Object[0]), (String)KeyMapBundle.message((String)"conflict.shortcut.dialog.leave.button", (Object[])new Object[0]), (String)KeyMapBundle.message((String)"conflict.shortcut.dialog.cancel.button", (Object[])new Object[0]), (Icon)Messages.getWarningIcon());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 12: 
            case 13: 
            case 14: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 12: 
            case 13: 
            case 14: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 1: 
            case 12: 
            case 13: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/keymap/impl/ui/KeymapPanel";
                break;
            }
            case 2: 
            case 7: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restrictions";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keymapSelected";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickLists";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/keymap/impl/ui/KeymapPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createTreeExpander";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createKeymapCopyIfNeededAndPossible";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditActionGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processCurrentKeymapChanged";
                break;
            }
            case 1: 
            case 12: 
            case 13: 
            case 14: 
            case 17: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addKeyboardShortcut";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addMouseShortcut";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentShortcuts";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createEditActionGroup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 12: 
            case 13: 
            case 14: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

