/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl.scopes;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.ModuleScopeProvider;
import com.intellij.openapi.module.impl.scopes.ModuleWithDependenciesScope;
import com.intellij.openapi.module.impl.scopes.ModuleWithDependentsScope;
import com.intellij.openapi.module.impl.scopes.ModuleWithDependentsTestScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;

public class ModuleScopeProviderImpl
implements ModuleScopeProvider {
    private final Module myModule;
    private final ConcurrentIntObjectMap<GlobalSearchScope> myScopeCache;
    private ModuleWithDependentsTestScope myModuleTestsWithDependentsScope;

    public ModuleScopeProviderImpl(@NotNull Module module2) {
        if (module2 == null) {
            ModuleScopeProviderImpl.$$$reportNull$$$0(0);
        }
        this.myScopeCache = ContainerUtil.createConcurrentIntObjectMap();
        this.myModule = module2;
    }

    @NotNull
    private GlobalSearchScope getCachedScope(@ModuleWithDependenciesScope.ScopeConstant int options) {
        GlobalSearchScope scope = (GlobalSearchScope)this.myScopeCache.get(options);
        if (scope == null) {
            scope = new ModuleWithDependenciesScope(this.myModule, options);
            this.myScopeCache.put(options, (Object)scope);
        }
        GlobalSearchScope globalSearchScope = scope;
        if (globalSearchScope == null) {
            ModuleScopeProviderImpl.$$$reportNull$$$0(1);
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleScope() {
        GlobalSearchScope globalSearchScope = this.getCachedScope(9);
        if (globalSearchScope == null) {
            ModuleScopeProviderImpl.$$$reportNull$$$0(2);
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleScope(boolean includeTests) {
        GlobalSearchScope globalSearchScope = this.getCachedScope(1 | (includeTests ? 8 : 0));
        if (globalSearchScope == null) {
            ModuleScopeProviderImpl.$$$reportNull$$$0(3);
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleWithLibrariesScope() {
        GlobalSearchScope globalSearchScope = this.getCachedScope(11);
        if (globalSearchScope == null) {
            ModuleScopeProviderImpl.$$$reportNull$$$0(4);
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleWithDependenciesScope() {
        GlobalSearchScope globalSearchScope = this.getCachedScope(13);
        if (globalSearchScope == null) {
            ModuleScopeProviderImpl.$$$reportNull$$$0(5);
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleContentScope() {
        GlobalSearchScope globalSearchScope = this.getCachedScope(32);
        if (globalSearchScope == null) {
            ModuleScopeProviderImpl.$$$reportNull$$$0(6);
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleContentWithDependenciesScope() {
        GlobalSearchScope globalSearchScope = this.getCachedScope(36);
        if (globalSearchScope == null) {
            ModuleScopeProviderImpl.$$$reportNull$$$0(7);
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleWithDependenciesAndLibrariesScope(boolean includeTests) {
        GlobalSearchScope globalSearchScope = this.getCachedScope(7 | (includeTests ? 8 : 0));
        if (globalSearchScope == null) {
            ModuleScopeProviderImpl.$$$reportNull$$$0(8);
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleWithDependentsScope() {
        ModuleWithDependentsScope moduleWithDependentsScope = this.getModuleTestsWithDependentsScope().getBaseScope();
        if (moduleWithDependentsScope == null) {
            ModuleScopeProviderImpl.$$$reportNull$$$0(9);
        }
        return moduleWithDependentsScope;
    }

    @NotNull
    public ModuleWithDependentsTestScope getModuleTestsWithDependentsScope() {
        ModuleWithDependentsTestScope scope = this.myModuleTestsWithDependentsScope;
        if (scope == null) {
            this.myModuleTestsWithDependentsScope = scope = new ModuleWithDependentsTestScope(this.myModule);
        }
        ModuleWithDependentsTestScope moduleWithDependentsTestScope = scope;
        if (moduleWithDependentsTestScope == null) {
            ModuleScopeProviderImpl.$$$reportNull$$$0(10);
        }
        return moduleWithDependentsTestScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleRuntimeScope(boolean includeTests) {
        GlobalSearchScope globalSearchScope = this.getCachedScope(6 | (includeTests ? 8 : 0));
        if (globalSearchScope == null) {
            ModuleScopeProviderImpl.$$$reportNull$$$0(11);
        }
        return globalSearchScope;
    }

    @Override
    public void clearCache() {
        this.myScopeCache.clear();
        this.myModuleTestsWithDependentsScope = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/module/impl/scopes/ModuleScopeProviderImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/module/impl/scopes/ModuleScopeProviderImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedScope";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleScope";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleWithLibrariesScope";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleWithDependenciesScope";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleContentScope";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleContentWithDependenciesScope";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleWithDependenciesAndLibrariesScope";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleWithDependentsScope";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleTestsWithDependentsScope";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleRuntimeScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

