/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class ColorProgressBar
extends JComponent {
    private static final Dimension PREFERRED_SIZE = new Dimension(146, 17);
    public static final Color GREEN = new JBColor(() -> {
        UISettings settings = UISettings.getInstance();
        return settings == null || null == settings.getColorBlindness() ? new JBColor(new Color(7122292), new Color(4885587)) : new JBColor(new Color(7120540), new Color(6527376));
    });
    public static final Color RED = new JBColor(() -> {
        UISettings settings = UISettings.getInstance();
        return settings == null || null == settings.getColorBlindness() ? new JBColor(new Color(14056310), new Color(0xE55757)) : new JBColor(new Color(0xCC7447), new Color(0xCC7447));
    });
    public static final Color RED_TEXT = new JBColor(new Color(12064520), new Color(14376028));
    public static final Color BLUE = new JBColor(new Color(1, 68, 208), (Color)JBColor.blue);
    public static final Color YELLOW = new JBColor(new Color(10910241), new Color(9531450));
    private static final Color SHADOW1 = new JBColor((Color)Gray._190, UIUtil.getBorderColor());
    private static final Color SHADOW2 = Gray._105;
    private static final int BRICK_WIDTH = 6;
    private static final int BRICK_SPACE = 1;
    private static final int INDETERMINATE_BRICKS_DRAW = 5;
    private static final double INDETERMINATE_INC_OFFSET = 0.02;
    private double myFraction = 0.0;
    private Color myColor = BLUE;
    private double myIndeterminateInc = 0.02;
    private boolean myIndeterminate = false;

    public boolean isIndeterminate() {
        return this.myIndeterminate;
    }

    public void setIndeterminate(boolean indeterminate) {
        this.myIndeterminate = indeterminate;
    }

    public ColorProgressBar() {
        this.updateUI();
    }

    public void setColor(Color color) {
        this.myColor = color;
        if (this.isDisplayable()) {
            this.repaint();
        }
    }

    public double getFraction() {
        return this.myFraction;
    }

    public void setFraction(double fraction) {
        if (Double.isNaN(fraction)) {
            fraction = 1.0;
        }
        if (this.myIndeterminate) {
            if (this.myFraction >= 1.0) {
                this.myIndeterminateInc = -0.02;
            } else if (this.myFraction <= 0.0) {
                this.myIndeterminateInc = 0.02;
            }
            boolean changed = this.myFraction == 0.0 || this.getBricksToDraw(this.myFraction) != this.getBricksToDraw(this.myFraction + this.myIndeterminateInc);
            this.myFraction += this.myIndeterminateInc;
            if (changed) {
                this.repaint();
            }
        } else {
            boolean changed = this.myFraction == 0.0 || this.getBricksToDraw(this.myFraction) != this.getBricksToDraw(fraction);
            this.myFraction = fraction;
            if (changed) {
                this.repaint();
            }
        }
    }

    private int getBricksToDraw(double fraction) {
        int bricksTotal = (this.getWidth() - 8) / 7;
        return (int)((double)bricksTotal * fraction) + 1;
    }

    @Override
    protected void paintComponent(Graphics g) {
        int bricksToDraw;
        super.paintComponent(g);
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
        Graphics2D g2 = (Graphics2D)g;
        if (this.myFraction > 1.0) {
            this.myFraction = 1.0;
        }
        Dimension size = this.getSize();
        g2.setPaint(UIUtil.getListBackground());
        Rectangle2D.Double rect = new Rectangle2D.Double(2.0, 2.0, size.width - 4, size.height - 4);
        g2.fill(rect);
        g2.setPaint((Paint)new JBColor(SHADOW1, UIUtil.getBorderColor()));
        ((Rectangle2D)rect).setRect(1.0, 1.0, size.width - 2, size.height - 2);
        g2.drawRoundRect(1, 1, size.width - 2, size.height - 2, 5, 5);
        g2.setPaint(SHADOW2);
        g2.drawRoundRect(0, 0, size.width - 2, size.height - 2, 5, 5);
        int y_center = size.height / 2;
        int y_steps = size.height / 2 - 3;
        int alpha_step = y_steps > 0 ? 185 / y_steps : 185;
        int x_offset = 4;
        g.setClip(4, 3, size.width - 8, size.height - 6);
        int n = bricksToDraw = this.myFraction == 0.0 ? 0 : this.getBricksToDraw(this.myFraction);
        if (this.myIndeterminate) {
            int startFrom = bricksToDraw < 5 ? 0 : bricksToDraw - 5;
            int endTo = bricksToDraw + 5 < this.getBricksToDraw(1.0) ? bricksToDraw + 5 : this.getBricksToDraw(1.0);
            for (int i = startFrom; i <= endTo; ++i) {
                g2.setPaint(this.myColor);
                int startXOffset = x_offset + 7 * i;
                UIUtil.drawLine((Graphics)g2, (int)startXOffset, (int)y_center, (int)(startXOffset + 6 - 1), (int)y_center);
                for (int j = 0; j < y_steps; ++j) {
                    Color color = ColorUtil.toAlpha((Color)this.myColor, (int)(255 - alpha_step * (j + 1)));
                    g2.setPaint(color);
                    UIUtil.drawLine((Graphics)g2, (int)startXOffset, (int)(y_center - 1 - j), (int)(startXOffset + 6 - 1), (int)(y_center - 1 - j));
                    if (y_center % 2 != 0 && j == y_steps - 1) continue;
                    UIUtil.drawLine((Graphics)g2, (int)startXOffset, (int)(y_center + 1 + j), (int)(startXOffset + 6 - 1), (int)(y_center + 1 + j));
                }
                g2.setColor(ColorUtil.toAlpha((Color)this.myColor, (int)(255 - alpha_step * (y_steps / 2 + 1))));
                g2.drawRect(startXOffset, y_center - y_steps, 5, size.height - 7);
            }
        } else {
            for (int i = 0; i < bricksToDraw; ++i) {
                g2.setPaint(this.myColor);
                UIUtil.drawLine((Graphics)g2, (int)x_offset, (int)y_center, (int)(x_offset + 6 - 1), (int)y_center);
                for (int j = 0; j < y_steps; ++j) {
                    Color color = ColorUtil.toAlpha((Color)this.myColor, (int)(255 - alpha_step * (j + 1)));
                    g2.setPaint(color);
                    UIUtil.drawLine((Graphics)g2, (int)x_offset, (int)(y_center - 1 - j), (int)(x_offset + 6 - 1), (int)(y_center - 1 - j));
                    if (y_center % 2 != 0 && j == y_steps - 1) continue;
                    UIUtil.drawLine((Graphics)g2, (int)x_offset, (int)(y_center + 1 + j), (int)(x_offset + 6 - 1), (int)(y_center + 1 + j));
                }
                g2.setColor(ColorUtil.toAlpha((Color)this.myColor, (int)(255 - alpha_step * (y_steps / 2 + 1))));
                g2.drawRect(x_offset, y_center - y_steps, 5, size.height - 7);
                x_offset += 7;
            }
        }
        config.restore();
    }

    @Override
    public Dimension getPreferredSize() {
        return PREFERRED_SIZE;
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension dimension = this.getPreferredSize();
        dimension.width = Short.MAX_VALUE;
        return dimension;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension = this.getPreferredSize();
        dimension.width = 13;
        return dimension;
    }

    public Color getColor() {
        return this.myColor;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("ColorProgressBar Test");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.setSize(800, 600);
        frame.setLocation(0, 0);
        Container contentPane = frame.getContentPane();
        contentPane.setLayout(new BorderLayout());
        final ColorProgressBar colorProgressBar = new ColorProgressBar();
        colorProgressBar.setFraction(0.5);
        colorProgressBar.setIndeterminate(true);
        contentPane.add((Component)colorProgressBar, "North");
        frame.setVisible(true);
        JButton b = new JButton("X");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                colorProgressBar.setFraction(1.0);
            }
        });
        contentPane.add((Component)b, "South");
    }
}

