/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.shelf.CleanUnshelvedFilterDialog;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import org.jetbrains.annotations.NotNull;

public class CleanUnshelvedAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            CleanUnshelvedAction.$$$reportNull$$$0(0);
        }
        super.update(e);
        Project project = CleanUnshelvedAction.getEventProject((AnActionEvent)e);
        Presentation presentation = e.getPresentation();
        if (project == null) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        presentation.setVisible(true);
        presentation.setEnabled(!ShelveChangesManager.getInstance(project).getRecycledShelvedChangeLists().isEmpty());
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        CleanUnshelvedFilterDialog dialog2 = new CleanUnshelvedFilterDialog(project);
        dialog2.show();
        if (dialog2.isOK()) {
            if (dialog2.isUnshelvedWithFilterSelected()) {
                ShelveChangesManager.getInstance(project).cleanUnshelved(false, dialog2.getTimeLimitInMillis());
            } else if (dialog2.isAllUnshelvedSelected()) {
                ShelveChangesManager.getInstance(project).clearRecycled();
            } else {
                ShelveChangesManager.getInstance(project).cleanUnshelved(true, System.currentTimeMillis());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/shelf/CleanUnshelvedAction", "update"));
    }
}

