/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util.proximity;

import com.intellij.openapi.util.NullableLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.ProximityLocation;
import com.intellij.psi.util.proximity.ProximityWeigher;
import org.jetbrains.annotations.NotNull;

public class SameDirectoryWeigher
extends ProximityWeigher {
    private static final NullableLazyKey<PsiDirectory, ProximityLocation> PLACE_DIRECTORY = NullableLazyKey.create((String)"placeDirectory", location -> SameDirectoryWeigher.getParentDirectory(location.getPosition()));

    private static PsiDirectory getParentDirectory(PsiElement element) {
        PsiFile file2 = InjectedLanguageUtil.getTopLevelFile(element);
        if (file2 != null) {
            element = file2.getOriginalFile();
        }
        while (element != null && !(element instanceof PsiDirectory)) {
            element = element.getParent();
        }
        return (PsiDirectory)element;
    }

    @Override
    public Boolean weigh(@NotNull PsiElement element, @NotNull ProximityLocation location) {
        if (element == null) {
            SameDirectoryWeigher.$$$reportNull$$$0(0);
        }
        if (location == null) {
            SameDirectoryWeigher.$$$reportNull$$$0(1);
        }
        if (location.getPosition() == null) {
            return Boolean.TRUE;
        }
        PsiDirectory placeDirectory = (PsiDirectory)PLACE_DIRECTORY.getValue((UserDataHolder)location);
        return placeDirectory != null && placeDirectory.equals(SameDirectoryWeigher.getParentDirectory(element));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "location";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/util/proximity/SameDirectoryWeigher";
        objectArray[2] = "weigh";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

