/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.actions;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.ide.IdeEventQueue;
import com.intellij.lang.ContextAwareActionHandler;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseRefactoringAction
extends AnAction {
    private final Condition<Language> myLanguageCondition = language -> this.isAvailableForLanguage((Language)language);

    protected abstract boolean isAvailableInEditorOnly();

    protected abstract boolean isEnabledOnElements(@NotNull PsiElement[] var1);

    public boolean startInTransaction() {
        return true;
    }

    protected boolean isAvailableOnElementInEditorAndFile(@NotNull PsiElement element, @NotNull Editor editor, @NotNull PsiFile file2, @NotNull DataContext context) {
        if (element == null) {
            BaseRefactoringAction.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            BaseRefactoringAction.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            BaseRefactoringAction.$$$reportNull$$$0(2);
        }
        if (context == null) {
            BaseRefactoringAction.$$$reportNull$$$0(3);
        }
        return true;
    }

    protected boolean hasAvailableHandler(@NotNull DataContext dataContext) {
        RefactoringActionHandler handler2;
        if (dataContext == null) {
            BaseRefactoringAction.$$$reportNull$$$0(4);
        }
        if ((handler2 = this.getHandler(dataContext)) != null) {
            if (handler2 instanceof ContextAwareActionHandler) {
                Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
                PsiFile file2 = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
                if (editor != null && file2 != null && !((ContextAwareActionHandler)handler2).isAvailableForQuickList(editor, file2, dataContext)) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Nullable
    protected abstract RefactoringActionHandler getHandler(@NotNull DataContext var1);

    public final void actionPerformed(@NotNull AnActionEvent e) {
        LookupEx lookup;
        RefactoringActionHandler handler2;
        if (e == null) {
            BaseRefactoringAction.$$$reportNull$$$0(5);
        }
        DataContext dataContext = e.getDataContext();
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        PsiElement[] elements = BaseRefactoringAction.getPsiElementArray(dataContext);
        int eventCount = IdeEventQueue.getInstance().getEventCount();
        try {
            handler2 = this.getHandler(dataContext);
        }
        catch (ProcessCanceledException ignored) {
            return;
        }
        if (handler2 == null) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.symbol.to.refactor"));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)RefactoringBundle.getCannotRefactorMessage(null), null);
            return;
        }
        InplaceRefactoring activeInplaceRenamer = InplaceRefactoring.getActiveInplaceRenamer(editor);
        if (!InplaceRefactoring.canStartAnotherRefactoring(editor, project, handler2, elements) && activeInplaceRenamer != null) {
            InplaceRefactoring.unableToStartWarning(project, editor);
            return;
        }
        if (activeInplaceRenamer == null && (lookup = LookupManager.getActiveLookup(editor)) instanceof LookupImpl) {
            Runnable command = () -> ((LookupImpl)lookup).finishLookup('\n');
            Document doc = editor.getDocument();
            DocCommandGroupId group = DocCommandGroupId.noneGroupId((Document)doc);
            CommandProcessor.getInstance().executeCommand(editor.getProject(), command, "Completion", (Object)group, UndoConfirmationPolicy.DEFAULT, doc);
        }
        IdeEventQueue.getInstance().setEventCount(eventCount);
        if (editor != null) {
            PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            if (file2 == null) {
                return;
            }
            DaemonCodeAnalyzer.getInstance((Project)project).autoImportReferenceAtCursor(editor, file2);
            handler2.invoke(project, editor, file2, dataContext);
        } else {
            handler2.invoke(project, elements, dataContext);
        }
    }

    protected boolean isEnabledOnDataContext(DataContext dataContext) {
        return false;
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        presentation.setVisible(true);
        presentation.setEnabled(true);
        DataContext dataContext = e.getDataContext();
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null || this.isHidden()) {
            BaseRefactoringAction.hideAction(e);
            return;
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        PsiFile file2 = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (file2 != null && (file2 instanceof PsiCompiledElement || !this.isAvailableForFile(file2))) {
            BaseRefactoringAction.hideAction(e);
            return;
        }
        if (editor == null) {
            boolean isEnabled;
            if (this.isAvailableInEditorOnly()) {
                BaseRefactoringAction.hideAction(e);
                return;
            }
            PsiElement[] elements = BaseRefactoringAction.getPsiElementArray(dataContext);
            boolean bl = isEnabled = this.isEnabledOnDataContext(dataContext) || elements.length != 0 && this.isEnabledOnElements(elements);
            if (!isEnabled) {
                BaseRefactoringAction.disableAction(e);
            }
        } else {
            boolean isVisible;
            PsiElement element = (PsiElement)e.getData(CommonDataKeys.PSI_ELEMENT);
            Object[] languages = (Language[])e.getData(LangDataKeys.CONTEXT_LANGUAGES);
            if (element == null || !this.isAvailableForLanguage(element.getLanguage())) {
                if (file2 == null) {
                    BaseRefactoringAction.hideAction(e);
                    return;
                }
                element = BaseRefactoringAction.getElementAtCaret(editor, file2);
            }
            if (element == null || element instanceof SyntheticElement || languages == null) {
                BaseRefactoringAction.hideAction(e);
                return;
            }
            boolean bl = isVisible = ContainerUtil.find((Object[])languages, this.myLanguageCondition) != null;
            if (isVisible) {
                boolean isEnabled;
                boolean bl2 = isEnabled = file2 != null && this.isAvailableOnElementInEditorAndFile(element, editor, file2, dataContext);
                if (!isEnabled) {
                    BaseRefactoringAction.disableAction(e);
                }
            } else {
                BaseRefactoringAction.hideAction(e);
            }
        }
    }

    private static void hideAction(AnActionEvent e) {
        e.getPresentation().setVisible(false);
        BaseRefactoringAction.disableAction(e);
    }

    protected boolean isHidden() {
        return false;
    }

    public static PsiElement getElementAtCaret(Editor editor, PsiFile file2) {
        int offset = BaseRefactoringAction.fixCaretOffset(editor);
        PsiElement element = file2.findElementAt(offset);
        if (element == null && offset == file2.getTextLength()) {
            element = file2.findElementAt(offset - 1);
        }
        if (element instanceof PsiWhiteSpace) {
            element = file2.findElementAt(element.getTextRange().getStartOffset() - 1);
        }
        return element;
    }

    private static int fixCaretOffset(Editor editor) {
        int caret = editor.getCaretModel().getOffset();
        if (editor.getSelectionModel().hasSelection() && caret == editor.getSelectionModel().getSelectionEnd()) {
            return Math.max(editor.getSelectionModel().getSelectionStart(), editor.getSelectionModel().getSelectionEnd() - 1);
        }
        return caret;
    }

    private static void disableAction(AnActionEvent e) {
        e.getPresentation().setEnabled(false);
    }

    protected boolean isAvailableForLanguage(Language language) {
        return language.isKindOf(StdFileTypes.JAVA.getLanguage());
    }

    protected boolean isAvailableForFile(PsiFile file2) {
        return true;
    }

    @NotNull
    public static PsiElement[] getPsiElementArray(DataContext dataContext) {
        PsiElement element;
        PsiElement[] psiElements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext);
        if ((psiElements == null || psiElements.length == 0) && (element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext)) != null) {
            psiElements = new PsiElement[]{element};
        }
        if (psiElements == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                BaseRefactoringAction.$$$reportNull$$$0(6);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        ArrayList<PsiElement> filtered = null;
        for (PsiElement element2 : psiElements) {
            if (!(element2 instanceof SyntheticElement)) continue;
            if (filtered == null) {
                filtered = new ArrayList<PsiElement>(Collections.singletonList(element2));
            }
            filtered.remove(element2);
        }
        PsiElement[] psiElementArray = filtered == null ? psiElements : PsiUtilCore.toPsiElementArray(filtered);
        if (psiElementArray == null) {
            BaseRefactoringAction.$$$reportNull$$$0(7);
        }
        return psiElementArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/actions/BaseRefactoringAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/actions/BaseRefactoringAction";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiElementArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableOnElementInEditorAndFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasAvailableHandler";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

