/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usageView;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewLongNameLocation;
import com.intellij.usageView.UsageViewNodeTextLocation;
import com.intellij.usageView.UsageViewShortNameLocation;
import com.intellij.usageView.UsageViewTypeLocation;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageView;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class UsageViewUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.usageView.UsageViewUtil");

    private UsageViewUtil() {
    }

    public static String createNodeText(PsiElement element) {
        return ElementDescriptionUtil.getElementDescription((PsiElement)element, (ElementDescriptionLocation)UsageViewNodeTextLocation.INSTANCE);
    }

    public static String getShortName(PsiElement psiElement) {
        LOG.assertTrue(psiElement.isValid(), (Object)psiElement);
        return ElementDescriptionUtil.getElementDescription((PsiElement)psiElement, (ElementDescriptionLocation)UsageViewShortNameLocation.INSTANCE);
    }

    public static String getLongName(PsiElement psiElement) {
        LOG.assertTrue(psiElement.isValid(), (Object)psiElement);
        return ElementDescriptionUtil.getElementDescription((PsiElement)psiElement, (ElementDescriptionLocation)UsageViewLongNameLocation.INSTANCE);
    }

    public static String getType(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            UsageViewUtil.$$$reportNull$$$0(0);
        }
        return ElementDescriptionUtil.getElementDescription((PsiElement)psiElement, (ElementDescriptionLocation)UsageViewTypeLocation.INSTANCE);
    }

    public static boolean hasNonCodeUsages(UsageInfo[] usages) {
        for (UsageInfo usage : usages) {
            if (!usage.isNonCodeUsage) continue;
            return true;
        }
        return false;
    }

    public static boolean hasUsagesInGeneratedCode(UsageInfo[] usages, Project project) {
        for (UsageInfo usage : usages) {
            VirtualFile file2 = usage.getVirtualFile();
            if (file2 == null || !GeneratedSourcesFilter.isGeneratedSourceByAnyFilter((VirtualFile)file2, (Project)project)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasReadOnlyUsages(UsageInfo[] usages) {
        for (UsageInfo usage : usages) {
            if (usage.isWritable()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static UsageInfo[] removeDuplicatedUsages(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            UsageViewUtil.$$$reportNull$$$0(1);
        }
        LinkedHashSet<UsageInfo> set2 = new LinkedHashSet<UsageInfo>(Arrays.asList(usages));
        String newTextInNonCodeUsage = null;
        for (UsageInfo usage : usages) {
            if (!(usage instanceof NonCodeUsageInfo)) continue;
            newTextInNonCodeUsage = ((NonCodeUsageInfo)usage).newText;
            break;
        }
        if (newTextInNonCodeUsage != null) {
            for (UsageInfo usage : usages) {
                PsiReference psiReference;
                PsiElement usageElement;
                PsiLanguageInjectionHost context;
                PsiFile file2;
                if (!(usage instanceof MoveRenameUsageInfo) || (file2 = usage.getFile()) == null || (context = InjectedLanguageManager.getInstance((Project)file2.getProject()).getInjectionHost((PsiElement)file2)) == null || (usageElement = usage.getElement()) == null || (psiReference = usage.getReference()) == null) continue;
                int injectionOffsetInMasterFile = InjectedLanguageManager.getInstance((Project)usageElement.getProject()).injectedToHost(usageElement, usageElement.getTextOffset());
                ProperTextRange rangeInElement = usage.getRangeInElement();
                assert (rangeInElement != null) : usage;
                TextRange range = rangeInElement.shiftRight(injectionOffsetInMasterFile);
                PsiFile containingFile = context.getContainingFile();
                if (containingFile == null) continue;
                set2.remove(NonCodeUsageInfo.create((PsiFile)containingFile, (int)range.getStartOffset(), (int)range.getEndOffset(), (PsiElement)((MoveRenameUsageInfo)usage).getReferencedElement(), (String)newTextInNonCodeUsage));
            }
        }
        UsageInfo[] usageInfoArray = set2.toArray(new UsageInfo[set2.size()]);
        if (usageInfoArray == null) {
            UsageViewUtil.$$$reportNull$$$0(2);
        }
        return usageInfoArray;
    }

    @NotNull
    public static UsageInfo[] toUsageInfoArray(@NotNull Collection<? extends UsageInfo> collection) {
        int size;
        if (collection == null) {
            UsageViewUtil.$$$reportNull$$$0(3);
        }
        UsageInfo[] usageInfoArray = (size = collection.size()) == 0 ? UsageInfo.EMPTY_ARRAY : collection.toArray(new UsageInfo[size]);
        if (usageInfoArray == null) {
            UsageViewUtil.$$$reportNull$$$0(4);
        }
        return usageInfoArray;
    }

    @NotNull
    public static PsiElement[] toElements(@NotNull UsageInfo[] usageInfos) {
        if (usageInfos == null) {
            UsageViewUtil.$$$reportNull$$$0(5);
        }
        PsiElement[] psiElementArray = (PsiElement[])ContainerUtil.map2Array((Object[])usageInfos, PsiElement.class, info -> info.getElement());
        if (psiElementArray == null) {
            UsageViewUtil.$$$reportNull$$$0(6);
        }
        return psiElementArray;
    }

    public static void navigateTo(@NotNull UsageInfo info, boolean requestFocus) {
        if (info == null) {
            UsageViewUtil.$$$reportNull$$$0(7);
        }
        int offset = info.getNavigationOffset();
        VirtualFile file2 = info.getVirtualFile();
        Project project = info.getProject();
        if (file2 != null) {
            FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, file2, offset), requestFocus);
        }
    }

    public static Set<UsageInfo> getNotExcludedUsageInfos(UsageView usageView) {
        Set excludedUsages = usageView.getExcludedUsages();
        LinkedHashSet<UsageInfo> usageInfos = new LinkedHashSet<UsageInfo>();
        for (Usage usage : usageView.getUsages()) {
            if (!(usage instanceof UsageInfo2UsageAdapter) || excludedUsages.contains(usage)) continue;
            UsageInfo usageInfo = ((UsageInfo2UsageAdapter)usage).getUsageInfo();
            usageInfos.add(usageInfo);
        }
        return usageInfos;
    }

    public static boolean reportNonRegularUsages(UsageInfo[] usages, Project project) {
        boolean inGeneratedCode = UsageViewUtil.hasUsagesInGeneratedCode(usages, project);
        if (UsageViewUtil.hasNonCodeUsages(usages) || inGeneratedCode) {
            StatusBar statusBar = WindowManager.getInstance().getStatusBar(project);
            if (statusBar != null) {
                statusBar.setInfo(RefactoringBundle.message((String)(inGeneratedCode ? "occurrences.found.in.comments.strings.non.java.files.and.generated.code" : "occurrences.found.in.comments.strings.and.non.java.files")));
            }
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/usageView/UsageViewUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfos";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/usageView/UsageViewUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "removeDuplicatedUsages";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "toUsageInfoArray";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "toElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "removeDuplicatedUsages";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "toUsageInfoArray";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "toElements";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "navigateTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

