/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.PlatformIcons;
import com.intellij.util.Producer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ListItemsDialogWrapper
extends DialogWrapper {
    protected final JPanel myPanel;
    protected final JList<String> myList = new JBList(new DefaultListModel());
    protected List<String> myData;

    public ListItemsDialogWrapper(String title) {
        super(true);
        this.myPanel = ToolbarDecorator.createDecorator(this.myList).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                String elementName = ListItemsDialogWrapper.this.createAddItemDialog();
                if (elementName != null) {
                    while (ListItemsDialogWrapper.this.myData.contains(elementName)) {
                        ListItemsDialogWrapper.this.myData.remove(elementName);
                    }
                    ListItemsDialogWrapper.this.myData.add(elementName);
                    ListItemsDialogWrapper.this.updateData();
                    ListItemsDialogWrapper.this.myList.setSelectedIndex(ListItemsDialogWrapper.this.myData.size() - 1);
                }
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                int selectedIndex = ListItemsDialogWrapper.this.myList.getSelectedIndex();
                if (selectedIndex >= 0) {
                    ListItemsDialogWrapper.this.myData.remove(selectedIndex);
                    ListItemsDialogWrapper.this.updateData();
                    if (selectedIndex >= ListItemsDialogWrapper.this.myData.size()) {
                        --selectedIndex;
                    }
                    if (selectedIndex >= 0) {
                        ListItemsDialogWrapper.this.myList.setSelectedIndex(selectedIndex);
                    }
                }
            }
        }).disableUpDownActions().createPanel();
        this.setTitle(title);
        this.init();
    }

    protected abstract String createAddItemDialog();

    public void setData(List<String> data) {
        this.myData = ContainerUtil.newArrayList(data);
        this.updateData();
        if (!this.myData.isEmpty()) {
            this.myList.setSelectedIndex(0);
        }
    }

    protected void updateData() {
        DefaultListModel model = (DefaultListModel)this.myList.getModel();
        model.clear();
        for (String data : this.myData) {
            model.addElement(data);
        }
    }

    @Nullable
    public List<String> getData() {
        return this.myData;
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myList;
    }

    @NotNull
    public static String createStringPresentation(@Nullable List<String> data) {
        String string = data == null ? "" : StringUtil.join(data, (String)",");
        if (string == null) {
            ListItemsDialogWrapper.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public static List<String> createListPresentation(@Nullable String data) {
        if (data == null || data.trim().isEmpty()) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                ListItemsDialogWrapper.$$$reportNull$$$0(1);
            }
            return list2;
        }
        ArrayList arrayList = ContainerUtil.newArrayList((Object[])data.split(","));
        if (arrayList == null) {
            ListItemsDialogWrapper.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    public static void installListItemsDialogForTextField(final @NotNull TextFieldWithBrowseButton uiField, final @NotNull Producer<ListItemsDialogWrapper> createDialog) {
        if (uiField == null) {
            ListItemsDialogWrapper.$$$reportNull$$$0(3);
        }
        if (createDialog == null) {
            ListItemsDialogWrapper.$$$reportNull$$$0(4);
        }
        uiField.getTextField().setEditable(false);
        uiField.setButtonIcon(PlatformIcons.OPEN_EDIT_DIALOG_ICON);
        uiField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListItemsDialogWrapper tagListDialog = (ListItemsDialogWrapper)((Object)createDialog.produce());
                tagListDialog.setData(ListItemsDialogWrapper.createListPresentation(uiField.getText()));
                if (tagListDialog.showAndGet()) {
                    uiField.setText(ListItemsDialogWrapper.createStringPresentation(tagListDialog.getData()));
                }
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/ListItemsDialogWrapper";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiField";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createStringPresentation";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createListPresentation";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/ListItemsDialogWrapper";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "installListItemsDialogForTextField";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

