/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.template.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.DocumentBasedFormattingModel;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.FormattingDocumentModelImpl;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.formatter.xml.AnotherLanguageBlockWrapper;
import com.intellij.psi.formatter.xml.HtmlPolicy;
import com.intellij.psi.formatter.xml.ReadOnlyBlock;
import com.intellij.psi.formatter.xml.SyntheticBlock;
import com.intellij.psi.formatter.xml.XmlBlock;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.formatter.xml.XmlTagBlock;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.templateLanguages.SimpleTemplateLanguageFormattingModelBuilder;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.template.formatter.CompositeTemplateBlock;
import com.intellij.xml.template.formatter.FragmentedTemplateException;
import com.intellij.xml.template.formatter.TemplateFormatUtil;
import com.intellij.xml.template.formatter.TemplateSyntheticBlock;
import com.intellij.xml.template.formatter.TemplateXmlBlock;
import com.intellij.xml.template.formatter.TemplateXmlTagBlock;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractXmlTemplateFormattingModelBuilder
extends SimpleTemplateLanguageFormattingModelBuilder {
    @Override
    @NotNull
    public FormattingModel createModel(PsiElement element, CodeStyleSettings settings) {
        block11: {
            PsiFile psiFile = element.getContainingFile();
            if (psiFile.getViewProvider() instanceof TemplateLanguageFileViewProvider) {
                TemplateLanguageFileViewProvider viewProvider = (TemplateLanguageFileViewProvider)psiFile.getViewProvider();
                if (this.isTemplateFile(psiFile)) {
                    Language templateDataLanguage = viewProvider.getTemplateDataLanguage();
                    if (templateDataLanguage != psiFile.getLanguage()) {
                        FormattingModel formattingModel = this.createDataLanguageFormattingModel((PsiElement)viewProvider.getPsi(templateDataLanguage), templateDataLanguage, settings, psiFile, Indent.getNoneIndent());
                        if (formattingModel == null) {
                            AbstractXmlTemplateFormattingModelBuilder.$$$reportNull$$$0(0);
                        }
                        return formattingModel;
                    }
                } else if (element instanceof OuterLanguageElement && this.isOuterLanguageElement(element)) {
                    FormattingModel formattingModel;
                    try {
                        FormattingModel model = this.createTemplateFormattingModel(psiFile, viewProvider, (OuterLanguageElement)element, settings, Indent.getNoneIndent());
                        if (model == null) break block11;
                        formattingModel = model;
                    }
                    catch (FragmentedTemplateException ie) {
                        DocumentBasedFormattingModel documentBasedFormattingModel = this.createDummyModel((Block)new ReadOnlyBlock(element.getNode()), settings, psiFile);
                        if (documentBasedFormattingModel == null) {
                            AbstractXmlTemplateFormattingModelBuilder.$$$reportNull$$$0(2);
                        }
                        return documentBasedFormattingModel;
                    }
                    if (formattingModel == null) {
                        AbstractXmlTemplateFormattingModelBuilder.$$$reportNull$$$0(1);
                    }
                    return formattingModel;
                }
            }
        }
        FormattingModel formattingModel = super.createModel(element, settings);
        if (formattingModel == null) {
            AbstractXmlTemplateFormattingModelBuilder.$$$reportNull$$$0(3);
        }
        return formattingModel;
    }

    @NotNull
    protected DocumentBasedFormattingModel createDummyModel(Block rootBlock, CodeStyleSettings settings, PsiFile psiFile) {
        DocumentBasedFormattingModel documentBasedFormattingModel = new DocumentBasedFormattingModel(rootBlock, psiFile.getProject(), settings, psiFile.getFileType(), psiFile);
        if (documentBasedFormattingModel == null) {
            AbstractXmlTemplateFormattingModelBuilder.$$$reportNull$$$0(4);
        }
        return documentBasedFormattingModel;
    }

    @Nullable
    FormattingModel createTemplateFormattingModel(@NotNull PsiFile psiFile, @NotNull TemplateLanguageFileViewProvider viewProvider, @NotNull OuterLanguageElement outerTemplateElement, @NotNull CodeStyleSettings settings, @Nullable Indent indent) throws FragmentedTemplateException {
        if (psiFile == null) {
            AbstractXmlTemplateFormattingModelBuilder.$$$reportNull$$$0(5);
        }
        if (viewProvider == null) {
            AbstractXmlTemplateFormattingModelBuilder.$$$reportNull$$$0(6);
        }
        if (outerTemplateElement == null) {
            AbstractXmlTemplateFormattingModelBuilder.$$$reportNull$$$0(7);
        }
        if (settings == null) {
            AbstractXmlTemplateFormattingModelBuilder.$$$reportNull$$$0(8);
        }
        List<PsiElement> templateElements = TemplateFormatUtil.findAllTemplateLanguageElementsInside((PsiElement)outerTemplateElement, viewProvider);
        return this.createTemplateFormattingModelInternal(psiFile, settings, AbstractXmlTemplateFormattingModelBuilder.getPolicy(settings, psiFile), templateElements, indent);
    }

    public FormattingModel createTemplateFormattingModel(PsiFile file2, CodeStyleSettings settings, XmlFormattingPolicy xmlFormattingPolicy, List<PsiElement> elements, Indent indent) {
        try {
            return this.createTemplateFormattingModelInternal(file2, settings, xmlFormattingPolicy, elements, indent);
        }
        catch (FragmentedTemplateException fte) {
            assert (elements.size() > 0);
            int start = Integer.MAX_VALUE;
            int end = -1;
            for (PsiElement element : elements) {
                TextRange range = element.getTextRange();
                if (range.getStartOffset() < start) {
                    start = range.getStartOffset();
                }
                if (range.getEndOffset() <= end) continue;
                end = range.getEndOffset();
            }
            return this.createDummyModel(new CompositeTemplateBlock(new TextRange(start, end)), settings, file2);
        }
    }

    @Nullable
    private FormattingModel createTemplateFormattingModelInternal(PsiFile file2, CodeStyleSettings settings, XmlFormattingPolicy xmlFormattingPolicy, List<PsiElement> elements, Indent indent) throws FragmentedTemplateException {
        if (elements.size() == 0) {
            return null;
        }
        ArrayList<Block> templateBlocks = new ArrayList<Block>();
        for (PsiElement element : elements) {
            if (element instanceof PsiErrorElement) {
                throw new FragmentedTemplateException((PsiErrorElement)element);
            }
            if (this.isMarkupLanguageElement(element) || FormatterUtil.containsWhiteSpacesOnly(element.getNode())) continue;
            templateBlocks.add(this.createTemplateLanguageBlock(element.getNode(), settings, xmlFormattingPolicy, indent, null, null));
        }
        if (templateBlocks.size() == 0) {
            return null;
        }
        CompositeTemplateBlock topBlock = templateBlocks.size() == 1 ? (Block)templateBlocks.get(0) : new CompositeTemplateBlock(templateBlocks);
        return new DocumentBasedFormattingModel(topBlock, file2.getProject(), settings, file2.getFileType(), file2);
    }

    protected abstract boolean isTemplateFile(PsiFile var1);

    public abstract boolean isOuterLanguageElement(PsiElement var1);

    public abstract boolean isMarkupLanguageElement(PsiElement var1);

    private FormattingModel createDataLanguageFormattingModel(PsiElement dataElement, Language language, CodeStyleSettings settings, PsiFile psiFile, @Nullable Indent indent) {
        Block block = this.createDataLanguageRootBlock(dataElement, language, settings, AbstractXmlTemplateFormattingModelBuilder.getPolicy(settings, psiFile), psiFile, indent);
        return new DocumentBasedFormattingModel(block, psiFile.getProject(), settings, psiFile.getFileType(), psiFile);
    }

    public Block createDataLanguageRootBlock(PsiElement dataElement, Language language, CodeStyleSettings settings, XmlFormattingPolicy xmlFormattingPolicy, PsiFile psiFile, Indent indent) {
        AbstractBlock block;
        if (dataElement instanceof XmlTag) {
            block = this.createXmlTagBlock(dataElement.getNode(), null, null, xmlFormattingPolicy, indent);
        } else if (language.isKindOf((Language)XMLLanguage.INSTANCE)) {
            block = this.createXmlBlock(dataElement.getNode(), null, Alignment.createAlignment(), xmlFormattingPolicy, indent, dataElement.getTextRange());
        } else {
            FormattingModelBuilder builder = LanguageFormatting.INSTANCE.forContext(language, dataElement);
            if (builder != null && !AbstractXmlTemplateFormattingModelBuilder.isInsideXmlAttributeValue(dataElement)) {
                FormattingModel otherLanguageModel = builder.createModel(dataElement, settings);
                block = otherLanguageModel.getRootBlock();
            } else {
                block = new ReadOnlyBlock(dataElement.getNode());
            }
        }
        return block;
    }

    protected abstract Block createTemplateLanguageBlock(ASTNode var1, CodeStyleSettings var2, XmlFormattingPolicy var3, Indent var4, @Nullable Alignment var5, @Nullable Wrap var6);

    protected XmlTagBlock createXmlTagBlock(ASTNode node, @Nullable Wrap wrap, @Nullable Alignment alignment, XmlFormattingPolicy policy, @Nullable Indent indent) {
        return new TemplateXmlTagBlock(this, node, wrap, alignment, policy, indent);
    }

    protected XmlBlock createXmlBlock(ASTNode node, @Nullable Wrap wrap, @Nullable Alignment alignment, XmlFormattingPolicy policy, @Nullable Indent indent, @Nullable TextRange textRange) {
        return new TemplateXmlBlock(this, node, wrap, alignment, policy, indent, textRange);
    }

    protected SyntheticBlock createSyntheticBlock(List<Block> subBlocks, Block parent, Indent indent, XmlFormattingPolicy policy, Indent childIndent) {
        return new TemplateSyntheticBlock(subBlocks, parent, indent, policy, childIndent);
    }

    public List<Block> mergeWithTemplateBlocks(List<Block> markupBlocks, CodeStyleSettings settings, XmlFormattingPolicy xmlFormattingPolicy, Indent childrenIndent) throws FragmentedTemplateException {
        int templateLangRangeStart = Integer.MAX_VALUE;
        int templateLangRangeEnd = -1;
        int rangeStart = Integer.MAX_VALUE;
        int rangeEnd = -1;
        PsiFile templateFile = null;
        ArrayList<Block> pureMarkupBlocks = new ArrayList<Block>();
        for (Block block : markupBlocks) {
            AnotherLanguageBlockWrapper wrapper2;
            PsiElement otherLangElement;
            TextRange currRange = block.getTextRange();
            rangeStart = Math.min(currRange.getStartOffset(), rangeStart);
            rangeEnd = Math.max(currRange.getEndOffset(), rangeEnd);
            boolean isMarkupBlock = true;
            if (block instanceof AnotherLanguageBlockWrapper && this.isOuterLanguageElement(otherLangElement = (wrapper2 = (AnotherLanguageBlockWrapper)block).getNode().getPsi())) {
                isMarkupBlock = false;
                if (templateFile == null) {
                    FileViewProvider provider = otherLangElement.getContainingFile().getViewProvider();
                    templateFile = provider.getPsi(provider.getBaseLanguage());
                }
                templateLangRangeStart = Math.min(currRange.getStartOffset(), templateLangRangeStart);
                templateLangRangeEnd = Math.max(currRange.getEndOffset(), templateLangRangeEnd);
            }
            if (!isMarkupBlock) continue;
            pureMarkupBlocks.add(block);
        }
        if (templateLangRangeEnd > templateLangRangeStart && templateFile != null) {
            List<Block> templateBlocks = this.buildTemplateLanguageBlocksInside(templateFile, new TextRange(templateLangRangeStart, templateLangRangeEnd), settings, xmlFormattingPolicy, childrenIndent);
            if (pureMarkupBlocks.isEmpty()) {
                return this.afterMerge(templateBlocks, true, settings, xmlFormattingPolicy);
            }
            return this.afterMerge(TemplateFormatUtil.mergeBlocks(pureMarkupBlocks, templateBlocks, new TextRange(rangeStart, rangeEnd)), false, settings, xmlFormattingPolicy);
        }
        return markupBlocks;
    }

    private List<Block> buildTemplateLanguageBlocksInside(@NotNull PsiFile templateFile, @NotNull TextRange range, CodeStyleSettings settings, XmlFormattingPolicy xmlFormattingPolicy, Indent childrenIndent) throws FragmentedTemplateException {
        if (templateFile == null) {
            AbstractXmlTemplateFormattingModelBuilder.$$$reportNull$$$0(9);
        }
        if (range == null) {
            AbstractXmlTemplateFormattingModelBuilder.$$$reportNull$$$0(10);
        }
        ArrayList<Block> templateBlocks = new ArrayList<Block>();
        TemplateLanguageFileViewProvider viewProvider = (TemplateLanguageFileViewProvider)templateFile.getViewProvider();
        List<PsiElement> templateElements = TemplateFormatUtil.findAllElementsInside(range, viewProvider, true);
        FormattingModel localModel = this.createTemplateFormattingModelInternal(templateFile, settings, xmlFormattingPolicy, templateElements, childrenIndent);
        if (localModel != null) {
            Block rootBlock = localModel.getRootBlock();
            if (rootBlock instanceof CompositeTemplateBlock) {
                templateBlocks.addAll(rootBlock.getSubBlocks());
            } else {
                templateBlocks.add(rootBlock);
            }
        }
        return templateBlocks;
    }

    protected List<Block> afterMerge(List<Block> originalBlocks, boolean templateOnly, CodeStyleSettings settings, @NotNull XmlFormattingPolicy xmlFormattingPolicy) {
        if (xmlFormattingPolicy == null) {
            AbstractXmlTemplateFormattingModelBuilder.$$$reportNull$$$0(11);
        }
        return originalBlocks;
    }

    protected static XmlFormattingPolicy getPolicy(CodeStyleSettings settings, PsiFile psiFile) {
        FormattingDocumentModelImpl documentModel = FormattingDocumentModelImpl.createOn(psiFile);
        return new HtmlPolicy(settings, documentModel);
    }

    private static boolean isInsideXmlAttributeValue(PsiElement element) {
        XmlAttributeValue value = (XmlAttributeValue)PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttributeValue.class, (boolean)true);
        return value != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xml/template/formatter/AbstractXmlTemplateFormattingModelBuilder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outerTemplateElement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateFile";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlFormattingPolicy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createDummyModel";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xml/template/formatter/AbstractXmlTemplateFormattingModelBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createTemplateFormattingModel";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildTemplateLanguageBlocksInside";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "afterMerge";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

