/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.stdlib;

import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.codeInsight.PyCustomMember;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.PyClassMembersProviderBase;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyFunctionType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyStdlibClassMembersProvider
extends PyClassMembersProviderBase {
    @NotNull
    private static final Key<List<PyCustomMember>> SOCKET_MEMBERS_KEY = Key.create((String)"socket.members");
    @NotNull
    public static final List<PyCustomMember> MOCK_PATCH_MEMBERS = PyStdlibClassMembersProvider.calcMockPatchMembers();

    @Override
    @NotNull
    public Collection<PyCustomMember> getMembers(PyClassType classType, PsiElement location, @NotNull TypeEvalContext context) {
        PyExpression qualifier;
        PyClass clazz;
        String qualifiedName;
        if (context == null) {
            PyStdlibClassMembersProvider.$$$reportNull$$$0(0);
        }
        if ("socket._socketobject".equals(qualifiedName = (clazz = classType.getPyClass()).getQualifiedName())) {
            PyFile socketFile = (PyFile)clazz.getContainingFile();
            List<PyCustomMember> socketMembers = (List<PyCustomMember>)socketFile.getUserData(SOCKET_MEMBERS_KEY);
            if (socketMembers == null) {
                socketMembers = PyStdlibClassMembersProvider.calcSocketMembers(socketFile);
                socketFile.putUserData(SOCKET_MEMBERS_KEY, socketMembers);
            }
            List<PyCustomMember> list2 = socketMembers;
            if (list2 == null) {
                PyStdlibClassMembersProvider.$$$reportNull$$$0(1);
            }
            return list2;
        }
        if (location instanceof PyReferenceExpression && (qualifier = ((PyReferenceExpression)location).getQualifier()) instanceof PyReferenceExpression && PyStdlibClassMembersProvider.referenceToMockPatch((PyReferenceExpression)qualifier, context)) {
            List<PyCustomMember> list3 = MOCK_PATCH_MEMBERS;
            if (list3 == null) {
                PyStdlibClassMembersProvider.$$$reportNull$$$0(2);
            }
            return list3;
        }
        List<PyCustomMember> list4 = Collections.emptyList();
        if (list4 == null) {
            PyStdlibClassMembersProvider.$$$reportNull$$$0(3);
        }
        return list4;
    }

    @Override
    @Nullable
    public PsiElement resolveMember(@NotNull PyClassType type, @NotNull String name, @Nullable PsiElement location, @NotNull PyResolveContext resolveContext) {
        if (type == null) {
            PyStdlibClassMembersProvider.$$$reportNull$$$0(4);
        }
        if (name == null) {
            PyStdlibClassMembersProvider.$$$reportNull$$$0(5);
        }
        if (resolveContext == null) {
            PyStdlibClassMembersProvider.$$$reportNull$$$0(6);
        }
        TypeEvalContext context = resolveContext.getTypeEvalContext();
        if (location instanceof PyReferenceExpression && PyStdlibClassMembersProvider.referenceToMockPatch((PyReferenceExpression)location, context)) {
            for (PyCustomMember member : MOCK_PATCH_MEMBERS) {
                if (!name.equals(member.getName())) continue;
                return member.resolve(location, resolveContext);
            }
        }
        return super.resolveMember(type, name, location, resolveContext);
    }

    public static boolean referenceToMockPatch(@NotNull PyReferenceExpression referenceExpression, @NotNull TypeEvalContext context) {
        PyType type;
        if (referenceExpression == null) {
            PyStdlibClassMembersProvider.$$$reportNull$$$0(7);
        }
        if (context == null) {
            PyStdlibClassMembersProvider.$$$reportNull$$$0(8);
        }
        if ((type = context.getType(referenceExpression)) instanceof PyFunctionType) {
            return "unittest.mock.patch".equals(((PyFunctionType)type).getCallable().getQualifiedName());
        }
        return false;
    }

    private static List<PyCustomMember> calcSocketMembers(PyFile socketFile) {
        ArrayList<PyCustomMember> result2 = new ArrayList<PyCustomMember>();
        PyStdlibClassMembersProvider.addMethodsFromAttr(socketFile, result2, "_socketmethods");
        PyStdlibClassMembersProvider.addMethodsFromAttr(socketFile, result2, "_delegate_methods");
        return result2;
    }

    @NotNull
    private static List<PyCustomMember> calcMockPatchMembers() {
        Object[] members = new String[]{"object", "dict", "multiple", "stopall", "TEST_PREFIX"};
        String moduleQName = "unittest.mock";
        List list2 = ContainerUtil.map((Object[])members, member -> new PyCustomMember((String)member).resolvesTo("unittest.mock").toAssignment("patch." + member));
        if (list2 == null) {
            PyStdlibClassMembersProvider.$$$reportNull$$$0(9);
        }
        return list2;
    }

    private static void addMethodsFromAttr(PyFile socketFile, List<PyCustomMember> result2, String attrName) {
        List<String> methods;
        PyTargetExpression socketMethods = socketFile.findTopLevelAttribute(attrName);
        if (socketMethods != null && (methods = PyUtil.getStringListFromTargetExpression(socketMethods)) != null) {
            for (String name : methods) {
                result2.add(new PyCustomMember(name).resolvesTo("_socket").toClass("SocketType").toFunction(name));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/stdlib/PyStdlibClassMembersProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/stdlib/PyStdlibClassMembersProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMembers";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "calcMockPatchMembers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMembers";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveMember";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "referenceToMockPatch";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

