/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation;

import com.google.common.collect.Sets;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.ui.AddEditRemovePanel;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PlatformUtils;
import com.jetbrains.python.documentation.PythonDocumentationEntryEditor;
import com.jetbrains.python.documentation.PythonDocumentationMap;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonDocumentationConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    public static final String ID = "com.jetbrains.python.documentation.PythonDocumentationConfigurable";
    private PythonDocumentationPanel myPanel = new PythonDocumentationPanel();
    private static final PythonDocumentationTableModel ourModel = new PythonDocumentationTableModel();

    @NotNull
    public String getId() {
        if (ID == null) {
            PythonDocumentationConfigurable.$$$reportNull$$$0(0);
        }
        return ID;
    }

    @Nls
    public String getDisplayName() {
        return PlatformUtils.isPyCharm() ? "External Documentation" : "Python External Documentation";
    }

    public String getHelpTopic() {
        return "preferences.ExternalDocumentation";
    }

    public JComponent createComponent() {
        return this.myPanel;
    }

    public void reset() {
        this.myPanel.getData().clear();
        this.myPanel.getData().addAll(PythonDocumentationMap.getInstance().getEntries());
    }

    public boolean isModified() {
        HashSet originalEntries = Sets.newHashSet(PythonDocumentationMap.getInstance().getEntries());
        HashSet editedEntries = Sets.newHashSet((Iterable)this.myPanel.getData());
        return !editedEntries.equals(originalEntries);
    }

    public void apply() throws ConfigurationException {
        PythonDocumentationMap.getInstance().setEntries(this.myPanel.getData());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/documentation/PythonDocumentationConfigurable", "getId"));
    }

    private static class PythonDocumentationPanel
    extends AddEditRemovePanel<PythonDocumentationMap.Entry> {
        public PythonDocumentationPanel() {
            super((AddEditRemovePanel.TableModel)ourModel, new ArrayList());
            this.setRenderer(1, (TableCellRenderer)new ColoredTableCellRenderer(){

                protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                    String text = value == null ? "" : (String)value;
                    int pos = 0;
                    while (pos < text.length()) {
                        int openBrace = text.indexOf(123, pos);
                        if (openBrace == -1) {
                            openBrace = text.length();
                        }
                        this.append(text.substring(pos, openBrace));
                        int closeBrace = text.indexOf(125, openBrace);
                        closeBrace = closeBrace == -1 ? text.length() : ++closeBrace;
                        this.append(text.substring(openBrace, closeBrace), new SimpleTextAttributes(1, JBColor.BLUE.darker()));
                        pos = closeBrace;
                    }
                }
            });
        }

        protected PythonDocumentationMap.Entry addItem() {
            return this.showEditor(null);
        }

        @Nullable
        private PythonDocumentationMap.Entry showEditor(PythonDocumentationMap.Entry entry) {
            PythonDocumentationEntryEditor editor = new PythonDocumentationEntryEditor((Component)((Object)this));
            if (entry != null) {
                editor.setEntry(entry);
            }
            editor.show();
            if (editor.getExitCode() != 0) {
                return null;
            }
            return editor.getEntry();
        }

        protected boolean removeItem(PythonDocumentationMap.Entry o) {
            return true;
        }

        protected PythonDocumentationMap.Entry editItem(PythonDocumentationMap.Entry o) {
            return this.showEditor(o);
        }
    }

    private static class PythonDocumentationTableModel
    extends AddEditRemovePanel.TableModel<PythonDocumentationMap.Entry> {
        private PythonDocumentationTableModel() {
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int columnIndex) {
            return columnIndex == 0 ? "Module Name" : "URL/Path Pattern";
        }

        public Object getField(PythonDocumentationMap.Entry o, int columnIndex) {
            return columnIndex == 0 ? o.getPrefix() : o.getUrlPattern();
        }
    }
}

