/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.editor;

import com.intellij.codeInsight.editorActions.JoinRawLinesHandlerDelegate;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyUtil;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyJoinLinesHandler
implements JoinRawLinesHandlerDelegate {
    private static final Joiner[] JOINERS = new Joiner[]{new OpenBracketJoiner(), new CloseBracketJoiner(), new StringLiteralJoiner(), new StmtJoiner(), new BinaryExprJoiner(), new CommentJoiner(), new StripBackslashJoiner()};

    public int tryJoinLines(Document document, PsiFile file2, int start, int end) {
        return -1;
    }

    public int tryJoinRawLines(@NotNull Document document, PsiFile file2, int start, int end) {
        if (document == null) {
            PyJoinLinesHandler.$$$reportNull$$$0(0);
        }
        if (!(file2 instanceof PyFile)) {
            return -1;
        }
        CharSequence text = document.getCharsSequence();
        if (start >= 0 && text.charAt(start) == '\n') {
            --start;
        }
        if (start >= 0 && text.charAt(start) == '\\') {
            --start;
        }
        while (start >= 0 && text.charAt(start) == ' ' || text.charAt(start) == '\t') {
            --start;
        }
        if (start < 0) {
            return -1;
        }
        PsiElement leftElement = file2.findElementAt(start);
        PsiElement rightElement = file2.findElementAt(end);
        if (leftElement != null && rightElement != null) {
            PyExpression leftExpr = (PyExpression)PsiTreeUtil.getParentOfType((PsiElement)leftElement, PyExpression.class);
            PyExpression rightExpr = (PyExpression)PsiTreeUtil.getParentOfType((PsiElement)rightElement, PyExpression.class);
            Request request = new Request(document, start, end, leftElement, leftExpr, rightElement, rightExpr);
            for (Joiner joiner : JOINERS) {
                Result res = joiner.join(request);
                if (res == null) continue;
                int cutStart = start + 1 - res.cutFromLeft;
                document.replaceString(cutStart, end + res.cutIntoRight, (CharSequence)res.replacement);
                return cutStart + res.caretOffset;
            }
        }
        return -1;
    }

    private static String findReplacement(String text, int maxLength) {
        String word;
        if (text.length() < maxLength) {
            return "";
        }
        List words = StringUtil.split((String)text, (String)" ");
        StringBuilder builder = new StringBuilder();
        boolean delimiterLength = true;
        int wordsLength = 0;
        Iterator iterator = words.iterator();
        while (iterator.hasNext() && (wordsLength += (word = (String)iterator.next()).length() + 1) < maxLength) {
            builder.append(word);
            builder.append(" ");
        }
        return builder.toString();
    }

    private static int getStringToJoinMaxLength(Request request, int symbolsToSkip) {
        int leftLineStartOffset = PyJoinLinesHandler.getLeftLineStartOffset(request);
        int margin = CodeStyleSettingsManager.getInstance().getCurrentSettings().getRightMargin((Language)PythonLanguage.getInstance());
        int leftLineLength = request.document.getLineEndOffset(request.document.getLineNumber(leftLineStartOffset)) - leftLineStartOffset;
        return margin - leftLineLength - symbolsToSkip;
    }

    private static int getLeftLineStartOffset(@NotNull Request req) {
        if (req == null) {
            PyJoinLinesHandler.$$$reportNull$$$0(1);
        }
        int lineNumber = req.document.getLineNumber(req.firstLineEndOffset);
        return req.document.getLineStartOffset(lineNumber);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "req";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/editor/PyJoinLinesHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "tryJoinRawLines";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getLeftLineStartOffset";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class StripBackslashJoiner
    implements Joiner {
        static final TokenSet SINGLE_QUOTED_STRINGS = TokenSet.create((IElementType[])new IElementType[]{PyTokenTypes.SINGLE_QUOTED_STRING, PyTokenTypes.SINGLE_QUOTED_UNICODE});

        private StripBackslashJoiner() {
        }

        @Override
        @Nullable
        public Result join(@NotNull Request req) {
            String gap;
            int index;
            if (req == null) {
                StripBackslashJoiner.$$$reportNull$$$0(0);
            }
            if ((index = (gap = req.document.getText(new TextRange(req.firstLineEndOffset + 1, req.secondLineStartOffset))).indexOf(92)) >= 0) {
                if (req.leftElem == req.rightElem && SINGLE_QUOTED_STRINGS.contains(req.leftElem.getNode().getElementType())) {
                    return new Result(gap.replaceFirst("\\\\\\n", ""), 0);
                }
                return new Result(gap.substring(0, index), 0);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "req", "com/jetbrains/python/editor/PyJoinLinesHandler$StripBackslashJoiner", "join"));
        }
    }

    private static class CommentJoiner
    implements Joiner {
        private CommentJoiner() {
        }

        @Override
        public Result join(@NotNull Request req) {
            if (req == null) {
                CommentJoiner.$$$reportNull$$$0(0);
            }
            if (req.leftElem instanceof PsiComment && req.rightElem instanceof PsiComment) {
                int initialPos;
                int pos;
                CharSequence text = req.document.getCharsSequence();
                TextRange rightRange = req.rightElem.getTextRange();
                int last = rightRange.getEndOffset();
                for (pos = initialPos = rightRange.getStartOffset() + 1; pos < last && " \t".indexOf(text.charAt(pos)) >= 0; ++pos) {
                }
                int right = pos - initialPos + 1;
                String substring = req.rightElem.getText().substring(right);
                String replacement = " " + PyJoinLinesHandler.findReplacement(substring, PyJoinLinesHandler.getStringToJoinMaxLength(req, 0));
                right += replacement.length() - 1;
                if (!replacement.trim().isEmpty()) {
                    replacement = replacement + "\n";
                    req.document.insertString(req.secondLineStartOffset + right, (CharSequence)"# ");
                }
                return new Result(replacement, 0, 0, right);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "req", "com/jetbrains/python/editor/PyJoinLinesHandler$CommentJoiner", "join"));
        }
    }

    private static class StringLiteralJoiner
    implements Joiner {
        private StringLiteralJoiner() {
        }

        @Override
        public Result join(@NotNull Request req) {
            if (req == null) {
                StringLiteralJoiner.$$$reportNull$$$0(0);
            }
            if (req.leftElem != req.rightElem) {
                PsiElement parent = req.rightElem.getParent();
                if (req.leftElem.getParent() == parent && parent instanceof PyStringLiteralExpression || req.leftExpr instanceof PyStringLiteralExpression && req.rightExpr instanceof PyStringLiteralExpression) {
                    PyUtil.StringNodeInfo leftNodeInfo = new PyUtil.StringNodeInfo(req.leftElem);
                    PyUtil.StringNodeInfo rightNodeInfo = new PyUtil.StringNodeInfo(req.rightElem);
                    if (leftNodeInfo.isTerminated() && rightNodeInfo.isTerminated()) {
                        int quotesMaxLength = Math.max(leftNodeInfo.getQuote().length(), rightNodeInfo.getQuote().length());
                        int stringToJoinMaxLength = PyJoinLinesHandler.getStringToJoinMaxLength(req, quotesMaxLength);
                        String replacement = PyJoinLinesHandler.findReplacement(rightNodeInfo.getContent(), stringToJoinMaxLength);
                        if (leftNodeInfo.equals(rightNodeInfo)) {
                            return StringLiteralJoiner.getResultAndSplitStringIfTooLong(req, leftNodeInfo, rightNodeInfo, replacement, leftNodeInfo.getQuote());
                        }
                        return StringLiteralJoiner.processStringsWithDifferentQuotes(req, leftNodeInfo, rightNodeInfo, replacement);
                    }
                }
            }
            return null;
        }

        @Nullable
        private static Result processStringsWithDifferentQuotes(@NotNull Request req, @NotNull PyUtil.StringNodeInfo leftNodeInfo, @NotNull PyUtil.StringNodeInfo rightNodeInfo, @NotNull String replacement) {
            if (req == null) {
                StringLiteralJoiner.$$$reportNull$$$0(1);
            }
            if (leftNodeInfo == null) {
                StringLiteralJoiner.$$$reportNull$$$0(2);
            }
            if (rightNodeInfo == null) {
                StringLiteralJoiner.$$$reportNull$$$0(3);
            }
            if (replacement == null) {
                StringLiteralJoiner.$$$reportNull$$$0(4);
            }
            if (StringLiteralJoiner.haveSamePrefixes(leftNodeInfo, rightNodeInfo) && !leftNodeInfo.isTripleQuoted() && !rightNodeInfo.isTripleQuoted()) {
                if (!rightNodeInfo.getContent().contains(leftNodeInfo.getQuote())) {
                    int quotePos = rightNodeInfo.getAbsoluteContentRange().getEndOffset();
                    String quote = leftNodeInfo.getQuote();
                    req.document.replaceString(quotePos, quotePos + 1, (CharSequence)quote);
                    return StringLiteralJoiner.getResultAndSplitStringIfTooLong(req, leftNodeInfo, rightNodeInfo, replacement, quote);
                }
                if (!leftNodeInfo.getContent().contains(rightNodeInfo.getQuote())) {
                    int quotePos = leftNodeInfo.getAbsoluteContentRange().getStartOffset() - 1;
                    String quote = rightNodeInfo.getQuote();
                    req.document.replaceString(quotePos, quotePos + 1, (CharSequence)quote);
                    return StringLiteralJoiner.getResultAndSplitStringIfTooLong(req, leftNodeInfo, rightNodeInfo, replacement, quote);
                }
            }
            return null;
        }

        @NotNull
        private static Result getResultAndSplitStringIfTooLong(@NotNull Request req, @NotNull PyUtil.StringNodeInfo leftNodeInfo, @NotNull PyUtil.StringNodeInfo rightNodeInfo, @NotNull String replacement, @NotNull String quote) {
            if (req == null) {
                StringLiteralJoiner.$$$reportNull$$$0(5);
            }
            if (leftNodeInfo == null) {
                StringLiteralJoiner.$$$reportNull$$$0(6);
            }
            if (rightNodeInfo == null) {
                StringLiteralJoiner.$$$reportNull$$$0(7);
            }
            if (replacement == null) {
                StringLiteralJoiner.$$$reportNull$$$0(8);
            }
            if (quote == null) {
                StringLiteralJoiner.$$$reportNull$$$0(9);
            }
            int cutIntoRight = rightNodeInfo.getContentRange().getStartOffset();
            String lineEnd = "";
            if (!replacement.isEmpty()) {
                cutIntoRight = replacement.length() + rightNodeInfo.getQuote().length();
                int contentWithQuoteStartColumn = leftNodeInfo.getAbsoluteContentRange().getStartOffset() - PyJoinLinesHandler.getLeftLineStartOffset(req) - leftNodeInfo.getQuote().length();
                int quotePos = rightNodeInfo.getAbsoluteContentRange().getStartOffset() + replacement.length();
                req.document.insertString(quotePos, (CharSequence)rightNodeInfo.getQuote());
                req.document.insertString(quotePos, (CharSequence)StringUtil.repeat((String)" ", (int)contentWithQuoteStartColumn));
                lineEnd = quote + "\\\n";
            }
            Result result2 = new Result(replacement + lineEnd, 0, leftNodeInfo.getQuote().length(), cutIntoRight);
            if (result2 == null) {
                StringLiteralJoiner.$$$reportNull$$$0(10);
            }
            return result2;
        }

        private static boolean haveSamePrefixes(@NotNull PyUtil.StringNodeInfo leftNodeInfo, @NotNull PyUtil.StringNodeInfo rightNodeInfo) {
            if (leftNodeInfo == null) {
                StringLiteralJoiner.$$$reportNull$$$0(11);
            }
            if (rightNodeInfo == null) {
                StringLiteralJoiner.$$$reportNull$$$0(12);
            }
            return leftNodeInfo.isUnicode() == rightNodeInfo.isUnicode() && leftNodeInfo.isRaw() == rightNodeInfo.isRaw() && leftNodeInfo.isBytes() == rightNodeInfo.isBytes();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "req";
                    break;
                }
                case 2: 
                case 6: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "leftNodeInfo";
                    break;
                }
                case 3: 
                case 7: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rightNodeInfo";
                    break;
                }
                case 4: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "replacement";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "quote";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/editor/PyJoinLinesHandler$StringLiteralJoiner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/editor/PyJoinLinesHandler$StringLiteralJoiner";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResultAndSplitStringIfTooLong";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "join";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "processStringsWithDifferentQuotes";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getResultAndSplitStringIfTooLong";
                    break;
                }
                case 10: {
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "haveSamePrefixes";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class StmtJoiner
    implements Joiner {
        private StmtJoiner() {
        }

        @Override
        public Result join(@NotNull Request req) {
            PyStatement rightStmt;
            PyStatement leftStmt;
            if (req == null) {
                StmtJoiner.$$$reportNull$$$0(0);
            }
            if ((leftStmt = (PyStatement)PsiTreeUtil.getParentOfType((PsiElement)req.leftExpr, PyStatement.class)) != null && (rightStmt = (PyStatement)PsiTreeUtil.getParentOfType((PsiElement)req.rightExpr, PyStatement.class)) != null && rightStmt != leftStmt) {
                return new Result("; ", 1);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "req", "com/jetbrains/python/editor/PyJoinLinesHandler$StmtJoiner", "join"));
        }
    }

    private static class BinaryExprJoiner
    implements Joiner {
        private BinaryExprJoiner() {
        }

        @Override
        public Result join(@NotNull Request req) {
            if (req == null) {
                BinaryExprJoiner.$$$reportNull$$$0(0);
            }
            if (req.leftExpr instanceof PyBinaryExpression || req.rightExpr instanceof PyBinaryExpression) {
                return new Result(" ", 1);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "req", "com/jetbrains/python/editor/PyJoinLinesHandler$BinaryExprJoiner", "join"));
        }
    }

    private static class CloseBracketJoiner
    implements Joiner {
        private static final TokenSet CLOSES = TokenSet.create((IElementType[])new IElementType[]{PyTokenTypes.RBRACKET, PyTokenTypes.RBRACE, PyTokenTypes.RPAR});

        private CloseBracketJoiner() {
        }

        @Override
        public Result join(@NotNull Request req) {
            if (req == null) {
                CloseBracketJoiner.$$$reportNull$$$0(0);
            }
            if (CLOSES.contains(req.rightElem.getNode().getElementType())) {
                return new Result("", 0);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "req", "com/jetbrains/python/editor/PyJoinLinesHandler$CloseBracketJoiner", "join"));
        }
    }

    private static class OpenBracketJoiner
    implements Joiner {
        private static final TokenSet OPENS = TokenSet.create((IElementType[])new IElementType[]{PyTokenTypes.LBRACKET, PyTokenTypes.LBRACE, PyTokenTypes.LPAR});

        private OpenBracketJoiner() {
        }

        @Override
        public Result join(@NotNull Request req) {
            if (req == null) {
                OpenBracketJoiner.$$$reportNull$$$0(0);
            }
            if (OPENS.contains(req.leftElem.getNode().getElementType())) {
                return new Result("", 0);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "req", "com/jetbrains/python/editor/PyJoinLinesHandler$OpenBracketJoiner", "join"));
        }
    }

    private static interface Joiner {
        @Nullable
        public Result join(@NotNull Request var1);
    }

    private static class Request {
        final Document document;
        final PsiElement leftElem;
        final PsiElement rightElem;
        final PyExpression leftExpr;
        final PyExpression rightExpr;
        final int secondLineStartOffset;
        final int firstLineEndOffset;

        private Request(@NotNull Document document, int firstLineEndOffset, int secondLineStartOffset, @NotNull PsiElement leftElem, @Nullable PyExpression leftExpr, @NotNull PsiElement rightElem, @Nullable PyExpression rightExpr) {
            if (document == null) {
                Request.$$$reportNull$$$0(0);
            }
            if (leftElem == null) {
                Request.$$$reportNull$$$0(1);
            }
            if (rightElem == null) {
                Request.$$$reportNull$$$0(2);
            }
            this.document = document;
            this.firstLineEndOffset = firstLineEndOffset;
            this.secondLineStartOffset = secondLineStartOffset;
            this.leftElem = leftElem;
            this.rightElem = rightElem;
            this.leftExpr = leftExpr;
            this.rightExpr = rightExpr;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "document";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "leftElem";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rightElem";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/editor/PyJoinLinesHandler$Request";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class Result {
        final String replacement;
        final int caretOffset;
        final int cutFromLeft;
        final int cutIntoRight;

        Result(@NotNull String replacement, int cursorOffset) {
            if (replacement == null) {
                Result.$$$reportNull$$$0(0);
            }
            this(replacement, cursorOffset, 0, 0);
        }

        Result(@NotNull String replacement, int cursorOffset, int cutFromLeft, int cutIntoRight) {
            if (replacement == null) {
                Result.$$$reportNull$$$0(1);
            }
            this.cutFromLeft = cutFromLeft;
            this.cutIntoRight = cutIntoRight;
            this.replacement = replacement;
            this.caretOffset = cursorOffset;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "replacement", "com/jetbrains/python/editor/PyJoinLinesHandler$Result", "<init>"));
        }
    }
}

