/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionExtension;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.AddSelfQuickFix;
import com.jetbrains.python.inspections.quickfix.RenameParameterQuickFix;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.ResolveImportUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyMethodParametersInspection
extends PyInspection {
    public String MCS = "mcs";

    @Nullable
    public JComponent createOptionsPanel() {
        ComboBox comboBox = new ComboBox((Object[])new String[]{"mcs", "metacls"});
        comboBox.setSelectedItem((Object)this.MCS);
        comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ComboBox cb = (ComboBox)e.getSource();
                PyMethodParametersInspection.this.MCS = (String)cb.getSelectedItem();
            }
        });
        JPanel option = new JPanel(new BorderLayout());
        option.add((Component)new JLabel("Metaclass method first argument name"), "West");
        option.add((Component)comboBox, "East");
        JPanel root = new JPanel(new BorderLayout());
        root.add((Component)option, "First");
        return root;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.problematic.first.parameter", new Object[0]);
        if (string == null) {
            PyMethodParametersInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WEAK_WARNING;
        if (highlightDisplayLevel == null) {
            PyMethodParametersInspection.$$$reportNull$$$0(1);
        }
        return highlightDisplayLevel;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session2) {
        if (holder == null) {
            PyMethodParametersInspection.$$$reportNull$$$0(2);
        }
        if (session2 == null) {
            PyMethodParametersInspection.$$$reportNull$$$0(3);
        }
        Visitor visitor2 = new Visitor(holder, session2);
        if (visitor2 == null) {
            PyMethodParametersInspection.$$$reportNull$$$0(4);
        }
        return visitor2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyMethodParametersInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyMethodParametersInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class Visitor
    extends PyInspectionVisitor {
        private Ref<PsiElement> myPossibleZopeRef;

        public Visitor(@NotNull ProblemsHolder holder, LocalInspectionToolSession session2) {
            if (session2 == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, session2);
            this.myPossibleZopeRef = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private PsiElement findZopeInterface(PsiElement foothold) {
            PsiElement ret;
            Visitor visitor2 = this;
            synchronized (visitor2) {
                if (this.myPossibleZopeRef == null) {
                    this.myPossibleZopeRef = new Ref();
                    ret = ResolveImportUtil.resolveModuleInRoots(QualifiedName.fromDottedString((String)"zope.interface.Interface"), foothold);
                    this.myPossibleZopeRef.set((Object)ret);
                } else {
                    ret = (PsiElement)this.myPossibleZopeRef.get();
                }
            }
            return ret;
        }

        @Override
        public void visitPyFunction(PyFunction node) {
            for (PyInspectionExtension extension : (PyInspectionExtension[])Extensions.getExtensions(PyInspectionExtension.EP_NAME)) {
                if (!extension.ignoreMethodParameters(node)) continue;
                return;
            }
            PsiElement zope_interface = this.findZopeInterface(node);
            PyClass cls = node.getContainingClass();
            if (zope_interface instanceof PyClass && cls != null && cls.isSubclass((PyClass)zope_interface, this.myTypeEvalContext)) {
                return;
            }
            PyUtil.MethodFlags flags = PyUtil.MethodFlags.of(node);
            if (flags != null) {
                PyParameterList plist = node.getParameterList();
                PyParameter[] params = plist.getParameters();
                String methodName = node.getName();
                String CLS = "cls";
                if (params.length == 0) {
                    if (flags.isStaticMethod()) {
                        return;
                    }
                    ASTNode name_node = node.getNameNode();
                    if (name_node != null) {
                        PsiElement open_paren = plist.getFirstChild();
                        PsiElement close_paren = plist.getLastChild();
                        if (open_paren != null && close_paren != null && "(".equals(open_paren.getText()) && ")".equals(close_paren.getText())) {
                            String paramName = flags.isMetaclassMethod() ? (flags.isClassMethod() ? PyMethodParametersInspection.this.MCS : "cls") : (flags.isClassMethod() ? "cls" : "self");
                            this.registerProblem((PsiElement)plist, PyBundle.message("INSP.must.have.first.parameter", paramName), ProblemHighlightType.GENERIC_ERROR, null, new AddSelfQuickFix(paramName));
                        }
                    }
                } else {
                    PyNamedParameter first_param = params[0].getAsNamed();
                    if (first_param != null) {
                        String pname = first_param.getName();
                        if (pname == null) {
                            return;
                        }
                        String[] mangled = new String[]{"eslf", "sself", "elf", "felf", "slef", "seelf", "slf", "sslf", "sefl", "sellf", "sef", "seef"};
                        if (PyUtil.among(pname, mangled)) {
                            this.registerProblem(PyUtil.sure(params[0].getNode()).getPsi(), PyBundle.message("INSP.probably.mistyped.self", new Object[0]), new RenameParameterQuickFix("self"));
                            return;
                        }
                        if (flags.isMetaclassMethod()) {
                            String expectedName;
                            if (flags.isStaticMethod() && !"__new__".equals(methodName)) {
                                return;
                            }
                            String alternativeName = null;
                            if ("__new__".equals(methodName) || flags.isClassMethod()) {
                                expectedName = PyMethodParametersInspection.this.MCS;
                            } else if (flags.isSpecialMetaclassMethod()) {
                                expectedName = "cls";
                            } else {
                                expectedName = "self";
                                alternativeName = "cls";
                            }
                            if (!(expectedName.equals(pname) || alternativeName != null && alternativeName.equals(pname))) {
                                this.registerProblem(PyUtil.sure(params[0].getNode()).getPsi(), PyBundle.message("INSP.usually.named.$0", expectedName), new RenameParameterQuickFix(expectedName));
                            }
                        } else if (flags.isClassMethod() || "__new__".equals(methodName) || "__init_subclass__".equals(methodName) && LanguageLevel.forElement(node).isAtLeast(LanguageLevel.PYTHON36)) {
                            if (!"cls".equals(pname)) {
                                this.registerProblem(PyUtil.sure(params[0].getNode()).getPsi(), PyBundle.message("INSP.usually.named.$0", "cls"), new RenameParameterQuickFix("cls"));
                            }
                        } else if (!(flags.isStaticMethod() || first_param.isPositionalContainer() || "self".equals(pname))) {
                            if (flags.isMetaclassMethod() && "cls".equals(pname)) {
                                return;
                            }
                            this.registerProblem(PyUtil.sure(params[0].getNode()).getPsi(), PyBundle.message("INSP.usually.named.self", new Object[0]), new RenameParameterQuickFix("self"));
                        }
                    } else if (!flags.isStaticMethod()) {
                        this.registerProblem((PsiElement)plist, PyBundle.message("INSP.first.param.must.not.be.tuple", new Object[0]));
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyMethodParametersInspection$Visitor", "<init>"));
        }
    }
}

