/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.documentation.PythonDocumentationProvider;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.PyTypeCheckerInspectionProblemRegistrar;
import com.jetbrains.python.inspections.quickfix.PyMakeFunctionReturnTypeQuickFix;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallSiteExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyComprehensionElement;
import com.jetbrains.python.psi.PyComprehensionForComponent;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyForStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyCallExpressionHelper;
import com.jetbrains.python.psi.types.PyABCUtil;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableType;
import com.jetbrains.python.psi.types.PyGenericType;
import com.jetbrains.python.psi.types.PyNoneType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyUnionType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyTypeCheckerInspection
extends PyInspection {
    private static final Logger LOG = Logger.getInstance((String)PyTypeCheckerInspection.class.getName());
    private static Key<Long> TIME_KEY = Key.create((String)"PyTypeCheckerInspection.StartTime");

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session2) {
        if (holder == null) {
            PyTypeCheckerInspection.$$$reportNull$$$0(0);
        }
        if (session2 == null) {
            PyTypeCheckerInspection.$$$reportNull$$$0(1);
        }
        if (LOG.isDebugEnabled()) {
            session2.putUserData(TIME_KEY, (Object)System.nanoTime());
        }
        Visitor visitor2 = new Visitor(holder, session2);
        if (visitor2 == null) {
            PyTypeCheckerInspection.$$$reportNull$$$0(2);
        }
        return visitor2;
    }

    public void inspectionFinished(@NotNull LocalInspectionToolSession session2, @NotNull ProblemsHolder problemsHolder) {
        Long startTime;
        if (session2 == null) {
            PyTypeCheckerInspection.$$$reportNull$$$0(3);
        }
        if (problemsHolder == null) {
            PyTypeCheckerInspection.$$$reportNull$$$0(4);
        }
        if (LOG.isDebugEnabled() && (startTime = (Long)session2.getUserData(TIME_KEY)) != null) {
            LOG.debug(String.format("[%d] elapsed time: %d ms\n", Thread.currentThread().getId(), (System.nanoTime() - startTime) / 1000000L));
        }
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Type checker" == null) {
            PyTypeCheckerInspection.$$$reportNull$$$0(5);
        }
        return "Type checker";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyTypeCheckerInspection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemsHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyTypeCheckerInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "inspectionFinished";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class AnalyzeArgumentResult {
        @NotNull
        private final PyExpression myArgument;
        @Nullable
        private final PyType myExpectedType;
        @Nullable
        private final PyType myExpectedTypeAfterSubstitution;
        @Nullable
        private final PyType myActualType;
        private final boolean myIsMatched;

        public AnalyzeArgumentResult(@NotNull PyExpression argument, @Nullable PyType expectedType, @Nullable PyType expectedTypeAfterSubstitution, @Nullable PyType actualType, boolean isMatched) {
            if (argument == null) {
                AnalyzeArgumentResult.$$$reportNull$$$0(0);
            }
            this.myArgument = argument;
            this.myExpectedType = expectedType;
            this.myExpectedTypeAfterSubstitution = expectedTypeAfterSubstitution;
            this.myActualType = actualType;
            this.myIsMatched = isMatched;
        }

        @NotNull
        public PyExpression getArgument() {
            PyExpression pyExpression = this.myArgument;
            if (pyExpression == null) {
                AnalyzeArgumentResult.$$$reportNull$$$0(1);
            }
            return pyExpression;
        }

        @Nullable
        public PyType getExpectedType() {
            return this.myExpectedType;
        }

        @Nullable
        public PyType getExpectedTypeAfterSubstitution() {
            return this.myExpectedTypeAfterSubstitution;
        }

        @Nullable
        public PyType getActualType() {
            return this.myActualType;
        }

        public boolean isMatched() {
            return this.myIsMatched;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "argument";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyTypeCheckerInspection$AnalyzeArgumentResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyTypeCheckerInspection$AnalyzeArgumentResult";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getArgument";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class AnalyzeCalleeResults {
        @NotNull
        private final PyCallableType myCallableType;
        @Nullable
        private final PyCallable myCallable;
        @NotNull
        private final List<AnalyzeArgumentResult> myResults;

        public AnalyzeCalleeResults(@NotNull PyCallableType callableType, @Nullable PyCallable callable, @NotNull List<AnalyzeArgumentResult> results) {
            if (callableType == null) {
                AnalyzeCalleeResults.$$$reportNull$$$0(0);
            }
            if (results == null) {
                AnalyzeCalleeResults.$$$reportNull$$$0(1);
            }
            this.myCallableType = callableType;
            this.myCallable = callable;
            this.myResults = results;
        }

        @NotNull
        public PyCallableType getCallableType() {
            PyCallableType pyCallableType = this.myCallableType;
            if (pyCallableType == null) {
                AnalyzeCalleeResults.$$$reportNull$$$0(2);
            }
            return pyCallableType;
        }

        @Nullable
        public PyCallable getCallable() {
            return this.myCallable;
        }

        @NotNull
        public List<AnalyzeArgumentResult> getResults() {
            List<AnalyzeArgumentResult> list2 = this.myResults;
            if (list2 == null) {
                AnalyzeCalleeResults.$$$reportNull$$$0(3);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callableType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "results";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyTypeCheckerInspection$AnalyzeCalleeResults";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyTypeCheckerInspection$AnalyzeCalleeResults";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCallableType";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResults";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Visitor
    extends PyInspectionVisitor {
        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session2) {
            if (session2 == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, session2);
        }

        @Override
        public void visitPyCallExpression(PyCallExpression node) {
            this.checkCallSite(node);
        }

        @Override
        public void visitPyBinaryExpression(PyBinaryExpression node) {
            this.checkCallSite(node);
        }

        @Override
        public void visitPySubscriptionExpression(PySubscriptionExpression node) {
            this.checkCallSite(node);
        }

        @Override
        public void visitPyForStatement(PyForStatement node) {
            this.checkIteratedValue(node.getForPart().getSource(), node.isAsync());
        }

        @Override
        public void visitPyReturnStatement(PyReturnStatement node) {
            ScopeOwner owner = ScopeUtil.getScopeOwner((PsiElement)node);
            if (owner instanceof PyFunction) {
                PyFunction function = (PyFunction)owner;
                PyAnnotation annotation = function.getAnnotation();
                String typeCommentAnnotation = function.getTypeCommentAnnotation();
                if (annotation != null || typeCommentAnnotation != null) {
                    PyExpression returnExpr = node.getExpression();
                    PyNoneType actual = returnExpr != null ? this.myTypeEvalContext.getType(returnExpr) : PyNoneType.INSTANCE;
                    PyType expected = this.getExpectedReturnType(function);
                    if (!PyTypeChecker.match(expected, actual, this.myTypeEvalContext)) {
                        String expectedName = PythonDocumentationProvider.getTypeName(expected, this.myTypeEvalContext);
                        String actualName = PythonDocumentationProvider.getTypeName(actual, this.myTypeEvalContext);
                        PyMakeFunctionReturnTypeQuickFix localQuickFix = new PyMakeFunctionReturnTypeQuickFix(function, actualName, this.myTypeEvalContext);
                        PyMakeFunctionReturnTypeQuickFix globalQuickFix = new PyMakeFunctionReturnTypeQuickFix(function, null, this.myTypeEvalContext);
                        this.registerProblem((PsiElement)(returnExpr != null ? returnExpr : node), String.format("Expected type '%s', got '%s' instead", expectedName, actualName), localQuickFix, globalQuickFix);
                    }
                }
            }
        }

        @Nullable
        private PyType getExpectedReturnType(@NotNull PyFunction function) {
            if (function == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            PyType returnType = this.myTypeEvalContext.getReturnType(function);
            if (function.isAsync() || function.isGenerator()) {
                return (PyType)Ref.deref(PyTypingTypeProvider.coroutineOrGeneratorElementType(returnType));
            }
            return returnType;
        }

        @Override
        public void visitPyFunction(PyFunction node) {
            PyAnnotation annotation = node.getAnnotation();
            String typeCommentAnnotation = node.getTypeCommentAnnotation();
            if (annotation != null || typeCommentAnnotation != null) {
                if (!PyUtil.isEmptyFunction(node)) {
                    ReturnVisitor visitor2 = new ReturnVisitor(node);
                    node.getStatementList().accept(visitor2);
                    if (!visitor2.myHasReturns) {
                        PyType expected = this.getExpectedReturnType(node);
                        String expectedName = PythonDocumentationProvider.getTypeName(expected, this.myTypeEvalContext);
                        if (expected != null && !(expected instanceof PyNoneType)) {
                            this.registerProblem((PsiElement)(annotation != null ? annotation.getValue() : node.getTypeComment()), String.format("Expected to return '%s', got no return", expectedName));
                        }
                    }
                }
                if (PyUtil.isInit(node) && !(this.getExpectedReturnType(node) instanceof PyNoneType)) {
                    this.registerProblem((PsiElement)(annotation != null ? annotation.getValue() : node.getTypeComment()), "__init__ should return None");
                }
            }
        }

        @Override
        public void visitPyComprehensionElement(PyComprehensionElement node) {
            super.visitPyComprehensionElement(node);
            for (PyComprehensionForComponent forComponent : node.getForComponents()) {
                this.checkIteratedValue(forComponent.getIteratedList(), forComponent.isAsync());
            }
        }

        private void checkCallSite(@NotNull PyCallSiteExpression callSite) {
            List calleesResults;
            if (callSite == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            if (!Visitor.matchedCalleeResultsExist(calleesResults = ((StreamEx)StreamEx.of(PyCallExpressionHelper.mapArguments(callSite, this.getResolveContext())).filter(mapping -> mapping.getUnmappedArguments().isEmpty() && mapping.getUnmappedParameters().isEmpty())).map(mapping -> {
                if (callSite == null) {
                    Visitor.$$$reportNull$$$0(15);
                }
                return this.analyzeCallee(callSite, (PyCallExpression.PyArgumentsMapping)mapping);
            }).nonNull().toList())) {
                PyTypeCheckerInspectionProblemRegistrar.registerProblem(this, callSite, Visitor.getArgumentTypes(calleesResults), calleesResults, this.myTypeEvalContext);
            }
        }

        private void checkIteratedValue(@Nullable PyExpression iteratedValue, boolean isAsync) {
            if (iteratedValue != null) {
                String iterableClassName;
                PyType type = this.myTypeEvalContext.getType(iteratedValue);
                String string = iterableClassName = isAsync ? "AsyncIterable" : "Iterable";
                if (type != null && !PyTypeChecker.isUnknown(type, this.myTypeEvalContext) && !PyABCUtil.isSubtype(type, iterableClassName, this.myTypeEvalContext)) {
                    String typeName = PythonDocumentationProvider.getTypeName(type, this.myTypeEvalContext);
                    this.registerProblem((PsiElement)iteratedValue, String.format("Expected 'collections.%s', got '%s' instead", iterableClassName, typeName));
                }
            }
        }

        @Nullable
        private AnalyzeCalleeResults analyzeCallee(@NotNull PyCallSiteExpression callSite, @NotNull PyCallExpression.PyArgumentsMapping mapping) {
            PyCallableParameter keywordContainer;
            PyCallExpression.PyMarkedCallee markedCallee;
            if (callSite == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            if (mapping == null) {
                Visitor.$$$reportNull$$$0(4);
            }
            if ((markedCallee = mapping.getMarkedCallee()) == null) {
                return null;
            }
            ArrayList<AnalyzeArgumentResult> result2 = new ArrayList<AnalyzeArgumentResult>();
            PyExpression receiver = callSite.getReceiver(markedCallee.getElement());
            Map<PyGenericType, PyType> substitutions = PyTypeChecker.unifyReceiver(receiver, this.myTypeEvalContext);
            Map<PyExpression, PyCallableParameter> mappedParameters = mapping.getMappedParameters();
            for (Map.Entry<PyExpression, PyCallableParameter> entry : PyCallExpressionHelper.getRegularMappedParameters(mappedParameters).entrySet()) {
                PyExpression argument = entry.getKey();
                PyCallableParameter parameter = entry.getValue();
                PyType expected = parameter.getArgumentType(this.myTypeEvalContext);
                PyType actual = this.myTypeEvalContext.getType(argument);
                boolean matched = PyTypeChecker.match(expected, actual, this.myTypeEvalContext, substitutions);
                result2.add(new AnalyzeArgumentResult(argument, expected, this.substituteGenerics(expected, substitutions), actual, matched));
            }
            PyCallableParameter positionalContainer = PyCallExpressionHelper.getMappedPositionalContainer(mappedParameters);
            if (positionalContainer != null) {
                result2.addAll(this.analyzeContainerMapping(positionalContainer, PyCallExpressionHelper.getArgumentsMappedToPositionalContainer(mappedParameters), substitutions));
            }
            if ((keywordContainer = PyCallExpressionHelper.getMappedKeywordContainer(mappedParameters)) != null) {
                result2.addAll(this.analyzeContainerMapping(keywordContainer, PyCallExpressionHelper.getArgumentsMappedToKeywordContainer(mappedParameters), substitutions));
            }
            return new AnalyzeCalleeResults(markedCallee.getCallableType(), markedCallee.getElement(), result2);
        }

        @NotNull
        private List<AnalyzeArgumentResult> analyzeContainerMapping(@NotNull PyCallableParameter container, @NotNull List<PyExpression> arguments, @NotNull Map<PyGenericType, PyType> substitutions) {
            if (container == null) {
                Visitor.$$$reportNull$$$0(5);
            }
            if (arguments == null) {
                Visitor.$$$reportNull$$$0(6);
            }
            if (substitutions == null) {
                Visitor.$$$reportNull$$$0(7);
            }
            PyType expected = container.getArgumentType(this.myTypeEvalContext);
            PyType expectedWithSubstitutions = this.substituteGenerics(expected, substitutions);
            if (PyTypeChecker.hasGenerics(expected, this.myTypeEvalContext)) {
                PyType actual = PyUnionType.union(arguments.stream().map(e -> this.myTypeEvalContext.getType((PyTypedElement)e)).collect(Collectors.toList()));
                boolean matched = PyTypeChecker.match(expected, actual, this.myTypeEvalContext, substitutions);
                List<AnalyzeArgumentResult> list2 = arguments.stream().map(argument -> new AnalyzeArgumentResult((PyExpression)argument, expected, expectedWithSubstitutions, actual, matched)).collect(Collectors.toList());
                if (list2 == null) {
                    Visitor.$$$reportNull$$$0(8);
                }
                return list2;
            }
            List<AnalyzeArgumentResult> list3 = arguments.stream().map(argument -> {
                if (substitutions == null) {
                    Visitor.$$$reportNull$$$0(14);
                }
                PyType actual = this.myTypeEvalContext.getType((PyTypedElement)argument);
                boolean matched = PyTypeChecker.match(expected, actual, this.myTypeEvalContext, substitutions);
                return new AnalyzeArgumentResult((PyExpression)argument, expected, expectedWithSubstitutions, actual, matched);
            }).collect(Collectors.toList());
            if (list3 == null) {
                Visitor.$$$reportNull$$$0(9);
            }
            return list3;
        }

        @Nullable
        private PyType substituteGenerics(@Nullable PyType expectedArgumentType, @NotNull Map<PyGenericType, PyType> substitutions) {
            if (substitutions == null) {
                Visitor.$$$reportNull$$$0(10);
            }
            return PyTypeChecker.hasGenerics(expectedArgumentType, this.myTypeEvalContext) ? PyTypeChecker.substitute(expectedArgumentType, substitutions, this.myTypeEvalContext) : null;
        }

        private static boolean matchedCalleeResultsExist(@NotNull List<AnalyzeCalleeResults> calleesResults) {
            if (calleesResults == null) {
                Visitor.$$$reportNull$$$0(11);
            }
            return calleesResults.stream().anyMatch(calleeResults -> calleeResults.getResults().stream().allMatch(AnalyzeArgumentResult::isMatched));
        }

        @NotNull
        private static List<PyType> getArgumentTypes(@NotNull List<AnalyzeCalleeResults> calleesResults) {
            if (calleesResults == null) {
                Visitor.$$$reportNull$$$0(12);
            }
            List<PyType> list2 = calleesResults.stream().map(AnalyzeCalleeResults::getResults).max(Comparator.comparingInt(List::size)).orElse(Collections.emptyList()).stream().map(AnalyzeArgumentResult::getActualType).collect(Collectors.toList());
            if (list2 == null) {
                Visitor.$$$reportNull$$$0(13);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 8: 
                case 9: 
                case 13: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 8: 
                case 9: 
                case 13: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "function";
                    break;
                }
                case 2: 
                case 3: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callSite";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mapping";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "container";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arguments";
                    break;
                }
                case 7: 
                case 10: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "substitutions";
                    break;
                }
                case 8: 
                case 9: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyTypeCheckerInspection$Visitor";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "calleesResults";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyTypeCheckerInspection$Visitor";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "analyzeContainerMapping";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getArgumentTypes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getExpectedReturnType";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "checkCallSite";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "analyzeCallee";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "analyzeContainerMapping";
                    break;
                }
                case 8: 
                case 9: 
                case 13: {
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "substituteGenerics";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "matchedCalleeResultsExist";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "getArgumentTypes";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$analyzeContainerMapping$4";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$checkCallSite$1";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 8: 
                case 9: 
                case 13: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class ReturnVisitor
        extends PyRecursiveElementVisitor {
            private final PyFunction myFunction;
            private boolean myHasReturns = false;

            public ReturnVisitor(PyFunction function) {
                this.myFunction = function;
            }

            @Override
            public void visitPyReturnStatement(PyReturnStatement node) {
                if (ScopeUtil.getScopeOwner((PsiElement)node) == this.myFunction) {
                    this.myHasReturns = true;
                }
            }
        }
    }
}

