/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Queues;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.PsiFileFactoryImpl;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.NotNullPredicate;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyListLiteralExpression;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyPassStatement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Formatter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyElementGeneratorImpl
extends PyElementGenerator {
    private static final CommasOnly COMMAS_ONLY = new CommasOnly();
    private final Project myProject;
    static final int[] FROM_ROOT = new int[]{0};
    static int[] PATH_PARAMETER = new int[]{0, 3, 1};

    public PyElementGeneratorImpl(Project project) {
        this.myProject = project;
    }

    @Override
    public ASTNode createNameIdentifier(String name, LanguageLevel languageLevel) {
        PsiFile dummyFile = this.createDummyFile(languageLevel, name);
        PyExpressionStatement expressionStatement = (PyExpressionStatement)dummyFile.getFirstChild();
        PyReferenceExpression refExpression = (PyReferenceExpression)expressionStatement.getFirstChild();
        return refExpression.getNode().getFirstChildNode();
    }

    @Override
    public PsiFile createDummyFile(LanguageLevel langLevel, String contents) {
        return this.createDummyFile(langLevel, contents, false);
    }

    public PsiFile createDummyFile(LanguageLevel langLevel, String contents, boolean physical) {
        PsiFileFactory factory = PsiFileFactory.getInstance((Project)this.myProject);
        String name = PyElementGeneratorImpl.getDummyFileName();
        LightVirtualFile virtualFile = new LightVirtualFile(name, (FileType)PythonFileType.INSTANCE, (CharSequence)contents);
        virtualFile.putUserData(LanguageLevel.KEY, (Object)langLevel);
        PsiFile psiFile = ((PsiFileFactoryImpl)factory).trySetupPsiForFile(virtualFile, PythonLanguage.getInstance(), physical, true);
        assert (psiFile != null);
        return psiFile;
    }

    @NotNull
    public static String getDummyFileName() {
        String string = "dummy." + PythonFileType.INSTANCE.getDefaultExtension();
        if (string == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public PyStringLiteralExpression createStringLiteralAlreadyEscaped(String str) {
        PsiFile dummyFile = this.createDummyFile(LanguageLevel.getDefault(), "a=(" + str + ")");
        PyAssignmentStatement expressionStatement = (PyAssignmentStatement)dummyFile.getFirstChild();
        PyExpression assignedValue = expressionStatement.getAssignedValue();
        if (assignedValue != null) {
            return (PyStringLiteralExpression)((PyParenthesizedExpression)assignedValue).getContainedExpression();
        }
        return this.createStringLiteralFromString(str);
    }

    @Override
    public PyStringLiteralExpression createStringLiteralFromString(@NotNull String unescaped) {
        if (unescaped == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(1);
        }
        return this.createStringLiteralFromString(null, unescaped, true);
    }

    @Override
    public PyStringLiteralExpression createStringLiteral(@NotNull PyStringLiteralExpression oldElement, @NotNull String unescaped) {
        Pair<String, String> quotes;
        if (oldElement == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(2);
        }
        if (unescaped == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(3);
        }
        if ((quotes = PyStringLiteralUtil.getQuotes(oldElement.getText())) != null) {
            return this.createStringLiteralAlreadyEscaped((String)quotes.first + unescaped + (String)quotes.second);
        }
        return this.createStringLiteralFromString(unescaped);
    }

    @Override
    public PyStringLiteralExpression createStringLiteralFromString(@Nullable PsiFile destination, @NotNull String unescaped, boolean preferUTF8) {
        VirtualFile vfile;
        if (unescaped == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(4);
        }
        boolean useDouble = !unescaped.contains("\"");
        boolean useMulti = unescaped.matches(".*(\r|\n).*");
        String quotes = useMulti ? (useDouble ? "\"\"\"" : "'''") : (useDouble ? "\"" : "'");
        StringBuilder buf = new StringBuilder(unescaped.length() * 2);
        buf.append(quotes);
        VirtualFile virtualFile = vfile = destination == null ? null : destination.getVirtualFile();
        Charset charset = vfile == null ? (preferUTF8 ? CharsetToolkit.UTF8_CHARSET : Charset.forName("US-ASCII")) : vfile.getCharset();
        CharsetEncoder encoder = charset.newEncoder();
        Formatter formatter = new Formatter(buf);
        boolean unicode = false;
        for (int i = 0; i < unescaped.length(); ++i) {
            int c = unescaped.codePointAt(i);
            if (c == 34 && useDouble) {
                buf.append("\\\"");
                continue;
            }
            if (c == 39 && !useDouble) {
                buf.append("\\'");
                continue;
            }
            if (!(c != 13 && c != 10 || useMulti)) {
                if (c == 13) {
                    buf.append("\\r");
                    continue;
                }
                if (c != 10) continue;
                buf.append("\\n");
                continue;
            }
            if (!encoder.canEncode(new String(Character.toChars(c)))) {
                if (c <= 255) {
                    formatter.format("\\x%02x", c);
                    continue;
                }
                if (c < 65535) {
                    unicode = true;
                    formatter.format("\\u%04x", c);
                    continue;
                }
                unicode = true;
                formatter.format("\\U%08x", c);
                continue;
            }
            buf.appendCodePoint(c);
        }
        buf.append(quotes);
        if (unicode) {
            buf.insert(0, "u");
        }
        return this.createStringLiteralAlreadyEscaped(buf.toString());
    }

    @Override
    public PyListLiteralExpression createListLiteral() {
        PsiFile dummyFile = this.createDummyFile(LanguageLevel.getDefault(), "[]");
        PyExpressionStatement expressionStatement = (PyExpressionStatement)dummyFile.getFirstChild();
        return (PyListLiteralExpression)expressionStatement.getFirstChild();
    }

    @Override
    public ASTNode createComma() {
        PsiFile dummyFile = this.createDummyFile(LanguageLevel.getDefault(), "[0,]");
        PyExpressionStatement expressionStatement = (PyExpressionStatement)dummyFile.getFirstChild();
        ASTNode zero = expressionStatement.getFirstChild().getNode().getFirstChildNode().getTreeNext();
        return zero.getTreeNext().copyElement();
    }

    @Override
    public ASTNode createDot() {
        PsiFile dummyFile = this.createDummyFile(LanguageLevel.getDefault(), "a.b");
        PyExpressionStatement expressionStatement = (PyExpressionStatement)dummyFile.getFirstChild();
        ASTNode dot = expressionStatement.getFirstChild().getNode().getFirstChildNode().getTreeNext();
        return dot.copyElement();
    }

    @Override
    @NotNull
    public PsiElement insertItemIntoListRemoveRedundantCommas(@NotNull PyElement list2, @Nullable PyExpression afterThis, @NotNull PyExpression toInsert) {
        LeafPsiElement lastComma;
        ArrayDeque commas;
        if (list2 == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(5);
        }
        if (toInsert == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(6);
        }
        PsiElement result2 = this.insertItemIntoList(list2, afterThis, toInsert);
        LeafPsiElement[] leafs = (LeafPsiElement[])PsiTreeUtil.getChildrenOfType((PsiElement)list2, LeafPsiElement.class);
        if (leafs != null && !(commas = Queues.newArrayDeque((Iterable)Collections2.filter(Arrays.asList(leafs), (Predicate)COMMAS_ONLY))).isEmpty() && PsiTreeUtil.getNextSiblingOfType((PsiElement)(lastComma = (LeafPsiElement)commas.getLast()), PyExpression.class) == null) {
            lastComma.delete();
        }
        PsiElement psiElement = result2;
        if (psiElement == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(7);
        }
        return psiElement;
    }

    @Override
    public PsiElement insertItemIntoList(PyElement list2, @Nullable PyExpression afterThis, PyExpression toInsert) throws IncorrectOperationException {
        ASTNode add = toInsert.getNode().copyElement();
        if (afterThis == null) {
            ASTNode exprNode = list2.getNode();
            ASTNode[] closingTokens = exprNode.getChildren(TokenSet.create((IElementType[])new IElementType[]{PyTokenTypes.LBRACKET, PyTokenTypes.LPAR}));
            if (closingTokens.length == 0) {
                exprNode.addChild(add);
            } else {
                ASTNode next = PyPsiUtils.getNextNonWhitespaceSibling(closingTokens[closingTokens.length - 1]);
                if (next != null) {
                    ASTNode comma = this.createComma();
                    exprNode.addChild(comma, next);
                    exprNode.addChild(add, comma);
                } else {
                    exprNode.addChild(add);
                }
            }
        } else {
            ASTNode lastArgNode = afterThis.getNode();
            ASTNode comma = this.createComma();
            ASTNode parent = lastArgNode.getTreeParent();
            ASTNode afterLast = lastArgNode.getTreeNext();
            if (afterLast == null) {
                parent.addChild(add);
            } else {
                parent.addChild(add, afterLast);
            }
            parent.addChild(comma, add);
        }
        return add.getPsi();
    }

    @Override
    public PyBinaryExpression createBinaryExpression(String s, PyExpression expr, PyExpression listLiteral) {
        PsiFile dummyFile = this.createDummyFile(LanguageLevel.getDefault(), "a " + s + " b");
        PyExpressionStatement expressionStatement = (PyExpressionStatement)dummyFile.getFirstChild();
        PyBinaryExpression binExpr = (PyBinaryExpression)expressionStatement.getExpression();
        ASTNode binnode = binExpr.getNode();
        binnode.replaceChild(binExpr.getLeftExpression().getNode(), expr.getNode().copyElement());
        binnode.replaceChild(binExpr.getRightExpression().getNode(), listLiteral.getNode().copyElement());
        return binExpr;
    }

    @Override
    public PyExpression createExpressionFromText(String text) {
        return this.createExpressionFromText(LanguageLevel.getDefault(), text);
    }

    @Override
    @NotNull
    public PyExpression createExpressionFromText(LanguageLevel languageLevel, String text) {
        PsiFile dummyFile = this.createDummyFile(languageLevel, text);
        PsiElement element = dummyFile.getFirstChild();
        if (element instanceof PyExpressionStatement) {
            PyExpression pyExpression = ((PyExpressionStatement)element).getExpression();
            if (pyExpression == null) {
                PyElementGeneratorImpl.$$$reportNull$$$0(8);
            }
            return pyExpression;
        }
        throw new IncorrectOperationException("could not parse text as expression: " + text);
    }

    @Override
    @NotNull
    public PyCallExpression createCallExpression(LanguageLevel langLevel, String functionName) {
        PsiElement element;
        PsiFile dummyFile = this.createDummyFile(langLevel, functionName + "()");
        PsiElement child = dummyFile.getFirstChild();
        if (child != null && (element = child.getFirstChild()) instanceof PyCallExpression) {
            PyCallExpression pyCallExpression = (PyCallExpression)element;
            if (pyCallExpression == null) {
                PyElementGeneratorImpl.$$$reportNull$$$0(9);
            }
            return pyCallExpression;
        }
        throw new IllegalArgumentException("Invalid call expression text " + functionName);
    }

    @Override
    public PyImportElement createImportElement(@NotNull LanguageLevel languageLevel, @NotNull String name, @Nullable String alias) {
        if (languageLevel == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(10);
        }
        if (name == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(11);
        }
        String importStatement = "from foo import " + name + (alias != null ? " as " + alias : "");
        return this.createFromText(languageLevel, PyImportElement.class, importStatement, new int[]{0, 6});
    }

    @Override
    public PyFunction createProperty(LanguageLevel languageLevel, String propertyName, String fieldName, AccessDirection accessDirection) {
        String propertyText = accessDirection == AccessDirection.DELETE ? "@" + propertyName + ".deleter\ndef " + propertyName + "(self):\n  del self." + fieldName : (accessDirection == AccessDirection.WRITE ? "@" + propertyName + ".setter\ndef " + propertyName + "(self, value):\n  self." + fieldName + " = value" : "@property\ndef " + propertyName + "(self):\n  return self." + fieldName);
        return this.createFromText(languageLevel, PyFunction.class, propertyText);
    }

    @Override
    @NotNull
    public <T> T createFromText(LanguageLevel langLevel, Class<T> aClass, String text) {
        T t = this.createFromText(langLevel, aClass, text, FROM_ROOT);
        if (t == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(12);
        }
        return t;
    }

    @Override
    @NotNull
    public <T> T createPhysicalFromText(LanguageLevel langLevel, Class<T> aClass, String text) {
        T t = this.createFromText(langLevel, aClass, text, FROM_ROOT, true);
        if (t == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(13);
        }
        return t;
    }

    @Override
    public PyNamedParameter createParameter(@NotNull String name) {
        if (name == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(14);
        }
        return this.createParameter(name, null, null, LanguageLevel.getDefault());
    }

    @Override
    @NotNull
    public PyParameterList createParameterList(@NotNull LanguageLevel languageLevel, @NotNull String text) {
        if (languageLevel == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(15);
        }
        if (text == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(16);
        }
        PyParameterList pyParameterList = this.createFromText(languageLevel, PyParameterList.class, "def f" + text + ": pass", new int[]{0, 3});
        if (pyParameterList == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(17);
        }
        return pyParameterList;
    }

    @Override
    @NotNull
    public PyArgumentList createArgumentList(@NotNull LanguageLevel languageLevel, @NotNull String text) {
        if (languageLevel == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(18);
        }
        if (text == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(19);
        }
        PyArgumentList pyArgumentList = this.createFromText(languageLevel, PyArgumentList.class, "f" + text, new int[]{0, 0, 1});
        if (pyArgumentList == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(20);
        }
        return pyArgumentList;
    }

    @Override
    public PyNamedParameter createParameter(@NotNull String name, @Nullable String defaultValue, @Nullable String annotation, @NotNull LanguageLevel languageLevel) {
        if (name == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(21);
        }
        if (languageLevel == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(22);
        }
        String parameterText = name;
        if (annotation != null) {
            parameterText = parameterText + ": " + annotation;
        }
        if (defaultValue != null) {
            parameterText = parameterText + " = " + defaultValue;
        }
        return this.createFromText(languageLevel, PyNamedParameter.class, "def f(" + parameterText + "): pass", PATH_PARAMETER);
    }

    @Override
    public PyKeywordArgument createKeywordArgument(LanguageLevel languageLevel, String keyword, String value) {
        PyCallExpression callExpression = (PyCallExpression)this.createExpressionFromText(languageLevel, "foo(" + keyword + "=" + value + ")");
        return (PyKeywordArgument)callExpression.getArguments()[0];
    }

    @Override
    @NotNull
    public <T> T createFromText(LanguageLevel langLevel, Class<T> aClass, String text, int[] path) {
        T t = this.createFromText(langLevel, aClass, text, path, false);
        if (t == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(23);
        }
        return t;
    }

    @NotNull
    public <T> T createFromText(LanguageLevel langLevel, Class<T> aClass, String text, int[] path, boolean physical) {
        PsiFile ret = this.createDummyFile(langLevel, text, physical);
        block0: for (int skip : path) {
            if (ret == null) break;
            ret = ret.getFirstChild();
            for (int i = 0; i < skip; ++i) {
                if (ret == null) {
                    ret = null;
                    continue block0;
                }
                ret = ret.getNextSibling();
            }
        }
        if (ret == null) {
            throw new IllegalArgumentException("Can't find element matching path " + Arrays.toString(path) + " in text '" + text + "'");
        }
        if (aClass.isInstance(ret)) {
            PsiFile psiFile = ret;
            if (psiFile == null) {
                PyElementGeneratorImpl.$$$reportNull$$$0(24);
            }
            return (T)psiFile;
        }
        throw new IllegalArgumentException("Can't create an element of type " + aClass + " from text '" + text + "', got " + ret.getClass() + " instead");
    }

    @Override
    public PyPassStatement createPassStatement() {
        PyStatementList statementList = this.createPassStatementList();
        return (PyPassStatement)statementList.getStatements()[0];
    }

    @Override
    @NotNull
    public PyDecoratorList createDecoratorList(String ... decoratorTexts) {
        if (decoratorTexts == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(25);
        }
        assert (decoratorTexts.length > 0);
        StringBuilder functionText = new StringBuilder();
        for (String decoText : decoratorTexts) {
            functionText.append(decoText).append("\n");
        }
        functionText.append("def foo():\n\tpass");
        PyFunction function = this.createFromText(LanguageLevel.getDefault(), PyFunction.class, functionText.toString());
        PyDecoratorList decoratorList = function.getDecoratorList();
        assert (decoratorList != null);
        PyDecoratorList pyDecoratorList = decoratorList;
        if (pyDecoratorList == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(26);
        }
        return pyDecoratorList;
    }

    private PyStatementList createPassStatementList() {
        PyFunction function = this.createFromText(LanguageLevel.getDefault(), PyFunction.class, "def foo():\n\tpass");
        return function.getStatementList();
    }

    @Override
    public PyExpressionStatement createDocstring(String content) {
        return this.createFromText(LanguageLevel.getDefault(), PyExpressionStatement.class, content + "\n");
    }

    @Override
    @NotNull
    public PsiElement createNewLine() {
        PsiElement psiElement = (PsiElement)this.createFromText(LanguageLevel.getDefault(), PsiWhiteSpace.class, " \n\n ");
        if (psiElement == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(27);
        }
        return psiElement;
    }

    @Override
    @NotNull
    public PyFromImportStatement createFromImportStatement(@NotNull LanguageLevel languageLevel, @NotNull String qualifier, @NotNull String name, @Nullable String alias) {
        if (languageLevel == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(28);
        }
        if (qualifier == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(29);
        }
        if (name == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(30);
        }
        String asClause = StringUtil.isNotEmpty((String)alias) ? " as " + alias : "";
        String statement = "from " + qualifier + " import " + name + asClause;
        PyFromImportStatement pyFromImportStatement = this.createFromText(languageLevel, PyFromImportStatement.class, statement);
        if (pyFromImportStatement == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(31);
        }
        return pyFromImportStatement;
    }

    @Override
    @NotNull
    public PyImportStatement createImportStatement(@NotNull LanguageLevel languageLevel, @NotNull String name, @Nullable String alias) {
        if (languageLevel == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(32);
        }
        if (name == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(33);
        }
        String asClause = StringUtil.isNotEmpty((String)alias) ? " as " + alias : "";
        String statement = "import " + name + asClause;
        PyImportStatement pyImportStatement = this.createFromText(languageLevel, PyImportStatement.class, statement);
        if (pyImportStatement == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(34);
        }
        return pyImportStatement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PyElementGeneratorImpl";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unescaped";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toInsert";
                break;
            }
            case 10: 
            case 15: 
            case 18: 
            case 22: 
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 11: 
            case 14: 
            case 21: 
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decoratorTexts";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDummyFileName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PyElementGeneratorImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "insertItemIntoListRemoveRedundantCommas";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createExpressionFromText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createCallExpression";
                break;
            }
            case 12: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createFromText";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createPhysicalFromText";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createParameterList";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createArgumentList";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createDecoratorList";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewLine";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "createFromImportStatement";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "createImportStatement";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createStringLiteralFromString";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createStringLiteral";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "insertItemIntoListRemoveRedundantCommas";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createImportElement";
                break;
            }
            case 14: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createParameter";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createParameterList";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createArgumentList";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createDecoratorList";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createFromImportStatement";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createImportStatement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CommasOnly
    extends NotNullPredicate<LeafPsiElement> {
        private CommasOnly() {
        }

        @Override
        protected boolean applyNotNull(@NotNull LeafPsiElement input) {
            if (input == null) {
                CommasOnly.$$$reportNull$$$0(0);
            }
            return input.getNode().getElementType().equals((Object)PyTokenTypes.COMMA);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/jetbrains/python/psi/impl/PyElementGeneratorImpl$CommasOnly", "applyNotNull"));
        }
    }
}

