/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.impl.PyEvaluator;
import java.io.File;
import org.jetbrains.annotations.Nullable;

public class PyPathEvaluator
extends PyEvaluator {
    private final String myContainingFilePath;

    public PyPathEvaluator(String containingFilePath) {
        this.myContainingFilePath = containingFilePath;
    }

    @Nullable
    public static String evaluatePath(PyExpression expr) {
        if (expr == null) {
            return null;
        }
        VirtualFile vFile = expr.getContainingFile().getVirtualFile();
        Object result2 = new PyPathEvaluator(vFile == null ? null : vFile.getPath()).evaluate(expr);
        return result2 instanceof String ? (String)result2 : null;
    }

    @Override
    protected Object evaluateCall(PyCallExpression call) {
        PyExpression[] args = call.getArguments();
        if (call.isCalleeText("dirname") && args.length == 1) {
            Object argValue = this.evaluate(args[0]);
            return argValue instanceof String ? new File((String)argValue).getParent() : null;
        }
        if (call.isCalleeText("join") && args.length >= 1) {
            return this.evaluatePathInJoin(args, args.length);
        }
        if (call.isCalleeText("normpath", "realpath") && args.length == 1) {
            return this.evaluate(args[0]);
        }
        if (call.isCalleeText("abspath") && args.length == 1) {
            Object argValue = this.evaluate(args[0]);
            if (!(argValue instanceof String)) {
                return null;
            }
            if (FileUtil.isAbsolutePlatformIndependent((String)((String)argValue))) {
                return argValue;
            }
            String path = new File(new File(this.myContainingFilePath).getParent(), (String)argValue).getPath();
            return path.replace("\\", "/");
        }
        return super.evaluateCall(call);
    }

    @Override
    protected Object evaluateReferenceExpression(PyReferenceExpression expr) {
        if ("pardir".equals(expr.getName())) {
            return "..";
        }
        if ("curdir".equals(expr.getName())) {
            return ".";
        }
        if (!expr.isQualified() && "__file__".equals(expr.getReferencedName())) {
            return this.myContainingFilePath;
        }
        return super.evaluateReferenceExpression(expr);
    }

    public String evaluatePathInJoin(PyExpression[] args, int endElement) {
        String result2 = null;
        for (int i = 0; i < endElement; ++i) {
            Object arg = this.evaluate(args[i]);
            if (!(arg instanceof String)) {
                return null;
            }
            result2 = result2 == null ? (String)arg : new File(result2, (String)arg).getPath().replace("\\", "/");
        }
        return result2;
    }
}

