/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.NameSuggestionProvider;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyParameter;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PyNameSuggestionProvider
implements NameSuggestionProvider {
    public SuggestedNameInfo getSuggestedNames(PsiElement element, PsiElement nameSuggestionContext, Set<String> result2) {
        if (!(element instanceof PyElement)) {
            return null;
        }
        String name = ((PyElement)element).getName();
        if (name == null) {
            return null;
        }
        if (element instanceof PyClass) {
            result2.add(this.toCamelCase(name, true));
        } else if (element instanceof PyFunction || element instanceof PyParameter) {
            result2.add(this.toUnderscores(name));
        } else {
            result2.add(this.toUnderscores(name));
            PyAssignmentStatement assignmentStatement = (PyAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PyAssignmentStatement.class);
            if (assignmentStatement != null) {
                return null;
            }
            result2.add(name.toUpperCase());
            result2.add(this.toCamelCase(name, false));
        }
        return SuggestedNameInfo.NULL_INFO;
    }

    @NotNull
    protected String toUnderscores(@NotNull String name) {
        if (name == null) {
            PyNameSuggestionProvider.$$$reportNull$$$0(0);
        }
        StringBuilder result2 = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isUpperCase(c)) {
                if (i != 0) {
                    result2.append("_");
                }
                result2.append(Character.toLowerCase(c));
                continue;
            }
            result2.append(c);
        }
        String string = result2.toString();
        if (string == null) {
            PyNameSuggestionProvider.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    protected String toCamelCase(@NotNull String name, boolean uppercaseFirstLetter) {
        List strings;
        if (name == null) {
            PyNameSuggestionProvider.$$$reportNull$$$0(2);
        }
        if ((strings = StringUtil.split((String)name, (String)"_")).size() > 0) {
            StringBuilder buf = new StringBuilder();
            String str = ((String)strings.get(0)).toLowerCase();
            if (uppercaseFirstLetter) {
                str = StringUtil.capitalize((String)str);
            }
            buf.append(str);
            for (int i = 1; i < strings.size(); ++i) {
                buf.append(StringUtil.capitalize((String)((String)strings.get(i)).toLowerCase()));
            }
            String string = buf.toString();
            if (string == null) {
                PyNameSuggestionProvider.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = name;
        if (string == null) {
            PyNameSuggestionProvider.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/PyNameSuggestionProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/PyNameSuggestionProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "toUnderscores";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "toCamelCase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "toUnderscores";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "toCamelCase";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

