/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.add;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.python.packaging.PyCondaPackageManagerImpl;
import com.jetbrains.python.packaging.PyCondaPackageService;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.add.PyAddNewEnvPanel;
import com.jetbrains.python.sdk.add.PyAddSdkPanel;
import com.jetbrains.python.sdk.flavors.CondaEnvSdkFlavor;
import com.jetbrains.python.validation.UnsupportedFeaturesUtil;
import icons.PythonIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\n\u0010 \u001a\u0004\u0018\u00010\u0006H\u0016J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u0005H\u0016R\u0016\u0010\n\u001a\u0004\u0018\u00010\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\f\"\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\fR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\f\u00a8\u0006#"}, d2={"Lcom/jetbrains/python/sdk/add/PyAddNewCondaEnvPanel;", "Lcom/jetbrains/python/sdk/add/PyAddNewEnvPanel;", "project", "Lcom/intellij/openapi/project/Project;", "existingSdks", "", "Lcom/intellij/openapi/projectRoots/Sdk;", "newProjectPath", "", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Ljava/lang/String;)V", "defaultBaseDir", "getDefaultBaseDir", "()Ljava/lang/String;", "envName", "getEnvName", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "languageLevelsField", "Ljavax/swing/JComboBox;", "makeSharedField", "Lcom/intellij/ui/components/JBCheckBox;", "getNewProjectPath", "setNewProjectPath", "(Ljava/lang/String;)V", "panelName", "getPanelName", "pathField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "selectedLanguageLevel", "getSelectedLanguageLevel", "getOrCreateSdk", "validateAll", "Lcom/intellij/openapi/ui/ValidationInfo;", "python-community"})
public final class PyAddNewCondaEnvPanel
extends PyAddNewEnvPanel {
    @NotNull
    private final String envName = "Conda";
    @NotNull
    private final String panelName = "New environment";
    @NotNull
    private final Icon icon;
    private final TextFieldWithBrowseButton pathField;
    private final JComboBox<String> languageLevelsField;
    private final JBCheckBox makeSharedField;
    private final Project project;
    private final List<Sdk> existingSdks;
    @Nullable
    private String newProjectPath;

    @Override
    @NotNull
    public String getEnvName() {
        return this.envName;
    }

    @Override
    @NotNull
    public String getPanelName() {
        return this.panelName;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    @NotNull
    public List<ValidationInfo> validateAll() {
        return CollectionsKt.filterNotNull((Iterable)CollectionsKt.listOf((Object[])new ValidationInfo[]{PyAddSdkPanel.Companion.validateAnacondaPresense((JComponent)this.pathField), PyAddSdkPanel.Companion.validateEmptyOrNonExistingDirectoryLocation(this.pathField)}));
    }

    @Override
    @Nullable
    public Sdk getOrCreateSdk() {
        String string;
        Task.WithResult<String, ExecutionException> task2 = new Task.WithResult<String, ExecutionException>(this, this.project, "Creating Conda Environment", false){
            final /* synthetic */ PyAddNewCondaEnvPanel this$0;

            @NotNull
            protected String compute(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                indicator.setIndeterminate(true);
                String string = PyCondaPackageManagerImpl.createVirtualEnv(PyAddNewCondaEnvPanel.access$getPathField$p(this.this$0).getText(), PyAddNewCondaEnvPanel.access$getSelectedLanguageLevel$p(this.this$0));
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"PyCondaPackageManagerImp\u2026t, selectedLanguageLevel)");
                return string;
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
            }
        };
        boolean shared = this.makeSharedField.isSelected();
        if (!shared) {
            string = this.getNewProjectPath();
            if (string == null) {
                Project project = this.project;
                string = project != null ? project.getBasePath() : null;
            }
        } else {
            string = null;
        }
        String associatedPath = string;
        Sdk sdk = PySdkExtKt.createSdkByGenerateTask((Task.WithResult<String, ExecutionException>)((Task.WithResult)task2), this.existingSdks, null, associatedPath);
        if (sdk == null) {
            return null;
        }
        Sdk sdk2 = sdk;
        if (!shared) {
            PySdkExtKt.associateWithProject(sdk2, this.project, this.getNewProjectPath() != null);
        }
        return sdk2;
    }

    private final String getDefaultBaseDir() {
        VirtualFile location = (VirtualFile)CollectionsKt.firstOrNull(CondaEnvSdkFlavor.getCondaDefaultLocations());
        if (location != null) {
            return location.getPath();
        }
        String string = PyCondaPackageService.getSystemCondaExecutable();
        if (string == null) {
            return null;
        }
        String conda = string;
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(conda);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile condaFile = virtualFile;
        VirtualFile virtualFile2 = condaFile.getParent();
        return virtualFile2 != null && (virtualFile2 = virtualFile2.getParent()) != null && (virtualFile2 = virtualFile2.findChild("envs")) != null ? virtualFile2.getPath() : null;
    }

    private final String getSelectedLanguageLevel() {
        String string = this.languageLevelsField.getItemAt(this.languageLevelsField.getSelectedIndex());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"languageLevelsField.getI\u2026evelsField.selectedIndex)");
        return string;
    }

    @Override
    @Nullable
    public String getNewProjectPath() {
        return this.newProjectPath;
    }

    @Override
    public void setNewProjectPath(@Nullable String string) {
        this.newProjectPath = string;
    }

    public PyAddNewCondaEnvPanel(@Nullable Project project, @NotNull List<? extends Sdk> existingSdks, @Nullable String newProjectPath) {
        Object $receiver$iv;
        JComboBox<String> jComboBox;
        Intrinsics.checkParameterIsNotNull(existingSdks, (String)"existingSdks");
        this.project = project;
        this.existingSdks = existingSdks;
        this.newProjectPath = newProjectPath;
        this.envName = "Conda";
        this.panelName = "New environment";
        Icon icon = PythonIcons.Python.Anaconda;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"PythonIcons.Python.Anaconda");
        this.icon = icon;
        TextFieldWithBrowseButton textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        PyAddNewCondaEnvPanel pyAddNewCondaEnvPanel = this;
        Object $receiver = textFieldWithBrowseButton;
        String string = this.getDefaultBaseDir();
        if (string == null) {
            String string2 = SystemProperties.getUserHome();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"SystemProperties.getUserHome()");
        }
        String baseDir = string;
        $receiver.setText(FileUtil.findSequentNonexistentFile((File)new File(baseDir), (String)"untitled", (String)"").getPath());
        $receiver.addBrowseFolderListener("Select Location for Conda Environment", null, this.project, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        Object object = textFieldWithBrowseButton;
        pyAddNewCondaEnvPanel.pathField = object;
        this.makeSharedField = new JBCheckBox("Make available to all projects");
        this.setLayout(new BorderLayout());
        List languageLevels = CollectionsKt.reversed((Iterable)UnsupportedFeaturesUtil.ALL_LANGUAGE_LEVELS);
        $receiver = languageLevels;
        JComboBox<String> jComboBox2 = jComboBox;
        object = jComboBox;
        pyAddNewCondaEnvPanel = this;
        void v4 = $receiver$iv;
        if (v4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        void thisCollection$iv = v4;
        String[] stringArray = thisCollection$iv.toArray(new String[thisCollection$iv.size()]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] stringArray2 = stringArray;
        jComboBox2(stringArray2);
        Object $receiver2 = $receiver$iv = object;
        ((JComboBox)$receiver2).setSelectedItem(((JComboBox)$receiver2).getItemCount() > 0 ? (String)((JComboBox)$receiver2).getItemAt(0) : null);
        ((JComponent)$receiver2).setPreferredSize(new Dimension(Integer.MAX_VALUE, ((JComponent)$receiver2).getPreferredSize().height));
        pyAddNewCondaEnvPanel.languageLevelsField = object = $receiver$iv;
        JPanel formPanel = FormBuilder.createFormBuilder().addLabeledComponent("Location:", (JComponent)this.pathField).addLabeledComponent("Python version:", (JComponent)this.languageLevelsField).addComponent((JComponent)this.makeSharedField).getPanel();
        this.add((Component)formPanel, "North");
    }

    @NotNull
    public static final /* synthetic */ TextFieldWithBrowseButton access$getPathField$p(PyAddNewCondaEnvPanel $this) {
        return $this.pathField;
    }

    @NotNull
    public static final /* synthetic */ String access$getSelectedLanguageLevel$p(PyAddNewCondaEnvPanel $this) {
        return $this.getSelectedLanguageLevel();
    }
}

