/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.PyBreakStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyContinueStatement;
import com.jetbrains.python.psi.PyFinallyPart;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyLoopStatement;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.validation.PyAnnotator;
import org.jetbrains.annotations.Nullable;

public class BreakContinueAnnotator
extends PyAnnotator {
    @Override
    public void visitPyBreakStatement(PyBreakStatement node) {
        if (BreakContinueAnnotator.getContainingLoop(node) == null) {
            this.getHolder().createErrorAnnotation((PsiElement)node, PyBundle.message("ANN.break.outside.loop", new Object[0]));
        }
    }

    @Nullable
    private static PyLoopStatement getContainingLoop(PyStatement node) {
        return (PyLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)node, PyLoopStatement.class, (boolean)false, (Class[])new Class[]{PyFunction.class, PyClass.class});
    }

    @Override
    public void visitPyContinueStatement(PyContinueStatement node) {
        if (BreakContinueAnnotator.getContainingLoop(node) == null) {
            this.getHolder().createErrorAnnotation((PsiElement)node, PyBundle.message("ANN.continue.outside.loop", new Object[0]));
        } else if (PsiTreeUtil.getParentOfType((PsiElement)node, PyFinallyPart.class, (boolean)false, (Class[])new Class[]{PyLoopStatement.class}) != null) {
            this.getHolder().createErrorAnnotation((PsiElement)node, PyBundle.message("ANN.cant.continue.in.finally", new Object[0]));
        }
    }
}

