/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.fastCgi;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.io.Responses;
import org.jetbrains.io.fastCgi.FastCgiRequestKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0016\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0011J \u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0003H\u0002J\u0016\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010\u001f\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u0003H\u0002J\u0018\u0010 \u001a\u00020\r2\b\u0010!\u001a\u0004\u0018\u00010\b2\u0006\u0010\"\u001a\u00020\u001eR\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006#"}, d2={"Lorg/jetbrains/io/fastCgi/FastCgiRequest;", "", "requestId", "", "allocator", "Lio/netty/buffer/ByteBufAllocator;", "(ILio/netty/buffer/ByteBufAllocator;)V", "params", "Lio/netty/buffer/ByteBuf;", "kotlin.jvm.PlatformType", "getRequestId", "()I", "addHeader", "", "key", "", "value", "", "writeFileHeaders", "pathInfo", "Lorg/jetbrains/builtInWebServer/PathInfo;", "canonicalRequestPath", "writeHeader", "buffer", "type", "length", "writeHeaders", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "clientChannel", "Lio/netty/channel/Channel;", "writeParamLength", "writeToServerChannel", "content", "fastCgiChannel", "built-in-server"})
public final class FastCgiRequest {
    private final ByteBuf params;
    private final int requestId;

    public final void writeFileHeaders(@NotNull PathInfo pathInfo, @NotNull CharSequence canonicalRequestPath) {
        Intrinsics.checkParameterIsNotNull((Object)pathInfo, (String)"pathInfo");
        Intrinsics.checkParameterIsNotNull((Object)canonicalRequestPath, (String)"canonicalRequestPath");
        VirtualFile root = pathInfo.getRoot();
        this.addHeader("DOCUMENT_ROOT", FileUtil.toSystemDependentName((String)root.getPath()));
        this.addHeader("SCRIPT_FILENAME", pathInfo.getFilePath());
        this.addHeader("SCRIPT_NAME", canonicalRequestPath);
    }

    private final void addHeader(String key, CharSequence value) {
        int n;
        byte[] byArray;
        if (value == null) {
            return;
        }
        CharSequence charSequence = value;
        if (!(charSequence instanceof String)) {
            charSequence = null;
        }
        String string = (String)charSequence;
        if (string != null) {
            String string2 = string;
            Charset charset = Charsets.UTF_8;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray2 = string3.getBytes(charset);
            byArray = byArray2;
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
        } else {
            byArray = null;
        }
        byte[] valBytes = byArray;
        ByteBuffer valBuffer = value instanceof String ? null : Charsets.UTF_8.encode(CharBuffer.wrap(value));
        int keyLength = key.length();
        if (valBytes != null) {
            n = valBytes.length;
        } else {
            ByteBuffer byteBuffer = valBuffer;
            if (byteBuffer == null) {
                Intrinsics.throwNpe();
            }
            n = byteBuffer.limit();
        }
        int valLength = n;
        this.writeParamLength(keyLength);
        this.writeParamLength(valLength);
        ByteBufUtil.writeAscii((ByteBuf)this.params, (CharSequence)key);
        if (valBuffer == null) {
            this.params.writeBytes(valBytes);
        } else {
            this.params.writeBytes(valBuffer);
        }
    }

    private final void writeParamLength(int length) {
        if (length > 127) {
            this.params.writeInt(length | (int)0x80000000L);
        } else {
            this.params.writeByte(length);
        }
    }

    public final void writeHeaders(@NotNull FullHttpRequest request, @NotNull Channel clientChannel) {
        Iterator iterator;
        String string;
        FastCgiRequest fastCgiRequest;
        CharSequence charSequence;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)clientChannel, (String)"clientChannel");
        this.addHeader("REQUEST_URI", request.uri());
        this.addHeader("REQUEST_METHOD", request.method().name());
        SocketAddress socketAddress = clientChannel.remoteAddress();
        if (socketAddress == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.net.InetSocketAddress");
        }
        InetSocketAddress remote = (InetSocketAddress)socketAddress;
        this.addHeader("REMOTE_ADDR", remote.getAddress().getHostAddress());
        this.addHeader("REMOTE_PORT", Integer.toString(remote.getPort()));
        SocketAddress socketAddress2 = clientChannel.localAddress();
        if (socketAddress2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.net.InetSocketAddress");
        }
        InetSocketAddress local = (InetSocketAddress)socketAddress2;
        this.addHeader("SERVER_SOFTWARE", Responses.getServerHeaderValue());
        this.addHeader("SERVER_NAME", Responses.getServerHeaderValue());
        this.addHeader("SERVER_ADDR", local.getAddress().getHostAddress());
        this.addHeader("SERVER_PORT", Integer.toString(local.getPort()));
        this.addHeader("GATEWAY_INTERFACE", "CGI/1.1");
        this.addHeader("SERVER_PROTOCOL", request.protocolVersion().text());
        this.addHeader("REDIRECT_STATUS", "200");
        String queryString = "";
        int queryIndex = StringsKt.indexOf$default((CharSequence)request.uri(), (char)'?', (int)0, (boolean)false, (int)6, null);
        if (queryIndex != -1) {
            object = request.uri();
            int n = queryIndex + 1;
            String string2 = object;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            queryString = string3;
            object = request.uri();
            n = 0;
            charSequence = "DOCUMENT_URI";
            fastCgiRequest = this;
            String string4 = object;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n, queryIndex);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string = string5;
            fastCgiRequest.addHeader((String)charSequence, string);
        } else {
            this.addHeader("DOCUMENT_URI", request.uri());
        }
        this.addHeader("QUERY_STRING", queryString);
        this.addHeader("CONTENT_LENGTH", String.valueOf(request.content().readableBytes()));
        String string6 = request.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        this.addHeader("CONTENT_TYPE", string6 != null ? (CharSequence)string6 : (CharSequence)"");
        Iterator iterator2 = iterator = request.headers().iteratorAsString();
        while (iterator2.hasNext()) {
            Locale locale;
            Object object2 = object = (Map.Entry)iterator2.next();
            String key = (String)object2.getKey();
            object2 = object;
            String value = (String)object2.getValue();
            if (StringsKt.equals((String)key, (String)"keep-alive", (boolean)true) || StringsKt.equals((String)key, (String)"connection", (boolean)true)) continue;
            StringBuilder stringBuilder = new StringBuilder().append("HTTP_");
            object2 = StringsKt.replace$default((String)key, (char)'-', (char)'_', (boolean)false, (int)4, null);
            Intrinsics.checkExpressionValueIsNotNull((Object)Locale.ENGLISH, (String)"Locale.ENGLISH");
            charSequence = stringBuilder;
            fastCgiRequest = this;
            Object object3 = object2;
            if (object3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)((String)object3).toUpperCase(locale), (String)"(this as java.lang.String).toUpperCase(locale)");
            fastCgiRequest.addHeader(((StringBuilder)charSequence).append(string).toString(), value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeToServerChannel(@Nullable ByteBuf content, @NotNull Channel fastCgiChannel) {
        Intrinsics.checkParameterIsNotNull((Object)fastCgiChannel, (String)"fastCgiChannel");
        if (fastCgiChannel.pipeline().first() == null) {
            throw (Throwable)new IllegalStateException("No handler in the pipeline");
        }
        try {
            ByteBuf buffer;
            ByteBuf byteBuf = buffer = fastCgiChannel.alloc().ioBuffer(4096);
            Intrinsics.checkExpressionValueIsNotNull((Object)byteBuf, (String)"buffer");
            this.writeHeader(byteBuf, FastCgiRequestKt.access$getBEGIN_REQUEST$p(), 8);
            buffer.writeShort(FastCgiRequestKt.access$getRESPONDER$p());
            buffer.writeByte(FastCgiRequestKt.access$getFCGI_KEEP_CONNECTION$p());
            buffer.writeZero(5);
            this.writeHeader(buffer, FastCgiRequestKt.access$getPARAMS$p(), this.params.readableBytes());
            buffer.writeBytes(this.params);
            this.writeHeader(buffer, FastCgiRequestKt.access$getPARAMS$p(), 0);
            fastCgiChannel.write((Object)buffer);
            if (content != null) {
                ByteBuf headerBuffer;
                int position = content.readerIndex();
                int toWrite = content.readableBytes();
                while (toWrite > 0) {
                    ByteBuf headerBuffer2;
                    int length = Math.min(FastCgiRequestKt.access$getMAX_CONTENT_LENGTH$p(), toWrite);
                    ByteBuf byteBuf2 = headerBuffer2 = fastCgiChannel.alloc().ioBuffer(8, 8);
                    Intrinsics.checkExpressionValueIsNotNull((Object)byteBuf2, (String)"headerBuffer");
                    this.writeHeader(byteBuf2, FastCgiRequestKt.access$getSTDIN$p(), length);
                    fastCgiChannel.write((Object)headerBuffer2);
                    ByteBuf chunk = content.slice(position, length);
                    chunk.retain();
                    fastCgiChannel.write((Object)chunk);
                    toWrite -= length;
                    position += length;
                }
                ByteBuf byteBuf3 = headerBuffer = fastCgiChannel.alloc().ioBuffer(8, 8);
                Intrinsics.checkExpressionValueIsNotNull((Object)byteBuf3, (String)"headerBuffer");
                this.writeHeader(byteBuf3, FastCgiRequestKt.access$getSTDIN$p(), 0);
                fastCgiChannel.write((Object)headerBuffer);
            }
        }
        finally {
            ByteBuf byteBuf = content;
            if (byteBuf != null) {
                byteBuf.release();
            }
        }
        fastCgiChannel.flush();
    }

    private final void writeHeader(ByteBuf buffer, int type, int length) {
        buffer.writeByte(FastCgiRequestKt.access$getVERSION$p());
        buffer.writeByte(type);
        buffer.writeShort(this.requestId);
        buffer.writeShort(length);
        buffer.writeZero(2);
    }

    public final int getRequestId() {
        return this.requestId;
    }

    public FastCgiRequest(int requestId, @NotNull ByteBufAllocator allocator) {
        Intrinsics.checkParameterIsNotNull((Object)allocator, (String)"allocator");
        this.requestId = requestId;
        this.params = allocator.ioBuffer(4096);
    }
}

