/*
 * This declarations of the PIC16LF1773 MCU.
 *
 * This file is part of the GNU PIC library for SDCC, originally
 * created by Molnar Karoly <molnarkaroly@users.sf.net> 2016.
 *
 * This file is generated automatically by the cinc2h.pl, 2016-04-13 17:23:15 UTC.
 *
 * SDCC is licensed under the GNU Public license (GPL) v2. Note that
 * this license covers the code to the compiler and other executables,
 * but explicitly does not cover any code or objects generated by sdcc.
 *
 * For pic device libraries and header files which are derived from
 * Microchip header (.inc) and linker script (.lkr) files Microchip
 * requires that "The header files should state that they are only to be
 * used with authentic Microchip devices" which makes them incompatible
 * with the GPL. Pic device libraries and header files are located at
 * non-free/lib and non-free/include directories respectively.
 * Sdcc should be run with the --use-non-free command line option in
 * order to include non-free header files and libraries.
 *
 * See http://sdcc.sourceforge.net/ for the latest information on sdcc.
 */

#ifndef __PIC16LF1773_H__
#define __PIC16LF1773_H__

//==============================================================================
//
//	Register Addresses
//
//==============================================================================

#ifndef NO_ADDR_DEFINES

#define INDF0_ADDR              0x0000
#define INDF1_ADDR              0x0001
#define PCL_ADDR                0x0002
#define STATUS_ADDR             0x0003
#define FSR0_ADDR               0x0004
#define FSR0L_ADDR              0x0004
#define FSR0H_ADDR              0x0005
#define FSR1_ADDR               0x0006
#define FSR1L_ADDR              0x0006
#define FSR1H_ADDR              0x0007
#define BSR_ADDR                0x0008
#define WREG_ADDR               0x0009
#define PCLATH_ADDR             0x000A
#define INTCON_ADDR             0x000B
#define PORTA_ADDR              0x000C
#define PORTB_ADDR              0x000D
#define PORTC_ADDR              0x000E
#define PORTE_ADDR              0x0010
#define PIR1_ADDR               0x0011
#define PIR2_ADDR               0x0012
#define PIR3_ADDR               0x0013
#define PIR4_ADDR               0x0014
#define PIR5_ADDR               0x0015
#define PIR6_ADDR               0x0016
#define TMR0_ADDR               0x0017
#define TMR1_ADDR               0x0018
#define TMR1L_ADDR              0x0018
#define TMR1H_ADDR              0x0019
#define T1CON_ADDR              0x001A
#define T1GCON_ADDR             0x001B
#define TMR3_ADDR               0x001C
#define TMR3L_ADDR              0x001C
#define TMR3H_ADDR              0x001D
#define T3CON_ADDR              0x001E
#define T3GCON_ADDR             0x001F
#define TRISA_ADDR              0x008C
#define TRISB_ADDR              0x008D
#define TRISC_ADDR              0x008E
#define TRISE_ADDR              0x0090
#define PIE1_ADDR               0x0091
#define PIE2_ADDR               0x0092
#define PIE3_ADDR               0x0093
#define PIE4_ADDR               0x0094
#define PIE5_ADDR               0x0095
#define PIE6_ADDR               0x0096
#define OPTION_REG_ADDR         0x0097
#define PCON_ADDR               0x0098
#define WDTCON_ADDR             0x0099
#define OSCTUNE_ADDR            0x009A
#define OSCCON_ADDR             0x009B
#define OSCSTAT_ADDR            0x009C
#define BORCON_ADDR             0x009D
#define FVRCON_ADDR             0x009E
#define ZCD1CON_ADDR            0x009F
#define LATA_ADDR               0x010C
#define LATB_ADDR               0x010D
#define LATC_ADDR               0x010E
#define CMOUT_ADDR              0x0111
#define CM1CON0_ADDR            0x0112
#define CM1CON1_ADDR            0x0113
#define CM1NSEL_ADDR            0x0114
#define CM1PSEL_ADDR            0x0115
#define CM2CON0_ADDR            0x0116
#define CM2CON1_ADDR            0x0117
#define CM2NSEL_ADDR            0x0118
#define CM2PSEL_ADDR            0x0119
#define CM3CON0_ADDR            0x011A
#define CM3CON1_ADDR            0x011B
#define CM3NSEL_ADDR            0x011C
#define CM3PSEL_ADDR            0x011D
#define ANSELA_ADDR             0x018C
#define ANSELB_ADDR             0x018D
#define ANSELC_ADDR             0x018E
#define PMADR_ADDR              0x0191
#define PMADRL_ADDR             0x0191
#define PMADRH_ADDR             0x0192
#define PMDAT_ADDR              0x0193
#define PMDATL_ADDR             0x0193
#define PMDATH_ADDR             0x0194
#define PMCON1_ADDR             0x0195
#define PMCON2_ADDR             0x0196
#define RC1REG_ADDR             0x0199
#define RCREG_ADDR              0x0199
#define RCREG1_ADDR             0x0199
#define TX1REG_ADDR             0x019A
#define TXREG_ADDR              0x019A
#define TXREG1_ADDR             0x019A
#define SP1BRG_ADDR             0x019B
#define SP1BRGL_ADDR            0x019B
#define SPBRG_ADDR              0x019B
#define SPBRG1_ADDR             0x019B
#define SPBRGL_ADDR             0x019B
#define SP1BRGH_ADDR            0x019C
#define SPBRGH_ADDR             0x019C
#define SPBRGH1_ADDR            0x019C
#define RC1STA_ADDR             0x019D
#define RCSTA_ADDR              0x019D
#define RCSTA1_ADDR             0x019D
#define TX1STA_ADDR             0x019E
#define TXSTA_ADDR              0x019E
#define TXSTA1_ADDR             0x019E
#define BAUD1CON_ADDR           0x019F
#define BAUDCON_ADDR            0x019F
#define BAUDCON1_ADDR           0x019F
#define BAUDCTL_ADDR            0x019F
#define BAUDCTL1_ADDR           0x019F
#define WPUA_ADDR               0x020C
#define WPUB_ADDR               0x020D
#define WPUC_ADDR               0x020E
#define WPUE_ADDR               0x0210
#define SSP1BUF_ADDR            0x0211
#define SSPBUF_ADDR             0x0211
#define SSP1ADD_ADDR            0x0212
#define SSPADD_ADDR             0x0212
#define SSP1MSK_ADDR            0x0213
#define SSPMSK_ADDR             0x0213
#define SSP1STAT_ADDR           0x0214
#define SSPSTAT_ADDR            0x0214
#define SSP1CON_ADDR            0x0215
#define SSP1CON1_ADDR           0x0215
#define SSPCON_ADDR             0x0215
#define SSPCON1_ADDR            0x0215
#define SSP1CON2_ADDR           0x0216
#define SSPCON2_ADDR            0x0216
#define SSP1CON3_ADDR           0x0217
#define SSPCON3_ADDR            0x0217
#define MD3CON0_ADDR            0x021B
#define MD3CON1_ADDR            0x021C
#define MD3SRC_ADDR             0x021D
#define MD3CARL_ADDR            0x021E
#define MD3CARH_ADDR            0x021F
#define ODCONA_ADDR             0x028C
#define ODCONB_ADDR             0x028D
#define ODCONC_ADDR             0x028E
#define CCPR1_ADDR              0x0291
#define CCPR1L_ADDR             0x0291
#define CCPR1H_ADDR             0x0292
#define CCP1CON_ADDR            0x0293
#define CCP1CAP_ADDR            0x0294
#define CCPR2_ADDR              0x0295
#define CCPR2L_ADDR             0x0295
#define CCPR2H_ADDR             0x0296
#define CCP2CON_ADDR            0x0297
#define CCP2CAP_ADDR            0x0298
#define CCPR7_ADDR              0x0299
#define CCPR7L_ADDR             0x0299
#define CCPR7H_ADDR             0x029A
#define CCP7CON_ADDR            0x029B
#define CCP7CAP_ADDR            0x029C
#define CCPTMRS1_ADDR           0x029E
#define CCPTMRS2_ADDR           0x029F
#define SLRCONA_ADDR            0x030C
#define SLRCONB_ADDR            0x030D
#define SLRCONC_ADDR            0x030E
#define MD1CON0_ADDR            0x0315
#define MD1CON1_ADDR            0x0316
#define MD1SRC_ADDR             0x0317
#define MD1CARL_ADDR            0x0318
#define MD1CARH_ADDR            0x0319
#define MD2CON0_ADDR            0x031B
#define MD2CON1_ADDR            0x031C
#define MD2SRC_ADDR             0x031D
#define MD2CARL_ADDR            0x031E
#define MD2CARH_ADDR            0x031F
#define INLVLA_ADDR             0x038C
#define INLVLB_ADDR             0x038D
#define INLVLC_ADDR             0x038E
#define INLVE_ADDR              0x0390
#define IOCAP_ADDR              0x0391
#define IOCAN_ADDR              0x0392
#define IOCAF_ADDR              0x0393
#define IOCBP_ADDR              0x0394
#define IOCBN_ADDR              0x0395
#define IOCBF_ADDR              0x0396
#define IOCCP_ADDR              0x0397
#define IOCCN_ADDR              0x0398
#define IOCCF_ADDR              0x0399
#define IOCEP_ADDR              0x039D
#define IOCEN_ADDR              0x039E
#define IOCEF_ADDR              0x039F
#define HIDRVB_ADDR             0x040D
#define TMR5_ADDR               0x040F
#define TMR5L_ADDR              0x040F
#define TMR5H_ADDR              0x0410
#define T5CON_ADDR              0x0411
#define T5GCON_ADDR             0x0412
#define T4TMR_ADDR              0x0413
#define TMR4_ADDR               0x0413
#define PR4_ADDR                0x0414
#define T4PR_ADDR               0x0414
#define T4CON_ADDR              0x0415
#define T4HLT_ADDR              0x0416
#define T4CLKCON_ADDR           0x0417
#define T4RST_ADDR              0x0418
#define T6TMR_ADDR              0x041A
#define TMR6_ADDR               0x041A
#define PR6_ADDR                0x041B
#define T6PR_ADDR               0x041B
#define T6CON_ADDR              0x041C
#define T6HLT_ADDR              0x041D
#define T6CLKCON_ADDR           0x041E
#define T6RST_ADDR              0x041F
#define ADRESL_ADDR             0x048E
#define ADRESH_ADDR             0x048F
#define ADCON0_ADDR             0x0490
#define ADCON1_ADDR             0x0491
#define ADCON2_ADDR             0x0492
#define T2TMR_ADDR              0x0493
#define TMR2_ADDR               0x0493
#define PR2_ADDR                0x0494
#define T2PR_ADDR               0x0494
#define T2CON_ADDR              0x0495
#define T2HLT_ADDR              0x0496
#define T2CLKCON_ADDR           0x0497
#define T2RST_ADDR              0x0498
#define T8TMR_ADDR              0x049A
#define TMR8_ADDR               0x049A
#define PR8_ADDR                0x049B
#define T8PR_ADDR               0x049B
#define T8CON_ADDR              0x049C
#define T8HLT_ADDR              0x049D
#define T8CLKCON_ADDR           0x049E
#define T8RST_ADDR              0x049F
#define OPA1NCHS_ADDR           0x050F
#define OPA1PCHS_ADDR           0x0510
#define OPA1CON_ADDR            0x0511
#define OPA1ORS_ADDR            0x0512
#define OPA2NCHS_ADDR           0x0513
#define OPA2PCHS_ADDR           0x0514
#define OPA2CON_ADDR            0x0515
#define OPA2ORS_ADDR            0x0516
#define OPA3NCHS_ADDR           0x0517
#define OPA3PCHS_ADDR           0x0518
#define OPA3CON_ADDR            0x0519
#define OPA3ORS_ADDR            0x051A
#define DACLD_ADDR              0x058D
#define DAC1CON0_ADDR           0x058E
#define DAC1CON1_ADDR           0x058F
#define DAC1REF_ADDR            0x058F
#define DAC1REFL_ADDR           0x058F
#define DAC1CON2_ADDR           0x0590
#define DAC1REFH_ADDR           0x0590
#define DAC2CON0_ADDR           0x0591
#define DAC2CON1_ADDR           0x0592
#define DAC2REF_ADDR            0x0592
#define DAC2REFL_ADDR           0x0592
#define DAC2CON2_ADDR           0x0593
#define DAC2REFH_ADDR           0x0593
#define DAC3CON0_ADDR           0x0594
#define DAC3CON1_ADDR           0x0595
#define DAC3REF_ADDR            0x0595
#define DAC4CON0_ADDR           0x0596
#define DAC4CON1_ADDR           0x0597
#define DAC4REF_ADDR            0x0597
#define DAC5CON0_ADDR           0x0598
#define DAC5CON1_ADDR           0x0599
#define DAC5REF_ADDR            0x0599
#define DAC5REFL_ADDR           0x0599
#define DAC5CON2_ADDR           0x059A
#define DAC5REFH_ADDR           0x059A
#define DAC7CON0_ADDR           0x059E
#define DAC7CON1_ADDR           0x059F
#define DAC7REF_ADDR            0x059F
#define PWM3DCL_ADDR            0x0614
#define PWM3DCH_ADDR            0x0615
#define PWM3CON_ADDR            0x0616
#define PWM4DCL_ADDR            0x0617
#define PWM4DCH_ADDR            0x0618
#define PWM4CON_ADDR            0x0619
#define PWM9DCL_ADDR            0x061A
#define PWM9DCH_ADDR            0x061B
#define PWM9CON_ADDR            0x061C
#define COG1PHR_ADDR            0x068D
#define COG1PHF_ADDR            0x068E
#define COG1BLKR_ADDR           0x068F
#define COG1BLKF_ADDR           0x0690
#define COG1DBR_ADDR            0x0691
#define COG1DBF_ADDR            0x0692
#define COG1CON0_ADDR           0x0693
#define COG1CON1_ADDR           0x0694
#define COG1RIS0_ADDR           0x0695
#define COG1RIS1_ADDR           0x0696
#define COG1RSIM0_ADDR          0x0697
#define COG1RSIM1_ADDR          0x0698
#define COG1FIS0_ADDR           0x0699
#define COG1FIS1_ADDR           0x069A
#define COG1FSIM0_ADDR          0x069B
#define COG1FSIM1_ADDR          0x069C
#define COG1ASD0_ADDR           0x069D
#define COG1ASD1_ADDR           0x069E
#define COG1STR_ADDR            0x069F
#define COG2PHR_ADDR            0x070D
#define COG2PHF_ADDR            0x070E
#define COG2BLKR_ADDR           0x070F
#define COG2BLKF_ADDR           0x0710
#define COG2DBR_ADDR            0x0711
#define COG2DBF_ADDR            0x0712
#define COG2CON0_ADDR           0x0713
#define COG2CON1_ADDR           0x0714
#define COG2RIS0_ADDR           0x0715
#define COG2RIS1_ADDR           0x0716
#define COG2RSIM0_ADDR          0x0717
#define COG2RSIM1_ADDR          0x0718
#define COG2FIS0_ADDR           0x0719
#define COG2FIS1_ADDR           0x071A
#define COG2FSIM0_ADDR          0x071B
#define COG2FSIM1_ADDR          0x071C
#define COG2ASD0_ADDR           0x071D
#define COG2ASD1_ADDR           0x071E
#define COG2STR_ADDR            0x071F
#define PRG1RTSS_ADDR           0x078E
#define PRG1FTSS_ADDR           0x078F
#define PRG1INS_ADDR            0x0790
#define PRG1CON0_ADDR           0x0791
#define PRG1CON1_ADDR           0x0792
#define PRG1CON2_ADDR           0x0793
#define PRG2RTSS_ADDR           0x0794
#define PRG2FTSS_ADDR           0x0795
#define PRG2INS_ADDR            0x0796
#define PRG2CON0_ADDR           0x0797
#define PRG2CON1_ADDR           0x0798
#define PRG2CON2_ADDR           0x0799
#define PRG3RTSS_ADDR           0x079A
#define PRG3FTSS_ADDR           0x079B
#define PRG3INS_ADDR            0x079C
#define PRG3CON0_ADDR           0x079D
#define PRG3CON1_ADDR           0x079E
#define PRG3CON2_ADDR           0x079F
#define COG3PHR_ADDR            0x080D
#define COG3PHF_ADDR            0x080E
#define COG3BLKR_ADDR           0x080F
#define COG3BLKF_ADDR           0x0810
#define COG3DBR_ADDR            0x0811
#define COG3DBF_ADDR            0x0812
#define COG3CON0_ADDR           0x0813
#define COG3CON1_ADDR           0x0814
#define COG3RIS0_ADDR           0x0815
#define COG3RIS1_ADDR           0x0816
#define COG3RSIM0_ADDR          0x0817
#define COG3RSIM1_ADDR          0x0818
#define COG3FIS0_ADDR           0x0819
#define COG3FIS1_ADDR           0x081A
#define COG3FSIM0_ADDR          0x081B
#define COG3FSIM1_ADDR          0x081C
#define COG3ASD0_ADDR           0x081D
#define COG3ASD1_ADDR           0x081E
#define COG3STR_ADDR            0x081F
#define CM4CON0_ADDR            0x090C
#define CM4CON1_ADDR            0x090D
#define CM4NSEL_ADDR            0x090E
#define CM4PSEL_ADDR            0x090F
#define CM5CON0_ADDR            0x0910
#define CM5CON1_ADDR            0x0911
#define CM5NSEL_ADDR            0x0912
#define CM5PSEL_ADDR            0x0913
#define CM6CON0_ADDR            0x0914
#define CM6CON1_ADDR            0x0915
#define CM6NSEL_ADDR            0x0916
#define CM6PSEL_ADDR            0x0917
#define PWMEN_ADDR              0x0D8E
#define PWMLD_ADDR              0x0D8F
#define PWMOUT_ADDR             0x0D90
#define PWM5PH_ADDR             0x0D91
#define PWM5PHL_ADDR            0x0D91
#define PWM5PHH_ADDR            0x0D92
#define PWM5DC_ADDR             0x0D93
#define PWM5DCL_ADDR            0x0D93
#define PWM5DCH_ADDR            0x0D94
#define PWM5PR_ADDR             0x0D95
#define PWM5PRL_ADDR            0x0D95
#define PWM5PRH_ADDR            0x0D96
#define PWM5OF_ADDR             0x0D97
#define PWM5OFL_ADDR            0x0D97
#define PWM5OFH_ADDR            0x0D98
#define PWM5TMR_ADDR            0x0D99
#define PWM5TMRL_ADDR           0x0D99
#define PWM5TMRH_ADDR           0x0D9A
#define PWM5CON_ADDR            0x0D9B
#define PWM5INTCON_ADDR         0x0D9C
#define PWM5INTE_ADDR           0x0D9C
#define PWM5INTF_ADDR           0x0D9D
#define PWM5INTFLG_ADDR         0x0D9D
#define PWM5CLKCON_ADDR         0x0D9E
#define PWM5LDCON_ADDR          0x0D9F
#define PWM5OFCON_ADDR          0x0DA0
#define PWM6PH_ADDR             0x0DA1
#define PWM6PHL_ADDR            0x0DA1
#define PWM6PHH_ADDR            0x0DA2
#define PWM6DC_ADDR             0x0DA3
#define PWM6DCL_ADDR            0x0DA3
#define PWM6DCH_ADDR            0x0DA4
#define PWM6PR_ADDR             0x0DA5
#define PWM6PRL_ADDR            0x0DA5
#define PWM6PRH_ADDR            0x0DA6
#define PWM6OF_ADDR             0x0DA7
#define PWM6OFL_ADDR            0x0DA7
#define PWM6OFH_ADDR            0x0DA8
#define PWM6TMR_ADDR            0x0DA9
#define PWM6TMRL_ADDR           0x0DA9
#define PWM6TMRH_ADDR           0x0DAA
#define PWM6CON_ADDR            0x0DAB
#define PWM6INTCON_ADDR         0x0DAC
#define PWM6INTE_ADDR           0x0DAC
#define PWM6INTF_ADDR           0x0DAD
#define PWM6INTFLG_ADDR         0x0DAD
#define PWM6CLKCON_ADDR         0x0DAE
#define PWM6LDCON_ADDR          0x0DAF
#define PWM6OFCON_ADDR          0x0DB0
#define PWM11PH_ADDR            0x0DB1
#define PWM11PHL_ADDR           0x0DB1
#define PWM11PHH_ADDR           0x0DB2
#define PWM11DC_ADDR            0x0DB3
#define PWM11DCL_ADDR           0x0DB3
#define PWM11DCH_ADDR           0x0DB4
#define PWM11PR_ADDR            0x0DB5
#define PWM11PRL_ADDR           0x0DB5
#define PWM11PRH_ADDR           0x0DB6
#define PWM11OF_ADDR            0x0DB7
#define PWM11OFL_ADDR           0x0DB7
#define PWM11OFH_ADDR           0x0DB8
#define PWM11TMR_ADDR           0x0DB9
#define PWM11TMRL_ADDR          0x0DB9
#define PWM11TMRH_ADDR          0x0DBA
#define PWM11CON_ADDR           0x0DBB
#define PWM11INTCON_ADDR        0x0DBC
#define PWM11INTE_ADDR          0x0DBC
#define PWM11INTF_ADDR          0x0DBD
#define PWM11INTFLG_ADDR        0x0DBD
#define PWM11CLKCON_ADDR        0x0DBE
#define PWM11LDCON_ADDR         0x0DBF
#define PWM11OFCON_ADDR         0x0DC0
#define PPSLOCK_ADDR            0x0E0C
#define INTPPS_ADDR             0x0E0D
#define T0CKIPPS_ADDR           0x0E0E
#define T1CKIPPS_ADDR           0x0E0F
#define T1GPPS_ADDR             0x0E10
#define T3CKIPPS_ADDR           0x0E11
#define T3GPPS_ADDR             0x0E12
#define T5CKIPPS_ADDR           0x0E13
#define T5GPPS_ADDR             0x0E14
#define T2CKIPPS_ADDR           0x0E15
#define T4CKIPPS_ADDR           0x0E16
#define T6CKIPPS_ADDR           0x0E17
#define T8CKIPPS_ADDR           0x0E18
#define CCP1PPS_ADDR            0x0E19
#define CCP2PPS_ADDR            0x0E1A
#define CCP7PPS_ADDR            0x0E1B
#define COG1INPPS_ADDR          0x0E1D
#define COG2INPPS_ADDR          0x0E1E
#define COG3INPPS_ADDR          0x0E1F
#define MD1CLPPS_ADDR           0x0E21
#define MD1CHPPS_ADDR           0x0E22
#define MD1MODPPS_ADDR          0x0E23
#define MD2CLPPS_ADDR           0x0E24
#define MD2CHPPS_ADDR           0x0E25
#define MD2MODPPS_ADDR          0x0E26
#define MD3CLPPS_ADDR           0x0E27
#define MD3CHPPS_ADDR           0x0E28
#define MD3MODPPS_ADDR          0x0E29
#define PRG1RPPS_ADDR           0x0E2D
#define PRG1FPPS_ADDR           0x0E2E
#define PRG2RPPS_ADDR           0x0E2F
#define PRG2FPPS_ADDR           0x0E30
#define PRG3RPPS_ADDR           0x0E31
#define PRG3FPPS_ADDR           0x0E32
#define CLCIN0PPS_ADDR          0x0E35
#define CLCIN1PPS_ADDR          0x0E36
#define CLCIN2PPS_ADDR          0x0E37
#define CLCIN3PPS_ADDR          0x0E38
#define ADCACTPPS_ADDR          0x0E39
#define SSPCLKPPS_ADDR          0x0E3A
#define SSPDATPPS_ADDR          0x0E3B
#define SSPSSPPS_ADDR           0x0E3C
#define RXPPS_ADDR              0x0E3D
#define CKPPS_ADDR              0x0E3E
#define RA0PPS_ADDR             0x0E90
#define RA1PPS_ADDR             0x0E91
#define RA2PPS_ADDR             0x0E92
#define RA3PPS_ADDR             0x0E93
#define RA4PPS_ADDR             0x0E94
#define RA5PPS_ADDR             0x0E95
#define RA6PPS_ADDR             0x0E96
#define RA7PPS_ADDR             0x0E97
#define RB0PPS_ADDR             0x0E98
#define RB1PPS_ADDR             0x0E99
#define RB2PPS_ADDR             0x0E9A
#define RB3PPS_ADDR             0x0E9B
#define RB4PPS_ADDR             0x0E9C
#define RB5PPS_ADDR             0x0E9D
#define RB6PPS_ADDR             0x0E9E
#define RB7PPS_ADDR             0x0E9F
#define RC0PPS_ADDR             0x0EA0
#define RC1PPS_ADDR             0x0EA1
#define RC2PPS_ADDR             0x0EA2
#define RC3PPS_ADDR             0x0EA3
#define RC4PPS_ADDR             0x0EA4
#define RC5PPS_ADDR             0x0EA5
#define RC6PPS_ADDR             0x0EA6
#define RC7PPS_ADDR             0x0EA7
#define CLCDATA_ADDR            0x0F0F
#define CLC1CON_ADDR            0x0F10
#define CLC1POL_ADDR            0x0F11
#define CLC1SEL0_ADDR           0x0F12
#define CLC1SEL1_ADDR           0x0F13
#define CLC1SEL2_ADDR           0x0F14
#define CLC1SEL3_ADDR           0x0F15
#define CLC1GLS0_ADDR           0x0F16
#define CLC1GLS1_ADDR           0x0F17
#define CLC1GLS2_ADDR           0x0F18
#define CLC1GLS3_ADDR           0x0F19
#define CLC2CON_ADDR            0x0F1A
#define CLC2POL_ADDR            0x0F1B
#define CLC2SEL0_ADDR           0x0F1C
#define CLC2SEL1_ADDR           0x0F1D
#define CLC2SEL2_ADDR           0x0F1E
#define CLC2SEL3_ADDR           0x0F1F
#define CLC2GLS0_ADDR           0x0F20
#define CLC2GLS1_ADDR           0x0F21
#define CLC2GLS2_ADDR           0x0F22
#define CLC2GLS3_ADDR           0x0F23
#define CLC3CON_ADDR            0x0F24
#define CLC3POL_ADDR            0x0F25
#define CLC3SEL0_ADDR           0x0F26
#define CLC3SEL1_ADDR           0x0F27
#define CLC3SEL2_ADDR           0x0F28
#define CLC3SEL3_ADDR           0x0F29
#define CLC3GLS0_ADDR           0x0F2A
#define CLC3GLS1_ADDR           0x0F2B
#define CLC3GLS2_ADDR           0x0F2C
#define CLC3GLS3_ADDR           0x0F2D
#define CLC4CON_ADDR            0x0F2E
#define CLC4POL_ADDR            0x0F2F
#define CLC4SEL0_ADDR           0x0F30
#define CLC4SEL1_ADDR           0x0F31
#define CLC4SEL2_ADDR           0x0F32
#define CLC4SEL3_ADDR           0x0F33
#define CLC4GLS0_ADDR           0x0F34
#define CLC4GLS1_ADDR           0x0F35
#define CLC4GLS2_ADDR           0x0F36
#define CLC4GLS3_ADDR           0x0F37
#define STATUS_SHAD_ADDR        0x0FE4
#define WREG_SHAD_ADDR          0x0FE5
#define BSR_SHAD_ADDR           0x0FE6
#define PCLATH_SHAD_ADDR        0x0FE7
#define FSR0L_SHAD_ADDR         0x0FE8
#define FSR0H_SHAD_ADDR         0x0FE9
#define FSR1L_SHAD_ADDR         0x0FEA
#define FSR1H_SHAD_ADDR         0x0FEB
#define STKPTR_ADDR             0x0FED
#define TOSL_ADDR               0x0FEE
#define TOSH_ADDR               0x0FEF

#endif // #ifndef NO_ADDR_DEFINES

//==============================================================================
//
//	Register Definitions
//
//==============================================================================

extern __at(0x0000) __sfr INDF0;
extern __at(0x0001) __sfr INDF1;
extern __at(0x0002) __sfr PCL;

//==============================================================================
//        STATUS Bits

extern __at(0x0003) __sfr STATUS;

typedef struct
  {
  unsigned C                    : 1;
  unsigned DC                   : 1;
  unsigned Z                    : 1;
  unsigned NOT_PD               : 1;
  unsigned NOT_TO               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __STATUSbits_t;

extern __at(0x0003) volatile __STATUSbits_t STATUSbits;

#define _C                      0x01
#define _DC                     0x02
#define _Z                      0x04
#define _NOT_PD                 0x08
#define _NOT_TO                 0x10

//==============================================================================

extern __at(0x0004) __sfr FSR0;
extern __at(0x0004) __sfr FSR0L;
extern __at(0x0005) __sfr FSR0H;
extern __at(0x0006) __sfr FSR1;
extern __at(0x0006) __sfr FSR1L;
extern __at(0x0007) __sfr FSR1H;

//==============================================================================
//        BSR Bits

extern __at(0x0008) __sfr BSR;

typedef union
  {
  struct
    {
    unsigned BSR0               : 1;
    unsigned BSR1               : 1;
    unsigned BSR2               : 1;
    unsigned BSR3               : 1;
    unsigned BSR4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned BSR                : 5;
    unsigned                    : 3;
    };
  } __BSRbits_t;

extern __at(0x0008) volatile __BSRbits_t BSRbits;

#define _BSR0                   0x01
#define _BSR1                   0x02
#define _BSR2                   0x04
#define _BSR3                   0x08
#define _BSR4                   0x10

//==============================================================================

extern __at(0x0009) __sfr WREG;
extern __at(0x000A) __sfr PCLATH;

//==============================================================================
//        INTCON Bits

extern __at(0x000B) __sfr INTCON;

typedef union
  {
  struct
    {
    unsigned IOCIF              : 1;
    unsigned INTF               : 1;
    unsigned TMR0IF             : 1;
    unsigned IOCIE              : 1;
    unsigned INTE               : 1;
    unsigned TMR0IE             : 1;
    unsigned PEIE               : 1;
    unsigned GIE                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0IF               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0IE               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __INTCONbits_t;

extern __at(0x000B) volatile __INTCONbits_t INTCONbits;

#define _IOCIF                  0x01
#define _INTF                   0x02
#define _TMR0IF                 0x04
#define _T0IF                   0x04
#define _IOCIE                  0x08
#define _INTE                   0x10
#define _TMR0IE                 0x20
#define _T0IE                   0x20
#define _PEIE                   0x40
#define _GIE                    0x80

//==============================================================================


//==============================================================================
//        PORTA Bits

extern __at(0x000C) __sfr PORTA;

typedef struct
  {
  unsigned RA0                  : 1;
  unsigned RA1                  : 1;
  unsigned RA2                  : 1;
  unsigned RA3                  : 1;
  unsigned RA4                  : 1;
  unsigned RA5                  : 1;
  unsigned RA6                  : 1;
  unsigned RA7                  : 1;
  } __PORTAbits_t;

extern __at(0x000C) volatile __PORTAbits_t PORTAbits;

#define _RA0                    0x01
#define _RA1                    0x02
#define _RA2                    0x04
#define _RA3                    0x08
#define _RA4                    0x10
#define _RA5                    0x20
#define _RA6                    0x40
#define _RA7                    0x80

//==============================================================================


//==============================================================================
//        PORTB Bits

extern __at(0x000D) __sfr PORTB;

typedef struct
  {
  unsigned RB0                  : 1;
  unsigned RB1                  : 1;
  unsigned RB2                  : 1;
  unsigned RB3                  : 1;
  unsigned RB4                  : 1;
  unsigned RB5                  : 1;
  unsigned RB6                  : 1;
  unsigned RB7                  : 1;
  } __PORTBbits_t;

extern __at(0x000D) volatile __PORTBbits_t PORTBbits;

#define _RB0                    0x01
#define _RB1                    0x02
#define _RB2                    0x04
#define _RB3                    0x08
#define _RB4                    0x10
#define _RB5                    0x20
#define _RB6                    0x40
#define _RB7                    0x80

//==============================================================================


//==============================================================================
//        PORTC Bits

extern __at(0x000E) __sfr PORTC;

typedef struct
  {
  unsigned RC0                  : 1;
  unsigned RC1                  : 1;
  unsigned RC2                  : 1;
  unsigned RC3                  : 1;
  unsigned RC4                  : 1;
  unsigned RC5                  : 1;
  unsigned RC6                  : 1;
  unsigned RC7                  : 1;
  } __PORTCbits_t;

extern __at(0x000E) volatile __PORTCbits_t PORTCbits;

#define _RC0                    0x01
#define _RC1                    0x02
#define _RC2                    0x04
#define _RC3                    0x08
#define _RC4                    0x10
#define _RC5                    0x20
#define _RC6                    0x40
#define _RC7                    0x80

//==============================================================================


//==============================================================================
//        PORTE Bits

extern __at(0x0010) __sfr PORTE;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned RE3                  : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PORTEbits_t;

extern __at(0x0010) volatile __PORTEbits_t PORTEbits;

#define _RE3                    0x08

//==============================================================================


//==============================================================================
//        PIR1 Bits

extern __at(0x0011) __sfr PIR1;

typedef union
  {
  struct
    {
    unsigned TMR1IF             : 1;
    unsigned TMR2IF             : 1;
    unsigned CCP1IF             : 1;
    unsigned SSP1IF             : 1;
    unsigned TXIF               : 1;
    unsigned RCIF               : 1;
    unsigned ADIF               : 1;
    unsigned TMR1GIF            : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCPIF              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PIR1bits_t;

extern __at(0x0011) volatile __PIR1bits_t PIR1bits;

#define _TMR1IF                 0x01
#define _TMR2IF                 0x02
#define _CCP1IF                 0x04
#define _CCPIF                  0x04
#define _SSP1IF                 0x08
#define _TXIF                   0x10
#define _RCIF                   0x20
#define _ADIF                   0x40
#define _TMR1GIF                0x80

//==============================================================================


//==============================================================================
//        PIR2 Bits

extern __at(0x0012) __sfr PIR2;

typedef struct
  {
  unsigned CCP2IF               : 1;
  unsigned C3IF                 : 1;
  unsigned C4IF                 : 1;
  unsigned BCL1IF               : 1;
  unsigned COG1IF               : 1;
  unsigned C1IF                 : 1;
  unsigned C2IF                 : 1;
  unsigned OSFIF                : 1;
  } __PIR2bits_t;

extern __at(0x0012) volatile __PIR2bits_t PIR2bits;

#define _CCP2IF                 0x01
#define _C3IF                   0x02
#define _C4IF                   0x04
#define _BCL1IF                 0x08
#define _COG1IF                 0x10
#define _C1IF                   0x20
#define _C2IF                   0x40
#define _OSFIF                  0x80

//==============================================================================


//==============================================================================
//        PIR3 Bits

extern __at(0x0013) __sfr PIR3;

typedef struct
  {
  unsigned CLC1IF               : 1;
  unsigned CLC2IF               : 1;
  unsigned CLC3IF               : 1;
  unsigned CLC4IF               : 1;
  unsigned ZCDIF                : 1;
  unsigned COG2IF               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIR3bits_t;

extern __at(0x0013) volatile __PIR3bits_t PIR3bits;

#define _CLC1IF                 0x01
#define _CLC2IF                 0x02
#define _CLC3IF                 0x04
#define _CLC4IF                 0x08
#define _ZCDIF                  0x10
#define _COG2IF                 0x20

//==============================================================================


//==============================================================================
//        PIR4 Bits

extern __at(0x0014) __sfr PIR4;

typedef struct
  {
  unsigned TMR4IF               : 1;
  unsigned TMR6IF               : 1;
  unsigned TMR3IF               : 1;
  unsigned TMR3GIF              : 1;
  unsigned TMR5IF               : 1;
  unsigned TMR5GIF              : 1;
  unsigned TMR8IF               : 1;
  unsigned                      : 1;
  } __PIR4bits_t;

extern __at(0x0014) volatile __PIR4bits_t PIR4bits;

#define _TMR4IF                 0x01
#define _TMR6IF                 0x02
#define _TMR3IF                 0x04
#define _TMR3GIF                0x08
#define _TMR5IF                 0x10
#define _TMR5GIF                0x20
#define _TMR8IF                 0x40

//==============================================================================


//==============================================================================
//        PIR5 Bits

extern __at(0x0015) __sfr PIR5;

typedef struct
  {
  unsigned C5IF                 : 1;
  unsigned C6IF                 : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned COG3IF               : 1;
  unsigned                      : 1;
  unsigned CCP7IF               : 1;
  unsigned                      : 1;
  } __PIR5bits_t;

extern __at(0x0015) volatile __PIR5bits_t PIR5bits;

#define _C5IF                   0x01
#define _C6IF                   0x02
#define _COG3IF                 0x10
#define _CCP7IF                 0x40

//==============================================================================


//==============================================================================
//        PIR6 Bits

extern __at(0x0016) __sfr PIR6;

typedef struct
  {
  unsigned PWM5IF               : 1;
  unsigned PWM6IF               : 1;
  unsigned PWM11IF              : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIR6bits_t;

extern __at(0x0016) volatile __PIR6bits_t PIR6bits;

#define _PWM5IF                 0x01
#define _PWM6IF                 0x02
#define _PWM11IF                0x04

//==============================================================================

extern __at(0x0017) __sfr TMR0;
extern __at(0x0018) __sfr TMR1;
extern __at(0x0018) __sfr TMR1L;
extern __at(0x0019) __sfr TMR1H;

//==============================================================================
//        T1CON Bits

extern __at(0x001A) __sfr T1CON;

typedef union
  {
  struct
    {
    unsigned ON                 : 1;
    unsigned                    : 1;
    unsigned NOT_SYNC           : 1;
    unsigned OSCEN              : 1;
    unsigned CKPS0              : 1;
    unsigned CKPS1              : 1;
    unsigned CS0                : 1;
    unsigned CS1                : 1;
    };

  struct
    {
    unsigned TMRON              : 1;
    unsigned                    : 1;
    unsigned SYNC               : 1;
    unsigned SOSCEN             : 1;
    unsigned T1CKPS0            : 1;
    unsigned T1CKPS1            : 1;
    unsigned T1CS0              : 1;
    unsigned T1CS1              : 1;
    };

  struct
    {
    unsigned TMR1ON             : 1;
    unsigned                    : 1;
    unsigned NOT_T1SYNC         : 1;
    unsigned T1OSCEN            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TMR1CS0            : 1;
    unsigned TMR1CS1            : 1;
    };

  struct
    {
    unsigned T1ON               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T1CKPS             : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 4;
    unsigned CKPS               : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned CS                 : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned T1CS               : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned TMR1CS             : 2;
    };
  } __T1CONbits_t;

extern __at(0x001A) volatile __T1CONbits_t T1CONbits;

#define _T1CON_ON               0x01
#define _T1CON_TMRON            0x01
#define _T1CON_TMR1ON           0x01
#define _T1CON_T1ON             0x01
#define _T1CON_NOT_SYNC         0x04
#define _T1CON_SYNC             0x04
#define _T1CON_NOT_T1SYNC       0x04
#define _T1CON_OSCEN            0x08
#define _T1CON_SOSCEN           0x08
#define _T1CON_T1OSCEN          0x08
#define _T1CON_CKPS0            0x10
#define _T1CON_T1CKPS0          0x10
#define _T1CON_CKPS1            0x20
#define _T1CON_T1CKPS1          0x20
#define _T1CON_CS0              0x40
#define _T1CON_T1CS0            0x40
#define _T1CON_TMR1CS0          0x40
#define _T1CON_CS1              0x80
#define _T1CON_T1CS1            0x80
#define _T1CON_TMR1CS1          0x80

//==============================================================================


//==============================================================================
//        T1GCON Bits

extern __at(0x001B) __sfr T1GCON;

typedef union
  {
  struct
    {
    unsigned GSS0               : 1;
    unsigned GSS1               : 1;
    unsigned GVAL               : 1;
    unsigned GGO_NOT_DONE       : 1;
    unsigned GSPM               : 1;
    unsigned GTM                : 1;
    unsigned GPOL               : 1;
    unsigned GE                 : 1;
    };

  struct
    {
    unsigned T1GSS0             : 1;
    unsigned T1GSS1             : 1;
    unsigned T1GVAL             : 1;
    unsigned T1GGO_NOT_DONE     : 1;
    unsigned T1GSPM             : 1;
    unsigned T1GTM              : 1;
    unsigned T1GPOL             : 1;
    unsigned T1GE               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TMR1GE             : 1;
    };

  struct
    {
    unsigned T1GSS              : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned GSS                : 2;
    unsigned                    : 6;
    };
  } __T1GCONbits_t;

extern __at(0x001B) volatile __T1GCONbits_t T1GCONbits;

#define _GSS0                   0x01
#define _T1GSS0                 0x01
#define _GSS1                   0x02
#define _T1GSS1                 0x02
#define _GVAL                   0x04
#define _T1GVAL                 0x04
#define _GGO_NOT_DONE           0x08
#define _T1GGO_NOT_DONE         0x08
#define _GSPM                   0x10
#define _T1GSPM                 0x10
#define _GTM                    0x20
#define _T1GTM                  0x20
#define _GPOL                   0x40
#define _T1GPOL                 0x40
#define _GE                     0x80
#define _T1GE                   0x80
#define _TMR1GE                 0x80

//==============================================================================

extern __at(0x001C) __sfr TMR3;
extern __at(0x001C) __sfr TMR3L;
extern __at(0x001D) __sfr TMR3H;

//==============================================================================
//        T3CON Bits

extern __at(0x001E) __sfr T3CON;

typedef union
  {
  struct
    {
    unsigned ON                 : 1;
    unsigned                    : 1;
    unsigned NOT_SYNC           : 1;
    unsigned OSCEN              : 1;
    unsigned CKPS0              : 1;
    unsigned CKPS1              : 1;
    unsigned CS0                : 1;
    unsigned CS1                : 1;
    };

  struct
    {
    unsigned TMRON              : 1;
    unsigned                    : 1;
    unsigned SYNC               : 1;
    unsigned SOSCEN             : 1;
    unsigned T3CKPS0            : 1;
    unsigned T3CKPS1            : 1;
    unsigned T3CS0              : 1;
    unsigned T3CS1              : 1;
    };

  struct
    {
    unsigned TMR3ON             : 1;
    unsigned                    : 1;
    unsigned NOT_T3SYNC         : 1;
    unsigned T3OSCEN            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TMR3CS0            : 1;
    unsigned TMR3CS1            : 1;
    };

  struct
    {
    unsigned T3ON               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T3CKPS             : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 4;
    unsigned CKPS               : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned TMR3CS             : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned T3CS               : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned CS                 : 2;
    };
  } __T3CONbits_t;

extern __at(0x001E) volatile __T3CONbits_t T3CONbits;

#define _T3CON_ON               0x01
#define _T3CON_TMRON            0x01
#define _T3CON_TMR3ON           0x01
#define _T3CON_T3ON             0x01
#define _T3CON_NOT_SYNC         0x04
#define _T3CON_SYNC             0x04
#define _T3CON_NOT_T3SYNC       0x04
#define _T3CON_OSCEN            0x08
#define _T3CON_SOSCEN           0x08
#define _T3CON_T3OSCEN          0x08
#define _T3CON_CKPS0            0x10
#define _T3CON_T3CKPS0          0x10
#define _T3CON_CKPS1            0x20
#define _T3CON_T3CKPS1          0x20
#define _T3CON_CS0              0x40
#define _T3CON_T3CS0            0x40
#define _T3CON_TMR3CS0          0x40
#define _T3CON_CS1              0x80
#define _T3CON_T3CS1            0x80
#define _T3CON_TMR3CS1          0x80

//==============================================================================


//==============================================================================
//        T3GCON Bits

extern __at(0x001F) __sfr T3GCON;

typedef union
  {
  struct
    {
    unsigned GSS0               : 1;
    unsigned GSS1               : 1;
    unsigned GVAL               : 1;
    unsigned GGO_NOT_DONE       : 1;
    unsigned GSPM               : 1;
    unsigned GTM                : 1;
    unsigned GPOL               : 1;
    unsigned GE                 : 1;
    };

  struct
    {
    unsigned T3GSS0             : 1;
    unsigned T3GSS1             : 1;
    unsigned T3GVAL             : 1;
    unsigned T3GGO_NOT_DONE     : 1;
    unsigned T3GSPM             : 1;
    unsigned T3GTM              : 1;
    unsigned T3GPOL             : 1;
    unsigned T3GE               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TMR3GE             : 1;
    };

  struct
    {
    unsigned T3GSS              : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned GSS                : 2;
    unsigned                    : 6;
    };
  } __T3GCONbits_t;

extern __at(0x001F) volatile __T3GCONbits_t T3GCONbits;

#define _T3GCON_GSS0            0x01
#define _T3GCON_T3GSS0          0x01
#define _T3GCON_GSS1            0x02
#define _T3GCON_T3GSS1          0x02
#define _T3GCON_GVAL            0x04
#define _T3GCON_T3GVAL          0x04
#define _T3GCON_GGO_NOT_DONE    0x08
#define _T3GCON_T3GGO_NOT_DONE  0x08
#define _T3GCON_GSPM            0x10
#define _T3GCON_T3GSPM          0x10
#define _T3GCON_GTM             0x20
#define _T3GCON_T3GTM           0x20
#define _T3GCON_GPOL            0x40
#define _T3GCON_T3GPOL          0x40
#define _T3GCON_GE              0x80
#define _T3GCON_T3GE            0x80
#define _T3GCON_TMR3GE          0x80

//==============================================================================


//==============================================================================
//        TRISA Bits

extern __at(0x008C) __sfr TRISA;

typedef struct
  {
  unsigned TRISA0               : 1;
  unsigned TRISA1               : 1;
  unsigned TRISA2               : 1;
  unsigned TRISA3               : 1;
  unsigned TRISA4               : 1;
  unsigned TRISA5               : 1;
  unsigned TRISA6               : 1;
  unsigned TRISA7               : 1;
  } __TRISAbits_t;

extern __at(0x008C) volatile __TRISAbits_t TRISAbits;

#define _TRISA0                 0x01
#define _TRISA1                 0x02
#define _TRISA2                 0x04
#define _TRISA3                 0x08
#define _TRISA4                 0x10
#define _TRISA5                 0x20
#define _TRISA6                 0x40
#define _TRISA7                 0x80

//==============================================================================


//==============================================================================
//        TRISB Bits

extern __at(0x008D) __sfr TRISB;

typedef struct
  {
  unsigned TRISB0               : 1;
  unsigned TRISB1               : 1;
  unsigned TRISB2               : 1;
  unsigned TRISB3               : 1;
  unsigned TRISB4               : 1;
  unsigned TRISB5               : 1;
  unsigned TRISB6               : 1;
  unsigned TRISB7               : 1;
  } __TRISBbits_t;

extern __at(0x008D) volatile __TRISBbits_t TRISBbits;

#define _TRISB0                 0x01
#define _TRISB1                 0x02
#define _TRISB2                 0x04
#define _TRISB3                 0x08
#define _TRISB4                 0x10
#define _TRISB5                 0x20
#define _TRISB6                 0x40
#define _TRISB7                 0x80

//==============================================================================


//==============================================================================
//        TRISC Bits

extern __at(0x008E) __sfr TRISC;

typedef struct
  {
  unsigned TRISC0               : 1;
  unsigned TRISC1               : 1;
  unsigned TRISC2               : 1;
  unsigned TRISC3               : 1;
  unsigned TRISC4               : 1;
  unsigned TRISC5               : 1;
  unsigned TRISC6               : 1;
  unsigned TRISC7               : 1;
  } __TRISCbits_t;

extern __at(0x008E) volatile __TRISCbits_t TRISCbits;

#define _TRISC0                 0x01
#define _TRISC1                 0x02
#define _TRISC2                 0x04
#define _TRISC3                 0x08
#define _TRISC4                 0x10
#define _TRISC5                 0x20
#define _TRISC6                 0x40
#define _TRISC7                 0x80

//==============================================================================


//==============================================================================
//        TRISE Bits

extern __at(0x0090) __sfr TRISE;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned TRISE3               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __TRISEbits_t;

extern __at(0x0090) volatile __TRISEbits_t TRISEbits;

#define _TRISE3                 0x08

//==============================================================================


//==============================================================================
//        PIE1 Bits

extern __at(0x0091) __sfr PIE1;

typedef union
  {
  struct
    {
    unsigned TMR1IE             : 1;
    unsigned TMR2IE             : 1;
    unsigned CCP1IE             : 1;
    unsigned SSP1IE             : 1;
    unsigned TXIE               : 1;
    unsigned RCIE               : 1;
    unsigned ADIE               : 1;
    unsigned TMR1GIE            : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCPIE              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PIE1bits_t;

extern __at(0x0091) volatile __PIE1bits_t PIE1bits;

#define _TMR1IE                 0x01
#define _TMR2IE                 0x02
#define _CCP1IE                 0x04
#define _CCPIE                  0x04
#define _SSP1IE                 0x08
#define _TXIE                   0x10
#define _RCIE                   0x20
#define _ADIE                   0x40
#define _TMR1GIE                0x80

//==============================================================================


//==============================================================================
//        PIE2 Bits

extern __at(0x0092) __sfr PIE2;

typedef struct
  {
  unsigned CCP2IE               : 1;
  unsigned C3IE                 : 1;
  unsigned C4IE                 : 1;
  unsigned BCL1IE               : 1;
  unsigned COGIE                : 1;
  unsigned C1IE                 : 1;
  unsigned C2IE                 : 1;
  unsigned OSFIE                : 1;
  } __PIE2bits_t;

extern __at(0x0092) volatile __PIE2bits_t PIE2bits;

#define _CCP2IE                 0x01
#define _C3IE                   0x02
#define _C4IE                   0x04
#define _BCL1IE                 0x08
#define _COGIE                  0x10
#define _C1IE                   0x20
#define _C2IE                   0x40
#define _OSFIE                  0x80

//==============================================================================


//==============================================================================
//        PIE3 Bits

extern __at(0x0093) __sfr PIE3;

typedef struct
  {
  unsigned CLC1IE               : 1;
  unsigned CLC2IE               : 1;
  unsigned CLC3IE               : 1;
  unsigned CLC4IE               : 1;
  unsigned ZCDIE                : 1;
  unsigned COG2IE               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIE3bits_t;

extern __at(0x0093) volatile __PIE3bits_t PIE3bits;

#define _CLC1IE                 0x01
#define _CLC2IE                 0x02
#define _CLC3IE                 0x04
#define _CLC4IE                 0x08
#define _ZCDIE                  0x10
#define _COG2IE                 0x20

//==============================================================================


//==============================================================================
//        PIE4 Bits

extern __at(0x0094) __sfr PIE4;

typedef struct
  {
  unsigned TMR4IE               : 1;
  unsigned TMR6IE               : 1;
  unsigned TMR3IE               : 1;
  unsigned TMR3GIE              : 1;
  unsigned TMR5IE               : 1;
  unsigned TMR5GIE              : 1;
  unsigned TMR8IE               : 1;
  unsigned                      : 1;
  } __PIE4bits_t;

extern __at(0x0094) volatile __PIE4bits_t PIE4bits;

#define _TMR4IE                 0x01
#define _TMR6IE                 0x02
#define _TMR3IE                 0x04
#define _TMR3GIE                0x08
#define _TMR5IE                 0x10
#define _TMR5GIE                0x20
#define _TMR8IE                 0x40

//==============================================================================


//==============================================================================
//        PIE5 Bits

extern __at(0x0095) __sfr PIE5;

typedef struct
  {
  unsigned C5IE                 : 1;
  unsigned C6IE                 : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned COG3IE               : 1;
  unsigned                      : 1;
  unsigned CCP7IE               : 1;
  unsigned                      : 1;
  } __PIE5bits_t;

extern __at(0x0095) volatile __PIE5bits_t PIE5bits;

#define _C5IE                   0x01
#define _C6IE                   0x02
#define _COG3IE                 0x10
#define _CCP7IE                 0x40

//==============================================================================


//==============================================================================
//        PIE6 Bits

extern __at(0x0096) __sfr PIE6;

typedef struct
  {
  unsigned PWM5IE               : 1;
  unsigned PWM6IE               : 1;
  unsigned PWM11IE              : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIE6bits_t;

extern __at(0x0096) volatile __PIE6bits_t PIE6bits;

#define _PWM5IE                 0x01
#define _PWM6IE                 0x02
#define _PWM11IE                0x04

//==============================================================================


//==============================================================================
//        OPTION_REG Bits

extern __at(0x0097) __sfr OPTION_REG;

typedef union
  {
  struct
    {
    unsigned PS0                : 1;
    unsigned PS1                : 1;
    unsigned PS2                : 1;
    unsigned PSA                : 1;
    unsigned TMR0SE             : 1;
    unsigned TMR0CS             : 1;
    unsigned INTEDG             : 1;
    unsigned NOT_WPUEN          : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0SE               : 1;
    unsigned T0CS               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PS                 : 3;
    unsigned                    : 5;
    };
  } __OPTION_REGbits_t;

extern __at(0x0097) volatile __OPTION_REGbits_t OPTION_REGbits;

#define _PS0                    0x01
#define _PS1                    0x02
#define _PS2                    0x04
#define _PSA                    0x08
#define _TMR0SE                 0x10
#define _T0SE                   0x10
#define _TMR0CS                 0x20
#define _T0CS                   0x20
#define _INTEDG                 0x40
#define _NOT_WPUEN              0x80

//==============================================================================


//==============================================================================
//        PCON Bits

extern __at(0x0098) __sfr PCON;

typedef struct
  {
  unsigned NOT_BOR              : 1;
  unsigned NOT_POR              : 1;
  unsigned NOT_RI               : 1;
  unsigned NOT_RMCLR            : 1;
  unsigned NOT_RWDT             : 1;
  unsigned                      : 1;
  unsigned STKUNF               : 1;
  unsigned STKOVF               : 1;
  } __PCONbits_t;

extern __at(0x0098) volatile __PCONbits_t PCONbits;

#define _NOT_BOR                0x01
#define _NOT_POR                0x02
#define _NOT_RI                 0x04
#define _NOT_RMCLR              0x08
#define _NOT_RWDT               0x10
#define _STKUNF                 0x40
#define _STKOVF                 0x80

//==============================================================================


//==============================================================================
//        WDTCON Bits

extern __at(0x0099) __sfr WDTCON;

typedef union
  {
  struct
    {
    unsigned SWDTEN             : 1;
    unsigned WDTPS0             : 1;
    unsigned WDTPS1             : 1;
    unsigned WDTPS2             : 1;
    unsigned WDTPS3             : 1;
    unsigned WDTPS4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned WDTPS              : 5;
    unsigned                    : 2;
    };
  } __WDTCONbits_t;

extern __at(0x0099) volatile __WDTCONbits_t WDTCONbits;

#define _SWDTEN                 0x01
#define _WDTPS0                 0x02
#define _WDTPS1                 0x04
#define _WDTPS2                 0x08
#define _WDTPS3                 0x10
#define _WDTPS4                 0x20

//==============================================================================


//==============================================================================
//        OSCTUNE Bits

extern __at(0x009A) __sfr OSCTUNE;

typedef union
  {
  struct
    {
    unsigned TUN0               : 1;
    unsigned TUN1               : 1;
    unsigned TUN2               : 1;
    unsigned TUN3               : 1;
    unsigned TUN4               : 1;
    unsigned TUN5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TUN                : 6;
    unsigned                    : 2;
    };
  } __OSCTUNEbits_t;

extern __at(0x009A) volatile __OSCTUNEbits_t OSCTUNEbits;

#define _TUN0                   0x01
#define _TUN1                   0x02
#define _TUN2                   0x04
#define _TUN3                   0x08
#define _TUN4                   0x10
#define _TUN5                   0x20

//==============================================================================


//==============================================================================
//        OSCCON Bits

extern __at(0x009B) __sfr OSCCON;

typedef union
  {
  struct
    {
    unsigned SCS0               : 1;
    unsigned SCS1               : 1;
    unsigned                    : 1;
    unsigned IRCF0              : 1;
    unsigned IRCF1              : 1;
    unsigned IRCF2              : 1;
    unsigned IRCF3              : 1;
    unsigned SPLLEN             : 1;
    };

  struct
    {
    unsigned SCS                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned IRCF               : 4;
    unsigned                    : 1;
    };
  } __OSCCONbits_t;

extern __at(0x009B) volatile __OSCCONbits_t OSCCONbits;

#define _SCS0                   0x01
#define _SCS1                   0x02
#define _IRCF0                  0x08
#define _IRCF1                  0x10
#define _IRCF2                  0x20
#define _IRCF3                  0x40
#define _SPLLEN                 0x80

//==============================================================================


//==============================================================================
//        OSCSTAT Bits

extern __at(0x009C) __sfr OSCSTAT;

typedef struct
  {
  unsigned HFIOFS               : 1;
  unsigned LFIOFR               : 1;
  unsigned MFIOFR               : 1;
  unsigned HFIOFL               : 1;
  unsigned HFIOFR               : 1;
  unsigned OSTS                 : 1;
  unsigned PLLR                 : 1;
  unsigned SOSCR                : 1;
  } __OSCSTATbits_t;

extern __at(0x009C) volatile __OSCSTATbits_t OSCSTATbits;

#define _HFIOFS                 0x01
#define _LFIOFR                 0x02
#define _MFIOFR                 0x04
#define _HFIOFL                 0x08
#define _HFIOFR                 0x10
#define _OSTS                   0x20
#define _PLLR                   0x40
#define _SOSCR                  0x80

//==============================================================================


//==============================================================================
//        BORCON Bits

extern __at(0x009D) __sfr BORCON;

typedef struct
  {
  unsigned BORRDY               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned BORFS                : 1;
  unsigned SBOREN               : 1;
  } __BORCONbits_t;

extern __at(0x009D) volatile __BORCONbits_t BORCONbits;

#define _BORRDY                 0x01
#define _BORFS                  0x40
#define _SBOREN                 0x80

//==============================================================================


//==============================================================================
//        FVRCON Bits

extern __at(0x009E) __sfr FVRCON;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned TSRNG                : 1;
  unsigned TSEN                 : 1;
  unsigned FVRRDY               : 1;
  unsigned FVREN                : 1;
  } __FVRCONbits_t;

extern __at(0x009E) volatile __FVRCONbits_t FVRCONbits;

#define _TSRNG                  0x10
#define _TSEN                   0x20
#define _FVRRDY                 0x40
#define _FVREN                  0x80

//==============================================================================


//==============================================================================
//        ZCD1CON Bits

extern __at(0x009F) __sfr ZCD1CON;

typedef struct
  {
  unsigned ZCD1INTN             : 1;
  unsigned ZCD1INTP             : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned ZCD1POL              : 1;
  unsigned ZCD1OUT              : 1;
  unsigned                      : 1;
  unsigned ZCD1EN               : 1;
  } __ZCD1CONbits_t;

extern __at(0x009F) volatile __ZCD1CONbits_t ZCD1CONbits;

#define _ZCD1INTN               0x01
#define _ZCD1INTP               0x02
#define _ZCD1POL                0x10
#define _ZCD1OUT                0x20
#define _ZCD1EN                 0x80

//==============================================================================


//==============================================================================
//        LATA Bits

extern __at(0x010C) __sfr LATA;

typedef struct
  {
  unsigned LATA0                : 1;
  unsigned LATA1                : 1;
  unsigned LATA2                : 1;
  unsigned LATA3                : 1;
  unsigned LATA4                : 1;
  unsigned LATA5                : 1;
  unsigned LATA6                : 1;
  unsigned LATA7                : 1;
  } __LATAbits_t;

extern __at(0x010C) volatile __LATAbits_t LATAbits;

#define _LATA0                  0x01
#define _LATA1                  0x02
#define _LATA2                  0x04
#define _LATA3                  0x08
#define _LATA4                  0x10
#define _LATA5                  0x20
#define _LATA6                  0x40
#define _LATA7                  0x80

//==============================================================================


//==============================================================================
//        LATB Bits

extern __at(0x010D) __sfr LATB;

typedef struct
  {
  unsigned LATB0                : 1;
  unsigned LATB1                : 1;
  unsigned LATB2                : 1;
  unsigned LATB3                : 1;
  unsigned LATB4                : 1;
  unsigned LATB5                : 1;
  unsigned LATB6                : 1;
  unsigned LATB7                : 1;
  } __LATBbits_t;

extern __at(0x010D) volatile __LATBbits_t LATBbits;

#define _LATB0                  0x01
#define _LATB1                  0x02
#define _LATB2                  0x04
#define _LATB3                  0x08
#define _LATB4                  0x10
#define _LATB5                  0x20
#define _LATB6                  0x40
#define _LATB7                  0x80

//==============================================================================


//==============================================================================
//        LATC Bits

extern __at(0x010E) __sfr LATC;

typedef struct
  {
  unsigned LATC0                : 1;
  unsigned LATC1                : 1;
  unsigned LATC2                : 1;
  unsigned LATC3                : 1;
  unsigned LATC4                : 1;
  unsigned LATC5                : 1;
  unsigned LATC6                : 1;
  unsigned LATC7                : 1;
  } __LATCbits_t;

extern __at(0x010E) volatile __LATCbits_t LATCbits;

#define _LATC0                  0x01
#define _LATC1                  0x02
#define _LATC2                  0x04
#define _LATC3                  0x08
#define _LATC4                  0x10
#define _LATC5                  0x20
#define _LATC6                  0x40
#define _LATC7                  0x80

//==============================================================================


//==============================================================================
//        CMOUT Bits

extern __at(0x0111) __sfr CMOUT;

typedef struct
  {
  unsigned MC1OUT               : 1;
  unsigned MC2OUT               : 1;
  unsigned MC3OUT               : 1;
  unsigned MC4OUT               : 1;
  unsigned MC5OUT               : 1;
  unsigned MC6OUT               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __CMOUTbits_t;

extern __at(0x0111) volatile __CMOUTbits_t CMOUTbits;

#define _MC1OUT                 0x01
#define _MC2OUT                 0x02
#define _MC3OUT                 0x04
#define _MC4OUT                 0x08
#define _MC5OUT                 0x10
#define _MC6OUT                 0x20

//==============================================================================


//==============================================================================
//        CM1CON0 Bits

extern __at(0x0112) __sfr CM1CON0;

typedef union
  {
  struct
    {
    unsigned SYNC               : 1;
    unsigned HYS                : 1;
    unsigned Reserved           : 1;
    unsigned ZLF                : 1;
    unsigned POL                : 1;
    unsigned                    : 1;
    unsigned OUT                : 1;
    unsigned ON                 : 1;
    };

  struct
    {
    unsigned C1SYNC             : 1;
    unsigned C1HYS              : 1;
    unsigned C1SP               : 1;
    unsigned C1ZLF              : 1;
    unsigned C1POL              : 1;
    unsigned                    : 1;
    unsigned C1OUT              : 1;
    unsigned C1ON               : 1;
    };
  } __CM1CON0bits_t;

extern __at(0x0112) volatile __CM1CON0bits_t CM1CON0bits;

#define _CM1CON0_SYNC           0x01
#define _CM1CON0_C1SYNC         0x01
#define _CM1CON0_HYS            0x02
#define _CM1CON0_C1HYS          0x02
#define _CM1CON0_Reserved       0x04
#define _CM1CON0_C1SP           0x04
#define _CM1CON0_ZLF            0x08
#define _CM1CON0_C1ZLF          0x08
#define _CM1CON0_POL            0x10
#define _CM1CON0_C1POL          0x10
#define _CM1CON0_OUT            0x40
#define _CM1CON0_C1OUT          0x40
#define _CM1CON0_ON             0x80
#define _CM1CON0_C1ON           0x80

//==============================================================================


//==============================================================================
//        CM1CON1 Bits

extern __at(0x0113) __sfr CM1CON1;

typedef union
  {
  struct
    {
    unsigned INTN               : 1;
    unsigned INTP               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned C1INTN             : 1;
    unsigned C1INTP             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __CM1CON1bits_t;

extern __at(0x0113) volatile __CM1CON1bits_t CM1CON1bits;

#define _CM1CON1_INTN           0x01
#define _CM1CON1_C1INTN         0x01
#define _CM1CON1_INTP           0x02
#define _CM1CON1_C1INTP         0x02

//==============================================================================


//==============================================================================
//        CM1NSEL Bits

extern __at(0x0114) __sfr CM1NSEL;

typedef union
  {
  struct
    {
    unsigned C1NCH0             : 1;
    unsigned C1NCH1             : 1;
    unsigned C1NCH2             : 1;
    unsigned C1NCH3             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned C1NCH              : 4;
    unsigned                    : 4;
    };
  } __CM1NSELbits_t;

extern __at(0x0114) volatile __CM1NSELbits_t CM1NSELbits;

#define _C1NCH0                 0x01
#define _C1NCH1                 0x02
#define _C1NCH2                 0x04
#define _C1NCH3                 0x08

//==============================================================================


//==============================================================================
//        CM1PSEL Bits

extern __at(0x0115) __sfr CM1PSEL;

typedef union
  {
  struct
    {
    unsigned PCH0               : 1;
    unsigned PCH1               : 1;
    unsigned PCH2               : 1;
    unsigned PCH3               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned C1PCH0             : 1;
    unsigned C1PCH1             : 1;
    unsigned C1PCH2             : 1;
    unsigned C1PCH3             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned C1PCH              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned PCH                : 4;
    unsigned                    : 4;
    };
  } __CM1PSELbits_t;

extern __at(0x0115) volatile __CM1PSELbits_t CM1PSELbits;

#define _PCH0                   0x01
#define _C1PCH0                 0x01
#define _PCH1                   0x02
#define _C1PCH1                 0x02
#define _PCH2                   0x04
#define _C1PCH2                 0x04
#define _PCH3                   0x08
#define _C1PCH3                 0x08

//==============================================================================


//==============================================================================
//        CM2CON0 Bits

extern __at(0x0116) __sfr CM2CON0;

typedef union
  {
  struct
    {
    unsigned SYNC               : 1;
    unsigned HYS                : 1;
    unsigned Reserved           : 1;
    unsigned ZLF                : 1;
    unsigned POL                : 1;
    unsigned                    : 1;
    unsigned OUT                : 1;
    unsigned ON                 : 1;
    };

  struct
    {
    unsigned C2SYNC             : 1;
    unsigned C2HYS              : 1;
    unsigned C2SP               : 1;
    unsigned C2ZLF              : 1;
    unsigned C2POL              : 1;
    unsigned                    : 1;
    unsigned C2OUT              : 1;
    unsigned C2ON               : 1;
    };
  } __CM2CON0bits_t;

extern __at(0x0116) volatile __CM2CON0bits_t CM2CON0bits;

#define _CM2CON0_SYNC           0x01
#define _CM2CON0_C2SYNC         0x01
#define _CM2CON0_HYS            0x02
#define _CM2CON0_C2HYS          0x02
#define _CM2CON0_Reserved       0x04
#define _CM2CON0_C2SP           0x04
#define _CM2CON0_ZLF            0x08
#define _CM2CON0_C2ZLF          0x08
#define _CM2CON0_POL            0x10
#define _CM2CON0_C2POL          0x10
#define _CM2CON0_OUT            0x40
#define _CM2CON0_C2OUT          0x40
#define _CM2CON0_ON             0x80
#define _CM2CON0_C2ON           0x80

//==============================================================================


//==============================================================================
//        CM2CON1 Bits

extern __at(0x0117) __sfr CM2CON1;

typedef union
  {
  struct
    {
    unsigned INTN               : 1;
    unsigned INTP               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned C2INTN             : 1;
    unsigned C2INTP             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __CM2CON1bits_t;

extern __at(0x0117) volatile __CM2CON1bits_t CM2CON1bits;

#define _CM2CON1_INTN           0x01
#define _CM2CON1_C2INTN         0x01
#define _CM2CON1_INTP           0x02
#define _CM2CON1_C2INTP         0x02

//==============================================================================


//==============================================================================
//        CM2NSEL Bits

extern __at(0x0118) __sfr CM2NSEL;

typedef union
  {
  struct
    {
    unsigned C2NCH0             : 1;
    unsigned C2NCH1             : 1;
    unsigned C2NCH2             : 1;
    unsigned C2NCH3             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned C2NCH              : 4;
    unsigned                    : 4;
    };
  } __CM2NSELbits_t;

extern __at(0x0118) volatile __CM2NSELbits_t CM2NSELbits;

#define _C2NCH0                 0x01
#define _C2NCH1                 0x02
#define _C2NCH2                 0x04
#define _C2NCH3                 0x08

//==============================================================================


//==============================================================================
//        CM2PSEL Bits

extern __at(0x0119) __sfr CM2PSEL;

typedef union
  {
  struct
    {
    unsigned PCH0               : 1;
    unsigned PCH1               : 1;
    unsigned PCH2               : 1;
    unsigned PCH3               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned C2PCH0             : 1;
    unsigned C2PCH1             : 1;
    unsigned C2PCH2             : 1;
    unsigned C2PCH3             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PCH                : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned C2PCH              : 4;
    unsigned                    : 4;
    };
  } __CM2PSELbits_t;

extern __at(0x0119) volatile __CM2PSELbits_t CM2PSELbits;

#define _CM2PSEL_PCH0           0x01
#define _CM2PSEL_C2PCH0         0x01
#define _CM2PSEL_PCH1           0x02
#define _CM2PSEL_C2PCH1         0x02
#define _CM2PSEL_PCH2           0x04
#define _CM2PSEL_C2PCH2         0x04
#define _CM2PSEL_PCH3           0x08
#define _CM2PSEL_C2PCH3         0x08

//==============================================================================


//==============================================================================
//        CM3CON0 Bits

extern __at(0x011A) __sfr CM3CON0;

typedef union
  {
  struct
    {
    unsigned SYNC               : 1;
    unsigned HYS                : 1;
    unsigned Reserved           : 1;
    unsigned ZLF                : 1;
    unsigned POL                : 1;
    unsigned                    : 1;
    unsigned OUT                : 1;
    unsigned ON                 : 1;
    };

  struct
    {
    unsigned C3SYNC             : 1;
    unsigned C3HYS              : 1;
    unsigned C3SP               : 1;
    unsigned C3ZLF              : 1;
    unsigned C3POL              : 1;
    unsigned                    : 1;
    unsigned C3OUT              : 1;
    unsigned C3ON               : 1;
    };
  } __CM3CON0bits_t;

extern __at(0x011A) volatile __CM3CON0bits_t CM3CON0bits;

#define _CM3CON0_SYNC           0x01
#define _CM3CON0_C3SYNC         0x01
#define _CM3CON0_HYS            0x02
#define _CM3CON0_C3HYS          0x02
#define _CM3CON0_Reserved       0x04
#define _CM3CON0_C3SP           0x04
#define _CM3CON0_ZLF            0x08
#define _CM3CON0_C3ZLF          0x08
#define _CM3CON0_POL            0x10
#define _CM3CON0_C3POL          0x10
#define _CM3CON0_OUT            0x40
#define _CM3CON0_C3OUT          0x40
#define _CM3CON0_ON             0x80
#define _CM3CON0_C3ON           0x80

//==============================================================================


//==============================================================================
//        CM3CON1 Bits

extern __at(0x011B) __sfr CM3CON1;

typedef union
  {
  struct
    {
    unsigned INTN               : 1;
    unsigned INTP               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned C3INTN             : 1;
    unsigned C3INTP             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __CM3CON1bits_t;

extern __at(0x011B) volatile __CM3CON1bits_t CM3CON1bits;

#define _CM3CON1_INTN           0x01
#define _CM3CON1_C3INTN         0x01
#define _CM3CON1_INTP           0x02
#define _CM3CON1_C3INTP         0x02

//==============================================================================


//==============================================================================
//        CM3NSEL Bits

extern __at(0x011C) __sfr CM3NSEL;

typedef union
  {
  struct
    {
    unsigned C3NCH0             : 1;
    unsigned C3NCH1             : 1;
    unsigned C3NCH2             : 1;
    unsigned C3NCH3             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned C3NCH              : 4;
    unsigned                    : 4;
    };
  } __CM3NSELbits_t;

extern __at(0x011C) volatile __CM3NSELbits_t CM3NSELbits;

#define _C3NCH0                 0x01
#define _C3NCH1                 0x02
#define _C3NCH2                 0x04
#define _C3NCH3                 0x08

//==============================================================================


//==============================================================================
//        CM3PSEL Bits

extern __at(0x011D) __sfr CM3PSEL;

typedef union
  {
  struct
    {
    unsigned PCH0               : 1;
    unsigned PCH1               : 1;
    unsigned PCH2               : 1;
    unsigned PCH3               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned C3PCH0             : 1;
    unsigned C3PCH1             : 1;
    unsigned C3PCH2             : 1;
    unsigned C3PCH3             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PCH                : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned C3PCH              : 4;
    unsigned                    : 4;
    };
  } __CM3PSELbits_t;

extern __at(0x011D) volatile __CM3PSELbits_t CM3PSELbits;

#define _CM3PSEL_PCH0           0x01
#define _CM3PSEL_C3PCH0         0x01
#define _CM3PSEL_PCH1           0x02
#define _CM3PSEL_C3PCH1         0x02
#define _CM3PSEL_PCH2           0x04
#define _CM3PSEL_C3PCH2         0x04
#define _CM3PSEL_PCH3           0x08
#define _CM3PSEL_C3PCH3         0x08

//==============================================================================


//==============================================================================
//        ANSELA Bits

extern __at(0x018C) __sfr ANSELA;

typedef union
  {
  struct
    {
    unsigned ANSA0              : 1;
    unsigned ANSA1              : 1;
    unsigned ANSA2              : 1;
    unsigned ANSA3              : 1;
    unsigned ANSA4              : 1;
    unsigned ANSA5              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ANSA               : 6;
    unsigned                    : 2;
    };
  } __ANSELAbits_t;

extern __at(0x018C) volatile __ANSELAbits_t ANSELAbits;

#define _ANSA0                  0x01
#define _ANSA1                  0x02
#define _ANSA2                  0x04
#define _ANSA3                  0x08
#define _ANSA4                  0x10
#define _ANSA5                  0x20

//==============================================================================


//==============================================================================
//        ANSELB Bits

extern __at(0x018D) __sfr ANSELB;

typedef union
  {
  struct
    {
    unsigned ANSB0              : 1;
    unsigned ANSB1              : 1;
    unsigned ANSB2              : 1;
    unsigned ANSB3              : 1;
    unsigned ANSB4              : 1;
    unsigned ANSB5              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ANSB               : 6;
    unsigned                    : 2;
    };
  } __ANSELBbits_t;

extern __at(0x018D) volatile __ANSELBbits_t ANSELBbits;

#define _ANSB0                  0x01
#define _ANSB1                  0x02
#define _ANSB2                  0x04
#define _ANSB3                  0x08
#define _ANSB4                  0x10
#define _ANSB5                  0x20

//==============================================================================


//==============================================================================
//        ANSELC Bits

extern __at(0x018E) __sfr ANSELC;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned ANSC2                : 1;
  unsigned ANSC3                : 1;
  unsigned ANSC4                : 1;
  unsigned ANSC5                : 1;
  unsigned ANSC6                : 1;
  unsigned ANSC7                : 1;
  } __ANSELCbits_t;

extern __at(0x018E) volatile __ANSELCbits_t ANSELCbits;

#define _ANSC2                  0x04
#define _ANSC3                  0x08
#define _ANSC4                  0x10
#define _ANSC5                  0x20
#define _ANSC6                  0x40
#define _ANSC7                  0x80

//==============================================================================

extern __at(0x0191) __sfr PMADR;
extern __at(0x0191) __sfr PMADRL;
extern __at(0x0192) __sfr PMADRH;
extern __at(0x0193) __sfr PMDAT;
extern __at(0x0193) __sfr PMDATL;
extern __at(0x0194) __sfr PMDATH;

//==============================================================================
//        PMCON1 Bits

extern __at(0x0195) __sfr PMCON1;

typedef struct
  {
  unsigned RD                   : 1;
  unsigned WR                   : 1;
  unsigned WREN                 : 1;
  unsigned WRERR                : 1;
  unsigned FREE                 : 1;
  unsigned LWLO                 : 1;
  unsigned CFGS                 : 1;
  unsigned                      : 1;
  } __PMCON1bits_t;

extern __at(0x0195) volatile __PMCON1bits_t PMCON1bits;

#define _RD                     0x01
#define _WR                     0x02
#define _WREN                   0x04
#define _WRERR                  0x08
#define _FREE                   0x10
#define _LWLO                   0x20
#define _CFGS                   0x40

//==============================================================================

extern __at(0x0196) __sfr PMCON2;
extern __at(0x0199) __sfr RC1REG;
extern __at(0x0199) __sfr RCREG;
extern __at(0x0199) __sfr RCREG1;
extern __at(0x019A) __sfr TX1REG;
extern __at(0x019A) __sfr TXREG;
extern __at(0x019A) __sfr TXREG1;
extern __at(0x019B) __sfr SP1BRG;
extern __at(0x019B) __sfr SP1BRGL;
extern __at(0x019B) __sfr SPBRG;
extern __at(0x019B) __sfr SPBRG1;
extern __at(0x019B) __sfr SPBRGL;
extern __at(0x019C) __sfr SP1BRGH;
extern __at(0x019C) __sfr SPBRGH;
extern __at(0x019C) __sfr SPBRGH1;

//==============================================================================
//        RC1STA Bits

extern __at(0x019D) __sfr RC1STA;

typedef struct
  {
  unsigned RX9D                 : 1;
  unsigned OERR                 : 1;
  unsigned FERR                 : 1;
  unsigned ADDEN                : 1;
  unsigned CREN                 : 1;
  unsigned SREN                 : 1;
  unsigned RX9                  : 1;
  unsigned SPEN                 : 1;
  } __RC1STAbits_t;

extern __at(0x019D) volatile __RC1STAbits_t RC1STAbits;

#define _RX9D                   0x01
#define _OERR                   0x02
#define _FERR                   0x04
#define _ADDEN                  0x08
#define _CREN                   0x10
#define _SREN                   0x20
#define _RX9                    0x40
#define _SPEN                   0x80

//==============================================================================


//==============================================================================
//        RCSTA Bits

extern __at(0x019D) __sfr RCSTA;

typedef struct
  {
  unsigned RX9D                 : 1;
  unsigned OERR                 : 1;
  unsigned FERR                 : 1;
  unsigned ADDEN                : 1;
  unsigned CREN                 : 1;
  unsigned SREN                 : 1;
  unsigned RX9                  : 1;
  unsigned SPEN                 : 1;
  } __RCSTAbits_t;

extern __at(0x019D) volatile __RCSTAbits_t RCSTAbits;

#define _RCSTA_RX9D             0x01
#define _RCSTA_OERR             0x02
#define _RCSTA_FERR             0x04
#define _RCSTA_ADDEN            0x08
#define _RCSTA_CREN             0x10
#define _RCSTA_SREN             0x20
#define _RCSTA_RX9              0x40
#define _RCSTA_SPEN             0x80

//==============================================================================


//==============================================================================
//        RCSTA1 Bits

extern __at(0x019D) __sfr RCSTA1;

typedef struct
  {
  unsigned RX9D                 : 1;
  unsigned OERR                 : 1;
  unsigned FERR                 : 1;
  unsigned ADDEN                : 1;
  unsigned CREN                 : 1;
  unsigned SREN                 : 1;
  unsigned RX9                  : 1;
  unsigned SPEN                 : 1;
  } __RCSTA1bits_t;

extern __at(0x019D) volatile __RCSTA1bits_t RCSTA1bits;

#define _RCSTA1_RX9D            0x01
#define _RCSTA1_OERR            0x02
#define _RCSTA1_FERR            0x04
#define _RCSTA1_ADDEN           0x08
#define _RCSTA1_CREN            0x10
#define _RCSTA1_SREN            0x20
#define _RCSTA1_RX9             0x40
#define _RCSTA1_SPEN            0x80

//==============================================================================


//==============================================================================
//        TX1STA Bits

extern __at(0x019E) __sfr TX1STA;

typedef struct
  {
  unsigned TX9D                 : 1;
  unsigned TRMT                 : 1;
  unsigned BRGH                 : 1;
  unsigned SENDB                : 1;
  unsigned SYNC                 : 1;
  unsigned TXEN                 : 1;
  unsigned TX9                  : 1;
  unsigned CSRC                 : 1;
  } __TX1STAbits_t;

extern __at(0x019E) volatile __TX1STAbits_t TX1STAbits;

#define _TX1STA_TX9D            0x01
#define _TX1STA_TRMT            0x02
#define _TX1STA_BRGH            0x04
#define _TX1STA_SENDB           0x08
#define _TX1STA_SYNC            0x10
#define _TX1STA_TXEN            0x20
#define _TX1STA_TX9             0x40
#define _TX1STA_CSRC            0x80

//==============================================================================


//==============================================================================
//        TXSTA Bits

extern __at(0x019E) __sfr TXSTA;

typedef struct
  {
  unsigned TX9D                 : 1;
  unsigned TRMT                 : 1;
  unsigned BRGH                 : 1;
  unsigned SENDB                : 1;
  unsigned SYNC                 : 1;
  unsigned TXEN                 : 1;
  unsigned TX9                  : 1;
  unsigned CSRC                 : 1;
  } __TXSTAbits_t;

extern __at(0x019E) volatile __TXSTAbits_t TXSTAbits;

#define _TXSTA_TX9D             0x01
#define _TXSTA_TRMT             0x02
#define _TXSTA_BRGH             0x04
#define _TXSTA_SENDB            0x08
#define _TXSTA_SYNC             0x10
#define _TXSTA_TXEN             0x20
#define _TXSTA_TX9              0x40
#define _TXSTA_CSRC             0x80

//==============================================================================


//==============================================================================
//        TXSTA1 Bits

extern __at(0x019E) __sfr TXSTA1;

typedef struct
  {
  unsigned TX9D                 : 1;
  unsigned TRMT                 : 1;
  unsigned BRGH                 : 1;
  unsigned SENDB                : 1;
  unsigned SYNC                 : 1;
  unsigned TXEN                 : 1;
  unsigned TX9                  : 1;
  unsigned CSRC                 : 1;
  } __TXSTA1bits_t;

extern __at(0x019E) volatile __TXSTA1bits_t TXSTA1bits;

#define _TXSTA1_TX9D            0x01
#define _TXSTA1_TRMT            0x02
#define _TXSTA1_BRGH            0x04
#define _TXSTA1_SENDB           0x08
#define _TXSTA1_SYNC            0x10
#define _TXSTA1_TXEN            0x20
#define _TXSTA1_TX9             0x40
#define _TXSTA1_CSRC            0x80

//==============================================================================


//==============================================================================
//        BAUD1CON Bits

extern __at(0x019F) __sfr BAUD1CON;

typedef struct
  {
  unsigned ABDEN                : 1;
  unsigned WUE                  : 1;
  unsigned                      : 1;
  unsigned BRG16                : 1;
  unsigned SCKP                 : 1;
  unsigned                      : 1;
  unsigned RCIDL                : 1;
  unsigned ABDOVF               : 1;
  } __BAUD1CONbits_t;

extern __at(0x019F) volatile __BAUD1CONbits_t BAUD1CONbits;

#define _ABDEN                  0x01
#define _WUE                    0x02
#define _BRG16                  0x08
#define _SCKP                   0x10
#define _RCIDL                  0x40
#define _ABDOVF                 0x80

//==============================================================================


//==============================================================================
//        BAUDCON Bits

extern __at(0x019F) __sfr BAUDCON;

typedef struct
  {
  unsigned ABDEN                : 1;
  unsigned WUE                  : 1;
  unsigned                      : 1;
  unsigned BRG16                : 1;
  unsigned SCKP                 : 1;
  unsigned                      : 1;
  unsigned RCIDL                : 1;
  unsigned ABDOVF               : 1;
  } __BAUDCONbits_t;

extern __at(0x019F) volatile __BAUDCONbits_t BAUDCONbits;

#define _BAUDCON_ABDEN          0x01
#define _BAUDCON_WUE            0x02
#define _BAUDCON_BRG16          0x08
#define _BAUDCON_SCKP           0x10
#define _BAUDCON_RCIDL          0x40
#define _BAUDCON_ABDOVF         0x80

//==============================================================================


//==============================================================================
//        BAUDCON1 Bits

extern __at(0x019F) __sfr BAUDCON1;

typedef struct
  {
  unsigned ABDEN                : 1;
  unsigned WUE                  : 1;
  unsigned                      : 1;
  unsigned BRG16                : 1;
  unsigned SCKP                 : 1;
  unsigned                      : 1;
  unsigned RCIDL                : 1;
  unsigned ABDOVF               : 1;
  } __BAUDCON1bits_t;

extern __at(0x019F) volatile __BAUDCON1bits_t BAUDCON1bits;

#define _BAUDCON1_ABDEN         0x01
#define _BAUDCON1_WUE           0x02
#define _BAUDCON1_BRG16         0x08
#define _BAUDCON1_SCKP          0x10
#define _BAUDCON1_RCIDL         0x40
#define _BAUDCON1_ABDOVF        0x80

//==============================================================================


//==============================================================================
//        BAUDCTL Bits

extern __at(0x019F) __sfr BAUDCTL;

typedef struct
  {
  unsigned ABDEN                : 1;
  unsigned WUE                  : 1;
  unsigned                      : 1;
  unsigned BRG16                : 1;
  unsigned SCKP                 : 1;
  unsigned                      : 1;
  unsigned RCIDL                : 1;
  unsigned ABDOVF               : 1;
  } __BAUDCTLbits_t;

extern __at(0x019F) volatile __BAUDCTLbits_t BAUDCTLbits;

#define _BAUDCTL_ABDEN          0x01
#define _BAUDCTL_WUE            0x02
#define _BAUDCTL_BRG16          0x08
#define _BAUDCTL_SCKP           0x10
#define _BAUDCTL_RCIDL          0x40
#define _BAUDCTL_ABDOVF         0x80

//==============================================================================


//==============================================================================
//        BAUDCTL1 Bits

extern __at(0x019F) __sfr BAUDCTL1;

typedef struct
  {
  unsigned ABDEN                : 1;
  unsigned WUE                  : 1;
  unsigned                      : 1;
  unsigned BRG16                : 1;
  unsigned SCKP                 : 1;
  unsigned                      : 1;
  unsigned RCIDL                : 1;
  unsigned ABDOVF               : 1;
  } __BAUDCTL1bits_t;

extern __at(0x019F) volatile __BAUDCTL1bits_t BAUDCTL1bits;

#define _BAUDCTL1_ABDEN         0x01
#define _BAUDCTL1_WUE           0x02
#define _BAUDCTL1_BRG16         0x08
#define _BAUDCTL1_SCKP          0x10
#define _BAUDCTL1_RCIDL         0x40
#define _BAUDCTL1_ABDOVF        0x80

//==============================================================================


//==============================================================================
//        WPUA Bits

extern __at(0x020C) __sfr WPUA;

typedef struct
  {
  unsigned WPUA0                : 1;
  unsigned WPUA1                : 1;
  unsigned WPUA2                : 1;
  unsigned WPUA3                : 1;
  unsigned WPUA4                : 1;
  unsigned WPUA5                : 1;
  unsigned WPUA6                : 1;
  unsigned WPUA7                : 1;
  } __WPUAbits_t;

extern __at(0x020C) volatile __WPUAbits_t WPUAbits;

#define _WPUA0                  0x01
#define _WPUA1                  0x02
#define _WPUA2                  0x04
#define _WPUA3                  0x08
#define _WPUA4                  0x10
#define _WPUA5                  0x20
#define _WPUA6                  0x40
#define _WPUA7                  0x80

//==============================================================================


//==============================================================================
//        WPUB Bits

extern __at(0x020D) __sfr WPUB;

typedef struct
  {
  unsigned WPUB0                : 1;
  unsigned WPUB1                : 1;
  unsigned WPUB2                : 1;
  unsigned WPUB3                : 1;
  unsigned WPUB4                : 1;
  unsigned WPUB5                : 1;
  unsigned WPUB6                : 1;
  unsigned WPUB7                : 1;
  } __WPUBbits_t;

extern __at(0x020D) volatile __WPUBbits_t WPUBbits;

#define _WPUB0                  0x01
#define _WPUB1                  0x02
#define _WPUB2                  0x04
#define _WPUB3                  0x08
#define _WPUB4                  0x10
#define _WPUB5                  0x20
#define _WPUB6                  0x40
#define _WPUB7                  0x80

//==============================================================================


//==============================================================================
//        WPUC Bits

extern __at(0x020E) __sfr WPUC;

typedef struct
  {
  unsigned WPUC0                : 1;
  unsigned WPUC1                : 1;
  unsigned WPUC2                : 1;
  unsigned WPUC3                : 1;
  unsigned WPUC4                : 1;
  unsigned WPUC5                : 1;
  unsigned WPUC6                : 1;
  unsigned WPUC7                : 1;
  } __WPUCbits_t;

extern __at(0x020E) volatile __WPUCbits_t WPUCbits;

#define _WPUC0                  0x01
#define _WPUC1                  0x02
#define _WPUC2                  0x04
#define _WPUC3                  0x08
#define _WPUC4                  0x10
#define _WPUC5                  0x20
#define _WPUC6                  0x40
#define _WPUC7                  0x80

//==============================================================================


//==============================================================================
//        WPUE Bits

extern __at(0x0210) __sfr WPUE;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned WPUE3                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __WPUEbits_t;

extern __at(0x0210) volatile __WPUEbits_t WPUEbits;

#define _WPUE3                  0x08

//==============================================================================


//==============================================================================
//        SSP1BUF Bits

extern __at(0x0211) __sfr SSP1BUF;

typedef union
  {
  struct
    {
    unsigned SSP1BUF0           : 1;
    unsigned SSP1BUF1           : 1;
    unsigned SSP1BUF2           : 1;
    unsigned SSP1BUF3           : 1;
    unsigned SSP1BUF4           : 1;
    unsigned SSP1BUF5           : 1;
    unsigned SSP1BUF6           : 1;
    unsigned SSP1BUF7           : 1;
    };

  struct
    {
    unsigned BUF0               : 1;
    unsigned BUF1               : 1;
    unsigned BUF2               : 1;
    unsigned BUF3               : 1;
    unsigned BUF4               : 1;
    unsigned BUF5               : 1;
    unsigned BUF6               : 1;
    unsigned BUF7               : 1;
    };
  } __SSP1BUFbits_t;

extern __at(0x0211) volatile __SSP1BUFbits_t SSP1BUFbits;

#define _SSP1BUF0               0x01
#define _BUF0                   0x01
#define _SSP1BUF1               0x02
#define _BUF1                   0x02
#define _SSP1BUF2               0x04
#define _BUF2                   0x04
#define _SSP1BUF3               0x08
#define _BUF3                   0x08
#define _SSP1BUF4               0x10
#define _BUF4                   0x10
#define _SSP1BUF5               0x20
#define _BUF5                   0x20
#define _SSP1BUF6               0x40
#define _BUF6                   0x40
#define _SSP1BUF7               0x80
#define _BUF7                   0x80

//==============================================================================


//==============================================================================
//        SSPBUF Bits

extern __at(0x0211) __sfr SSPBUF;

typedef union
  {
  struct
    {
    unsigned SSP1BUF0           : 1;
    unsigned SSP1BUF1           : 1;
    unsigned SSP1BUF2           : 1;
    unsigned SSP1BUF3           : 1;
    unsigned SSP1BUF4           : 1;
    unsigned SSP1BUF5           : 1;
    unsigned SSP1BUF6           : 1;
    unsigned SSP1BUF7           : 1;
    };

  struct
    {
    unsigned BUF0               : 1;
    unsigned BUF1               : 1;
    unsigned BUF2               : 1;
    unsigned BUF3               : 1;
    unsigned BUF4               : 1;
    unsigned BUF5               : 1;
    unsigned BUF6               : 1;
    unsigned BUF7               : 1;
    };
  } __SSPBUFbits_t;

extern __at(0x0211) volatile __SSPBUFbits_t SSPBUFbits;

#define _SSPBUF_SSP1BUF0        0x01
#define _SSPBUF_BUF0            0x01
#define _SSPBUF_SSP1BUF1        0x02
#define _SSPBUF_BUF1            0x02
#define _SSPBUF_SSP1BUF2        0x04
#define _SSPBUF_BUF2            0x04
#define _SSPBUF_SSP1BUF3        0x08
#define _SSPBUF_BUF3            0x08
#define _SSPBUF_SSP1BUF4        0x10
#define _SSPBUF_BUF4            0x10
#define _SSPBUF_SSP1BUF5        0x20
#define _SSPBUF_BUF5            0x20
#define _SSPBUF_SSP1BUF6        0x40
#define _SSPBUF_BUF6            0x40
#define _SSPBUF_SSP1BUF7        0x80
#define _SSPBUF_BUF7            0x80

//==============================================================================


//==============================================================================
//        SSP1ADD Bits

extern __at(0x0212) __sfr SSP1ADD;

typedef union
  {
  struct
    {
    unsigned SSP1ADD0           : 1;
    unsigned SSP1ADD1           : 1;
    unsigned SSP1ADD2           : 1;
    unsigned SSP1ADD3           : 1;
    unsigned SSP1ADD4           : 1;
    unsigned SSP1ADD5           : 1;
    unsigned SSP1ADD6           : 1;
    unsigned SSP1ADD7           : 1;
    };

  struct
    {
    unsigned ADD0               : 1;
    unsigned ADD1               : 1;
    unsigned ADD2               : 1;
    unsigned ADD3               : 1;
    unsigned ADD4               : 1;
    unsigned ADD5               : 1;
    unsigned ADD6               : 1;
    unsigned ADD7               : 1;
    };
  } __SSP1ADDbits_t;

extern __at(0x0212) volatile __SSP1ADDbits_t SSP1ADDbits;

#define _SSP1ADD0               0x01
#define _ADD0                   0x01
#define _SSP1ADD1               0x02
#define _ADD1                   0x02
#define _SSP1ADD2               0x04
#define _ADD2                   0x04
#define _SSP1ADD3               0x08
#define _ADD3                   0x08
#define _SSP1ADD4               0x10
#define _ADD4                   0x10
#define _SSP1ADD5               0x20
#define _ADD5                   0x20
#define _SSP1ADD6               0x40
#define _ADD6                   0x40
#define _SSP1ADD7               0x80
#define _ADD7                   0x80

//==============================================================================


//==============================================================================
//        SSPADD Bits

extern __at(0x0212) __sfr SSPADD;

typedef union
  {
  struct
    {
    unsigned SSP1ADD0           : 1;
    unsigned SSP1ADD1           : 1;
    unsigned SSP1ADD2           : 1;
    unsigned SSP1ADD3           : 1;
    unsigned SSP1ADD4           : 1;
    unsigned SSP1ADD5           : 1;
    unsigned SSP1ADD6           : 1;
    unsigned SSP1ADD7           : 1;
    };

  struct
    {
    unsigned ADD0               : 1;
    unsigned ADD1               : 1;
    unsigned ADD2               : 1;
    unsigned ADD3               : 1;
    unsigned ADD4               : 1;
    unsigned ADD5               : 1;
    unsigned ADD6               : 1;
    unsigned ADD7               : 1;
    };
  } __SSPADDbits_t;

extern __at(0x0212) volatile __SSPADDbits_t SSPADDbits;

#define _SSPADD_SSP1ADD0        0x01
#define _SSPADD_ADD0            0x01
#define _SSPADD_SSP1ADD1        0x02
#define _SSPADD_ADD1            0x02
#define _SSPADD_SSP1ADD2        0x04
#define _SSPADD_ADD2            0x04
#define _SSPADD_SSP1ADD3        0x08
#define _SSPADD_ADD3            0x08
#define _SSPADD_SSP1ADD4        0x10
#define _SSPADD_ADD4            0x10
#define _SSPADD_SSP1ADD5        0x20
#define _SSPADD_ADD5            0x20
#define _SSPADD_SSP1ADD6        0x40
#define _SSPADD_ADD6            0x40
#define _SSPADD_SSP1ADD7        0x80
#define _SSPADD_ADD7            0x80

//==============================================================================


//==============================================================================
//        SSP1MSK Bits

extern __at(0x0213) __sfr SSP1MSK;

typedef union
  {
  struct
    {
    unsigned SSP1MSK0           : 1;
    unsigned SSP1MSK1           : 1;
    unsigned SSP1MSK2           : 1;
    unsigned SSP1MSK3           : 1;
    unsigned SSP1MSK4           : 1;
    unsigned SSP1MSK5           : 1;
    unsigned SSP1MSK6           : 1;
    unsigned SSP1MSK7           : 1;
    };

  struct
    {
    unsigned MSK0               : 1;
    unsigned MSK1               : 1;
    unsigned MSK2               : 1;
    unsigned MSK3               : 1;
    unsigned MSK4               : 1;
    unsigned MSK5               : 1;
    unsigned MSK6               : 1;
    unsigned MSK7               : 1;
    };
  } __SSP1MSKbits_t;

extern __at(0x0213) volatile __SSP1MSKbits_t SSP1MSKbits;

#define _SSP1MSK0               0x01
#define _MSK0                   0x01
#define _SSP1MSK1               0x02
#define _MSK1                   0x02
#define _SSP1MSK2               0x04
#define _MSK2                   0x04
#define _SSP1MSK3               0x08
#define _MSK3                   0x08
#define _SSP1MSK4               0x10
#define _MSK4                   0x10
#define _SSP1MSK5               0x20
#define _MSK5                   0x20
#define _SSP1MSK6               0x40
#define _MSK6                   0x40
#define _SSP1MSK7               0x80
#define _MSK7                   0x80

//==============================================================================


//==============================================================================
//        SSPMSK Bits

extern __at(0x0213) __sfr SSPMSK;

typedef union
  {
  struct
    {
    unsigned SSP1MSK0           : 1;
    unsigned SSP1MSK1           : 1;
    unsigned SSP1MSK2           : 1;
    unsigned SSP1MSK3           : 1;
    unsigned SSP1MSK4           : 1;
    unsigned SSP1MSK5           : 1;
    unsigned SSP1MSK6           : 1;
    unsigned SSP1MSK7           : 1;
    };

  struct
    {
    unsigned MSK0               : 1;
    unsigned MSK1               : 1;
    unsigned MSK2               : 1;
    unsigned MSK3               : 1;
    unsigned MSK4               : 1;
    unsigned MSK5               : 1;
    unsigned MSK6               : 1;
    unsigned MSK7               : 1;
    };
  } __SSPMSKbits_t;

extern __at(0x0213) volatile __SSPMSKbits_t SSPMSKbits;

#define _SSPMSK_SSP1MSK0        0x01
#define _SSPMSK_MSK0            0x01
#define _SSPMSK_SSP1MSK1        0x02
#define _SSPMSK_MSK1            0x02
#define _SSPMSK_SSP1MSK2        0x04
#define _SSPMSK_MSK2            0x04
#define _SSPMSK_SSP1MSK3        0x08
#define _SSPMSK_MSK3            0x08
#define _SSPMSK_SSP1MSK4        0x10
#define _SSPMSK_MSK4            0x10
#define _SSPMSK_SSP1MSK5        0x20
#define _SSPMSK_MSK5            0x20
#define _SSPMSK_SSP1MSK6        0x40
#define _SSPMSK_MSK6            0x40
#define _SSPMSK_SSP1MSK7        0x80
#define _SSPMSK_MSK7            0x80

//==============================================================================


//==============================================================================
//        SSP1STAT Bits

extern __at(0x0214) __sfr SSP1STAT;

typedef struct
  {
  unsigned BF                   : 1;
  unsigned UA                   : 1;
  unsigned R_NOT_W              : 1;
  unsigned S                    : 1;
  unsigned P                    : 1;
  unsigned D_NOT_A              : 1;
  unsigned CKE                  : 1;
  unsigned SMP                  : 1;
  } __SSP1STATbits_t;

extern __at(0x0214) volatile __SSP1STATbits_t SSP1STATbits;

#define _BF                     0x01
#define _UA                     0x02
#define _R_NOT_W                0x04
#define _S                      0x08
#define _P                      0x10
#define _D_NOT_A                0x20
#define _CKE                    0x40
#define _SMP                    0x80

//==============================================================================


//==============================================================================
//        SSPSTAT Bits

extern __at(0x0214) __sfr SSPSTAT;

typedef struct
  {
  unsigned BF                   : 1;
  unsigned UA                   : 1;
  unsigned R_NOT_W              : 1;
  unsigned S                    : 1;
  unsigned P                    : 1;
  unsigned D_NOT_A              : 1;
  unsigned CKE                  : 1;
  unsigned SMP                  : 1;
  } __SSPSTATbits_t;

extern __at(0x0214) volatile __SSPSTATbits_t SSPSTATbits;

#define _SSPSTAT_BF             0x01
#define _SSPSTAT_UA             0x02
#define _SSPSTAT_R_NOT_W        0x04
#define _SSPSTAT_S              0x08
#define _SSPSTAT_P              0x10
#define _SSPSTAT_D_NOT_A        0x20
#define _SSPSTAT_CKE            0x40
#define _SSPSTAT_SMP            0x80

//==============================================================================


//==============================================================================
//        SSP1CON Bits

extern __at(0x0215) __sfr SSP1CON;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSP1CONbits_t;

extern __at(0x0215) volatile __SSP1CONbits_t SSP1CONbits;

#define _SSPM0                  0x01
#define _SSPM1                  0x02
#define _SSPM2                  0x04
#define _SSPM3                  0x08
#define _CKP                    0x10
#define _SSPEN                  0x20
#define _SSPOV                  0x40
#define _WCOL                   0x80

//==============================================================================


//==============================================================================
//        SSP1CON1 Bits

extern __at(0x0215) __sfr SSP1CON1;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSP1CON1bits_t;

extern __at(0x0215) volatile __SSP1CON1bits_t SSP1CON1bits;

#define _SSP1CON1_SSPM0         0x01
#define _SSP1CON1_SSPM1         0x02
#define _SSP1CON1_SSPM2         0x04
#define _SSP1CON1_SSPM3         0x08
#define _SSP1CON1_CKP           0x10
#define _SSP1CON1_SSPEN         0x20
#define _SSP1CON1_SSPOV         0x40
#define _SSP1CON1_WCOL          0x80

//==============================================================================


//==============================================================================
//        SSPCON Bits

extern __at(0x0215) __sfr SSPCON;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSPCONbits_t;

extern __at(0x0215) volatile __SSPCONbits_t SSPCONbits;

#define _SSPCON_SSPM0           0x01
#define _SSPCON_SSPM1           0x02
#define _SSPCON_SSPM2           0x04
#define _SSPCON_SSPM3           0x08
#define _SSPCON_CKP             0x10
#define _SSPCON_SSPEN           0x20
#define _SSPCON_SSPOV           0x40
#define _SSPCON_WCOL            0x80

//==============================================================================


//==============================================================================
//        SSPCON1 Bits

extern __at(0x0215) __sfr SSPCON1;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSPCON1bits_t;

extern __at(0x0215) volatile __SSPCON1bits_t SSPCON1bits;

#define _SSPCON1_SSPM0          0x01
#define _SSPCON1_SSPM1          0x02
#define _SSPCON1_SSPM2          0x04
#define _SSPCON1_SSPM3          0x08
#define _SSPCON1_CKP            0x10
#define _SSPCON1_SSPEN          0x20
#define _SSPCON1_SSPOV          0x40
#define _SSPCON1_WCOL           0x80

//==============================================================================


//==============================================================================
//        SSP1CON2 Bits

extern __at(0x0216) __sfr SSP1CON2;

typedef struct
  {
  unsigned SEN                  : 1;
  unsigned RSEN                 : 1;
  unsigned PEN                  : 1;
  unsigned RCEN                 : 1;
  unsigned ACKEN                : 1;
  unsigned ACKDT                : 1;
  unsigned ACKSTAT              : 1;
  unsigned GCEN                 : 1;
  } __SSP1CON2bits_t;

extern __at(0x0216) volatile __SSP1CON2bits_t SSP1CON2bits;

#define _SEN                    0x01
#define _RSEN                   0x02
#define _PEN                    0x04
#define _RCEN                   0x08
#define _ACKEN                  0x10
#define _ACKDT                  0x20
#define _ACKSTAT                0x40
#define _GCEN                   0x80

//==============================================================================


//==============================================================================
//        SSPCON2 Bits

extern __at(0x0216) __sfr SSPCON2;

typedef struct
  {
  unsigned SEN                  : 1;
  unsigned RSEN                 : 1;
  unsigned PEN                  : 1;
  unsigned RCEN                 : 1;
  unsigned ACKEN                : 1;
  unsigned ACKDT                : 1;
  unsigned ACKSTAT              : 1;
  unsigned GCEN                 : 1;
  } __SSPCON2bits_t;

extern __at(0x0216) volatile __SSPCON2bits_t SSPCON2bits;

#define _SSPCON2_SEN            0x01
#define _SSPCON2_RSEN           0x02
#define _SSPCON2_PEN            0x04
#define _SSPCON2_RCEN           0x08
#define _SSPCON2_ACKEN          0x10
#define _SSPCON2_ACKDT          0x20
#define _SSPCON2_ACKSTAT        0x40
#define _SSPCON2_GCEN           0x80

//==============================================================================


//==============================================================================
//        SSP1CON3 Bits

extern __at(0x0217) __sfr SSP1CON3;

typedef struct
  {
  unsigned DHEN                 : 1;
  unsigned AHEN                 : 1;
  unsigned SBCDE                : 1;
  unsigned SDAHT                : 1;
  unsigned BOEN                 : 1;
  unsigned SCIE                 : 1;
  unsigned PCIE                 : 1;
  unsigned ACKTIM               : 1;
  } __SSP1CON3bits_t;

extern __at(0x0217) volatile __SSP1CON3bits_t SSP1CON3bits;

#define _DHEN                   0x01
#define _AHEN                   0x02
#define _SBCDE                  0x04
#define _SDAHT                  0x08
#define _BOEN                   0x10
#define _SCIE                   0x20
#define _PCIE                   0x40
#define _ACKTIM                 0x80

//==============================================================================


//==============================================================================
//        SSPCON3 Bits

extern __at(0x0217) __sfr SSPCON3;

typedef struct
  {
  unsigned DHEN                 : 1;
  unsigned AHEN                 : 1;
  unsigned SBCDE                : 1;
  unsigned SDAHT                : 1;
  unsigned BOEN                 : 1;
  unsigned SCIE                 : 1;
  unsigned PCIE                 : 1;
  unsigned ACKTIM               : 1;
  } __SSPCON3bits_t;

extern __at(0x0217) volatile __SSPCON3bits_t SSPCON3bits;

#define _SSPCON3_DHEN           0x01
#define _SSPCON3_AHEN           0x02
#define _SSPCON3_SBCDE          0x04
#define _SSPCON3_SDAHT          0x08
#define _SSPCON3_BOEN           0x10
#define _SSPCON3_SCIE           0x20
#define _SSPCON3_PCIE           0x40
#define _SSPCON3_ACKTIM         0x80

//==============================================================================


//==============================================================================
//        MD3CON0 Bits

extern __at(0x021B) __sfr MD3CON0;

typedef union
  {
  struct
    {
    unsigned BIT                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned OPOL               : 1;
    unsigned OUT                : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned MD3BIT             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned MD3OPOL            : 1;
    unsigned MD3OUT             : 1;
    unsigned                    : 1;
    unsigned MD3EN              : 1;
    };
  } __MD3CON0bits_t;

extern __at(0x021B) volatile __MD3CON0bits_t MD3CON0bits;

#define _MD3CON0_BIT            0x01
#define _MD3CON0_MD3BIT         0x01
#define _MD3CON0_OPOL           0x10
#define _MD3CON0_MD3OPOL        0x10
#define _MD3CON0_OUT            0x20
#define _MD3CON0_MD3OUT         0x20
#define _MD3CON0_EN             0x80
#define _MD3CON0_MD3EN          0x80

//==============================================================================


//==============================================================================
//        MD3CON1 Bits

extern __at(0x021C) __sfr MD3CON1;

typedef union
  {
  struct
    {
    unsigned CLSYNC             : 1;
    unsigned CLPOL              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CHSYNC             : 1;
    unsigned CHPOL              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned MD3CLSYNC          : 1;
    unsigned MD3CLPOL           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned MD3CHSYNC          : 1;
    unsigned MD3CHPOL           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __MD3CON1bits_t;

extern __at(0x021C) volatile __MD3CON1bits_t MD3CON1bits;

#define _MD3CON1_CLSYNC         0x01
#define _MD3CON1_MD3CLSYNC      0x01
#define _MD3CON1_CLPOL          0x02
#define _MD3CON1_MD3CLPOL       0x02
#define _MD3CON1_CHSYNC         0x10
#define _MD3CON1_MD3CHSYNC      0x10
#define _MD3CON1_CHPOL          0x20
#define _MD3CON1_MD3CHPOL       0x20

//==============================================================================


//==============================================================================
//        MD3SRC Bits

extern __at(0x021D) __sfr MD3SRC;

typedef union
  {
  struct
    {
    unsigned MS0                : 1;
    unsigned MS1                : 1;
    unsigned MS2                : 1;
    unsigned MS3                : 1;
    unsigned MS4                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned MD3MS0             : 1;
    unsigned MD3MS1             : 1;
    unsigned MD3MS2             : 1;
    unsigned MD3MS3             : 1;
    unsigned MD3MS4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned MD3MS              : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned MS                 : 5;
    unsigned                    : 3;
    };
  } __MD3SRCbits_t;

extern __at(0x021D) volatile __MD3SRCbits_t MD3SRCbits;

#define _MD3SRC_MS0             0x01
#define _MD3SRC_MD3MS0          0x01
#define _MD3SRC_MS1             0x02
#define _MD3SRC_MD3MS1          0x02
#define _MD3SRC_MS2             0x04
#define _MD3SRC_MD3MS2          0x04
#define _MD3SRC_MS3             0x08
#define _MD3SRC_MD3MS3          0x08
#define _MD3SRC_MS4             0x10
#define _MD3SRC_MD3MS4          0x10

//==============================================================================


//==============================================================================
//        MD3CARL Bits

extern __at(0x021E) __sfr MD3CARL;

typedef union
  {
  struct
    {
    unsigned CL0                : 1;
    unsigned CL1                : 1;
    unsigned CL2                : 1;
    unsigned CL3                : 1;
    unsigned CL4                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned MD3CL0             : 1;
    unsigned MD3CL1             : 1;
    unsigned MD3CL2             : 1;
    unsigned MD3CL3             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CL                 : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned MD3CL              : 4;
    unsigned                    : 4;
    };
  } __MD3CARLbits_t;

extern __at(0x021E) volatile __MD3CARLbits_t MD3CARLbits;

#define _MD3CARL_CL0            0x01
#define _MD3CARL_MD3CL0         0x01
#define _MD3CARL_CL1            0x02
#define _MD3CARL_MD3CL1         0x02
#define _MD3CARL_CL2            0x04
#define _MD3CARL_MD3CL2         0x04
#define _MD3CARL_CL3            0x08
#define _MD3CARL_MD3CL3         0x08
#define _MD3CARL_CL4            0x10

//==============================================================================


//==============================================================================
//        MD3CARH Bits

extern __at(0x021F) __sfr MD3CARH;

typedef union
  {
  struct
    {
    unsigned CH0                : 1;
    unsigned CH1                : 1;
    unsigned CH2                : 1;
    unsigned CH3                : 1;
    unsigned CH4                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned MD3CH0             : 1;
    unsigned MD3CH1             : 1;
    unsigned MD3CH2             : 1;
    unsigned MD3CH3             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CH                 : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned MD3CH              : 4;
    unsigned                    : 4;
    };
  } __MD3CARHbits_t;

extern __at(0x021F) volatile __MD3CARHbits_t MD3CARHbits;

#define _MD3CARH_CH0            0x01
#define _MD3CARH_MD3CH0         0x01
#define _MD3CARH_CH1            0x02
#define _MD3CARH_MD3CH1         0x02
#define _MD3CARH_CH2            0x04
#define _MD3CARH_MD3CH2         0x04
#define _MD3CARH_CH3            0x08
#define _MD3CARH_MD3CH3         0x08
#define _MD3CARH_CH4            0x10

//==============================================================================


//==============================================================================
//        ODCONA Bits

extern __at(0x028C) __sfr ODCONA;

typedef struct
  {
  unsigned ODA0                 : 1;
  unsigned ODA1                 : 1;
  unsigned ODA2                 : 1;
  unsigned ODA3                 : 1;
  unsigned ODA4                 : 1;
  unsigned ODA5                 : 1;
  unsigned ODA6                 : 1;
  unsigned ODA7                 : 1;
  } __ODCONAbits_t;

extern __at(0x028C) volatile __ODCONAbits_t ODCONAbits;

#define _ODA0                   0x01
#define _ODA1                   0x02
#define _ODA2                   0x04
#define _ODA3                   0x08
#define _ODA4                   0x10
#define _ODA5                   0x20
#define _ODA6                   0x40
#define _ODA7                   0x80

//==============================================================================


//==============================================================================
//        ODCONB Bits

extern __at(0x028D) __sfr ODCONB;

typedef union
  {
  struct
    {
    unsigned ODA0               : 1;
    unsigned ODA1               : 1;
    unsigned ODA2               : 1;
    unsigned ODA3               : 1;
    unsigned ODB4               : 1;
    unsigned ODB5               : 1;
    unsigned ODB6               : 1;
    unsigned ODB7               : 1;
    };

  struct
    {
    unsigned ODA                : 4;
    unsigned                    : 4;
    };
  } __ODCONBbits_t;

extern __at(0x028D) volatile __ODCONBbits_t ODCONBbits;

#define _ODCONB_ODA0            0x01
#define _ODCONB_ODA1            0x02
#define _ODCONB_ODA2            0x04
#define _ODCONB_ODA3            0x08
#define _ODCONB_ODB4            0x10
#define _ODCONB_ODB5            0x20
#define _ODCONB_ODB6            0x40
#define _ODCONB_ODB7            0x80

//==============================================================================


//==============================================================================
//        ODCONC Bits

extern __at(0x028E) __sfr ODCONC;

typedef struct
  {
  unsigned ODC0                 : 1;
  unsigned ODC1                 : 1;
  unsigned ODC2                 : 1;
  unsigned ODC3                 : 1;
  unsigned ODC4                 : 1;
  unsigned ODC5                 : 1;
  unsigned ODC6                 : 1;
  unsigned ODC7                 : 1;
  } __ODCONCbits_t;

extern __at(0x028E) volatile __ODCONCbits_t ODCONCbits;

#define _ODC0                   0x01
#define _ODC1                   0x02
#define _ODC2                   0x04
#define _ODC3                   0x08
#define _ODC4                   0x10
#define _ODC5                   0x20
#define _ODC6                   0x40
#define _ODC7                   0x80

//==============================================================================

extern __at(0x0291) __sfr CCPR1;
extern __at(0x0291) __sfr CCPR1L;
extern __at(0x0292) __sfr CCPR1H;

//==============================================================================
//        CCP1CON Bits

extern __at(0x0293) __sfr CCP1CON;

typedef union
  {
  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned MODE3              : 1;
    unsigned FMT                : 1;
    unsigned OUT                : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned CCP1MODE0          : 1;
    unsigned CCP1MODE1          : 1;
    unsigned CCP1MODE2          : 1;
    unsigned CCP1MODE3          : 1;
    unsigned CCP1FMT            : 1;
    unsigned CCP1OUT            : 1;
    unsigned                    : 1;
    unsigned CCP1EN             : 1;
    };

  struct
    {
    unsigned CCP1MODE           : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned MODE               : 4;
    unsigned                    : 4;
    };
  } __CCP1CONbits_t;

extern __at(0x0293) volatile __CCP1CONbits_t CCP1CONbits;

#define _MODE0                  0x01
#define _CCP1MODE0              0x01
#define _MODE1                  0x02
#define _CCP1MODE1              0x02
#define _MODE2                  0x04
#define _CCP1MODE2              0x04
#define _MODE3                  0x08
#define _CCP1MODE3              0x08
#define _FMT                    0x10
#define _CCP1FMT                0x10
#define _OUT                    0x20
#define _CCP1OUT                0x20
#define _EN                     0x80
#define _CCP1EN                 0x80

//==============================================================================


//==============================================================================
//        CCP1CAP Bits

extern __at(0x0294) __sfr CCP1CAP;

typedef union
  {
  struct
    {
    unsigned CTS0               : 1;
    unsigned CTS1               : 1;
    unsigned CTS2               : 1;
    unsigned CTS3               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP1CTS0           : 1;
    unsigned CCP1CTS1           : 1;
    unsigned CCP1CTS2           : 1;
    unsigned CCP1CTS3           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CTS                : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned CCP1CTS            : 4;
    unsigned                    : 4;
    };
  } __CCP1CAPbits_t;

extern __at(0x0294) volatile __CCP1CAPbits_t CCP1CAPbits;

#define _CTS0                   0x01
#define _CCP1CTS0               0x01
#define _CTS1                   0x02
#define _CCP1CTS1               0x02
#define _CTS2                   0x04
#define _CCP1CTS2               0x04
#define _CTS3                   0x08
#define _CCP1CTS3               0x08

//==============================================================================

extern __at(0x0295) __sfr CCPR2;
extern __at(0x0295) __sfr CCPR2L;
extern __at(0x0296) __sfr CCPR2H;

//==============================================================================
//        CCP2CON Bits

extern __at(0x0297) __sfr CCP2CON;

typedef union
  {
  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned MODE3              : 1;
    unsigned FMT                : 1;
    unsigned OUT                : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned CCP2MODE0          : 1;
    unsigned CCP2MODE1          : 1;
    unsigned CCP2MODE2          : 1;
    unsigned CCP2MODE3          : 1;
    unsigned CCP2FMT            : 1;
    unsigned CCP2OUT            : 1;
    unsigned                    : 1;
    unsigned CCP2EN             : 1;
    };

  struct
    {
    unsigned MODE               : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned CCP2MODE           : 4;
    unsigned                    : 4;
    };
  } __CCP2CONbits_t;

extern __at(0x0297) volatile __CCP2CONbits_t CCP2CONbits;

#define _CCP2CON_MODE0          0x01
#define _CCP2CON_CCP2MODE0      0x01
#define _CCP2CON_MODE1          0x02
#define _CCP2CON_CCP2MODE1      0x02
#define _CCP2CON_MODE2          0x04
#define _CCP2CON_CCP2MODE2      0x04
#define _CCP2CON_MODE3          0x08
#define _CCP2CON_CCP2MODE3      0x08
#define _CCP2CON_FMT            0x10
#define _CCP2CON_CCP2FMT        0x10
#define _CCP2CON_OUT            0x20
#define _CCP2CON_CCP2OUT        0x20
#define _CCP2CON_EN             0x80
#define _CCP2CON_CCP2EN         0x80

//==============================================================================


//==============================================================================
//        CCP2CAP Bits

extern __at(0x0298) __sfr CCP2CAP;

typedef union
  {
  struct
    {
    unsigned CTS0               : 1;
    unsigned CTS1               : 1;
    unsigned CTS2               : 1;
    unsigned CTS3               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP2CTS0           : 1;
    unsigned CCP2CTS1           : 1;
    unsigned CCP2CTS2           : 1;
    unsigned CCP2CTS3           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP2CTS            : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned CTS                : 4;
    unsigned                    : 4;
    };
  } __CCP2CAPbits_t;

extern __at(0x0298) volatile __CCP2CAPbits_t CCP2CAPbits;

#define _CCP2CAP_CTS0           0x01
#define _CCP2CAP_CCP2CTS0       0x01
#define _CCP2CAP_CTS1           0x02
#define _CCP2CAP_CCP2CTS1       0x02
#define _CCP2CAP_CTS2           0x04
#define _CCP2CAP_CCP2CTS2       0x04
#define _CCP2CAP_CTS3           0x08
#define _CCP2CAP_CCP2CTS3       0x08

//==============================================================================

extern __at(0x0299) __sfr CCPR7;
extern __at(0x0299) __sfr CCPR7L;
extern __at(0x029A) __sfr CCPR7H;

//==============================================================================
//        CCP7CON Bits

extern __at(0x029B) __sfr CCP7CON;

typedef union
  {
  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned MODE3              : 1;
    unsigned FMT                : 1;
    unsigned OUT                : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned CCP7MODE0          : 1;
    unsigned CCP7MODE1          : 1;
    unsigned CCP7MODE2          : 1;
    unsigned CCP7MODE3          : 1;
    unsigned CCP7FMT            : 1;
    unsigned CCP7OUT            : 1;
    unsigned                    : 1;
    unsigned CCP7EN             : 1;
    };

  struct
    {
    unsigned MODE               : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned CCP7MODE           : 4;
    unsigned                    : 4;
    };
  } __CCP7CONbits_t;

extern __at(0x029B) volatile __CCP7CONbits_t CCP7CONbits;

#define _CCP7CON_MODE0          0x01
#define _CCP7CON_CCP7MODE0      0x01
#define _CCP7CON_MODE1          0x02
#define _CCP7CON_CCP7MODE1      0x02
#define _CCP7CON_MODE2          0x04
#define _CCP7CON_CCP7MODE2      0x04
#define _CCP7CON_MODE3          0x08
#define _CCP7CON_CCP7MODE3      0x08
#define _CCP7CON_FMT            0x10
#define _CCP7CON_CCP7FMT        0x10
#define _CCP7CON_OUT            0x20
#define _CCP7CON_CCP7OUT        0x20
#define _CCP7CON_EN             0x80
#define _CCP7CON_CCP7EN         0x80

//==============================================================================


//==============================================================================
//        CCP7CAP Bits

extern __at(0x029C) __sfr CCP7CAP;

typedef union
  {
  struct
    {
    unsigned CTS0               : 1;
    unsigned CTS1               : 1;
    unsigned CTS2               : 1;
    unsigned CTS3               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP7CTS0           : 1;
    unsigned CCP7CTS1           : 1;
    unsigned CCP7CTS2           : 1;
    unsigned CCP7CTS3           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CTS                : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned CCP7CTS            : 4;
    unsigned                    : 4;
    };
  } __CCP7CAPbits_t;

extern __at(0x029C) volatile __CCP7CAPbits_t CCP7CAPbits;

#define _CCP7CAP_CTS0           0x01
#define _CCP7CAP_CCP7CTS0       0x01
#define _CCP7CAP_CTS1           0x02
#define _CCP7CAP_CCP7CTS1       0x02
#define _CCP7CAP_CTS2           0x04
#define _CCP7CAP_CCP7CTS2       0x04
#define _CCP7CAP_CTS3           0x08
#define _CCP7CAP_CCP7CTS3       0x08

//==============================================================================


//==============================================================================
//        CCPTMRS1 Bits

extern __at(0x029E) __sfr CCPTMRS1;

typedef union
  {
  struct
    {
    unsigned C1TSEL0            : 1;
    unsigned C1TSEL1            : 1;
    unsigned C2TSEL0            : 1;
    unsigned C2TSEL1            : 1;
    unsigned C7TSEL0            : 1;
    unsigned C7TSEL1            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned C1TSEL             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned C2TSEL             : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned C7TSEL             : 2;
    unsigned                    : 2;
    };
  } __CCPTMRS1bits_t;

extern __at(0x029E) volatile __CCPTMRS1bits_t CCPTMRS1bits;

#define _C1TSEL0                0x01
#define _C1TSEL1                0x02
#define _C2TSEL0                0x04
#define _C2TSEL1                0x08
#define _C7TSEL0                0x10
#define _C7TSEL1                0x20

//==============================================================================


//==============================================================================
//        CCPTMRS2 Bits

extern __at(0x029F) __sfr CCPTMRS2;

typedef union
  {
  struct
    {
    unsigned P3TSEL0            : 1;
    unsigned P3TSEL1            : 1;
    unsigned P4TSEL0            : 1;
    unsigned P5TSEL1            : 1;
    unsigned P9TSEL0            : 1;
    unsigned P9TSEL1            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned P3TSEL             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 4;
    unsigned P9TSEL             : 2;
    unsigned                    : 2;
    };
  } __CCPTMRS2bits_t;

extern __at(0x029F) volatile __CCPTMRS2bits_t CCPTMRS2bits;

#define _P3TSEL0                0x01
#define _P3TSEL1                0x02
#define _P4TSEL0                0x04
#define _P5TSEL1                0x08
#define _P9TSEL0                0x10
#define _P9TSEL1                0x20

//==============================================================================


//==============================================================================
//        SLRCONA Bits

extern __at(0x030C) __sfr SLRCONA;

typedef struct
  {
  unsigned SLRA0                : 1;
  unsigned SLRA1                : 1;
  unsigned SLRA2                : 1;
  unsigned SLRA3                : 1;
  unsigned SLRA4                : 1;
  unsigned SLRA5                : 1;
  unsigned SLRA6                : 1;
  unsigned SLRA7                : 1;
  } __SLRCONAbits_t;

extern __at(0x030C) volatile __SLRCONAbits_t SLRCONAbits;

#define _SLRA0                  0x01
#define _SLRA1                  0x02
#define _SLRA2                  0x04
#define _SLRA3                  0x08
#define _SLRA4                  0x10
#define _SLRA5                  0x20
#define _SLRA6                  0x40
#define _SLRA7                  0x80

//==============================================================================


//==============================================================================
//        SLRCONB Bits

extern __at(0x030D) __sfr SLRCONB;

typedef struct
  {
  unsigned SLRB0                : 1;
  unsigned SLRB1                : 1;
  unsigned SLRB2                : 1;
  unsigned SLRB3                : 1;
  unsigned SLRB4                : 1;
  unsigned SLRB5                : 1;
  unsigned SLRB6                : 1;
  unsigned SLRB7                : 1;
  } __SLRCONBbits_t;

extern __at(0x030D) volatile __SLRCONBbits_t SLRCONBbits;

#define _SLRB0                  0x01
#define _SLRB1                  0x02
#define _SLRB2                  0x04
#define _SLRB3                  0x08
#define _SLRB4                  0x10
#define _SLRB5                  0x20
#define _SLRB6                  0x40
#define _SLRB7                  0x80

//==============================================================================


//==============================================================================
//        SLRCONC Bits

extern __at(0x030E) __sfr SLRCONC;

typedef struct
  {
  unsigned SLRC0                : 1;
  unsigned SLRC1                : 1;
  unsigned SLRC2                : 1;
  unsigned SLRC3                : 1;
  unsigned SLRC4                : 1;
  unsigned SLRC5                : 1;
  unsigned SLRC6                : 1;
  unsigned SLRC7                : 1;
  } __SLRCONCbits_t;

extern __at(0x030E) volatile __SLRCONCbits_t SLRCONCbits;

#define _SLRC0                  0x01
#define _SLRC1                  0x02
#define _SLRC2                  0x04
#define _SLRC3                  0x08
#define _SLRC4                  0x10
#define _SLRC5                  0x20
#define _SLRC6                  0x40
#define _SLRC7                  0x80

//==============================================================================


//==============================================================================
//        MD1CON0 Bits

extern __at(0x0315) __sfr MD1CON0;

typedef union
  {
  struct
    {
    unsigned BIT                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned OPOL               : 1;
    unsigned OUT                : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned MD1BIT             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned MD1OPOL            : 1;
    unsigned MD1OUT             : 1;
    unsigned                    : 1;
    unsigned MD1EN              : 1;
    };
  } __MD1CON0bits_t;

extern __at(0x0315) volatile __MD1CON0bits_t MD1CON0bits;

#define _MD1CON0_BIT            0x01
#define _MD1CON0_MD1BIT         0x01
#define _MD1CON0_OPOL           0x10
#define _MD1CON0_MD1OPOL        0x10
#define _MD1CON0_OUT            0x20
#define _MD1CON0_MD1OUT         0x20
#define _MD1CON0_EN             0x80
#define _MD1CON0_MD1EN          0x80

//==============================================================================


//==============================================================================
//        MD1CON1 Bits

extern __at(0x0316) __sfr MD1CON1;

typedef union
  {
  struct
    {
    unsigned CLSYNC             : 1;
    unsigned CLPOL              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CHSYNC             : 1;
    unsigned CHPOL              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned MD1CLSYNC          : 1;
    unsigned MD1CLPOL           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned MD1CHSYNC          : 1;
    unsigned MD1CHPOL           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __MD1CON1bits_t;

extern __at(0x0316) volatile __MD1CON1bits_t MD1CON1bits;

#define _CLSYNC                 0x01
#define _MD1CLSYNC              0x01
#define _CLPOL                  0x02
#define _MD1CLPOL               0x02
#define _CHSYNC                 0x10
#define _MD1CHSYNC              0x10
#define _CHPOL                  0x20
#define _MD1CHPOL               0x20

//==============================================================================


//==============================================================================
//        MD1SRC Bits

extern __at(0x0317) __sfr MD1SRC;

typedef union
  {
  struct
    {
    unsigned MS0                : 1;
    unsigned MS1                : 1;
    unsigned MS2                : 1;
    unsigned MS3                : 1;
    unsigned MS4                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned MD1MS0             : 1;
    unsigned MD1MS1             : 1;
    unsigned MD1MS2             : 1;
    unsigned MD1MS3             : 1;
    unsigned MD1MS4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned MS                 : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned MD1MS              : 5;
    unsigned                    : 3;
    };
  } __MD1SRCbits_t;

extern __at(0x0317) volatile __MD1SRCbits_t MD1SRCbits;

#define _MS0                    0x01
#define _MD1MS0                 0x01
#define _MS1                    0x02
#define _MD1MS1                 0x02
#define _MS2                    0x04
#define _MD1MS2                 0x04
#define _MS3                    0x08
#define _MD1MS3                 0x08
#define _MS4                    0x10
#define _MD1MS4                 0x10

//==============================================================================


//==============================================================================
//        MD1CARL Bits

extern __at(0x0318) __sfr MD1CARL;

typedef union
  {
  struct
    {
    unsigned CL0                : 1;
    unsigned CL1                : 1;
    unsigned CL2                : 1;
    unsigned CL3                : 1;
    unsigned CL4                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned MD1CL0             : 1;
    unsigned MD1CL1             : 1;
    unsigned MD1CL2             : 1;
    unsigned MD1CL3             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned MD1CL              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned CL                 : 5;
    unsigned                    : 3;
    };
  } __MD1CARLbits_t;

extern __at(0x0318) volatile __MD1CARLbits_t MD1CARLbits;

#define _CL0                    0x01
#define _MD1CL0                 0x01
#define _CL1                    0x02
#define _MD1CL1                 0x02
#define _CL2                    0x04
#define _MD1CL2                 0x04
#define _CL3                    0x08
#define _MD1CL3                 0x08
#define _CL4                    0x10

//==============================================================================


//==============================================================================
//        MD1CARH Bits

extern __at(0x0319) __sfr MD1CARH;

typedef union
  {
  struct
    {
    unsigned CH0                : 1;
    unsigned CH1                : 1;
    unsigned CH2                : 1;
    unsigned CH3                : 1;
    unsigned CH4                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned MD1CH0             : 1;
    unsigned MD1CH1             : 1;
    unsigned MD1CH2             : 1;
    unsigned MD1CH3             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned MD1CH              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned CH                 : 5;
    unsigned                    : 3;
    };
  } __MD1CARHbits_t;

extern __at(0x0319) volatile __MD1CARHbits_t MD1CARHbits;

#define _CH0                    0x01
#define _MD1CH0                 0x01
#define _CH1                    0x02
#define _MD1CH1                 0x02
#define _CH2                    0x04
#define _MD1CH2                 0x04
#define _CH3                    0x08
#define _MD1CH3                 0x08
#define _CH4                    0x10

//==============================================================================


//==============================================================================
//        MD2CON0 Bits

extern __at(0x031B) __sfr MD2CON0;

typedef union
  {
  struct
    {
    unsigned BIT                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned OPOL               : 1;
    unsigned OUT                : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned MD2BIT             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned MD2OPOL            : 1;
    unsigned MD2OUT             : 1;
    unsigned                    : 1;
    unsigned MD2EN              : 1;
    };
  } __MD2CON0bits_t;

extern __at(0x031B) volatile __MD2CON0bits_t MD2CON0bits;

#define _MD2CON0_BIT            0x01
#define _MD2CON0_MD2BIT         0x01
#define _MD2CON0_OPOL           0x10
#define _MD2CON0_MD2OPOL        0x10
#define _MD2CON0_OUT            0x20
#define _MD2CON0_MD2OUT         0x20
#define _MD2CON0_EN             0x80
#define _MD2CON0_MD2EN          0x80

//==============================================================================


//==============================================================================
//        MD2CON1 Bits

extern __at(0x031C) __sfr MD2CON1;

typedef union
  {
  struct
    {
    unsigned CLSYNC             : 1;
    unsigned CLPOL              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CHSYNC             : 1;
    unsigned CHPOL              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned MD2CLSYNC          : 1;
    unsigned MD2CLPOL           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned MD2CHSYNC          : 1;
    unsigned MD2CHPOL           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __MD2CON1bits_t;

extern __at(0x031C) volatile __MD2CON1bits_t MD2CON1bits;

#define _MD2CON1_CLSYNC         0x01
#define _MD2CON1_MD2CLSYNC      0x01
#define _MD2CON1_CLPOL          0x02
#define _MD2CON1_MD2CLPOL       0x02
#define _MD2CON1_CHSYNC         0x10
#define _MD2CON1_MD2CHSYNC      0x10
#define _MD2CON1_CHPOL          0x20
#define _MD2CON1_MD2CHPOL       0x20

//==============================================================================


//==============================================================================
//        MD2SRC Bits

extern __at(0x031D) __sfr MD2SRC;

typedef union
  {
  struct
    {
    unsigned MS0                : 1;
    unsigned MS1                : 1;
    unsigned MS2                : 1;
    unsigned MS3                : 1;
    unsigned MS4                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned MD2MS0             : 1;
    unsigned MD2MS1             : 1;
    unsigned MD2MS2             : 1;
    unsigned MD2MS3             : 1;
    unsigned MD2MS4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned MS                 : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned MD2MS              : 5;
    unsigned                    : 3;
    };
  } __MD2SRCbits_t;

extern __at(0x031D) volatile __MD2SRCbits_t MD2SRCbits;

#define _MD2SRC_MS0             0x01
#define _MD2SRC_MD2MS0          0x01
#define _MD2SRC_MS1             0x02
#define _MD2SRC_MD2MS1          0x02
#define _MD2SRC_MS2             0x04
#define _MD2SRC_MD2MS2          0x04
#define _MD2SRC_MS3             0x08
#define _MD2SRC_MD2MS3          0x08
#define _MD2SRC_MS4             0x10
#define _MD2SRC_MD2MS4          0x10

//==============================================================================


//==============================================================================
//        MD2CARL Bits

extern __at(0x031E) __sfr MD2CARL;

typedef union
  {
  struct
    {
    unsigned CL0                : 1;
    unsigned CL1                : 1;
    unsigned CL2                : 1;
    unsigned CL3                : 1;
    unsigned CL4                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned MD2CL0             : 1;
    unsigned MD2CL1             : 1;
    unsigned MD2CL2             : 1;
    unsigned MD2CL3             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned MD2CL              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned CL                 : 5;
    unsigned                    : 3;
    };
  } __MD2CARLbits_t;

extern __at(0x031E) volatile __MD2CARLbits_t MD2CARLbits;

#define _MD2CARL_CL0            0x01
#define _MD2CARL_MD2CL0         0x01
#define _MD2CARL_CL1            0x02
#define _MD2CARL_MD2CL1         0x02
#define _MD2CARL_CL2            0x04
#define _MD2CARL_MD2CL2         0x04
#define _MD2CARL_CL3            0x08
#define _MD2CARL_MD2CL3         0x08
#define _MD2CARL_CL4            0x10

//==============================================================================


//==============================================================================
//        MD2CARH Bits

extern __at(0x031F) __sfr MD2CARH;

typedef union
  {
  struct
    {
    unsigned CH0                : 1;
    unsigned CH1                : 1;
    unsigned CH2                : 1;
    unsigned CH3                : 1;
    unsigned CH4                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned MD2CH0             : 1;
    unsigned MD2CH1             : 1;
    unsigned MD2CH2             : 1;
    unsigned MD2CH3             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CH                 : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned MD2CH              : 4;
    unsigned                    : 4;
    };
  } __MD2CARHbits_t;

extern __at(0x031F) volatile __MD2CARHbits_t MD2CARHbits;

#define _MD2CARH_CH0            0x01
#define _MD2CARH_MD2CH0         0x01
#define _MD2CARH_CH1            0x02
#define _MD2CARH_MD2CH1         0x02
#define _MD2CARH_CH2            0x04
#define _MD2CARH_MD2CH2         0x04
#define _MD2CARH_CH3            0x08
#define _MD2CARH_MD2CH3         0x08
#define _MD2CARH_CH4            0x10

//==============================================================================


//==============================================================================
//        INLVLA Bits

extern __at(0x038C) __sfr INLVLA;

typedef union
  {
  struct
    {
    unsigned INLVLA0            : 1;
    unsigned INLVLA1            : 1;
    unsigned INLVLA2            : 1;
    unsigned INLVLA3            : 1;
    unsigned INLVLA4            : 1;
    unsigned INLVLA5            : 1;
    unsigned INLVA6             : 1;
    unsigned INLVA7             : 1;
    };

  struct
    {
    unsigned INLVLA             : 6;
    unsigned                    : 2;
    };
  } __INLVLAbits_t;

extern __at(0x038C) volatile __INLVLAbits_t INLVLAbits;

#define _INLVLA0                0x01
#define _INLVLA1                0x02
#define _INLVLA2                0x04
#define _INLVLA3                0x08
#define _INLVLA4                0x10
#define _INLVLA5                0x20
#define _INLVA6                 0x40
#define _INLVA7                 0x80

//==============================================================================


//==============================================================================
//        INLVLB Bits

extern __at(0x038D) __sfr INLVLB;

typedef union
  {
  struct
    {
    unsigned INLVB0             : 1;
    unsigned INLVB1             : 1;
    unsigned INLVB2             : 1;
    unsigned INLVB3             : 1;
    unsigned INLVLB4            : 1;
    unsigned INLVLB5            : 1;
    unsigned INLVLB6            : 1;
    unsigned INLVLB7            : 1;
    };

  struct
    {
    unsigned INLVB              : 4;
    unsigned                    : 4;
    };
  } __INLVLBbits_t;

extern __at(0x038D) volatile __INLVLBbits_t INLVLBbits;

#define _INLVB0                 0x01
#define _INLVB1                 0x02
#define _INLVB2                 0x04
#define _INLVB3                 0x08
#define _INLVLB4                0x10
#define _INLVLB5                0x20
#define _INLVLB6                0x40
#define _INLVLB7                0x80

//==============================================================================


//==============================================================================
//        INLVLC Bits

extern __at(0x038E) __sfr INLVLC;

typedef struct
  {
  unsigned INLVLC0              : 1;
  unsigned INLVLC1              : 1;
  unsigned INLVLC2              : 1;
  unsigned INLVLC3              : 1;
  unsigned INLVLC4              : 1;
  unsigned INLVLC5              : 1;
  unsigned INLVLC6              : 1;
  unsigned INLVLC7              : 1;
  } __INLVLCbits_t;

extern __at(0x038E) volatile __INLVLCbits_t INLVLCbits;

#define _INLVLC0                0x01
#define _INLVLC1                0x02
#define _INLVLC2                0x04
#define _INLVLC3                0x08
#define _INLVLC4                0x10
#define _INLVLC5                0x20
#define _INLVLC6                0x40
#define _INLVLC7                0x80

//==============================================================================


//==============================================================================
//        INLVE Bits

extern __at(0x0390) __sfr INLVE;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned INLVE3               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __INLVEbits_t;

extern __at(0x0390) volatile __INLVEbits_t INLVEbits;

#define _INLVE3                 0x08

//==============================================================================


//==============================================================================
//        IOCAP Bits

extern __at(0x0391) __sfr IOCAP;

typedef struct
  {
  unsigned IOCAP0               : 1;
  unsigned IOCAP1               : 1;
  unsigned IOCAP2               : 1;
  unsigned IOCAP3               : 1;
  unsigned IOCAP4               : 1;
  unsigned IOCAP5               : 1;
  unsigned IOCAP6               : 1;
  unsigned IOCAP7               : 1;
  } __IOCAPbits_t;

extern __at(0x0391) volatile __IOCAPbits_t IOCAPbits;

#define _IOCAP0                 0x01
#define _IOCAP1                 0x02
#define _IOCAP2                 0x04
#define _IOCAP3                 0x08
#define _IOCAP4                 0x10
#define _IOCAP5                 0x20
#define _IOCAP6                 0x40
#define _IOCAP7                 0x80

//==============================================================================


//==============================================================================
//        IOCAN Bits

extern __at(0x0392) __sfr IOCAN;

typedef struct
  {
  unsigned IOCAN0               : 1;
  unsigned IOCAN1               : 1;
  unsigned IOCAN2               : 1;
  unsigned IOCAN3               : 1;
  unsigned IOCAN4               : 1;
  unsigned IOCAN5               : 1;
  unsigned IOCAN6               : 1;
  unsigned IOCAN7               : 1;
  } __IOCANbits_t;

extern __at(0x0392) volatile __IOCANbits_t IOCANbits;

#define _IOCAN0                 0x01
#define _IOCAN1                 0x02
#define _IOCAN2                 0x04
#define _IOCAN3                 0x08
#define _IOCAN4                 0x10
#define _IOCAN5                 0x20
#define _IOCAN6                 0x40
#define _IOCAN7                 0x80

//==============================================================================


//==============================================================================
//        IOCAF Bits

extern __at(0x0393) __sfr IOCAF;

typedef struct
  {
  unsigned IOCAF0               : 1;
  unsigned IOCAF1               : 1;
  unsigned IOCAF2               : 1;
  unsigned IOCAF3               : 1;
  unsigned IOCAF4               : 1;
  unsigned IOCAF5               : 1;
  unsigned IOCAF6               : 1;
  unsigned IOCAF7               : 1;
  } __IOCAFbits_t;

extern __at(0x0393) volatile __IOCAFbits_t IOCAFbits;

#define _IOCAF0                 0x01
#define _IOCAF1                 0x02
#define _IOCAF2                 0x04
#define _IOCAF3                 0x08
#define _IOCAF4                 0x10
#define _IOCAF5                 0x20
#define _IOCAF6                 0x40
#define _IOCAF7                 0x80

//==============================================================================


//==============================================================================
//        IOCBP Bits

extern __at(0x0394) __sfr IOCBP;

typedef struct
  {
  unsigned IOCBP0               : 1;
  unsigned IOCBP1               : 1;
  unsigned IOCBP2               : 1;
  unsigned IOCBP3               : 1;
  unsigned IOCBP4               : 1;
  unsigned IOCBP5               : 1;
  unsigned IOCBP6               : 1;
  unsigned IOCBP7               : 1;
  } __IOCBPbits_t;

extern __at(0x0394) volatile __IOCBPbits_t IOCBPbits;

#define _IOCBP0                 0x01
#define _IOCBP1                 0x02
#define _IOCBP2                 0x04
#define _IOCBP3                 0x08
#define _IOCBP4                 0x10
#define _IOCBP5                 0x20
#define _IOCBP6                 0x40
#define _IOCBP7                 0x80

//==============================================================================


//==============================================================================
//        IOCBN Bits

extern __at(0x0395) __sfr IOCBN;

typedef struct
  {
  unsigned IOCBN0               : 1;
  unsigned IOCBN1               : 1;
  unsigned IOCBN2               : 1;
  unsigned IOCBN3               : 1;
  unsigned IOCBN4               : 1;
  unsigned IOCBN5               : 1;
  unsigned IOCBN6               : 1;
  unsigned IOCBN7               : 1;
  } __IOCBNbits_t;

extern __at(0x0395) volatile __IOCBNbits_t IOCBNbits;

#define _IOCBN0                 0x01
#define _IOCBN1                 0x02
#define _IOCBN2                 0x04
#define _IOCBN3                 0x08
#define _IOCBN4                 0x10
#define _IOCBN5                 0x20
#define _IOCBN6                 0x40
#define _IOCBN7                 0x80

//==============================================================================


//==============================================================================
//        IOCBF Bits

extern __at(0x0396) __sfr IOCBF;

typedef struct
  {
  unsigned IOCBF0               : 1;
  unsigned IOCBF1               : 1;
  unsigned IOCBF2               : 1;
  unsigned IOCBF3               : 1;
  unsigned IOCBF4               : 1;
  unsigned IOCBF5               : 1;
  unsigned IOCBF6               : 1;
  unsigned IOCBF7               : 1;
  } __IOCBFbits_t;

extern __at(0x0396) volatile __IOCBFbits_t IOCBFbits;

#define _IOCBF0                 0x01
#define _IOCBF1                 0x02
#define _IOCBF2                 0x04
#define _IOCBF3                 0x08
#define _IOCBF4                 0x10
#define _IOCBF5                 0x20
#define _IOCBF6                 0x40
#define _IOCBF7                 0x80

//==============================================================================


//==============================================================================
//        IOCCP Bits

extern __at(0x0397) __sfr IOCCP;

typedef struct
  {
  unsigned IOCCP0               : 1;
  unsigned IOCCP1               : 1;
  unsigned IOCCP2               : 1;
  unsigned IOCCP3               : 1;
  unsigned IOCCP4               : 1;
  unsigned IOCCP5               : 1;
  unsigned IOCCP6               : 1;
  unsigned IOCCP7               : 1;
  } __IOCCPbits_t;

extern __at(0x0397) volatile __IOCCPbits_t IOCCPbits;

#define _IOCCP0                 0x01
#define _IOCCP1                 0x02
#define _IOCCP2                 0x04
#define _IOCCP3                 0x08
#define _IOCCP4                 0x10
#define _IOCCP5                 0x20
#define _IOCCP6                 0x40
#define _IOCCP7                 0x80

//==============================================================================


//==============================================================================
//        IOCCN Bits

extern __at(0x0398) __sfr IOCCN;

typedef struct
  {
  unsigned IOCCN0               : 1;
  unsigned IOCCN1               : 1;
  unsigned IOCCN2               : 1;
  unsigned IOCCN3               : 1;
  unsigned IOCCN4               : 1;
  unsigned IOCCN5               : 1;
  unsigned IOCCN6               : 1;
  unsigned IOCCN7               : 1;
  } __IOCCNbits_t;

extern __at(0x0398) volatile __IOCCNbits_t IOCCNbits;

#define _IOCCN0                 0x01
#define _IOCCN1                 0x02
#define _IOCCN2                 0x04
#define _IOCCN3                 0x08
#define _IOCCN4                 0x10
#define _IOCCN5                 0x20
#define _IOCCN6                 0x40
#define _IOCCN7                 0x80

//==============================================================================


//==============================================================================
//        IOCCF Bits

extern __at(0x0399) __sfr IOCCF;

typedef struct
  {
  unsigned IOCCF0               : 1;
  unsigned IOCCF1               : 1;
  unsigned IOCCF2               : 1;
  unsigned IOCCF3               : 1;
  unsigned IOCCF4               : 1;
  unsigned IOCCF5               : 1;
  unsigned IOCCF6               : 1;
  unsigned IOCCF7               : 1;
  } __IOCCFbits_t;

extern __at(0x0399) volatile __IOCCFbits_t IOCCFbits;

#define _IOCCF0                 0x01
#define _IOCCF1                 0x02
#define _IOCCF2                 0x04
#define _IOCCF3                 0x08
#define _IOCCF4                 0x10
#define _IOCCF5                 0x20
#define _IOCCF6                 0x40
#define _IOCCF7                 0x80

//==============================================================================


//==============================================================================
//        IOCEP Bits

extern __at(0x039D) __sfr IOCEP;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned IOCEP3               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __IOCEPbits_t;

extern __at(0x039D) volatile __IOCEPbits_t IOCEPbits;

#define _IOCEP3                 0x08

//==============================================================================


//==============================================================================
//        IOCEN Bits

extern __at(0x039E) __sfr IOCEN;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned IOCEN3               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __IOCENbits_t;

extern __at(0x039E) volatile __IOCENbits_t IOCENbits;

#define _IOCEN3                 0x08

//==============================================================================


//==============================================================================
//        IOCEF Bits

extern __at(0x039F) __sfr IOCEF;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned IOCEF3               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __IOCEFbits_t;

extern __at(0x039F) volatile __IOCEFbits_t IOCEFbits;

#define _IOCEF3                 0x08

//==============================================================================


//==============================================================================
//        HIDRVB Bits

extern __at(0x040D) __sfr HIDRVB;

typedef union
  {
  struct
    {
    unsigned HIDB0              : 1;
    unsigned HIDB1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned HIDB               : 2;
    unsigned                    : 6;
    };
  } __HIDRVBbits_t;

extern __at(0x040D) volatile __HIDRVBbits_t HIDRVBbits;

#define _HIDB0                  0x01
#define _HIDB1                  0x02

//==============================================================================

extern __at(0x040F) __sfr TMR5;
extern __at(0x040F) __sfr TMR5L;
extern __at(0x0410) __sfr TMR5H;

//==============================================================================
//        T5CON Bits

extern __at(0x0411) __sfr T5CON;

typedef union
  {
  struct
    {
    unsigned ON                 : 1;
    unsigned                    : 1;
    unsigned NOT_SYNC           : 1;
    unsigned OSCEN              : 1;
    unsigned CKPS0              : 1;
    unsigned CKPS1              : 1;
    unsigned CS0                : 1;
    unsigned CS1                : 1;
    };

  struct
    {
    unsigned TMRON              : 1;
    unsigned                    : 1;
    unsigned SYNC               : 1;
    unsigned SOSCEN             : 1;
    unsigned T5CKPS0            : 1;
    unsigned T5CKPS1            : 1;
    unsigned T5CS0              : 1;
    unsigned T5CS1              : 1;
    };

  struct
    {
    unsigned TMR5ON             : 1;
    unsigned                    : 1;
    unsigned NOT_T5SYNC         : 1;
    unsigned T5OSCEN            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TMR5CS0            : 1;
    unsigned TMR5CS1            : 1;
    };

  struct
    {
    unsigned T5ON               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned CKPS               : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T5CKPS             : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned TMR5CS             : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned CS                 : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned T5CS               : 2;
    };
  } __T5CONbits_t;

extern __at(0x0411) volatile __T5CONbits_t T5CONbits;

#define _T5CON_ON               0x01
#define _T5CON_TMRON            0x01
#define _T5CON_TMR5ON           0x01
#define _T5CON_T5ON             0x01
#define _T5CON_NOT_SYNC         0x04
#define _T5CON_SYNC             0x04
#define _T5CON_NOT_T5SYNC       0x04
#define _T5CON_OSCEN            0x08
#define _T5CON_SOSCEN           0x08
#define _T5CON_T5OSCEN          0x08
#define _T5CON_CKPS0            0x10
#define _T5CON_T5CKPS0          0x10
#define _T5CON_CKPS1            0x20
#define _T5CON_T5CKPS1          0x20
#define _T5CON_CS0              0x40
#define _T5CON_T5CS0            0x40
#define _T5CON_TMR5CS0          0x40
#define _T5CON_CS1              0x80
#define _T5CON_T5CS1            0x80
#define _T5CON_TMR5CS1          0x80

//==============================================================================


//==============================================================================
//        T5GCON Bits

extern __at(0x0412) __sfr T5GCON;

typedef union
  {
  struct
    {
    unsigned GSS0               : 1;
    unsigned GSS1               : 1;
    unsigned GVAL               : 1;
    unsigned GGO_NOT_DONE       : 1;
    unsigned GSPM               : 1;
    unsigned GTM                : 1;
    unsigned GPOL               : 1;
    unsigned GE                 : 1;
    };

  struct
    {
    unsigned T5GSS0             : 1;
    unsigned T5GSS1             : 1;
    unsigned T5GVAL             : 1;
    unsigned T5GGO_NOT_DONE     : 1;
    unsigned T5GSPM             : 1;
    unsigned T5GTM              : 1;
    unsigned T5GPOL             : 1;
    unsigned T5GE               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TMR5GE             : 1;
    };

  struct
    {
    unsigned T5GSS              : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned GSS                : 2;
    unsigned                    : 6;
    };
  } __T5GCONbits_t;

extern __at(0x0412) volatile __T5GCONbits_t T5GCONbits;

#define _T5GCON_GSS0            0x01
#define _T5GCON_T5GSS0          0x01
#define _T5GCON_GSS1            0x02
#define _T5GCON_T5GSS1          0x02
#define _T5GCON_GVAL            0x04
#define _T5GCON_T5GVAL          0x04
#define _T5GCON_GGO_NOT_DONE    0x08
#define _T5GCON_T5GGO_NOT_DONE  0x08
#define _T5GCON_GSPM            0x10
#define _T5GCON_T5GSPM          0x10
#define _T5GCON_GTM             0x20
#define _T5GCON_T5GTM           0x20
#define _T5GCON_GPOL            0x40
#define _T5GCON_T5GPOL          0x40
#define _T5GCON_GE              0x80
#define _T5GCON_T5GE            0x80
#define _T5GCON_TMR5GE          0x80

//==============================================================================

extern __at(0x0413) __sfr T4TMR;
extern __at(0x0413) __sfr TMR4;
extern __at(0x0414) __sfr PR4;
extern __at(0x0414) __sfr T4PR;

//==============================================================================
//        T4CON Bits

extern __at(0x0415) __sfr T4CON;

typedef union
  {
  struct
    {
    unsigned OUTPS0             : 1;
    unsigned OUTPS1             : 1;
    unsigned OUTPS2             : 1;
    unsigned OUTPS3             : 1;
    unsigned CKPS0              : 1;
    unsigned CKPS1              : 1;
    unsigned CKPS2              : 1;
    unsigned ON                 : 1;
    };

  struct
    {
    unsigned T4OUTPS0           : 1;
    unsigned T4OUTPS1           : 1;
    unsigned T4OUTPS2           : 1;
    unsigned T4OUTPS3           : 1;
    unsigned T4CKPS0            : 1;
    unsigned T4CKPS1            : 1;
    unsigned T4CKPS2            : 1;
    unsigned T4ON               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TMR4ON             : 1;
    };

  struct
    {
    unsigned T4OUTPS            : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned OUTPS              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned CKPS               : 3;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T4CKPS             : 3;
    unsigned                    : 1;
    };
  } __T4CONbits_t;

extern __at(0x0415) volatile __T4CONbits_t T4CONbits;

#define _T4CON_OUTPS0           0x01
#define _T4CON_T4OUTPS0         0x01
#define _T4CON_OUTPS1           0x02
#define _T4CON_T4OUTPS1         0x02
#define _T4CON_OUTPS2           0x04
#define _T4CON_T4OUTPS2         0x04
#define _T4CON_OUTPS3           0x08
#define _T4CON_T4OUTPS3         0x08
#define _T4CON_CKPS0            0x10
#define _T4CON_T4CKPS0          0x10
#define _T4CON_CKPS1            0x20
#define _T4CON_T4CKPS1          0x20
#define _T4CON_CKPS2            0x40
#define _T4CON_T4CKPS2          0x40
#define _T4CON_ON               0x80
#define _T4CON_T4ON             0x80
#define _T4CON_TMR4ON           0x80

//==============================================================================


//==============================================================================
//        T4HLT Bits

extern __at(0x0416) __sfr T4HLT;

typedef union
  {
  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned MODE3              : 1;
    unsigned MODE4              : 1;
    unsigned CKSYNC             : 1;
    unsigned CKPOL              : 1;
    unsigned PSYNC              : 1;
    };

  struct
    {
    unsigned T4MODE0            : 1;
    unsigned T4MODE1            : 1;
    unsigned T4MODE2            : 1;
    unsigned T4MODE3            : 1;
    unsigned T4MODE4            : 1;
    unsigned T4CKSYNC           : 1;
    unsigned T4CKPOL            : 1;
    unsigned T4PSYNC            : 1;
    };

  struct
    {
    unsigned MODE               : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned T4MODE             : 5;
    unsigned                    : 3;
    };
  } __T4HLTbits_t;

extern __at(0x0416) volatile __T4HLTbits_t T4HLTbits;

#define _T4HLT_MODE0            0x01
#define _T4HLT_T4MODE0          0x01
#define _T4HLT_MODE1            0x02
#define _T4HLT_T4MODE1          0x02
#define _T4HLT_MODE2            0x04
#define _T4HLT_T4MODE2          0x04
#define _T4HLT_MODE3            0x08
#define _T4HLT_T4MODE3          0x08
#define _T4HLT_MODE4            0x10
#define _T4HLT_T4MODE4          0x10
#define _T4HLT_CKSYNC           0x20
#define _T4HLT_T4CKSYNC         0x20
#define _T4HLT_CKPOL            0x40
#define _T4HLT_T4CKPOL          0x40
#define _T4HLT_PSYNC            0x80
#define _T4HLT_T4PSYNC          0x80

//==============================================================================


//==============================================================================
//        T4CLKCON Bits

extern __at(0x0417) __sfr T4CLKCON;

typedef union
  {
  struct
    {
    unsigned CS0                : 1;
    unsigned CS1                : 1;
    unsigned CS2                : 1;
    unsigned CS3                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T4CS0              : 1;
    unsigned T4CS1              : 1;
    unsigned T4CS2              : 1;
    unsigned T4CS3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CS                 : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned T4CS               : 4;
    unsigned                    : 4;
    };
  } __T4CLKCONbits_t;

extern __at(0x0417) volatile __T4CLKCONbits_t T4CLKCONbits;

#define _T4CLKCON_CS0           0x01
#define _T4CLKCON_T4CS0         0x01
#define _T4CLKCON_CS1           0x02
#define _T4CLKCON_T4CS1         0x02
#define _T4CLKCON_CS2           0x04
#define _T4CLKCON_T4CS2         0x04
#define _T4CLKCON_CS3           0x08
#define _T4CLKCON_T4CS3         0x08

//==============================================================================


//==============================================================================
//        T4RST Bits

extern __at(0x0418) __sfr T4RST;

typedef union
  {
  struct
    {
    unsigned RSEL0              : 1;
    unsigned RSEL1              : 1;
    unsigned RSEL2              : 1;
    unsigned RSEL3              : 1;
    unsigned RSEL4              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T4RSEL0            : 1;
    unsigned T4RSEL1            : 1;
    unsigned T4RSEL2            : 1;
    unsigned T4RSEL3            : 1;
    unsigned T4RSEL4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RSEL               : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned T4RSEL             : 5;
    unsigned                    : 3;
    };
  } __T4RSTbits_t;

extern __at(0x0418) volatile __T4RSTbits_t T4RSTbits;

#define _T4RST_RSEL0            0x01
#define _T4RST_T4RSEL0          0x01
#define _T4RST_RSEL1            0x02
#define _T4RST_T4RSEL1          0x02
#define _T4RST_RSEL2            0x04
#define _T4RST_T4RSEL2          0x04
#define _T4RST_RSEL3            0x08
#define _T4RST_T4RSEL3          0x08
#define _T4RST_RSEL4            0x10
#define _T4RST_T4RSEL4          0x10

//==============================================================================

extern __at(0x041A) __sfr T6TMR;
extern __at(0x041A) __sfr TMR6;
extern __at(0x041B) __sfr PR6;
extern __at(0x041B) __sfr T6PR;

//==============================================================================
//        T6CON Bits

extern __at(0x041C) __sfr T6CON;

typedef union
  {
  struct
    {
    unsigned OUTPS0             : 1;
    unsigned OUTPS1             : 1;
    unsigned OUTPS2             : 1;
    unsigned OUTPS3             : 1;
    unsigned CKPS0              : 1;
    unsigned CKPS1              : 1;
    unsigned CKPS2              : 1;
    unsigned ON                 : 1;
    };

  struct
    {
    unsigned T6OUTPS0           : 1;
    unsigned T6OUTPS1           : 1;
    unsigned T6OUTPS2           : 1;
    unsigned T6OUTPS3           : 1;
    unsigned T6CKPS0            : 1;
    unsigned T6CKPS1            : 1;
    unsigned T6CKPS2            : 1;
    unsigned T6ON               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TMR6ON             : 1;
    };

  struct
    {
    unsigned T6OUTPS            : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned OUTPS              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned CKPS               : 3;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T6CKPS             : 3;
    unsigned                    : 1;
    };
  } __T6CONbits_t;

extern __at(0x041C) volatile __T6CONbits_t T6CONbits;

#define _T6CON_OUTPS0           0x01
#define _T6CON_T6OUTPS0         0x01
#define _T6CON_OUTPS1           0x02
#define _T6CON_T6OUTPS1         0x02
#define _T6CON_OUTPS2           0x04
#define _T6CON_T6OUTPS2         0x04
#define _T6CON_OUTPS3           0x08
#define _T6CON_T6OUTPS3         0x08
#define _T6CON_CKPS0            0x10
#define _T6CON_T6CKPS0          0x10
#define _T6CON_CKPS1            0x20
#define _T6CON_T6CKPS1          0x20
#define _T6CON_CKPS2            0x40
#define _T6CON_T6CKPS2          0x40
#define _T6CON_ON               0x80
#define _T6CON_T6ON             0x80
#define _T6CON_TMR6ON           0x80

//==============================================================================


//==============================================================================
//        T6HLT Bits

extern __at(0x041D) __sfr T6HLT;

typedef union
  {
  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned MODE3              : 1;
    unsigned MODE4              : 1;
    unsigned CKSYNC             : 1;
    unsigned CKPOL              : 1;
    unsigned PSYNC              : 1;
    };

  struct
    {
    unsigned T6MODE0            : 1;
    unsigned T6MODE1            : 1;
    unsigned T6MODE2            : 1;
    unsigned T6MODE3            : 1;
    unsigned T6MODE4            : 1;
    unsigned T6CKSYNC           : 1;
    unsigned T6CKPOL            : 1;
    unsigned T6PSYNC            : 1;
    };

  struct
    {
    unsigned T6MODE             : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned MODE               : 5;
    unsigned                    : 3;
    };
  } __T6HLTbits_t;

extern __at(0x041D) volatile __T6HLTbits_t T6HLTbits;

#define _T6HLT_MODE0            0x01
#define _T6HLT_T6MODE0          0x01
#define _T6HLT_MODE1            0x02
#define _T6HLT_T6MODE1          0x02
#define _T6HLT_MODE2            0x04
#define _T6HLT_T6MODE2          0x04
#define _T6HLT_MODE3            0x08
#define _T6HLT_T6MODE3          0x08
#define _T6HLT_MODE4            0x10
#define _T6HLT_T6MODE4          0x10
#define _T6HLT_CKSYNC           0x20
#define _T6HLT_T6CKSYNC         0x20
#define _T6HLT_CKPOL            0x40
#define _T6HLT_T6CKPOL          0x40
#define _T6HLT_PSYNC            0x80
#define _T6HLT_T6PSYNC          0x80

//==============================================================================


//==============================================================================
//        T6CLKCON Bits

extern __at(0x041E) __sfr T6CLKCON;

typedef union
  {
  struct
    {
    unsigned CS0                : 1;
    unsigned CS1                : 1;
    unsigned CS2                : 1;
    unsigned CS3                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T6CS0              : 1;
    unsigned T6CS1              : 1;
    unsigned T6CS2              : 1;
    unsigned T6CS3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CS                 : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned T6CS               : 4;
    unsigned                    : 4;
    };
  } __T6CLKCONbits_t;

extern __at(0x041E) volatile __T6CLKCONbits_t T6CLKCONbits;

#define _T6CLKCON_CS0           0x01
#define _T6CLKCON_T6CS0         0x01
#define _T6CLKCON_CS1           0x02
#define _T6CLKCON_T6CS1         0x02
#define _T6CLKCON_CS2           0x04
#define _T6CLKCON_T6CS2         0x04
#define _T6CLKCON_CS3           0x08
#define _T6CLKCON_T6CS3         0x08

//==============================================================================


//==============================================================================
//        T6RST Bits

extern __at(0x041F) __sfr T6RST;

typedef union
  {
  struct
    {
    unsigned RSEL0              : 1;
    unsigned RSEL1              : 1;
    unsigned RSEL2              : 1;
    unsigned RSEL3              : 1;
    unsigned RSEL4              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T6RSEL0            : 1;
    unsigned T6RSEL1            : 1;
    unsigned T6RSEL2            : 1;
    unsigned T6RSEL3            : 1;
    unsigned T6RSEL4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T6RSEL             : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned RSEL               : 5;
    unsigned                    : 3;
    };
  } __T6RSTbits_t;

extern __at(0x041F) volatile __T6RSTbits_t T6RSTbits;

#define _T6RST_RSEL0            0x01
#define _T6RST_T6RSEL0          0x01
#define _T6RST_RSEL1            0x02
#define _T6RST_T6RSEL1          0x02
#define _T6RST_RSEL2            0x04
#define _T6RST_T6RSEL2          0x04
#define _T6RST_RSEL3            0x08
#define _T6RST_T6RSEL3          0x08
#define _T6RST_RSEL4            0x10
#define _T6RST_T6RSEL4          0x10

//==============================================================================

extern __at(0x048E) __sfr ADRESL;
extern __at(0x048F) __sfr ADRESH;

//==============================================================================
//        ADCON0 Bits

extern __at(0x0490) __sfr ADCON0;

typedef struct
  {
  unsigned ADON                 : 1;
  unsigned GO                   : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __ADCON0bits_t;

extern __at(0x0490) volatile __ADCON0bits_t ADCON0bits;

#define _ADON                   0x01
#define _GO                     0x02

//==============================================================================


//==============================================================================
//        ADCON1 Bits

extern __at(0x0491) __sfr ADCON1;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned ADNREF               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned ADFM                 : 1;
  } __ADCON1bits_t;

extern __at(0x0491) volatile __ADCON1bits_t ADCON1bits;

#define _ADNREF                 0x04
#define _ADFM                   0x80

//==============================================================================

extern __at(0x0492) __sfr ADCON2;
extern __at(0x0493) __sfr T2TMR;
extern __at(0x0493) __sfr TMR2;
extern __at(0x0494) __sfr PR2;
extern __at(0x0494) __sfr T2PR;

//==============================================================================
//        T2CON Bits

extern __at(0x0495) __sfr T2CON;

typedef union
  {
  struct
    {
    unsigned OUTPS0             : 1;
    unsigned OUTPS1             : 1;
    unsigned OUTPS2             : 1;
    unsigned OUTPS3             : 1;
    unsigned CKPS0              : 1;
    unsigned CKPS1              : 1;
    unsigned CKPS2              : 1;
    unsigned ON                 : 1;
    };

  struct
    {
    unsigned T2OUTPS0           : 1;
    unsigned T2OUTPS1           : 1;
    unsigned T2OUTPS2           : 1;
    unsigned T2OUTPS3           : 1;
    unsigned T2CKPS0            : 1;
    unsigned T2CKPS1            : 1;
    unsigned T2CKPS2            : 1;
    unsigned T2ON               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TMR2ON             : 1;
    };

  struct
    {
    unsigned OUTPS              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned T2OUTPS            : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T2CKPS             : 3;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned CKPS               : 3;
    unsigned                    : 1;
    };
  } __T2CONbits_t;

extern __at(0x0495) volatile __T2CONbits_t T2CONbits;

#define _T2CON_OUTPS0           0x01
#define _T2CON_T2OUTPS0         0x01
#define _T2CON_OUTPS1           0x02
#define _T2CON_T2OUTPS1         0x02
#define _T2CON_OUTPS2           0x04
#define _T2CON_T2OUTPS2         0x04
#define _T2CON_OUTPS3           0x08
#define _T2CON_T2OUTPS3         0x08
#define _T2CON_CKPS0            0x10
#define _T2CON_T2CKPS0          0x10
#define _T2CON_CKPS1            0x20
#define _T2CON_T2CKPS1          0x20
#define _T2CON_CKPS2            0x40
#define _T2CON_T2CKPS2          0x40
#define _T2CON_ON               0x80
#define _T2CON_T2ON             0x80
#define _T2CON_TMR2ON           0x80

//==============================================================================


//==============================================================================
//        T2HLT Bits

extern __at(0x0496) __sfr T2HLT;

typedef union
  {
  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned MODE3              : 1;
    unsigned MODE4              : 1;
    unsigned CKSYNC             : 1;
    unsigned CKPOL              : 1;
    unsigned PSYNC              : 1;
    };

  struct
    {
    unsigned T2MODE0            : 1;
    unsigned T2MODE1            : 1;
    unsigned T2MODE2            : 1;
    unsigned T2MODE3            : 1;
    unsigned T2MODE4            : 1;
    unsigned T2CKSYNC           : 1;
    unsigned T2CKPOL            : 1;
    unsigned T2PSYNC            : 1;
    };

  struct
    {
    unsigned T2MODE             : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned MODE               : 5;
    unsigned                    : 3;
    };
  } __T2HLTbits_t;

extern __at(0x0496) volatile __T2HLTbits_t T2HLTbits;

#define _T2HLT_MODE0            0x01
#define _T2HLT_T2MODE0          0x01
#define _T2HLT_MODE1            0x02
#define _T2HLT_T2MODE1          0x02
#define _T2HLT_MODE2            0x04
#define _T2HLT_T2MODE2          0x04
#define _T2HLT_MODE3            0x08
#define _T2HLT_T2MODE3          0x08
#define _T2HLT_MODE4            0x10
#define _T2HLT_T2MODE4          0x10
#define _T2HLT_CKSYNC           0x20
#define _T2HLT_T2CKSYNC         0x20
#define _T2HLT_CKPOL            0x40
#define _T2HLT_T2CKPOL          0x40
#define _T2HLT_PSYNC            0x80
#define _T2HLT_T2PSYNC          0x80

//==============================================================================


//==============================================================================
//        T2CLKCON Bits

extern __at(0x0497) __sfr T2CLKCON;

typedef union
  {
  struct
    {
    unsigned CS0                : 1;
    unsigned CS1                : 1;
    unsigned CS2                : 1;
    unsigned CS3                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T2CS0              : 1;
    unsigned T2CS1              : 1;
    unsigned T2CS2              : 1;
    unsigned T2CS3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CS                 : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned T2CS               : 4;
    unsigned                    : 4;
    };
  } __T2CLKCONbits_t;

extern __at(0x0497) volatile __T2CLKCONbits_t T2CLKCONbits;

#define _T2CLKCON_CS0           0x01
#define _T2CLKCON_T2CS0         0x01
#define _T2CLKCON_CS1           0x02
#define _T2CLKCON_T2CS1         0x02
#define _T2CLKCON_CS2           0x04
#define _T2CLKCON_T2CS2         0x04
#define _T2CLKCON_CS3           0x08
#define _T2CLKCON_T2CS3         0x08

//==============================================================================


//==============================================================================
//        T2RST Bits

extern __at(0x0498) __sfr T2RST;

typedef union
  {
  struct
    {
    unsigned RSEL0              : 1;
    unsigned RSEL1              : 1;
    unsigned RSEL2              : 1;
    unsigned RSEL3              : 1;
    unsigned RSEL4              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T2RSEL0            : 1;
    unsigned T2RSEL1            : 1;
    unsigned T2RSEL2            : 1;
    unsigned T2RSEL3            : 1;
    unsigned T2RSEL4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T2RSEL             : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned RSEL               : 5;
    unsigned                    : 3;
    };
  } __T2RSTbits_t;

extern __at(0x0498) volatile __T2RSTbits_t T2RSTbits;

#define _RSEL0                  0x01
#define _T2RSEL0                0x01
#define _RSEL1                  0x02
#define _T2RSEL1                0x02
#define _RSEL2                  0x04
#define _T2RSEL2                0x04
#define _RSEL3                  0x08
#define _T2RSEL3                0x08
#define _RSEL4                  0x10
#define _T2RSEL4                0x10

//==============================================================================

extern __at(0x049A) __sfr T8TMR;
extern __at(0x049A) __sfr TMR8;
extern __at(0x049B) __sfr PR8;
extern __at(0x049B) __sfr T8PR;

//==============================================================================
//        T8CON Bits

extern __at(0x049C) __sfr T8CON;

typedef union
  {
  struct
    {
    unsigned OUTPS0             : 1;
    unsigned OUTPS1             : 1;
    unsigned OUTPS2             : 1;
    unsigned OUTPS3             : 1;
    unsigned CKPS0              : 1;
    unsigned CKPS1              : 1;
    unsigned CKPS2              : 1;
    unsigned ON                 : 1;
    };

  struct
    {
    unsigned T8OUTPS0           : 1;
    unsigned T8OUTPS1           : 1;
    unsigned T8OUTPS2           : 1;
    unsigned T8OUTPS3           : 1;
    unsigned T8CKPS0            : 1;
    unsigned T8CKPS1            : 1;
    unsigned T8CKPS2            : 1;
    unsigned T8ON               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TMR8ON             : 1;
    };

  struct
    {
    unsigned OUTPS              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned T8OUTPS            : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T8CKPS             : 3;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned CKPS               : 3;
    unsigned                    : 1;
    };
  } __T8CONbits_t;

extern __at(0x049C) volatile __T8CONbits_t T8CONbits;

#define _T8CON_OUTPS0           0x01
#define _T8CON_T8OUTPS0         0x01
#define _T8CON_OUTPS1           0x02
#define _T8CON_T8OUTPS1         0x02
#define _T8CON_OUTPS2           0x04
#define _T8CON_T8OUTPS2         0x04
#define _T8CON_OUTPS3           0x08
#define _T8CON_T8OUTPS3         0x08
#define _T8CON_CKPS0            0x10
#define _T8CON_T8CKPS0          0x10
#define _T8CON_CKPS1            0x20
#define _T8CON_T8CKPS1          0x20
#define _T8CON_CKPS2            0x40
#define _T8CON_T8CKPS2          0x40
#define _T8CON_ON               0x80
#define _T8CON_T8ON             0x80
#define _T8CON_TMR8ON           0x80

//==============================================================================


//==============================================================================
//        T8HLT Bits

extern __at(0x049D) __sfr T8HLT;

typedef union
  {
  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned MODE3              : 1;
    unsigned MODE4              : 1;
    unsigned CKSYNC             : 1;
    unsigned CKPOL              : 1;
    unsigned PSYNC              : 1;
    };

  struct
    {
    unsigned T8MODE0            : 1;
    unsigned T8MODE1            : 1;
    unsigned T8MODE2            : 1;
    unsigned T8MODE3            : 1;
    unsigned T8MODE4            : 1;
    unsigned T8CKSYNC           : 1;
    unsigned T8CKPOL            : 1;
    unsigned T8PSYNC            : 1;
    };

  struct
    {
    unsigned T8MODE             : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned MODE               : 5;
    unsigned                    : 3;
    };
  } __T8HLTbits_t;

extern __at(0x049D) volatile __T8HLTbits_t T8HLTbits;

#define _T8HLT_MODE0            0x01
#define _T8HLT_T8MODE0          0x01
#define _T8HLT_MODE1            0x02
#define _T8HLT_T8MODE1          0x02
#define _T8HLT_MODE2            0x04
#define _T8HLT_T8MODE2          0x04
#define _T8HLT_MODE3            0x08
#define _T8HLT_T8MODE3          0x08
#define _T8HLT_MODE4            0x10
#define _T8HLT_T8MODE4          0x10
#define _T8HLT_CKSYNC           0x20
#define _T8HLT_T8CKSYNC         0x20
#define _T8HLT_CKPOL            0x40
#define _T8HLT_T8CKPOL          0x40
#define _T8HLT_PSYNC            0x80
#define _T8HLT_T8PSYNC          0x80

//==============================================================================


//==============================================================================
//        T8CLKCON Bits

extern __at(0x049E) __sfr T8CLKCON;

typedef union
  {
  struct
    {
    unsigned CS0                : 1;
    unsigned CS1                : 1;
    unsigned CS2                : 1;
    unsigned CS3                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T8CS0              : 1;
    unsigned T8CS1              : 1;
    unsigned T8CS2              : 1;
    unsigned T8CS3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CS                 : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned T8CS               : 4;
    unsigned                    : 4;
    };
  } __T8CLKCONbits_t;

extern __at(0x049E) volatile __T8CLKCONbits_t T8CLKCONbits;

#define _T8CLKCON_CS0           0x01
#define _T8CLKCON_T8CS0         0x01
#define _T8CLKCON_CS1           0x02
#define _T8CLKCON_T8CS1         0x02
#define _T8CLKCON_CS2           0x04
#define _T8CLKCON_T8CS2         0x04
#define _T8CLKCON_CS3           0x08
#define _T8CLKCON_T8CS3         0x08

//==============================================================================


//==============================================================================
//        T8RST Bits

extern __at(0x049F) __sfr T8RST;

typedef union
  {
  struct
    {
    unsigned RSEL0              : 1;
    unsigned RSEL1              : 1;
    unsigned RSEL2              : 1;
    unsigned RSEL3              : 1;
    unsigned RSEL4              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T8RSEL0            : 1;
    unsigned T8RSEL1            : 1;
    unsigned T8RSEL2            : 1;
    unsigned T8RSEL3            : 1;
    unsigned T8RSEL4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RSEL               : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned T8RSEL             : 5;
    unsigned                    : 3;
    };
  } __T8RSTbits_t;

extern __at(0x049F) volatile __T8RSTbits_t T8RSTbits;

#define _T8RST_RSEL0            0x01
#define _T8RST_T8RSEL0          0x01
#define _T8RST_RSEL1            0x02
#define _T8RST_T8RSEL1          0x02
#define _T8RST_RSEL2            0x04
#define _T8RST_T8RSEL2          0x04
#define _T8RST_RSEL3            0x08
#define _T8RST_T8RSEL3          0x08
#define _T8RST_RSEL4            0x10
#define _T8RST_T8RSEL4          0x10

//==============================================================================

extern __at(0x050F) __sfr OPA1NCHS;
extern __at(0x0510) __sfr OPA1PCHS;

//==============================================================================
//        OPA1CON Bits

extern __at(0x0511) __sfr OPA1CON;

typedef union
  {
  struct
    {
    unsigned ORM0               : 1;
    unsigned ORM1               : 1;
    unsigned ORPOL              : 1;
    unsigned                    : 1;
    unsigned UG                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned OPA1ORM0           : 1;
    unsigned OPA1ORM1           : 1;
    unsigned OPA1ORPOL          : 1;
    unsigned                    : 1;
    unsigned OPA1UG             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned OPA1EN             : 1;
    };

  struct
    {
    unsigned OPA1ORM            : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned ORM                : 2;
    unsigned                    : 6;
    };
  } __OPA1CONbits_t;

extern __at(0x0511) volatile __OPA1CONbits_t OPA1CONbits;

#define _OPA1CON_ORM0           0x01
#define _OPA1CON_OPA1ORM0       0x01
#define _OPA1CON_ORM1           0x02
#define _OPA1CON_OPA1ORM1       0x02
#define _OPA1CON_ORPOL          0x04
#define _OPA1CON_OPA1ORPOL      0x04
#define _OPA1CON_UG             0x10
#define _OPA1CON_OPA1UG         0x10
#define _OPA1CON_EN             0x80
#define _OPA1CON_OPA1EN         0x80

//==============================================================================

extern __at(0x0512) __sfr OPA1ORS;
extern __at(0x0513) __sfr OPA2NCHS;
extern __at(0x0514) __sfr OPA2PCHS;

//==============================================================================
//        OPA2CON Bits

extern __at(0x0515) __sfr OPA2CON;

typedef union
  {
  struct
    {
    unsigned ORM0               : 1;
    unsigned ORM1               : 1;
    unsigned ORPOL              : 1;
    unsigned                    : 1;
    unsigned UG                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned OPA2ORM0           : 1;
    unsigned OPA2ORM1           : 1;
    unsigned OPA2ORPOL          : 1;
    unsigned                    : 1;
    unsigned OPA2UG             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned OPA2EN             : 1;
    };

  struct
    {
    unsigned OPA2ORM            : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned ORM                : 2;
    unsigned                    : 6;
    };
  } __OPA2CONbits_t;

extern __at(0x0515) volatile __OPA2CONbits_t OPA2CONbits;

#define _OPA2CON_ORM0           0x01
#define _OPA2CON_OPA2ORM0       0x01
#define _OPA2CON_ORM1           0x02
#define _OPA2CON_OPA2ORM1       0x02
#define _OPA2CON_ORPOL          0x04
#define _OPA2CON_OPA2ORPOL      0x04
#define _OPA2CON_UG             0x10
#define _OPA2CON_OPA2UG         0x10
#define _OPA2CON_EN             0x80
#define _OPA2CON_OPA2EN         0x80

//==============================================================================

extern __at(0x0516) __sfr OPA2ORS;
extern __at(0x0517) __sfr OPA3NCHS;
extern __at(0x0518) __sfr OPA3PCHS;

//==============================================================================
//        OPA3CON Bits

extern __at(0x0519) __sfr OPA3CON;

typedef union
  {
  struct
    {
    unsigned ORM0               : 1;
    unsigned ORM1               : 1;
    unsigned ORPOL              : 1;
    unsigned                    : 1;
    unsigned UG                 : 1;
    unsigned                    : 1;
    unsigned SP                 : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned OPA3ORM0           : 1;
    unsigned OPA3ORM1           : 1;
    unsigned OPA3ORPOL          : 1;
    unsigned                    : 1;
    unsigned OPA3UG             : 1;
    unsigned                    : 1;
    unsigned OPA3SP             : 1;
    unsigned OPA3EN             : 1;
    };

  struct
    {
    unsigned ORM                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned OPA3ORM            : 2;
    unsigned                    : 6;
    };
  } __OPA3CONbits_t;

extern __at(0x0519) volatile __OPA3CONbits_t OPA3CONbits;

#define _OPA3CON_ORM0           0x01
#define _OPA3CON_OPA3ORM0       0x01
#define _OPA3CON_ORM1           0x02
#define _OPA3CON_OPA3ORM1       0x02
#define _OPA3CON_ORPOL          0x04
#define _OPA3CON_OPA3ORPOL      0x04
#define _OPA3CON_UG             0x10
#define _OPA3CON_OPA3UG         0x10
#define _OPA3CON_SP             0x40
#define _OPA3CON_OPA3SP         0x40
#define _OPA3CON_EN             0x80
#define _OPA3CON_OPA3EN         0x80

//==============================================================================

extern __at(0x051A) __sfr OPA3ORS;

//==============================================================================
//        DACLD Bits

extern __at(0x058D) __sfr DACLD;

typedef struct
  {
  unsigned DAC1LD               : 1;
  unsigned DAC2LD               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned DAC5LD               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __DACLDbits_t;

extern __at(0x058D) volatile __DACLDbits_t DACLDbits;

#define _DAC1LD                 0x01
#define _DAC2LD                 0x02
#define _DAC5LD                 0x10

//==============================================================================


//==============================================================================
//        DAC1CON0 Bits

extern __at(0x058E) __sfr DAC1CON0;

typedef union
  {
  struct
    {
    unsigned NSS0               : 1;
    unsigned NSS1               : 1;
    unsigned PSS0               : 1;
    unsigned PSS1               : 1;
    unsigned OE2                : 1;
    unsigned OE1                : 1;
    unsigned FM                 : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned DACNSS0            : 1;
    unsigned DACNSS1            : 1;
    unsigned DACPSS0            : 1;
    unsigned DACPSS1            : 1;
    unsigned DACOE2             : 1;
    unsigned OE                 : 1;
    unsigned DACFM              : 1;
    unsigned DACEN              : 1;
    };

  struct
    {
    unsigned DAC1NSS0           : 1;
    unsigned DAC1NSS1           : 1;
    unsigned DAC1PSS0           : 1;
    unsigned DAC1PSS1           : 1;
    unsigned DAC1OE2            : 1;
    unsigned DACOE1             : 1;
    unsigned DAC1FM             : 1;
    unsigned DAC1EN             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned DACOE              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned DAC1OE1            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned NSS                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned DACNSS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned DAC1NSS            : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned DACPSS             : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PSS                : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 2;
    unsigned DAC1PSS            : 2;
    unsigned                    : 4;
    };
  } __DAC1CON0bits_t;

extern __at(0x058E) volatile __DAC1CON0bits_t DAC1CON0bits;

#define _DAC1CON0_NSS0          0x01
#define _DAC1CON0_DACNSS0       0x01
#define _DAC1CON0_DAC1NSS0      0x01
#define _DAC1CON0_NSS1          0x02
#define _DAC1CON0_DACNSS1       0x02
#define _DAC1CON0_DAC1NSS1      0x02
#define _DAC1CON0_PSS0          0x04
#define _DAC1CON0_DACPSS0       0x04
#define _DAC1CON0_DAC1PSS0      0x04
#define _DAC1CON0_PSS1          0x08
#define _DAC1CON0_DACPSS1       0x08
#define _DAC1CON0_DAC1PSS1      0x08
#define _DAC1CON0_OE2           0x10
#define _DAC1CON0_DACOE2        0x10
#define _DAC1CON0_DAC1OE2       0x10
#define _DAC1CON0_OE1           0x20
#define _DAC1CON0_OE            0x20
#define _DAC1CON0_DACOE1        0x20
#define _DAC1CON0_DACOE         0x20
#define _DAC1CON0_DAC1OE1       0x20
#define _DAC1CON0_FM            0x40
#define _DAC1CON0_DACFM         0x40
#define _DAC1CON0_DAC1FM        0x40
#define _DAC1CON0_EN            0x80
#define _DAC1CON0_DACEN         0x80
#define _DAC1CON0_DAC1EN        0x80

//==============================================================================


//==============================================================================
//        DAC1CON1 Bits

extern __at(0x058F) __sfr DAC1CON1;

typedef union
  {
  struct
    {
    unsigned REF0               : 1;
    unsigned REF1               : 1;
    unsigned REF2               : 1;
    unsigned REF3               : 1;
    unsigned REF4               : 1;
    unsigned REF5               : 1;
    unsigned REF6               : 1;
    unsigned REF7               : 1;
    };

  struct
    {
    unsigned DAC1REF0           : 1;
    unsigned DAC1REF1           : 1;
    unsigned DAC1REF2           : 1;
    unsigned DAC1REF3           : 1;
    unsigned DAC1REF4           : 1;
    unsigned DAC1REF5           : 1;
    unsigned DAC1REF6           : 1;
    unsigned DAC1REF7           : 1;
    };

  struct
    {
    unsigned R0                 : 1;
    unsigned R1                 : 1;
    unsigned R2                 : 1;
    unsigned R3                 : 1;
    unsigned R4                 : 1;
    unsigned R5                 : 1;
    unsigned R6                 : 1;
    unsigned R7                 : 1;
    };

  struct
    {
    unsigned DAC1R0             : 1;
    unsigned DAC1R1             : 1;
    unsigned DAC1R2             : 1;
    unsigned DAC1R3             : 1;
    unsigned DAC1R4             : 1;
    unsigned DAC1R5             : 1;
    unsigned DAC1R6             : 1;
    unsigned DAC1R7             : 1;
    };
  } __DAC1CON1bits_t;

extern __at(0x058F) volatile __DAC1CON1bits_t DAC1CON1bits;

#define _REF0                   0x01
#define _DAC1REF0               0x01
#define _R0                     0x01
#define _DAC1R0                 0x01
#define _REF1                   0x02
#define _DAC1REF1               0x02
#define _R1                     0x02
#define _DAC1R1                 0x02
#define _REF2                   0x04
#define _DAC1REF2               0x04
#define _R2                     0x04
#define _DAC1R2                 0x04
#define _REF3                   0x08
#define _DAC1REF3               0x08
#define _R3                     0x08
#define _DAC1R3                 0x08
#define _REF4                   0x10
#define _DAC1REF4               0x10
#define _R4                     0x10
#define _DAC1R4                 0x10
#define _REF5                   0x20
#define _DAC1REF5               0x20
#define _R5                     0x20
#define _DAC1R5                 0x20
#define _REF6                   0x40
#define _DAC1REF6               0x40
#define _R6                     0x40
#define _DAC1R6                 0x40
#define _REF7                   0x80
#define _DAC1REF7               0x80
#define _R7                     0x80
#define _DAC1R7                 0x80

//==============================================================================

extern __at(0x058F) __sfr DAC1REF;

//==============================================================================
//        DAC1REFL Bits

extern __at(0x058F) __sfr DAC1REFL;

typedef union
  {
  struct
    {
    unsigned REF0               : 1;
    unsigned REF1               : 1;
    unsigned REF2               : 1;
    unsigned REF3               : 1;
    unsigned REF4               : 1;
    unsigned REF5               : 1;
    unsigned REF6               : 1;
    unsigned REF7               : 1;
    };

  struct
    {
    unsigned DAC1REF0           : 1;
    unsigned DAC1REF1           : 1;
    unsigned DAC1REF2           : 1;
    unsigned DAC1REF3           : 1;
    unsigned DAC1REF4           : 1;
    unsigned DAC1REF5           : 1;
    unsigned DAC1REF6           : 1;
    unsigned DAC1REF7           : 1;
    };

  struct
    {
    unsigned R0                 : 1;
    unsigned R1                 : 1;
    unsigned R2                 : 1;
    unsigned R3                 : 1;
    unsigned R4                 : 1;
    unsigned R5                 : 1;
    unsigned R6                 : 1;
    unsigned R7                 : 1;
    };

  struct
    {
    unsigned DAC1R0             : 1;
    unsigned DAC1R1             : 1;
    unsigned DAC1R2             : 1;
    unsigned DAC1R3             : 1;
    unsigned DAC1R4             : 1;
    unsigned DAC1R5             : 1;
    unsigned DAC1R6             : 1;
    unsigned DAC1R7             : 1;
    };
  } __DAC1REFLbits_t;

extern __at(0x058F) volatile __DAC1REFLbits_t DAC1REFLbits;

#define _DAC1REFL_REF0          0x01
#define _DAC1REFL_DAC1REF0      0x01
#define _DAC1REFL_R0            0x01
#define _DAC1REFL_DAC1R0        0x01
#define _DAC1REFL_REF1          0x02
#define _DAC1REFL_DAC1REF1      0x02
#define _DAC1REFL_R1            0x02
#define _DAC1REFL_DAC1R1        0x02
#define _DAC1REFL_REF2          0x04
#define _DAC1REFL_DAC1REF2      0x04
#define _DAC1REFL_R2            0x04
#define _DAC1REFL_DAC1R2        0x04
#define _DAC1REFL_REF3          0x08
#define _DAC1REFL_DAC1REF3      0x08
#define _DAC1REFL_R3            0x08
#define _DAC1REFL_DAC1R3        0x08
#define _DAC1REFL_REF4          0x10
#define _DAC1REFL_DAC1REF4      0x10
#define _DAC1REFL_R4            0x10
#define _DAC1REFL_DAC1R4        0x10
#define _DAC1REFL_REF5          0x20
#define _DAC1REFL_DAC1REF5      0x20
#define _DAC1REFL_R5            0x20
#define _DAC1REFL_DAC1R5        0x20
#define _DAC1REFL_REF6          0x40
#define _DAC1REFL_DAC1REF6      0x40
#define _DAC1REFL_R6            0x40
#define _DAC1REFL_DAC1R6        0x40
#define _DAC1REFL_REF7          0x80
#define _DAC1REFL_DAC1REF7      0x80
#define _DAC1REFL_R7            0x80
#define _DAC1REFL_DAC1R7        0x80

//==============================================================================


//==============================================================================
//        DAC1CON2 Bits

extern __at(0x0590) __sfr DAC1CON2;

typedef union
  {
  struct
    {
    unsigned REF8               : 1;
    unsigned REF9               : 1;
    unsigned REF10              : 1;
    unsigned REF11              : 1;
    unsigned REF12              : 1;
    unsigned REF13              : 1;
    unsigned REF14              : 1;
    unsigned REF15              : 1;
    };

  struct
    {
    unsigned DAC1REF8           : 1;
    unsigned DAC1REF9           : 1;
    unsigned DAC1REF10          : 1;
    unsigned DAC1REF11          : 1;
    unsigned DAC1REF12          : 1;
    unsigned DAC1REF13          : 1;
    unsigned DAC1REF14          : 1;
    unsigned DAC1REF15          : 1;
    };

  struct
    {
    unsigned R8                 : 1;
    unsigned R9                 : 1;
    unsigned R10                : 1;
    unsigned R11                : 1;
    unsigned R12                : 1;
    unsigned R13                : 1;
    unsigned R14                : 1;
    unsigned R15                : 1;
    };

  struct
    {
    unsigned DAC1R8             : 1;
    unsigned DAC1R9             : 1;
    unsigned DAC1R10            : 1;
    unsigned DAC1R11            : 1;
    unsigned DAC1R12            : 1;
    unsigned DAC1R13            : 1;
    unsigned DAC1R14            : 1;
    unsigned DAC1R15            : 1;
    };
  } __DAC1CON2bits_t;

extern __at(0x0590) volatile __DAC1CON2bits_t DAC1CON2bits;

#define _REF8                   0x01
#define _DAC1REF8               0x01
#define _R8                     0x01
#define _DAC1R8                 0x01
#define _REF9                   0x02
#define _DAC1REF9               0x02
#define _R9                     0x02
#define _DAC1R9                 0x02
#define _REF10                  0x04
#define _DAC1REF10              0x04
#define _R10                    0x04
#define _DAC1R10                0x04
#define _REF11                  0x08
#define _DAC1REF11              0x08
#define _R11                    0x08
#define _DAC1R11                0x08
#define _REF12                  0x10
#define _DAC1REF12              0x10
#define _R12                    0x10
#define _DAC1R12                0x10
#define _REF13                  0x20
#define _DAC1REF13              0x20
#define _R13                    0x20
#define _DAC1R13                0x20
#define _REF14                  0x40
#define _DAC1REF14              0x40
#define _R14                    0x40
#define _DAC1R14                0x40
#define _REF15                  0x80
#define _DAC1REF15              0x80
#define _R15                    0x80
#define _DAC1R15                0x80

//==============================================================================


//==============================================================================
//        DAC1REFH Bits

extern __at(0x0590) __sfr DAC1REFH;

typedef union
  {
  struct
    {
    unsigned REF8               : 1;
    unsigned REF9               : 1;
    unsigned REF10              : 1;
    unsigned REF11              : 1;
    unsigned REF12              : 1;
    unsigned REF13              : 1;
    unsigned REF14              : 1;
    unsigned REF15              : 1;
    };

  struct
    {
    unsigned DAC1REF8           : 1;
    unsigned DAC1REF9           : 1;
    unsigned DAC1REF10          : 1;
    unsigned DAC1REF11          : 1;
    unsigned DAC1REF12          : 1;
    unsigned DAC1REF13          : 1;
    unsigned DAC1REF14          : 1;
    unsigned DAC1REF15          : 1;
    };

  struct
    {
    unsigned R8                 : 1;
    unsigned R9                 : 1;
    unsigned R10                : 1;
    unsigned R11                : 1;
    unsigned R12                : 1;
    unsigned R13                : 1;
    unsigned R14                : 1;
    unsigned R15                : 1;
    };

  struct
    {
    unsigned DAC1R8             : 1;
    unsigned DAC1R9             : 1;
    unsigned DAC1R10            : 1;
    unsigned DAC1R11            : 1;
    unsigned DAC1R12            : 1;
    unsigned DAC1R13            : 1;
    unsigned DAC1R14            : 1;
    unsigned DAC1R15            : 1;
    };
  } __DAC1REFHbits_t;

extern __at(0x0590) volatile __DAC1REFHbits_t DAC1REFHbits;

#define _DAC1REFH_REF8          0x01
#define _DAC1REFH_DAC1REF8      0x01
#define _DAC1REFH_R8            0x01
#define _DAC1REFH_DAC1R8        0x01
#define _DAC1REFH_REF9          0x02
#define _DAC1REFH_DAC1REF9      0x02
#define _DAC1REFH_R9            0x02
#define _DAC1REFH_DAC1R9        0x02
#define _DAC1REFH_REF10         0x04
#define _DAC1REFH_DAC1REF10     0x04
#define _DAC1REFH_R10           0x04
#define _DAC1REFH_DAC1R10       0x04
#define _DAC1REFH_REF11         0x08
#define _DAC1REFH_DAC1REF11     0x08
#define _DAC1REFH_R11           0x08
#define _DAC1REFH_DAC1R11       0x08
#define _DAC1REFH_REF12         0x10
#define _DAC1REFH_DAC1REF12     0x10
#define _DAC1REFH_R12           0x10
#define _DAC1REFH_DAC1R12       0x10
#define _DAC1REFH_REF13         0x20
#define _DAC1REFH_DAC1REF13     0x20
#define _DAC1REFH_R13           0x20
#define _DAC1REFH_DAC1R13       0x20
#define _DAC1REFH_REF14         0x40
#define _DAC1REFH_DAC1REF14     0x40
#define _DAC1REFH_R14           0x40
#define _DAC1REFH_DAC1R14       0x40
#define _DAC1REFH_REF15         0x80
#define _DAC1REFH_DAC1REF15     0x80
#define _DAC1REFH_R15           0x80
#define _DAC1REFH_DAC1R15       0x80

//==============================================================================


//==============================================================================
//        DAC2CON0 Bits

extern __at(0x0591) __sfr DAC2CON0;

typedef union
  {
  struct
    {
    unsigned NSS0               : 1;
    unsigned NSS1               : 1;
    unsigned PSS0               : 1;
    unsigned PSS1               : 1;
    unsigned OE2                : 1;
    unsigned OE1                : 1;
    unsigned FM                 : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned DACNSS0            : 1;
    unsigned DACNSS1            : 1;
    unsigned DACPSS0            : 1;
    unsigned DACPSS1            : 1;
    unsigned DACOE2             : 1;
    unsigned OE                 : 1;
    unsigned DACFM              : 1;
    unsigned DACEN              : 1;
    };

  struct
    {
    unsigned DAC2NSS0           : 1;
    unsigned DAC2NSS1           : 1;
    unsigned DAC2PSS0           : 1;
    unsigned DAC2PSS1           : 1;
    unsigned DAC2OE2            : 1;
    unsigned DACOE1             : 1;
    unsigned DAC2FM             : 1;
    unsigned DAC2EN             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned DACOE              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned DAC2OE1            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned NSS                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned DACNSS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned DAC2NSS            : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned DACPSS             : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PSS                : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 2;
    unsigned DAC2PSS            : 2;
    unsigned                    : 4;
    };
  } __DAC2CON0bits_t;

extern __at(0x0591) volatile __DAC2CON0bits_t DAC2CON0bits;

#define _DAC2CON0_NSS0          0x01
#define _DAC2CON0_DACNSS0       0x01
#define _DAC2CON0_DAC2NSS0      0x01
#define _DAC2CON0_NSS1          0x02
#define _DAC2CON0_DACNSS1       0x02
#define _DAC2CON0_DAC2NSS1      0x02
#define _DAC2CON0_PSS0          0x04
#define _DAC2CON0_DACPSS0       0x04
#define _DAC2CON0_DAC2PSS0      0x04
#define _DAC2CON0_PSS1          0x08
#define _DAC2CON0_DACPSS1       0x08
#define _DAC2CON0_DAC2PSS1      0x08
#define _DAC2CON0_OE2           0x10
#define _DAC2CON0_DACOE2        0x10
#define _DAC2CON0_DAC2OE2       0x10
#define _DAC2CON0_OE1           0x20
#define _DAC2CON0_OE            0x20
#define _DAC2CON0_DACOE1        0x20
#define _DAC2CON0_DACOE         0x20
#define _DAC2CON0_DAC2OE1       0x20
#define _DAC2CON0_FM            0x40
#define _DAC2CON0_DACFM         0x40
#define _DAC2CON0_DAC2FM        0x40
#define _DAC2CON0_EN            0x80
#define _DAC2CON0_DACEN         0x80
#define _DAC2CON0_DAC2EN        0x80

//==============================================================================


//==============================================================================
//        DAC2CON1 Bits

extern __at(0x0592) __sfr DAC2CON1;

typedef union
  {
  struct
    {
    unsigned REF0               : 1;
    unsigned REF1               : 1;
    unsigned REF2               : 1;
    unsigned REF3               : 1;
    unsigned REF4               : 1;
    unsigned REF5               : 1;
    unsigned REF6               : 1;
    unsigned REF7               : 1;
    };

  struct
    {
    unsigned DAC2REF0           : 1;
    unsigned DAC2REF1           : 1;
    unsigned DAC2REF2           : 1;
    unsigned DAC2REF3           : 1;
    unsigned DAC2REF4           : 1;
    unsigned DAC2REF5           : 1;
    unsigned DAC2REF6           : 1;
    unsigned DAC2REF7           : 1;
    };

  struct
    {
    unsigned R0                 : 1;
    unsigned R1                 : 1;
    unsigned R2                 : 1;
    unsigned R3                 : 1;
    unsigned R4                 : 1;
    unsigned R5                 : 1;
    unsigned R6                 : 1;
    unsigned R7                 : 1;
    };

  struct
    {
    unsigned DAC2R0             : 1;
    unsigned DAC2R1             : 1;
    unsigned DAC2R2             : 1;
    unsigned DAC2R3             : 1;
    unsigned DAC2R4             : 1;
    unsigned DAC2R5             : 1;
    unsigned DAC2R6             : 1;
    unsigned DAC2R7             : 1;
    };
  } __DAC2CON1bits_t;

extern __at(0x0592) volatile __DAC2CON1bits_t DAC2CON1bits;

#define _DAC2CON1_REF0          0x01
#define _DAC2CON1_DAC2REF0      0x01
#define _DAC2CON1_R0            0x01
#define _DAC2CON1_DAC2R0        0x01
#define _DAC2CON1_REF1          0x02
#define _DAC2CON1_DAC2REF1      0x02
#define _DAC2CON1_R1            0x02
#define _DAC2CON1_DAC2R1        0x02
#define _DAC2CON1_REF2          0x04
#define _DAC2CON1_DAC2REF2      0x04
#define _DAC2CON1_R2            0x04
#define _DAC2CON1_DAC2R2        0x04
#define _DAC2CON1_REF3          0x08
#define _DAC2CON1_DAC2REF3      0x08
#define _DAC2CON1_R3            0x08
#define _DAC2CON1_DAC2R3        0x08
#define _DAC2CON1_REF4          0x10
#define _DAC2CON1_DAC2REF4      0x10
#define _DAC2CON1_R4            0x10
#define _DAC2CON1_DAC2R4        0x10
#define _DAC2CON1_REF5          0x20
#define _DAC2CON1_DAC2REF5      0x20
#define _DAC2CON1_R5            0x20
#define _DAC2CON1_DAC2R5        0x20
#define _DAC2CON1_REF6          0x40
#define _DAC2CON1_DAC2REF6      0x40
#define _DAC2CON1_R6            0x40
#define _DAC2CON1_DAC2R6        0x40
#define _DAC2CON1_REF7          0x80
#define _DAC2CON1_DAC2REF7      0x80
#define _DAC2CON1_R7            0x80
#define _DAC2CON1_DAC2R7        0x80

//==============================================================================

extern __at(0x0592) __sfr DAC2REF;

//==============================================================================
//        DAC2REFL Bits

extern __at(0x0592) __sfr DAC2REFL;

typedef union
  {
  struct
    {
    unsigned REF0               : 1;
    unsigned REF1               : 1;
    unsigned REF2               : 1;
    unsigned REF3               : 1;
    unsigned REF4               : 1;
    unsigned REF5               : 1;
    unsigned REF6               : 1;
    unsigned REF7               : 1;
    };

  struct
    {
    unsigned DAC2REF0           : 1;
    unsigned DAC2REF1           : 1;
    unsigned DAC2REF2           : 1;
    unsigned DAC2REF3           : 1;
    unsigned DAC2REF4           : 1;
    unsigned DAC2REF5           : 1;
    unsigned DAC2REF6           : 1;
    unsigned DAC2REF7           : 1;
    };

  struct
    {
    unsigned R0                 : 1;
    unsigned R1                 : 1;
    unsigned R2                 : 1;
    unsigned R3                 : 1;
    unsigned R4                 : 1;
    unsigned R5                 : 1;
    unsigned R6                 : 1;
    unsigned R7                 : 1;
    };

  struct
    {
    unsigned DAC2R0             : 1;
    unsigned DAC2R1             : 1;
    unsigned DAC2R2             : 1;
    unsigned DAC2R3             : 1;
    unsigned DAC2R4             : 1;
    unsigned DAC2R5             : 1;
    unsigned DAC2R6             : 1;
    unsigned DAC2R7             : 1;
    };
  } __DAC2REFLbits_t;

extern __at(0x0592) volatile __DAC2REFLbits_t DAC2REFLbits;

#define _DAC2REFL_REF0          0x01
#define _DAC2REFL_DAC2REF0      0x01
#define _DAC2REFL_R0            0x01
#define _DAC2REFL_DAC2R0        0x01
#define _DAC2REFL_REF1          0x02
#define _DAC2REFL_DAC2REF1      0x02
#define _DAC2REFL_R1            0x02
#define _DAC2REFL_DAC2R1        0x02
#define _DAC2REFL_REF2          0x04
#define _DAC2REFL_DAC2REF2      0x04
#define _DAC2REFL_R2            0x04
#define _DAC2REFL_DAC2R2        0x04
#define _DAC2REFL_REF3          0x08
#define _DAC2REFL_DAC2REF3      0x08
#define _DAC2REFL_R3            0x08
#define _DAC2REFL_DAC2R3        0x08
#define _DAC2REFL_REF4          0x10
#define _DAC2REFL_DAC2REF4      0x10
#define _DAC2REFL_R4            0x10
#define _DAC2REFL_DAC2R4        0x10
#define _DAC2REFL_REF5          0x20
#define _DAC2REFL_DAC2REF5      0x20
#define _DAC2REFL_R5            0x20
#define _DAC2REFL_DAC2R5        0x20
#define _DAC2REFL_REF6          0x40
#define _DAC2REFL_DAC2REF6      0x40
#define _DAC2REFL_R6            0x40
#define _DAC2REFL_DAC2R6        0x40
#define _DAC2REFL_REF7          0x80
#define _DAC2REFL_DAC2REF7      0x80
#define _DAC2REFL_R7            0x80
#define _DAC2REFL_DAC2R7        0x80

//==============================================================================


//==============================================================================
//        DAC2CON2 Bits

extern __at(0x0593) __sfr DAC2CON2;

typedef union
  {
  struct
    {
    unsigned REF8               : 1;
    unsigned REF9               : 1;
    unsigned REF10              : 1;
    unsigned REF11              : 1;
    unsigned REF12              : 1;
    unsigned REF13              : 1;
    unsigned REF14              : 1;
    unsigned REF15              : 1;
    };

  struct
    {
    unsigned DAC2REF8           : 1;
    unsigned DAC2REF9           : 1;
    unsigned DAC2REF10          : 1;
    unsigned DAC2REF11          : 1;
    unsigned DAC2REF12          : 1;
    unsigned DAC2REF13          : 1;
    unsigned DAC2REF14          : 1;
    unsigned DAC2REF15          : 1;
    };

  struct
    {
    unsigned R8                 : 1;
    unsigned R9                 : 1;
    unsigned R10                : 1;
    unsigned R11                : 1;
    unsigned R12                : 1;
    unsigned R13                : 1;
    unsigned R14                : 1;
    unsigned R15                : 1;
    };

  struct
    {
    unsigned DAC2R8             : 1;
    unsigned DAC2R9             : 1;
    unsigned DAC2R10            : 1;
    unsigned DAC2R11            : 1;
    unsigned DAC2R12            : 1;
    unsigned DAC2R13            : 1;
    unsigned DAC2R14            : 1;
    unsigned DAC2R15            : 1;
    };
  } __DAC2CON2bits_t;

extern __at(0x0593) volatile __DAC2CON2bits_t DAC2CON2bits;

#define _DAC2CON2_REF8          0x01
#define _DAC2CON2_DAC2REF8      0x01
#define _DAC2CON2_R8            0x01
#define _DAC2CON2_DAC2R8        0x01
#define _DAC2CON2_REF9          0x02
#define _DAC2CON2_DAC2REF9      0x02
#define _DAC2CON2_R9            0x02
#define _DAC2CON2_DAC2R9        0x02
#define _DAC2CON2_REF10         0x04
#define _DAC2CON2_DAC2REF10     0x04
#define _DAC2CON2_R10           0x04
#define _DAC2CON2_DAC2R10       0x04
#define _DAC2CON2_REF11         0x08
#define _DAC2CON2_DAC2REF11     0x08
#define _DAC2CON2_R11           0x08
#define _DAC2CON2_DAC2R11       0x08
#define _DAC2CON2_REF12         0x10
#define _DAC2CON2_DAC2REF12     0x10
#define _DAC2CON2_R12           0x10
#define _DAC2CON2_DAC2R12       0x10
#define _DAC2CON2_REF13         0x20
#define _DAC2CON2_DAC2REF13     0x20
#define _DAC2CON2_R13           0x20
#define _DAC2CON2_DAC2R13       0x20
#define _DAC2CON2_REF14         0x40
#define _DAC2CON2_DAC2REF14     0x40
#define _DAC2CON2_R14           0x40
#define _DAC2CON2_DAC2R14       0x40
#define _DAC2CON2_REF15         0x80
#define _DAC2CON2_DAC2REF15     0x80
#define _DAC2CON2_R15           0x80
#define _DAC2CON2_DAC2R15       0x80

//==============================================================================


//==============================================================================
//        DAC2REFH Bits

extern __at(0x0593) __sfr DAC2REFH;

typedef union
  {
  struct
    {
    unsigned REF8               : 1;
    unsigned REF9               : 1;
    unsigned REF10              : 1;
    unsigned REF11              : 1;
    unsigned REF12              : 1;
    unsigned REF13              : 1;
    unsigned REF14              : 1;
    unsigned REF15              : 1;
    };

  struct
    {
    unsigned DAC2REF8           : 1;
    unsigned DAC2REF9           : 1;
    unsigned DAC2REF10          : 1;
    unsigned DAC2REF11          : 1;
    unsigned DAC2REF12          : 1;
    unsigned DAC2REF13          : 1;
    unsigned DAC2REF14          : 1;
    unsigned DAC2REF15          : 1;
    };

  struct
    {
    unsigned R8                 : 1;
    unsigned R9                 : 1;
    unsigned R10                : 1;
    unsigned R11                : 1;
    unsigned R12                : 1;
    unsigned R13                : 1;
    unsigned R14                : 1;
    unsigned R15                : 1;
    };

  struct
    {
    unsigned DAC2R8             : 1;
    unsigned DAC2R9             : 1;
    unsigned DAC2R10            : 1;
    unsigned DAC2R11            : 1;
    unsigned DAC2R12            : 1;
    unsigned DAC2R13            : 1;
    unsigned DAC2R14            : 1;
    unsigned DAC2R15            : 1;
    };
  } __DAC2REFHbits_t;

extern __at(0x0593) volatile __DAC2REFHbits_t DAC2REFHbits;

#define _DAC2REFH_REF8          0x01
#define _DAC2REFH_DAC2REF8      0x01
#define _DAC2REFH_R8            0x01
#define _DAC2REFH_DAC2R8        0x01
#define _DAC2REFH_REF9          0x02
#define _DAC2REFH_DAC2REF9      0x02
#define _DAC2REFH_R9            0x02
#define _DAC2REFH_DAC2R9        0x02
#define _DAC2REFH_REF10         0x04
#define _DAC2REFH_DAC2REF10     0x04
#define _DAC2REFH_R10           0x04
#define _DAC2REFH_DAC2R10       0x04
#define _DAC2REFH_REF11         0x08
#define _DAC2REFH_DAC2REF11     0x08
#define _DAC2REFH_R11           0x08
#define _DAC2REFH_DAC2R11       0x08
#define _DAC2REFH_REF12         0x10
#define _DAC2REFH_DAC2REF12     0x10
#define _DAC2REFH_R12           0x10
#define _DAC2REFH_DAC2R12       0x10
#define _DAC2REFH_REF13         0x20
#define _DAC2REFH_DAC2REF13     0x20
#define _DAC2REFH_R13           0x20
#define _DAC2REFH_DAC2R13       0x20
#define _DAC2REFH_REF14         0x40
#define _DAC2REFH_DAC2REF14     0x40
#define _DAC2REFH_R14           0x40
#define _DAC2REFH_DAC2R14       0x40
#define _DAC2REFH_REF15         0x80
#define _DAC2REFH_DAC2REF15     0x80
#define _DAC2REFH_R15           0x80
#define _DAC2REFH_DAC2R15       0x80

//==============================================================================


//==============================================================================
//        DAC3CON0 Bits

extern __at(0x0594) __sfr DAC3CON0;

typedef union
  {
  struct
    {
    unsigned NSS0               : 1;
    unsigned NSS1               : 1;
    unsigned PSS0               : 1;
    unsigned PSS1               : 1;
    unsigned OE2                : 1;
    unsigned OE1                : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned DACNSS0            : 1;
    unsigned DACNSS1            : 1;
    unsigned DACPSS0            : 1;
    unsigned DACPSS1            : 1;
    unsigned DACOE2             : 1;
    unsigned DACOE1             : 1;
    unsigned                    : 1;
    unsigned DACEN              : 1;
    };

  struct
    {
    unsigned DAC3NSS0           : 1;
    unsigned DAC3NSS1           : 1;
    unsigned DAC3PSS0           : 1;
    unsigned DAC3PSS1           : 1;
    unsigned DAC3OE2            : 1;
    unsigned DAC3OE1            : 1;
    unsigned                    : 1;
    unsigned DAC3EN             : 1;
    };

  struct
    {
    unsigned NSS                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned DACNSS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned DAC3NSS            : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned DACPSS             : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 2;
    unsigned DAC3PSS            : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PSS                : 2;
    unsigned                    : 4;
    };
  } __DAC3CON0bits_t;

extern __at(0x0594) volatile __DAC3CON0bits_t DAC3CON0bits;

#define _DAC3CON0_NSS0          0x01
#define _DAC3CON0_DACNSS0       0x01
#define _DAC3CON0_DAC3NSS0      0x01
#define _DAC3CON0_NSS1          0x02
#define _DAC3CON0_DACNSS1       0x02
#define _DAC3CON0_DAC3NSS1      0x02
#define _DAC3CON0_PSS0          0x04
#define _DAC3CON0_DACPSS0       0x04
#define _DAC3CON0_DAC3PSS0      0x04
#define _DAC3CON0_PSS1          0x08
#define _DAC3CON0_DACPSS1       0x08
#define _DAC3CON0_DAC3PSS1      0x08
#define _DAC3CON0_OE2           0x10
#define _DAC3CON0_DACOE2        0x10
#define _DAC3CON0_DAC3OE2       0x10
#define _DAC3CON0_OE1           0x20
#define _DAC3CON0_DACOE1        0x20
#define _DAC3CON0_DAC3OE1       0x20
#define _DAC3CON0_EN            0x80
#define _DAC3CON0_DACEN         0x80
#define _DAC3CON0_DAC3EN        0x80

//==============================================================================


//==============================================================================
//        DAC3CON1 Bits

extern __at(0x0595) __sfr DAC3CON1;

typedef union
  {
  struct
    {
    unsigned DACR0              : 1;
    unsigned DACR1              : 1;
    unsigned DACR2              : 1;
    unsigned DACR3              : 1;
    unsigned DACR4              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned R0                 : 1;
    unsigned R1                 : 1;
    unsigned R2                 : 1;
    unsigned R3                 : 1;
    unsigned R4                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DAC3R0             : 1;
    unsigned DAC3R1             : 1;
    unsigned DAC3R2             : 1;
    unsigned DAC3R3             : 1;
    unsigned DAC3R4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned REF0               : 1;
    unsigned REF1               : 1;
    unsigned REF2               : 1;
    unsigned REF3               : 1;
    unsigned REF4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DAC3REF0           : 1;
    unsigned DAC3REF1           : 1;
    unsigned DAC3REF2           : 1;
    unsigned DAC3REF3           : 1;
    unsigned DAC3REF4           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned REF                : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned R                  : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned DACR               : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned DAC3REF            : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned DAC3R              : 5;
    unsigned                    : 3;
    };
  } __DAC3CON1bits_t;

extern __at(0x0595) volatile __DAC3CON1bits_t DAC3CON1bits;

#define _DAC3CON1_DACR0         0x01
#define _DAC3CON1_R0            0x01
#define _DAC3CON1_DAC3R0        0x01
#define _DAC3CON1_REF0          0x01
#define _DAC3CON1_DAC3REF0      0x01
#define _DAC3CON1_DACR1         0x02
#define _DAC3CON1_R1            0x02
#define _DAC3CON1_DAC3R1        0x02
#define _DAC3CON1_REF1          0x02
#define _DAC3CON1_DAC3REF1      0x02
#define _DAC3CON1_DACR2         0x04
#define _DAC3CON1_R2            0x04
#define _DAC3CON1_DAC3R2        0x04
#define _DAC3CON1_REF2          0x04
#define _DAC3CON1_DAC3REF2      0x04
#define _DAC3CON1_DACR3         0x08
#define _DAC3CON1_R3            0x08
#define _DAC3CON1_DAC3R3        0x08
#define _DAC3CON1_REF3          0x08
#define _DAC3CON1_DAC3REF3      0x08
#define _DAC3CON1_DACR4         0x10
#define _DAC3CON1_R4            0x10
#define _DAC3CON1_DAC3R4        0x10
#define _DAC3CON1_REF4          0x10
#define _DAC3CON1_DAC3REF4      0x10

//==============================================================================


//==============================================================================
//        DAC3REF Bits

extern __at(0x0595) __sfr DAC3REF;

typedef union
  {
  struct
    {
    unsigned DACR0              : 1;
    unsigned DACR1              : 1;
    unsigned DACR2              : 1;
    unsigned DACR3              : 1;
    unsigned DACR4              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned R0                 : 1;
    unsigned R1                 : 1;
    unsigned R2                 : 1;
    unsigned R3                 : 1;
    unsigned R4                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DAC3R0             : 1;
    unsigned DAC3R1             : 1;
    unsigned DAC3R2             : 1;
    unsigned DAC3R3             : 1;
    unsigned DAC3R4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned REF0               : 1;
    unsigned REF1               : 1;
    unsigned REF2               : 1;
    unsigned REF3               : 1;
    unsigned REF4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DAC3REF0           : 1;
    unsigned DAC3REF1           : 1;
    unsigned DAC3REF2           : 1;
    unsigned DAC3REF3           : 1;
    unsigned DAC3REF4           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DACR               : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned REF                : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned R                  : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned DAC3REF            : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned DAC3R              : 5;
    unsigned                    : 3;
    };
  } __DAC3REFbits_t;

extern __at(0x0595) volatile __DAC3REFbits_t DAC3REFbits;

#define _DAC3REF_DACR0          0x01
#define _DAC3REF_R0             0x01
#define _DAC3REF_DAC3R0         0x01
#define _DAC3REF_REF0           0x01
#define _DAC3REF_DAC3REF0       0x01
#define _DAC3REF_DACR1          0x02
#define _DAC3REF_R1             0x02
#define _DAC3REF_DAC3R1         0x02
#define _DAC3REF_REF1           0x02
#define _DAC3REF_DAC3REF1       0x02
#define _DAC3REF_DACR2          0x04
#define _DAC3REF_R2             0x04
#define _DAC3REF_DAC3R2         0x04
#define _DAC3REF_REF2           0x04
#define _DAC3REF_DAC3REF2       0x04
#define _DAC3REF_DACR3          0x08
#define _DAC3REF_R3             0x08
#define _DAC3REF_DAC3R3         0x08
#define _DAC3REF_REF3           0x08
#define _DAC3REF_DAC3REF3       0x08
#define _DAC3REF_DACR4          0x10
#define _DAC3REF_R4             0x10
#define _DAC3REF_DAC3R4         0x10
#define _DAC3REF_REF4           0x10
#define _DAC3REF_DAC3REF4       0x10

//==============================================================================


//==============================================================================
//        DAC4CON0 Bits

extern __at(0x0596) __sfr DAC4CON0;

typedef union
  {
  struct
    {
    unsigned NSS0               : 1;
    unsigned NSS1               : 1;
    unsigned PSS0               : 1;
    unsigned PSS1               : 1;
    unsigned OE2                : 1;
    unsigned OE1                : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned DACNSS0            : 1;
    unsigned DACNSS1            : 1;
    unsigned DACPSS0            : 1;
    unsigned DACPSS1            : 1;
    unsigned DACOE2             : 1;
    unsigned DACOE1             : 1;
    unsigned                    : 1;
    unsigned DACEN              : 1;
    };

  struct
    {
    unsigned DAC4NSS0           : 1;
    unsigned DAC4NSS1           : 1;
    unsigned DAC4PSS0           : 1;
    unsigned DAC4PSS1           : 1;
    unsigned DAC4OE2            : 1;
    unsigned DAC4OE1            : 1;
    unsigned                    : 1;
    unsigned DAC4EN             : 1;
    };

  struct
    {
    unsigned DACNSS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned NSS                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned DAC4NSS            : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned DAC4PSS            : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 2;
    unsigned DACPSS             : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PSS                : 2;
    unsigned                    : 4;
    };
  } __DAC4CON0bits_t;

extern __at(0x0596) volatile __DAC4CON0bits_t DAC4CON0bits;

#define _DAC4CON0_NSS0          0x01
#define _DAC4CON0_DACNSS0       0x01
#define _DAC4CON0_DAC4NSS0      0x01
#define _DAC4CON0_NSS1          0x02
#define _DAC4CON0_DACNSS1       0x02
#define _DAC4CON0_DAC4NSS1      0x02
#define _DAC4CON0_PSS0          0x04
#define _DAC4CON0_DACPSS0       0x04
#define _DAC4CON0_DAC4PSS0      0x04
#define _DAC4CON0_PSS1          0x08
#define _DAC4CON0_DACPSS1       0x08
#define _DAC4CON0_DAC4PSS1      0x08
#define _DAC4CON0_OE2           0x10
#define _DAC4CON0_DACOE2        0x10
#define _DAC4CON0_DAC4OE2       0x10
#define _DAC4CON0_OE1           0x20
#define _DAC4CON0_DACOE1        0x20
#define _DAC4CON0_DAC4OE1       0x20
#define _DAC4CON0_EN            0x80
#define _DAC4CON0_DACEN         0x80
#define _DAC4CON0_DAC4EN        0x80

//==============================================================================


//==============================================================================
//        DAC4CON1 Bits

extern __at(0x0597) __sfr DAC4CON1;

typedef union
  {
  struct
    {
    unsigned DACR0              : 1;
    unsigned DACR1              : 1;
    unsigned DACR2              : 1;
    unsigned DACR3              : 1;
    unsigned DACR4              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned R0                 : 1;
    unsigned R1                 : 1;
    unsigned R2                 : 1;
    unsigned R3                 : 1;
    unsigned R4                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DAC4R0             : 1;
    unsigned DAC4R1             : 1;
    unsigned DAC4R2             : 1;
    unsigned DAC4R3             : 1;
    unsigned DAC4R4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned REF0               : 1;
    unsigned REF1               : 1;
    unsigned REF2               : 1;
    unsigned REF3               : 1;
    unsigned REF4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DAC4REF0           : 1;
    unsigned DAC4REF1           : 1;
    unsigned DAC4REF2           : 1;
    unsigned DAC4REF3           : 1;
    unsigned DAC4REF4           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DAC4R              : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned DAC4REF            : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned R                  : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned REF                : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned DACR               : 5;
    unsigned                    : 3;
    };
  } __DAC4CON1bits_t;

extern __at(0x0597) volatile __DAC4CON1bits_t DAC4CON1bits;

#define _DAC4CON1_DACR0         0x01
#define _DAC4CON1_R0            0x01
#define _DAC4CON1_DAC4R0        0x01
#define _DAC4CON1_REF0          0x01
#define _DAC4CON1_DAC4REF0      0x01
#define _DAC4CON1_DACR1         0x02
#define _DAC4CON1_R1            0x02
#define _DAC4CON1_DAC4R1        0x02
#define _DAC4CON1_REF1          0x02
#define _DAC4CON1_DAC4REF1      0x02
#define _DAC4CON1_DACR2         0x04
#define _DAC4CON1_R2            0x04
#define _DAC4CON1_DAC4R2        0x04
#define _DAC4CON1_REF2          0x04
#define _DAC4CON1_DAC4REF2      0x04
#define _DAC4CON1_DACR3         0x08
#define _DAC4CON1_R3            0x08
#define _DAC4CON1_DAC4R3        0x08
#define _DAC4CON1_REF3          0x08
#define _DAC4CON1_DAC4REF3      0x08
#define _DAC4CON1_DACR4         0x10
#define _DAC4CON1_R4            0x10
#define _DAC4CON1_DAC4R4        0x10
#define _DAC4CON1_REF4          0x10
#define _DAC4CON1_DAC4REF4      0x10

//==============================================================================


//==============================================================================
//        DAC4REF Bits

extern __at(0x0597) __sfr DAC4REF;

typedef union
  {
  struct
    {
    unsigned DACR0              : 1;
    unsigned DACR1              : 1;
    unsigned DACR2              : 1;
    unsigned DACR3              : 1;
    unsigned DACR4              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned R0                 : 1;
    unsigned R1                 : 1;
    unsigned R2                 : 1;
    unsigned R3                 : 1;
    unsigned R4                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DAC4R0             : 1;
    unsigned DAC4R1             : 1;
    unsigned DAC4R2             : 1;
    unsigned DAC4R3             : 1;
    unsigned DAC4R4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned REF0               : 1;
    unsigned REF1               : 1;
    unsigned REF2               : 1;
    unsigned REF3               : 1;
    unsigned REF4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DAC4REF0           : 1;
    unsigned DAC4REF1           : 1;
    unsigned DAC4REF2           : 1;
    unsigned DAC4REF3           : 1;
    unsigned DAC4REF4           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned R                  : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned REF                : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned DACR               : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned DAC4R              : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned DAC4REF            : 5;
    unsigned                    : 3;
    };
  } __DAC4REFbits_t;

extern __at(0x0597) volatile __DAC4REFbits_t DAC4REFbits;

#define _DAC4REF_DACR0          0x01
#define _DAC4REF_R0             0x01
#define _DAC4REF_DAC4R0         0x01
#define _DAC4REF_REF0           0x01
#define _DAC4REF_DAC4REF0       0x01
#define _DAC4REF_DACR1          0x02
#define _DAC4REF_R1             0x02
#define _DAC4REF_DAC4R1         0x02
#define _DAC4REF_REF1           0x02
#define _DAC4REF_DAC4REF1       0x02
#define _DAC4REF_DACR2          0x04
#define _DAC4REF_R2             0x04
#define _DAC4REF_DAC4R2         0x04
#define _DAC4REF_REF2           0x04
#define _DAC4REF_DAC4REF2       0x04
#define _DAC4REF_DACR3          0x08
#define _DAC4REF_R3             0x08
#define _DAC4REF_DAC4R3         0x08
#define _DAC4REF_REF3           0x08
#define _DAC4REF_DAC4REF3       0x08
#define _DAC4REF_DACR4          0x10
#define _DAC4REF_R4             0x10
#define _DAC4REF_DAC4R4         0x10
#define _DAC4REF_REF4           0x10
#define _DAC4REF_DAC4REF4       0x10

//==============================================================================


//==============================================================================
//        DAC5CON0 Bits

extern __at(0x0598) __sfr DAC5CON0;

typedef union
  {
  struct
    {
    unsigned NSS0               : 1;
    unsigned NSS1               : 1;
    unsigned PSS0               : 1;
    unsigned PSS1               : 1;
    unsigned OE2                : 1;
    unsigned OE1                : 1;
    unsigned FM                 : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned DACNSS0            : 1;
    unsigned DACNSS1            : 1;
    unsigned DACPSS0            : 1;
    unsigned DACPSS1            : 1;
    unsigned DACOE2             : 1;
    unsigned OE                 : 1;
    unsigned DACFM              : 1;
    unsigned DACEN              : 1;
    };

  struct
    {
    unsigned DAC5NSS0           : 1;
    unsigned DAC5NSS1           : 1;
    unsigned DAC5PSS0           : 1;
    unsigned DAC5PSS1           : 1;
    unsigned DAC5OE2            : 1;
    unsigned DACOE1             : 1;
    unsigned DAC5FM             : 1;
    unsigned DAC5EN             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned DACOE              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned DAC5OE1            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DAC5NSS            : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned NSS                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned DACNSS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned DACPSS             : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 2;
    unsigned DAC5PSS            : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PSS                : 2;
    unsigned                    : 4;
    };
  } __DAC5CON0bits_t;

extern __at(0x0598) volatile __DAC5CON0bits_t DAC5CON0bits;

#define _DAC5CON0_NSS0          0x01
#define _DAC5CON0_DACNSS0       0x01
#define _DAC5CON0_DAC5NSS0      0x01
#define _DAC5CON0_NSS1          0x02
#define _DAC5CON0_DACNSS1       0x02
#define _DAC5CON0_DAC5NSS1      0x02
#define _DAC5CON0_PSS0          0x04
#define _DAC5CON0_DACPSS0       0x04
#define _DAC5CON0_DAC5PSS0      0x04
#define _DAC5CON0_PSS1          0x08
#define _DAC5CON0_DACPSS1       0x08
#define _DAC5CON0_DAC5PSS1      0x08
#define _DAC5CON0_OE2           0x10
#define _DAC5CON0_DACOE2        0x10
#define _DAC5CON0_DAC5OE2       0x10
#define _DAC5CON0_OE1           0x20
#define _DAC5CON0_OE            0x20
#define _DAC5CON0_DACOE1        0x20
#define _DAC5CON0_DACOE         0x20
#define _DAC5CON0_DAC5OE1       0x20
#define _DAC5CON0_FM            0x40
#define _DAC5CON0_DACFM         0x40
#define _DAC5CON0_DAC5FM        0x40
#define _DAC5CON0_EN            0x80
#define _DAC5CON0_DACEN         0x80
#define _DAC5CON0_DAC5EN        0x80

//==============================================================================


//==============================================================================
//        DAC5CON1 Bits

extern __at(0x0599) __sfr DAC5CON1;

typedef union
  {
  struct
    {
    unsigned REF0               : 1;
    unsigned REF1               : 1;
    unsigned REF2               : 1;
    unsigned REF3               : 1;
    unsigned REF4               : 1;
    unsigned REF5               : 1;
    unsigned REF6               : 1;
    unsigned REF7               : 1;
    };

  struct
    {
    unsigned DAC5REF0           : 1;
    unsigned DAC5REF1           : 1;
    unsigned DAC5REF2           : 1;
    unsigned DAC5REF3           : 1;
    unsigned DAC5REF4           : 1;
    unsigned DAC5REF5           : 1;
    unsigned DAC5REF6           : 1;
    unsigned DAC5REF7           : 1;
    };

  struct
    {
    unsigned R0                 : 1;
    unsigned R1                 : 1;
    unsigned R2                 : 1;
    unsigned R3                 : 1;
    unsigned R4                 : 1;
    unsigned R5                 : 1;
    unsigned R6                 : 1;
    unsigned R7                 : 1;
    };

  struct
    {
    unsigned DAC5R0             : 1;
    unsigned DAC5R1             : 1;
    unsigned DAC5R2             : 1;
    unsigned DAC5R3             : 1;
    unsigned DAC5R4             : 1;
    unsigned DAC5R5             : 1;
    unsigned DAC5R6             : 1;
    unsigned DAC5R7             : 1;
    };
  } __DAC5CON1bits_t;

extern __at(0x0599) volatile __DAC5CON1bits_t DAC5CON1bits;

#define _DAC5CON1_REF0          0x01
#define _DAC5CON1_DAC5REF0      0x01
#define _DAC5CON1_R0            0x01
#define _DAC5CON1_DAC5R0        0x01
#define _DAC5CON1_REF1          0x02
#define _DAC5CON1_DAC5REF1      0x02
#define _DAC5CON1_R1            0x02
#define _DAC5CON1_DAC5R1        0x02
#define _DAC5CON1_REF2          0x04
#define _DAC5CON1_DAC5REF2      0x04
#define _DAC5CON1_R2            0x04
#define _DAC5CON1_DAC5R2        0x04
#define _DAC5CON1_REF3          0x08
#define _DAC5CON1_DAC5REF3      0x08
#define _DAC5CON1_R3            0x08
#define _DAC5CON1_DAC5R3        0x08
#define _DAC5CON1_REF4          0x10
#define _DAC5CON1_DAC5REF4      0x10
#define _DAC5CON1_R4            0x10
#define _DAC5CON1_DAC5R4        0x10
#define _DAC5CON1_REF5          0x20
#define _DAC5CON1_DAC5REF5      0x20
#define _DAC5CON1_R5            0x20
#define _DAC5CON1_DAC5R5        0x20
#define _DAC5CON1_REF6          0x40
#define _DAC5CON1_DAC5REF6      0x40
#define _DAC5CON1_R6            0x40
#define _DAC5CON1_DAC5R6        0x40
#define _DAC5CON1_REF7          0x80
#define _DAC5CON1_DAC5REF7      0x80
#define _DAC5CON1_R7            0x80
#define _DAC5CON1_DAC5R7        0x80

//==============================================================================

extern __at(0x0599) __sfr DAC5REF;

//==============================================================================
//        DAC5REFL Bits

extern __at(0x0599) __sfr DAC5REFL;

typedef union
  {
  struct
    {
    unsigned REF0               : 1;
    unsigned REF1               : 1;
    unsigned REF2               : 1;
    unsigned REF3               : 1;
    unsigned REF4               : 1;
    unsigned REF5               : 1;
    unsigned REF6               : 1;
    unsigned REF7               : 1;
    };

  struct
    {
    unsigned DAC5REF0           : 1;
    unsigned DAC5REF1           : 1;
    unsigned DAC5REF2           : 1;
    unsigned DAC5REF3           : 1;
    unsigned DAC5REF4           : 1;
    unsigned DAC5REF5           : 1;
    unsigned DAC5REF6           : 1;
    unsigned DAC5REF7           : 1;
    };

  struct
    {
    unsigned R0                 : 1;
    unsigned R1                 : 1;
    unsigned R2                 : 1;
    unsigned R3                 : 1;
    unsigned R4                 : 1;
    unsigned R5                 : 1;
    unsigned R6                 : 1;
    unsigned R7                 : 1;
    };

  struct
    {
    unsigned DAC5R0             : 1;
    unsigned DAC5R1             : 1;
    unsigned DAC5R2             : 1;
    unsigned DAC5R3             : 1;
    unsigned DAC5R4             : 1;
    unsigned DAC5R5             : 1;
    unsigned DAC5R6             : 1;
    unsigned DAC5R7             : 1;
    };
  } __DAC5REFLbits_t;

extern __at(0x0599) volatile __DAC5REFLbits_t DAC5REFLbits;

#define _DAC5REFL_REF0          0x01
#define _DAC5REFL_DAC5REF0      0x01
#define _DAC5REFL_R0            0x01
#define _DAC5REFL_DAC5R0        0x01
#define _DAC5REFL_REF1          0x02
#define _DAC5REFL_DAC5REF1      0x02
#define _DAC5REFL_R1            0x02
#define _DAC5REFL_DAC5R1        0x02
#define _DAC5REFL_REF2          0x04
#define _DAC5REFL_DAC5REF2      0x04
#define _DAC5REFL_R2            0x04
#define _DAC5REFL_DAC5R2        0x04
#define _DAC5REFL_REF3          0x08
#define _DAC5REFL_DAC5REF3      0x08
#define _DAC5REFL_R3            0x08
#define _DAC5REFL_DAC5R3        0x08
#define _DAC5REFL_REF4          0x10
#define _DAC5REFL_DAC5REF4      0x10
#define _DAC5REFL_R4            0x10
#define _DAC5REFL_DAC5R4        0x10
#define _DAC5REFL_REF5          0x20
#define _DAC5REFL_DAC5REF5      0x20
#define _DAC5REFL_R5            0x20
#define _DAC5REFL_DAC5R5        0x20
#define _DAC5REFL_REF6          0x40
#define _DAC5REFL_DAC5REF6      0x40
#define _DAC5REFL_R6            0x40
#define _DAC5REFL_DAC5R6        0x40
#define _DAC5REFL_REF7          0x80
#define _DAC5REFL_DAC5REF7      0x80
#define _DAC5REFL_R7            0x80
#define _DAC5REFL_DAC5R7        0x80

//==============================================================================


//==============================================================================
//        DAC5CON2 Bits

extern __at(0x059A) __sfr DAC5CON2;

typedef union
  {
  struct
    {
    unsigned REF8               : 1;
    unsigned REF9               : 1;
    unsigned REF10              : 1;
    unsigned REF11              : 1;
    unsigned REF12              : 1;
    unsigned REF13              : 1;
    unsigned REF14              : 1;
    unsigned REF15              : 1;
    };

  struct
    {
    unsigned DAC5REF8           : 1;
    unsigned DAC5REF9           : 1;
    unsigned DAC5REF10          : 1;
    unsigned DAC5REF11          : 1;
    unsigned DAC5REF12          : 1;
    unsigned DAC5REF13          : 1;
    unsigned DAC5REF14          : 1;
    unsigned DAC5REF15          : 1;
    };

  struct
    {
    unsigned R8                 : 1;
    unsigned R9                 : 1;
    unsigned R10                : 1;
    unsigned R11                : 1;
    unsigned R12                : 1;
    unsigned R13                : 1;
    unsigned R14                : 1;
    unsigned R15                : 1;
    };

  struct
    {
    unsigned DAC5R8             : 1;
    unsigned DAC5R9             : 1;
    unsigned DAC5R10            : 1;
    unsigned DAC5R11            : 1;
    unsigned DAC5R12            : 1;
    unsigned DAC5R13            : 1;
    unsigned DAC5R14            : 1;
    unsigned DAC5R15            : 1;
    };
  } __DAC5CON2bits_t;

extern __at(0x059A) volatile __DAC5CON2bits_t DAC5CON2bits;

#define _DAC5CON2_REF8          0x01
#define _DAC5CON2_DAC5REF8      0x01
#define _DAC5CON2_R8            0x01
#define _DAC5CON2_DAC5R8        0x01
#define _DAC5CON2_REF9          0x02
#define _DAC5CON2_DAC5REF9      0x02
#define _DAC5CON2_R9            0x02
#define _DAC5CON2_DAC5R9        0x02
#define _DAC5CON2_REF10         0x04
#define _DAC5CON2_DAC5REF10     0x04
#define _DAC5CON2_R10           0x04
#define _DAC5CON2_DAC5R10       0x04
#define _DAC5CON2_REF11         0x08
#define _DAC5CON2_DAC5REF11     0x08
#define _DAC5CON2_R11           0x08
#define _DAC5CON2_DAC5R11       0x08
#define _DAC5CON2_REF12         0x10
#define _DAC5CON2_DAC5REF12     0x10
#define _DAC5CON2_R12           0x10
#define _DAC5CON2_DAC5R12       0x10
#define _DAC5CON2_REF13         0x20
#define _DAC5CON2_DAC5REF13     0x20
#define _DAC5CON2_R13           0x20
#define _DAC5CON2_DAC5R13       0x20
#define _DAC5CON2_REF14         0x40
#define _DAC5CON2_DAC5REF14     0x40
#define _DAC5CON2_R14           0x40
#define _DAC5CON2_DAC5R14       0x40
#define _DAC5CON2_REF15         0x80
#define _DAC5CON2_DAC5REF15     0x80
#define _DAC5CON2_R15           0x80
#define _DAC5CON2_DAC5R15       0x80

//==============================================================================


//==============================================================================
//        DAC5REFH Bits

extern __at(0x059A) __sfr DAC5REFH;

typedef union
  {
  struct
    {
    unsigned REF8               : 1;
    unsigned REF9               : 1;
    unsigned REF10              : 1;
    unsigned REF11              : 1;
    unsigned REF12              : 1;
    unsigned REF13              : 1;
    unsigned REF14              : 1;
    unsigned REF15              : 1;
    };

  struct
    {
    unsigned DAC5REF8           : 1;
    unsigned DAC5REF9           : 1;
    unsigned DAC5REF10          : 1;
    unsigned DAC5REF11          : 1;
    unsigned DAC5REF12          : 1;
    unsigned DAC5REF13          : 1;
    unsigned DAC5REF14          : 1;
    unsigned DAC5REF15          : 1;
    };

  struct
    {
    unsigned R8                 : 1;
    unsigned R9                 : 1;
    unsigned R10                : 1;
    unsigned R11                : 1;
    unsigned R12                : 1;
    unsigned R13                : 1;
    unsigned R14                : 1;
    unsigned R15                : 1;
    };

  struct
    {
    unsigned DAC5R8             : 1;
    unsigned DAC5R9             : 1;
    unsigned DAC5R10            : 1;
    unsigned DAC5R11            : 1;
    unsigned DAC5R12            : 1;
    unsigned DAC5R13            : 1;
    unsigned DAC5R14            : 1;
    unsigned DAC5R15            : 1;
    };
  } __DAC5REFHbits_t;

extern __at(0x059A) volatile __DAC5REFHbits_t DAC5REFHbits;

#define _DAC5REFH_REF8          0x01
#define _DAC5REFH_DAC5REF8      0x01
#define _DAC5REFH_R8            0x01
#define _DAC5REFH_DAC5R8        0x01
#define _DAC5REFH_REF9          0x02
#define _DAC5REFH_DAC5REF9      0x02
#define _DAC5REFH_R9            0x02
#define _DAC5REFH_DAC5R9        0x02
#define _DAC5REFH_REF10         0x04
#define _DAC5REFH_DAC5REF10     0x04
#define _DAC5REFH_R10           0x04
#define _DAC5REFH_DAC5R10       0x04
#define _DAC5REFH_REF11         0x08
#define _DAC5REFH_DAC5REF11     0x08
#define _DAC5REFH_R11           0x08
#define _DAC5REFH_DAC5R11       0x08
#define _DAC5REFH_REF12         0x10
#define _DAC5REFH_DAC5REF12     0x10
#define _DAC5REFH_R12           0x10
#define _DAC5REFH_DAC5R12       0x10
#define _DAC5REFH_REF13         0x20
#define _DAC5REFH_DAC5REF13     0x20
#define _DAC5REFH_R13           0x20
#define _DAC5REFH_DAC5R13       0x20
#define _DAC5REFH_REF14         0x40
#define _DAC5REFH_DAC5REF14     0x40
#define _DAC5REFH_R14           0x40
#define _DAC5REFH_DAC5R14       0x40
#define _DAC5REFH_REF15         0x80
#define _DAC5REFH_DAC5REF15     0x80
#define _DAC5REFH_R15           0x80
#define _DAC5REFH_DAC5R15       0x80

//==============================================================================


//==============================================================================
//        DAC7CON0 Bits

extern __at(0x059E) __sfr DAC7CON0;

typedef union
  {
  struct
    {
    unsigned NSS0               : 1;
    unsigned NSS1               : 1;
    unsigned PSS0               : 1;
    unsigned PSS1               : 1;
    unsigned OE2                : 1;
    unsigned OE1                : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned DACNSS0            : 1;
    unsigned DACNSS1            : 1;
    unsigned DACPSS0            : 1;
    unsigned DACPSS1            : 1;
    unsigned DACOE2             : 1;
    unsigned DACOE1             : 1;
    unsigned                    : 1;
    unsigned DACEN              : 1;
    };

  struct
    {
    unsigned DAC7NSS0           : 1;
    unsigned DAC7NSS1           : 1;
    unsigned DAC7PSS0           : 1;
    unsigned DAC7PSS1           : 1;
    unsigned DAC7OE2            : 1;
    unsigned DAC7OE1            : 1;
    unsigned                    : 1;
    unsigned DAC7EN             : 1;
    };

  struct
    {
    unsigned DAC7NSS            : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned DACNSS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned NSS                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PSS                : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 2;
    unsigned DACPSS             : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 2;
    unsigned DAC7PSS            : 2;
    unsigned                    : 4;
    };
  } __DAC7CON0bits_t;

extern __at(0x059E) volatile __DAC7CON0bits_t DAC7CON0bits;

#define _DAC7CON0_NSS0          0x01
#define _DAC7CON0_DACNSS0       0x01
#define _DAC7CON0_DAC7NSS0      0x01
#define _DAC7CON0_NSS1          0x02
#define _DAC7CON0_DACNSS1       0x02
#define _DAC7CON0_DAC7NSS1      0x02
#define _DAC7CON0_PSS0          0x04
#define _DAC7CON0_DACPSS0       0x04
#define _DAC7CON0_DAC7PSS0      0x04
#define _DAC7CON0_PSS1          0x08
#define _DAC7CON0_DACPSS1       0x08
#define _DAC7CON0_DAC7PSS1      0x08
#define _DAC7CON0_OE2           0x10
#define _DAC7CON0_DACOE2        0x10
#define _DAC7CON0_DAC7OE2       0x10
#define _DAC7CON0_OE1           0x20
#define _DAC7CON0_DACOE1        0x20
#define _DAC7CON0_DAC7OE1       0x20
#define _DAC7CON0_EN            0x80
#define _DAC7CON0_DACEN         0x80
#define _DAC7CON0_DAC7EN        0x80

//==============================================================================


//==============================================================================
//        DAC7CON1 Bits

extern __at(0x059F) __sfr DAC7CON1;

typedef union
  {
  struct
    {
    unsigned DACR0              : 1;
    unsigned DACR1              : 1;
    unsigned DACR2              : 1;
    unsigned DACR3              : 1;
    unsigned DACR4              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned R0                 : 1;
    unsigned R1                 : 1;
    unsigned R2                 : 1;
    unsigned R3                 : 1;
    unsigned R4                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DAC7R0             : 1;
    unsigned DAC7R1             : 1;
    unsigned DAC7R2             : 1;
    unsigned DAC7R3             : 1;
    unsigned DAC7R4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned REF0               : 1;
    unsigned REF1               : 1;
    unsigned REF2               : 1;
    unsigned REF3               : 1;
    unsigned REF4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DAC7REF0           : 1;
    unsigned DAC7REF1           : 1;
    unsigned DAC7REF2           : 1;
    unsigned DAC7REF3           : 1;
    unsigned DAC7REF4           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DACR               : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned REF                : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned R                  : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned DAC7REF            : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned DAC7R              : 5;
    unsigned                    : 3;
    };
  } __DAC7CON1bits_t;

extern __at(0x059F) volatile __DAC7CON1bits_t DAC7CON1bits;

#define _DAC7CON1_DACR0         0x01
#define _DAC7CON1_R0            0x01
#define _DAC7CON1_DAC7R0        0x01
#define _DAC7CON1_REF0          0x01
#define _DAC7CON1_DAC7REF0      0x01
#define _DAC7CON1_DACR1         0x02
#define _DAC7CON1_R1            0x02
#define _DAC7CON1_DAC7R1        0x02
#define _DAC7CON1_REF1          0x02
#define _DAC7CON1_DAC7REF1      0x02
#define _DAC7CON1_DACR2         0x04
#define _DAC7CON1_R2            0x04
#define _DAC7CON1_DAC7R2        0x04
#define _DAC7CON1_REF2          0x04
#define _DAC7CON1_DAC7REF2      0x04
#define _DAC7CON1_DACR3         0x08
#define _DAC7CON1_R3            0x08
#define _DAC7CON1_DAC7R3        0x08
#define _DAC7CON1_REF3          0x08
#define _DAC7CON1_DAC7REF3      0x08
#define _DAC7CON1_DACR4         0x10
#define _DAC7CON1_R4            0x10
#define _DAC7CON1_DAC7R4        0x10
#define _DAC7CON1_REF4          0x10
#define _DAC7CON1_DAC7REF4      0x10

//==============================================================================


//==============================================================================
//        DAC7REF Bits

extern __at(0x059F) __sfr DAC7REF;

typedef union
  {
  struct
    {
    unsigned DACR0              : 1;
    unsigned DACR1              : 1;
    unsigned DACR2              : 1;
    unsigned DACR3              : 1;
    unsigned DACR4              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned R0                 : 1;
    unsigned R1                 : 1;
    unsigned R2                 : 1;
    unsigned R3                 : 1;
    unsigned R4                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DAC7R0             : 1;
    unsigned DAC7R1             : 1;
    unsigned DAC7R2             : 1;
    unsigned DAC7R3             : 1;
    unsigned DAC7R4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned REF0               : 1;
    unsigned REF1               : 1;
    unsigned REF2               : 1;
    unsigned REF3               : 1;
    unsigned REF4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DAC7REF0           : 1;
    unsigned DAC7REF1           : 1;
    unsigned DAC7REF2           : 1;
    unsigned DAC7REF3           : 1;
    unsigned DAC7REF4           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DAC7R              : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned DAC7REF            : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned R                  : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned REF                : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned DACR               : 5;
    unsigned                    : 3;
    };
  } __DAC7REFbits_t;

extern __at(0x059F) volatile __DAC7REFbits_t DAC7REFbits;

#define _DAC7REF_DACR0          0x01
#define _DAC7REF_R0             0x01
#define _DAC7REF_DAC7R0         0x01
#define _DAC7REF_REF0           0x01
#define _DAC7REF_DAC7REF0       0x01
#define _DAC7REF_DACR1          0x02
#define _DAC7REF_R1             0x02
#define _DAC7REF_DAC7R1         0x02
#define _DAC7REF_REF1           0x02
#define _DAC7REF_DAC7REF1       0x02
#define _DAC7REF_DACR2          0x04
#define _DAC7REF_R2             0x04
#define _DAC7REF_DAC7R2         0x04
#define _DAC7REF_REF2           0x04
#define _DAC7REF_DAC7REF2       0x04
#define _DAC7REF_DACR3          0x08
#define _DAC7REF_R3             0x08
#define _DAC7REF_DAC7R3         0x08
#define _DAC7REF_REF3           0x08
#define _DAC7REF_DAC7REF3       0x08
#define _DAC7REF_DACR4          0x10
#define _DAC7REF_R4             0x10
#define _DAC7REF_DAC7R4         0x10
#define _DAC7REF_REF4           0x10
#define _DAC7REF_DAC7REF4       0x10

//==============================================================================


//==============================================================================
//        PWM3DCL Bits

extern __at(0x0614) __sfr PWM3DCL;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned DC0                : 1;
    unsigned DC1                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWM3DC0            : 1;
    unsigned PWM3DC1            : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWMPW0             : 1;
    unsigned PWMPW1             : 1;
    };

  struct
    {
    unsigned                    : 6;
    unsigned DC                 : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned PWMPW              : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned PWM3DC             : 2;
    };
  } __PWM3DCLbits_t;

extern __at(0x0614) volatile __PWM3DCLbits_t PWM3DCLbits;

#define _DC0                    0x40
#define _PWM3DC0                0x40
#define _PWMPW0                 0x40
#define _DC1                    0x80
#define _PWM3DC1                0x80
#define _PWMPW1                 0x80

//==============================================================================


//==============================================================================
//        PWM3DCH Bits

extern __at(0x0615) __sfr PWM3DCH;

typedef union
  {
  struct
    {
    unsigned DC2                : 1;
    unsigned DC3                : 1;
    unsigned DC4                : 1;
    unsigned DC5                : 1;
    unsigned DC6                : 1;
    unsigned DC7                : 1;
    unsigned DC8                : 1;
    unsigned DC9                : 1;
    };

  struct
    {
    unsigned PWM3DC2            : 1;
    unsigned PWM3DC3            : 1;
    unsigned PWM3DC4            : 1;
    unsigned PWM3DC5            : 1;
    unsigned PWM3DC6            : 1;
    unsigned PWM3DC7            : 1;
    unsigned PWM3DC8            : 1;
    unsigned PWM3DC9            : 1;
    };

  struct
    {
    unsigned PWMPW2             : 1;
    unsigned PWMPW3             : 1;
    unsigned PWMPW4             : 1;
    unsigned PWMPW5             : 1;
    unsigned PWMPW6             : 1;
    unsigned PWMPW7             : 1;
    unsigned PWMPW8             : 1;
    unsigned PWMPW9             : 1;
    };
  } __PWM3DCHbits_t;

extern __at(0x0615) volatile __PWM3DCHbits_t PWM3DCHbits;

#define _DC2                    0x01
#define _PWM3DC2                0x01
#define _PWMPW2                 0x01
#define _DC3                    0x02
#define _PWM3DC3                0x02
#define _PWMPW3                 0x02
#define _DC4                    0x04
#define _PWM3DC4                0x04
#define _PWMPW4                 0x04
#define _DC5                    0x08
#define _PWM3DC5                0x08
#define _PWMPW5                 0x08
#define _DC6                    0x10
#define _PWM3DC6                0x10
#define _PWMPW6                 0x10
#define _DC7                    0x20
#define _PWM3DC7                0x20
#define _PWMPW7                 0x20
#define _DC8                    0x40
#define _PWM3DC8                0x40
#define _PWMPW8                 0x40
#define _DC9                    0x80
#define _PWM3DC9                0x80
#define _PWMPW9                 0x80

//==============================================================================


//==============================================================================
//        PWM3CON Bits

extern __at(0x0616) __sfr PWM3CON;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned POL                : 1;
    unsigned OUT                : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWM3POL            : 1;
    unsigned PWM3OUT            : 1;
    unsigned                    : 1;
    unsigned PWM3EN             : 1;
    };
  } __PWM3CONbits_t;

extern __at(0x0616) volatile __PWM3CONbits_t PWM3CONbits;

#define _PWM3CON_POL            0x10
#define _PWM3CON_PWM3POL        0x10
#define _PWM3CON_OUT            0x20
#define _PWM3CON_PWM3OUT        0x20
#define _PWM3CON_EN             0x80
#define _PWM3CON_PWM3EN         0x80

//==============================================================================


//==============================================================================
//        PWM4DCL Bits

extern __at(0x0617) __sfr PWM4DCL;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned DC0                : 1;
    unsigned DC1                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWM4DC0            : 1;
    unsigned PWM4DC1            : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWMPW0             : 1;
    unsigned PWMPW1             : 1;
    };

  struct
    {
    unsigned                    : 6;
    unsigned DC                 : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned PWMPW              : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned PWM4DC             : 2;
    };
  } __PWM4DCLbits_t;

extern __at(0x0617) volatile __PWM4DCLbits_t PWM4DCLbits;

#define _PWM4DCL_DC0            0x40
#define _PWM4DCL_PWM4DC0        0x40
#define _PWM4DCL_PWMPW0         0x40
#define _PWM4DCL_DC1            0x80
#define _PWM4DCL_PWM4DC1        0x80
#define _PWM4DCL_PWMPW1         0x80

//==============================================================================


//==============================================================================
//        PWM4DCH Bits

extern __at(0x0618) __sfr PWM4DCH;

typedef union
  {
  struct
    {
    unsigned DC2                : 1;
    unsigned DC3                : 1;
    unsigned DC4                : 1;
    unsigned DC5                : 1;
    unsigned DC6                : 1;
    unsigned DC7                : 1;
    unsigned DC8                : 1;
    unsigned DC9                : 1;
    };

  struct
    {
    unsigned PWM4DC2            : 1;
    unsigned PWM4DC3            : 1;
    unsigned PWM4DC4            : 1;
    unsigned PWM4DC5            : 1;
    unsigned PWM4DC6            : 1;
    unsigned PWM4DC7            : 1;
    unsigned PWM4DC8            : 1;
    unsigned PWM4DC9            : 1;
    };

  struct
    {
    unsigned PWMPW2             : 1;
    unsigned PWMPW3             : 1;
    unsigned PWMPW4             : 1;
    unsigned PWMPW5             : 1;
    unsigned PWMPW6             : 1;
    unsigned PWMPW7             : 1;
    unsigned PWMPW8             : 1;
    unsigned PWMPW9             : 1;
    };
  } __PWM4DCHbits_t;

extern __at(0x0618) volatile __PWM4DCHbits_t PWM4DCHbits;

#define _PWM4DCH_DC2            0x01
#define _PWM4DCH_PWM4DC2        0x01
#define _PWM4DCH_PWMPW2         0x01
#define _PWM4DCH_DC3            0x02
#define _PWM4DCH_PWM4DC3        0x02
#define _PWM4DCH_PWMPW3         0x02
#define _PWM4DCH_DC4            0x04
#define _PWM4DCH_PWM4DC4        0x04
#define _PWM4DCH_PWMPW4         0x04
#define _PWM4DCH_DC5            0x08
#define _PWM4DCH_PWM4DC5        0x08
#define _PWM4DCH_PWMPW5         0x08
#define _PWM4DCH_DC6            0x10
#define _PWM4DCH_PWM4DC6        0x10
#define _PWM4DCH_PWMPW6         0x10
#define _PWM4DCH_DC7            0x20
#define _PWM4DCH_PWM4DC7        0x20
#define _PWM4DCH_PWMPW7         0x20
#define _PWM4DCH_DC8            0x40
#define _PWM4DCH_PWM4DC8        0x40
#define _PWM4DCH_PWMPW8         0x40
#define _PWM4DCH_DC9            0x80
#define _PWM4DCH_PWM4DC9        0x80
#define _PWM4DCH_PWMPW9         0x80

//==============================================================================


//==============================================================================
//        PWM4CON Bits

extern __at(0x0619) __sfr PWM4CON;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned POL                : 1;
    unsigned OUT                : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWM4POL            : 1;
    unsigned PWM4OUT            : 1;
    unsigned                    : 1;
    unsigned PWM4EN             : 1;
    };
  } __PWM4CONbits_t;

extern __at(0x0619) volatile __PWM4CONbits_t PWM4CONbits;

#define _PWM4CON_POL            0x10
#define _PWM4CON_PWM4POL        0x10
#define _PWM4CON_OUT            0x20
#define _PWM4CON_PWM4OUT        0x20
#define _PWM4CON_EN             0x80
#define _PWM4CON_PWM4EN         0x80

//==============================================================================


//==============================================================================
//        PWM9DCL Bits

extern __at(0x061A) __sfr PWM9DCL;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned DC0                : 1;
    unsigned DC1                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWM9DC0            : 1;
    unsigned PWM9DC1            : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWMPW0             : 1;
    unsigned PWMPW1             : 1;
    };

  struct
    {
    unsigned                    : 6;
    unsigned PWM9DC             : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned PWMPW              : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned DC                 : 2;
    };
  } __PWM9DCLbits_t;

extern __at(0x061A) volatile __PWM9DCLbits_t PWM9DCLbits;

#define _PWM9DCL_DC0            0x40
#define _PWM9DCL_PWM9DC0        0x40
#define _PWM9DCL_PWMPW0         0x40
#define _PWM9DCL_DC1            0x80
#define _PWM9DCL_PWM9DC1        0x80
#define _PWM9DCL_PWMPW1         0x80

//==============================================================================


//==============================================================================
//        PWM9DCH Bits

extern __at(0x061B) __sfr PWM9DCH;

typedef union
  {
  struct
    {
    unsigned DC2                : 1;
    unsigned DC3                : 1;
    unsigned DC4                : 1;
    unsigned DC5                : 1;
    unsigned DC6                : 1;
    unsigned DC7                : 1;
    unsigned DC8                : 1;
    unsigned DC9                : 1;
    };

  struct
    {
    unsigned PWM9DC2            : 1;
    unsigned PWM9DC3            : 1;
    unsigned PWM9DC4            : 1;
    unsigned PWM9DC5            : 1;
    unsigned PWM9DC6            : 1;
    unsigned PWM9DC7            : 1;
    unsigned PWM9DC8            : 1;
    unsigned PWM9DC9            : 1;
    };

  struct
    {
    unsigned PWMPW2             : 1;
    unsigned PWMPW3             : 1;
    unsigned PWMPW4             : 1;
    unsigned PWMPW5             : 1;
    unsigned PWMPW6             : 1;
    unsigned PWMPW7             : 1;
    unsigned PWMPW8             : 1;
    unsigned PWMPW9             : 1;
    };
  } __PWM9DCHbits_t;

extern __at(0x061B) volatile __PWM9DCHbits_t PWM9DCHbits;

#define _PWM9DCH_DC2            0x01
#define _PWM9DCH_PWM9DC2        0x01
#define _PWM9DCH_PWMPW2         0x01
#define _PWM9DCH_DC3            0x02
#define _PWM9DCH_PWM9DC3        0x02
#define _PWM9DCH_PWMPW3         0x02
#define _PWM9DCH_DC4            0x04
#define _PWM9DCH_PWM9DC4        0x04
#define _PWM9DCH_PWMPW4         0x04
#define _PWM9DCH_DC5            0x08
#define _PWM9DCH_PWM9DC5        0x08
#define _PWM9DCH_PWMPW5         0x08
#define _PWM9DCH_DC6            0x10
#define _PWM9DCH_PWM9DC6        0x10
#define _PWM9DCH_PWMPW6         0x10
#define _PWM9DCH_DC7            0x20
#define _PWM9DCH_PWM9DC7        0x20
#define _PWM9DCH_PWMPW7         0x20
#define _PWM9DCH_DC8            0x40
#define _PWM9DCH_PWM9DC8        0x40
#define _PWM9DCH_PWMPW8         0x40
#define _PWM9DCH_DC9            0x80
#define _PWM9DCH_PWM9DC9        0x80
#define _PWM9DCH_PWMPW9         0x80

//==============================================================================


//==============================================================================
//        PWM9CON Bits

extern __at(0x061C) __sfr PWM9CON;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned POL                : 1;
    unsigned OUT                : 1;
    unsigned OE                 : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWM9POL            : 1;
    unsigned PWM9OUT            : 1;
    unsigned PWM9OE             : 1;
    unsigned PWM9EN             : 1;
    };
  } __PWM9CONbits_t;

extern __at(0x061C) volatile __PWM9CONbits_t PWM9CONbits;

#define _PWM9CON_POL            0x10
#define _PWM9CON_PWM9POL        0x10
#define _PWM9CON_OUT            0x20
#define _PWM9CON_PWM9OUT        0x20
#define _PWM9CON_OE             0x40
#define _PWM9CON_PWM9OE         0x40
#define _PWM9CON_EN             0x80
#define _PWM9CON_PWM9EN         0x80

//==============================================================================


//==============================================================================
//        COG1PHR Bits

extern __at(0x068D) __sfr COG1PHR;

typedef union
  {
  struct
    {
    unsigned PHR0               : 1;
    unsigned PHR1               : 1;
    unsigned PHR2               : 1;
    unsigned PHR3               : 1;
    unsigned PHR4               : 1;
    unsigned PHR5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned G1PHR0             : 1;
    unsigned G1PHR1             : 1;
    unsigned G1PHR2             : 1;
    unsigned G1PHR3             : 1;
    unsigned G1PHR4             : 1;
    unsigned G1PHR5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned G1PHR              : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned PHR                : 6;
    unsigned                    : 2;
    };
  } __COG1PHRbits_t;

extern __at(0x068D) volatile __COG1PHRbits_t COG1PHRbits;

#define _PHR0                   0x01
#define _G1PHR0                 0x01
#define _PHR1                   0x02
#define _G1PHR1                 0x02
#define _PHR2                   0x04
#define _G1PHR2                 0x04
#define _PHR3                   0x08
#define _G1PHR3                 0x08
#define _PHR4                   0x10
#define _G1PHR4                 0x10
#define _PHR5                   0x20
#define _G1PHR5                 0x20

//==============================================================================


//==============================================================================
//        COG1PHF Bits

extern __at(0x068E) __sfr COG1PHF;

typedef union
  {
  struct
    {
    unsigned PHF0               : 1;
    unsigned PHF1               : 1;
    unsigned PHF2               : 1;
    unsigned PHF3               : 1;
    unsigned PHF4               : 1;
    unsigned PHF5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned G1PHF0             : 1;
    unsigned G1PHF1             : 1;
    unsigned G1PHF2             : 1;
    unsigned G1PHF3             : 1;
    unsigned G1PHF4             : 1;
    unsigned G1PHF5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned G1PHF              : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned PHF                : 6;
    unsigned                    : 2;
    };
  } __COG1PHFbits_t;

extern __at(0x068E) volatile __COG1PHFbits_t COG1PHFbits;

#define _PHF0                   0x01
#define _G1PHF0                 0x01
#define _PHF1                   0x02
#define _G1PHF1                 0x02
#define _PHF2                   0x04
#define _G1PHF2                 0x04
#define _PHF3                   0x08
#define _G1PHF3                 0x08
#define _PHF4                   0x10
#define _G1PHF4                 0x10
#define _PHF5                   0x20
#define _G1PHF5                 0x20

//==============================================================================


//==============================================================================
//        COG1BLKR Bits

extern __at(0x068F) __sfr COG1BLKR;

typedef union
  {
  struct
    {
    unsigned BLKR0              : 1;
    unsigned BLKR1              : 1;
    unsigned BLKR2              : 1;
    unsigned BLKR3              : 1;
    unsigned BLKR4              : 1;
    unsigned BLKR5              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned G1BLKR0            : 1;
    unsigned G1BLKR1            : 1;
    unsigned G1BLKR2            : 1;
    unsigned G1BLKR3            : 1;
    unsigned G1BLKR4            : 1;
    unsigned G1BLKR5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned G1BLKR             : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned BLKR               : 6;
    unsigned                    : 2;
    };
  } __COG1BLKRbits_t;

extern __at(0x068F) volatile __COG1BLKRbits_t COG1BLKRbits;

#define _BLKR0                  0x01
#define _G1BLKR0                0x01
#define _BLKR1                  0x02
#define _G1BLKR1                0x02
#define _BLKR2                  0x04
#define _G1BLKR2                0x04
#define _BLKR3                  0x08
#define _G1BLKR3                0x08
#define _BLKR4                  0x10
#define _G1BLKR4                0x10
#define _BLKR5                  0x20
#define _G1BLKR5                0x20

//==============================================================================


//==============================================================================
//        COG1BLKF Bits

extern __at(0x0690) __sfr COG1BLKF;

typedef union
  {
  struct
    {
    unsigned BLKF0              : 1;
    unsigned BLKF1              : 1;
    unsigned BLKF2              : 1;
    unsigned BLKF3              : 1;
    unsigned BLKF4              : 1;
    unsigned BLKF5              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned G1BLKF0            : 1;
    unsigned G1BLKF1            : 1;
    unsigned G1BLKF2            : 1;
    unsigned G1BLKF3            : 1;
    unsigned G1BLKF4            : 1;
    unsigned G1BLKF5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned G1BLKF             : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned BLKF               : 6;
    unsigned                    : 2;
    };
  } __COG1BLKFbits_t;

extern __at(0x0690) volatile __COG1BLKFbits_t COG1BLKFbits;

#define _BLKF0                  0x01
#define _G1BLKF0                0x01
#define _BLKF1                  0x02
#define _G1BLKF1                0x02
#define _BLKF2                  0x04
#define _G1BLKF2                0x04
#define _BLKF3                  0x08
#define _G1BLKF3                0x08
#define _BLKF4                  0x10
#define _G1BLKF4                0x10
#define _BLKF5                  0x20
#define _G1BLKF5                0x20

//==============================================================================


//==============================================================================
//        COG1DBR Bits

extern __at(0x0691) __sfr COG1DBR;

typedef union
  {
  struct
    {
    unsigned DBR0               : 1;
    unsigned DBR1               : 1;
    unsigned DBR2               : 1;
    unsigned DBR3               : 1;
    unsigned DBR4               : 1;
    unsigned DBR5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned G1DBR0             : 1;
    unsigned G1DBR1             : 1;
    unsigned G1DBR2             : 1;
    unsigned G1DBR3             : 1;
    unsigned G1DBR4             : 1;
    unsigned G1DBR5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned G1DBR              : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned DBR                : 6;
    unsigned                    : 2;
    };
  } __COG1DBRbits_t;

extern __at(0x0691) volatile __COG1DBRbits_t COG1DBRbits;

#define _DBR0                   0x01
#define _G1DBR0                 0x01
#define _DBR1                   0x02
#define _G1DBR1                 0x02
#define _DBR2                   0x04
#define _G1DBR2                 0x04
#define _DBR3                   0x08
#define _G1DBR3                 0x08
#define _DBR4                   0x10
#define _G1DBR4                 0x10
#define _DBR5                   0x20
#define _G1DBR5                 0x20

//==============================================================================


//==============================================================================
//        COG1DBF Bits

extern __at(0x0692) __sfr COG1DBF;

typedef union
  {
  struct
    {
    unsigned DBF0               : 1;
    unsigned DBF1               : 1;
    unsigned DBF2               : 1;
    unsigned DBF3               : 1;
    unsigned DBF4               : 1;
    unsigned DBF5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned G1DBF0             : 1;
    unsigned G1DBF1             : 1;
    unsigned G1DBF2             : 1;
    unsigned G1DBF3             : 1;
    unsigned G1DBF4             : 1;
    unsigned G1DBF5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned G1DBF              : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned DBF                : 6;
    unsigned                    : 2;
    };
  } __COG1DBFbits_t;

extern __at(0x0692) volatile __COG1DBFbits_t COG1DBFbits;

#define _DBF0                   0x01
#define _G1DBF0                 0x01
#define _DBF1                   0x02
#define _G1DBF1                 0x02
#define _DBF2                   0x04
#define _G1DBF2                 0x04
#define _DBF3                   0x08
#define _G1DBF3                 0x08
#define _DBF4                   0x10
#define _G1DBF4                 0x10
#define _DBF5                   0x20
#define _G1DBF5                 0x20

//==============================================================================


//==============================================================================
//        COG1CON0 Bits

extern __at(0x0693) __sfr COG1CON0;

typedef union
  {
  struct
    {
    unsigned MD0                : 1;
    unsigned MD1                : 1;
    unsigned MD2                : 1;
    unsigned CS0                : 1;
    unsigned CS1                : 1;
    unsigned                    : 1;
    unsigned LD                 : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned G1MD0              : 1;
    unsigned G1MD1              : 1;
    unsigned G1MD2              : 1;
    unsigned G1CS0              : 1;
    unsigned G1CS1              : 1;
    unsigned                    : 1;
    unsigned G1LD               : 1;
    unsigned G1EN               : 1;
    };

  struct
    {
    unsigned MD                 : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned G1MD               : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 3;
    unsigned CS                 : 2;
    unsigned                    : 3;
    };

  struct
    {
    unsigned                    : 3;
    unsigned G1CS               : 2;
    unsigned                    : 3;
    };
  } __COG1CON0bits_t;

extern __at(0x0693) volatile __COG1CON0bits_t COG1CON0bits;

#define _COG1CON0_MD0           0x01
#define _COG1CON0_G1MD0         0x01
#define _COG1CON0_MD1           0x02
#define _COG1CON0_G1MD1         0x02
#define _COG1CON0_MD2           0x04
#define _COG1CON0_G1MD2         0x04
#define _COG1CON0_CS0           0x08
#define _COG1CON0_G1CS0         0x08
#define _COG1CON0_CS1           0x10
#define _COG1CON0_G1CS1         0x10
#define _COG1CON0_LD            0x40
#define _COG1CON0_G1LD          0x40
#define _COG1CON0_EN            0x80
#define _COG1CON0_G1EN          0x80

//==============================================================================


//==============================================================================
//        COG1CON1 Bits

extern __at(0x0694) __sfr COG1CON1;

typedef union
  {
  struct
    {
    unsigned POLA               : 1;
    unsigned POLB               : 1;
    unsigned POLC               : 1;
    unsigned POLD               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned FDBS               : 1;
    unsigned RDBS               : 1;
    };

  struct
    {
    unsigned G1POLA             : 1;
    unsigned G1POLB             : 1;
    unsigned G1POLC             : 1;
    unsigned G1POLD             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned G1FDBS             : 1;
    unsigned G1RDBS             : 1;
    };
  } __COG1CON1bits_t;

extern __at(0x0694) volatile __COG1CON1bits_t COG1CON1bits;

#define _POLA                   0x01
#define _G1POLA                 0x01
#define _POLB                   0x02
#define _G1POLB                 0x02
#define _POLC                   0x04
#define _G1POLC                 0x04
#define _POLD                   0x08
#define _G1POLD                 0x08
#define _FDBS                   0x40
#define _G1FDBS                 0x40
#define _RDBS                   0x80
#define _G1RDBS                 0x80

//==============================================================================


//==============================================================================
//        COG1RIS0 Bits

extern __at(0x0695) __sfr COG1RIS0;

typedef union
  {
  struct
    {
    unsigned RIS0               : 1;
    unsigned RIS1               : 1;
    unsigned RIS2               : 1;
    unsigned RIS3               : 1;
    unsigned RIS4               : 1;
    unsigned RIS5               : 1;
    unsigned RIS6               : 1;
    unsigned RIS7               : 1;
    };

  struct
    {
    unsigned G1RIS0             : 1;
    unsigned G1RIS1             : 1;
    unsigned G1RIS2             : 1;
    unsigned G1RIS3             : 1;
    unsigned G1RIS4             : 1;
    unsigned G1RIS5             : 1;
    unsigned G1RIS6             : 1;
    unsigned G1RIS7             : 1;
    };
  } __COG1RIS0bits_t;

extern __at(0x0695) volatile __COG1RIS0bits_t COG1RIS0bits;

#define _RIS0                   0x01
#define _G1RIS0                 0x01
#define _RIS1                   0x02
#define _G1RIS1                 0x02
#define _RIS2                   0x04
#define _G1RIS2                 0x04
#define _RIS3                   0x08
#define _G1RIS3                 0x08
#define _RIS4                   0x10
#define _G1RIS4                 0x10
#define _RIS5                   0x20
#define _G1RIS5                 0x20
#define _RIS6                   0x40
#define _G1RIS6                 0x40
#define _RIS7                   0x80
#define _G1RIS7                 0x80

//==============================================================================


//==============================================================================
//        COG1RIS1 Bits

extern __at(0x0696) __sfr COG1RIS1;

typedef union
  {
  struct
    {
    unsigned RIS8               : 1;
    unsigned RIS9               : 1;
    unsigned RIS10              : 1;
    unsigned RIS11              : 1;
    unsigned RIS12              : 1;
    unsigned RIS13              : 1;
    unsigned RIS14              : 1;
    unsigned RIS15              : 1;
    };

  struct
    {
    unsigned G1RIS8             : 1;
    unsigned G1RIS9             : 1;
    unsigned G1RIS10            : 1;
    unsigned G1RIS11            : 1;
    unsigned G1RIS12            : 1;
    unsigned G1RIS13            : 1;
    unsigned G1RIS14            : 1;
    unsigned G1RIS15            : 1;
    };
  } __COG1RIS1bits_t;

extern __at(0x0696) volatile __COG1RIS1bits_t COG1RIS1bits;

#define _RIS8                   0x01
#define _G1RIS8                 0x01
#define _RIS9                   0x02
#define _G1RIS9                 0x02
#define _RIS10                  0x04
#define _G1RIS10                0x04
#define _RIS11                  0x08
#define _G1RIS11                0x08
#define _RIS12                  0x10
#define _G1RIS12                0x10
#define _RIS13                  0x20
#define _G1RIS13                0x20
#define _RIS14                  0x40
#define _G1RIS14                0x40
#define _RIS15                  0x80
#define _G1RIS15                0x80

//==============================================================================


//==============================================================================
//        COG1RSIM0 Bits

extern __at(0x0697) __sfr COG1RSIM0;

typedef union
  {
  struct
    {
    unsigned RSIM0              : 1;
    unsigned RSIM1              : 1;
    unsigned RSIM2              : 1;
    unsigned RSIM3              : 1;
    unsigned RSIM4              : 1;
    unsigned RSIM5              : 1;
    unsigned RSIM6              : 1;
    unsigned RSIM7              : 1;
    };

  struct
    {
    unsigned G1RSIM0            : 1;
    unsigned G1RSIM1            : 1;
    unsigned G1RSIM2            : 1;
    unsigned G1RSIM3            : 1;
    unsigned G1RSIM4            : 1;
    unsigned G1RSIM5            : 1;
    unsigned G1RSIM6            : 1;
    unsigned G1RSIM7            : 1;
    };
  } __COG1RSIM0bits_t;

extern __at(0x0697) volatile __COG1RSIM0bits_t COG1RSIM0bits;

#define _RSIM0                  0x01
#define _G1RSIM0                0x01
#define _RSIM1                  0x02
#define _G1RSIM1                0x02
#define _RSIM2                  0x04
#define _G1RSIM2                0x04
#define _RSIM3                  0x08
#define _G1RSIM3                0x08
#define _RSIM4                  0x10
#define _G1RSIM4                0x10
#define _RSIM5                  0x20
#define _G1RSIM5                0x20
#define _RSIM6                  0x40
#define _G1RSIM6                0x40
#define _RSIM7                  0x80
#define _G1RSIM7                0x80

//==============================================================================


//==============================================================================
//        COG1RSIM1 Bits

extern __at(0x0698) __sfr COG1RSIM1;

typedef union
  {
  struct
    {
    unsigned RSIM8              : 1;
    unsigned RSIM9              : 1;
    unsigned RSIM10             : 1;
    unsigned RSIM11             : 1;
    unsigned RSIM12             : 1;
    unsigned RSIM13             : 1;
    unsigned RSIM14             : 1;
    unsigned RSIM15             : 1;
    };

  struct
    {
    unsigned G1RSIM8            : 1;
    unsigned G1RSIM9            : 1;
    unsigned G1RSIM10           : 1;
    unsigned G1RSIM11           : 1;
    unsigned G1RSIM12           : 1;
    unsigned G1RSIM13           : 1;
    unsigned G1RSIM14           : 1;
    unsigned G1RSIM15           : 1;
    };
  } __COG1RSIM1bits_t;

extern __at(0x0698) volatile __COG1RSIM1bits_t COG1RSIM1bits;

#define _RSIM8                  0x01
#define _G1RSIM8                0x01
#define _RSIM9                  0x02
#define _G1RSIM9                0x02
#define _RSIM10                 0x04
#define _G1RSIM10               0x04
#define _RSIM11                 0x08
#define _G1RSIM11               0x08
#define _RSIM12                 0x10
#define _G1RSIM12               0x10
#define _RSIM13                 0x20
#define _G1RSIM13               0x20
#define _RSIM14                 0x40
#define _G1RSIM14               0x40
#define _RSIM15                 0x80
#define _G1RSIM15               0x80

//==============================================================================


//==============================================================================
//        COG1FIS0 Bits

extern __at(0x0699) __sfr COG1FIS0;

typedef union
  {
  struct
    {
    unsigned FIS0               : 1;
    unsigned FIS1               : 1;
    unsigned FIS2               : 1;
    unsigned FIS3               : 1;
    unsigned FIS4               : 1;
    unsigned FIS5               : 1;
    unsigned FIS6               : 1;
    unsigned FIS7               : 1;
    };

  struct
    {
    unsigned G1FIS0             : 1;
    unsigned G1FIS1             : 1;
    unsigned G1FIS2             : 1;
    unsigned G1FIS3             : 1;
    unsigned G1FIS4             : 1;
    unsigned G1FIS5             : 1;
    unsigned G1FIS6             : 1;
    unsigned G1FIS7             : 1;
    };
  } __COG1FIS0bits_t;

extern __at(0x0699) volatile __COG1FIS0bits_t COG1FIS0bits;

#define _FIS0                   0x01
#define _G1FIS0                 0x01
#define _FIS1                   0x02
#define _G1FIS1                 0x02
#define _FIS2                   0x04
#define _G1FIS2                 0x04
#define _FIS3                   0x08
#define _G1FIS3                 0x08
#define _FIS4                   0x10
#define _G1FIS4                 0x10
#define _FIS5                   0x20
#define _G1FIS5                 0x20
#define _FIS6                   0x40
#define _G1FIS6                 0x40
#define _FIS7                   0x80
#define _G1FIS7                 0x80

//==============================================================================


//==============================================================================
//        COG1FIS1 Bits

extern __at(0x069A) __sfr COG1FIS1;

typedef union
  {
  struct
    {
    unsigned FIS8               : 1;
    unsigned FIS9               : 1;
    unsigned FIS10              : 1;
    unsigned FIS11              : 1;
    unsigned FIS12              : 1;
    unsigned FIS13              : 1;
    unsigned FIS14              : 1;
    unsigned FIS15              : 1;
    };

  struct
    {
    unsigned G1FIS8             : 1;
    unsigned G1FIS9             : 1;
    unsigned G1FIS10            : 1;
    unsigned G1FIS11            : 1;
    unsigned G1FIS12            : 1;
    unsigned G1FIS13            : 1;
    unsigned G1FIS14            : 1;
    unsigned G1FIS15            : 1;
    };
  } __COG1FIS1bits_t;

extern __at(0x069A) volatile __COG1FIS1bits_t COG1FIS1bits;

#define _FIS8                   0x01
#define _G1FIS8                 0x01
#define _FIS9                   0x02
#define _G1FIS9                 0x02
#define _FIS10                  0x04
#define _G1FIS10                0x04
#define _FIS11                  0x08
#define _G1FIS11                0x08
#define _FIS12                  0x10
#define _G1FIS12                0x10
#define _FIS13                  0x20
#define _G1FIS13                0x20
#define _FIS14                  0x40
#define _G1FIS14                0x40
#define _FIS15                  0x80
#define _G1FIS15                0x80

//==============================================================================


//==============================================================================
//        COG1FSIM0 Bits

extern __at(0x069B) __sfr COG1FSIM0;

typedef union
  {
  struct
    {
    unsigned FSIM0              : 1;
    unsigned FSIM1              : 1;
    unsigned FSIM2              : 1;
    unsigned FSIM3              : 1;
    unsigned FSIM4              : 1;
    unsigned FSIM5              : 1;
    unsigned FSIM6              : 1;
    unsigned FSIM7              : 1;
    };

  struct
    {
    unsigned G1FSIM0            : 1;
    unsigned G1FSIM1            : 1;
    unsigned G1FSIM2            : 1;
    unsigned G1FSIM3            : 1;
    unsigned G1FSIM4            : 1;
    unsigned G1FSIM5            : 1;
    unsigned G1FSIM6            : 1;
    unsigned G1FSIM7            : 1;
    };
  } __COG1FSIM0bits_t;

extern __at(0x069B) volatile __COG1FSIM0bits_t COG1FSIM0bits;

#define _FSIM0                  0x01
#define _G1FSIM0                0x01
#define _FSIM1                  0x02
#define _G1FSIM1                0x02
#define _FSIM2                  0x04
#define _G1FSIM2                0x04
#define _FSIM3                  0x08
#define _G1FSIM3                0x08
#define _FSIM4                  0x10
#define _G1FSIM4                0x10
#define _FSIM5                  0x20
#define _G1FSIM5                0x20
#define _FSIM6                  0x40
#define _G1FSIM6                0x40
#define _FSIM7                  0x80
#define _G1FSIM7                0x80

//==============================================================================


//==============================================================================
//        COG1FSIM1 Bits

extern __at(0x069C) __sfr COG1FSIM1;

typedef union
  {
  struct
    {
    unsigned FSIM8              : 1;
    unsigned FSIM9              : 1;
    unsigned FSIM10             : 1;
    unsigned FSIM11             : 1;
    unsigned FSIM12             : 1;
    unsigned FSIM13             : 1;
    unsigned FSIM14             : 1;
    unsigned FSIM15             : 1;
    };

  struct
    {
    unsigned G1FSIM8            : 1;
    unsigned G1FSIM9            : 1;
    unsigned G1FSIM10           : 1;
    unsigned G1FSIM11           : 1;
    unsigned G1FSIM12           : 1;
    unsigned G1FSIM13           : 1;
    unsigned G1FSIM14           : 1;
    unsigned G1FSIM15           : 1;
    };
  } __COG1FSIM1bits_t;

extern __at(0x069C) volatile __COG1FSIM1bits_t COG1FSIM1bits;

#define _FSIM8                  0x01
#define _G1FSIM8                0x01
#define _FSIM9                  0x02
#define _G1FSIM9                0x02
#define _FSIM10                 0x04
#define _G1FSIM10               0x04
#define _FSIM11                 0x08
#define _G1FSIM11               0x08
#define _FSIM12                 0x10
#define _G1FSIM12               0x10
#define _FSIM13                 0x20
#define _G1FSIM13               0x20
#define _FSIM14                 0x40
#define _G1FSIM14               0x40
#define _FSIM15                 0x80
#define _G1FSIM15               0x80

//==============================================================================


//==============================================================================
//        COG1ASD0 Bits

extern __at(0x069D) __sfr COG1ASD0;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ASDAC0             : 1;
    unsigned ASDAC1             : 1;
    unsigned ASDBD0             : 1;
    unsigned ASDBD1             : 1;
    unsigned ASREN              : 1;
    unsigned ASE                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned G1ASDAC0           : 1;
    unsigned G1ASDAC1           : 1;
    unsigned G1ASDBD0           : 1;
    unsigned G1ASDBD1           : 1;
    unsigned ARSEN              : 1;
    unsigned G1ASE              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned G1ARSEN            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned G1ASREN            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned G1ASDAC            : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 2;
    unsigned ASDAC              : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned G1ASDBD            : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 4;
    unsigned ASDBD              : 2;
    unsigned                    : 2;
    };
  } __COG1ASD0bits_t;

extern __at(0x069D) volatile __COG1ASD0bits_t COG1ASD0bits;

#define _ASDAC0                 0x04
#define _G1ASDAC0               0x04
#define _ASDAC1                 0x08
#define _G1ASDAC1               0x08
#define _ASDBD0                 0x10
#define _G1ASDBD0               0x10
#define _ASDBD1                 0x20
#define _G1ASDBD1               0x20
#define _ASREN                  0x40
#define _ARSEN                  0x40
#define _G1ARSEN                0x40
#define _G1ASREN                0x40
#define _ASE                    0x80
#define _G1ASE                  0x80

//==============================================================================


//==============================================================================
//        COG1ASD1 Bits

extern __at(0x069E) __sfr COG1ASD1;

typedef union
  {
  struct
    {
    unsigned AS0E               : 1;
    unsigned AS1E               : 1;
    unsigned AS2E               : 1;
    unsigned AS3E               : 1;
    unsigned AS4E               : 1;
    unsigned AS5E               : 1;
    unsigned AS6E               : 1;
    unsigned AS7E               : 1;
    };

  struct
    {
    unsigned G1AS0E             : 1;
    unsigned G1AS1E             : 1;
    unsigned G1AS2E             : 1;
    unsigned G1AS3E             : 1;
    unsigned G1AS4E             : 1;
    unsigned G1AS5E             : 1;
    unsigned G1AS6E             : 1;
    unsigned G1AS7E             : 1;
    };
  } __COG1ASD1bits_t;

extern __at(0x069E) volatile __COG1ASD1bits_t COG1ASD1bits;

#define _AS0E                   0x01
#define _G1AS0E                 0x01
#define _AS1E                   0x02
#define _G1AS1E                 0x02
#define _AS2E                   0x04
#define _G1AS2E                 0x04
#define _AS3E                   0x08
#define _G1AS3E                 0x08
#define _AS4E                   0x10
#define _G1AS4E                 0x10
#define _AS5E                   0x20
#define _G1AS5E                 0x20
#define _AS6E                   0x40
#define _G1AS6E                 0x40
#define _AS7E                   0x80
#define _G1AS7E                 0x80

//==============================================================================


//==============================================================================
//        COG1STR Bits

extern __at(0x069F) __sfr COG1STR;

typedef union
  {
  struct
    {
    unsigned STRA               : 1;
    unsigned STRB               : 1;
    unsigned STRC               : 1;
    unsigned STRD               : 1;
    unsigned SDATA              : 1;
    unsigned SDATB              : 1;
    unsigned SDATC              : 1;
    unsigned SDATD              : 1;
    };

  struct
    {
    unsigned G1STRA             : 1;
    unsigned G1STRB             : 1;
    unsigned G1STRC             : 1;
    unsigned G1STRD             : 1;
    unsigned G1SDATA            : 1;
    unsigned G1SDATB            : 1;
    unsigned G1SDATC            : 1;
    unsigned G1SDATD            : 1;
    };
  } __COG1STRbits_t;

extern __at(0x069F) volatile __COG1STRbits_t COG1STRbits;

#define _STRA                   0x01
#define _G1STRA                 0x01
#define _STRB                   0x02
#define _G1STRB                 0x02
#define _STRC                   0x04
#define _G1STRC                 0x04
#define _STRD                   0x08
#define _G1STRD                 0x08
#define _SDATA                  0x10
#define _G1SDATA                0x10
#define _SDATB                  0x20
#define _G1SDATB                0x20
#define _SDATC                  0x40
#define _G1SDATC                0x40
#define _SDATD                  0x80
#define _G1SDATD                0x80

//==============================================================================


//==============================================================================
//        COG2PHR Bits

extern __at(0x070D) __sfr COG2PHR;

typedef union
  {
  struct
    {
    unsigned PHR0               : 1;
    unsigned PHR1               : 1;
    unsigned PHR2               : 1;
    unsigned PHR3               : 1;
    unsigned PHR4               : 1;
    unsigned PHR5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned G2PHR0             : 1;
    unsigned G2PHR1             : 1;
    unsigned G2PHR2             : 1;
    unsigned G2PHR3             : 1;
    unsigned G2PHR4             : 1;
    unsigned G2PHR5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PHR                : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned G2PHR              : 6;
    unsigned                    : 2;
    };
  } __COG2PHRbits_t;

extern __at(0x070D) volatile __COG2PHRbits_t COG2PHRbits;

#define _COG2PHR_PHR0           0x01
#define _COG2PHR_G2PHR0         0x01
#define _COG2PHR_PHR1           0x02
#define _COG2PHR_G2PHR1         0x02
#define _COG2PHR_PHR2           0x04
#define _COG2PHR_G2PHR2         0x04
#define _COG2PHR_PHR3           0x08
#define _COG2PHR_G2PHR3         0x08
#define _COG2PHR_PHR4           0x10
#define _COG2PHR_G2PHR4         0x10
#define _COG2PHR_PHR5           0x20
#define _COG2PHR_G2PHR5         0x20

//==============================================================================


//==============================================================================
//        COG2PHF Bits

extern __at(0x070E) __sfr COG2PHF;

typedef union
  {
  struct
    {
    unsigned PHF0               : 1;
    unsigned PHF1               : 1;
    unsigned PHF2               : 1;
    unsigned PHF3               : 1;
    unsigned PHF4               : 1;
    unsigned PHF5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned G2PHF0             : 1;
    unsigned G2PHF1             : 1;
    unsigned G2PHF2             : 1;
    unsigned G2PHF3             : 1;
    unsigned G2PHF4             : 1;
    unsigned G2PHF5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PHF                : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned G2PHF              : 6;
    unsigned                    : 2;
    };
  } __COG2PHFbits_t;

extern __at(0x070E) volatile __COG2PHFbits_t COG2PHFbits;

#define _COG2PHF_PHF0           0x01
#define _COG2PHF_G2PHF0         0x01
#define _COG2PHF_PHF1           0x02
#define _COG2PHF_G2PHF1         0x02
#define _COG2PHF_PHF2           0x04
#define _COG2PHF_G2PHF2         0x04
#define _COG2PHF_PHF3           0x08
#define _COG2PHF_G2PHF3         0x08
#define _COG2PHF_PHF4           0x10
#define _COG2PHF_G2PHF4         0x10
#define _COG2PHF_PHF5           0x20
#define _COG2PHF_G2PHF5         0x20

//==============================================================================


//==============================================================================
//        COG2BLKR Bits

extern __at(0x070F) __sfr COG2BLKR;

typedef union
  {
  struct
    {
    unsigned BLKR0              : 1;
    unsigned BLKR1              : 1;
    unsigned BLKR2              : 1;
    unsigned BLKR3              : 1;
    unsigned BLKR4              : 1;
    unsigned BLKR5              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned G2BLKR0            : 1;
    unsigned G2BLKR1            : 1;
    unsigned G2BLKR2            : 1;
    unsigned G2BLKR3            : 1;
    unsigned G2BLKR4            : 1;
    unsigned G2BLKR5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned G2BLKR             : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned BLKR               : 6;
    unsigned                    : 2;
    };
  } __COG2BLKRbits_t;

extern __at(0x070F) volatile __COG2BLKRbits_t COG2BLKRbits;

#define _COG2BLKR_BLKR0         0x01
#define _COG2BLKR_G2BLKR0       0x01
#define _COG2BLKR_BLKR1         0x02
#define _COG2BLKR_G2BLKR1       0x02
#define _COG2BLKR_BLKR2         0x04
#define _COG2BLKR_G2BLKR2       0x04
#define _COG2BLKR_BLKR3         0x08
#define _COG2BLKR_G2BLKR3       0x08
#define _COG2BLKR_BLKR4         0x10
#define _COG2BLKR_G2BLKR4       0x10
#define _COG2BLKR_BLKR5         0x20
#define _COG2BLKR_G2BLKR5       0x20

//==============================================================================


//==============================================================================
//        COG2BLKF Bits

extern __at(0x0710) __sfr COG2BLKF;

typedef union
  {
  struct
    {
    unsigned BLKF0              : 1;
    unsigned BLKF1              : 1;
    unsigned BLKF2              : 1;
    unsigned BLKF3              : 1;
    unsigned BLKF4              : 1;
    unsigned BLKF5              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned G2BLKF0            : 1;
    unsigned G2BLKF1            : 1;
    unsigned G2BLKF2            : 1;
    unsigned G2BLKF3            : 1;
    unsigned G2BLKF4            : 1;
    unsigned G2BLKF5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned BLKF               : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned G2BLKF             : 6;
    unsigned                    : 2;
    };
  } __COG2BLKFbits_t;

extern __at(0x0710) volatile __COG2BLKFbits_t COG2BLKFbits;

#define _COG2BLKF_BLKF0         0x01
#define _COG2BLKF_G2BLKF0       0x01
#define _COG2BLKF_BLKF1         0x02
#define _COG2BLKF_G2BLKF1       0x02
#define _COG2BLKF_BLKF2         0x04
#define _COG2BLKF_G2BLKF2       0x04
#define _COG2BLKF_BLKF3         0x08
#define _COG2BLKF_G2BLKF3       0x08
#define _COG2BLKF_BLKF4         0x10
#define _COG2BLKF_G2BLKF4       0x10
#define _COG2BLKF_BLKF5         0x20
#define _COG2BLKF_G2BLKF5       0x20

//==============================================================================


//==============================================================================
//        COG2DBR Bits

extern __at(0x0711) __sfr COG2DBR;

typedef union
  {
  struct
    {
    unsigned DBR0               : 1;
    unsigned DBR1               : 1;
    unsigned DBR2               : 1;
    unsigned DBR3               : 1;
    unsigned DBR4               : 1;
    unsigned DBR5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned G2DBR0             : 1;
    unsigned G2DBR1             : 1;
    unsigned G2DBR2             : 1;
    unsigned G2DBR3             : 1;
    unsigned G2DBR4             : 1;
    unsigned G2DBR5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned G2DBR              : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned DBR                : 6;
    unsigned                    : 2;
    };
  } __COG2DBRbits_t;

extern __at(0x0711) volatile __COG2DBRbits_t COG2DBRbits;

#define _COG2DBR_DBR0           0x01
#define _COG2DBR_G2DBR0         0x01
#define _COG2DBR_DBR1           0x02
#define _COG2DBR_G2DBR1         0x02
#define _COG2DBR_DBR2           0x04
#define _COG2DBR_G2DBR2         0x04
#define _COG2DBR_DBR3           0x08
#define _COG2DBR_G2DBR3         0x08
#define _COG2DBR_DBR4           0x10
#define _COG2DBR_G2DBR4         0x10
#define _COG2DBR_DBR5           0x20
#define _COG2DBR_G2DBR5         0x20

//==============================================================================


//==============================================================================
//        COG2DBF Bits

extern __at(0x0712) __sfr COG2DBF;

typedef union
  {
  struct
    {
    unsigned DBF0               : 1;
    unsigned DBF1               : 1;
    unsigned DBF2               : 1;
    unsigned DBF3               : 1;
    unsigned DBF4               : 1;
    unsigned DBF5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned G2DBF0             : 1;
    unsigned G2DBF1             : 1;
    unsigned G2DBF2             : 1;
    unsigned G2DBF3             : 1;
    unsigned G2DBF4             : 1;
    unsigned G2DBF5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DBF                : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned G2DBF              : 6;
    unsigned                    : 2;
    };
  } __COG2DBFbits_t;

extern __at(0x0712) volatile __COG2DBFbits_t COG2DBFbits;

#define _COG2DBF_DBF0           0x01
#define _COG2DBF_G2DBF0         0x01
#define _COG2DBF_DBF1           0x02
#define _COG2DBF_G2DBF1         0x02
#define _COG2DBF_DBF2           0x04
#define _COG2DBF_G2DBF2         0x04
#define _COG2DBF_DBF3           0x08
#define _COG2DBF_G2DBF3         0x08
#define _COG2DBF_DBF4           0x10
#define _COG2DBF_G2DBF4         0x10
#define _COG2DBF_DBF5           0x20
#define _COG2DBF_G2DBF5         0x20

//==============================================================================


//==============================================================================
//        COG2CON0 Bits

extern __at(0x0713) __sfr COG2CON0;

typedef union
  {
  struct
    {
    unsigned MD0                : 1;
    unsigned MD1                : 1;
    unsigned MD2                : 1;
    unsigned CS0                : 1;
    unsigned CS1                : 1;
    unsigned                    : 1;
    unsigned LD                 : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned G2MD0              : 1;
    unsigned G2MD1              : 1;
    unsigned G2MD2              : 1;
    unsigned G2CS0              : 1;
    unsigned G2CS1              : 1;
    unsigned                    : 1;
    unsigned G2LD               : 1;
    unsigned G2EN               : 1;
    };

  struct
    {
    unsigned G2MD               : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned MD                 : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 3;
    unsigned CS                 : 2;
    unsigned                    : 3;
    };

  struct
    {
    unsigned                    : 3;
    unsigned G2CS               : 2;
    unsigned                    : 3;
    };
  } __COG2CON0bits_t;

extern __at(0x0713) volatile __COG2CON0bits_t COG2CON0bits;

#define _COG2CON0_MD0           0x01
#define _COG2CON0_G2MD0         0x01
#define _COG2CON0_MD1           0x02
#define _COG2CON0_G2MD1         0x02
#define _COG2CON0_MD2           0x04
#define _COG2CON0_G2MD2         0x04
#define _COG2CON0_CS0           0x08
#define _COG2CON0_G2CS0         0x08
#define _COG2CON0_CS1           0x10
#define _COG2CON0_G2CS1         0x10
#define _COG2CON0_LD            0x40
#define _COG2CON0_G2LD          0x40
#define _COG2CON0_EN            0x80
#define _COG2CON0_G2EN          0x80

//==============================================================================


//==============================================================================
//        COG2CON1 Bits

extern __at(0x0714) __sfr COG2CON1;

typedef union
  {
  struct
    {
    unsigned POLA               : 1;
    unsigned POLB               : 1;
    unsigned POLC               : 1;
    unsigned POLD               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned FDBS               : 1;
    unsigned RDBS               : 1;
    };

  struct
    {
    unsigned G2POLA             : 1;
    unsigned G2POLB             : 1;
    unsigned G2POLC             : 1;
    unsigned G2POLD             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned G2FDBS             : 1;
    unsigned G2RDBS             : 1;
    };
  } __COG2CON1bits_t;

extern __at(0x0714) volatile __COG2CON1bits_t COG2CON1bits;

#define _COG2CON1_POLA          0x01
#define _COG2CON1_G2POLA        0x01
#define _COG2CON1_POLB          0x02
#define _COG2CON1_G2POLB        0x02
#define _COG2CON1_POLC          0x04
#define _COG2CON1_G2POLC        0x04
#define _COG2CON1_POLD          0x08
#define _COG2CON1_G2POLD        0x08
#define _COG2CON1_FDBS          0x40
#define _COG2CON1_G2FDBS        0x40
#define _COG2CON1_RDBS          0x80
#define _COG2CON1_G2RDBS        0x80

//==============================================================================


//==============================================================================
//        COG2RIS0 Bits

extern __at(0x0715) __sfr COG2RIS0;

typedef union
  {
  struct
    {
    unsigned RIS0               : 1;
    unsigned RIS1               : 1;
    unsigned RIS2               : 1;
    unsigned RIS3               : 1;
    unsigned RIS4               : 1;
    unsigned RIS5               : 1;
    unsigned RIS6               : 1;
    unsigned RIS7               : 1;
    };

  struct
    {
    unsigned G2RIS0             : 1;
    unsigned G2RIS1             : 1;
    unsigned G2RIS2             : 1;
    unsigned G2RIS3             : 1;
    unsigned G2RIS4             : 1;
    unsigned G2RIS5             : 1;
    unsigned G2RIS6             : 1;
    unsigned G2RIS7             : 1;
    };
  } __COG2RIS0bits_t;

extern __at(0x0715) volatile __COG2RIS0bits_t COG2RIS0bits;

#define _COG2RIS0_RIS0          0x01
#define _COG2RIS0_G2RIS0        0x01
#define _COG2RIS0_RIS1          0x02
#define _COG2RIS0_G2RIS1        0x02
#define _COG2RIS0_RIS2          0x04
#define _COG2RIS0_G2RIS2        0x04
#define _COG2RIS0_RIS3          0x08
#define _COG2RIS0_G2RIS3        0x08
#define _COG2RIS0_RIS4          0x10
#define _COG2RIS0_G2RIS4        0x10
#define _COG2RIS0_RIS5          0x20
#define _COG2RIS0_G2RIS5        0x20
#define _COG2RIS0_RIS6          0x40
#define _COG2RIS0_G2RIS6        0x40
#define _COG2RIS0_RIS7          0x80
#define _COG2RIS0_G2RIS7        0x80

//==============================================================================


//==============================================================================
//        COG2RIS1 Bits

extern __at(0x0716) __sfr COG2RIS1;

typedef union
  {
  struct
    {
    unsigned RIS8               : 1;
    unsigned RIS9               : 1;
    unsigned RIS10              : 1;
    unsigned RIS11              : 1;
    unsigned RIS12              : 1;
    unsigned RIS13              : 1;
    unsigned RIS14              : 1;
    unsigned RIS15              : 1;
    };

  struct
    {
    unsigned G2RIS8             : 1;
    unsigned G2RIS9             : 1;
    unsigned G2RIS10            : 1;
    unsigned G2RIS11            : 1;
    unsigned G2RIS12            : 1;
    unsigned G2RIS13            : 1;
    unsigned G2RIS14            : 1;
    unsigned G2RIS15            : 1;
    };
  } __COG2RIS1bits_t;

extern __at(0x0716) volatile __COG2RIS1bits_t COG2RIS1bits;

#define _COG2RIS1_RIS8          0x01
#define _COG2RIS1_G2RIS8        0x01
#define _COG2RIS1_RIS9          0x02
#define _COG2RIS1_G2RIS9        0x02
#define _COG2RIS1_RIS10         0x04
#define _COG2RIS1_G2RIS10       0x04
#define _COG2RIS1_RIS11         0x08
#define _COG2RIS1_G2RIS11       0x08
#define _COG2RIS1_RIS12         0x10
#define _COG2RIS1_G2RIS12       0x10
#define _COG2RIS1_RIS13         0x20
#define _COG2RIS1_G2RIS13       0x20
#define _COG2RIS1_RIS14         0x40
#define _COG2RIS1_G2RIS14       0x40
#define _COG2RIS1_RIS15         0x80
#define _COG2RIS1_G2RIS15       0x80

//==============================================================================


//==============================================================================
//        COG2RSIM0 Bits

extern __at(0x0717) __sfr COG2RSIM0;

typedef union
  {
  struct
    {
    unsigned RSIM0              : 1;
    unsigned RSIM1              : 1;
    unsigned RSIM2              : 1;
    unsigned RSIM3              : 1;
    unsigned RSIM4              : 1;
    unsigned RSIM5              : 1;
    unsigned RSIM6              : 1;
    unsigned RSIM7              : 1;
    };

  struct
    {
    unsigned G2RSIM0            : 1;
    unsigned G2RSIM1            : 1;
    unsigned G2RSIM2            : 1;
    unsigned G2RSIM3            : 1;
    unsigned G2RSIM4            : 1;
    unsigned G2RSIM5            : 1;
    unsigned G2RSIM6            : 1;
    unsigned G2RSIM7            : 1;
    };
  } __COG2RSIM0bits_t;

extern __at(0x0717) volatile __COG2RSIM0bits_t COG2RSIM0bits;

#define _COG2RSIM0_RSIM0        0x01
#define _COG2RSIM0_G2RSIM0      0x01
#define _COG2RSIM0_RSIM1        0x02
#define _COG2RSIM0_G2RSIM1      0x02
#define _COG2RSIM0_RSIM2        0x04
#define _COG2RSIM0_G2RSIM2      0x04
#define _COG2RSIM0_RSIM3        0x08
#define _COG2RSIM0_G2RSIM3      0x08
#define _COG2RSIM0_RSIM4        0x10
#define _COG2RSIM0_G2RSIM4      0x10
#define _COG2RSIM0_RSIM5        0x20
#define _COG2RSIM0_G2RSIM5      0x20
#define _COG2RSIM0_RSIM6        0x40
#define _COG2RSIM0_G2RSIM6      0x40
#define _COG2RSIM0_RSIM7        0x80
#define _COG2RSIM0_G2RSIM7      0x80

//==============================================================================


//==============================================================================
//        COG2RSIM1 Bits

extern __at(0x0718) __sfr COG2RSIM1;

typedef union
  {
  struct
    {
    unsigned RSIM8              : 1;
    unsigned RSIM9              : 1;
    unsigned RSIM10             : 1;
    unsigned RSIM11             : 1;
    unsigned RSIM12             : 1;
    unsigned RSIM13             : 1;
    unsigned RSIM14             : 1;
    unsigned RSIM15             : 1;
    };

  struct
    {
    unsigned G2RSIM8            : 1;
    unsigned G2RSIM9            : 1;
    unsigned G2RSIM10           : 1;
    unsigned G2RSIM11           : 1;
    unsigned G2RSIM12           : 1;
    unsigned G2RSIM13           : 1;
    unsigned G2RSIM14           : 1;
    unsigned G2RSIM15           : 1;
    };
  } __COG2RSIM1bits_t;

extern __at(0x0718) volatile __COG2RSIM1bits_t COG2RSIM1bits;

#define _COG2RSIM1_RSIM8        0x01
#define _COG2RSIM1_G2RSIM8      0x01
#define _COG2RSIM1_RSIM9        0x02
#define _COG2RSIM1_G2RSIM9      0x02
#define _COG2RSIM1_RSIM10       0x04
#define _COG2RSIM1_G2RSIM10     0x04
#define _COG2RSIM1_RSIM11       0x08
#define _COG2RSIM1_G2RSIM11     0x08
#define _COG2RSIM1_RSIM12       0x10
#define _COG2RSIM1_G2RSIM12     0x10
#define _COG2RSIM1_RSIM13       0x20
#define _COG2RSIM1_G2RSIM13     0x20
#define _COG2RSIM1_RSIM14       0x40
#define _COG2RSIM1_G2RSIM14     0x40
#define _COG2RSIM1_RSIM15       0x80
#define _COG2RSIM1_G2RSIM15     0x80

//==============================================================================


//==============================================================================
//        COG2FIS0 Bits

extern __at(0x0719) __sfr COG2FIS0;

typedef union
  {
  struct
    {
    unsigned FIS0               : 1;
    unsigned FIS1               : 1;
    unsigned FIS2               : 1;
    unsigned FIS3               : 1;
    unsigned FIS4               : 1;
    unsigned FIS5               : 1;
    unsigned FIS6               : 1;
    unsigned FIS7               : 1;
    };

  struct
    {
    unsigned G2FIS0             : 1;
    unsigned G2FIS1             : 1;
    unsigned G2FIS2             : 1;
    unsigned G2FIS3             : 1;
    unsigned G2FIS4             : 1;
    unsigned G2FIS5             : 1;
    unsigned G2FIS6             : 1;
    unsigned G2FIS7             : 1;
    };
  } __COG2FIS0bits_t;

extern __at(0x0719) volatile __COG2FIS0bits_t COG2FIS0bits;

#define _COG2FIS0_FIS0          0x01
#define _COG2FIS0_G2FIS0        0x01
#define _COG2FIS0_FIS1          0x02
#define _COG2FIS0_G2FIS1        0x02
#define _COG2FIS0_FIS2          0x04
#define _COG2FIS0_G2FIS2        0x04
#define _COG2FIS0_FIS3          0x08
#define _COG2FIS0_G2FIS3        0x08
#define _COG2FIS0_FIS4          0x10
#define _COG2FIS0_G2FIS4        0x10
#define _COG2FIS0_FIS5          0x20
#define _COG2FIS0_G2FIS5        0x20
#define _COG2FIS0_FIS6          0x40
#define _COG2FIS0_G2FIS6        0x40
#define _COG2FIS0_FIS7          0x80
#define _COG2FIS0_G2FIS7        0x80

//==============================================================================


//==============================================================================
//        COG2FIS1 Bits

extern __at(0x071A) __sfr COG2FIS1;

typedef union
  {
  struct
    {
    unsigned FIS8               : 1;
    unsigned FIS9               : 1;
    unsigned FIS10              : 1;
    unsigned FIS11              : 1;
    unsigned FIS12              : 1;
    unsigned FIS13              : 1;
    unsigned FIS14              : 1;
    unsigned FIS15              : 1;
    };

  struct
    {
    unsigned G2FIS8             : 1;
    unsigned G2FIS9             : 1;
    unsigned G2FIS10            : 1;
    unsigned G2FIS11            : 1;
    unsigned G2FIS12            : 1;
    unsigned G2FIS13            : 1;
    unsigned G2FIS14            : 1;
    unsigned G2FIS15            : 1;
    };
  } __COG2FIS1bits_t;

extern __at(0x071A) volatile __COG2FIS1bits_t COG2FIS1bits;

#define _COG2FIS1_FIS8          0x01
#define _COG2FIS1_G2FIS8        0x01
#define _COG2FIS1_FIS9          0x02
#define _COG2FIS1_G2FIS9        0x02
#define _COG2FIS1_FIS10         0x04
#define _COG2FIS1_G2FIS10       0x04
#define _COG2FIS1_FIS11         0x08
#define _COG2FIS1_G2FIS11       0x08
#define _COG2FIS1_FIS12         0x10
#define _COG2FIS1_G2FIS12       0x10
#define _COG2FIS1_FIS13         0x20
#define _COG2FIS1_G2FIS13       0x20
#define _COG2FIS1_FIS14         0x40
#define _COG2FIS1_G2FIS14       0x40
#define _COG2FIS1_FIS15         0x80
#define _COG2FIS1_G2FIS15       0x80

//==============================================================================


//==============================================================================
//        COG2FSIM0 Bits

extern __at(0x071B) __sfr COG2FSIM0;

typedef union
  {
  struct
    {
    unsigned FSIM0              : 1;
    unsigned FSIM1              : 1;
    unsigned FSIM2              : 1;
    unsigned FSIM3              : 1;
    unsigned FSIM4              : 1;
    unsigned FSIM5              : 1;
    unsigned FSIM6              : 1;
    unsigned FSIM7              : 1;
    };

  struct
    {
    unsigned G2FSIM0            : 1;
    unsigned G2FSIM1            : 1;
    unsigned G2FSIM2            : 1;
    unsigned G2FSIM3            : 1;
    unsigned G2FSIM4            : 1;
    unsigned G2FSIM5            : 1;
    unsigned G2FSIM6            : 1;
    unsigned G2FSIM7            : 1;
    };
  } __COG2FSIM0bits_t;

extern __at(0x071B) volatile __COG2FSIM0bits_t COG2FSIM0bits;

#define _COG2FSIM0_FSIM0        0x01
#define _COG2FSIM0_G2FSIM0      0x01
#define _COG2FSIM0_FSIM1        0x02
#define _COG2FSIM0_G2FSIM1      0x02
#define _COG2FSIM0_FSIM2        0x04
#define _COG2FSIM0_G2FSIM2      0x04
#define _COG2FSIM0_FSIM3        0x08
#define _COG2FSIM0_G2FSIM3      0x08
#define _COG2FSIM0_FSIM4        0x10
#define _COG2FSIM0_G2FSIM4      0x10
#define _COG2FSIM0_FSIM5        0x20
#define _COG2FSIM0_G2FSIM5      0x20
#define _COG2FSIM0_FSIM6        0x40
#define _COG2FSIM0_G2FSIM6      0x40
#define _COG2FSIM0_FSIM7        0x80
#define _COG2FSIM0_G2FSIM7      0x80

//==============================================================================


//==============================================================================
//        COG2FSIM1 Bits

extern __at(0x071C) __sfr COG2FSIM1;

typedef union
  {
  struct
    {
    unsigned FSIM8              : 1;
    unsigned FSIM9              : 1;
    unsigned FSIM10             : 1;
    unsigned FSIM11             : 1;
    unsigned FSIM12             : 1;
    unsigned FSIM13             : 1;
    unsigned FSIM14             : 1;
    unsigned FSIM15             : 1;
    };

  struct
    {
    unsigned G2FSIM8            : 1;
    unsigned G2FSIM9            : 1;
    unsigned G2FSIM10           : 1;
    unsigned G2FSIM11           : 1;
    unsigned G2FSIM12           : 1;
    unsigned G2FSIM13           : 1;
    unsigned G2FSIM14           : 1;
    unsigned G2FSIM15           : 1;
    };
  } __COG2FSIM1bits_t;

extern __at(0x071C) volatile __COG2FSIM1bits_t COG2FSIM1bits;

#define _COG2FSIM1_FSIM8        0x01
#define _COG2FSIM1_G2FSIM8      0x01
#define _COG2FSIM1_FSIM9        0x02
#define _COG2FSIM1_G2FSIM9      0x02
#define _COG2FSIM1_FSIM10       0x04
#define _COG2FSIM1_G2FSIM10     0x04
#define _COG2FSIM1_FSIM11       0x08
#define _COG2FSIM1_G2FSIM11     0x08
#define _COG2FSIM1_FSIM12       0x10
#define _COG2FSIM1_G2FSIM12     0x10
#define _COG2FSIM1_FSIM13       0x20
#define _COG2FSIM1_G2FSIM13     0x20
#define _COG2FSIM1_FSIM14       0x40
#define _COG2FSIM1_G2FSIM14     0x40
#define _COG2FSIM1_FSIM15       0x80
#define _COG2FSIM1_G2FSIM15     0x80

//==============================================================================


//==============================================================================
//        COG2ASD0 Bits

extern __at(0x071D) __sfr COG2ASD0;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ASDAC0             : 1;
    unsigned ASDAC1             : 1;
    unsigned ASDBD0             : 1;
    unsigned ASDBD1             : 1;
    unsigned ASREN              : 1;
    unsigned ASE                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned G2ASDAC0           : 1;
    unsigned G2ASDAC1           : 1;
    unsigned G2ASDBD0           : 1;
    unsigned G2ASDBD1           : 1;
    unsigned ARSEN              : 1;
    unsigned G2ASE              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned G2ARSEN            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned G2ASREN            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned G2ASDAC            : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 2;
    unsigned ASDAC              : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned G2ASDBD            : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 4;
    unsigned ASDBD              : 2;
    unsigned                    : 2;
    };
  } __COG2ASD0bits_t;

extern __at(0x071D) volatile __COG2ASD0bits_t COG2ASD0bits;

#define _COG2ASD0_ASDAC0        0x04
#define _COG2ASD0_G2ASDAC0      0x04
#define _COG2ASD0_ASDAC1        0x08
#define _COG2ASD0_G2ASDAC1      0x08
#define _COG2ASD0_ASDBD0        0x10
#define _COG2ASD0_G2ASDBD0      0x10
#define _COG2ASD0_ASDBD1        0x20
#define _COG2ASD0_G2ASDBD1      0x20
#define _COG2ASD0_ASREN         0x40
#define _COG2ASD0_ARSEN         0x40
#define _COG2ASD0_G2ARSEN       0x40
#define _COG2ASD0_G2ASREN       0x40
#define _COG2ASD0_ASE           0x80
#define _COG2ASD0_G2ASE         0x80

//==============================================================================


//==============================================================================
//        COG2ASD1 Bits

extern __at(0x071E) __sfr COG2ASD1;

typedef union
  {
  struct
    {
    unsigned AS0E               : 1;
    unsigned AS1E               : 1;
    unsigned AS2E               : 1;
    unsigned AS3E               : 1;
    unsigned AS4E               : 1;
    unsigned AS5E               : 1;
    unsigned AS6E               : 1;
    unsigned AS7E               : 1;
    };

  struct
    {
    unsigned G2AS0E             : 1;
    unsigned G2AS1E             : 1;
    unsigned G2AS2E             : 1;
    unsigned G2AS3E             : 1;
    unsigned G2AS4E             : 1;
    unsigned G2AS5E             : 1;
    unsigned G2AS6E             : 1;
    unsigned G2AS7E             : 1;
    };
  } __COG2ASD1bits_t;

extern __at(0x071E) volatile __COG2ASD1bits_t COG2ASD1bits;

#define _COG2ASD1_AS0E          0x01
#define _COG2ASD1_G2AS0E        0x01
#define _COG2ASD1_AS1E          0x02
#define _COG2ASD1_G2AS1E        0x02
#define _COG2ASD1_AS2E          0x04
#define _COG2ASD1_G2AS2E        0x04
#define _COG2ASD1_AS3E          0x08
#define _COG2ASD1_G2AS3E        0x08
#define _COG2ASD1_AS4E          0x10
#define _COG2ASD1_G2AS4E        0x10
#define _COG2ASD1_AS5E          0x20
#define _COG2ASD1_G2AS5E        0x20
#define _COG2ASD1_AS6E          0x40
#define _COG2ASD1_G2AS6E        0x40
#define _COG2ASD1_AS7E          0x80
#define _COG2ASD1_G2AS7E        0x80

//==============================================================================


//==============================================================================
//        COG2STR Bits

extern __at(0x071F) __sfr COG2STR;

typedef union
  {
  struct
    {
    unsigned STRA               : 1;
    unsigned STRB               : 1;
    unsigned STRC               : 1;
    unsigned STRD               : 1;
    unsigned SDATA              : 1;
    unsigned SDATB              : 1;
    unsigned SDATC              : 1;
    unsigned SDATD              : 1;
    };

  struct
    {
    unsigned G2STRA             : 1;
    unsigned G2STRB             : 1;
    unsigned G2STRC             : 1;
    unsigned G2STRD             : 1;
    unsigned G2SDATA            : 1;
    unsigned G2SDATB            : 1;
    unsigned G2SDATC            : 1;
    unsigned G2SDATD            : 1;
    };
  } __COG2STRbits_t;

extern __at(0x071F) volatile __COG2STRbits_t COG2STRbits;

#define _COG2STR_STRA           0x01
#define _COG2STR_G2STRA         0x01
#define _COG2STR_STRB           0x02
#define _COG2STR_G2STRB         0x02
#define _COG2STR_STRC           0x04
#define _COG2STR_G2STRC         0x04
#define _COG2STR_STRD           0x08
#define _COG2STR_G2STRD         0x08
#define _COG2STR_SDATA          0x10
#define _COG2STR_G2SDATA        0x10
#define _COG2STR_SDATB          0x20
#define _COG2STR_G2SDATB        0x20
#define _COG2STR_SDATC          0x40
#define _COG2STR_G2SDATC        0x40
#define _COG2STR_SDATD          0x80
#define _COG2STR_G2SDATD        0x80

//==============================================================================


//==============================================================================
//        PRG1RTSS Bits

extern __at(0x078E) __sfr PRG1RTSS;

typedef union
  {
  struct
    {
    unsigned RTSS0              : 1;
    unsigned RTSS1              : 1;
    unsigned RTSS2              : 1;
    unsigned RTSS3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RG1RTSS0           : 1;
    unsigned RG1RTSS1           : 1;
    unsigned RG1RTSS2           : 1;
    unsigned RG1RTSS3           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RTSS               : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned RG1RTSS            : 4;
    unsigned                    : 4;
    };
  } __PRG1RTSSbits_t;

extern __at(0x078E) volatile __PRG1RTSSbits_t PRG1RTSSbits;

#define _RTSS0                  0x01
#define _RG1RTSS0               0x01
#define _RTSS1                  0x02
#define _RG1RTSS1               0x02
#define _RTSS2                  0x04
#define _RG1RTSS2               0x04
#define _RTSS3                  0x08
#define _RG1RTSS3               0x08

//==============================================================================


//==============================================================================
//        PRG1FTSS Bits

extern __at(0x078F) __sfr PRG1FTSS;

typedef union
  {
  struct
    {
    unsigned FTSS0              : 1;
    unsigned FTSS1              : 1;
    unsigned FTSS2              : 1;
    unsigned FTSS3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RG1FTSS0           : 1;
    unsigned RG1FTSS1           : 1;
    unsigned RG1FTSS2           : 1;
    unsigned RG1FTSS3           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned FTSS               : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned RG1FTSS            : 4;
    unsigned                    : 4;
    };
  } __PRG1FTSSbits_t;

extern __at(0x078F) volatile __PRG1FTSSbits_t PRG1FTSSbits;

#define _FTSS0                  0x01
#define _RG1FTSS0               0x01
#define _FTSS1                  0x02
#define _RG1FTSS1               0x02
#define _FTSS2                  0x04
#define _RG1FTSS2               0x04
#define _FTSS3                  0x08
#define _RG1FTSS3               0x08

//==============================================================================


//==============================================================================
//        PRG1INS Bits

extern __at(0x0790) __sfr PRG1INS;

typedef union
  {
  struct
    {
    unsigned INS0               : 1;
    unsigned INS1               : 1;
    unsigned INS2               : 1;
    unsigned INS3               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RG1INS0            : 1;
    unsigned RG1INS1            : 1;
    unsigned RG1INS2            : 1;
    unsigned RG1INS3            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned INS                : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned RG1INS             : 4;
    unsigned                    : 4;
    };
  } __PRG1INSbits_t;

extern __at(0x0790) volatile __PRG1INSbits_t PRG1INSbits;

#define _INS0                   0x01
#define _RG1INS0                0x01
#define _INS1                   0x02
#define _RG1INS1                0x02
#define _INS2                   0x04
#define _RG1INS2                0x04
#define _INS3                   0x08
#define _RG1INS3                0x08

//==============================================================================


//==============================================================================
//        PRG1CON0 Bits

extern __at(0x0791) __sfr PRG1CON0;

typedef union
  {
  struct
    {
    unsigned GO                 : 1;
    unsigned OS                 : 1;
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned REDG               : 1;
    unsigned FEDG               : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned RG1GO              : 1;
    unsigned RG1OS              : 1;
    unsigned RG1MODE0           : 1;
    unsigned RG1MODE1           : 1;
    unsigned RG1REDG            : 1;
    unsigned RG1FEDG            : 1;
    unsigned                    : 1;
    unsigned RG1EN              : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned RG1MODE            : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 2;
    unsigned MODE               : 2;
    unsigned                    : 4;
    };
  } __PRG1CON0bits_t;

extern __at(0x0791) volatile __PRG1CON0bits_t PRG1CON0bits;

#define _PRG1CON0_GO            0x01
#define _PRG1CON0_RG1GO         0x01
#define _PRG1CON0_OS            0x02
#define _PRG1CON0_RG1OS         0x02
#define _PRG1CON0_MODE0         0x04
#define _PRG1CON0_RG1MODE0      0x04
#define _PRG1CON0_MODE1         0x08
#define _PRG1CON0_RG1MODE1      0x08
#define _PRG1CON0_REDG          0x10
#define _PRG1CON0_RG1REDG       0x10
#define _PRG1CON0_FEDG          0x20
#define _PRG1CON0_RG1FEDG       0x20
#define _PRG1CON0_EN            0x80
#define _PRG1CON0_RG1EN         0x80

//==============================================================================


//==============================================================================
//        PRG1CON1 Bits

extern __at(0x0792) __sfr PRG1CON1;

typedef union
  {
  struct
    {
    unsigned RPOL               : 1;
    unsigned FPOL               : 1;
    unsigned RDY                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RG1RPOL            : 1;
    unsigned RG1FPOL            : 1;
    unsigned RG1RDY             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PRG1CON1bits_t;

extern __at(0x0792) volatile __PRG1CON1bits_t PRG1CON1bits;

#define _RPOL                   0x01
#define _RG1RPOL                0x01
#define _FPOL                   0x02
#define _RG1FPOL                0x02
#define _RDY                    0x04
#define _RG1RDY                 0x04

//==============================================================================


//==============================================================================
//        PRG1CON2 Bits

extern __at(0x0793) __sfr PRG1CON2;

typedef union
  {
  struct
    {
    unsigned ISET0              : 1;
    unsigned ISET1              : 1;
    unsigned ISET2              : 1;
    unsigned ISET3              : 1;
    unsigned ISET4              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RG1ISET0           : 1;
    unsigned RG1ISET1           : 1;
    unsigned RG1ISET2           : 1;
    unsigned RG1ISET3           : 1;
    unsigned RG1ISET4           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RG1ISET            : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned ISET               : 5;
    unsigned                    : 3;
    };
  } __PRG1CON2bits_t;

extern __at(0x0793) volatile __PRG1CON2bits_t PRG1CON2bits;

#define _ISET0                  0x01
#define _RG1ISET0               0x01
#define _ISET1                  0x02
#define _RG1ISET1               0x02
#define _ISET2                  0x04
#define _RG1ISET2               0x04
#define _ISET3                  0x08
#define _RG1ISET3               0x08
#define _ISET4                  0x10
#define _RG1ISET4               0x10

//==============================================================================


//==============================================================================
//        PRG2RTSS Bits

extern __at(0x0794) __sfr PRG2RTSS;

typedef union
  {
  struct
    {
    unsigned RTSS0              : 1;
    unsigned RTSS1              : 1;
    unsigned RTSS2              : 1;
    unsigned RTSS3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RG2RTSS0           : 1;
    unsigned RG2RTSS1           : 1;
    unsigned RG2RTSS2           : 1;
    unsigned RG2RTSS3           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RG2RTSS            : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned RTSS               : 4;
    unsigned                    : 4;
    };
  } __PRG2RTSSbits_t;

extern __at(0x0794) volatile __PRG2RTSSbits_t PRG2RTSSbits;

#define _PRG2RTSS_RTSS0         0x01
#define _PRG2RTSS_RG2RTSS0      0x01
#define _PRG2RTSS_RTSS1         0x02
#define _PRG2RTSS_RG2RTSS1      0x02
#define _PRG2RTSS_RTSS2         0x04
#define _PRG2RTSS_RG2RTSS2      0x04
#define _PRG2RTSS_RTSS3         0x08
#define _PRG2RTSS_RG2RTSS3      0x08

//==============================================================================


//==============================================================================
//        PRG2FTSS Bits

extern __at(0x0795) __sfr PRG2FTSS;

typedef union
  {
  struct
    {
    unsigned FTSS0              : 1;
    unsigned FTSS1              : 1;
    unsigned FTSS2              : 1;
    unsigned FTSS3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RG2FTSS0           : 1;
    unsigned RG2FTSS1           : 1;
    unsigned RG2FTSS2           : 1;
    unsigned RG2FTSS3           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned FTSS               : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned RG2FTSS            : 4;
    unsigned                    : 4;
    };
  } __PRG2FTSSbits_t;

extern __at(0x0795) volatile __PRG2FTSSbits_t PRG2FTSSbits;

#define _PRG2FTSS_FTSS0         0x01
#define _PRG2FTSS_RG2FTSS0      0x01
#define _PRG2FTSS_FTSS1         0x02
#define _PRG2FTSS_RG2FTSS1      0x02
#define _PRG2FTSS_FTSS2         0x04
#define _PRG2FTSS_RG2FTSS2      0x04
#define _PRG2FTSS_FTSS3         0x08
#define _PRG2FTSS_RG2FTSS3      0x08

//==============================================================================


//==============================================================================
//        PRG2INS Bits

extern __at(0x0796) __sfr PRG2INS;

typedef union
  {
  struct
    {
    unsigned INS0               : 1;
    unsigned INS1               : 1;
    unsigned INS2               : 1;
    unsigned INS3               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RG2INS0            : 1;
    unsigned RG2INS1            : 1;
    unsigned RG2INS2            : 1;
    unsigned RG2INS3            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RG2INS             : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned INS                : 4;
    unsigned                    : 4;
    };
  } __PRG2INSbits_t;

extern __at(0x0796) volatile __PRG2INSbits_t PRG2INSbits;

#define _PRG2INS_INS0           0x01
#define _PRG2INS_RG2INS0        0x01
#define _PRG2INS_INS1           0x02
#define _PRG2INS_RG2INS1        0x02
#define _PRG2INS_INS2           0x04
#define _PRG2INS_RG2INS2        0x04
#define _PRG2INS_INS3           0x08
#define _PRG2INS_RG2INS3        0x08

//==============================================================================


//==============================================================================
//        PRG2CON0 Bits

extern __at(0x0797) __sfr PRG2CON0;

typedef union
  {
  struct
    {
    unsigned GO                 : 1;
    unsigned OS                 : 1;
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned REDG               : 1;
    unsigned FEDG               : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned RG2GO              : 1;
    unsigned RG2OS              : 1;
    unsigned RG2MODE0           : 1;
    unsigned RG2MODE1           : 1;
    unsigned RG2REDG            : 1;
    unsigned RG2FEDG            : 1;
    unsigned                    : 1;
    unsigned RG2EN              : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned RG2MODE            : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 2;
    unsigned MODE               : 2;
    unsigned                    : 4;
    };
  } __PRG2CON0bits_t;

extern __at(0x0797) volatile __PRG2CON0bits_t PRG2CON0bits;

#define _PRG2CON0_GO            0x01
#define _PRG2CON0_RG2GO         0x01
#define _PRG2CON0_OS            0x02
#define _PRG2CON0_RG2OS         0x02
#define _PRG2CON0_MODE0         0x04
#define _PRG2CON0_RG2MODE0      0x04
#define _PRG2CON0_MODE1         0x08
#define _PRG2CON0_RG2MODE1      0x08
#define _PRG2CON0_REDG          0x10
#define _PRG2CON0_RG2REDG       0x10
#define _PRG2CON0_FEDG          0x20
#define _PRG2CON0_RG2FEDG       0x20
#define _PRG2CON0_EN            0x80
#define _PRG2CON0_RG2EN         0x80

//==============================================================================


//==============================================================================
//        PRG2CON1 Bits

extern __at(0x0798) __sfr PRG2CON1;

typedef union
  {
  struct
    {
    unsigned RPOL               : 1;
    unsigned FPOL               : 1;
    unsigned RDY                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RG2RPOL            : 1;
    unsigned RG2FPOL            : 1;
    unsigned RG2RDY             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PRG2CON1bits_t;

extern __at(0x0798) volatile __PRG2CON1bits_t PRG2CON1bits;

#define _PRG2CON1_RPOL          0x01
#define _PRG2CON1_RG2RPOL       0x01
#define _PRG2CON1_FPOL          0x02
#define _PRG2CON1_RG2FPOL       0x02
#define _PRG2CON1_RDY           0x04
#define _PRG2CON1_RG2RDY        0x04

//==============================================================================


//==============================================================================
//        PRG2CON2 Bits

extern __at(0x0799) __sfr PRG2CON2;

typedef union
  {
  struct
    {
    unsigned ISET0              : 1;
    unsigned ISET1              : 1;
    unsigned ISET2              : 1;
    unsigned ISET3              : 1;
    unsigned ISET4              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RG2ISET0           : 1;
    unsigned RG2ISET1           : 1;
    unsigned RG2ISET2           : 1;
    unsigned RG2ISET3           : 1;
    unsigned RG2ISET4           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ISET               : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned RG2ISET            : 5;
    unsigned                    : 3;
    };
  } __PRG2CON2bits_t;

extern __at(0x0799) volatile __PRG2CON2bits_t PRG2CON2bits;

#define _PRG2CON2_ISET0         0x01
#define _PRG2CON2_RG2ISET0      0x01
#define _PRG2CON2_ISET1         0x02
#define _PRG2CON2_RG2ISET1      0x02
#define _PRG2CON2_ISET2         0x04
#define _PRG2CON2_RG2ISET2      0x04
#define _PRG2CON2_ISET3         0x08
#define _PRG2CON2_RG2ISET3      0x08
#define _PRG2CON2_ISET4         0x10
#define _PRG2CON2_RG2ISET4      0x10

//==============================================================================


//==============================================================================
//        PRG3RTSS Bits

extern __at(0x079A) __sfr PRG3RTSS;

typedef union
  {
  struct
    {
    unsigned RTSS0              : 1;
    unsigned RTSS1              : 1;
    unsigned RTSS2              : 1;
    unsigned RTSS3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RG3RTSS0           : 1;
    unsigned RG3RTSS1           : 1;
    unsigned RG3RTSS2           : 1;
    unsigned RG3RTSS3           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RG3RTSS            : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned RTSS               : 4;
    unsigned                    : 4;
    };
  } __PRG3RTSSbits_t;

extern __at(0x079A) volatile __PRG3RTSSbits_t PRG3RTSSbits;

#define _PRG3RTSS_RTSS0         0x01
#define _PRG3RTSS_RG3RTSS0      0x01
#define _PRG3RTSS_RTSS1         0x02
#define _PRG3RTSS_RG3RTSS1      0x02
#define _PRG3RTSS_RTSS2         0x04
#define _PRG3RTSS_RG3RTSS2      0x04
#define _PRG3RTSS_RTSS3         0x08
#define _PRG3RTSS_RG3RTSS3      0x08

//==============================================================================


//==============================================================================
//        PRG3FTSS Bits

extern __at(0x079B) __sfr PRG3FTSS;

typedef union
  {
  struct
    {
    unsigned FTSS0              : 1;
    unsigned FTSS1              : 1;
    unsigned FTSS2              : 1;
    unsigned FTSS3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RG3FTSS0           : 1;
    unsigned RG3FTSS1           : 1;
    unsigned RG3FTSS2           : 1;
    unsigned RG3FTSS3           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RG3FTSS            : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned FTSS               : 4;
    unsigned                    : 4;
    };
  } __PRG3FTSSbits_t;

extern __at(0x079B) volatile __PRG3FTSSbits_t PRG3FTSSbits;

#define _PRG3FTSS_FTSS0         0x01
#define _PRG3FTSS_RG3FTSS0      0x01
#define _PRG3FTSS_FTSS1         0x02
#define _PRG3FTSS_RG3FTSS1      0x02
#define _PRG3FTSS_FTSS2         0x04
#define _PRG3FTSS_RG3FTSS2      0x04
#define _PRG3FTSS_FTSS3         0x08
#define _PRG3FTSS_RG3FTSS3      0x08

//==============================================================================


//==============================================================================
//        PRG3INS Bits

extern __at(0x079C) __sfr PRG3INS;

typedef union
  {
  struct
    {
    unsigned INS0               : 1;
    unsigned INS1               : 1;
    unsigned INS2               : 1;
    unsigned INS3               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RG3INS0            : 1;
    unsigned RG3INS1            : 1;
    unsigned RG3INS2            : 1;
    unsigned RG3INS3            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RG3INS             : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned INS                : 4;
    unsigned                    : 4;
    };
  } __PRG3INSbits_t;

extern __at(0x079C) volatile __PRG3INSbits_t PRG3INSbits;

#define _PRG3INS_INS0           0x01
#define _PRG3INS_RG3INS0        0x01
#define _PRG3INS_INS1           0x02
#define _PRG3INS_RG3INS1        0x02
#define _PRG3INS_INS2           0x04
#define _PRG3INS_RG3INS2        0x04
#define _PRG3INS_INS3           0x08
#define _PRG3INS_RG3INS3        0x08

//==============================================================================


//==============================================================================
//        PRG3CON0 Bits

extern __at(0x079D) __sfr PRG3CON0;

typedef union
  {
  struct
    {
    unsigned GO                 : 1;
    unsigned OS                 : 1;
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned REDG               : 1;
    unsigned FEDG               : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned RG3GO              : 1;
    unsigned RG3OS              : 1;
    unsigned RG3MODE0           : 1;
    unsigned RG3MODE1           : 1;
    unsigned RG3REDG            : 1;
    unsigned RG3FEDG            : 1;
    unsigned                    : 1;
    unsigned RG3EN              : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned RG3MODE            : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 2;
    unsigned MODE               : 2;
    unsigned                    : 4;
    };
  } __PRG3CON0bits_t;

extern __at(0x079D) volatile __PRG3CON0bits_t PRG3CON0bits;

#define _PRG3CON0_GO            0x01
#define _PRG3CON0_RG3GO         0x01
#define _PRG3CON0_OS            0x02
#define _PRG3CON0_RG3OS         0x02
#define _PRG3CON0_MODE0         0x04
#define _PRG3CON0_RG3MODE0      0x04
#define _PRG3CON0_MODE1         0x08
#define _PRG3CON0_RG3MODE1      0x08
#define _PRG3CON0_REDG          0x10
#define _PRG3CON0_RG3REDG       0x10
#define _PRG3CON0_FEDG          0x20
#define _PRG3CON0_RG3FEDG       0x20
#define _PRG3CON0_EN            0x80
#define _PRG3CON0_RG3EN         0x80

//==============================================================================


//==============================================================================
//        PRG3CON1 Bits

extern __at(0x079E) __sfr PRG3CON1;

typedef union
  {
  struct
    {
    unsigned RPOL               : 1;
    unsigned FPOL               : 1;
    unsigned RDY                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RG3RPOL            : 1;
    unsigned RG3FPOL            : 1;
    unsigned RG3RDY             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PRG3CON1bits_t;

extern __at(0x079E) volatile __PRG3CON1bits_t PRG3CON1bits;

#define _PRG3CON1_RPOL          0x01
#define _PRG3CON1_RG3RPOL       0x01
#define _PRG3CON1_FPOL          0x02
#define _PRG3CON1_RG3FPOL       0x02
#define _PRG3CON1_RDY           0x04
#define _PRG3CON1_RG3RDY        0x04

//==============================================================================


//==============================================================================
//        PRG3CON2 Bits

extern __at(0x079F) __sfr PRG3CON2;

typedef union
  {
  struct
    {
    unsigned ISET0              : 1;
    unsigned ISET1              : 1;
    unsigned ISET2              : 1;
    unsigned ISET3              : 1;
    unsigned ISET4              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RG3ISET0           : 1;
    unsigned RG3ISET1           : 1;
    unsigned RG3ISET2           : 1;
    unsigned RG3ISET3           : 1;
    unsigned RG3ISET4           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RG3ISET            : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned ISET               : 5;
    unsigned                    : 3;
    };
  } __PRG3CON2bits_t;

extern __at(0x079F) volatile __PRG3CON2bits_t PRG3CON2bits;

#define _PRG3CON2_ISET0         0x01
#define _PRG3CON2_RG3ISET0      0x01
#define _PRG3CON2_ISET1         0x02
#define _PRG3CON2_RG3ISET1      0x02
#define _PRG3CON2_ISET2         0x04
#define _PRG3CON2_RG3ISET2      0x04
#define _PRG3CON2_ISET3         0x08
#define _PRG3CON2_RG3ISET3      0x08
#define _PRG3CON2_ISET4         0x10
#define _PRG3CON2_RG3ISET4      0x10

//==============================================================================


//==============================================================================
//        COG3PHR Bits

extern __at(0x080D) __sfr COG3PHR;

typedef union
  {
  struct
    {
    unsigned PHR0               : 1;
    unsigned PHR1               : 1;
    unsigned PHR2               : 1;
    unsigned PHR3               : 1;
    unsigned PHR4               : 1;
    unsigned PHR5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned G3PHR0             : 1;
    unsigned G3PHR1             : 1;
    unsigned G3PHR2             : 1;
    unsigned G3PHR3             : 1;
    unsigned G3PHR4             : 1;
    unsigned G3PHR5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PHR                : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned G3PHR              : 6;
    unsigned                    : 2;
    };
  } __COG3PHRbits_t;

extern __at(0x080D) volatile __COG3PHRbits_t COG3PHRbits;

#define _COG3PHR_PHR0           0x01
#define _COG3PHR_G3PHR0         0x01
#define _COG3PHR_PHR1           0x02
#define _COG3PHR_G3PHR1         0x02
#define _COG3PHR_PHR2           0x04
#define _COG3PHR_G3PHR2         0x04
#define _COG3PHR_PHR3           0x08
#define _COG3PHR_G3PHR3         0x08
#define _COG3PHR_PHR4           0x10
#define _COG3PHR_G3PHR4         0x10
#define _COG3PHR_PHR5           0x20
#define _COG3PHR_G3PHR5         0x20

//==============================================================================


//==============================================================================
//        COG3PHF Bits

extern __at(0x080E) __sfr COG3PHF;

typedef union
  {
  struct
    {
    unsigned PHF0               : 1;
    unsigned PHF1               : 1;
    unsigned PHF2               : 1;
    unsigned PHF3               : 1;
    unsigned PHF4               : 1;
    unsigned PHF5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned G3PHF0             : 1;
    unsigned G3PHF1             : 1;
    unsigned G3PHF2             : 1;
    unsigned G3PHF3             : 1;
    unsigned G3PHF4             : 1;
    unsigned G3PHF5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PHF                : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned G3PHF              : 6;
    unsigned                    : 2;
    };
  } __COG3PHFbits_t;

extern __at(0x080E) volatile __COG3PHFbits_t COG3PHFbits;

#define _COG3PHF_PHF0           0x01
#define _COG3PHF_G3PHF0         0x01
#define _COG3PHF_PHF1           0x02
#define _COG3PHF_G3PHF1         0x02
#define _COG3PHF_PHF2           0x04
#define _COG3PHF_G3PHF2         0x04
#define _COG3PHF_PHF3           0x08
#define _COG3PHF_G3PHF3         0x08
#define _COG3PHF_PHF4           0x10
#define _COG3PHF_G3PHF4         0x10
#define _COG3PHF_PHF5           0x20
#define _COG3PHF_G3PHF5         0x20

//==============================================================================


//==============================================================================
//        COG3BLKR Bits

extern __at(0x080F) __sfr COG3BLKR;

typedef union
  {
  struct
    {
    unsigned BLKR0              : 1;
    unsigned BLKR1              : 1;
    unsigned BLKR2              : 1;
    unsigned BLKR3              : 1;
    unsigned BLKR4              : 1;
    unsigned BLKR5              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned G3BLKR0            : 1;
    unsigned G3BLKR1            : 1;
    unsigned G3BLKR2            : 1;
    unsigned G3BLKR3            : 1;
    unsigned G3BLKR4            : 1;
    unsigned G3BLKR5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned G3BLKR             : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned BLKR               : 6;
    unsigned                    : 2;
    };
  } __COG3BLKRbits_t;

extern __at(0x080F) volatile __COG3BLKRbits_t COG3BLKRbits;

#define _COG3BLKR_BLKR0         0x01
#define _COG3BLKR_G3BLKR0       0x01
#define _COG3BLKR_BLKR1         0x02
#define _COG3BLKR_G3BLKR1       0x02
#define _COG3BLKR_BLKR2         0x04
#define _COG3BLKR_G3BLKR2       0x04
#define _COG3BLKR_BLKR3         0x08
#define _COG3BLKR_G3BLKR3       0x08
#define _COG3BLKR_BLKR4         0x10
#define _COG3BLKR_G3BLKR4       0x10
#define _COG3BLKR_BLKR5         0x20
#define _COG3BLKR_G3BLKR5       0x20

//==============================================================================


//==============================================================================
//        COG3BLKF Bits

extern __at(0x0810) __sfr COG3BLKF;

typedef union
  {
  struct
    {
    unsigned BLKF0              : 1;
    unsigned BLKF1              : 1;
    unsigned BLKF2              : 1;
    unsigned BLKF3              : 1;
    unsigned BLKF4              : 1;
    unsigned BLKF5              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned G3BLKF0            : 1;
    unsigned G3BLKF1            : 1;
    unsigned G3BLKF2            : 1;
    unsigned G3BLKF3            : 1;
    unsigned G3BLKF4            : 1;
    unsigned G3BLKF5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned BLKF               : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned G3BLKF             : 6;
    unsigned                    : 2;
    };
  } __COG3BLKFbits_t;

extern __at(0x0810) volatile __COG3BLKFbits_t COG3BLKFbits;

#define _COG3BLKF_BLKF0         0x01
#define _COG3BLKF_G3BLKF0       0x01
#define _COG3BLKF_BLKF1         0x02
#define _COG3BLKF_G3BLKF1       0x02
#define _COG3BLKF_BLKF2         0x04
#define _COG3BLKF_G3BLKF2       0x04
#define _COG3BLKF_BLKF3         0x08
#define _COG3BLKF_G3BLKF3       0x08
#define _COG3BLKF_BLKF4         0x10
#define _COG3BLKF_G3BLKF4       0x10
#define _COG3BLKF_BLKF5         0x20
#define _COG3BLKF_G3BLKF5       0x20

//==============================================================================


//==============================================================================
//        COG3DBR Bits

extern __at(0x0811) __sfr COG3DBR;

typedef union
  {
  struct
    {
    unsigned DBR0               : 1;
    unsigned DBR1               : 1;
    unsigned DBR2               : 1;
    unsigned DBR3               : 1;
    unsigned DBR4               : 1;
    unsigned DBR5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned G3DBR0             : 1;
    unsigned G3DBR1             : 1;
    unsigned G3DBR2             : 1;
    unsigned G3DBR3             : 1;
    unsigned G3DBR4             : 1;
    unsigned G3DBR5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned G3DBR              : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned DBR                : 6;
    unsigned                    : 2;
    };
  } __COG3DBRbits_t;

extern __at(0x0811) volatile __COG3DBRbits_t COG3DBRbits;

#define _COG3DBR_DBR0           0x01
#define _COG3DBR_G3DBR0         0x01
#define _COG3DBR_DBR1           0x02
#define _COG3DBR_G3DBR1         0x02
#define _COG3DBR_DBR2           0x04
#define _COG3DBR_G3DBR2         0x04
#define _COG3DBR_DBR3           0x08
#define _COG3DBR_G3DBR3         0x08
#define _COG3DBR_DBR4           0x10
#define _COG3DBR_G3DBR4         0x10
#define _COG3DBR_DBR5           0x20
#define _COG3DBR_G3DBR5         0x20

//==============================================================================


//==============================================================================
//        COG3DBF Bits

extern __at(0x0812) __sfr COG3DBF;

typedef union
  {
  struct
    {
    unsigned DBF0               : 1;
    unsigned DBF1               : 1;
    unsigned DBF2               : 1;
    unsigned DBF3               : 1;
    unsigned DBF4               : 1;
    unsigned DBF5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned G3DBF0             : 1;
    unsigned G3DBF1             : 1;
    unsigned G3DBF2             : 1;
    unsigned G3DBF3             : 1;
    unsigned G3DBF4             : 1;
    unsigned G3DBF5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned G3DBF              : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned DBF                : 6;
    unsigned                    : 2;
    };
  } __COG3DBFbits_t;

extern __at(0x0812) volatile __COG3DBFbits_t COG3DBFbits;

#define _COG3DBF_DBF0           0x01
#define _COG3DBF_G3DBF0         0x01
#define _COG3DBF_DBF1           0x02
#define _COG3DBF_G3DBF1         0x02
#define _COG3DBF_DBF2           0x04
#define _COG3DBF_G3DBF2         0x04
#define _COG3DBF_DBF3           0x08
#define _COG3DBF_G3DBF3         0x08
#define _COG3DBF_DBF4           0x10
#define _COG3DBF_G3DBF4         0x10
#define _COG3DBF_DBF5           0x20
#define _COG3DBF_G3DBF5         0x20

//==============================================================================


//==============================================================================
//        COG3CON0 Bits

extern __at(0x0813) __sfr COG3CON0;

typedef union
  {
  struct
    {
    unsigned MD0                : 1;
    unsigned MD1                : 1;
    unsigned MD2                : 1;
    unsigned CS0                : 1;
    unsigned CS1                : 1;
    unsigned                    : 1;
    unsigned LD                 : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned G3MD0              : 1;
    unsigned G3MD1              : 1;
    unsigned G3MD2              : 1;
    unsigned G3CS0              : 1;
    unsigned G3CS1              : 1;
    unsigned                    : 1;
    unsigned G3LD               : 1;
    unsigned G3EN               : 1;
    };

  struct
    {
    unsigned MD                 : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned G3MD               : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 3;
    unsigned CS                 : 2;
    unsigned                    : 3;
    };

  struct
    {
    unsigned                    : 3;
    unsigned G3CS               : 2;
    unsigned                    : 3;
    };
  } __COG3CON0bits_t;

extern __at(0x0813) volatile __COG3CON0bits_t COG3CON0bits;

#define _COG3CON0_MD0           0x01
#define _COG3CON0_G3MD0         0x01
#define _COG3CON0_MD1           0x02
#define _COG3CON0_G3MD1         0x02
#define _COG3CON0_MD2           0x04
#define _COG3CON0_G3MD2         0x04
#define _COG3CON0_CS0           0x08
#define _COG3CON0_G3CS0         0x08
#define _COG3CON0_CS1           0x10
#define _COG3CON0_G3CS1         0x10
#define _COG3CON0_LD            0x40
#define _COG3CON0_G3LD          0x40
#define _COG3CON0_EN            0x80
#define _COG3CON0_G3EN          0x80

//==============================================================================


//==============================================================================
//        COG3CON1 Bits

extern __at(0x0814) __sfr COG3CON1;

typedef union
  {
  struct
    {
    unsigned POLA               : 1;
    unsigned POLB               : 1;
    unsigned POLC               : 1;
    unsigned POLD               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned FDBS               : 1;
    unsigned RDBS               : 1;
    };

  struct
    {
    unsigned G3POLA             : 1;
    unsigned G3POLB             : 1;
    unsigned G3POLC             : 1;
    unsigned G3POLD             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned G3FDBS             : 1;
    unsigned G3RDBS             : 1;
    };
  } __COG3CON1bits_t;

extern __at(0x0814) volatile __COG3CON1bits_t COG3CON1bits;

#define _COG3CON1_POLA          0x01
#define _COG3CON1_G3POLA        0x01
#define _COG3CON1_POLB          0x02
#define _COG3CON1_G3POLB        0x02
#define _COG3CON1_POLC          0x04
#define _COG3CON1_G3POLC        0x04
#define _COG3CON1_POLD          0x08
#define _COG3CON1_G3POLD        0x08
#define _COG3CON1_FDBS          0x40
#define _COG3CON1_G3FDBS        0x40
#define _COG3CON1_RDBS          0x80
#define _COG3CON1_G3RDBS        0x80

//==============================================================================


//==============================================================================
//        COG3RIS0 Bits

extern __at(0x0815) __sfr COG3RIS0;

typedef union
  {
  struct
    {
    unsigned RIS0               : 1;
    unsigned RIS1               : 1;
    unsigned RIS2               : 1;
    unsigned RIS3               : 1;
    unsigned RIS4               : 1;
    unsigned RIS5               : 1;
    unsigned RIS6               : 1;
    unsigned RIS7               : 1;
    };

  struct
    {
    unsigned G3RIS0             : 1;
    unsigned G3RIS1             : 1;
    unsigned G3RIS2             : 1;
    unsigned G3RIS3             : 1;
    unsigned G3RIS4             : 1;
    unsigned G3RIS5             : 1;
    unsigned G3RIS6             : 1;
    unsigned G3RIS7             : 1;
    };
  } __COG3RIS0bits_t;

extern __at(0x0815) volatile __COG3RIS0bits_t COG3RIS0bits;

#define _COG3RIS0_RIS0          0x01
#define _COG3RIS0_G3RIS0        0x01
#define _COG3RIS0_RIS1          0x02
#define _COG3RIS0_G3RIS1        0x02
#define _COG3RIS0_RIS2          0x04
#define _COG3RIS0_G3RIS2        0x04
#define _COG3RIS0_RIS3          0x08
#define _COG3RIS0_G3RIS3        0x08
#define _COG3RIS0_RIS4          0x10
#define _COG3RIS0_G3RIS4        0x10
#define _COG3RIS0_RIS5          0x20
#define _COG3RIS0_G3RIS5        0x20
#define _COG3RIS0_RIS6          0x40
#define _COG3RIS0_G3RIS6        0x40
#define _COG3RIS0_RIS7          0x80
#define _COG3RIS0_G3RIS7        0x80

//==============================================================================


//==============================================================================
//        COG3RIS1 Bits

extern __at(0x0816) __sfr COG3RIS1;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned RIS9               : 1;
    unsigned                    : 1;
    unsigned RIS11              : 1;
    unsigned RIS12              : 1;
    unsigned RIS13              : 1;
    unsigned RIS14              : 1;
    unsigned RIS15              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned G3RIS9             : 1;
    unsigned                    : 1;
    unsigned G3RIS11            : 1;
    unsigned G3RIS12            : 1;
    unsigned G3RIS13            : 1;
    unsigned G3RIS14            : 1;
    unsigned G3RIS15            : 1;
    };
  } __COG3RIS1bits_t;

extern __at(0x0816) volatile __COG3RIS1bits_t COG3RIS1bits;

#define _COG3RIS1_RIS9          0x02
#define _COG3RIS1_G3RIS9        0x02
#define _COG3RIS1_RIS11         0x08
#define _COG3RIS1_G3RIS11       0x08
#define _COG3RIS1_RIS12         0x10
#define _COG3RIS1_G3RIS12       0x10
#define _COG3RIS1_RIS13         0x20
#define _COG3RIS1_G3RIS13       0x20
#define _COG3RIS1_RIS14         0x40
#define _COG3RIS1_G3RIS14       0x40
#define _COG3RIS1_RIS15         0x80
#define _COG3RIS1_G3RIS15       0x80

//==============================================================================


//==============================================================================
//        COG3RSIM0 Bits

extern __at(0x0817) __sfr COG3RSIM0;

typedef union
  {
  struct
    {
    unsigned RSIM0              : 1;
    unsigned RSIM1              : 1;
    unsigned RSIM2              : 1;
    unsigned RSIM3              : 1;
    unsigned RSIM4              : 1;
    unsigned RSIM5              : 1;
    unsigned RSIM6              : 1;
    unsigned RSIM7              : 1;
    };

  struct
    {
    unsigned G3RSIM0            : 1;
    unsigned G3RSIM1            : 1;
    unsigned G3RSIM2            : 1;
    unsigned G3RSIM3            : 1;
    unsigned G3RSIM4            : 1;
    unsigned G3RSIM5            : 1;
    unsigned G3RSIM6            : 1;
    unsigned G3RSIM7            : 1;
    };
  } __COG3RSIM0bits_t;

extern __at(0x0817) volatile __COG3RSIM0bits_t COG3RSIM0bits;

#define _COG3RSIM0_RSIM0        0x01
#define _COG3RSIM0_G3RSIM0      0x01
#define _COG3RSIM0_RSIM1        0x02
#define _COG3RSIM0_G3RSIM1      0x02
#define _COG3RSIM0_RSIM2        0x04
#define _COG3RSIM0_G3RSIM2      0x04
#define _COG3RSIM0_RSIM3        0x08
#define _COG3RSIM0_G3RSIM3      0x08
#define _COG3RSIM0_RSIM4        0x10
#define _COG3RSIM0_G3RSIM4      0x10
#define _COG3RSIM0_RSIM5        0x20
#define _COG3RSIM0_G3RSIM5      0x20
#define _COG3RSIM0_RSIM6        0x40
#define _COG3RSIM0_G3RSIM6      0x40
#define _COG3RSIM0_RSIM7        0x80
#define _COG3RSIM0_G3RSIM7      0x80

//==============================================================================


//==============================================================================
//        COG3RSIM1 Bits

extern __at(0x0818) __sfr COG3RSIM1;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned RSIM9              : 1;
    unsigned                    : 1;
    unsigned RSIM11             : 1;
    unsigned RSIM12             : 1;
    unsigned RSIM13             : 1;
    unsigned RSIM14             : 1;
    unsigned RSIM15             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned G3RSIM9            : 1;
    unsigned                    : 1;
    unsigned G3RSIM11           : 1;
    unsigned G3RSIM12           : 1;
    unsigned G3RSIM13           : 1;
    unsigned G3RSIM14           : 1;
    unsigned G3RSIM15           : 1;
    };
  } __COG3RSIM1bits_t;

extern __at(0x0818) volatile __COG3RSIM1bits_t COG3RSIM1bits;

#define _COG3RSIM1_RSIM9        0x02
#define _COG3RSIM1_G3RSIM9      0x02
#define _COG3RSIM1_RSIM11       0x08
#define _COG3RSIM1_G3RSIM11     0x08
#define _COG3RSIM1_RSIM12       0x10
#define _COG3RSIM1_G3RSIM12     0x10
#define _COG3RSIM1_RSIM13       0x20
#define _COG3RSIM1_G3RSIM13     0x20
#define _COG3RSIM1_RSIM14       0x40
#define _COG3RSIM1_G3RSIM14     0x40
#define _COG3RSIM1_RSIM15       0x80
#define _COG3RSIM1_G3RSIM15     0x80

//==============================================================================


//==============================================================================
//        COG3FIS0 Bits

extern __at(0x0819) __sfr COG3FIS0;

typedef union
  {
  struct
    {
    unsigned FIS0               : 1;
    unsigned FIS1               : 1;
    unsigned FIS2               : 1;
    unsigned FIS3               : 1;
    unsigned FIS4               : 1;
    unsigned FIS5               : 1;
    unsigned FIS6               : 1;
    unsigned FIS7               : 1;
    };

  struct
    {
    unsigned G3FIS0             : 1;
    unsigned G3FIS1             : 1;
    unsigned G3FIS2             : 1;
    unsigned G3FIS3             : 1;
    unsigned G3FIS4             : 1;
    unsigned G3FIS5             : 1;
    unsigned G3FIS6             : 1;
    unsigned G3FIS7             : 1;
    };
  } __COG3FIS0bits_t;

extern __at(0x0819) volatile __COG3FIS0bits_t COG3FIS0bits;

#define _COG3FIS0_FIS0          0x01
#define _COG3FIS0_G3FIS0        0x01
#define _COG3FIS0_FIS1          0x02
#define _COG3FIS0_G3FIS1        0x02
#define _COG3FIS0_FIS2          0x04
#define _COG3FIS0_G3FIS2        0x04
#define _COG3FIS0_FIS3          0x08
#define _COG3FIS0_G3FIS3        0x08
#define _COG3FIS0_FIS4          0x10
#define _COG3FIS0_G3FIS4        0x10
#define _COG3FIS0_FIS5          0x20
#define _COG3FIS0_G3FIS5        0x20
#define _COG3FIS0_FIS6          0x40
#define _COG3FIS0_G3FIS6        0x40
#define _COG3FIS0_FIS7          0x80
#define _COG3FIS0_G3FIS7        0x80

//==============================================================================


//==============================================================================
//        COG3FIS1 Bits

extern __at(0x081A) __sfr COG3FIS1;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned FIS9               : 1;
    unsigned                    : 1;
    unsigned FIS11              : 1;
    unsigned FIS12              : 1;
    unsigned FIS13              : 1;
    unsigned FIS14              : 1;
    unsigned FIS15              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned G3FIS9             : 1;
    unsigned                    : 1;
    unsigned G3FIS11            : 1;
    unsigned G3FIS12            : 1;
    unsigned G3FIS13            : 1;
    unsigned G3FIS14            : 1;
    unsigned G3FIS15            : 1;
    };
  } __COG3FIS1bits_t;

extern __at(0x081A) volatile __COG3FIS1bits_t COG3FIS1bits;

#define _COG3FIS1_FIS9          0x02
#define _COG3FIS1_G3FIS9        0x02
#define _COG3FIS1_FIS11         0x08
#define _COG3FIS1_G3FIS11       0x08
#define _COG3FIS1_FIS12         0x10
#define _COG3FIS1_G3FIS12       0x10
#define _COG3FIS1_FIS13         0x20
#define _COG3FIS1_G3FIS13       0x20
#define _COG3FIS1_FIS14         0x40
#define _COG3FIS1_G3FIS14       0x40
#define _COG3FIS1_FIS15         0x80
#define _COG3FIS1_G3FIS15       0x80

//==============================================================================


//==============================================================================
//        COG3FSIM0 Bits

extern __at(0x081B) __sfr COG3FSIM0;

typedef union
  {
  struct
    {
    unsigned FSIM0              : 1;
    unsigned FSIM1              : 1;
    unsigned FSIM2              : 1;
    unsigned FSIM3              : 1;
    unsigned FSIM4              : 1;
    unsigned FSIM5              : 1;
    unsigned FSIM6              : 1;
    unsigned FSIM7              : 1;
    };

  struct
    {
    unsigned G3FSIM0            : 1;
    unsigned G3FSIM1            : 1;
    unsigned G3FSIM2            : 1;
    unsigned G3FSIM3            : 1;
    unsigned G3FSIM4            : 1;
    unsigned G3FSIM5            : 1;
    unsigned G3FSIM6            : 1;
    unsigned G3FSIM7            : 1;
    };
  } __COG3FSIM0bits_t;

extern __at(0x081B) volatile __COG3FSIM0bits_t COG3FSIM0bits;

#define _COG3FSIM0_FSIM0        0x01
#define _COG3FSIM0_G3FSIM0      0x01
#define _COG3FSIM0_FSIM1        0x02
#define _COG3FSIM0_G3FSIM1      0x02
#define _COG3FSIM0_FSIM2        0x04
#define _COG3FSIM0_G3FSIM2      0x04
#define _COG3FSIM0_FSIM3        0x08
#define _COG3FSIM0_G3FSIM3      0x08
#define _COG3FSIM0_FSIM4        0x10
#define _COG3FSIM0_G3FSIM4      0x10
#define _COG3FSIM0_FSIM5        0x20
#define _COG3FSIM0_G3FSIM5      0x20
#define _COG3FSIM0_FSIM6        0x40
#define _COG3FSIM0_G3FSIM6      0x40
#define _COG3FSIM0_FSIM7        0x80
#define _COG3FSIM0_G3FSIM7      0x80

//==============================================================================


//==============================================================================
//        COG3FSIM1 Bits

extern __at(0x081C) __sfr COG3FSIM1;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned FSIM9              : 1;
    unsigned                    : 1;
    unsigned FSIM11             : 1;
    unsigned FSIM12             : 1;
    unsigned FSIM13             : 1;
    unsigned FSIM14             : 1;
    unsigned FSIM15             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned G3FSIM9            : 1;
    unsigned                    : 1;
    unsigned G3FSIM11           : 1;
    unsigned G3FSIM12           : 1;
    unsigned G3FSIM13           : 1;
    unsigned G3FSIM14           : 1;
    unsigned G3FSIM15           : 1;
    };
  } __COG3FSIM1bits_t;

extern __at(0x081C) volatile __COG3FSIM1bits_t COG3FSIM1bits;

#define _COG3FSIM1_FSIM9        0x02
#define _COG3FSIM1_G3FSIM9      0x02
#define _COG3FSIM1_FSIM11       0x08
#define _COG3FSIM1_G3FSIM11     0x08
#define _COG3FSIM1_FSIM12       0x10
#define _COG3FSIM1_G3FSIM12     0x10
#define _COG3FSIM1_FSIM13       0x20
#define _COG3FSIM1_G3FSIM13     0x20
#define _COG3FSIM1_FSIM14       0x40
#define _COG3FSIM1_G3FSIM14     0x40
#define _COG3FSIM1_FSIM15       0x80
#define _COG3FSIM1_G3FSIM15     0x80

//==============================================================================


//==============================================================================
//        COG3ASD0 Bits

extern __at(0x081D) __sfr COG3ASD0;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ASDAC0             : 1;
    unsigned ASDAC1             : 1;
    unsigned ASDBD0             : 1;
    unsigned ASDBD1             : 1;
    unsigned ASREN              : 1;
    unsigned ASE                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned G3ASDAC0           : 1;
    unsigned G3ASDAC1           : 1;
    unsigned G3ASDBD0           : 1;
    unsigned G3ASDBD1           : 1;
    unsigned ARSEN              : 1;
    unsigned G3ASE              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned G3ARSEN            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned G3ASREN            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned ASDAC              : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 2;
    unsigned G3ASDAC            : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned G3ASDBD            : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 4;
    unsigned ASDBD              : 2;
    unsigned                    : 2;
    };
  } __COG3ASD0bits_t;

extern __at(0x081D) volatile __COG3ASD0bits_t COG3ASD0bits;

#define _COG3ASD0_ASDAC0        0x04
#define _COG3ASD0_G3ASDAC0      0x04
#define _COG3ASD0_ASDAC1        0x08
#define _COG3ASD0_G3ASDAC1      0x08
#define _COG3ASD0_ASDBD0        0x10
#define _COG3ASD0_G3ASDBD0      0x10
#define _COG3ASD0_ASDBD1        0x20
#define _COG3ASD0_G3ASDBD1      0x20
#define _COG3ASD0_ASREN         0x40
#define _COG3ASD0_ARSEN         0x40
#define _COG3ASD0_G3ARSEN       0x40
#define _COG3ASD0_G3ASREN       0x40
#define _COG3ASD0_ASE           0x80
#define _COG3ASD0_G3ASE         0x80

//==============================================================================


//==============================================================================
//        COG3ASD1 Bits

extern __at(0x081E) __sfr COG3ASD1;

typedef union
  {
  struct
    {
    unsigned AS0E               : 1;
    unsigned AS1E               : 1;
    unsigned AS2E               : 1;
    unsigned AS3E               : 1;
    unsigned AS4E               : 1;
    unsigned AS5E               : 1;
    unsigned AS6E               : 1;
    unsigned AS7E               : 1;
    };

  struct
    {
    unsigned G3AS0E             : 1;
    unsigned G3AS1E             : 1;
    unsigned G3AS2E             : 1;
    unsigned G3AS3E             : 1;
    unsigned G3AS4E             : 1;
    unsigned G3AS5E             : 1;
    unsigned G3AS6E             : 1;
    unsigned G3AS7E             : 1;
    };
  } __COG3ASD1bits_t;

extern __at(0x081E) volatile __COG3ASD1bits_t COG3ASD1bits;

#define _COG3ASD1_AS0E          0x01
#define _COG3ASD1_G3AS0E        0x01
#define _COG3ASD1_AS1E          0x02
#define _COG3ASD1_G3AS1E        0x02
#define _COG3ASD1_AS2E          0x04
#define _COG3ASD1_G3AS2E        0x04
#define _COG3ASD1_AS3E          0x08
#define _COG3ASD1_G3AS3E        0x08
#define _COG3ASD1_AS4E          0x10
#define _COG3ASD1_G3AS4E        0x10
#define _COG3ASD1_AS5E          0x20
#define _COG3ASD1_G3AS5E        0x20
#define _COG3ASD1_AS6E          0x40
#define _COG3ASD1_G3AS6E        0x40
#define _COG3ASD1_AS7E          0x80
#define _COG3ASD1_G3AS7E        0x80

//==============================================================================


//==============================================================================
//        COG3STR Bits

extern __at(0x081F) __sfr COG3STR;

typedef union
  {
  struct
    {
    unsigned STRA               : 1;
    unsigned STRB               : 1;
    unsigned STRC               : 1;
    unsigned STRD               : 1;
    unsigned SDATA              : 1;
    unsigned SDATB              : 1;
    unsigned SDATC              : 1;
    unsigned SDATD              : 1;
    };

  struct
    {
    unsigned G3STRA             : 1;
    unsigned G3STRB             : 1;
    unsigned G3STRC             : 1;
    unsigned G3STRD             : 1;
    unsigned G3SDATA            : 1;
    unsigned G3SDATB            : 1;
    unsigned G3SDATC            : 1;
    unsigned G3SDATD            : 1;
    };
  } __COG3STRbits_t;

extern __at(0x081F) volatile __COG3STRbits_t COG3STRbits;

#define _COG3STR_STRA           0x01
#define _COG3STR_G3STRA         0x01
#define _COG3STR_STRB           0x02
#define _COG3STR_G3STRB         0x02
#define _COG3STR_STRC           0x04
#define _COG3STR_G3STRC         0x04
#define _COG3STR_STRD           0x08
#define _COG3STR_G3STRD         0x08
#define _COG3STR_SDATA          0x10
#define _COG3STR_G3SDATA        0x10
#define _COG3STR_SDATB          0x20
#define _COG3STR_G3SDATB        0x20
#define _COG3STR_SDATC          0x40
#define _COG3STR_G3SDATC        0x40
#define _COG3STR_SDATD          0x80
#define _COG3STR_G3SDATD        0x80

//==============================================================================


//==============================================================================
//        CM4CON0 Bits

extern __at(0x090C) __sfr CM4CON0;

typedef union
  {
  struct
    {
    unsigned SYNC               : 1;
    unsigned HYS                : 1;
    unsigned Reserved           : 1;
    unsigned ZLF                : 1;
    unsigned POL                : 1;
    unsigned                    : 1;
    unsigned OUT                : 1;
    unsigned ON                 : 1;
    };

  struct
    {
    unsigned C4SYNC             : 1;
    unsigned C4HYS              : 1;
    unsigned C4SP               : 1;
    unsigned C4ZLF              : 1;
    unsigned C4POL              : 1;
    unsigned                    : 1;
    unsigned C4OUT              : 1;
    unsigned C4ON               : 1;
    };
  } __CM4CON0bits_t;

extern __at(0x090C) volatile __CM4CON0bits_t CM4CON0bits;

#define _CM4CON0_SYNC           0x01
#define _CM4CON0_C4SYNC         0x01
#define _CM4CON0_HYS            0x02
#define _CM4CON0_C4HYS          0x02
#define _CM4CON0_Reserved       0x04
#define _CM4CON0_C4SP           0x04
#define _CM4CON0_ZLF            0x08
#define _CM4CON0_C4ZLF          0x08
#define _CM4CON0_POL            0x10
#define _CM4CON0_C4POL          0x10
#define _CM4CON0_OUT            0x40
#define _CM4CON0_C4OUT          0x40
#define _CM4CON0_ON             0x80
#define _CM4CON0_C4ON           0x80

//==============================================================================


//==============================================================================
//        CM4CON1 Bits

extern __at(0x090D) __sfr CM4CON1;

typedef union
  {
  struct
    {
    unsigned INTN               : 1;
    unsigned INTP               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned C4INTN             : 1;
    unsigned C4INTP             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __CM4CON1bits_t;

extern __at(0x090D) volatile __CM4CON1bits_t CM4CON1bits;

#define _CM4CON1_INTN           0x01
#define _CM4CON1_C4INTN         0x01
#define _CM4CON1_INTP           0x02
#define _CM4CON1_C4INTP         0x02

//==============================================================================


//==============================================================================
//        CM4NSEL Bits

extern __at(0x090E) __sfr CM4NSEL;

typedef union
  {
  struct
    {
    unsigned C4NCH0             : 1;
    unsigned C4NCH1             : 1;
    unsigned C4NCH2             : 1;
    unsigned C4NCH3             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned C4NCH              : 4;
    unsigned                    : 4;
    };
  } __CM4NSELbits_t;

extern __at(0x090E) volatile __CM4NSELbits_t CM4NSELbits;

#define _C4NCH0                 0x01
#define _C4NCH1                 0x02
#define _C4NCH2                 0x04
#define _C4NCH3                 0x08

//==============================================================================


//==============================================================================
//        CM4PSEL Bits

extern __at(0x090F) __sfr CM4PSEL;

typedef union
  {
  struct
    {
    unsigned PCH0               : 1;
    unsigned PCH1               : 1;
    unsigned PCH2               : 1;
    unsigned PCH3               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned C4PCH0             : 1;
    unsigned C4PCH1             : 1;
    unsigned C4PCH2             : 1;
    unsigned C4PCH3             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PCH                : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned C4PCH              : 4;
    unsigned                    : 4;
    };
  } __CM4PSELbits_t;

extern __at(0x090F) volatile __CM4PSELbits_t CM4PSELbits;

#define _CM4PSEL_PCH0           0x01
#define _CM4PSEL_C4PCH0         0x01
#define _CM4PSEL_PCH1           0x02
#define _CM4PSEL_C4PCH1         0x02
#define _CM4PSEL_PCH2           0x04
#define _CM4PSEL_C4PCH2         0x04
#define _CM4PSEL_PCH3           0x08
#define _CM4PSEL_C4PCH3         0x08

//==============================================================================


//==============================================================================
//        CM5CON0 Bits

extern __at(0x0910) __sfr CM5CON0;

typedef union
  {
  struct
    {
    unsigned SYNC               : 1;
    unsigned HYS                : 1;
    unsigned Reserved           : 1;
    unsigned ZLF                : 1;
    unsigned POL                : 1;
    unsigned                    : 1;
    unsigned OUT                : 1;
    unsigned ON                 : 1;
    };

  struct
    {
    unsigned C5SYNC             : 1;
    unsigned C5HYS              : 1;
    unsigned C5SP               : 1;
    unsigned C5ZLF              : 1;
    unsigned C5POL              : 1;
    unsigned                    : 1;
    unsigned C5OUT              : 1;
    unsigned C5ON               : 1;
    };
  } __CM5CON0bits_t;

extern __at(0x0910) volatile __CM5CON0bits_t CM5CON0bits;

#define _CM5CON0_SYNC           0x01
#define _CM5CON0_C5SYNC         0x01
#define _CM5CON0_HYS            0x02
#define _CM5CON0_C5HYS          0x02
#define _CM5CON0_Reserved       0x04
#define _CM5CON0_C5SP           0x04
#define _CM5CON0_ZLF            0x08
#define _CM5CON0_C5ZLF          0x08
#define _CM5CON0_POL            0x10
#define _CM5CON0_C5POL          0x10
#define _CM5CON0_OUT            0x40
#define _CM5CON0_C5OUT          0x40
#define _CM5CON0_ON             0x80
#define _CM5CON0_C5ON           0x80

//==============================================================================


//==============================================================================
//        CM5CON1 Bits

extern __at(0x0911) __sfr CM5CON1;

typedef union
  {
  struct
    {
    unsigned INTN               : 1;
    unsigned INTP               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned C5INTN             : 1;
    unsigned C5INTP             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __CM5CON1bits_t;

extern __at(0x0911) volatile __CM5CON1bits_t CM5CON1bits;

#define _CM5CON1_INTN           0x01
#define _CM5CON1_C5INTN         0x01
#define _CM5CON1_INTP           0x02
#define _CM5CON1_C5INTP         0x02

//==============================================================================


//==============================================================================
//        CM5NSEL Bits

extern __at(0x0912) __sfr CM5NSEL;

typedef union
  {
  struct
    {
    unsigned C5NCH0             : 1;
    unsigned C5NCH1             : 1;
    unsigned C5NCH2             : 1;
    unsigned C5NCH3             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned C5NCH              : 4;
    unsigned                    : 4;
    };
  } __CM5NSELbits_t;

extern __at(0x0912) volatile __CM5NSELbits_t CM5NSELbits;

#define _C5NCH0                 0x01
#define _C5NCH1                 0x02
#define _C5NCH2                 0x04
#define _C5NCH3                 0x08

//==============================================================================


//==============================================================================
//        CM5PSEL Bits

extern __at(0x0913) __sfr CM5PSEL;

typedef union
  {
  struct
    {
    unsigned PCH0               : 1;
    unsigned PCH1               : 1;
    unsigned PCH2               : 1;
    unsigned PCH3               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned C5PCH0             : 1;
    unsigned C5PCH1             : 1;
    unsigned C5PCH2             : 1;
    unsigned C5PCH3             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned C5PCH              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned PCH                : 4;
    unsigned                    : 4;
    };
  } __CM5PSELbits_t;

extern __at(0x0913) volatile __CM5PSELbits_t CM5PSELbits;

#define _CM5PSEL_PCH0           0x01
#define _CM5PSEL_C5PCH0         0x01
#define _CM5PSEL_PCH1           0x02
#define _CM5PSEL_C5PCH1         0x02
#define _CM5PSEL_PCH2           0x04
#define _CM5PSEL_C5PCH2         0x04
#define _CM5PSEL_PCH3           0x08
#define _CM5PSEL_C5PCH3         0x08

//==============================================================================


//==============================================================================
//        CM6CON0 Bits

extern __at(0x0914) __sfr CM6CON0;

typedef union
  {
  struct
    {
    unsigned SYNC               : 1;
    unsigned HYS                : 1;
    unsigned Reserved           : 1;
    unsigned ZLF                : 1;
    unsigned POL                : 1;
    unsigned                    : 1;
    unsigned OUT                : 1;
    unsigned ON                 : 1;
    };

  struct
    {
    unsigned C6SYNC             : 1;
    unsigned C6HYS              : 1;
    unsigned C6SP               : 1;
    unsigned C6ZLF              : 1;
    unsigned C6POL              : 1;
    unsigned                    : 1;
    unsigned C6OUT              : 1;
    unsigned C6ON               : 1;
    };
  } __CM6CON0bits_t;

extern __at(0x0914) volatile __CM6CON0bits_t CM6CON0bits;

#define _CM6CON0_SYNC           0x01
#define _CM6CON0_C6SYNC         0x01
#define _CM6CON0_HYS            0x02
#define _CM6CON0_C6HYS          0x02
#define _CM6CON0_Reserved       0x04
#define _CM6CON0_C6SP           0x04
#define _CM6CON0_ZLF            0x08
#define _CM6CON0_C6ZLF          0x08
#define _CM6CON0_POL            0x10
#define _CM6CON0_C6POL          0x10
#define _CM6CON0_OUT            0x40
#define _CM6CON0_C6OUT          0x40
#define _CM6CON0_ON             0x80
#define _CM6CON0_C6ON           0x80

//==============================================================================


//==============================================================================
//        CM6CON1 Bits

extern __at(0x0915) __sfr CM6CON1;

typedef union
  {
  struct
    {
    unsigned INTN               : 1;
    unsigned INTP               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned C6INTN             : 1;
    unsigned C6INTP             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __CM6CON1bits_t;

extern __at(0x0915) volatile __CM6CON1bits_t CM6CON1bits;

#define _CM6CON1_INTN           0x01
#define _CM6CON1_C6INTN         0x01
#define _CM6CON1_INTP           0x02
#define _CM6CON1_C6INTP         0x02

//==============================================================================


//==============================================================================
//        CM6NSEL Bits

extern __at(0x0916) __sfr CM6NSEL;

typedef union
  {
  struct
    {
    unsigned C6NCH0             : 1;
    unsigned C6NCH1             : 1;
    unsigned C6NCH2             : 1;
    unsigned C6NCH3             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned C6NCH              : 4;
    unsigned                    : 4;
    };
  } __CM6NSELbits_t;

extern __at(0x0916) volatile __CM6NSELbits_t CM6NSELbits;

#define _C6NCH0                 0x01
#define _C6NCH1                 0x02
#define _C6NCH2                 0x04
#define _C6NCH3                 0x08

//==============================================================================


//==============================================================================
//        CM6PSEL Bits

extern __at(0x0917) __sfr CM6PSEL;

typedef union
  {
  struct
    {
    unsigned PCH0               : 1;
    unsigned PCH1               : 1;
    unsigned PCH2               : 1;
    unsigned PCH3               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned C6PCH0             : 1;
    unsigned C6PCH1             : 1;
    unsigned C6PCH2             : 1;
    unsigned C6PCH3             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned C6PCH              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned PCH                : 4;
    unsigned                    : 4;
    };
  } __CM6PSELbits_t;

extern __at(0x0917) volatile __CM6PSELbits_t CM6PSELbits;

#define _CM6PSEL_PCH0           0x01
#define _CM6PSEL_C6PCH0         0x01
#define _CM6PSEL_PCH1           0x02
#define _CM6PSEL_C6PCH1         0x02
#define _CM6PSEL_PCH2           0x04
#define _CM6PSEL_C6PCH2         0x04
#define _CM6PSEL_PCH3           0x08
#define _CM6PSEL_C6PCH3         0x08

//==============================================================================


//==============================================================================
//        PWMEN Bits

extern __at(0x0D8E) __sfr PWMEN;

typedef struct
  {
  unsigned MPWM5EN              : 1;
  unsigned MPWM6EN              : 1;
  unsigned MPWM11EN             : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PWMENbits_t;

extern __at(0x0D8E) volatile __PWMENbits_t PWMENbits;

#define _MPWM5EN                0x01
#define _MPWM6EN                0x02
#define _MPWM11EN               0x04

//==============================================================================


//==============================================================================
//        PWMLD Bits

extern __at(0x0D8F) __sfr PWMLD;

typedef struct
  {
  unsigned MPWM5LD              : 1;
  unsigned MPWM6LD              : 1;
  unsigned MPWM11LD             : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PWMLDbits_t;

extern __at(0x0D8F) volatile __PWMLDbits_t PWMLDbits;

#define _MPWM5LD                0x01
#define _MPWM6LD                0x02
#define _MPWM11LD               0x04

//==============================================================================


//==============================================================================
//        PWMOUT Bits

extern __at(0x0D90) __sfr PWMOUT;

typedef struct
  {
  unsigned MPWM5OUT             : 1;
  unsigned MPWM6OUT             : 1;
  unsigned MPWM11OUT            : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PWMOUTbits_t;

extern __at(0x0D90) volatile __PWMOUTbits_t PWMOUTbits;

#define _MPWM5OUT               0x01
#define _MPWM6OUT               0x02
#define _MPWM11OUT              0x04

//==============================================================================

extern __at(0x0D91) __sfr PWM5PH;

//==============================================================================
//        PWM5PHL Bits

extern __at(0x0D91) __sfr PWM5PHL;

typedef struct
  {
  unsigned PWM5PHL0             : 1;
  unsigned PWM5PHL1             : 1;
  unsigned PWM5PHL2             : 1;
  unsigned PWM5PHL3             : 1;
  unsigned PWM5PHL4             : 1;
  unsigned PWM5PHL5             : 1;
  unsigned PWM5PHL6             : 1;
  unsigned PWM5PHL7             : 1;
  } __PWM5PHLbits_t;

extern __at(0x0D91) volatile __PWM5PHLbits_t PWM5PHLbits;

#define _PWM5PHL0               0x01
#define _PWM5PHL1               0x02
#define _PWM5PHL2               0x04
#define _PWM5PHL3               0x08
#define _PWM5PHL4               0x10
#define _PWM5PHL5               0x20
#define _PWM5PHL6               0x40
#define _PWM5PHL7               0x80

//==============================================================================


//==============================================================================
//        PWM5PHH Bits

extern __at(0x0D92) __sfr PWM5PHH;

typedef struct
  {
  unsigned PWM5PHH0             : 1;
  unsigned PWM5PHH1             : 1;
  unsigned PWM5PHH2             : 1;
  unsigned PWM5PHH3             : 1;
  unsigned PWM5PHH4             : 1;
  unsigned PWM5PHH5             : 1;
  unsigned PWM5PHH6             : 1;
  unsigned PWM5PHH7             : 1;
  } __PWM5PHHbits_t;

extern __at(0x0D92) volatile __PWM5PHHbits_t PWM5PHHbits;

#define _PWM5PHH0               0x01
#define _PWM5PHH1               0x02
#define _PWM5PHH2               0x04
#define _PWM5PHH3               0x08
#define _PWM5PHH4               0x10
#define _PWM5PHH5               0x20
#define _PWM5PHH6               0x40
#define _PWM5PHH7               0x80

//==============================================================================

extern __at(0x0D93) __sfr PWM5DC;

//==============================================================================
//        PWM5DCL Bits

extern __at(0x0D93) __sfr PWM5DCL;

typedef struct
  {
  unsigned PWM5DCL0             : 1;
  unsigned PWM5DCL1             : 1;
  unsigned PWM5DCL2             : 1;
  unsigned PWM5DCL3             : 1;
  unsigned PWM5DCL4             : 1;
  unsigned PWM5DCL5             : 1;
  unsigned PWM5DCL6             : 1;
  unsigned PWM5DCL7             : 1;
  } __PWM5DCLbits_t;

extern __at(0x0D93) volatile __PWM5DCLbits_t PWM5DCLbits;

#define _PWM5DCL0               0x01
#define _PWM5DCL1               0x02
#define _PWM5DCL2               0x04
#define _PWM5DCL3               0x08
#define _PWM5DCL4               0x10
#define _PWM5DCL5               0x20
#define _PWM5DCL6               0x40
#define _PWM5DCL7               0x80

//==============================================================================


//==============================================================================
//        PWM5DCH Bits

extern __at(0x0D94) __sfr PWM5DCH;

typedef struct
  {
  unsigned PWM5DCH0             : 1;
  unsigned PWM5DCH1             : 1;
  unsigned PWM5DCH2             : 1;
  unsigned PWM5DCH3             : 1;
  unsigned PWM5DCH4             : 1;
  unsigned PWM5DCH5             : 1;
  unsigned PWM5DCH6             : 1;
  unsigned PWM5DCH7             : 1;
  } __PWM5DCHbits_t;

extern __at(0x0D94) volatile __PWM5DCHbits_t PWM5DCHbits;

#define _PWM5DCH0               0x01
#define _PWM5DCH1               0x02
#define _PWM5DCH2               0x04
#define _PWM5DCH3               0x08
#define _PWM5DCH4               0x10
#define _PWM5DCH5               0x20
#define _PWM5DCH6               0x40
#define _PWM5DCH7               0x80

//==============================================================================

extern __at(0x0D95) __sfr PWM5PR;

//==============================================================================
//        PWM5PRL Bits

extern __at(0x0D95) __sfr PWM5PRL;

typedef struct
  {
  unsigned PWM5PRL0             : 1;
  unsigned PWM5PRL1             : 1;
  unsigned PWM5PRL2             : 1;
  unsigned PWM5PRL3             : 1;
  unsigned PWM5PRL4             : 1;
  unsigned PWM5PRL5             : 1;
  unsigned PWM5PRL6             : 1;
  unsigned PWM5PRL7             : 1;
  } __PWM5PRLbits_t;

extern __at(0x0D95) volatile __PWM5PRLbits_t PWM5PRLbits;

#define _PWM5PRL0               0x01
#define _PWM5PRL1               0x02
#define _PWM5PRL2               0x04
#define _PWM5PRL3               0x08
#define _PWM5PRL4               0x10
#define _PWM5PRL5               0x20
#define _PWM5PRL6               0x40
#define _PWM5PRL7               0x80

//==============================================================================


//==============================================================================
//        PWM5PRH Bits

extern __at(0x0D96) __sfr PWM5PRH;

typedef struct
  {
  unsigned PWM5PRH0             : 1;
  unsigned PWM5PRH1             : 1;
  unsigned PWM5PRH2             : 1;
  unsigned PWM5PRH3             : 1;
  unsigned PWM5PRH4             : 1;
  unsigned PWM5PRH5             : 1;
  unsigned PWM5PRH6             : 1;
  unsigned PWM5PRH7             : 1;
  } __PWM5PRHbits_t;

extern __at(0x0D96) volatile __PWM5PRHbits_t PWM5PRHbits;

#define _PWM5PRH0               0x01
#define _PWM5PRH1               0x02
#define _PWM5PRH2               0x04
#define _PWM5PRH3               0x08
#define _PWM5PRH4               0x10
#define _PWM5PRH5               0x20
#define _PWM5PRH6               0x40
#define _PWM5PRH7               0x80

//==============================================================================

extern __at(0x0D97) __sfr PWM5OF;

//==============================================================================
//        PWM5OFL Bits

extern __at(0x0D97) __sfr PWM5OFL;

typedef struct
  {
  unsigned PWM5OFL0             : 1;
  unsigned PWM5OFL1             : 1;
  unsigned PWM5OFL2             : 1;
  unsigned PWM5OFL3             : 1;
  unsigned PWM5OFL4             : 1;
  unsigned PWM5OFL5             : 1;
  unsigned PWM5OFL6             : 1;
  unsigned PWM5OFL7             : 1;
  } __PWM5OFLbits_t;

extern __at(0x0D97) volatile __PWM5OFLbits_t PWM5OFLbits;

#define _PWM5OFL0               0x01
#define _PWM5OFL1               0x02
#define _PWM5OFL2               0x04
#define _PWM5OFL3               0x08
#define _PWM5OFL4               0x10
#define _PWM5OFL5               0x20
#define _PWM5OFL6               0x40
#define _PWM5OFL7               0x80

//==============================================================================


//==============================================================================
//        PWM5OFH Bits

extern __at(0x0D98) __sfr PWM5OFH;

typedef struct
  {
  unsigned PWM5OFH0             : 1;
  unsigned PWM5OFH1             : 1;
  unsigned PWM5OFH2             : 1;
  unsigned PWM5OFH3             : 1;
  unsigned PWM5OFH4             : 1;
  unsigned PWM5OFH5             : 1;
  unsigned PWM5OFH6             : 1;
  unsigned PWM5OFH7             : 1;
  } __PWM5OFHbits_t;

extern __at(0x0D98) volatile __PWM5OFHbits_t PWM5OFHbits;

#define _PWM5OFH0               0x01
#define _PWM5OFH1               0x02
#define _PWM5OFH2               0x04
#define _PWM5OFH3               0x08
#define _PWM5OFH4               0x10
#define _PWM5OFH5               0x20
#define _PWM5OFH6               0x40
#define _PWM5OFH7               0x80

//==============================================================================

extern __at(0x0D99) __sfr PWM5TMR;

//==============================================================================
//        PWM5TMRL Bits

extern __at(0x0D99) __sfr PWM5TMRL;

typedef struct
  {
  unsigned PWM5TMRL0            : 1;
  unsigned PWM5TMRL1            : 1;
  unsigned PWM5TMRL2            : 1;
  unsigned PWM5TMRL3            : 1;
  unsigned PWM5TMRL4            : 1;
  unsigned PWM5TMRL5            : 1;
  unsigned PWM5TMRL6            : 1;
  unsigned PWM5TMRL7            : 1;
  } __PWM5TMRLbits_t;

extern __at(0x0D99) volatile __PWM5TMRLbits_t PWM5TMRLbits;

#define _PWM5TMRL0              0x01
#define _PWM5TMRL1              0x02
#define _PWM5TMRL2              0x04
#define _PWM5TMRL3              0x08
#define _PWM5TMRL4              0x10
#define _PWM5TMRL5              0x20
#define _PWM5TMRL6              0x40
#define _PWM5TMRL7              0x80

//==============================================================================


//==============================================================================
//        PWM5TMRH Bits

extern __at(0x0D9A) __sfr PWM5TMRH;

typedef struct
  {
  unsigned PWM5TMRH0            : 1;
  unsigned PWM5TMRH1            : 1;
  unsigned PWM5TMRH2            : 1;
  unsigned PWM5TMRH3            : 1;
  unsigned PWM5TMRH4            : 1;
  unsigned PWM5TMRH5            : 1;
  unsigned PWM5TMRH6            : 1;
  unsigned PWM5TMRH7            : 1;
  } __PWM5TMRHbits_t;

extern __at(0x0D9A) volatile __PWM5TMRHbits_t PWM5TMRHbits;

#define _PWM5TMRH0              0x01
#define _PWM5TMRH1              0x02
#define _PWM5TMRH2              0x04
#define _PWM5TMRH3              0x08
#define _PWM5TMRH4              0x10
#define _PWM5TMRH5              0x20
#define _PWM5TMRH6              0x40
#define _PWM5TMRH7              0x80

//==============================================================================


//==============================================================================
//        PWM5CON Bits

extern __at(0x0D9B) __sfr PWM5CON;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWM5MODE0          : 1;
    unsigned PWM5MODE1          : 1;
    unsigned POL                : 1;
    unsigned OUT                : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned PWM5POL            : 1;
    unsigned PWM5OUT            : 1;
    unsigned                    : 1;
    unsigned PWM5EN             : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned MODE               : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PWM5MODE           : 2;
    unsigned                    : 4;
    };
  } __PWM5CONbits_t;

extern __at(0x0D9B) volatile __PWM5CONbits_t PWM5CONbits;

#define _PWM5CON_PWM5MODE0      0x04
#define _PWM5CON_MODE0          0x04
#define _PWM5CON_PWM5MODE1      0x08
#define _PWM5CON_MODE1          0x08
#define _PWM5CON_POL            0x10
#define _PWM5CON_PWM5POL        0x10
#define _PWM5CON_OUT            0x20
#define _PWM5CON_PWM5OUT        0x20
#define _PWM5CON_EN             0x80
#define _PWM5CON_PWM5EN         0x80

//==============================================================================


//==============================================================================
//        PWM5INTCON Bits

extern __at(0x0D9C) __sfr PWM5INTCON;

typedef union
  {
  struct
    {
    unsigned PRIE               : 1;
    unsigned DCIE               : 1;
    unsigned PHIE               : 1;
    unsigned OFIE               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PWM5PRIE           : 1;
    unsigned PWM5DCIE           : 1;
    unsigned PWM5PHIE           : 1;
    unsigned PWM5OFIE           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PWM5INTCONbits_t;

extern __at(0x0D9C) volatile __PWM5INTCONbits_t PWM5INTCONbits;

#define _PRIE                   0x01
#define _PWM5PRIE               0x01
#define _DCIE                   0x02
#define _PWM5DCIE               0x02
#define _PHIE                   0x04
#define _PWM5PHIE               0x04
#define _OFIE                   0x08
#define _PWM5OFIE               0x08

//==============================================================================


//==============================================================================
//        PWM5INTE Bits

extern __at(0x0D9C) __sfr PWM5INTE;

typedef union
  {
  struct
    {
    unsigned PRIE               : 1;
    unsigned DCIE               : 1;
    unsigned PHIE               : 1;
    unsigned OFIE               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PWM5PRIE           : 1;
    unsigned PWM5DCIE           : 1;
    unsigned PWM5PHIE           : 1;
    unsigned PWM5OFIE           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PWM5INTEbits_t;

extern __at(0x0D9C) volatile __PWM5INTEbits_t PWM5INTEbits;

#define _PWM5INTE_PRIE          0x01
#define _PWM5INTE_PWM5PRIE      0x01
#define _PWM5INTE_DCIE          0x02
#define _PWM5INTE_PWM5DCIE      0x02
#define _PWM5INTE_PHIE          0x04
#define _PWM5INTE_PWM5PHIE      0x04
#define _PWM5INTE_OFIE          0x08
#define _PWM5INTE_PWM5OFIE      0x08

//==============================================================================


//==============================================================================
//        PWM5INTF Bits

extern __at(0x0D9D) __sfr PWM5INTF;

typedef union
  {
  struct
    {
    unsigned PRIF               : 1;
    unsigned DCIF               : 1;
    unsigned PHIF               : 1;
    unsigned OFIF               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PWM5PRIF           : 1;
    unsigned PWM5DCIF           : 1;
    unsigned PWM5PHIF           : 1;
    unsigned PWM5OFIF           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PWM5INTFbits_t;

extern __at(0x0D9D) volatile __PWM5INTFbits_t PWM5INTFbits;

#define _PRIF                   0x01
#define _PWM5PRIF               0x01
#define _DCIF                   0x02
#define _PWM5DCIF               0x02
#define _PHIF                   0x04
#define _PWM5PHIF               0x04
#define _OFIF                   0x08
#define _PWM5OFIF               0x08

//==============================================================================


//==============================================================================
//        PWM5INTFLG Bits

extern __at(0x0D9D) __sfr PWM5INTFLG;

typedef union
  {
  struct
    {
    unsigned PRIF               : 1;
    unsigned DCIF               : 1;
    unsigned PHIF               : 1;
    unsigned OFIF               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PWM5PRIF           : 1;
    unsigned PWM5DCIF           : 1;
    unsigned PWM5PHIF           : 1;
    unsigned PWM5OFIF           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PWM5INTFLGbits_t;

extern __at(0x0D9D) volatile __PWM5INTFLGbits_t PWM5INTFLGbits;

#define _PWM5INTFLG_PRIF        0x01
#define _PWM5INTFLG_PWM5PRIF    0x01
#define _PWM5INTFLG_DCIF        0x02
#define _PWM5INTFLG_PWM5DCIF    0x02
#define _PWM5INTFLG_PHIF        0x04
#define _PWM5INTFLG_PWM5PHIF    0x04
#define _PWM5INTFLG_OFIF        0x08
#define _PWM5INTFLG_PWM5OFIF    0x08

//==============================================================================


//==============================================================================
//        PWM5CLKCON Bits

extern __at(0x0D9E) __sfr PWM5CLKCON;

typedef union
  {
  struct
    {
    unsigned PWM5CS0            : 1;
    unsigned PWM5CS1            : 1;
    unsigned PWM5CS2            : 1;
    unsigned                    : 1;
    unsigned PWM5PS0            : 1;
    unsigned PWM5PS1            : 1;
    unsigned PWM5PS2            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CS0                : 1;
    unsigned CS1                : 1;
    unsigned CS2                : 1;
    unsigned                    : 1;
    unsigned PS0                : 1;
    unsigned PS1                : 1;
    unsigned PS2                : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PWM5CS             : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned CS                 : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 4;
    unsigned PS                 : 3;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned PWM5PS             : 3;
    unsigned                    : 1;
    };
  } __PWM5CLKCONbits_t;

extern __at(0x0D9E) volatile __PWM5CLKCONbits_t PWM5CLKCONbits;

#define _PWM5CLKCON_PWM5CS0     0x01
#define _PWM5CLKCON_CS0         0x01
#define _PWM5CLKCON_PWM5CS1     0x02
#define _PWM5CLKCON_CS1         0x02
#define _PWM5CLKCON_PWM5CS2     0x04
#define _PWM5CLKCON_CS2         0x04
#define _PWM5CLKCON_PWM5PS0     0x10
#define _PWM5CLKCON_PS0         0x10
#define _PWM5CLKCON_PWM5PS1     0x20
#define _PWM5CLKCON_PS1         0x20
#define _PWM5CLKCON_PWM5PS2     0x40
#define _PWM5CLKCON_PS2         0x40

//==============================================================================


//==============================================================================
//        PWM5LDCON Bits

extern __at(0x0D9F) __sfr PWM5LDCON;

typedef union
  {
  struct
    {
    unsigned PWM5LDS0           : 1;
    unsigned PWM5LDS1           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LDT                : 1;
    unsigned LDA                : 1;
    };

  struct
    {
    unsigned LDS0               : 1;
    unsigned LDS1               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWM5LDM            : 1;
    unsigned PWM5LD             : 1;
    };

  struct
    {
    unsigned LDS                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned PWM5LDS            : 2;
    unsigned                    : 6;
    };
  } __PWM5LDCONbits_t;

extern __at(0x0D9F) volatile __PWM5LDCONbits_t PWM5LDCONbits;

#define _PWM5LDS0               0x01
#define _LDS0                   0x01
#define _PWM5LDS1               0x02
#define _LDS1                   0x02
#define _LDT                    0x40
#define _PWM5LDM                0x40
#define _LDA                    0x80
#define _PWM5LD                 0x80

//==============================================================================


//==============================================================================
//        PWM5OFCON Bits

extern __at(0x0DA0) __sfr PWM5OFCON;

typedef union
  {
  struct
    {
    unsigned PWM5OFS0           : 1;
    unsigned PWM5OFS1           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned OFO                : 1;
    unsigned PWM5OFM0           : 1;
    unsigned PWM5OFM1           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned OFS0               : 1;
    unsigned OFS1               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWM5OFMC           : 1;
    unsigned OFM0               : 1;
    unsigned OFM1               : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PWM5OFS            : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned OFS                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 5;
    unsigned OFM                : 2;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned PWM5OFM            : 2;
    unsigned                    : 1;
    };
  } __PWM5OFCONbits_t;

extern __at(0x0DA0) volatile __PWM5OFCONbits_t PWM5OFCONbits;

#define _PWM5OFS0               0x01
#define _OFS0                   0x01
#define _PWM5OFS1               0x02
#define _OFS1                   0x02
#define _OFO                    0x10
#define _PWM5OFMC               0x10
#define _PWM5OFM0               0x20
#define _OFM0                   0x20
#define _PWM5OFM1               0x40
#define _OFM1                   0x40

//==============================================================================

extern __at(0x0DA1) __sfr PWM6PH;

//==============================================================================
//        PWM6PHL Bits

extern __at(0x0DA1) __sfr PWM6PHL;

typedef struct
  {
  unsigned PWM6PHL0             : 1;
  unsigned PWM6PHL1             : 1;
  unsigned PWM6PHL2             : 1;
  unsigned PWM6PHL3             : 1;
  unsigned PWM6PHL4             : 1;
  unsigned PWM6PHL5             : 1;
  unsigned PWM6PHL6             : 1;
  unsigned PWM6PHL7             : 1;
  } __PWM6PHLbits_t;

extern __at(0x0DA1) volatile __PWM6PHLbits_t PWM6PHLbits;

#define _PWM6PHL0               0x01
#define _PWM6PHL1               0x02
#define _PWM6PHL2               0x04
#define _PWM6PHL3               0x08
#define _PWM6PHL4               0x10
#define _PWM6PHL5               0x20
#define _PWM6PHL6               0x40
#define _PWM6PHL7               0x80

//==============================================================================


//==============================================================================
//        PWM6PHH Bits

extern __at(0x0DA2) __sfr PWM6PHH;

typedef struct
  {
  unsigned PWM6PHH0             : 1;
  unsigned PWM6PHH1             : 1;
  unsigned PWM6PHH2             : 1;
  unsigned PWM6PHH3             : 1;
  unsigned PWM6PHH4             : 1;
  unsigned PWM6PHH5             : 1;
  unsigned PWM6PHH6             : 1;
  unsigned PWM6PHH7             : 1;
  } __PWM6PHHbits_t;

extern __at(0x0DA2) volatile __PWM6PHHbits_t PWM6PHHbits;

#define _PWM6PHH0               0x01
#define _PWM6PHH1               0x02
#define _PWM6PHH2               0x04
#define _PWM6PHH3               0x08
#define _PWM6PHH4               0x10
#define _PWM6PHH5               0x20
#define _PWM6PHH6               0x40
#define _PWM6PHH7               0x80

//==============================================================================

extern __at(0x0DA3) __sfr PWM6DC;

//==============================================================================
//        PWM6DCL Bits

extern __at(0x0DA3) __sfr PWM6DCL;

typedef struct
  {
  unsigned PWM6DCL0             : 1;
  unsigned PWM6DCL1             : 1;
  unsigned PWM6DCL2             : 1;
  unsigned PWM6DCL3             : 1;
  unsigned PWM6DCL4             : 1;
  unsigned PWM6DCL5             : 1;
  unsigned PWM6DCL6             : 1;
  unsigned PWM6DCL7             : 1;
  } __PWM6DCLbits_t;

extern __at(0x0DA3) volatile __PWM6DCLbits_t PWM6DCLbits;

#define _PWM6DCL0               0x01
#define _PWM6DCL1               0x02
#define _PWM6DCL2               0x04
#define _PWM6DCL3               0x08
#define _PWM6DCL4               0x10
#define _PWM6DCL5               0x20
#define _PWM6DCL6               0x40
#define _PWM6DCL7               0x80

//==============================================================================


//==============================================================================
//        PWM6DCH Bits

extern __at(0x0DA4) __sfr PWM6DCH;

typedef struct
  {
  unsigned PWM6DCH0             : 1;
  unsigned PWM6DCH1             : 1;
  unsigned PWM6DCH2             : 1;
  unsigned PWM6DCH3             : 1;
  unsigned PWM6DCH4             : 1;
  unsigned PWM6DCH5             : 1;
  unsigned PWM6DCH6             : 1;
  unsigned PWM6DCH7             : 1;
  } __PWM6DCHbits_t;

extern __at(0x0DA4) volatile __PWM6DCHbits_t PWM6DCHbits;

#define _PWM6DCH0               0x01
#define _PWM6DCH1               0x02
#define _PWM6DCH2               0x04
#define _PWM6DCH3               0x08
#define _PWM6DCH4               0x10
#define _PWM6DCH5               0x20
#define _PWM6DCH6               0x40
#define _PWM6DCH7               0x80

//==============================================================================

extern __at(0x0DA5) __sfr PWM6PR;

//==============================================================================
//        PWM6PRL Bits

extern __at(0x0DA5) __sfr PWM6PRL;

typedef struct
  {
  unsigned PWM6PRL0             : 1;
  unsigned PWM6PRL1             : 1;
  unsigned PWM6PRL2             : 1;
  unsigned PWM6PRL3             : 1;
  unsigned PWM6PRL4             : 1;
  unsigned PWM6PRL5             : 1;
  unsigned PWM6PRL6             : 1;
  unsigned PWM6PRL7             : 1;
  } __PWM6PRLbits_t;

extern __at(0x0DA5) volatile __PWM6PRLbits_t PWM6PRLbits;

#define _PWM6PRL0               0x01
#define _PWM6PRL1               0x02
#define _PWM6PRL2               0x04
#define _PWM6PRL3               0x08
#define _PWM6PRL4               0x10
#define _PWM6PRL5               0x20
#define _PWM6PRL6               0x40
#define _PWM6PRL7               0x80

//==============================================================================


//==============================================================================
//        PWM6PRH Bits

extern __at(0x0DA6) __sfr PWM6PRH;

typedef struct
  {
  unsigned PWM6PRH0             : 1;
  unsigned PWM6PRH1             : 1;
  unsigned PWM6PRH2             : 1;
  unsigned PWM6PRH3             : 1;
  unsigned PWM6PRH4             : 1;
  unsigned PWM6PRH5             : 1;
  unsigned PWM6PRH6             : 1;
  unsigned PWM6PRH7             : 1;
  } __PWM6PRHbits_t;

extern __at(0x0DA6) volatile __PWM6PRHbits_t PWM6PRHbits;

#define _PWM6PRH0               0x01
#define _PWM6PRH1               0x02
#define _PWM6PRH2               0x04
#define _PWM6PRH3               0x08
#define _PWM6PRH4               0x10
#define _PWM6PRH5               0x20
#define _PWM6PRH6               0x40
#define _PWM6PRH7               0x80

//==============================================================================

extern __at(0x0DA7) __sfr PWM6OF;

//==============================================================================
//        PWM6OFL Bits

extern __at(0x0DA7) __sfr PWM6OFL;

typedef struct
  {
  unsigned PWM6OFL0             : 1;
  unsigned PWM6OFL1             : 1;
  unsigned PWM6OFL2             : 1;
  unsigned PWM6OFL3             : 1;
  unsigned PWM6OFL4             : 1;
  unsigned PWM6OFL5             : 1;
  unsigned PWM6OFL6             : 1;
  unsigned PWM6OFL7             : 1;
  } __PWM6OFLbits_t;

extern __at(0x0DA7) volatile __PWM6OFLbits_t PWM6OFLbits;

#define _PWM6OFL0               0x01
#define _PWM6OFL1               0x02
#define _PWM6OFL2               0x04
#define _PWM6OFL3               0x08
#define _PWM6OFL4               0x10
#define _PWM6OFL5               0x20
#define _PWM6OFL6               0x40
#define _PWM6OFL7               0x80

//==============================================================================


//==============================================================================
//        PWM6OFH Bits

extern __at(0x0DA8) __sfr PWM6OFH;

typedef struct
  {
  unsigned PWM6OFH0             : 1;
  unsigned PWM6OFH1             : 1;
  unsigned PWM6OFH2             : 1;
  unsigned PWM6OFH3             : 1;
  unsigned PWM6OFH4             : 1;
  unsigned PWM6OFH5             : 1;
  unsigned PWM6OFH6             : 1;
  unsigned PWM6OFH7             : 1;
  } __PWM6OFHbits_t;

extern __at(0x0DA8) volatile __PWM6OFHbits_t PWM6OFHbits;

#define _PWM6OFH0               0x01
#define _PWM6OFH1               0x02
#define _PWM6OFH2               0x04
#define _PWM6OFH3               0x08
#define _PWM6OFH4               0x10
#define _PWM6OFH5               0x20
#define _PWM6OFH6               0x40
#define _PWM6OFH7               0x80

//==============================================================================

extern __at(0x0DA9) __sfr PWM6TMR;

//==============================================================================
//        PWM6TMRL Bits

extern __at(0x0DA9) __sfr PWM6TMRL;

typedef struct
  {
  unsigned PWM6TMRL0            : 1;
  unsigned PWM6TMRL1            : 1;
  unsigned PWM6TMRL2            : 1;
  unsigned PWM6TMRL3            : 1;
  unsigned PWM6TMRL4            : 1;
  unsigned PWM6TMRL5            : 1;
  unsigned PWM6TMRL6            : 1;
  unsigned PWM6TMRL7            : 1;
  } __PWM6TMRLbits_t;

extern __at(0x0DA9) volatile __PWM6TMRLbits_t PWM6TMRLbits;

#define _PWM6TMRL0              0x01
#define _PWM6TMRL1              0x02
#define _PWM6TMRL2              0x04
#define _PWM6TMRL3              0x08
#define _PWM6TMRL4              0x10
#define _PWM6TMRL5              0x20
#define _PWM6TMRL6              0x40
#define _PWM6TMRL7              0x80

//==============================================================================


//==============================================================================
//        PWM6TMRH Bits

extern __at(0x0DAA) __sfr PWM6TMRH;

typedef struct
  {
  unsigned PWM6TMRH0            : 1;
  unsigned PWM6TMRH1            : 1;
  unsigned PWM6TMRH2            : 1;
  unsigned PWM6TMRH3            : 1;
  unsigned PWM6TMRH4            : 1;
  unsigned PWM6TMRH5            : 1;
  unsigned PWM6TMRH6            : 1;
  unsigned PWM6TMRH7            : 1;
  } __PWM6TMRHbits_t;

extern __at(0x0DAA) volatile __PWM6TMRHbits_t PWM6TMRHbits;

#define _PWM6TMRH0              0x01
#define _PWM6TMRH1              0x02
#define _PWM6TMRH2              0x04
#define _PWM6TMRH3              0x08
#define _PWM6TMRH4              0x10
#define _PWM6TMRH5              0x20
#define _PWM6TMRH6              0x40
#define _PWM6TMRH7              0x80

//==============================================================================


//==============================================================================
//        PWM6CON Bits

extern __at(0x0DAB) __sfr PWM6CON;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWM6MODE0          : 1;
    unsigned PWM6MODE1          : 1;
    unsigned POL                : 1;
    unsigned OUT                : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned PWM6POL            : 1;
    unsigned PWM6OUT            : 1;
    unsigned                    : 1;
    unsigned PWM6EN             : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PWM6MODE           : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 2;
    unsigned MODE               : 2;
    unsigned                    : 4;
    };
  } __PWM6CONbits_t;

extern __at(0x0DAB) volatile __PWM6CONbits_t PWM6CONbits;

#define _PWM6CON_PWM6MODE0      0x04
#define _PWM6CON_MODE0          0x04
#define _PWM6CON_PWM6MODE1      0x08
#define _PWM6CON_MODE1          0x08
#define _PWM6CON_POL            0x10
#define _PWM6CON_PWM6POL        0x10
#define _PWM6CON_OUT            0x20
#define _PWM6CON_PWM6OUT        0x20
#define _PWM6CON_EN             0x80
#define _PWM6CON_PWM6EN         0x80

//==============================================================================


//==============================================================================
//        PWM6INTCON Bits

extern __at(0x0DAC) __sfr PWM6INTCON;

typedef union
  {
  struct
    {
    unsigned PRIE               : 1;
    unsigned DCIE               : 1;
    unsigned PHIE               : 1;
    unsigned OFIE               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PWM6PRIE           : 1;
    unsigned PWM6DCIE           : 1;
    unsigned PWM6PHIE           : 1;
    unsigned PWM6OFIE           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PWM6INTCONbits_t;

extern __at(0x0DAC) volatile __PWM6INTCONbits_t PWM6INTCONbits;

#define _PWM6INTCON_PRIE        0x01
#define _PWM6INTCON_PWM6PRIE    0x01
#define _PWM6INTCON_DCIE        0x02
#define _PWM6INTCON_PWM6DCIE    0x02
#define _PWM6INTCON_PHIE        0x04
#define _PWM6INTCON_PWM6PHIE    0x04
#define _PWM6INTCON_OFIE        0x08
#define _PWM6INTCON_PWM6OFIE    0x08

//==============================================================================


//==============================================================================
//        PWM6INTE Bits

extern __at(0x0DAC) __sfr PWM6INTE;

typedef union
  {
  struct
    {
    unsigned PRIE               : 1;
    unsigned DCIE               : 1;
    unsigned PHIE               : 1;
    unsigned OFIE               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PWM6PRIE           : 1;
    unsigned PWM6DCIE           : 1;
    unsigned PWM6PHIE           : 1;
    unsigned PWM6OFIE           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PWM6INTEbits_t;

extern __at(0x0DAC) volatile __PWM6INTEbits_t PWM6INTEbits;

#define _PWM6INTE_PRIE          0x01
#define _PWM6INTE_PWM6PRIE      0x01
#define _PWM6INTE_DCIE          0x02
#define _PWM6INTE_PWM6DCIE      0x02
#define _PWM6INTE_PHIE          0x04
#define _PWM6INTE_PWM6PHIE      0x04
#define _PWM6INTE_OFIE          0x08
#define _PWM6INTE_PWM6OFIE      0x08

//==============================================================================


//==============================================================================
//        PWM6INTF Bits

extern __at(0x0DAD) __sfr PWM6INTF;

typedef union
  {
  struct
    {
    unsigned PRIF               : 1;
    unsigned DCIF               : 1;
    unsigned PHIF               : 1;
    unsigned OFIF               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PWM6PRIF           : 1;
    unsigned PWM6DCIF           : 1;
    unsigned PWM6PHIF           : 1;
    unsigned PWM6OFIF           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PWM6INTFbits_t;

extern __at(0x0DAD) volatile __PWM6INTFbits_t PWM6INTFbits;

#define _PWM6INTF_PRIF          0x01
#define _PWM6INTF_PWM6PRIF      0x01
#define _PWM6INTF_DCIF          0x02
#define _PWM6INTF_PWM6DCIF      0x02
#define _PWM6INTF_PHIF          0x04
#define _PWM6INTF_PWM6PHIF      0x04
#define _PWM6INTF_OFIF          0x08
#define _PWM6INTF_PWM6OFIF      0x08

//==============================================================================


//==============================================================================
//        PWM6INTFLG Bits

extern __at(0x0DAD) __sfr PWM6INTFLG;

typedef union
  {
  struct
    {
    unsigned PRIF               : 1;
    unsigned DCIF               : 1;
    unsigned PHIF               : 1;
    unsigned OFIF               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PWM6PRIF           : 1;
    unsigned PWM6DCIF           : 1;
    unsigned PWM6PHIF           : 1;
    unsigned PWM6OFIF           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PWM6INTFLGbits_t;

extern __at(0x0DAD) volatile __PWM6INTFLGbits_t PWM6INTFLGbits;

#define _PWM6INTFLG_PRIF        0x01
#define _PWM6INTFLG_PWM6PRIF    0x01
#define _PWM6INTFLG_DCIF        0x02
#define _PWM6INTFLG_PWM6DCIF    0x02
#define _PWM6INTFLG_PHIF        0x04
#define _PWM6INTFLG_PWM6PHIF    0x04
#define _PWM6INTFLG_OFIF        0x08
#define _PWM6INTFLG_PWM6OFIF    0x08

//==============================================================================


//==============================================================================
//        PWM6CLKCON Bits

extern __at(0x0DAE) __sfr PWM6CLKCON;

typedef union
  {
  struct
    {
    unsigned PWM6CS0            : 1;
    unsigned PWM6CS1            : 1;
    unsigned PWM6CS2            : 1;
    unsigned                    : 1;
    unsigned PWM6PS0            : 1;
    unsigned PWM6PS1            : 1;
    unsigned PWM6PS2            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CS0                : 1;
    unsigned CS1                : 1;
    unsigned CS2                : 1;
    unsigned                    : 1;
    unsigned PS0                : 1;
    unsigned PS1                : 1;
    unsigned PS2                : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PWM6CS             : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned CS                 : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 4;
    unsigned PS                 : 3;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned PWM6PS             : 3;
    unsigned                    : 1;
    };
  } __PWM6CLKCONbits_t;

extern __at(0x0DAE) volatile __PWM6CLKCONbits_t PWM6CLKCONbits;

#define _PWM6CLKCON_PWM6CS0     0x01
#define _PWM6CLKCON_CS0         0x01
#define _PWM6CLKCON_PWM6CS1     0x02
#define _PWM6CLKCON_CS1         0x02
#define _PWM6CLKCON_PWM6CS2     0x04
#define _PWM6CLKCON_CS2         0x04
#define _PWM6CLKCON_PWM6PS0     0x10
#define _PWM6CLKCON_PS0         0x10
#define _PWM6CLKCON_PWM6PS1     0x20
#define _PWM6CLKCON_PS1         0x20
#define _PWM6CLKCON_PWM6PS2     0x40
#define _PWM6CLKCON_PS2         0x40

//==============================================================================


//==============================================================================
//        PWM6LDCON Bits

extern __at(0x0DAF) __sfr PWM6LDCON;

typedef union
  {
  struct
    {
    unsigned PWM6LDS0           : 1;
    unsigned PWM6LDS1           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LDT                : 1;
    unsigned LDA                : 1;
    };

  struct
    {
    unsigned LDS0               : 1;
    unsigned LDS1               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWM6LDM            : 1;
    unsigned PWM6LD             : 1;
    };

  struct
    {
    unsigned PWM6LDS            : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned LDS                : 2;
    unsigned                    : 6;
    };
  } __PWM6LDCONbits_t;

extern __at(0x0DAF) volatile __PWM6LDCONbits_t PWM6LDCONbits;

#define _PWM6LDCON_PWM6LDS0     0x01
#define _PWM6LDCON_LDS0         0x01
#define _PWM6LDCON_PWM6LDS1     0x02
#define _PWM6LDCON_LDS1         0x02
#define _PWM6LDCON_LDT          0x40
#define _PWM6LDCON_PWM6LDM      0x40
#define _PWM6LDCON_LDA          0x80
#define _PWM6LDCON_PWM6LD       0x80

//==============================================================================


//==============================================================================
//        PWM6OFCON Bits

extern __at(0x0DB0) __sfr PWM6OFCON;

typedef union
  {
  struct
    {
    unsigned PWM6OFS0           : 1;
    unsigned PWM6OFS1           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned OFO                : 1;
    unsigned PWM6OFM0           : 1;
    unsigned PWM6OFM1           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned OFS0               : 1;
    unsigned OFS1               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWM6OFMC           : 1;
    unsigned OFM0               : 1;
    unsigned OFM1               : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PWM6OFS            : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned OFS                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 5;
    unsigned OFM                : 2;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned PWM6OFM            : 2;
    unsigned                    : 1;
    };
  } __PWM6OFCONbits_t;

extern __at(0x0DB0) volatile __PWM6OFCONbits_t PWM6OFCONbits;

#define _PWM6OFCON_PWM6OFS0     0x01
#define _PWM6OFCON_OFS0         0x01
#define _PWM6OFCON_PWM6OFS1     0x02
#define _PWM6OFCON_OFS1         0x02
#define _PWM6OFCON_OFO          0x10
#define _PWM6OFCON_PWM6OFMC     0x10
#define _PWM6OFCON_PWM6OFM0     0x20
#define _PWM6OFCON_OFM0         0x20
#define _PWM6OFCON_PWM6OFM1     0x40
#define _PWM6OFCON_OFM1         0x40

//==============================================================================

extern __at(0x0DB1) __sfr PWM11PH;

//==============================================================================
//        PWM11PHL Bits

extern __at(0x0DB1) __sfr PWM11PHL;

typedef struct
  {
  unsigned PWM11PHL0            : 1;
  unsigned PWM11PHL1            : 1;
  unsigned PWM11PHL2            : 1;
  unsigned PWM11PHL3            : 1;
  unsigned PWM11PHL4            : 1;
  unsigned PWM11PHL5            : 1;
  unsigned PWM11PHL6            : 1;
  unsigned PWM11PHL7            : 1;
  } __PWM11PHLbits_t;

extern __at(0x0DB1) volatile __PWM11PHLbits_t PWM11PHLbits;

#define _PWM11PHL0              0x01
#define _PWM11PHL1              0x02
#define _PWM11PHL2              0x04
#define _PWM11PHL3              0x08
#define _PWM11PHL4              0x10
#define _PWM11PHL5              0x20
#define _PWM11PHL6              0x40
#define _PWM11PHL7              0x80

//==============================================================================


//==============================================================================
//        PWM11PHH Bits

extern __at(0x0DB2) __sfr PWM11PHH;

typedef struct
  {
  unsigned PWM11PHH0            : 1;
  unsigned PWM11PHH1            : 1;
  unsigned PWM11PHH2            : 1;
  unsigned PWM11PHH3            : 1;
  unsigned PWM11PHH4            : 1;
  unsigned PWM11PHH5            : 1;
  unsigned PWM11PHH6            : 1;
  unsigned PWM11PHH7            : 1;
  } __PWM11PHHbits_t;

extern __at(0x0DB2) volatile __PWM11PHHbits_t PWM11PHHbits;

#define _PWM11PHH0              0x01
#define _PWM11PHH1              0x02
#define _PWM11PHH2              0x04
#define _PWM11PHH3              0x08
#define _PWM11PHH4              0x10
#define _PWM11PHH5              0x20
#define _PWM11PHH6              0x40
#define _PWM11PHH7              0x80

//==============================================================================

extern __at(0x0DB3) __sfr PWM11DC;

//==============================================================================
//        PWM11DCL Bits

extern __at(0x0DB3) __sfr PWM11DCL;

typedef struct
  {
  unsigned PWM11DCL0            : 1;
  unsigned PWM11DCL1            : 1;
  unsigned PWM11DCL2            : 1;
  unsigned PWM11DCL3            : 1;
  unsigned PWM11DCL4            : 1;
  unsigned PWM11DCL5            : 1;
  unsigned PWM11DCL6            : 1;
  unsigned PWM11DCL7            : 1;
  } __PWM11DCLbits_t;

extern __at(0x0DB3) volatile __PWM11DCLbits_t PWM11DCLbits;

#define _PWM11DCL0              0x01
#define _PWM11DCL1              0x02
#define _PWM11DCL2              0x04
#define _PWM11DCL3              0x08
#define _PWM11DCL4              0x10
#define _PWM11DCL5              0x20
#define _PWM11DCL6              0x40
#define _PWM11DCL7              0x80

//==============================================================================


//==============================================================================
//        PWM11DCH Bits

extern __at(0x0DB4) __sfr PWM11DCH;

typedef struct
  {
  unsigned PWM11DCH0            : 1;
  unsigned PWM11DCH1            : 1;
  unsigned PWM11DCH2            : 1;
  unsigned PWM11DCH3            : 1;
  unsigned PWM11DCH4            : 1;
  unsigned PWM11DCH5            : 1;
  unsigned PWM11DCH6            : 1;
  unsigned PWM11DCH7            : 1;
  } __PWM11DCHbits_t;

extern __at(0x0DB4) volatile __PWM11DCHbits_t PWM11DCHbits;

#define _PWM11DCH0              0x01
#define _PWM11DCH1              0x02
#define _PWM11DCH2              0x04
#define _PWM11DCH3              0x08
#define _PWM11DCH4              0x10
#define _PWM11DCH5              0x20
#define _PWM11DCH6              0x40
#define _PWM11DCH7              0x80

//==============================================================================

extern __at(0x0DB5) __sfr PWM11PR;

//==============================================================================
//        PWM11PRL Bits

extern __at(0x0DB5) __sfr PWM11PRL;

typedef struct
  {
  unsigned PWM11PRL0            : 1;
  unsigned PWM11PRL1            : 1;
  unsigned PWM11PRL2            : 1;
  unsigned PWM11PRL3            : 1;
  unsigned PWM11PRL4            : 1;
  unsigned PWM11PRL5            : 1;
  unsigned PWM11PRL6            : 1;
  unsigned PWM11PRL7            : 1;
  } __PWM11PRLbits_t;

extern __at(0x0DB5) volatile __PWM11PRLbits_t PWM11PRLbits;

#define _PWM11PRL0              0x01
#define _PWM11PRL1              0x02
#define _PWM11PRL2              0x04
#define _PWM11PRL3              0x08
#define _PWM11PRL4              0x10
#define _PWM11PRL5              0x20
#define _PWM11PRL6              0x40
#define _PWM11PRL7              0x80

//==============================================================================


//==============================================================================
//        PWM11PRH Bits

extern __at(0x0DB6) __sfr PWM11PRH;

typedef struct
  {
  unsigned PWM11PRH0            : 1;
  unsigned PWM11PRH1            : 1;
  unsigned PWM11PRH2            : 1;
  unsigned PWM11PRH3            : 1;
  unsigned PWM11PRH4            : 1;
  unsigned PWM11PRH5            : 1;
  unsigned PWM11PRH6            : 1;
  unsigned PWM11PRH7            : 1;
  } __PWM11PRHbits_t;

extern __at(0x0DB6) volatile __PWM11PRHbits_t PWM11PRHbits;

#define _PWM11PRH0              0x01
#define _PWM11PRH1              0x02
#define _PWM11PRH2              0x04
#define _PWM11PRH3              0x08
#define _PWM11PRH4              0x10
#define _PWM11PRH5              0x20
#define _PWM11PRH6              0x40
#define _PWM11PRH7              0x80

//==============================================================================

extern __at(0x0DB7) __sfr PWM11OF;

//==============================================================================
//        PWM11OFL Bits

extern __at(0x0DB7) __sfr PWM11OFL;

typedef struct
  {
  unsigned PWM11OFL0            : 1;
  unsigned PWM11OFL1            : 1;
  unsigned PWM11OFL2            : 1;
  unsigned PWM11OFL3            : 1;
  unsigned PWM11OFL4            : 1;
  unsigned PWM11OFL5            : 1;
  unsigned PWM11OFL6            : 1;
  unsigned PWM11OFL7            : 1;
  } __PWM11OFLbits_t;

extern __at(0x0DB7) volatile __PWM11OFLbits_t PWM11OFLbits;

#define _PWM11OFL0              0x01
#define _PWM11OFL1              0x02
#define _PWM11OFL2              0x04
#define _PWM11OFL3              0x08
#define _PWM11OFL4              0x10
#define _PWM11OFL5              0x20
#define _PWM11OFL6              0x40
#define _PWM11OFL7              0x80

//==============================================================================


//==============================================================================
//        PWM11OFH Bits

extern __at(0x0DB8) __sfr PWM11OFH;

typedef struct
  {
  unsigned PWM11OFH0            : 1;
  unsigned PWM11OFH1            : 1;
  unsigned PWM11OFH2            : 1;
  unsigned PWM11OFH3            : 1;
  unsigned PWM11OFH4            : 1;
  unsigned PWM11OFH5            : 1;
  unsigned PWM11OFH6            : 1;
  unsigned PWM11OFH7            : 1;
  } __PWM11OFHbits_t;

extern __at(0x0DB8) volatile __PWM11OFHbits_t PWM11OFHbits;

#define _PWM11OFH0              0x01
#define _PWM11OFH1              0x02
#define _PWM11OFH2              0x04
#define _PWM11OFH3              0x08
#define _PWM11OFH4              0x10
#define _PWM11OFH5              0x20
#define _PWM11OFH6              0x40
#define _PWM11OFH7              0x80

//==============================================================================

extern __at(0x0DB9) __sfr PWM11TMR;

//==============================================================================
//        PWM11TMRL Bits

extern __at(0x0DB9) __sfr PWM11TMRL;

typedef struct
  {
  unsigned PWM11TMRL0           : 1;
  unsigned PWM11TMRL1           : 1;
  unsigned PWM11TMRL2           : 1;
  unsigned PWM11TMRL3           : 1;
  unsigned PWM11TMRL4           : 1;
  unsigned PWM11TMRL5           : 1;
  unsigned PWM11TMRL6           : 1;
  unsigned PWM11TMRL7           : 1;
  } __PWM11TMRLbits_t;

extern __at(0x0DB9) volatile __PWM11TMRLbits_t PWM11TMRLbits;

#define _PWM11TMRL0             0x01
#define _PWM11TMRL1             0x02
#define _PWM11TMRL2             0x04
#define _PWM11TMRL3             0x08
#define _PWM11TMRL4             0x10
#define _PWM11TMRL5             0x20
#define _PWM11TMRL6             0x40
#define _PWM11TMRL7             0x80

//==============================================================================


//==============================================================================
//        PWM11TMRH Bits

extern __at(0x0DBA) __sfr PWM11TMRH;

typedef struct
  {
  unsigned PWM11TMRH0           : 1;
  unsigned PWM11TMRH1           : 1;
  unsigned PWM11TMRH2           : 1;
  unsigned PWM11TMRH3           : 1;
  unsigned PWM11TMRH4           : 1;
  unsigned PWM11TMRH5           : 1;
  unsigned PWM11TMRH6           : 1;
  unsigned PWM11TMRH7           : 1;
  } __PWM11TMRHbits_t;

extern __at(0x0DBA) volatile __PWM11TMRHbits_t PWM11TMRHbits;

#define _PWM11TMRH0             0x01
#define _PWM11TMRH1             0x02
#define _PWM11TMRH2             0x04
#define _PWM11TMRH3             0x08
#define _PWM11TMRH4             0x10
#define _PWM11TMRH5             0x20
#define _PWM11TMRH6             0x40
#define _PWM11TMRH7             0x80

//==============================================================================


//==============================================================================
//        PWM11CON Bits

extern __at(0x0DBB) __sfr PWM11CON;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWM11MODE0         : 1;
    unsigned PWM11MODE1         : 1;
    unsigned POL                : 1;
    unsigned OUT                : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned PWM11POL           : 1;
    unsigned PWM11OUT           : 1;
    unsigned                    : 1;
    unsigned PWM11EN            : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PWM11MODE          : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 2;
    unsigned MODE               : 2;
    unsigned                    : 4;
    };
  } __PWM11CONbits_t;

extern __at(0x0DBB) volatile __PWM11CONbits_t PWM11CONbits;

#define _PWM11CON_PWM11MODE0    0x04
#define _PWM11CON_MODE0         0x04
#define _PWM11CON_PWM11MODE1    0x08
#define _PWM11CON_MODE1         0x08
#define _PWM11CON_POL           0x10
#define _PWM11CON_PWM11POL      0x10
#define _PWM11CON_OUT           0x20
#define _PWM11CON_PWM11OUT      0x20
#define _PWM11CON_EN            0x80
#define _PWM11CON_PWM11EN       0x80

//==============================================================================


//==============================================================================
//        PWM11INTCON Bits

extern __at(0x0DBC) __sfr PWM11INTCON;

typedef union
  {
  struct
    {
    unsigned PRIE               : 1;
    unsigned DCIE               : 1;
    unsigned PHIE               : 1;
    unsigned OFIE               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PWM11PRIE          : 1;
    unsigned PWM11DCIE          : 1;
    unsigned PWM11PHIE          : 1;
    unsigned PWM11OFIE          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PWM11INTCONbits_t;

extern __at(0x0DBC) volatile __PWM11INTCONbits_t PWM11INTCONbits;

#define _PWM11INTCON_PRIE       0x01
#define _PWM11INTCON_PWM11PRIE  0x01
#define _PWM11INTCON_DCIE       0x02
#define _PWM11INTCON_PWM11DCIE  0x02
#define _PWM11INTCON_PHIE       0x04
#define _PWM11INTCON_PWM11PHIE  0x04
#define _PWM11INTCON_OFIE       0x08
#define _PWM11INTCON_PWM11OFIE  0x08

//==============================================================================


//==============================================================================
//        PWM11INTE Bits

extern __at(0x0DBC) __sfr PWM11INTE;

typedef union
  {
  struct
    {
    unsigned PRIE               : 1;
    unsigned DCIE               : 1;
    unsigned PHIE               : 1;
    unsigned OFIE               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PWM11PRIE          : 1;
    unsigned PWM11DCIE          : 1;
    unsigned PWM11PHIE          : 1;
    unsigned PWM11OFIE          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PWM11INTEbits_t;

extern __at(0x0DBC) volatile __PWM11INTEbits_t PWM11INTEbits;

#define _PWM11INTE_PRIE         0x01
#define _PWM11INTE_PWM11PRIE    0x01
#define _PWM11INTE_DCIE         0x02
#define _PWM11INTE_PWM11DCIE    0x02
#define _PWM11INTE_PHIE         0x04
#define _PWM11INTE_PWM11PHIE    0x04
#define _PWM11INTE_OFIE         0x08
#define _PWM11INTE_PWM11OFIE    0x08

//==============================================================================


//==============================================================================
//        PWM11INTF Bits

extern __at(0x0DBD) __sfr PWM11INTF;

typedef union
  {
  struct
    {
    unsigned PRIF               : 1;
    unsigned DCIF               : 1;
    unsigned PHIF               : 1;
    unsigned OFIF               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PWM11PRIF          : 1;
    unsigned PWM11DCIF          : 1;
    unsigned PWM11PHIF          : 1;
    unsigned PWM11OFIF          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PWM11INTFbits_t;

extern __at(0x0DBD) volatile __PWM11INTFbits_t PWM11INTFbits;

#define _PWM11INTF_PRIF         0x01
#define _PWM11INTF_PWM11PRIF    0x01
#define _PWM11INTF_DCIF         0x02
#define _PWM11INTF_PWM11DCIF    0x02
#define _PWM11INTF_PHIF         0x04
#define _PWM11INTF_PWM11PHIF    0x04
#define _PWM11INTF_OFIF         0x08
#define _PWM11INTF_PWM11OFIF    0x08

//==============================================================================


//==============================================================================
//        PWM11INTFLG Bits

extern __at(0x0DBD) __sfr PWM11INTFLG;

typedef union
  {
  struct
    {
    unsigned PRIF               : 1;
    unsigned DCIF               : 1;
    unsigned PHIF               : 1;
    unsigned OFIF               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PWM11PRIF          : 1;
    unsigned PWM11DCIF          : 1;
    unsigned PWM11PHIF          : 1;
    unsigned PWM11OFIF          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PWM11INTFLGbits_t;

extern __at(0x0DBD) volatile __PWM11INTFLGbits_t PWM11INTFLGbits;

#define _PWM11INTFLG_PRIF       0x01
#define _PWM11INTFLG_PWM11PRIF  0x01
#define _PWM11INTFLG_DCIF       0x02
#define _PWM11INTFLG_PWM11DCIF  0x02
#define _PWM11INTFLG_PHIF       0x04
#define _PWM11INTFLG_PWM11PHIF  0x04
#define _PWM11INTFLG_OFIF       0x08
#define _PWM11INTFLG_PWM11OFIF  0x08

//==============================================================================


//==============================================================================
//        PWM11CLKCON Bits

extern __at(0x0DBE) __sfr PWM11CLKCON;

typedef union
  {
  struct
    {
    unsigned PWM11CS0           : 1;
    unsigned PWM11CS1           : 1;
    unsigned PWM11CS2           : 1;
    unsigned                    : 1;
    unsigned PWM11PS0           : 1;
    unsigned PWM11PS1           : 1;
    unsigned PWM11PS2           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CS0                : 1;
    unsigned CS1                : 1;
    unsigned CS2                : 1;
    unsigned                    : 1;
    unsigned PS0                : 1;
    unsigned PS1                : 1;
    unsigned PS2                : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PWM11CS            : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned CS                 : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 4;
    unsigned PS                 : 3;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned PWM11PS            : 3;
    unsigned                    : 1;
    };
  } __PWM11CLKCONbits_t;

extern __at(0x0DBE) volatile __PWM11CLKCONbits_t PWM11CLKCONbits;

#define _PWM11CLKCON_PWM11CS0   0x01
#define _PWM11CLKCON_CS0        0x01
#define _PWM11CLKCON_PWM11CS1   0x02
#define _PWM11CLKCON_CS1        0x02
#define _PWM11CLKCON_PWM11CS2   0x04
#define _PWM11CLKCON_CS2        0x04
#define _PWM11CLKCON_PWM11PS0   0x10
#define _PWM11CLKCON_PS0        0x10
#define _PWM11CLKCON_PWM11PS1   0x20
#define _PWM11CLKCON_PS1        0x20
#define _PWM11CLKCON_PWM11PS2   0x40
#define _PWM11CLKCON_PS2        0x40

//==============================================================================


//==============================================================================
//        PWM11LDCON Bits

extern __at(0x0DBF) __sfr PWM11LDCON;

typedef union
  {
  struct
    {
    unsigned PWM11LDS0          : 1;
    unsigned PWM11LDS1          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LDT                : 1;
    unsigned LDA                : 1;
    };

  struct
    {
    unsigned LDS0               : 1;
    unsigned LDS1               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWM11LDM           : 1;
    unsigned PWM11LD            : 1;
    };

  struct
    {
    unsigned PWM11LDS           : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned LDS                : 2;
    unsigned                    : 6;
    };
  } __PWM11LDCONbits_t;

extern __at(0x0DBF) volatile __PWM11LDCONbits_t PWM11LDCONbits;

#define _PWM11LDCON_PWM11LDS0   0x01
#define _PWM11LDCON_LDS0        0x01
#define _PWM11LDCON_PWM11LDS1   0x02
#define _PWM11LDCON_LDS1        0x02
#define _PWM11LDCON_LDT         0x40
#define _PWM11LDCON_PWM11LDM    0x40
#define _PWM11LDCON_LDA         0x80
#define _PWM11LDCON_PWM11LD     0x80

//==============================================================================


//==============================================================================
//        PWM11OFCON Bits

extern __at(0x0DC0) __sfr PWM11OFCON;

typedef union
  {
  struct
    {
    unsigned PWM11OFS0          : 1;
    unsigned PWM11OFS1          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned OFO                : 1;
    unsigned PWM11OFM0          : 1;
    unsigned PWM11OFM1          : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned OFS0               : 1;
    unsigned OFS1               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWM11OFMC          : 1;
    unsigned OFM0               : 1;
    unsigned OFM1               : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned OFS                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned PWM11OFS           : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 5;
    unsigned OFM                : 2;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned PWM11OFM           : 2;
    unsigned                    : 1;
    };
  } __PWM11OFCONbits_t;

extern __at(0x0DC0) volatile __PWM11OFCONbits_t PWM11OFCONbits;

#define _PWM11OFCON_PWM11OFS0   0x01
#define _PWM11OFCON_OFS0        0x01
#define _PWM11OFCON_PWM11OFS1   0x02
#define _PWM11OFCON_OFS1        0x02
#define _PWM11OFCON_OFO         0x10
#define _PWM11OFCON_PWM11OFMC   0x10
#define _PWM11OFCON_PWM11OFM0   0x20
#define _PWM11OFCON_OFM0        0x20
#define _PWM11OFCON_PWM11OFM1   0x40
#define _PWM11OFCON_OFM1        0x40

//==============================================================================


//==============================================================================
//        PPSLOCK Bits

extern __at(0x0E0C) __sfr PPSLOCK;

typedef struct
  {
  unsigned PPSLOCKED            : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PPSLOCKbits_t;

extern __at(0x0E0C) volatile __PPSLOCKbits_t PPSLOCKbits;

#define _PPSLOCKED              0x01

//==============================================================================

extern __at(0x0E0D) __sfr INTPPS;
extern __at(0x0E0E) __sfr T0CKIPPS;
extern __at(0x0E0F) __sfr T1CKIPPS;
extern __at(0x0E10) __sfr T1GPPS;
extern __at(0x0E11) __sfr T3CKIPPS;
extern __at(0x0E12) __sfr T3GPPS;
extern __at(0x0E13) __sfr T5CKIPPS;
extern __at(0x0E14) __sfr T5GPPS;
extern __at(0x0E15) __sfr T2CKIPPS;
extern __at(0x0E16) __sfr T4CKIPPS;
extern __at(0x0E17) __sfr T6CKIPPS;
extern __at(0x0E18) __sfr T8CKIPPS;
extern __at(0x0E19) __sfr CCP1PPS;
extern __at(0x0E1A) __sfr CCP2PPS;
extern __at(0x0E1B) __sfr CCP7PPS;
extern __at(0x0E1D) __sfr COG1INPPS;
extern __at(0x0E1E) __sfr COG2INPPS;
extern __at(0x0E1F) __sfr COG3INPPS;
extern __at(0x0E21) __sfr MD1CLPPS;
extern __at(0x0E22) __sfr MD1CHPPS;
extern __at(0x0E23) __sfr MD1MODPPS;
extern __at(0x0E24) __sfr MD2CLPPS;
extern __at(0x0E25) __sfr MD2CHPPS;
extern __at(0x0E26) __sfr MD2MODPPS;
extern __at(0x0E27) __sfr MD3CLPPS;
extern __at(0x0E28) __sfr MD3CHPPS;
extern __at(0x0E29) __sfr MD3MODPPS;
extern __at(0x0E2D) __sfr PRG1RPPS;
extern __at(0x0E2E) __sfr PRG1FPPS;
extern __at(0x0E2F) __sfr PRG2RPPS;
extern __at(0x0E30) __sfr PRG2FPPS;
extern __at(0x0E31) __sfr PRG3RPPS;
extern __at(0x0E32) __sfr PRG3FPPS;
extern __at(0x0E35) __sfr CLCIN0PPS;
extern __at(0x0E36) __sfr CLCIN1PPS;
extern __at(0x0E37) __sfr CLCIN2PPS;
extern __at(0x0E38) __sfr CLCIN3PPS;
extern __at(0x0E39) __sfr ADCACTPPS;
extern __at(0x0E3A) __sfr SSPCLKPPS;
extern __at(0x0E3B) __sfr SSPDATPPS;
extern __at(0x0E3C) __sfr SSPSSPPS;
extern __at(0x0E3D) __sfr RXPPS;
extern __at(0x0E3E) __sfr CKPPS;
extern __at(0x0E90) __sfr RA0PPS;
extern __at(0x0E91) __sfr RA1PPS;
extern __at(0x0E92) __sfr RA2PPS;
extern __at(0x0E93) __sfr RA3PPS;
extern __at(0x0E94) __sfr RA4PPS;
extern __at(0x0E95) __sfr RA5PPS;
extern __at(0x0E96) __sfr RA6PPS;
extern __at(0x0E97) __sfr RA7PPS;
extern __at(0x0E98) __sfr RB0PPS;
extern __at(0x0E99) __sfr RB1PPS;
extern __at(0x0E9A) __sfr RB2PPS;
extern __at(0x0E9B) __sfr RB3PPS;
extern __at(0x0E9C) __sfr RB4PPS;
extern __at(0x0E9D) __sfr RB5PPS;
extern __at(0x0E9E) __sfr RB6PPS;
extern __at(0x0E9F) __sfr RB7PPS;
extern __at(0x0EA0) __sfr RC0PPS;
extern __at(0x0EA1) __sfr RC1PPS;
extern __at(0x0EA2) __sfr RC2PPS;
extern __at(0x0EA3) __sfr RC3PPS;
extern __at(0x0EA4) __sfr RC4PPS;
extern __at(0x0EA5) __sfr RC5PPS;
extern __at(0x0EA6) __sfr RC6PPS;
extern __at(0x0EA7) __sfr RC7PPS;

//==============================================================================
//        CLCDATA Bits

extern __at(0x0F0F) __sfr CLCDATA;

typedef struct
  {
  unsigned MCLC1OUT             : 1;
  unsigned MCLC2OUT             : 1;
  unsigned MCLC3OUT             : 1;
  unsigned MLC4OUT              : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __CLCDATAbits_t;

extern __at(0x0F0F) volatile __CLCDATAbits_t CLCDATAbits;

#define _MCLC1OUT               0x01
#define _MCLC2OUT               0x02
#define _MCLC3OUT               0x04
#define _MLC4OUT                0x08

//==============================================================================


//==============================================================================
//        CLC1CON Bits

extern __at(0x0F10) __sfr CLC1CON;

typedef union
  {
  struct
    {
    unsigned LC1MODE0           : 1;
    unsigned LC1MODE1           : 1;
    unsigned LC1MODE2           : 1;
    unsigned LC1INTN            : 1;
    unsigned LC1INTP            : 1;
    unsigned LC1OUT             : 1;
    unsigned                    : 1;
    unsigned LC1EN              : 1;
    };

  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned INTN               : 1;
    unsigned INTP               : 1;
    unsigned OUT                : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned MODE               : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned LC1MODE            : 3;
    unsigned                    : 5;
    };
  } __CLC1CONbits_t;

extern __at(0x0F10) volatile __CLC1CONbits_t CLC1CONbits;

#define _CLC1CON_LC1MODE0       0x01
#define _CLC1CON_MODE0          0x01
#define _CLC1CON_LC1MODE1       0x02
#define _CLC1CON_MODE1          0x02
#define _CLC1CON_LC1MODE2       0x04
#define _CLC1CON_MODE2          0x04
#define _CLC1CON_LC1INTN        0x08
#define _CLC1CON_INTN           0x08
#define _CLC1CON_LC1INTP        0x10
#define _CLC1CON_INTP           0x10
#define _CLC1CON_LC1OUT         0x20
#define _CLC1CON_OUT            0x20
#define _CLC1CON_LC1EN          0x80
#define _CLC1CON_EN             0x80

//==============================================================================


//==============================================================================
//        CLC1POL Bits

extern __at(0x0F11) __sfr CLC1POL;

typedef union
  {
  struct
    {
    unsigned LC1G1POL           : 1;
    unsigned LC1G2POL           : 1;
    unsigned LC1G3POL           : 1;
    unsigned LC1G4POL           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LC1POL             : 1;
    };

  struct
    {
    unsigned G1POL              : 1;
    unsigned G2POL              : 1;
    unsigned G3POL              : 1;
    unsigned G4POL              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned POL                : 1;
    };
  } __CLC1POLbits_t;

extern __at(0x0F11) volatile __CLC1POLbits_t CLC1POLbits;

#define _LC1G1POL               0x01
#define _G1POL                  0x01
#define _LC1G2POL               0x02
#define _G2POL                  0x02
#define _LC1G3POL               0x04
#define _G3POL                  0x04
#define _LC1G4POL               0x08
#define _G4POL                  0x08
#define _LC1POL                 0x80
#define _POL                    0x80

//==============================================================================


//==============================================================================
//        CLC1SEL0 Bits

extern __at(0x0F12) __sfr CLC1SEL0;

typedef union
  {
  struct
    {
    unsigned LC1D1S0            : 1;
    unsigned LC1D1S1            : 1;
    unsigned LC1D1S2            : 1;
    unsigned LC1D1S3            : 1;
    unsigned LC1D1S4            : 1;
    unsigned LC1D1S5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D1S0               : 1;
    unsigned D1S1               : 1;
    unsigned D1S2               : 1;
    unsigned D1S3               : 1;
    unsigned D1S4               : 1;
    unsigned D1S5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LC1D1S             : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned D1S                : 6;
    unsigned                    : 2;
    };
  } __CLC1SEL0bits_t;

extern __at(0x0F12) volatile __CLC1SEL0bits_t CLC1SEL0bits;

#define _LC1D1S0                0x01
#define _D1S0                   0x01
#define _LC1D1S1                0x02
#define _D1S1                   0x02
#define _LC1D1S2                0x04
#define _D1S2                   0x04
#define _LC1D1S3                0x08
#define _D1S3                   0x08
#define _LC1D1S4                0x10
#define _D1S4                   0x10
#define _LC1D1S5                0x20
#define _D1S5                   0x20

//==============================================================================


//==============================================================================
//        CLC1SEL1 Bits

extern __at(0x0F13) __sfr CLC1SEL1;

typedef union
  {
  struct
    {
    unsigned LC1D2S0            : 1;
    unsigned LC1D2S1            : 1;
    unsigned LC1D2S2            : 1;
    unsigned LC1D2S3            : 1;
    unsigned LC1D2S4            : 1;
    unsigned LC1D2S5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D2S0               : 1;
    unsigned D2S1               : 1;
    unsigned D2S2               : 1;
    unsigned D2S3               : 1;
    unsigned D2S4               : 1;
    unsigned D2S5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LC1D2S             : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned D2S                : 6;
    unsigned                    : 2;
    };
  } __CLC1SEL1bits_t;

extern __at(0x0F13) volatile __CLC1SEL1bits_t CLC1SEL1bits;

#define _LC1D2S0                0x01
#define _D2S0                   0x01
#define _LC1D2S1                0x02
#define _D2S1                   0x02
#define _LC1D2S2                0x04
#define _D2S2                   0x04
#define _LC1D2S3                0x08
#define _D2S3                   0x08
#define _LC1D2S4                0x10
#define _D2S4                   0x10
#define _LC1D2S5                0x20
#define _D2S5                   0x20

//==============================================================================


//==============================================================================
//        CLC1SEL2 Bits

extern __at(0x0F14) __sfr CLC1SEL2;

typedef union
  {
  struct
    {
    unsigned LC1D3S0            : 1;
    unsigned LC1D3S1            : 1;
    unsigned LC1D3S2            : 1;
    unsigned LC1D3S3            : 1;
    unsigned LC1D3S4            : 1;
    unsigned LC1D3S5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D3S0               : 1;
    unsigned D3S1               : 1;
    unsigned D3S2               : 1;
    unsigned D3S3               : 1;
    unsigned D3S4               : 1;
    unsigned D3S5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D3S                : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned LC1D3S             : 6;
    unsigned                    : 2;
    };
  } __CLC1SEL2bits_t;

extern __at(0x0F14) volatile __CLC1SEL2bits_t CLC1SEL2bits;

#define _LC1D3S0                0x01
#define _D3S0                   0x01
#define _LC1D3S1                0x02
#define _D3S1                   0x02
#define _LC1D3S2                0x04
#define _D3S2                   0x04
#define _LC1D3S3                0x08
#define _D3S3                   0x08
#define _LC1D3S4                0x10
#define _D3S4                   0x10
#define _LC1D3S5                0x20
#define _D3S5                   0x20

//==============================================================================


//==============================================================================
//        CLC1SEL3 Bits

extern __at(0x0F15) __sfr CLC1SEL3;

typedef union
  {
  struct
    {
    unsigned LC1D4S0            : 1;
    unsigned LC1D4S1            : 1;
    unsigned LC1D4S2            : 1;
    unsigned LC1D4S3            : 1;
    unsigned LC1D4S4            : 1;
    unsigned LC1D4S5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D4S0               : 1;
    unsigned D4S1               : 1;
    unsigned D4S2               : 1;
    unsigned D4S3               : 1;
    unsigned D4S4               : 1;
    unsigned D4S5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LC1D4S             : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned D4S                : 6;
    unsigned                    : 2;
    };
  } __CLC1SEL3bits_t;

extern __at(0x0F15) volatile __CLC1SEL3bits_t CLC1SEL3bits;

#define _LC1D4S0                0x01
#define _D4S0                   0x01
#define _LC1D4S1                0x02
#define _D4S1                   0x02
#define _LC1D4S2                0x04
#define _D4S2                   0x04
#define _LC1D4S3                0x08
#define _D4S3                   0x08
#define _LC1D4S4                0x10
#define _D4S4                   0x10
#define _LC1D4S5                0x20
#define _D4S5                   0x20

//==============================================================================


//==============================================================================
//        CLC1GLS0 Bits

extern __at(0x0F16) __sfr CLC1GLS0;

typedef union
  {
  struct
    {
    unsigned LC1G1D1N           : 1;
    unsigned LC1G1D1T           : 1;
    unsigned LC1G1D2N           : 1;
    unsigned LC1G1D2T           : 1;
    unsigned LC1G1D3N           : 1;
    unsigned LC1G1D3T           : 1;
    unsigned LC1G1D4N           : 1;
    unsigned LC1G1D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC1GLS0bits_t;

extern __at(0x0F16) volatile __CLC1GLS0bits_t CLC1GLS0bits;

#define _LC1G1D1N               0x01
#define _D1N                    0x01
#define _LC1G1D1T               0x02
#define _D1T                    0x02
#define _LC1G1D2N               0x04
#define _D2N                    0x04
#define _LC1G1D2T               0x08
#define _D2T                    0x08
#define _LC1G1D3N               0x10
#define _D3N                    0x10
#define _LC1G1D3T               0x20
#define _D3T                    0x20
#define _LC1G1D4N               0x40
#define _D4N                    0x40
#define _LC1G1D4T               0x80
#define _D4T                    0x80

//==============================================================================


//==============================================================================
//        CLC1GLS1 Bits

extern __at(0x0F17) __sfr CLC1GLS1;

typedef union
  {
  struct
    {
    unsigned LC1G2D1N           : 1;
    unsigned LC1G2D1T           : 1;
    unsigned LC1G2D2N           : 1;
    unsigned LC1G2D2T           : 1;
    unsigned LC1G2D3N           : 1;
    unsigned LC1G2D3T           : 1;
    unsigned LC1G2D4N           : 1;
    unsigned LC1G2D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC1GLS1bits_t;

extern __at(0x0F17) volatile __CLC1GLS1bits_t CLC1GLS1bits;

#define _CLC1GLS1_LC1G2D1N      0x01
#define _CLC1GLS1_D1N           0x01
#define _CLC1GLS1_LC1G2D1T      0x02
#define _CLC1GLS1_D1T           0x02
#define _CLC1GLS1_LC1G2D2N      0x04
#define _CLC1GLS1_D2N           0x04
#define _CLC1GLS1_LC1G2D2T      0x08
#define _CLC1GLS1_D2T           0x08
#define _CLC1GLS1_LC1G2D3N      0x10
#define _CLC1GLS1_D3N           0x10
#define _CLC1GLS1_LC1G2D3T      0x20
#define _CLC1GLS1_D3T           0x20
#define _CLC1GLS1_LC1G2D4N      0x40
#define _CLC1GLS1_D4N           0x40
#define _CLC1GLS1_LC1G2D4T      0x80
#define _CLC1GLS1_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC1GLS2 Bits

extern __at(0x0F18) __sfr CLC1GLS2;

typedef union
  {
  struct
    {
    unsigned LC1G3D1N           : 1;
    unsigned LC1G3D1T           : 1;
    unsigned LC1G3D2N           : 1;
    unsigned LC1G3D2T           : 1;
    unsigned LC1G3D3N           : 1;
    unsigned LC1G3D3T           : 1;
    unsigned LC1G3D4N           : 1;
    unsigned LC1G3D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC1GLS2bits_t;

extern __at(0x0F18) volatile __CLC1GLS2bits_t CLC1GLS2bits;

#define _CLC1GLS2_LC1G3D1N      0x01
#define _CLC1GLS2_D1N           0x01
#define _CLC1GLS2_LC1G3D1T      0x02
#define _CLC1GLS2_D1T           0x02
#define _CLC1GLS2_LC1G3D2N      0x04
#define _CLC1GLS2_D2N           0x04
#define _CLC1GLS2_LC1G3D2T      0x08
#define _CLC1GLS2_D2T           0x08
#define _CLC1GLS2_LC1G3D3N      0x10
#define _CLC1GLS2_D3N           0x10
#define _CLC1GLS2_LC1G3D3T      0x20
#define _CLC1GLS2_D3T           0x20
#define _CLC1GLS2_LC1G3D4N      0x40
#define _CLC1GLS2_D4N           0x40
#define _CLC1GLS2_LC1G3D4T      0x80
#define _CLC1GLS2_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC1GLS3 Bits

extern __at(0x0F19) __sfr CLC1GLS3;

typedef union
  {
  struct
    {
    unsigned LC1G4D1N           : 1;
    unsigned LC1G4D1T           : 1;
    unsigned LC1G4D2N           : 1;
    unsigned LC1G4D2T           : 1;
    unsigned LC1G4D3N           : 1;
    unsigned LC1G4D3T           : 1;
    unsigned LC1G4D4N           : 1;
    unsigned LC1G4D4T           : 1;
    };

  struct
    {
    unsigned G4D1N              : 1;
    unsigned G4D1T              : 1;
    unsigned G4D2N              : 1;
    unsigned G4D2T              : 1;
    unsigned G4D3N              : 1;
    unsigned G4D3T              : 1;
    unsigned G4D4N              : 1;
    unsigned G4D4T              : 1;
    };
  } __CLC1GLS3bits_t;

extern __at(0x0F19) volatile __CLC1GLS3bits_t CLC1GLS3bits;

#define _LC1G4D1N               0x01
#define _G4D1N                  0x01
#define _LC1G4D1T               0x02
#define _G4D1T                  0x02
#define _LC1G4D2N               0x04
#define _G4D2N                  0x04
#define _LC1G4D2T               0x08
#define _G4D2T                  0x08
#define _LC1G4D3N               0x10
#define _G4D3N                  0x10
#define _LC1G4D3T               0x20
#define _G4D3T                  0x20
#define _LC1G4D4N               0x40
#define _G4D4N                  0x40
#define _LC1G4D4T               0x80
#define _G4D4T                  0x80

//==============================================================================


//==============================================================================
//        CLC2CON Bits

extern __at(0x0F1A) __sfr CLC2CON;

typedef union
  {
  struct
    {
    unsigned LC2MODE0           : 1;
    unsigned LC2MODE1           : 1;
    unsigned LC2MODE2           : 1;
    unsigned LC2INTN            : 1;
    unsigned LC2INTP            : 1;
    unsigned LC2OUT             : 1;
    unsigned                    : 1;
    unsigned LC2EN              : 1;
    };

  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned INTN               : 1;
    unsigned INTP               : 1;
    unsigned OUT                : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned LC2MODE            : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned MODE               : 3;
    unsigned                    : 5;
    };
  } __CLC2CONbits_t;

extern __at(0x0F1A) volatile __CLC2CONbits_t CLC2CONbits;

#define _CLC2CON_LC2MODE0       0x01
#define _CLC2CON_MODE0          0x01
#define _CLC2CON_LC2MODE1       0x02
#define _CLC2CON_MODE1          0x02
#define _CLC2CON_LC2MODE2       0x04
#define _CLC2CON_MODE2          0x04
#define _CLC2CON_LC2INTN        0x08
#define _CLC2CON_INTN           0x08
#define _CLC2CON_LC2INTP        0x10
#define _CLC2CON_INTP           0x10
#define _CLC2CON_LC2OUT         0x20
#define _CLC2CON_OUT            0x20
#define _CLC2CON_LC2EN          0x80
#define _CLC2CON_EN             0x80

//==============================================================================


//==============================================================================
//        CLC2POL Bits

extern __at(0x0F1B) __sfr CLC2POL;

typedef union
  {
  struct
    {
    unsigned LC2G1POL           : 1;
    unsigned LC2G2POL           : 1;
    unsigned LC2G3POL           : 1;
    unsigned LC2G4POL           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LC2POL             : 1;
    };

  struct
    {
    unsigned G1POL              : 1;
    unsigned G2POL              : 1;
    unsigned G3POL              : 1;
    unsigned G4POL              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned POL                : 1;
    };
  } __CLC2POLbits_t;

extern __at(0x0F1B) volatile __CLC2POLbits_t CLC2POLbits;

#define _CLC2POL_LC2G1POL       0x01
#define _CLC2POL_G1POL          0x01
#define _CLC2POL_LC2G2POL       0x02
#define _CLC2POL_G2POL          0x02
#define _CLC2POL_LC2G3POL       0x04
#define _CLC2POL_G3POL          0x04
#define _CLC2POL_LC2G4POL       0x08
#define _CLC2POL_G4POL          0x08
#define _CLC2POL_LC2POL         0x80
#define _CLC2POL_POL            0x80

//==============================================================================


//==============================================================================
//        CLC2SEL0 Bits

extern __at(0x0F1C) __sfr CLC2SEL0;

typedef union
  {
  struct
    {
    unsigned LC2D1S0            : 1;
    unsigned LC2D1S1            : 1;
    unsigned LC2D1S2            : 1;
    unsigned LC2D1S3            : 1;
    unsigned LC2D1S4            : 1;
    unsigned LC2D1S5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D1S0               : 1;
    unsigned D1S1               : 1;
    unsigned D1S2               : 1;
    unsigned D1S3               : 1;
    unsigned D1S4               : 1;
    unsigned D1S5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LC2D1S             : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned D1S                : 6;
    unsigned                    : 2;
    };
  } __CLC2SEL0bits_t;

extern __at(0x0F1C) volatile __CLC2SEL0bits_t CLC2SEL0bits;

#define _CLC2SEL0_LC2D1S0       0x01
#define _CLC2SEL0_D1S0          0x01
#define _CLC2SEL0_LC2D1S1       0x02
#define _CLC2SEL0_D1S1          0x02
#define _CLC2SEL0_LC2D1S2       0x04
#define _CLC2SEL0_D1S2          0x04
#define _CLC2SEL0_LC2D1S3       0x08
#define _CLC2SEL0_D1S3          0x08
#define _CLC2SEL0_LC2D1S4       0x10
#define _CLC2SEL0_D1S4          0x10
#define _CLC2SEL0_LC2D1S5       0x20
#define _CLC2SEL0_D1S5          0x20

//==============================================================================


//==============================================================================
//        CLC2SEL1 Bits

extern __at(0x0F1D) __sfr CLC2SEL1;

typedef union
  {
  struct
    {
    unsigned LC2D2S0            : 1;
    unsigned LC2D2S1            : 1;
    unsigned LC2D2S2            : 1;
    unsigned LC2D2S3            : 1;
    unsigned LC2D2S4            : 1;
    unsigned LC2D2S5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D2S0               : 1;
    unsigned D2S1               : 1;
    unsigned D2S2               : 1;
    unsigned D2S3               : 1;
    unsigned D2S4               : 1;
    unsigned D2S5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D2S                : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned LC2D2S             : 6;
    unsigned                    : 2;
    };
  } __CLC2SEL1bits_t;

extern __at(0x0F1D) volatile __CLC2SEL1bits_t CLC2SEL1bits;

#define _CLC2SEL1_LC2D2S0       0x01
#define _CLC2SEL1_D2S0          0x01
#define _CLC2SEL1_LC2D2S1       0x02
#define _CLC2SEL1_D2S1          0x02
#define _CLC2SEL1_LC2D2S2       0x04
#define _CLC2SEL1_D2S2          0x04
#define _CLC2SEL1_LC2D2S3       0x08
#define _CLC2SEL1_D2S3          0x08
#define _CLC2SEL1_LC2D2S4       0x10
#define _CLC2SEL1_D2S4          0x10
#define _CLC2SEL1_LC2D2S5       0x20
#define _CLC2SEL1_D2S5          0x20

//==============================================================================


//==============================================================================
//        CLC2SEL2 Bits

extern __at(0x0F1E) __sfr CLC2SEL2;

typedef union
  {
  struct
    {
    unsigned LC2D3S0            : 1;
    unsigned LC2D3S1            : 1;
    unsigned LC2D3S2            : 1;
    unsigned LC2D3S3            : 1;
    unsigned LC2D3S4            : 1;
    unsigned LC2D3S5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D3S0               : 1;
    unsigned D3S1               : 1;
    unsigned D3S2               : 1;
    unsigned D3S3               : 1;
    unsigned D3S4               : 1;
    unsigned D3S5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D3S                : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned LC2D3S             : 6;
    unsigned                    : 2;
    };
  } __CLC2SEL2bits_t;

extern __at(0x0F1E) volatile __CLC2SEL2bits_t CLC2SEL2bits;

#define _CLC2SEL2_LC2D3S0       0x01
#define _CLC2SEL2_D3S0          0x01
#define _CLC2SEL2_LC2D3S1       0x02
#define _CLC2SEL2_D3S1          0x02
#define _CLC2SEL2_LC2D3S2       0x04
#define _CLC2SEL2_D3S2          0x04
#define _CLC2SEL2_LC2D3S3       0x08
#define _CLC2SEL2_D3S3          0x08
#define _CLC2SEL2_LC2D3S4       0x10
#define _CLC2SEL2_D3S4          0x10
#define _CLC2SEL2_LC2D3S5       0x20
#define _CLC2SEL2_D3S5          0x20

//==============================================================================


//==============================================================================
//        CLC2SEL3 Bits

extern __at(0x0F1F) __sfr CLC2SEL3;

typedef union
  {
  struct
    {
    unsigned LC2D4S0            : 1;
    unsigned LC2D4S1            : 1;
    unsigned LC2D4S2            : 1;
    unsigned LC2D4S3            : 1;
    unsigned LC2D4S4            : 1;
    unsigned LC2D4S5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D4S0               : 1;
    unsigned D4S1               : 1;
    unsigned D4S2               : 1;
    unsigned D4S3               : 1;
    unsigned D4S4               : 1;
    unsigned D4S5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D4S                : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned LC2D4S             : 6;
    unsigned                    : 2;
    };
  } __CLC2SEL3bits_t;

extern __at(0x0F1F) volatile __CLC2SEL3bits_t CLC2SEL3bits;

#define _CLC2SEL3_LC2D4S0       0x01
#define _CLC2SEL3_D4S0          0x01
#define _CLC2SEL3_LC2D4S1       0x02
#define _CLC2SEL3_D4S1          0x02
#define _CLC2SEL3_LC2D4S2       0x04
#define _CLC2SEL3_D4S2          0x04
#define _CLC2SEL3_LC2D4S3       0x08
#define _CLC2SEL3_D4S3          0x08
#define _CLC2SEL3_LC2D4S4       0x10
#define _CLC2SEL3_D4S4          0x10
#define _CLC2SEL3_LC2D4S5       0x20
#define _CLC2SEL3_D4S5          0x20

//==============================================================================


//==============================================================================
//        CLC2GLS0 Bits

extern __at(0x0F20) __sfr CLC2GLS0;

typedef union
  {
  struct
    {
    unsigned LC2G1D1N           : 1;
    unsigned LC2G1D1T           : 1;
    unsigned LC2G1D2N           : 1;
    unsigned LC2G1D2T           : 1;
    unsigned LC2G1D3N           : 1;
    unsigned LC2G1D3T           : 1;
    unsigned LC2G1D4N           : 1;
    unsigned LC2G1D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC2GLS0bits_t;

extern __at(0x0F20) volatile __CLC2GLS0bits_t CLC2GLS0bits;

#define _CLC2GLS0_LC2G1D1N      0x01
#define _CLC2GLS0_D1N           0x01
#define _CLC2GLS0_LC2G1D1T      0x02
#define _CLC2GLS0_D1T           0x02
#define _CLC2GLS0_LC2G1D2N      0x04
#define _CLC2GLS0_D2N           0x04
#define _CLC2GLS0_LC2G1D2T      0x08
#define _CLC2GLS0_D2T           0x08
#define _CLC2GLS0_LC2G1D3N      0x10
#define _CLC2GLS0_D3N           0x10
#define _CLC2GLS0_LC2G1D3T      0x20
#define _CLC2GLS0_D3T           0x20
#define _CLC2GLS0_LC2G1D4N      0x40
#define _CLC2GLS0_D4N           0x40
#define _CLC2GLS0_LC2G1D4T      0x80
#define _CLC2GLS0_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC2GLS1 Bits

extern __at(0x0F21) __sfr CLC2GLS1;

typedef union
  {
  struct
    {
    unsigned LC2G2D1N           : 1;
    unsigned LC2G2D1T           : 1;
    unsigned LC2G2D2N           : 1;
    unsigned LC2G2D2T           : 1;
    unsigned LC2G2D3N           : 1;
    unsigned LC2G2D3T           : 1;
    unsigned LC2G2D4N           : 1;
    unsigned LC2G2D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC2GLS1bits_t;

extern __at(0x0F21) volatile __CLC2GLS1bits_t CLC2GLS1bits;

#define _CLC2GLS1_LC2G2D1N      0x01
#define _CLC2GLS1_D1N           0x01
#define _CLC2GLS1_LC2G2D1T      0x02
#define _CLC2GLS1_D1T           0x02
#define _CLC2GLS1_LC2G2D2N      0x04
#define _CLC2GLS1_D2N           0x04
#define _CLC2GLS1_LC2G2D2T      0x08
#define _CLC2GLS1_D2T           0x08
#define _CLC2GLS1_LC2G2D3N      0x10
#define _CLC2GLS1_D3N           0x10
#define _CLC2GLS1_LC2G2D3T      0x20
#define _CLC2GLS1_D3T           0x20
#define _CLC2GLS1_LC2G2D4N      0x40
#define _CLC2GLS1_D4N           0x40
#define _CLC2GLS1_LC2G2D4T      0x80
#define _CLC2GLS1_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC2GLS2 Bits

extern __at(0x0F22) __sfr CLC2GLS2;

typedef union
  {
  struct
    {
    unsigned LC2G3D1N           : 1;
    unsigned LC2G3D1T           : 1;
    unsigned LC2G3D2N           : 1;
    unsigned LC2G3D2T           : 1;
    unsigned LC2G3D3N           : 1;
    unsigned LC2G3D3T           : 1;
    unsigned LC2G3D4N           : 1;
    unsigned LC2G3D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC2GLS2bits_t;

extern __at(0x0F22) volatile __CLC2GLS2bits_t CLC2GLS2bits;

#define _CLC2GLS2_LC2G3D1N      0x01
#define _CLC2GLS2_D1N           0x01
#define _CLC2GLS2_LC2G3D1T      0x02
#define _CLC2GLS2_D1T           0x02
#define _CLC2GLS2_LC2G3D2N      0x04
#define _CLC2GLS2_D2N           0x04
#define _CLC2GLS2_LC2G3D2T      0x08
#define _CLC2GLS2_D2T           0x08
#define _CLC2GLS2_LC2G3D3N      0x10
#define _CLC2GLS2_D3N           0x10
#define _CLC2GLS2_LC2G3D3T      0x20
#define _CLC2GLS2_D3T           0x20
#define _CLC2GLS2_LC2G3D4N      0x40
#define _CLC2GLS2_D4N           0x40
#define _CLC2GLS2_LC2G3D4T      0x80
#define _CLC2GLS2_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC2GLS3 Bits

extern __at(0x0F23) __sfr CLC2GLS3;

typedef union
  {
  struct
    {
    unsigned LC2G4D1N           : 1;
    unsigned LC2G4D1T           : 1;
    unsigned LC2G4D2N           : 1;
    unsigned LC2G4D2T           : 1;
    unsigned LC2G4D3N           : 1;
    unsigned LC2G4D3T           : 1;
    unsigned LC2G4D4N           : 1;
    unsigned LC2G4D4T           : 1;
    };

  struct
    {
    unsigned G4D1N              : 1;
    unsigned G4D1T              : 1;
    unsigned G4D2N              : 1;
    unsigned G4D2T              : 1;
    unsigned G4D3N              : 1;
    unsigned G4D3T              : 1;
    unsigned G4D4N              : 1;
    unsigned G4D4T              : 1;
    };
  } __CLC2GLS3bits_t;

extern __at(0x0F23) volatile __CLC2GLS3bits_t CLC2GLS3bits;

#define _CLC2GLS3_LC2G4D1N      0x01
#define _CLC2GLS3_G4D1N         0x01
#define _CLC2GLS3_LC2G4D1T      0x02
#define _CLC2GLS3_G4D1T         0x02
#define _CLC2GLS3_LC2G4D2N      0x04
#define _CLC2GLS3_G4D2N         0x04
#define _CLC2GLS3_LC2G4D2T      0x08
#define _CLC2GLS3_G4D2T         0x08
#define _CLC2GLS3_LC2G4D3N      0x10
#define _CLC2GLS3_G4D3N         0x10
#define _CLC2GLS3_LC2G4D3T      0x20
#define _CLC2GLS3_G4D3T         0x20
#define _CLC2GLS3_LC2G4D4N      0x40
#define _CLC2GLS3_G4D4N         0x40
#define _CLC2GLS3_LC2G4D4T      0x80
#define _CLC2GLS3_G4D4T         0x80

//==============================================================================


//==============================================================================
//        CLC3CON Bits

extern __at(0x0F24) __sfr CLC3CON;

typedef union
  {
  struct
    {
    unsigned LC3MODE0           : 1;
    unsigned LC3MODE1           : 1;
    unsigned LC3MODE2           : 1;
    unsigned LC3INTN            : 1;
    unsigned LC3INTP            : 1;
    unsigned LC3OUT             : 1;
    unsigned                    : 1;
    unsigned LC3EN              : 1;
    };

  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned INTN               : 1;
    unsigned INTP               : 1;
    unsigned OUT                : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned LC3MODE            : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned MODE               : 3;
    unsigned                    : 5;
    };
  } __CLC3CONbits_t;

extern __at(0x0F24) volatile __CLC3CONbits_t CLC3CONbits;

#define _CLC3CON_LC3MODE0       0x01
#define _CLC3CON_MODE0          0x01
#define _CLC3CON_LC3MODE1       0x02
#define _CLC3CON_MODE1          0x02
#define _CLC3CON_LC3MODE2       0x04
#define _CLC3CON_MODE2          0x04
#define _CLC3CON_LC3INTN        0x08
#define _CLC3CON_INTN           0x08
#define _CLC3CON_LC3INTP        0x10
#define _CLC3CON_INTP           0x10
#define _CLC3CON_LC3OUT         0x20
#define _CLC3CON_OUT            0x20
#define _CLC3CON_LC3EN          0x80
#define _CLC3CON_EN             0x80

//==============================================================================


//==============================================================================
//        CLC3POL Bits

extern __at(0x0F25) __sfr CLC3POL;

typedef union
  {
  struct
    {
    unsigned LC3G1POL           : 1;
    unsigned LC3G2POL           : 1;
    unsigned LC3G3POL           : 1;
    unsigned LC3G4POL           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LC3POL             : 1;
    };

  struct
    {
    unsigned G1POL              : 1;
    unsigned G2POL              : 1;
    unsigned G3POL              : 1;
    unsigned G4POL              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned POL                : 1;
    };
  } __CLC3POLbits_t;

extern __at(0x0F25) volatile __CLC3POLbits_t CLC3POLbits;

#define _CLC3POL_LC3G1POL       0x01
#define _CLC3POL_G1POL          0x01
#define _CLC3POL_LC3G2POL       0x02
#define _CLC3POL_G2POL          0x02
#define _CLC3POL_LC3G3POL       0x04
#define _CLC3POL_G3POL          0x04
#define _CLC3POL_LC3G4POL       0x08
#define _CLC3POL_G4POL          0x08
#define _CLC3POL_LC3POL         0x80
#define _CLC3POL_POL            0x80

//==============================================================================


//==============================================================================
//        CLC3SEL0 Bits

extern __at(0x0F26) __sfr CLC3SEL0;

typedef union
  {
  struct
    {
    unsigned LC3D1S0            : 1;
    unsigned LC3D1S1            : 1;
    unsigned LC3D1S2            : 1;
    unsigned LC3D1S3            : 1;
    unsigned LC3D1S4            : 1;
    unsigned LC3D1S5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D1S0               : 1;
    unsigned D1S1               : 1;
    unsigned D1S2               : 1;
    unsigned D1S3               : 1;
    unsigned D1S4               : 1;
    unsigned D1S5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D1S                : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned LC3D1S             : 6;
    unsigned                    : 2;
    };
  } __CLC3SEL0bits_t;

extern __at(0x0F26) volatile __CLC3SEL0bits_t CLC3SEL0bits;

#define _CLC3SEL0_LC3D1S0       0x01
#define _CLC3SEL0_D1S0          0x01
#define _CLC3SEL0_LC3D1S1       0x02
#define _CLC3SEL0_D1S1          0x02
#define _CLC3SEL0_LC3D1S2       0x04
#define _CLC3SEL0_D1S2          0x04
#define _CLC3SEL0_LC3D1S3       0x08
#define _CLC3SEL0_D1S3          0x08
#define _CLC3SEL0_LC3D1S4       0x10
#define _CLC3SEL0_D1S4          0x10
#define _CLC3SEL0_LC3D1S5       0x20
#define _CLC3SEL0_D1S5          0x20

//==============================================================================


//==============================================================================
//        CLC3SEL1 Bits

extern __at(0x0F27) __sfr CLC3SEL1;

typedef union
  {
  struct
    {
    unsigned LC3D2S0            : 1;
    unsigned LC3D2S1            : 1;
    unsigned LC3D2S2            : 1;
    unsigned LC3D2S3            : 1;
    unsigned LC3D2S4            : 1;
    unsigned LC3D2S5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D2S0               : 1;
    unsigned D2S1               : 1;
    unsigned D2S2               : 1;
    unsigned D2S3               : 1;
    unsigned D2S4               : 1;
    unsigned D2S5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LC3D2S             : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned D2S                : 6;
    unsigned                    : 2;
    };
  } __CLC3SEL1bits_t;

extern __at(0x0F27) volatile __CLC3SEL1bits_t CLC3SEL1bits;

#define _CLC3SEL1_LC3D2S0       0x01
#define _CLC3SEL1_D2S0          0x01
#define _CLC3SEL1_LC3D2S1       0x02
#define _CLC3SEL1_D2S1          0x02
#define _CLC3SEL1_LC3D2S2       0x04
#define _CLC3SEL1_D2S2          0x04
#define _CLC3SEL1_LC3D2S3       0x08
#define _CLC3SEL1_D2S3          0x08
#define _CLC3SEL1_LC3D2S4       0x10
#define _CLC3SEL1_D2S4          0x10
#define _CLC3SEL1_LC3D2S5       0x20
#define _CLC3SEL1_D2S5          0x20

//==============================================================================


//==============================================================================
//        CLC3SEL2 Bits

extern __at(0x0F28) __sfr CLC3SEL2;

typedef union
  {
  struct
    {
    unsigned LC3D3S0            : 1;
    unsigned LC3D3S1            : 1;
    unsigned LC3D3S2            : 1;
    unsigned LC3D3S3            : 1;
    unsigned LC3D3S4            : 1;
    unsigned LC3D3S5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D3S0               : 1;
    unsigned D3S1               : 1;
    unsigned D3S2               : 1;
    unsigned D3S3               : 1;
    unsigned D3S4               : 1;
    unsigned D3S5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LC3D3S             : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned D3S                : 6;
    unsigned                    : 2;
    };
  } __CLC3SEL2bits_t;

extern __at(0x0F28) volatile __CLC3SEL2bits_t CLC3SEL2bits;

#define _CLC3SEL2_LC3D3S0       0x01
#define _CLC3SEL2_D3S0          0x01
#define _CLC3SEL2_LC3D3S1       0x02
#define _CLC3SEL2_D3S1          0x02
#define _CLC3SEL2_LC3D3S2       0x04
#define _CLC3SEL2_D3S2          0x04
#define _CLC3SEL2_LC3D3S3       0x08
#define _CLC3SEL2_D3S3          0x08
#define _CLC3SEL2_LC3D3S4       0x10
#define _CLC3SEL2_D3S4          0x10
#define _CLC3SEL2_LC3D3S5       0x20
#define _CLC3SEL2_D3S5          0x20

//==============================================================================


//==============================================================================
//        CLC3SEL3 Bits

extern __at(0x0F29) __sfr CLC3SEL3;

typedef union
  {
  struct
    {
    unsigned LC3D4S0            : 1;
    unsigned LC3D4S1            : 1;
    unsigned LC3D4S2            : 1;
    unsigned LC3D4S3            : 1;
    unsigned LC3D4S4            : 1;
    unsigned LC3D4S5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D4S0               : 1;
    unsigned D4S1               : 1;
    unsigned D4S2               : 1;
    unsigned D4S3               : 1;
    unsigned D4S4               : 1;
    unsigned D4S5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D4S                : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned LC3D4S             : 6;
    unsigned                    : 2;
    };
  } __CLC3SEL3bits_t;

extern __at(0x0F29) volatile __CLC3SEL3bits_t CLC3SEL3bits;

#define _CLC3SEL3_LC3D4S0       0x01
#define _CLC3SEL3_D4S0          0x01
#define _CLC3SEL3_LC3D4S1       0x02
#define _CLC3SEL3_D4S1          0x02
#define _CLC3SEL3_LC3D4S2       0x04
#define _CLC3SEL3_D4S2          0x04
#define _CLC3SEL3_LC3D4S3       0x08
#define _CLC3SEL3_D4S3          0x08
#define _CLC3SEL3_LC3D4S4       0x10
#define _CLC3SEL3_D4S4          0x10
#define _CLC3SEL3_LC3D4S5       0x20
#define _CLC3SEL3_D4S5          0x20

//==============================================================================


//==============================================================================
//        CLC3GLS0 Bits

extern __at(0x0F2A) __sfr CLC3GLS0;

typedef union
  {
  struct
    {
    unsigned LC3G1D1N           : 1;
    unsigned LC3G1D1T           : 1;
    unsigned LC3G1D2N           : 1;
    unsigned LC3G1D2T           : 1;
    unsigned LC3G1D3N           : 1;
    unsigned LC3G1D3T           : 1;
    unsigned LC3G1D4N           : 1;
    unsigned LC3G1D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC3GLS0bits_t;

extern __at(0x0F2A) volatile __CLC3GLS0bits_t CLC3GLS0bits;

#define _CLC3GLS0_LC3G1D1N      0x01
#define _CLC3GLS0_D1N           0x01
#define _CLC3GLS0_LC3G1D1T      0x02
#define _CLC3GLS0_D1T           0x02
#define _CLC3GLS0_LC3G1D2N      0x04
#define _CLC3GLS0_D2N           0x04
#define _CLC3GLS0_LC3G1D2T      0x08
#define _CLC3GLS0_D2T           0x08
#define _CLC3GLS0_LC3G1D3N      0x10
#define _CLC3GLS0_D3N           0x10
#define _CLC3GLS0_LC3G1D3T      0x20
#define _CLC3GLS0_D3T           0x20
#define _CLC3GLS0_LC3G1D4N      0x40
#define _CLC3GLS0_D4N           0x40
#define _CLC3GLS0_LC3G1D4T      0x80
#define _CLC3GLS0_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC3GLS1 Bits

extern __at(0x0F2B) __sfr CLC3GLS1;

typedef union
  {
  struct
    {
    unsigned LC3G2D1N           : 1;
    unsigned LC3G2D1T           : 1;
    unsigned LC3G2D2N           : 1;
    unsigned LC3G2D2T           : 1;
    unsigned LC3G2D3N           : 1;
    unsigned LC3G2D3T           : 1;
    unsigned LC3G2D4N           : 1;
    unsigned LC3G2D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC3GLS1bits_t;

extern __at(0x0F2B) volatile __CLC3GLS1bits_t CLC3GLS1bits;

#define _CLC3GLS1_LC3G2D1N      0x01
#define _CLC3GLS1_D1N           0x01
#define _CLC3GLS1_LC3G2D1T      0x02
#define _CLC3GLS1_D1T           0x02
#define _CLC3GLS1_LC3G2D2N      0x04
#define _CLC3GLS1_D2N           0x04
#define _CLC3GLS1_LC3G2D2T      0x08
#define _CLC3GLS1_D2T           0x08
#define _CLC3GLS1_LC3G2D3N      0x10
#define _CLC3GLS1_D3N           0x10
#define _CLC3GLS1_LC3G2D3T      0x20
#define _CLC3GLS1_D3T           0x20
#define _CLC3GLS1_LC3G2D4N      0x40
#define _CLC3GLS1_D4N           0x40
#define _CLC3GLS1_LC3G2D4T      0x80
#define _CLC3GLS1_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC3GLS2 Bits

extern __at(0x0F2C) __sfr CLC3GLS2;

typedef union
  {
  struct
    {
    unsigned LC3G3D1N           : 1;
    unsigned LC3G3D1T           : 1;
    unsigned LC3G3D2N           : 1;
    unsigned LC3G3D2T           : 1;
    unsigned LC3G3D3N           : 1;
    unsigned LC3G3D3T           : 1;
    unsigned LC3G3D4N           : 1;
    unsigned LC3G3D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC3GLS2bits_t;

extern __at(0x0F2C) volatile __CLC3GLS2bits_t CLC3GLS2bits;

#define _CLC3GLS2_LC3G3D1N      0x01
#define _CLC3GLS2_D1N           0x01
#define _CLC3GLS2_LC3G3D1T      0x02
#define _CLC3GLS2_D1T           0x02
#define _CLC3GLS2_LC3G3D2N      0x04
#define _CLC3GLS2_D2N           0x04
#define _CLC3GLS2_LC3G3D2T      0x08
#define _CLC3GLS2_D2T           0x08
#define _CLC3GLS2_LC3G3D3N      0x10
#define _CLC3GLS2_D3N           0x10
#define _CLC3GLS2_LC3G3D3T      0x20
#define _CLC3GLS2_D3T           0x20
#define _CLC3GLS2_LC3G3D4N      0x40
#define _CLC3GLS2_D4N           0x40
#define _CLC3GLS2_LC3G3D4T      0x80
#define _CLC3GLS2_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC3GLS3 Bits

extern __at(0x0F2D) __sfr CLC3GLS3;

typedef union
  {
  struct
    {
    unsigned LC3G4D1N           : 1;
    unsigned LC3G4D1T           : 1;
    unsigned LC3G4D2N           : 1;
    unsigned LC3G4D2T           : 1;
    unsigned LC3G4D3N           : 1;
    unsigned LC3G4D3T           : 1;
    unsigned LC3G4D4N           : 1;
    unsigned LC3G4D4T           : 1;
    };

  struct
    {
    unsigned G4D1N              : 1;
    unsigned G4D1T              : 1;
    unsigned G4D2N              : 1;
    unsigned G4D2T              : 1;
    unsigned G4D3N              : 1;
    unsigned G4D3T              : 1;
    unsigned G4D4N              : 1;
    unsigned G4D4T              : 1;
    };
  } __CLC3GLS3bits_t;

extern __at(0x0F2D) volatile __CLC3GLS3bits_t CLC3GLS3bits;

#define _CLC3GLS3_LC3G4D1N      0x01
#define _CLC3GLS3_G4D1N         0x01
#define _CLC3GLS3_LC3G4D1T      0x02
#define _CLC3GLS3_G4D1T         0x02
#define _CLC3GLS3_LC3G4D2N      0x04
#define _CLC3GLS3_G4D2N         0x04
#define _CLC3GLS3_LC3G4D2T      0x08
#define _CLC3GLS3_G4D2T         0x08
#define _CLC3GLS3_LC3G4D3N      0x10
#define _CLC3GLS3_G4D3N         0x10
#define _CLC3GLS3_LC3G4D3T      0x20
#define _CLC3GLS3_G4D3T         0x20
#define _CLC3GLS3_LC3G4D4N      0x40
#define _CLC3GLS3_G4D4N         0x40
#define _CLC3GLS3_LC3G4D4T      0x80
#define _CLC3GLS3_G4D4T         0x80

//==============================================================================


//==============================================================================
//        CLC4CON Bits

extern __at(0x0F2E) __sfr CLC4CON;

typedef union
  {
  struct
    {
    unsigned LC4MODE0           : 1;
    unsigned LC4MODE1           : 1;
    unsigned LC4MODE2           : 1;
    unsigned LC4INTN            : 1;
    unsigned LC4INTP            : 1;
    unsigned LC4OUT             : 1;
    unsigned                    : 1;
    unsigned LC4EN              : 1;
    };

  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned INTN               : 1;
    unsigned INTP               : 1;
    unsigned OUT                : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned LC4MODE            : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned MODE               : 3;
    unsigned                    : 5;
    };
  } __CLC4CONbits_t;

extern __at(0x0F2E) volatile __CLC4CONbits_t CLC4CONbits;

#define _CLC4CON_LC4MODE0       0x01
#define _CLC4CON_MODE0          0x01
#define _CLC4CON_LC4MODE1       0x02
#define _CLC4CON_MODE1          0x02
#define _CLC4CON_LC4MODE2       0x04
#define _CLC4CON_MODE2          0x04
#define _CLC4CON_LC4INTN        0x08
#define _CLC4CON_INTN           0x08
#define _CLC4CON_LC4INTP        0x10
#define _CLC4CON_INTP           0x10
#define _CLC4CON_LC4OUT         0x20
#define _CLC4CON_OUT            0x20
#define _CLC4CON_LC4EN          0x80
#define _CLC4CON_EN             0x80

//==============================================================================


//==============================================================================
//        CLC4POL Bits

extern __at(0x0F2F) __sfr CLC4POL;

typedef union
  {
  struct
    {
    unsigned LC4G1POL           : 1;
    unsigned LC4G2POL           : 1;
    unsigned LC4G3POL           : 1;
    unsigned LC4G4POL           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LC4POL             : 1;
    };

  struct
    {
    unsigned G1POL              : 1;
    unsigned G2POL              : 1;
    unsigned G3POL              : 1;
    unsigned G4POL              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned POL                : 1;
    };
  } __CLC4POLbits_t;

extern __at(0x0F2F) volatile __CLC4POLbits_t CLC4POLbits;

#define _CLC4POL_LC4G1POL       0x01
#define _CLC4POL_G1POL          0x01
#define _CLC4POL_LC4G2POL       0x02
#define _CLC4POL_G2POL          0x02
#define _CLC4POL_LC4G3POL       0x04
#define _CLC4POL_G3POL          0x04
#define _CLC4POL_LC4G4POL       0x08
#define _CLC4POL_G4POL          0x08
#define _CLC4POL_LC4POL         0x80
#define _CLC4POL_POL            0x80

//==============================================================================


//==============================================================================
//        CLC4SEL0 Bits

extern __at(0x0F30) __sfr CLC4SEL0;

typedef union
  {
  struct
    {
    unsigned LC4D1S0            : 1;
    unsigned LC4D1S1            : 1;
    unsigned LC4D1S2            : 1;
    unsigned LC4D1S3            : 1;
    unsigned LC4D1S4            : 1;
    unsigned LC4D1S5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D1S0               : 1;
    unsigned D1S1               : 1;
    unsigned D1S2               : 1;
    unsigned D1S3               : 1;
    unsigned D1S4               : 1;
    unsigned D1S5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D1S                : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned LC4D1S             : 6;
    unsigned                    : 2;
    };
  } __CLC4SEL0bits_t;

extern __at(0x0F30) volatile __CLC4SEL0bits_t CLC4SEL0bits;

#define _CLC4SEL0_LC4D1S0       0x01
#define _CLC4SEL0_D1S0          0x01
#define _CLC4SEL0_LC4D1S1       0x02
#define _CLC4SEL0_D1S1          0x02
#define _CLC4SEL0_LC4D1S2       0x04
#define _CLC4SEL0_D1S2          0x04
#define _CLC4SEL0_LC4D1S3       0x08
#define _CLC4SEL0_D1S3          0x08
#define _CLC4SEL0_LC4D1S4       0x10
#define _CLC4SEL0_D1S4          0x10
#define _CLC4SEL0_LC4D1S5       0x20
#define _CLC4SEL0_D1S5          0x20

//==============================================================================


//==============================================================================
//        CLC4SEL1 Bits

extern __at(0x0F31) __sfr CLC4SEL1;

typedef union
  {
  struct
    {
    unsigned LC4D2S0            : 1;
    unsigned LC4D2S1            : 1;
    unsigned LC4D2S2            : 1;
    unsigned LC4D2S3            : 1;
    unsigned LC4D2S4            : 1;
    unsigned LC4D2S5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D2S0               : 1;
    unsigned D2S1               : 1;
    unsigned D2S2               : 1;
    unsigned D2S3               : 1;
    unsigned D2S4               : 1;
    unsigned D2S5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LC4D2S             : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned D2S                : 6;
    unsigned                    : 2;
    };
  } __CLC4SEL1bits_t;

extern __at(0x0F31) volatile __CLC4SEL1bits_t CLC4SEL1bits;

#define _CLC4SEL1_LC4D2S0       0x01
#define _CLC4SEL1_D2S0          0x01
#define _CLC4SEL1_LC4D2S1       0x02
#define _CLC4SEL1_D2S1          0x02
#define _CLC4SEL1_LC4D2S2       0x04
#define _CLC4SEL1_D2S2          0x04
#define _CLC4SEL1_LC4D2S3       0x08
#define _CLC4SEL1_D2S3          0x08
#define _CLC4SEL1_LC4D2S4       0x10
#define _CLC4SEL1_D2S4          0x10
#define _CLC4SEL1_LC4D2S5       0x20
#define _CLC4SEL1_D2S5          0x20

//==============================================================================


//==============================================================================
//        CLC4SEL2 Bits

extern __at(0x0F32) __sfr CLC4SEL2;

typedef union
  {
  struct
    {
    unsigned LC4D3S0            : 1;
    unsigned LC4D3S1            : 1;
    unsigned LC4D3S2            : 1;
    unsigned LC4D3S3            : 1;
    unsigned LC4D3S4            : 1;
    unsigned LC4D3S5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D3S0               : 1;
    unsigned D3S1               : 1;
    unsigned D3S2               : 1;
    unsigned D3S3               : 1;
    unsigned D3S4               : 1;
    unsigned D3S5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D3S                : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned LC4D3S             : 6;
    unsigned                    : 2;
    };
  } __CLC4SEL2bits_t;

extern __at(0x0F32) volatile __CLC4SEL2bits_t CLC4SEL2bits;

#define _CLC4SEL2_LC4D3S0       0x01
#define _CLC4SEL2_D3S0          0x01
#define _CLC4SEL2_LC4D3S1       0x02
#define _CLC4SEL2_D3S1          0x02
#define _CLC4SEL2_LC4D3S2       0x04
#define _CLC4SEL2_D3S2          0x04
#define _CLC4SEL2_LC4D3S3       0x08
#define _CLC4SEL2_D3S3          0x08
#define _CLC4SEL2_LC4D3S4       0x10
#define _CLC4SEL2_D3S4          0x10
#define _CLC4SEL2_LC4D3S5       0x20
#define _CLC4SEL2_D3S5          0x20

//==============================================================================


//==============================================================================
//        CLC4SEL3 Bits

extern __at(0x0F33) __sfr CLC4SEL3;

typedef union
  {
  struct
    {
    unsigned LC4D4S0            : 1;
    unsigned LC4D4S1            : 1;
    unsigned LC4D4S2            : 1;
    unsigned LC4D4S3            : 1;
    unsigned LC4D4S4            : 1;
    unsigned LC4D4S5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D4S0               : 1;
    unsigned D4S1               : 1;
    unsigned D4S2               : 1;
    unsigned D4S3               : 1;
    unsigned D4S4               : 1;
    unsigned D4S5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D4S                : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned LC4D4S             : 6;
    unsigned                    : 2;
    };
  } __CLC4SEL3bits_t;

extern __at(0x0F33) volatile __CLC4SEL3bits_t CLC4SEL3bits;

#define _CLC4SEL3_LC4D4S0       0x01
#define _CLC4SEL3_D4S0          0x01
#define _CLC4SEL3_LC4D4S1       0x02
#define _CLC4SEL3_D4S1          0x02
#define _CLC4SEL3_LC4D4S2       0x04
#define _CLC4SEL3_D4S2          0x04
#define _CLC4SEL3_LC4D4S3       0x08
#define _CLC4SEL3_D4S3          0x08
#define _CLC4SEL3_LC4D4S4       0x10
#define _CLC4SEL3_D4S4          0x10
#define _CLC4SEL3_LC4D4S5       0x20
#define _CLC4SEL3_D4S5          0x20

//==============================================================================


//==============================================================================
//        CLC4GLS0 Bits

extern __at(0x0F34) __sfr CLC4GLS0;

typedef union
  {
  struct
    {
    unsigned LC4G1D1N           : 1;
    unsigned LC4G1D1T           : 1;
    unsigned LC4G1D2N           : 1;
    unsigned LC4G1D2T           : 1;
    unsigned LC4G1D3N           : 1;
    unsigned LC4G1D3T           : 1;
    unsigned LC4G1D4N           : 1;
    unsigned LC4G1D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC4GLS0bits_t;

extern __at(0x0F34) volatile __CLC4GLS0bits_t CLC4GLS0bits;

#define _CLC4GLS0_LC4G1D1N      0x01
#define _CLC4GLS0_D1N           0x01
#define _CLC4GLS0_LC4G1D1T      0x02
#define _CLC4GLS0_D1T           0x02
#define _CLC4GLS0_LC4G1D2N      0x04
#define _CLC4GLS0_D2N           0x04
#define _CLC4GLS0_LC4G1D2T      0x08
#define _CLC4GLS0_D2T           0x08
#define _CLC4GLS0_LC4G1D3N      0x10
#define _CLC4GLS0_D3N           0x10
#define _CLC4GLS0_LC4G1D3T      0x20
#define _CLC4GLS0_D3T           0x20
#define _CLC4GLS0_LC4G1D4N      0x40
#define _CLC4GLS0_D4N           0x40
#define _CLC4GLS0_LC4G1D4T      0x80
#define _CLC4GLS0_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC4GLS1 Bits

extern __at(0x0F35) __sfr CLC4GLS1;

typedef union
  {
  struct
    {
    unsigned LC4G2D1N           : 1;
    unsigned LC4G2D1T           : 1;
    unsigned LC4G2D2N           : 1;
    unsigned LC4G2D2T           : 1;
    unsigned LC4G2D3N           : 1;
    unsigned LC4G2D3T           : 1;
    unsigned LC4G2D4N           : 1;
    unsigned LC4G2D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC4GLS1bits_t;

extern __at(0x0F35) volatile __CLC4GLS1bits_t CLC4GLS1bits;

#define _CLC4GLS1_LC4G2D1N      0x01
#define _CLC4GLS1_D1N           0x01
#define _CLC4GLS1_LC4G2D1T      0x02
#define _CLC4GLS1_D1T           0x02
#define _CLC4GLS1_LC4G2D2N      0x04
#define _CLC4GLS1_D2N           0x04
#define _CLC4GLS1_LC4G2D2T      0x08
#define _CLC4GLS1_D2T           0x08
#define _CLC4GLS1_LC4G2D3N      0x10
#define _CLC4GLS1_D3N           0x10
#define _CLC4GLS1_LC4G2D3T      0x20
#define _CLC4GLS1_D3T           0x20
#define _CLC4GLS1_LC4G2D4N      0x40
#define _CLC4GLS1_D4N           0x40
#define _CLC4GLS1_LC4G2D4T      0x80
#define _CLC4GLS1_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC4GLS2 Bits

extern __at(0x0F36) __sfr CLC4GLS2;

typedef union
  {
  struct
    {
    unsigned LC4G3D1N           : 1;
    unsigned LC4G3D1T           : 1;
    unsigned LC4G3D2N           : 1;
    unsigned LC4G3D2T           : 1;
    unsigned LC4G3D3N           : 1;
    unsigned LC4G3D3T           : 1;
    unsigned LC4G3D4N           : 1;
    unsigned LC4G3D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC4GLS2bits_t;

extern __at(0x0F36) volatile __CLC4GLS2bits_t CLC4GLS2bits;

#define _CLC4GLS2_LC4G3D1N      0x01
#define _CLC4GLS2_D1N           0x01
#define _CLC4GLS2_LC4G3D1T      0x02
#define _CLC4GLS2_D1T           0x02
#define _CLC4GLS2_LC4G3D2N      0x04
#define _CLC4GLS2_D2N           0x04
#define _CLC4GLS2_LC4G3D2T      0x08
#define _CLC4GLS2_D2T           0x08
#define _CLC4GLS2_LC4G3D3N      0x10
#define _CLC4GLS2_D3N           0x10
#define _CLC4GLS2_LC4G3D3T      0x20
#define _CLC4GLS2_D3T           0x20
#define _CLC4GLS2_LC4G3D4N      0x40
#define _CLC4GLS2_D4N           0x40
#define _CLC4GLS2_LC4G3D4T      0x80
#define _CLC4GLS2_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC4GLS3 Bits

extern __at(0x0F37) __sfr CLC4GLS3;

typedef union
  {
  struct
    {
    unsigned LC4G4D1N           : 1;
    unsigned LC4G4D1T           : 1;
    unsigned LC4G4D2N           : 1;
    unsigned LC4G4D2T           : 1;
    unsigned LC4G4D3N           : 1;
    unsigned LC4G4D3T           : 1;
    unsigned LC4G4D4N           : 1;
    unsigned LC4G4D4T           : 1;
    };

  struct
    {
    unsigned G4D1N              : 1;
    unsigned G4D1T              : 1;
    unsigned G4D2N              : 1;
    unsigned G4D2T              : 1;
    unsigned G4D3N              : 1;
    unsigned G4D3T              : 1;
    unsigned G4D4N              : 1;
    unsigned G4D4T              : 1;
    };
  } __CLC4GLS3bits_t;

extern __at(0x0F37) volatile __CLC4GLS3bits_t CLC4GLS3bits;

#define _CLC4GLS3_LC4G4D1N      0x01
#define _CLC4GLS3_G4D1N         0x01
#define _CLC4GLS3_LC4G4D1T      0x02
#define _CLC4GLS3_G4D1T         0x02
#define _CLC4GLS3_LC4G4D2N      0x04
#define _CLC4GLS3_G4D2N         0x04
#define _CLC4GLS3_LC4G4D2T      0x08
#define _CLC4GLS3_G4D2T         0x08
#define _CLC4GLS3_LC4G4D3N      0x10
#define _CLC4GLS3_G4D3N         0x10
#define _CLC4GLS3_LC4G4D3T      0x20
#define _CLC4GLS3_G4D3T         0x20
#define _CLC4GLS3_LC4G4D4N      0x40
#define _CLC4GLS3_G4D4N         0x40
#define _CLC4GLS3_LC4G4D4T      0x80
#define _CLC4GLS3_G4D4T         0x80

//==============================================================================


//==============================================================================
//        STATUS_SHAD Bits

extern __at(0x0FE4) __sfr STATUS_SHAD;

typedef struct
  {
  unsigned C_SHAD               : 1;
  unsigned DC_SHAD              : 1;
  unsigned Z_SHAD               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __STATUS_SHADbits_t;

extern __at(0x0FE4) volatile __STATUS_SHADbits_t STATUS_SHADbits;

#define _C_SHAD                 0x01
#define _DC_SHAD                0x02
#define _Z_SHAD                 0x04

//==============================================================================

extern __at(0x0FE5) __sfr WREG_SHAD;
extern __at(0x0FE6) __sfr BSR_SHAD;
extern __at(0x0FE7) __sfr PCLATH_SHAD;
extern __at(0x0FE8) __sfr FSR0L_SHAD;
extern __at(0x0FE9) __sfr FSR0H_SHAD;
extern __at(0x0FEA) __sfr FSR1L_SHAD;
extern __at(0x0FEB) __sfr FSR1H_SHAD;
extern __at(0x0FED) __sfr STKPTR;
extern __at(0x0FEE) __sfr TOSL;
extern __at(0x0FEF) __sfr TOSH;

//==============================================================================
//
//        Configuration Bits
//
//==============================================================================

#define _CONFIG1                0x8007
#define _CONFIG2                0x8008

//----------------------------- CONFIG1 Options -------------------------------

#define _FOSC_LP                0x3FF8  // LP Oscillator, Low-power crystal connected between OSC1 and OSC2 pins.
#define _FOSC_XT                0x3FF9  // XT Oscillator, Crystal/resonator connected between OSC1 and OSC2 pins.
#define _FOSC_HS                0x3FFA  // HS Oscillator, High-speed crystal/resonator connected between OSC1 and OSC2 pins.
#define _FOSC_EXTRC             0x3FFB  // EXTRC oscillator: External RC circuit connected to CLKIN pin.
#define _FOSC_INTOSC            0x3FFC  // INTOSC oscillator: I/O function on CLKIN pin.
#define _FOSC_ECL               0x3FFD  // ECL, External Clock, Low Power Mode (0-0.5 MHz): device clock supplied to CLKIN pins.
#define _FOSC_ECM               0x3FFE  // ECM, External Clock, Medium Power Mode (0.5-4 MHz): device clock supplied to CLKIN pins.
#define _FOSC_ECH               0x3FFF  // ECH, External Clock, High Power Mode (4-20 MHz): device clock supplied to CLKIN pins.
#define _WDTE_OFF               0x3FE7  // WDT disabled.
#define _WDTE_SWDTEN            0x3FEF  // WDT controlled by the SWDTEN bit in the WDTCON register.
#define _WDTE_NSLEEP            0x3FF7  // WDT enabled while running and disabled in Sleep.
#define _WDTE_ON                0x3FFF  // WDT enabled.
#define _PWRTE_ON               0x3FDF  // PWRT enabled.
#define _PWRTE_OFF              0x3FFF  // PWRT disabled.
#define _MCLRE_OFF              0x3FBF  // MCLR/VPP pin function is digital input.
#define _MCLRE_ON               0x3FFF  // MCLR/VPP pin function is MCLR.
#define _CP_ON                  0x3F7F  // Program memory code protection is enabled.
#define _CP_OFF                 0x3FFF  // Program memory code protection is disabled.
#define _BOREN_OFF              0x39FF  // Brown-out Reset disabled.
#define _BOREN_SBODEN           0x3BFF  // Brown-out Reset controlled by the SBOREN bit in the BORCON register.
#define _BOREN_NSLEEP           0x3DFF  // Brown-out Reset enabled while running and disabled in Sleep.
#define _BOREN_ON               0x3FFF  // Brown-out Reset enabled.
#define _CLKOUTEN_ON            0x37FF  // CLKOUT function is enabled on the CLKOUT pin.
#define _CLKOUTEN_OFF           0x3FFF  // CLKOUT function is disabled. I/O or oscillator function on the CLKOUT pin.
#define _IESO_OFF               0x2FFF  // Internal/External Switchover Mode is disabled.
#define _IESO_ON                0x3FFF  // Internal/External Switchover Mode is enabled.
#define _FCMEN_OFF              0x1FFF  // Fail-Safe Clock Monitor is disabled.
#define _FCMEN_ON               0x3FFF  // Fail-Safe Clock Monitor is enabled.

//----------------------------- CONFIG2 Options -------------------------------

#define _WRT_ALL                0x3FFC  // 000h to 1FFFh write protected, no addresses may be modified by EECON control.
#define _WRT_HALF               0x3FFD  // 000h to FFFh write protected, 1000h to 1FFFh may be modified by EECON control.
#define _WRT_BOOT               0x3FFE  // 000h to 1FFh write protected, 200h to 1FFFh may be modified by EECON control.
#define _WRT_OFF                0x3FFF  // Write protection off.
#define _PPS1WAY_OFF            0x3FFB  // The PPSLOCK bit can be set and cleared repeatedly by software.
#define _PPS1WAY_ON             0x3FFF  // The PPSLOCK bit cannot be cleared once it is set by software.
#define _ZCD_ON                 0x3F7F  // Zero-cross detect circuit is enabled at POR.
#define _ZCD_OFF                0x3FFF  // Zero-cross detect circuit is disabled at POR.
#define _PLLEN_OFF              0x3EFF  // 4x PLL is enabled when software sets the SPLLEN bit.
#define _PLLEN_ON               0x3FFF  // 4x PLL is always enabled.
#define _STVREN_OFF             0x3DFF  // Stack Overflow or Underflow will not cause a Reset.
#define _STVREN_ON              0x3FFF  // Stack Overflow or Underflow will cause a Reset.
#define _BORV_HI                0x3BFF  // Brown-out Reset Voltage (Vbor), high trip point selected.
#define _BORV_LO                0x3FFF  // Brown-out Reset Voltage (Vbor), low trip point selected.
#define _LPBOR_ON               0x37FF  // Low-Power BOR is enabled.
#define _LPBOR_OFF              0x3FFF  // Low-Power BOR is disabled.
#define _DEBUG_ON               0x2FFF  // In-Circuit Debugger enabled, ICSPCLK and ICSPDAT are dedicated to the debugger.
#define _DEBUG_OFF              0x3FFF  // In-Circuit Debugger disabled, ICSPCLK and ICSPDAT are general purpose I/O pins.
#define _LVP_OFF                0x1FFF  // High-voltage on MCLR/VPP must be used for programming.
#define _LVP_ON                 0x3FFF  // Low-voltage programming enabled.

//==============================================================================

#define _DEVID1                 0x8006

#define _IDLOC0                 0x8000
#define _IDLOC1                 0x8001
#define _IDLOC2                 0x8002
#define _IDLOC3                 0x8003

//==============================================================================

#ifndef NO_BIT_DEFINES

#define ADON                    ADCON0bits.ADON                 // bit 0
#define GO                      ADCON0bits.GO                   // bit 1

#define ADNREF                  ADCON1bits.ADNREF               // bit 2
#define ADFM                    ADCON1bits.ADFM                 // bit 7

#define ANSA0                   ANSELAbits.ANSA0                // bit 0
#define ANSA1                   ANSELAbits.ANSA1                // bit 1
#define ANSA2                   ANSELAbits.ANSA2                // bit 2
#define ANSA3                   ANSELAbits.ANSA3                // bit 3
#define ANSA4                   ANSELAbits.ANSA4                // bit 4
#define ANSA5                   ANSELAbits.ANSA5                // bit 5

#define ANSB0                   ANSELBbits.ANSB0                // bit 0
#define ANSB1                   ANSELBbits.ANSB1                // bit 1
#define ANSB2                   ANSELBbits.ANSB2                // bit 2
#define ANSB3                   ANSELBbits.ANSB3                // bit 3
#define ANSB4                   ANSELBbits.ANSB4                // bit 4
#define ANSB5                   ANSELBbits.ANSB5                // bit 5

#define ANSC2                   ANSELCbits.ANSC2                // bit 2
#define ANSC3                   ANSELCbits.ANSC3                // bit 3
#define ANSC4                   ANSELCbits.ANSC4                // bit 4
#define ANSC5                   ANSELCbits.ANSC5                // bit 5
#define ANSC6                   ANSELCbits.ANSC6                // bit 6
#define ANSC7                   ANSELCbits.ANSC7                // bit 7

#define ABDEN                   BAUD1CONbits.ABDEN              // bit 0
#define WUE                     BAUD1CONbits.WUE                // bit 1
#define BRG16                   BAUD1CONbits.BRG16              // bit 3
#define SCKP                    BAUD1CONbits.SCKP               // bit 4
#define RCIDL                   BAUD1CONbits.RCIDL              // bit 6
#define ABDOVF                  BAUD1CONbits.ABDOVF             // bit 7

#define BORRDY                  BORCONbits.BORRDY               // bit 0
#define BORFS                   BORCONbits.BORFS                // bit 6
#define SBOREN                  BORCONbits.SBOREN               // bit 7

#define BSR0                    BSRbits.BSR0                    // bit 0
#define BSR1                    BSRbits.BSR1                    // bit 1
#define BSR2                    BSRbits.BSR2                    // bit 2
#define BSR3                    BSRbits.BSR3                    // bit 3
#define BSR4                    BSRbits.BSR4                    // bit 4

#define CTS0                    CCP1CAPbits.CTS0                // bit 0, shadows bit in CCP1CAPbits
#define CCP1CTS0                CCP1CAPbits.CCP1CTS0            // bit 0, shadows bit in CCP1CAPbits
#define CTS1                    CCP1CAPbits.CTS1                // bit 1, shadows bit in CCP1CAPbits
#define CCP1CTS1                CCP1CAPbits.CCP1CTS1            // bit 1, shadows bit in CCP1CAPbits
#define CTS2                    CCP1CAPbits.CTS2                // bit 2, shadows bit in CCP1CAPbits
#define CCP1CTS2                CCP1CAPbits.CCP1CTS2            // bit 2, shadows bit in CCP1CAPbits
#define CTS3                    CCP1CAPbits.CTS3                // bit 3, shadows bit in CCP1CAPbits
#define CCP1CTS3                CCP1CAPbits.CCP1CTS3            // bit 3, shadows bit in CCP1CAPbits

#define MODE0                   CCP1CONbits.MODE0               // bit 0, shadows bit in CCP1CONbits
#define CCP1MODE0               CCP1CONbits.CCP1MODE0           // bit 0, shadows bit in CCP1CONbits
#define MODE1                   CCP1CONbits.MODE1               // bit 1, shadows bit in CCP1CONbits
#define CCP1MODE1               CCP1CONbits.CCP1MODE1           // bit 1, shadows bit in CCP1CONbits
#define MODE2                   CCP1CONbits.MODE2               // bit 2, shadows bit in CCP1CONbits
#define CCP1MODE2               CCP1CONbits.CCP1MODE2           // bit 2, shadows bit in CCP1CONbits
#define MODE3                   CCP1CONbits.MODE3               // bit 3, shadows bit in CCP1CONbits
#define CCP1MODE3               CCP1CONbits.CCP1MODE3           // bit 3, shadows bit in CCP1CONbits
#define FMT                     CCP1CONbits.FMT                 // bit 4, shadows bit in CCP1CONbits
#define CCP1FMT                 CCP1CONbits.CCP1FMT             // bit 4, shadows bit in CCP1CONbits
#define OUT                     CCP1CONbits.OUT                 // bit 5, shadows bit in CCP1CONbits
#define CCP1OUT                 CCP1CONbits.CCP1OUT             // bit 5, shadows bit in CCP1CONbits
#define EN                      CCP1CONbits.EN                  // bit 7, shadows bit in CCP1CONbits
#define CCP1EN                  CCP1CONbits.CCP1EN              // bit 7, shadows bit in CCP1CONbits

#define C1TSEL0                 CCPTMRS1bits.C1TSEL0            // bit 0
#define C1TSEL1                 CCPTMRS1bits.C1TSEL1            // bit 1
#define C2TSEL0                 CCPTMRS1bits.C2TSEL0            // bit 2
#define C2TSEL1                 CCPTMRS1bits.C2TSEL1            // bit 3
#define C7TSEL0                 CCPTMRS1bits.C7TSEL0            // bit 4
#define C7TSEL1                 CCPTMRS1bits.C7TSEL1            // bit 5

#define P3TSEL0                 CCPTMRS2bits.P3TSEL0            // bit 0
#define P3TSEL1                 CCPTMRS2bits.P3TSEL1            // bit 1
#define P4TSEL0                 CCPTMRS2bits.P4TSEL0            // bit 2
#define P5TSEL1                 CCPTMRS2bits.P5TSEL1            // bit 3
#define P9TSEL0                 CCPTMRS2bits.P9TSEL0            // bit 4
#define P9TSEL1                 CCPTMRS2bits.P9TSEL1            // bit 5

#define LC1G1D1N                CLC1GLS0bits.LC1G1D1N           // bit 0, shadows bit in CLC1GLS0bits
#define D1N                     CLC1GLS0bits.D1N                // bit 0, shadows bit in CLC1GLS0bits
#define LC1G1D1T                CLC1GLS0bits.LC1G1D1T           // bit 1, shadows bit in CLC1GLS0bits
#define D1T                     CLC1GLS0bits.D1T                // bit 1, shadows bit in CLC1GLS0bits
#define LC1G1D2N                CLC1GLS0bits.LC1G1D2N           // bit 2, shadows bit in CLC1GLS0bits
#define D2N                     CLC1GLS0bits.D2N                // bit 2, shadows bit in CLC1GLS0bits
#define LC1G1D2T                CLC1GLS0bits.LC1G1D2T           // bit 3, shadows bit in CLC1GLS0bits
#define D2T                     CLC1GLS0bits.D2T                // bit 3, shadows bit in CLC1GLS0bits
#define LC1G1D3N                CLC1GLS0bits.LC1G1D3N           // bit 4, shadows bit in CLC1GLS0bits
#define D3N                     CLC1GLS0bits.D3N                // bit 4, shadows bit in CLC1GLS0bits
#define LC1G1D3T                CLC1GLS0bits.LC1G1D3T           // bit 5, shadows bit in CLC1GLS0bits
#define D3T                     CLC1GLS0bits.D3T                // bit 5, shadows bit in CLC1GLS0bits
#define LC1G1D4N                CLC1GLS0bits.LC1G1D4N           // bit 6, shadows bit in CLC1GLS0bits
#define D4N                     CLC1GLS0bits.D4N                // bit 6, shadows bit in CLC1GLS0bits
#define LC1G1D4T                CLC1GLS0bits.LC1G1D4T           // bit 7, shadows bit in CLC1GLS0bits
#define D4T                     CLC1GLS0bits.D4T                // bit 7, shadows bit in CLC1GLS0bits

#define LC1G4D1N                CLC1GLS3bits.LC1G4D1N           // bit 0, shadows bit in CLC1GLS3bits
#define G4D1N                   CLC1GLS3bits.G4D1N              // bit 0, shadows bit in CLC1GLS3bits
#define LC1G4D1T                CLC1GLS3bits.LC1G4D1T           // bit 1, shadows bit in CLC1GLS3bits
#define G4D1T                   CLC1GLS3bits.G4D1T              // bit 1, shadows bit in CLC1GLS3bits
#define LC1G4D2N                CLC1GLS3bits.LC1G4D2N           // bit 2, shadows bit in CLC1GLS3bits
#define G4D2N                   CLC1GLS3bits.G4D2N              // bit 2, shadows bit in CLC1GLS3bits
#define LC1G4D2T                CLC1GLS3bits.LC1G4D2T           // bit 3, shadows bit in CLC1GLS3bits
#define G4D2T                   CLC1GLS3bits.G4D2T              // bit 3, shadows bit in CLC1GLS3bits
#define LC1G4D3N                CLC1GLS3bits.LC1G4D3N           // bit 4, shadows bit in CLC1GLS3bits
#define G4D3N                   CLC1GLS3bits.G4D3N              // bit 4, shadows bit in CLC1GLS3bits
#define LC1G4D3T                CLC1GLS3bits.LC1G4D3T           // bit 5, shadows bit in CLC1GLS3bits
#define G4D3T                   CLC1GLS3bits.G4D3T              // bit 5, shadows bit in CLC1GLS3bits
#define LC1G4D4N                CLC1GLS3bits.LC1G4D4N           // bit 6, shadows bit in CLC1GLS3bits
#define G4D4N                   CLC1GLS3bits.G4D4N              // bit 6, shadows bit in CLC1GLS3bits
#define LC1G4D4T                CLC1GLS3bits.LC1G4D4T           // bit 7, shadows bit in CLC1GLS3bits
#define G4D4T                   CLC1GLS3bits.G4D4T              // bit 7, shadows bit in CLC1GLS3bits

#define LC1G1POL                CLC1POLbits.LC1G1POL            // bit 0, shadows bit in CLC1POLbits
#define G1POL                   CLC1POLbits.G1POL               // bit 0, shadows bit in CLC1POLbits
#define LC1G2POL                CLC1POLbits.LC1G2POL            // bit 1, shadows bit in CLC1POLbits
#define G2POL                   CLC1POLbits.G2POL               // bit 1, shadows bit in CLC1POLbits
#define LC1G3POL                CLC1POLbits.LC1G3POL            // bit 2, shadows bit in CLC1POLbits
#define G3POL                   CLC1POLbits.G3POL               // bit 2, shadows bit in CLC1POLbits
#define LC1G4POL                CLC1POLbits.LC1G4POL            // bit 3, shadows bit in CLC1POLbits
#define G4POL                   CLC1POLbits.G4POL               // bit 3, shadows bit in CLC1POLbits
#define LC1POL                  CLC1POLbits.LC1POL              // bit 7, shadows bit in CLC1POLbits
#define POL                     CLC1POLbits.POL                 // bit 7, shadows bit in CLC1POLbits

#define LC1D1S0                 CLC1SEL0bits.LC1D1S0            // bit 0, shadows bit in CLC1SEL0bits
#define D1S0                    CLC1SEL0bits.D1S0               // bit 0, shadows bit in CLC1SEL0bits
#define LC1D1S1                 CLC1SEL0bits.LC1D1S1            // bit 1, shadows bit in CLC1SEL0bits
#define D1S1                    CLC1SEL0bits.D1S1               // bit 1, shadows bit in CLC1SEL0bits
#define LC1D1S2                 CLC1SEL0bits.LC1D1S2            // bit 2, shadows bit in CLC1SEL0bits
#define D1S2                    CLC1SEL0bits.D1S2               // bit 2, shadows bit in CLC1SEL0bits
#define LC1D1S3                 CLC1SEL0bits.LC1D1S3            // bit 3, shadows bit in CLC1SEL0bits
#define D1S3                    CLC1SEL0bits.D1S3               // bit 3, shadows bit in CLC1SEL0bits
#define LC1D1S4                 CLC1SEL0bits.LC1D1S4            // bit 4, shadows bit in CLC1SEL0bits
#define D1S4                    CLC1SEL0bits.D1S4               // bit 4, shadows bit in CLC1SEL0bits
#define LC1D1S5                 CLC1SEL0bits.LC1D1S5            // bit 5, shadows bit in CLC1SEL0bits
#define D1S5                    CLC1SEL0bits.D1S5               // bit 5, shadows bit in CLC1SEL0bits

#define LC1D2S0                 CLC1SEL1bits.LC1D2S0            // bit 0, shadows bit in CLC1SEL1bits
#define D2S0                    CLC1SEL1bits.D2S0               // bit 0, shadows bit in CLC1SEL1bits
#define LC1D2S1                 CLC1SEL1bits.LC1D2S1            // bit 1, shadows bit in CLC1SEL1bits
#define D2S1                    CLC1SEL1bits.D2S1               // bit 1, shadows bit in CLC1SEL1bits
#define LC1D2S2                 CLC1SEL1bits.LC1D2S2            // bit 2, shadows bit in CLC1SEL1bits
#define D2S2                    CLC1SEL1bits.D2S2               // bit 2, shadows bit in CLC1SEL1bits
#define LC1D2S3                 CLC1SEL1bits.LC1D2S3            // bit 3, shadows bit in CLC1SEL1bits
#define D2S3                    CLC1SEL1bits.D2S3               // bit 3, shadows bit in CLC1SEL1bits
#define LC1D2S4                 CLC1SEL1bits.LC1D2S4            // bit 4, shadows bit in CLC1SEL1bits
#define D2S4                    CLC1SEL1bits.D2S4               // bit 4, shadows bit in CLC1SEL1bits
#define LC1D2S5                 CLC1SEL1bits.LC1D2S5            // bit 5, shadows bit in CLC1SEL1bits
#define D2S5                    CLC1SEL1bits.D2S5               // bit 5, shadows bit in CLC1SEL1bits

#define LC1D3S0                 CLC1SEL2bits.LC1D3S0            // bit 0, shadows bit in CLC1SEL2bits
#define D3S0                    CLC1SEL2bits.D3S0               // bit 0, shadows bit in CLC1SEL2bits
#define LC1D3S1                 CLC1SEL2bits.LC1D3S1            // bit 1, shadows bit in CLC1SEL2bits
#define D3S1                    CLC1SEL2bits.D3S1               // bit 1, shadows bit in CLC1SEL2bits
#define LC1D3S2                 CLC1SEL2bits.LC1D3S2            // bit 2, shadows bit in CLC1SEL2bits
#define D3S2                    CLC1SEL2bits.D3S2               // bit 2, shadows bit in CLC1SEL2bits
#define LC1D3S3                 CLC1SEL2bits.LC1D3S3            // bit 3, shadows bit in CLC1SEL2bits
#define D3S3                    CLC1SEL2bits.D3S3               // bit 3, shadows bit in CLC1SEL2bits
#define LC1D3S4                 CLC1SEL2bits.LC1D3S4            // bit 4, shadows bit in CLC1SEL2bits
#define D3S4                    CLC1SEL2bits.D3S4               // bit 4, shadows bit in CLC1SEL2bits
#define LC1D3S5                 CLC1SEL2bits.LC1D3S5            // bit 5, shadows bit in CLC1SEL2bits
#define D3S5                    CLC1SEL2bits.D3S5               // bit 5, shadows bit in CLC1SEL2bits

#define LC1D4S0                 CLC1SEL3bits.LC1D4S0            // bit 0, shadows bit in CLC1SEL3bits
#define D4S0                    CLC1SEL3bits.D4S0               // bit 0, shadows bit in CLC1SEL3bits
#define LC1D4S1                 CLC1SEL3bits.LC1D4S1            // bit 1, shadows bit in CLC1SEL3bits
#define D4S1                    CLC1SEL3bits.D4S1               // bit 1, shadows bit in CLC1SEL3bits
#define LC1D4S2                 CLC1SEL3bits.LC1D4S2            // bit 2, shadows bit in CLC1SEL3bits
#define D4S2                    CLC1SEL3bits.D4S2               // bit 2, shadows bit in CLC1SEL3bits
#define LC1D4S3                 CLC1SEL3bits.LC1D4S3            // bit 3, shadows bit in CLC1SEL3bits
#define D4S3                    CLC1SEL3bits.D4S3               // bit 3, shadows bit in CLC1SEL3bits
#define LC1D4S4                 CLC1SEL3bits.LC1D4S4            // bit 4, shadows bit in CLC1SEL3bits
#define D4S4                    CLC1SEL3bits.D4S4               // bit 4, shadows bit in CLC1SEL3bits
#define LC1D4S5                 CLC1SEL3bits.LC1D4S5            // bit 5, shadows bit in CLC1SEL3bits
#define D4S5                    CLC1SEL3bits.D4S5               // bit 5, shadows bit in CLC1SEL3bits

#define MCLC1OUT                CLCDATAbits.MCLC1OUT            // bit 0
#define MCLC2OUT                CLCDATAbits.MCLC2OUT            // bit 1
#define MCLC3OUT                CLCDATAbits.MCLC3OUT            // bit 2
#define MLC4OUT                 CLCDATAbits.MLC4OUT             // bit 3

#define C1NCH0                  CM1NSELbits.C1NCH0              // bit 0
#define C1NCH1                  CM1NSELbits.C1NCH1              // bit 1
#define C1NCH2                  CM1NSELbits.C1NCH2              // bit 2
#define C1NCH3                  CM1NSELbits.C1NCH3              // bit 3

#define PCH0                    CM1PSELbits.PCH0                // bit 0, shadows bit in CM1PSELbits
#define C1PCH0                  CM1PSELbits.C1PCH0              // bit 0, shadows bit in CM1PSELbits
#define PCH1                    CM1PSELbits.PCH1                // bit 1, shadows bit in CM1PSELbits
#define C1PCH1                  CM1PSELbits.C1PCH1              // bit 1, shadows bit in CM1PSELbits
#define PCH2                    CM1PSELbits.PCH2                // bit 2, shadows bit in CM1PSELbits
#define C1PCH2                  CM1PSELbits.C1PCH2              // bit 2, shadows bit in CM1PSELbits
#define PCH3                    CM1PSELbits.PCH3                // bit 3, shadows bit in CM1PSELbits
#define C1PCH3                  CM1PSELbits.C1PCH3              // bit 3, shadows bit in CM1PSELbits

#define C2NCH0                  CM2NSELbits.C2NCH0              // bit 0
#define C2NCH1                  CM2NSELbits.C2NCH1              // bit 1
#define C2NCH2                  CM2NSELbits.C2NCH2              // bit 2
#define C2NCH3                  CM2NSELbits.C2NCH3              // bit 3

#define C3NCH0                  CM3NSELbits.C3NCH0              // bit 0
#define C3NCH1                  CM3NSELbits.C3NCH1              // bit 1
#define C3NCH2                  CM3NSELbits.C3NCH2              // bit 2
#define C3NCH3                  CM3NSELbits.C3NCH3              // bit 3

#define C4NCH0                  CM4NSELbits.C4NCH0              // bit 0
#define C4NCH1                  CM4NSELbits.C4NCH1              // bit 1
#define C4NCH2                  CM4NSELbits.C4NCH2              // bit 2
#define C4NCH3                  CM4NSELbits.C4NCH3              // bit 3

#define C5NCH0                  CM5NSELbits.C5NCH0              // bit 0
#define C5NCH1                  CM5NSELbits.C5NCH1              // bit 1
#define C5NCH2                  CM5NSELbits.C5NCH2              // bit 2
#define C5NCH3                  CM5NSELbits.C5NCH3              // bit 3

#define C6NCH0                  CM6NSELbits.C6NCH0              // bit 0
#define C6NCH1                  CM6NSELbits.C6NCH1              // bit 1
#define C6NCH2                  CM6NSELbits.C6NCH2              // bit 2
#define C6NCH3                  CM6NSELbits.C6NCH3              // bit 3

#define MC1OUT                  CMOUTbits.MC1OUT                // bit 0
#define MC2OUT                  CMOUTbits.MC2OUT                // bit 1
#define MC3OUT                  CMOUTbits.MC3OUT                // bit 2
#define MC4OUT                  CMOUTbits.MC4OUT                // bit 3
#define MC5OUT                  CMOUTbits.MC5OUT                // bit 4
#define MC6OUT                  CMOUTbits.MC6OUT                // bit 5

#define ASDAC0                  COG1ASD0bits.ASDAC0             // bit 2, shadows bit in COG1ASD0bits
#define G1ASDAC0                COG1ASD0bits.G1ASDAC0           // bit 2, shadows bit in COG1ASD0bits
#define ASDAC1                  COG1ASD0bits.ASDAC1             // bit 3, shadows bit in COG1ASD0bits
#define G1ASDAC1                COG1ASD0bits.G1ASDAC1           // bit 3, shadows bit in COG1ASD0bits
#define ASDBD0                  COG1ASD0bits.ASDBD0             // bit 4, shadows bit in COG1ASD0bits
#define G1ASDBD0                COG1ASD0bits.G1ASDBD0           // bit 4, shadows bit in COG1ASD0bits
#define ASDBD1                  COG1ASD0bits.ASDBD1             // bit 5, shadows bit in COG1ASD0bits
#define G1ASDBD1                COG1ASD0bits.G1ASDBD1           // bit 5, shadows bit in COG1ASD0bits
#define ASREN                   COG1ASD0bits.ASREN              // bit 6, shadows bit in COG1ASD0bits
#define ARSEN                   COG1ASD0bits.ARSEN              // bit 6, shadows bit in COG1ASD0bits
#define G1ARSEN                 COG1ASD0bits.G1ARSEN            // bit 6, shadows bit in COG1ASD0bits
#define G1ASREN                 COG1ASD0bits.G1ASREN            // bit 6, shadows bit in COG1ASD0bits
#define ASE                     COG1ASD0bits.ASE                // bit 7, shadows bit in COG1ASD0bits
#define G1ASE                   COG1ASD0bits.G1ASE              // bit 7, shadows bit in COG1ASD0bits

#define AS0E                    COG1ASD1bits.AS0E               // bit 0, shadows bit in COG1ASD1bits
#define G1AS0E                  COG1ASD1bits.G1AS0E             // bit 0, shadows bit in COG1ASD1bits
#define AS1E                    COG1ASD1bits.AS1E               // bit 1, shadows bit in COG1ASD1bits
#define G1AS1E                  COG1ASD1bits.G1AS1E             // bit 1, shadows bit in COG1ASD1bits
#define AS2E                    COG1ASD1bits.AS2E               // bit 2, shadows bit in COG1ASD1bits
#define G1AS2E                  COG1ASD1bits.G1AS2E             // bit 2, shadows bit in COG1ASD1bits
#define AS3E                    COG1ASD1bits.AS3E               // bit 3, shadows bit in COG1ASD1bits
#define G1AS3E                  COG1ASD1bits.G1AS3E             // bit 3, shadows bit in COG1ASD1bits
#define AS4E                    COG1ASD1bits.AS4E               // bit 4, shadows bit in COG1ASD1bits
#define G1AS4E                  COG1ASD1bits.G1AS4E             // bit 4, shadows bit in COG1ASD1bits
#define AS5E                    COG1ASD1bits.AS5E               // bit 5, shadows bit in COG1ASD1bits
#define G1AS5E                  COG1ASD1bits.G1AS5E             // bit 5, shadows bit in COG1ASD1bits
#define AS6E                    COG1ASD1bits.AS6E               // bit 6, shadows bit in COG1ASD1bits
#define G1AS6E                  COG1ASD1bits.G1AS6E             // bit 6, shadows bit in COG1ASD1bits
#define AS7E                    COG1ASD1bits.AS7E               // bit 7, shadows bit in COG1ASD1bits
#define G1AS7E                  COG1ASD1bits.G1AS7E             // bit 7, shadows bit in COG1ASD1bits

#define BLKF0                   COG1BLKFbits.BLKF0              // bit 0, shadows bit in COG1BLKFbits
#define G1BLKF0                 COG1BLKFbits.G1BLKF0            // bit 0, shadows bit in COG1BLKFbits
#define BLKF1                   COG1BLKFbits.BLKF1              // bit 1, shadows bit in COG1BLKFbits
#define G1BLKF1                 COG1BLKFbits.G1BLKF1            // bit 1, shadows bit in COG1BLKFbits
#define BLKF2                   COG1BLKFbits.BLKF2              // bit 2, shadows bit in COG1BLKFbits
#define G1BLKF2                 COG1BLKFbits.G1BLKF2            // bit 2, shadows bit in COG1BLKFbits
#define BLKF3                   COG1BLKFbits.BLKF3              // bit 3, shadows bit in COG1BLKFbits
#define G1BLKF3                 COG1BLKFbits.G1BLKF3            // bit 3, shadows bit in COG1BLKFbits
#define BLKF4                   COG1BLKFbits.BLKF4              // bit 4, shadows bit in COG1BLKFbits
#define G1BLKF4                 COG1BLKFbits.G1BLKF4            // bit 4, shadows bit in COG1BLKFbits
#define BLKF5                   COG1BLKFbits.BLKF5              // bit 5, shadows bit in COG1BLKFbits
#define G1BLKF5                 COG1BLKFbits.G1BLKF5            // bit 5, shadows bit in COG1BLKFbits

#define BLKR0                   COG1BLKRbits.BLKR0              // bit 0, shadows bit in COG1BLKRbits
#define G1BLKR0                 COG1BLKRbits.G1BLKR0            // bit 0, shadows bit in COG1BLKRbits
#define BLKR1                   COG1BLKRbits.BLKR1              // bit 1, shadows bit in COG1BLKRbits
#define G1BLKR1                 COG1BLKRbits.G1BLKR1            // bit 1, shadows bit in COG1BLKRbits
#define BLKR2                   COG1BLKRbits.BLKR2              // bit 2, shadows bit in COG1BLKRbits
#define G1BLKR2                 COG1BLKRbits.G1BLKR2            // bit 2, shadows bit in COG1BLKRbits
#define BLKR3                   COG1BLKRbits.BLKR3              // bit 3, shadows bit in COG1BLKRbits
#define G1BLKR3                 COG1BLKRbits.G1BLKR3            // bit 3, shadows bit in COG1BLKRbits
#define BLKR4                   COG1BLKRbits.BLKR4              // bit 4, shadows bit in COG1BLKRbits
#define G1BLKR4                 COG1BLKRbits.G1BLKR4            // bit 4, shadows bit in COG1BLKRbits
#define BLKR5                   COG1BLKRbits.BLKR5              // bit 5, shadows bit in COG1BLKRbits
#define G1BLKR5                 COG1BLKRbits.G1BLKR5            // bit 5, shadows bit in COG1BLKRbits

#define POLA                    COG1CON1bits.POLA               // bit 0, shadows bit in COG1CON1bits
#define G1POLA                  COG1CON1bits.G1POLA             // bit 0, shadows bit in COG1CON1bits
#define POLB                    COG1CON1bits.POLB               // bit 1, shadows bit in COG1CON1bits
#define G1POLB                  COG1CON1bits.G1POLB             // bit 1, shadows bit in COG1CON1bits
#define POLC                    COG1CON1bits.POLC               // bit 2, shadows bit in COG1CON1bits
#define G1POLC                  COG1CON1bits.G1POLC             // bit 2, shadows bit in COG1CON1bits
#define POLD                    COG1CON1bits.POLD               // bit 3, shadows bit in COG1CON1bits
#define G1POLD                  COG1CON1bits.G1POLD             // bit 3, shadows bit in COG1CON1bits
#define FDBS                    COG1CON1bits.FDBS               // bit 6, shadows bit in COG1CON1bits
#define G1FDBS                  COG1CON1bits.G1FDBS             // bit 6, shadows bit in COG1CON1bits
#define RDBS                    COG1CON1bits.RDBS               // bit 7, shadows bit in COG1CON1bits
#define G1RDBS                  COG1CON1bits.G1RDBS             // bit 7, shadows bit in COG1CON1bits

#define DBF0                    COG1DBFbits.DBF0                // bit 0, shadows bit in COG1DBFbits
#define G1DBF0                  COG1DBFbits.G1DBF0              // bit 0, shadows bit in COG1DBFbits
#define DBF1                    COG1DBFbits.DBF1                // bit 1, shadows bit in COG1DBFbits
#define G1DBF1                  COG1DBFbits.G1DBF1              // bit 1, shadows bit in COG1DBFbits
#define DBF2                    COG1DBFbits.DBF2                // bit 2, shadows bit in COG1DBFbits
#define G1DBF2                  COG1DBFbits.G1DBF2              // bit 2, shadows bit in COG1DBFbits
#define DBF3                    COG1DBFbits.DBF3                // bit 3, shadows bit in COG1DBFbits
#define G1DBF3                  COG1DBFbits.G1DBF3              // bit 3, shadows bit in COG1DBFbits
#define DBF4                    COG1DBFbits.DBF4                // bit 4, shadows bit in COG1DBFbits
#define G1DBF4                  COG1DBFbits.G1DBF4              // bit 4, shadows bit in COG1DBFbits
#define DBF5                    COG1DBFbits.DBF5                // bit 5, shadows bit in COG1DBFbits
#define G1DBF5                  COG1DBFbits.G1DBF5              // bit 5, shadows bit in COG1DBFbits

#define DBR0                    COG1DBRbits.DBR0                // bit 0, shadows bit in COG1DBRbits
#define G1DBR0                  COG1DBRbits.G1DBR0              // bit 0, shadows bit in COG1DBRbits
#define DBR1                    COG1DBRbits.DBR1                // bit 1, shadows bit in COG1DBRbits
#define G1DBR1                  COG1DBRbits.G1DBR1              // bit 1, shadows bit in COG1DBRbits
#define DBR2                    COG1DBRbits.DBR2                // bit 2, shadows bit in COG1DBRbits
#define G1DBR2                  COG1DBRbits.G1DBR2              // bit 2, shadows bit in COG1DBRbits
#define DBR3                    COG1DBRbits.DBR3                // bit 3, shadows bit in COG1DBRbits
#define G1DBR3                  COG1DBRbits.G1DBR3              // bit 3, shadows bit in COG1DBRbits
#define DBR4                    COG1DBRbits.DBR4                // bit 4, shadows bit in COG1DBRbits
#define G1DBR4                  COG1DBRbits.G1DBR4              // bit 4, shadows bit in COG1DBRbits
#define DBR5                    COG1DBRbits.DBR5                // bit 5, shadows bit in COG1DBRbits
#define G1DBR5                  COG1DBRbits.G1DBR5              // bit 5, shadows bit in COG1DBRbits

#define FIS0                    COG1FIS0bits.FIS0               // bit 0, shadows bit in COG1FIS0bits
#define G1FIS0                  COG1FIS0bits.G1FIS0             // bit 0, shadows bit in COG1FIS0bits
#define FIS1                    COG1FIS0bits.FIS1               // bit 1, shadows bit in COG1FIS0bits
#define G1FIS1                  COG1FIS0bits.G1FIS1             // bit 1, shadows bit in COG1FIS0bits
#define FIS2                    COG1FIS0bits.FIS2               // bit 2, shadows bit in COG1FIS0bits
#define G1FIS2                  COG1FIS0bits.G1FIS2             // bit 2, shadows bit in COG1FIS0bits
#define FIS3                    COG1FIS0bits.FIS3               // bit 3, shadows bit in COG1FIS0bits
#define G1FIS3                  COG1FIS0bits.G1FIS3             // bit 3, shadows bit in COG1FIS0bits
#define FIS4                    COG1FIS0bits.FIS4               // bit 4, shadows bit in COG1FIS0bits
#define G1FIS4                  COG1FIS0bits.G1FIS4             // bit 4, shadows bit in COG1FIS0bits
#define FIS5                    COG1FIS0bits.FIS5               // bit 5, shadows bit in COG1FIS0bits
#define G1FIS5                  COG1FIS0bits.G1FIS5             // bit 5, shadows bit in COG1FIS0bits
#define FIS6                    COG1FIS0bits.FIS6               // bit 6, shadows bit in COG1FIS0bits
#define G1FIS6                  COG1FIS0bits.G1FIS6             // bit 6, shadows bit in COG1FIS0bits
#define FIS7                    COG1FIS0bits.FIS7               // bit 7, shadows bit in COG1FIS0bits
#define G1FIS7                  COG1FIS0bits.G1FIS7             // bit 7, shadows bit in COG1FIS0bits

#define FIS8                    COG1FIS1bits.FIS8               // bit 0, shadows bit in COG1FIS1bits
#define G1FIS8                  COG1FIS1bits.G1FIS8             // bit 0, shadows bit in COG1FIS1bits
#define FIS9                    COG1FIS1bits.FIS9               // bit 1, shadows bit in COG1FIS1bits
#define G1FIS9                  COG1FIS1bits.G1FIS9             // bit 1, shadows bit in COG1FIS1bits
#define FIS10                   COG1FIS1bits.FIS10              // bit 2, shadows bit in COG1FIS1bits
#define G1FIS10                 COG1FIS1bits.G1FIS10            // bit 2, shadows bit in COG1FIS1bits
#define FIS11                   COG1FIS1bits.FIS11              // bit 3, shadows bit in COG1FIS1bits
#define G1FIS11                 COG1FIS1bits.G1FIS11            // bit 3, shadows bit in COG1FIS1bits
#define FIS12                   COG1FIS1bits.FIS12              // bit 4, shadows bit in COG1FIS1bits
#define G1FIS12                 COG1FIS1bits.G1FIS12            // bit 4, shadows bit in COG1FIS1bits
#define FIS13                   COG1FIS1bits.FIS13              // bit 5, shadows bit in COG1FIS1bits
#define G1FIS13                 COG1FIS1bits.G1FIS13            // bit 5, shadows bit in COG1FIS1bits
#define FIS14                   COG1FIS1bits.FIS14              // bit 6, shadows bit in COG1FIS1bits
#define G1FIS14                 COG1FIS1bits.G1FIS14            // bit 6, shadows bit in COG1FIS1bits
#define FIS15                   COG1FIS1bits.FIS15              // bit 7, shadows bit in COG1FIS1bits
#define G1FIS15                 COG1FIS1bits.G1FIS15            // bit 7, shadows bit in COG1FIS1bits

#define FSIM0                   COG1FSIM0bits.FSIM0             // bit 0, shadows bit in COG1FSIM0bits
#define G1FSIM0                 COG1FSIM0bits.G1FSIM0           // bit 0, shadows bit in COG1FSIM0bits
#define FSIM1                   COG1FSIM0bits.FSIM1             // bit 1, shadows bit in COG1FSIM0bits
#define G1FSIM1                 COG1FSIM0bits.G1FSIM1           // bit 1, shadows bit in COG1FSIM0bits
#define FSIM2                   COG1FSIM0bits.FSIM2             // bit 2, shadows bit in COG1FSIM0bits
#define G1FSIM2                 COG1FSIM0bits.G1FSIM2           // bit 2, shadows bit in COG1FSIM0bits
#define FSIM3                   COG1FSIM0bits.FSIM3             // bit 3, shadows bit in COG1FSIM0bits
#define G1FSIM3                 COG1FSIM0bits.G1FSIM3           // bit 3, shadows bit in COG1FSIM0bits
#define FSIM4                   COG1FSIM0bits.FSIM4             // bit 4, shadows bit in COG1FSIM0bits
#define G1FSIM4                 COG1FSIM0bits.G1FSIM4           // bit 4, shadows bit in COG1FSIM0bits
#define FSIM5                   COG1FSIM0bits.FSIM5             // bit 5, shadows bit in COG1FSIM0bits
#define G1FSIM5                 COG1FSIM0bits.G1FSIM5           // bit 5, shadows bit in COG1FSIM0bits
#define FSIM6                   COG1FSIM0bits.FSIM6             // bit 6, shadows bit in COG1FSIM0bits
#define G1FSIM6                 COG1FSIM0bits.G1FSIM6           // bit 6, shadows bit in COG1FSIM0bits
#define FSIM7                   COG1FSIM0bits.FSIM7             // bit 7, shadows bit in COG1FSIM0bits
#define G1FSIM7                 COG1FSIM0bits.G1FSIM7           // bit 7, shadows bit in COG1FSIM0bits

#define FSIM8                   COG1FSIM1bits.FSIM8             // bit 0, shadows bit in COG1FSIM1bits
#define G1FSIM8                 COG1FSIM1bits.G1FSIM8           // bit 0, shadows bit in COG1FSIM1bits
#define FSIM9                   COG1FSIM1bits.FSIM9             // bit 1, shadows bit in COG1FSIM1bits
#define G1FSIM9                 COG1FSIM1bits.G1FSIM9           // bit 1, shadows bit in COG1FSIM1bits
#define FSIM10                  COG1FSIM1bits.FSIM10            // bit 2, shadows bit in COG1FSIM1bits
#define G1FSIM10                COG1FSIM1bits.G1FSIM10          // bit 2, shadows bit in COG1FSIM1bits
#define FSIM11                  COG1FSIM1bits.FSIM11            // bit 3, shadows bit in COG1FSIM1bits
#define G1FSIM11                COG1FSIM1bits.G1FSIM11          // bit 3, shadows bit in COG1FSIM1bits
#define FSIM12                  COG1FSIM1bits.FSIM12            // bit 4, shadows bit in COG1FSIM1bits
#define G1FSIM12                COG1FSIM1bits.G1FSIM12          // bit 4, shadows bit in COG1FSIM1bits
#define FSIM13                  COG1FSIM1bits.FSIM13            // bit 5, shadows bit in COG1FSIM1bits
#define G1FSIM13                COG1FSIM1bits.G1FSIM13          // bit 5, shadows bit in COG1FSIM1bits
#define FSIM14                  COG1FSIM1bits.FSIM14            // bit 6, shadows bit in COG1FSIM1bits
#define G1FSIM14                COG1FSIM1bits.G1FSIM14          // bit 6, shadows bit in COG1FSIM1bits
#define FSIM15                  COG1FSIM1bits.FSIM15            // bit 7, shadows bit in COG1FSIM1bits
#define G1FSIM15                COG1FSIM1bits.G1FSIM15          // bit 7, shadows bit in COG1FSIM1bits

#define PHF0                    COG1PHFbits.PHF0                // bit 0, shadows bit in COG1PHFbits
#define G1PHF0                  COG1PHFbits.G1PHF0              // bit 0, shadows bit in COG1PHFbits
#define PHF1                    COG1PHFbits.PHF1                // bit 1, shadows bit in COG1PHFbits
#define G1PHF1                  COG1PHFbits.G1PHF1              // bit 1, shadows bit in COG1PHFbits
#define PHF2                    COG1PHFbits.PHF2                // bit 2, shadows bit in COG1PHFbits
#define G1PHF2                  COG1PHFbits.G1PHF2              // bit 2, shadows bit in COG1PHFbits
#define PHF3                    COG1PHFbits.PHF3                // bit 3, shadows bit in COG1PHFbits
#define G1PHF3                  COG1PHFbits.G1PHF3              // bit 3, shadows bit in COG1PHFbits
#define PHF4                    COG1PHFbits.PHF4                // bit 4, shadows bit in COG1PHFbits
#define G1PHF4                  COG1PHFbits.G1PHF4              // bit 4, shadows bit in COG1PHFbits
#define PHF5                    COG1PHFbits.PHF5                // bit 5, shadows bit in COG1PHFbits
#define G1PHF5                  COG1PHFbits.G1PHF5              // bit 5, shadows bit in COG1PHFbits

#define PHR0                    COG1PHRbits.PHR0                // bit 0, shadows bit in COG1PHRbits
#define G1PHR0                  COG1PHRbits.G1PHR0              // bit 0, shadows bit in COG1PHRbits
#define PHR1                    COG1PHRbits.PHR1                // bit 1, shadows bit in COG1PHRbits
#define G1PHR1                  COG1PHRbits.G1PHR1              // bit 1, shadows bit in COG1PHRbits
#define PHR2                    COG1PHRbits.PHR2                // bit 2, shadows bit in COG1PHRbits
#define G1PHR2                  COG1PHRbits.G1PHR2              // bit 2, shadows bit in COG1PHRbits
#define PHR3                    COG1PHRbits.PHR3                // bit 3, shadows bit in COG1PHRbits
#define G1PHR3                  COG1PHRbits.G1PHR3              // bit 3, shadows bit in COG1PHRbits
#define PHR4                    COG1PHRbits.PHR4                // bit 4, shadows bit in COG1PHRbits
#define G1PHR4                  COG1PHRbits.G1PHR4              // bit 4, shadows bit in COG1PHRbits
#define PHR5                    COG1PHRbits.PHR5                // bit 5, shadows bit in COG1PHRbits
#define G1PHR5                  COG1PHRbits.G1PHR5              // bit 5, shadows bit in COG1PHRbits

#define RIS0                    COG1RIS0bits.RIS0               // bit 0, shadows bit in COG1RIS0bits
#define G1RIS0                  COG1RIS0bits.G1RIS0             // bit 0, shadows bit in COG1RIS0bits
#define RIS1                    COG1RIS0bits.RIS1               // bit 1, shadows bit in COG1RIS0bits
#define G1RIS1                  COG1RIS0bits.G1RIS1             // bit 1, shadows bit in COG1RIS0bits
#define RIS2                    COG1RIS0bits.RIS2               // bit 2, shadows bit in COG1RIS0bits
#define G1RIS2                  COG1RIS0bits.G1RIS2             // bit 2, shadows bit in COG1RIS0bits
#define RIS3                    COG1RIS0bits.RIS3               // bit 3, shadows bit in COG1RIS0bits
#define G1RIS3                  COG1RIS0bits.G1RIS3             // bit 3, shadows bit in COG1RIS0bits
#define RIS4                    COG1RIS0bits.RIS4               // bit 4, shadows bit in COG1RIS0bits
#define G1RIS4                  COG1RIS0bits.G1RIS4             // bit 4, shadows bit in COG1RIS0bits
#define RIS5                    COG1RIS0bits.RIS5               // bit 5, shadows bit in COG1RIS0bits
#define G1RIS5                  COG1RIS0bits.G1RIS5             // bit 5, shadows bit in COG1RIS0bits
#define RIS6                    COG1RIS0bits.RIS6               // bit 6, shadows bit in COG1RIS0bits
#define G1RIS6                  COG1RIS0bits.G1RIS6             // bit 6, shadows bit in COG1RIS0bits
#define RIS7                    COG1RIS0bits.RIS7               // bit 7, shadows bit in COG1RIS0bits
#define G1RIS7                  COG1RIS0bits.G1RIS7             // bit 7, shadows bit in COG1RIS0bits

#define RIS8                    COG1RIS1bits.RIS8               // bit 0, shadows bit in COG1RIS1bits
#define G1RIS8                  COG1RIS1bits.G1RIS8             // bit 0, shadows bit in COG1RIS1bits
#define RIS9                    COG1RIS1bits.RIS9               // bit 1, shadows bit in COG1RIS1bits
#define G1RIS9                  COG1RIS1bits.G1RIS9             // bit 1, shadows bit in COG1RIS1bits
#define RIS10                   COG1RIS1bits.RIS10              // bit 2, shadows bit in COG1RIS1bits
#define G1RIS10                 COG1RIS1bits.G1RIS10            // bit 2, shadows bit in COG1RIS1bits
#define RIS11                   COG1RIS1bits.RIS11              // bit 3, shadows bit in COG1RIS1bits
#define G1RIS11                 COG1RIS1bits.G1RIS11            // bit 3, shadows bit in COG1RIS1bits
#define RIS12                   COG1RIS1bits.RIS12              // bit 4, shadows bit in COG1RIS1bits
#define G1RIS12                 COG1RIS1bits.G1RIS12            // bit 4, shadows bit in COG1RIS1bits
#define RIS13                   COG1RIS1bits.RIS13              // bit 5, shadows bit in COG1RIS1bits
#define G1RIS13                 COG1RIS1bits.G1RIS13            // bit 5, shadows bit in COG1RIS1bits
#define RIS14                   COG1RIS1bits.RIS14              // bit 6, shadows bit in COG1RIS1bits
#define G1RIS14                 COG1RIS1bits.G1RIS14            // bit 6, shadows bit in COG1RIS1bits
#define RIS15                   COG1RIS1bits.RIS15              // bit 7, shadows bit in COG1RIS1bits
#define G1RIS15                 COG1RIS1bits.G1RIS15            // bit 7, shadows bit in COG1RIS1bits

#define RSIM0                   COG1RSIM0bits.RSIM0             // bit 0, shadows bit in COG1RSIM0bits
#define G1RSIM0                 COG1RSIM0bits.G1RSIM0           // bit 0, shadows bit in COG1RSIM0bits
#define RSIM1                   COG1RSIM0bits.RSIM1             // bit 1, shadows bit in COG1RSIM0bits
#define G1RSIM1                 COG1RSIM0bits.G1RSIM1           // bit 1, shadows bit in COG1RSIM0bits
#define RSIM2                   COG1RSIM0bits.RSIM2             // bit 2, shadows bit in COG1RSIM0bits
#define G1RSIM2                 COG1RSIM0bits.G1RSIM2           // bit 2, shadows bit in COG1RSIM0bits
#define RSIM3                   COG1RSIM0bits.RSIM3             // bit 3, shadows bit in COG1RSIM0bits
#define G1RSIM3                 COG1RSIM0bits.G1RSIM3           // bit 3, shadows bit in COG1RSIM0bits
#define RSIM4                   COG1RSIM0bits.RSIM4             // bit 4, shadows bit in COG1RSIM0bits
#define G1RSIM4                 COG1RSIM0bits.G1RSIM4           // bit 4, shadows bit in COG1RSIM0bits
#define RSIM5                   COG1RSIM0bits.RSIM5             // bit 5, shadows bit in COG1RSIM0bits
#define G1RSIM5                 COG1RSIM0bits.G1RSIM5           // bit 5, shadows bit in COG1RSIM0bits
#define RSIM6                   COG1RSIM0bits.RSIM6             // bit 6, shadows bit in COG1RSIM0bits
#define G1RSIM6                 COG1RSIM0bits.G1RSIM6           // bit 6, shadows bit in COG1RSIM0bits
#define RSIM7                   COG1RSIM0bits.RSIM7             // bit 7, shadows bit in COG1RSIM0bits
#define G1RSIM7                 COG1RSIM0bits.G1RSIM7           // bit 7, shadows bit in COG1RSIM0bits

#define RSIM8                   COG1RSIM1bits.RSIM8             // bit 0, shadows bit in COG1RSIM1bits
#define G1RSIM8                 COG1RSIM1bits.G1RSIM8           // bit 0, shadows bit in COG1RSIM1bits
#define RSIM9                   COG1RSIM1bits.RSIM9             // bit 1, shadows bit in COG1RSIM1bits
#define G1RSIM9                 COG1RSIM1bits.G1RSIM9           // bit 1, shadows bit in COG1RSIM1bits
#define RSIM10                  COG1RSIM1bits.RSIM10            // bit 2, shadows bit in COG1RSIM1bits
#define G1RSIM10                COG1RSIM1bits.G1RSIM10          // bit 2, shadows bit in COG1RSIM1bits
#define RSIM11                  COG1RSIM1bits.RSIM11            // bit 3, shadows bit in COG1RSIM1bits
#define G1RSIM11                COG1RSIM1bits.G1RSIM11          // bit 3, shadows bit in COG1RSIM1bits
#define RSIM12                  COG1RSIM1bits.RSIM12            // bit 4, shadows bit in COG1RSIM1bits
#define G1RSIM12                COG1RSIM1bits.G1RSIM12          // bit 4, shadows bit in COG1RSIM1bits
#define RSIM13                  COG1RSIM1bits.RSIM13            // bit 5, shadows bit in COG1RSIM1bits
#define G1RSIM13                COG1RSIM1bits.G1RSIM13          // bit 5, shadows bit in COG1RSIM1bits
#define RSIM14                  COG1RSIM1bits.RSIM14            // bit 6, shadows bit in COG1RSIM1bits
#define G1RSIM14                COG1RSIM1bits.G1RSIM14          // bit 6, shadows bit in COG1RSIM1bits
#define RSIM15                  COG1RSIM1bits.RSIM15            // bit 7, shadows bit in COG1RSIM1bits
#define G1RSIM15                COG1RSIM1bits.G1RSIM15          // bit 7, shadows bit in COG1RSIM1bits

#define STRA                    COG1STRbits.STRA                // bit 0, shadows bit in COG1STRbits
#define G1STRA                  COG1STRbits.G1STRA              // bit 0, shadows bit in COG1STRbits
#define STRB                    COG1STRbits.STRB                // bit 1, shadows bit in COG1STRbits
#define G1STRB                  COG1STRbits.G1STRB              // bit 1, shadows bit in COG1STRbits
#define STRC                    COG1STRbits.STRC                // bit 2, shadows bit in COG1STRbits
#define G1STRC                  COG1STRbits.G1STRC              // bit 2, shadows bit in COG1STRbits
#define STRD                    COG1STRbits.STRD                // bit 3, shadows bit in COG1STRbits
#define G1STRD                  COG1STRbits.G1STRD              // bit 3, shadows bit in COG1STRbits
#define SDATA                   COG1STRbits.SDATA               // bit 4, shadows bit in COG1STRbits
#define G1SDATA                 COG1STRbits.G1SDATA             // bit 4, shadows bit in COG1STRbits
#define SDATB                   COG1STRbits.SDATB               // bit 5, shadows bit in COG1STRbits
#define G1SDATB                 COG1STRbits.G1SDATB             // bit 5, shadows bit in COG1STRbits
#define SDATC                   COG1STRbits.SDATC               // bit 6, shadows bit in COG1STRbits
#define G1SDATC                 COG1STRbits.G1SDATC             // bit 6, shadows bit in COG1STRbits
#define SDATD                   COG1STRbits.SDATD               // bit 7, shadows bit in COG1STRbits
#define G1SDATD                 COG1STRbits.G1SDATD             // bit 7, shadows bit in COG1STRbits

#define REF0                    DAC1CON1bits.REF0               // bit 0, shadows bit in DAC1CON1bits
#define DAC1REF0                DAC1CON1bits.DAC1REF0           // bit 0, shadows bit in DAC1CON1bits
#define R0                      DAC1CON1bits.R0                 // bit 0, shadows bit in DAC1CON1bits
#define DAC1R0                  DAC1CON1bits.DAC1R0             // bit 0, shadows bit in DAC1CON1bits
#define REF1                    DAC1CON1bits.REF1               // bit 1, shadows bit in DAC1CON1bits
#define DAC1REF1                DAC1CON1bits.DAC1REF1           // bit 1, shadows bit in DAC1CON1bits
#define R1                      DAC1CON1bits.R1                 // bit 1, shadows bit in DAC1CON1bits
#define DAC1R1                  DAC1CON1bits.DAC1R1             // bit 1, shadows bit in DAC1CON1bits
#define REF2                    DAC1CON1bits.REF2               // bit 2, shadows bit in DAC1CON1bits
#define DAC1REF2                DAC1CON1bits.DAC1REF2           // bit 2, shadows bit in DAC1CON1bits
#define R2                      DAC1CON1bits.R2                 // bit 2, shadows bit in DAC1CON1bits
#define DAC1R2                  DAC1CON1bits.DAC1R2             // bit 2, shadows bit in DAC1CON1bits
#define REF3                    DAC1CON1bits.REF3               // bit 3, shadows bit in DAC1CON1bits
#define DAC1REF3                DAC1CON1bits.DAC1REF3           // bit 3, shadows bit in DAC1CON1bits
#define R3                      DAC1CON1bits.R3                 // bit 3, shadows bit in DAC1CON1bits
#define DAC1R3                  DAC1CON1bits.DAC1R3             // bit 3, shadows bit in DAC1CON1bits
#define REF4                    DAC1CON1bits.REF4               // bit 4, shadows bit in DAC1CON1bits
#define DAC1REF4                DAC1CON1bits.DAC1REF4           // bit 4, shadows bit in DAC1CON1bits
#define R4                      DAC1CON1bits.R4                 // bit 4, shadows bit in DAC1CON1bits
#define DAC1R4                  DAC1CON1bits.DAC1R4             // bit 4, shadows bit in DAC1CON1bits
#define REF5                    DAC1CON1bits.REF5               // bit 5, shadows bit in DAC1CON1bits
#define DAC1REF5                DAC1CON1bits.DAC1REF5           // bit 5, shadows bit in DAC1CON1bits
#define R5                      DAC1CON1bits.R5                 // bit 5, shadows bit in DAC1CON1bits
#define DAC1R5                  DAC1CON1bits.DAC1R5             // bit 5, shadows bit in DAC1CON1bits
#define REF6                    DAC1CON1bits.REF6               // bit 6, shadows bit in DAC1CON1bits
#define DAC1REF6                DAC1CON1bits.DAC1REF6           // bit 6, shadows bit in DAC1CON1bits
#define R6                      DAC1CON1bits.R6                 // bit 6, shadows bit in DAC1CON1bits
#define DAC1R6                  DAC1CON1bits.DAC1R6             // bit 6, shadows bit in DAC1CON1bits
#define REF7                    DAC1CON1bits.REF7               // bit 7, shadows bit in DAC1CON1bits
#define DAC1REF7                DAC1CON1bits.DAC1REF7           // bit 7, shadows bit in DAC1CON1bits
#define R7                      DAC1CON1bits.R7                 // bit 7, shadows bit in DAC1CON1bits
#define DAC1R7                  DAC1CON1bits.DAC1R7             // bit 7, shadows bit in DAC1CON1bits

#define REF8                    DAC1CON2bits.REF8               // bit 0, shadows bit in DAC1CON2bits
#define DAC1REF8                DAC1CON2bits.DAC1REF8           // bit 0, shadows bit in DAC1CON2bits
#define R8                      DAC1CON2bits.R8                 // bit 0, shadows bit in DAC1CON2bits
#define DAC1R8                  DAC1CON2bits.DAC1R8             // bit 0, shadows bit in DAC1CON2bits
#define REF9                    DAC1CON2bits.REF9               // bit 1, shadows bit in DAC1CON2bits
#define DAC1REF9                DAC1CON2bits.DAC1REF9           // bit 1, shadows bit in DAC1CON2bits
#define R9                      DAC1CON2bits.R9                 // bit 1, shadows bit in DAC1CON2bits
#define DAC1R9                  DAC1CON2bits.DAC1R9             // bit 1, shadows bit in DAC1CON2bits
#define REF10                   DAC1CON2bits.REF10              // bit 2, shadows bit in DAC1CON2bits
#define DAC1REF10               DAC1CON2bits.DAC1REF10          // bit 2, shadows bit in DAC1CON2bits
#define R10                     DAC1CON2bits.R10                // bit 2, shadows bit in DAC1CON2bits
#define DAC1R10                 DAC1CON2bits.DAC1R10            // bit 2, shadows bit in DAC1CON2bits
#define REF11                   DAC1CON2bits.REF11              // bit 3, shadows bit in DAC1CON2bits
#define DAC1REF11               DAC1CON2bits.DAC1REF11          // bit 3, shadows bit in DAC1CON2bits
#define R11                     DAC1CON2bits.R11                // bit 3, shadows bit in DAC1CON2bits
#define DAC1R11                 DAC1CON2bits.DAC1R11            // bit 3, shadows bit in DAC1CON2bits
#define REF12                   DAC1CON2bits.REF12              // bit 4, shadows bit in DAC1CON2bits
#define DAC1REF12               DAC1CON2bits.DAC1REF12          // bit 4, shadows bit in DAC1CON2bits
#define R12                     DAC1CON2bits.R12                // bit 4, shadows bit in DAC1CON2bits
#define DAC1R12                 DAC1CON2bits.DAC1R12            // bit 4, shadows bit in DAC1CON2bits
#define REF13                   DAC1CON2bits.REF13              // bit 5, shadows bit in DAC1CON2bits
#define DAC1REF13               DAC1CON2bits.DAC1REF13          // bit 5, shadows bit in DAC1CON2bits
#define R13                     DAC1CON2bits.R13                // bit 5, shadows bit in DAC1CON2bits
#define DAC1R13                 DAC1CON2bits.DAC1R13            // bit 5, shadows bit in DAC1CON2bits
#define REF14                   DAC1CON2bits.REF14              // bit 6, shadows bit in DAC1CON2bits
#define DAC1REF14               DAC1CON2bits.DAC1REF14          // bit 6, shadows bit in DAC1CON2bits
#define R14                     DAC1CON2bits.R14                // bit 6, shadows bit in DAC1CON2bits
#define DAC1R14                 DAC1CON2bits.DAC1R14            // bit 6, shadows bit in DAC1CON2bits
#define REF15                   DAC1CON2bits.REF15              // bit 7, shadows bit in DAC1CON2bits
#define DAC1REF15               DAC1CON2bits.DAC1REF15          // bit 7, shadows bit in DAC1CON2bits
#define R15                     DAC1CON2bits.R15                // bit 7, shadows bit in DAC1CON2bits
#define DAC1R15                 DAC1CON2bits.DAC1R15            // bit 7, shadows bit in DAC1CON2bits

#define DAC1LD                  DACLDbits.DAC1LD                // bit 0
#define DAC2LD                  DACLDbits.DAC2LD                // bit 1
#define DAC5LD                  DACLDbits.DAC5LD                // bit 4

#define TSRNG                   FVRCONbits.TSRNG                // bit 4
#define TSEN                    FVRCONbits.TSEN                 // bit 5
#define FVRRDY                  FVRCONbits.FVRRDY               // bit 6
#define FVREN                   FVRCONbits.FVREN                // bit 7

#define HIDB0                   HIDRVBbits.HIDB0                // bit 0
#define HIDB1                   HIDRVBbits.HIDB1                // bit 1

#define INLVE3                  INLVEbits.INLVE3                // bit 3

#define INLVLA0                 INLVLAbits.INLVLA0              // bit 0
#define INLVLA1                 INLVLAbits.INLVLA1              // bit 1
#define INLVLA2                 INLVLAbits.INLVLA2              // bit 2
#define INLVLA3                 INLVLAbits.INLVLA3              // bit 3
#define INLVLA4                 INLVLAbits.INLVLA4              // bit 4
#define INLVLA5                 INLVLAbits.INLVLA5              // bit 5
#define INLVA6                  INLVLAbits.INLVA6               // bit 6
#define INLVA7                  INLVLAbits.INLVA7               // bit 7

#define INLVB0                  INLVLBbits.INLVB0               // bit 0
#define INLVB1                  INLVLBbits.INLVB1               // bit 1
#define INLVB2                  INLVLBbits.INLVB2               // bit 2
#define INLVB3                  INLVLBbits.INLVB3               // bit 3
#define INLVLB4                 INLVLBbits.INLVLB4              // bit 4
#define INLVLB5                 INLVLBbits.INLVLB5              // bit 5
#define INLVLB6                 INLVLBbits.INLVLB6              // bit 6
#define INLVLB7                 INLVLBbits.INLVLB7              // bit 7

#define INLVLC0                 INLVLCbits.INLVLC0              // bit 0
#define INLVLC1                 INLVLCbits.INLVLC1              // bit 1
#define INLVLC2                 INLVLCbits.INLVLC2              // bit 2
#define INLVLC3                 INLVLCbits.INLVLC3              // bit 3
#define INLVLC4                 INLVLCbits.INLVLC4              // bit 4
#define INLVLC5                 INLVLCbits.INLVLC5              // bit 5
#define INLVLC6                 INLVLCbits.INLVLC6              // bit 6
#define INLVLC7                 INLVLCbits.INLVLC7              // bit 7

#define IOCIF                   INTCONbits.IOCIF                // bit 0
#define INTF                    INTCONbits.INTF                 // bit 1
#define TMR0IF                  INTCONbits.TMR0IF               // bit 2, shadows bit in INTCONbits
#define T0IF                    INTCONbits.T0IF                 // bit 2, shadows bit in INTCONbits
#define IOCIE                   INTCONbits.IOCIE                // bit 3
#define INTE                    INTCONbits.INTE                 // bit 4
#define TMR0IE                  INTCONbits.TMR0IE               // bit 5, shadows bit in INTCONbits
#define T0IE                    INTCONbits.T0IE                 // bit 5, shadows bit in INTCONbits
#define PEIE                    INTCONbits.PEIE                 // bit 6
#define GIE                     INTCONbits.GIE                  // bit 7

#define IOCAF0                  IOCAFbits.IOCAF0                // bit 0
#define IOCAF1                  IOCAFbits.IOCAF1                // bit 1
#define IOCAF2                  IOCAFbits.IOCAF2                // bit 2
#define IOCAF3                  IOCAFbits.IOCAF3                // bit 3
#define IOCAF4                  IOCAFbits.IOCAF4                // bit 4
#define IOCAF5                  IOCAFbits.IOCAF5                // bit 5
#define IOCAF6                  IOCAFbits.IOCAF6                // bit 6
#define IOCAF7                  IOCAFbits.IOCAF7                // bit 7

#define IOCAN0                  IOCANbits.IOCAN0                // bit 0
#define IOCAN1                  IOCANbits.IOCAN1                // bit 1
#define IOCAN2                  IOCANbits.IOCAN2                // bit 2
#define IOCAN3                  IOCANbits.IOCAN3                // bit 3
#define IOCAN4                  IOCANbits.IOCAN4                // bit 4
#define IOCAN5                  IOCANbits.IOCAN5                // bit 5
#define IOCAN6                  IOCANbits.IOCAN6                // bit 6
#define IOCAN7                  IOCANbits.IOCAN7                // bit 7

#define IOCAP0                  IOCAPbits.IOCAP0                // bit 0
#define IOCAP1                  IOCAPbits.IOCAP1                // bit 1
#define IOCAP2                  IOCAPbits.IOCAP2                // bit 2
#define IOCAP3                  IOCAPbits.IOCAP3                // bit 3
#define IOCAP4                  IOCAPbits.IOCAP4                // bit 4
#define IOCAP5                  IOCAPbits.IOCAP5                // bit 5
#define IOCAP6                  IOCAPbits.IOCAP6                // bit 6
#define IOCAP7                  IOCAPbits.IOCAP7                // bit 7

#define IOCBF0                  IOCBFbits.IOCBF0                // bit 0
#define IOCBF1                  IOCBFbits.IOCBF1                // bit 1
#define IOCBF2                  IOCBFbits.IOCBF2                // bit 2
#define IOCBF3                  IOCBFbits.IOCBF3                // bit 3
#define IOCBF4                  IOCBFbits.IOCBF4                // bit 4
#define IOCBF5                  IOCBFbits.IOCBF5                // bit 5
#define IOCBF6                  IOCBFbits.IOCBF6                // bit 6
#define IOCBF7                  IOCBFbits.IOCBF7                // bit 7

#define IOCBN0                  IOCBNbits.IOCBN0                // bit 0
#define IOCBN1                  IOCBNbits.IOCBN1                // bit 1
#define IOCBN2                  IOCBNbits.IOCBN2                // bit 2
#define IOCBN3                  IOCBNbits.IOCBN3                // bit 3
#define IOCBN4                  IOCBNbits.IOCBN4                // bit 4
#define IOCBN5                  IOCBNbits.IOCBN5                // bit 5
#define IOCBN6                  IOCBNbits.IOCBN6                // bit 6
#define IOCBN7                  IOCBNbits.IOCBN7                // bit 7

#define IOCBP0                  IOCBPbits.IOCBP0                // bit 0
#define IOCBP1                  IOCBPbits.IOCBP1                // bit 1
#define IOCBP2                  IOCBPbits.IOCBP2                // bit 2
#define IOCBP3                  IOCBPbits.IOCBP3                // bit 3
#define IOCBP4                  IOCBPbits.IOCBP4                // bit 4
#define IOCBP5                  IOCBPbits.IOCBP5                // bit 5
#define IOCBP6                  IOCBPbits.IOCBP6                // bit 6
#define IOCBP7                  IOCBPbits.IOCBP7                // bit 7

#define IOCCF0                  IOCCFbits.IOCCF0                // bit 0
#define IOCCF1                  IOCCFbits.IOCCF1                // bit 1
#define IOCCF2                  IOCCFbits.IOCCF2                // bit 2
#define IOCCF3                  IOCCFbits.IOCCF3                // bit 3
#define IOCCF4                  IOCCFbits.IOCCF4                // bit 4
#define IOCCF5                  IOCCFbits.IOCCF5                // bit 5
#define IOCCF6                  IOCCFbits.IOCCF6                // bit 6
#define IOCCF7                  IOCCFbits.IOCCF7                // bit 7

#define IOCCN0                  IOCCNbits.IOCCN0                // bit 0
#define IOCCN1                  IOCCNbits.IOCCN1                // bit 1
#define IOCCN2                  IOCCNbits.IOCCN2                // bit 2
#define IOCCN3                  IOCCNbits.IOCCN3                // bit 3
#define IOCCN4                  IOCCNbits.IOCCN4                // bit 4
#define IOCCN5                  IOCCNbits.IOCCN5                // bit 5
#define IOCCN6                  IOCCNbits.IOCCN6                // bit 6
#define IOCCN7                  IOCCNbits.IOCCN7                // bit 7

#define IOCCP0                  IOCCPbits.IOCCP0                // bit 0
#define IOCCP1                  IOCCPbits.IOCCP1                // bit 1
#define IOCCP2                  IOCCPbits.IOCCP2                // bit 2
#define IOCCP3                  IOCCPbits.IOCCP3                // bit 3
#define IOCCP4                  IOCCPbits.IOCCP4                // bit 4
#define IOCCP5                  IOCCPbits.IOCCP5                // bit 5
#define IOCCP6                  IOCCPbits.IOCCP6                // bit 6
#define IOCCP7                  IOCCPbits.IOCCP7                // bit 7

#define IOCEF3                  IOCEFbits.IOCEF3                // bit 3

#define IOCEN3                  IOCENbits.IOCEN3                // bit 3

#define IOCEP3                  IOCEPbits.IOCEP3                // bit 3

#define LATA0                   LATAbits.LATA0                  // bit 0
#define LATA1                   LATAbits.LATA1                  // bit 1
#define LATA2                   LATAbits.LATA2                  // bit 2
#define LATA3                   LATAbits.LATA3                  // bit 3
#define LATA4                   LATAbits.LATA4                  // bit 4
#define LATA5                   LATAbits.LATA5                  // bit 5
#define LATA6                   LATAbits.LATA6                  // bit 6
#define LATA7                   LATAbits.LATA7                  // bit 7

#define LATB0                   LATBbits.LATB0                  // bit 0
#define LATB1                   LATBbits.LATB1                  // bit 1
#define LATB2                   LATBbits.LATB2                  // bit 2
#define LATB3                   LATBbits.LATB3                  // bit 3
#define LATB4                   LATBbits.LATB4                  // bit 4
#define LATB5                   LATBbits.LATB5                  // bit 5
#define LATB6                   LATBbits.LATB6                  // bit 6
#define LATB7                   LATBbits.LATB7                  // bit 7

#define LATC0                   LATCbits.LATC0                  // bit 0
#define LATC1                   LATCbits.LATC1                  // bit 1
#define LATC2                   LATCbits.LATC2                  // bit 2
#define LATC3                   LATCbits.LATC3                  // bit 3
#define LATC4                   LATCbits.LATC4                  // bit 4
#define LATC5                   LATCbits.LATC5                  // bit 5
#define LATC6                   LATCbits.LATC6                  // bit 6
#define LATC7                   LATCbits.LATC7                  // bit 7

#define CH0                     MD1CARHbits.CH0                 // bit 0, shadows bit in MD1CARHbits
#define MD1CH0                  MD1CARHbits.MD1CH0              // bit 0, shadows bit in MD1CARHbits
#define CH1                     MD1CARHbits.CH1                 // bit 1, shadows bit in MD1CARHbits
#define MD1CH1                  MD1CARHbits.MD1CH1              // bit 1, shadows bit in MD1CARHbits
#define CH2                     MD1CARHbits.CH2                 // bit 2, shadows bit in MD1CARHbits
#define MD1CH2                  MD1CARHbits.MD1CH2              // bit 2, shadows bit in MD1CARHbits
#define CH3                     MD1CARHbits.CH3                 // bit 3, shadows bit in MD1CARHbits
#define MD1CH3                  MD1CARHbits.MD1CH3              // bit 3, shadows bit in MD1CARHbits
#define CH4                     MD1CARHbits.CH4                 // bit 4

#define CL0                     MD1CARLbits.CL0                 // bit 0, shadows bit in MD1CARLbits
#define MD1CL0                  MD1CARLbits.MD1CL0              // bit 0, shadows bit in MD1CARLbits
#define CL1                     MD1CARLbits.CL1                 // bit 1, shadows bit in MD1CARLbits
#define MD1CL1                  MD1CARLbits.MD1CL1              // bit 1, shadows bit in MD1CARLbits
#define CL2                     MD1CARLbits.CL2                 // bit 2, shadows bit in MD1CARLbits
#define MD1CL2                  MD1CARLbits.MD1CL2              // bit 2, shadows bit in MD1CARLbits
#define CL3                     MD1CARLbits.CL3                 // bit 3, shadows bit in MD1CARLbits
#define MD1CL3                  MD1CARLbits.MD1CL3              // bit 3, shadows bit in MD1CARLbits
#define CL4                     MD1CARLbits.CL4                 // bit 4

#define CLSYNC                  MD1CON1bits.CLSYNC              // bit 0, shadows bit in MD1CON1bits
#define MD1CLSYNC               MD1CON1bits.MD1CLSYNC           // bit 0, shadows bit in MD1CON1bits
#define CLPOL                   MD1CON1bits.CLPOL               // bit 1, shadows bit in MD1CON1bits
#define MD1CLPOL                MD1CON1bits.MD1CLPOL            // bit 1, shadows bit in MD1CON1bits
#define CHSYNC                  MD1CON1bits.CHSYNC              // bit 4, shadows bit in MD1CON1bits
#define MD1CHSYNC               MD1CON1bits.MD1CHSYNC           // bit 4, shadows bit in MD1CON1bits
#define CHPOL                   MD1CON1bits.CHPOL               // bit 5, shadows bit in MD1CON1bits
#define MD1CHPOL                MD1CON1bits.MD1CHPOL            // bit 5, shadows bit in MD1CON1bits

#define MS0                     MD1SRCbits.MS0                  // bit 0, shadows bit in MD1SRCbits
#define MD1MS0                  MD1SRCbits.MD1MS0               // bit 0, shadows bit in MD1SRCbits
#define MS1                     MD1SRCbits.MS1                  // bit 1, shadows bit in MD1SRCbits
#define MD1MS1                  MD1SRCbits.MD1MS1               // bit 1, shadows bit in MD1SRCbits
#define MS2                     MD1SRCbits.MS2                  // bit 2, shadows bit in MD1SRCbits
#define MD1MS2                  MD1SRCbits.MD1MS2               // bit 2, shadows bit in MD1SRCbits
#define MS3                     MD1SRCbits.MS3                  // bit 3, shadows bit in MD1SRCbits
#define MD1MS3                  MD1SRCbits.MD1MS3               // bit 3, shadows bit in MD1SRCbits
#define MS4                     MD1SRCbits.MS4                  // bit 4, shadows bit in MD1SRCbits
#define MD1MS4                  MD1SRCbits.MD1MS4               // bit 4, shadows bit in MD1SRCbits

#define ODA0                    ODCONAbits.ODA0                 // bit 0
#define ODA1                    ODCONAbits.ODA1                 // bit 1
#define ODA2                    ODCONAbits.ODA2                 // bit 2
#define ODA3                    ODCONAbits.ODA3                 // bit 3
#define ODA4                    ODCONAbits.ODA4                 // bit 4
#define ODA5                    ODCONAbits.ODA5                 // bit 5
#define ODA6                    ODCONAbits.ODA6                 // bit 6
#define ODA7                    ODCONAbits.ODA7                 // bit 7

#define ODC0                    ODCONCbits.ODC0                 // bit 0
#define ODC1                    ODCONCbits.ODC1                 // bit 1
#define ODC2                    ODCONCbits.ODC2                 // bit 2
#define ODC3                    ODCONCbits.ODC3                 // bit 3
#define ODC4                    ODCONCbits.ODC4                 // bit 4
#define ODC5                    ODCONCbits.ODC5                 // bit 5
#define ODC6                    ODCONCbits.ODC6                 // bit 6
#define ODC7                    ODCONCbits.ODC7                 // bit 7

#define PS0                     OPTION_REGbits.PS0              // bit 0
#define PS1                     OPTION_REGbits.PS1              // bit 1
#define PS2                     OPTION_REGbits.PS2              // bit 2
#define PSA                     OPTION_REGbits.PSA              // bit 3
#define TMR0SE                  OPTION_REGbits.TMR0SE           // bit 4, shadows bit in OPTION_REGbits
#define T0SE                    OPTION_REGbits.T0SE             // bit 4, shadows bit in OPTION_REGbits
#define TMR0CS                  OPTION_REGbits.TMR0CS           // bit 5, shadows bit in OPTION_REGbits
#define T0CS                    OPTION_REGbits.T0CS             // bit 5, shadows bit in OPTION_REGbits
#define INTEDG                  OPTION_REGbits.INTEDG           // bit 6
#define NOT_WPUEN               OPTION_REGbits.NOT_WPUEN        // bit 7

#define SCS0                    OSCCONbits.SCS0                 // bit 0
#define SCS1                    OSCCONbits.SCS1                 // bit 1
#define IRCF0                   OSCCONbits.IRCF0                // bit 3
#define IRCF1                   OSCCONbits.IRCF1                // bit 4
#define IRCF2                   OSCCONbits.IRCF2                // bit 5
#define IRCF3                   OSCCONbits.IRCF3                // bit 6
#define SPLLEN                  OSCCONbits.SPLLEN               // bit 7

#define HFIOFS                  OSCSTATbits.HFIOFS              // bit 0
#define LFIOFR                  OSCSTATbits.LFIOFR              // bit 1
#define MFIOFR                  OSCSTATbits.MFIOFR              // bit 2
#define HFIOFL                  OSCSTATbits.HFIOFL              // bit 3
#define HFIOFR                  OSCSTATbits.HFIOFR              // bit 4
#define OSTS                    OSCSTATbits.OSTS                // bit 5
#define PLLR                    OSCSTATbits.PLLR                // bit 6
#define SOSCR                   OSCSTATbits.SOSCR               // bit 7

#define TUN0                    OSCTUNEbits.TUN0                // bit 0
#define TUN1                    OSCTUNEbits.TUN1                // bit 1
#define TUN2                    OSCTUNEbits.TUN2                // bit 2
#define TUN3                    OSCTUNEbits.TUN3                // bit 3
#define TUN4                    OSCTUNEbits.TUN4                // bit 4
#define TUN5                    OSCTUNEbits.TUN5                // bit 5

#define NOT_BOR                 PCONbits.NOT_BOR                // bit 0
#define NOT_POR                 PCONbits.NOT_POR                // bit 1
#define NOT_RI                  PCONbits.NOT_RI                 // bit 2
#define NOT_RMCLR               PCONbits.NOT_RMCLR              // bit 3
#define NOT_RWDT                PCONbits.NOT_RWDT               // bit 4
#define STKUNF                  PCONbits.STKUNF                 // bit 6
#define STKOVF                  PCONbits.STKOVF                 // bit 7

#define TMR1IE                  PIE1bits.TMR1IE                 // bit 0
#define TMR2IE                  PIE1bits.TMR2IE                 // bit 1
#define CCP1IE                  PIE1bits.CCP1IE                 // bit 2, shadows bit in PIE1bits
#define CCPIE                   PIE1bits.CCPIE                  // bit 2, shadows bit in PIE1bits
#define SSP1IE                  PIE1bits.SSP1IE                 // bit 3
#define TXIE                    PIE1bits.TXIE                   // bit 4
#define RCIE                    PIE1bits.RCIE                   // bit 5
#define ADIE                    PIE1bits.ADIE                   // bit 6
#define TMR1GIE                 PIE1bits.TMR1GIE                // bit 7

#define CCP2IE                  PIE2bits.CCP2IE                 // bit 0
#define C3IE                    PIE2bits.C3IE                   // bit 1
#define C4IE                    PIE2bits.C4IE                   // bit 2
#define BCL1IE                  PIE2bits.BCL1IE                 // bit 3
#define COGIE                   PIE2bits.COGIE                  // bit 4
#define C1IE                    PIE2bits.C1IE                   // bit 5
#define C2IE                    PIE2bits.C2IE                   // bit 6
#define OSFIE                   PIE2bits.OSFIE                  // bit 7

#define CLC1IE                  PIE3bits.CLC1IE                 // bit 0
#define CLC2IE                  PIE3bits.CLC2IE                 // bit 1
#define CLC3IE                  PIE3bits.CLC3IE                 // bit 2
#define CLC4IE                  PIE3bits.CLC4IE                 // bit 3
#define ZCDIE                   PIE3bits.ZCDIE                  // bit 4
#define COG2IE                  PIE3bits.COG2IE                 // bit 5

#define TMR4IE                  PIE4bits.TMR4IE                 // bit 0
#define TMR6IE                  PIE4bits.TMR6IE                 // bit 1
#define TMR3IE                  PIE4bits.TMR3IE                 // bit 2
#define TMR3GIE                 PIE4bits.TMR3GIE                // bit 3
#define TMR5IE                  PIE4bits.TMR5IE                 // bit 4
#define TMR5GIE                 PIE4bits.TMR5GIE                // bit 5
#define TMR8IE                  PIE4bits.TMR8IE                 // bit 6

#define C5IE                    PIE5bits.C5IE                   // bit 0
#define C6IE                    PIE5bits.C6IE                   // bit 1
#define COG3IE                  PIE5bits.COG3IE                 // bit 4
#define CCP7IE                  PIE5bits.CCP7IE                 // bit 6

#define PWM5IE                  PIE6bits.PWM5IE                 // bit 0
#define PWM6IE                  PIE6bits.PWM6IE                 // bit 1
#define PWM11IE                 PIE6bits.PWM11IE                // bit 2

#define TMR1IF                  PIR1bits.TMR1IF                 // bit 0
#define TMR2IF                  PIR1bits.TMR2IF                 // bit 1
#define CCP1IF                  PIR1bits.CCP1IF                 // bit 2, shadows bit in PIR1bits
#define CCPIF                   PIR1bits.CCPIF                  // bit 2, shadows bit in PIR1bits
#define SSP1IF                  PIR1bits.SSP1IF                 // bit 3
#define TXIF                    PIR1bits.TXIF                   // bit 4
#define RCIF                    PIR1bits.RCIF                   // bit 5
#define ADIF                    PIR1bits.ADIF                   // bit 6
#define TMR1GIF                 PIR1bits.TMR1GIF                // bit 7

#define CCP2IF                  PIR2bits.CCP2IF                 // bit 0
#define C3IF                    PIR2bits.C3IF                   // bit 1
#define C4IF                    PIR2bits.C4IF                   // bit 2
#define BCL1IF                  PIR2bits.BCL1IF                 // bit 3
#define COG1IF                  PIR2bits.COG1IF                 // bit 4
#define C1IF                    PIR2bits.C1IF                   // bit 5
#define C2IF                    PIR2bits.C2IF                   // bit 6
#define OSFIF                   PIR2bits.OSFIF                  // bit 7

#define CLC1IF                  PIR3bits.CLC1IF                 // bit 0
#define CLC2IF                  PIR3bits.CLC2IF                 // bit 1
#define CLC3IF                  PIR3bits.CLC3IF                 // bit 2
#define CLC4IF                  PIR3bits.CLC4IF                 // bit 3
#define ZCDIF                   PIR3bits.ZCDIF                  // bit 4
#define COG2IF                  PIR3bits.COG2IF                 // bit 5

#define TMR4IF                  PIR4bits.TMR4IF                 // bit 0
#define TMR6IF                  PIR4bits.TMR6IF                 // bit 1
#define TMR3IF                  PIR4bits.TMR3IF                 // bit 2
#define TMR3GIF                 PIR4bits.TMR3GIF                // bit 3
#define TMR5IF                  PIR4bits.TMR5IF                 // bit 4
#define TMR5GIF                 PIR4bits.TMR5GIF                // bit 5
#define TMR8IF                  PIR4bits.TMR8IF                 // bit 6

#define C5IF                    PIR5bits.C5IF                   // bit 0
#define C6IF                    PIR5bits.C6IF                   // bit 1
#define COG3IF                  PIR5bits.COG3IF                 // bit 4
#define CCP7IF                  PIR5bits.CCP7IF                 // bit 6

#define PWM5IF                  PIR6bits.PWM5IF                 // bit 0
#define PWM6IF                  PIR6bits.PWM6IF                 // bit 1
#define PWM11IF                 PIR6bits.PWM11IF                // bit 2

#define RD                      PMCON1bits.RD                   // bit 0
#define WR                      PMCON1bits.WR                   // bit 1
#define WREN                    PMCON1bits.WREN                 // bit 2
#define WRERR                   PMCON1bits.WRERR                // bit 3
#define FREE                    PMCON1bits.FREE                 // bit 4
#define LWLO                    PMCON1bits.LWLO                 // bit 5
#define CFGS                    PMCON1bits.CFGS                 // bit 6

#define RA0                     PORTAbits.RA0                   // bit 0
#define RA1                     PORTAbits.RA1                   // bit 1
#define RA2                     PORTAbits.RA2                   // bit 2
#define RA3                     PORTAbits.RA3                   // bit 3
#define RA4                     PORTAbits.RA4                   // bit 4
#define RA5                     PORTAbits.RA5                   // bit 5
#define RA6                     PORTAbits.RA6                   // bit 6
#define RA7                     PORTAbits.RA7                   // bit 7

#define RB0                     PORTBbits.RB0                   // bit 0
#define RB1                     PORTBbits.RB1                   // bit 1
#define RB2                     PORTBbits.RB2                   // bit 2
#define RB3                     PORTBbits.RB3                   // bit 3
#define RB4                     PORTBbits.RB4                   // bit 4
#define RB5                     PORTBbits.RB5                   // bit 5
#define RB6                     PORTBbits.RB6                   // bit 6
#define RB7                     PORTBbits.RB7                   // bit 7

#define RC0                     PORTCbits.RC0                   // bit 0
#define RC1                     PORTCbits.RC1                   // bit 1
#define RC2                     PORTCbits.RC2                   // bit 2
#define RC3                     PORTCbits.RC3                   // bit 3
#define RC4                     PORTCbits.RC4                   // bit 4
#define RC5                     PORTCbits.RC5                   // bit 5
#define RC6                     PORTCbits.RC6                   // bit 6
#define RC7                     PORTCbits.RC7                   // bit 7

#define RE3                     PORTEbits.RE3                   // bit 3

#define PPSLOCKED               PPSLOCKbits.PPSLOCKED           // bit 0

#define RPOL                    PRG1CON1bits.RPOL               // bit 0, shadows bit in PRG1CON1bits
#define RG1RPOL                 PRG1CON1bits.RG1RPOL            // bit 0, shadows bit in PRG1CON1bits
#define FPOL                    PRG1CON1bits.FPOL               // bit 1, shadows bit in PRG1CON1bits
#define RG1FPOL                 PRG1CON1bits.RG1FPOL            // bit 1, shadows bit in PRG1CON1bits
#define RDY                     PRG1CON1bits.RDY                // bit 2, shadows bit in PRG1CON1bits
#define RG1RDY                  PRG1CON1bits.RG1RDY             // bit 2, shadows bit in PRG1CON1bits

#define ISET0                   PRG1CON2bits.ISET0              // bit 0, shadows bit in PRG1CON2bits
#define RG1ISET0                PRG1CON2bits.RG1ISET0           // bit 0, shadows bit in PRG1CON2bits
#define ISET1                   PRG1CON2bits.ISET1              // bit 1, shadows bit in PRG1CON2bits
#define RG1ISET1                PRG1CON2bits.RG1ISET1           // bit 1, shadows bit in PRG1CON2bits
#define ISET2                   PRG1CON2bits.ISET2              // bit 2, shadows bit in PRG1CON2bits
#define RG1ISET2                PRG1CON2bits.RG1ISET2           // bit 2, shadows bit in PRG1CON2bits
#define ISET3                   PRG1CON2bits.ISET3              // bit 3, shadows bit in PRG1CON2bits
#define RG1ISET3                PRG1CON2bits.RG1ISET3           // bit 3, shadows bit in PRG1CON2bits
#define ISET4                   PRG1CON2bits.ISET4              // bit 4, shadows bit in PRG1CON2bits
#define RG1ISET4                PRG1CON2bits.RG1ISET4           // bit 4, shadows bit in PRG1CON2bits

#define FTSS0                   PRG1FTSSbits.FTSS0              // bit 0, shadows bit in PRG1FTSSbits
#define RG1FTSS0                PRG1FTSSbits.RG1FTSS0           // bit 0, shadows bit in PRG1FTSSbits
#define FTSS1                   PRG1FTSSbits.FTSS1              // bit 1, shadows bit in PRG1FTSSbits
#define RG1FTSS1                PRG1FTSSbits.RG1FTSS1           // bit 1, shadows bit in PRG1FTSSbits
#define FTSS2                   PRG1FTSSbits.FTSS2              // bit 2, shadows bit in PRG1FTSSbits
#define RG1FTSS2                PRG1FTSSbits.RG1FTSS2           // bit 2, shadows bit in PRG1FTSSbits
#define FTSS3                   PRG1FTSSbits.FTSS3              // bit 3, shadows bit in PRG1FTSSbits
#define RG1FTSS3                PRG1FTSSbits.RG1FTSS3           // bit 3, shadows bit in PRG1FTSSbits

#define INS0                    PRG1INSbits.INS0                // bit 0, shadows bit in PRG1INSbits
#define RG1INS0                 PRG1INSbits.RG1INS0             // bit 0, shadows bit in PRG1INSbits
#define INS1                    PRG1INSbits.INS1                // bit 1, shadows bit in PRG1INSbits
#define RG1INS1                 PRG1INSbits.RG1INS1             // bit 1, shadows bit in PRG1INSbits
#define INS2                    PRG1INSbits.INS2                // bit 2, shadows bit in PRG1INSbits
#define RG1INS2                 PRG1INSbits.RG1INS2             // bit 2, shadows bit in PRG1INSbits
#define INS3                    PRG1INSbits.INS3                // bit 3, shadows bit in PRG1INSbits
#define RG1INS3                 PRG1INSbits.RG1INS3             // bit 3, shadows bit in PRG1INSbits

#define RTSS0                   PRG1RTSSbits.RTSS0              // bit 0, shadows bit in PRG1RTSSbits
#define RG1RTSS0                PRG1RTSSbits.RG1RTSS0           // bit 0, shadows bit in PRG1RTSSbits
#define RTSS1                   PRG1RTSSbits.RTSS1              // bit 1, shadows bit in PRG1RTSSbits
#define RG1RTSS1                PRG1RTSSbits.RG1RTSS1           // bit 1, shadows bit in PRG1RTSSbits
#define RTSS2                   PRG1RTSSbits.RTSS2              // bit 2, shadows bit in PRG1RTSSbits
#define RG1RTSS2                PRG1RTSSbits.RG1RTSS2           // bit 2, shadows bit in PRG1RTSSbits
#define RTSS3                   PRG1RTSSbits.RTSS3              // bit 3, shadows bit in PRG1RTSSbits
#define RG1RTSS3                PRG1RTSSbits.RG1RTSS3           // bit 3, shadows bit in PRG1RTSSbits

#define DC2                     PWM3DCHbits.DC2                 // bit 0, shadows bit in PWM3DCHbits
#define PWM3DC2                 PWM3DCHbits.PWM3DC2             // bit 0, shadows bit in PWM3DCHbits
#define PWMPW2                  PWM3DCHbits.PWMPW2              // bit 0, shadows bit in PWM3DCHbits
#define DC3                     PWM3DCHbits.DC3                 // bit 1, shadows bit in PWM3DCHbits
#define PWM3DC3                 PWM3DCHbits.PWM3DC3             // bit 1, shadows bit in PWM3DCHbits
#define PWMPW3                  PWM3DCHbits.PWMPW3              // bit 1, shadows bit in PWM3DCHbits
#define DC4                     PWM3DCHbits.DC4                 // bit 2, shadows bit in PWM3DCHbits
#define PWM3DC4                 PWM3DCHbits.PWM3DC4             // bit 2, shadows bit in PWM3DCHbits
#define PWMPW4                  PWM3DCHbits.PWMPW4              // bit 2, shadows bit in PWM3DCHbits
#define DC5                     PWM3DCHbits.DC5                 // bit 3, shadows bit in PWM3DCHbits
#define PWM3DC5                 PWM3DCHbits.PWM3DC5             // bit 3, shadows bit in PWM3DCHbits
#define PWMPW5                  PWM3DCHbits.PWMPW5              // bit 3, shadows bit in PWM3DCHbits
#define DC6                     PWM3DCHbits.DC6                 // bit 4, shadows bit in PWM3DCHbits
#define PWM3DC6                 PWM3DCHbits.PWM3DC6             // bit 4, shadows bit in PWM3DCHbits
#define PWMPW6                  PWM3DCHbits.PWMPW6              // bit 4, shadows bit in PWM3DCHbits
#define DC7                     PWM3DCHbits.DC7                 // bit 5, shadows bit in PWM3DCHbits
#define PWM3DC7                 PWM3DCHbits.PWM3DC7             // bit 5, shadows bit in PWM3DCHbits
#define PWMPW7                  PWM3DCHbits.PWMPW7              // bit 5, shadows bit in PWM3DCHbits
#define DC8                     PWM3DCHbits.DC8                 // bit 6, shadows bit in PWM3DCHbits
#define PWM3DC8                 PWM3DCHbits.PWM3DC8             // bit 6, shadows bit in PWM3DCHbits
#define PWMPW8                  PWM3DCHbits.PWMPW8              // bit 6, shadows bit in PWM3DCHbits
#define DC9                     PWM3DCHbits.DC9                 // bit 7, shadows bit in PWM3DCHbits
#define PWM3DC9                 PWM3DCHbits.PWM3DC9             // bit 7, shadows bit in PWM3DCHbits
#define PWMPW9                  PWM3DCHbits.PWMPW9              // bit 7, shadows bit in PWM3DCHbits

#define DC0                     PWM3DCLbits.DC0                 // bit 6, shadows bit in PWM3DCLbits
#define PWM3DC0                 PWM3DCLbits.PWM3DC0             // bit 6, shadows bit in PWM3DCLbits
#define PWMPW0                  PWM3DCLbits.PWMPW0              // bit 6, shadows bit in PWM3DCLbits
#define DC1                     PWM3DCLbits.DC1                 // bit 7, shadows bit in PWM3DCLbits
#define PWM3DC1                 PWM3DCLbits.PWM3DC1             // bit 7, shadows bit in PWM3DCLbits
#define PWMPW1                  PWM3DCLbits.PWMPW1              // bit 7, shadows bit in PWM3DCLbits

#define PWM5DCH0                PWM5DCHbits.PWM5DCH0            // bit 0
#define PWM5DCH1                PWM5DCHbits.PWM5DCH1            // bit 1
#define PWM5DCH2                PWM5DCHbits.PWM5DCH2            // bit 2
#define PWM5DCH3                PWM5DCHbits.PWM5DCH3            // bit 3
#define PWM5DCH4                PWM5DCHbits.PWM5DCH4            // bit 4
#define PWM5DCH5                PWM5DCHbits.PWM5DCH5            // bit 5
#define PWM5DCH6                PWM5DCHbits.PWM5DCH6            // bit 6
#define PWM5DCH7                PWM5DCHbits.PWM5DCH7            // bit 7

#define PWM5DCL0                PWM5DCLbits.PWM5DCL0            // bit 0
#define PWM5DCL1                PWM5DCLbits.PWM5DCL1            // bit 1
#define PWM5DCL2                PWM5DCLbits.PWM5DCL2            // bit 2
#define PWM5DCL3                PWM5DCLbits.PWM5DCL3            // bit 3
#define PWM5DCL4                PWM5DCLbits.PWM5DCL4            // bit 4
#define PWM5DCL5                PWM5DCLbits.PWM5DCL5            // bit 5
#define PWM5DCL6                PWM5DCLbits.PWM5DCL6            // bit 6
#define PWM5DCL7                PWM5DCLbits.PWM5DCL7            // bit 7

#define PRIE                    PWM5INTCONbits.PRIE             // bit 0, shadows bit in PWM5INTCONbits
#define PWM5PRIE                PWM5INTCONbits.PWM5PRIE         // bit 0, shadows bit in PWM5INTCONbits
#define DCIE                    PWM5INTCONbits.DCIE             // bit 1, shadows bit in PWM5INTCONbits
#define PWM5DCIE                PWM5INTCONbits.PWM5DCIE         // bit 1, shadows bit in PWM5INTCONbits
#define PHIE                    PWM5INTCONbits.PHIE             // bit 2, shadows bit in PWM5INTCONbits
#define PWM5PHIE                PWM5INTCONbits.PWM5PHIE         // bit 2, shadows bit in PWM5INTCONbits
#define OFIE                    PWM5INTCONbits.OFIE             // bit 3, shadows bit in PWM5INTCONbits
#define PWM5OFIE                PWM5INTCONbits.PWM5OFIE         // bit 3, shadows bit in PWM5INTCONbits

#define PRIF                    PWM5INTFbits.PRIF               // bit 0, shadows bit in PWM5INTFbits
#define PWM5PRIF                PWM5INTFbits.PWM5PRIF           // bit 0, shadows bit in PWM5INTFbits
#define DCIF                    PWM5INTFbits.DCIF               // bit 1, shadows bit in PWM5INTFbits
#define PWM5DCIF                PWM5INTFbits.PWM5DCIF           // bit 1, shadows bit in PWM5INTFbits
#define PHIF                    PWM5INTFbits.PHIF               // bit 2, shadows bit in PWM5INTFbits
#define PWM5PHIF                PWM5INTFbits.PWM5PHIF           // bit 2, shadows bit in PWM5INTFbits
#define OFIF                    PWM5INTFbits.OFIF               // bit 3, shadows bit in PWM5INTFbits
#define PWM5OFIF                PWM5INTFbits.PWM5OFIF           // bit 3, shadows bit in PWM5INTFbits

#define PWM5LDS0                PWM5LDCONbits.PWM5LDS0          // bit 0, shadows bit in PWM5LDCONbits
#define LDS0                    PWM5LDCONbits.LDS0              // bit 0, shadows bit in PWM5LDCONbits
#define PWM5LDS1                PWM5LDCONbits.PWM5LDS1          // bit 1, shadows bit in PWM5LDCONbits
#define LDS1                    PWM5LDCONbits.LDS1              // bit 1, shadows bit in PWM5LDCONbits
#define LDT                     PWM5LDCONbits.LDT               // bit 6, shadows bit in PWM5LDCONbits
#define PWM5LDM                 PWM5LDCONbits.PWM5LDM           // bit 6, shadows bit in PWM5LDCONbits
#define LDA                     PWM5LDCONbits.LDA               // bit 7, shadows bit in PWM5LDCONbits
#define PWM5LD                  PWM5LDCONbits.PWM5LD            // bit 7, shadows bit in PWM5LDCONbits

#define PWM5OFS0                PWM5OFCONbits.PWM5OFS0          // bit 0, shadows bit in PWM5OFCONbits
#define OFS0                    PWM5OFCONbits.OFS0              // bit 0, shadows bit in PWM5OFCONbits
#define PWM5OFS1                PWM5OFCONbits.PWM5OFS1          // bit 1, shadows bit in PWM5OFCONbits
#define OFS1                    PWM5OFCONbits.OFS1              // bit 1, shadows bit in PWM5OFCONbits
#define OFO                     PWM5OFCONbits.OFO               // bit 4, shadows bit in PWM5OFCONbits
#define PWM5OFMC                PWM5OFCONbits.PWM5OFMC          // bit 4, shadows bit in PWM5OFCONbits
#define PWM5OFM0                PWM5OFCONbits.PWM5OFM0          // bit 5, shadows bit in PWM5OFCONbits
#define OFM0                    PWM5OFCONbits.OFM0              // bit 5, shadows bit in PWM5OFCONbits
#define PWM5OFM1                PWM5OFCONbits.PWM5OFM1          // bit 6, shadows bit in PWM5OFCONbits
#define OFM1                    PWM5OFCONbits.OFM1              // bit 6, shadows bit in PWM5OFCONbits

#define PWM5OFH0                PWM5OFHbits.PWM5OFH0            // bit 0
#define PWM5OFH1                PWM5OFHbits.PWM5OFH1            // bit 1
#define PWM5OFH2                PWM5OFHbits.PWM5OFH2            // bit 2
#define PWM5OFH3                PWM5OFHbits.PWM5OFH3            // bit 3
#define PWM5OFH4                PWM5OFHbits.PWM5OFH4            // bit 4
#define PWM5OFH5                PWM5OFHbits.PWM5OFH5            // bit 5
#define PWM5OFH6                PWM5OFHbits.PWM5OFH6            // bit 6
#define PWM5OFH7                PWM5OFHbits.PWM5OFH7            // bit 7

#define PWM5OFL0                PWM5OFLbits.PWM5OFL0            // bit 0
#define PWM5OFL1                PWM5OFLbits.PWM5OFL1            // bit 1
#define PWM5OFL2                PWM5OFLbits.PWM5OFL2            // bit 2
#define PWM5OFL3                PWM5OFLbits.PWM5OFL3            // bit 3
#define PWM5OFL4                PWM5OFLbits.PWM5OFL4            // bit 4
#define PWM5OFL5                PWM5OFLbits.PWM5OFL5            // bit 5
#define PWM5OFL6                PWM5OFLbits.PWM5OFL6            // bit 6
#define PWM5OFL7                PWM5OFLbits.PWM5OFL7            // bit 7

#define PWM5PHH0                PWM5PHHbits.PWM5PHH0            // bit 0
#define PWM5PHH1                PWM5PHHbits.PWM5PHH1            // bit 1
#define PWM5PHH2                PWM5PHHbits.PWM5PHH2            // bit 2
#define PWM5PHH3                PWM5PHHbits.PWM5PHH3            // bit 3
#define PWM5PHH4                PWM5PHHbits.PWM5PHH4            // bit 4
#define PWM5PHH5                PWM5PHHbits.PWM5PHH5            // bit 5
#define PWM5PHH6                PWM5PHHbits.PWM5PHH6            // bit 6
#define PWM5PHH7                PWM5PHHbits.PWM5PHH7            // bit 7

#define PWM5PHL0                PWM5PHLbits.PWM5PHL0            // bit 0
#define PWM5PHL1                PWM5PHLbits.PWM5PHL1            // bit 1
#define PWM5PHL2                PWM5PHLbits.PWM5PHL2            // bit 2
#define PWM5PHL3                PWM5PHLbits.PWM5PHL3            // bit 3
#define PWM5PHL4                PWM5PHLbits.PWM5PHL4            // bit 4
#define PWM5PHL5                PWM5PHLbits.PWM5PHL5            // bit 5
#define PWM5PHL6                PWM5PHLbits.PWM5PHL6            // bit 6
#define PWM5PHL7                PWM5PHLbits.PWM5PHL7            // bit 7

#define PWM5PRH0                PWM5PRHbits.PWM5PRH0            // bit 0
#define PWM5PRH1                PWM5PRHbits.PWM5PRH1            // bit 1
#define PWM5PRH2                PWM5PRHbits.PWM5PRH2            // bit 2
#define PWM5PRH3                PWM5PRHbits.PWM5PRH3            // bit 3
#define PWM5PRH4                PWM5PRHbits.PWM5PRH4            // bit 4
#define PWM5PRH5                PWM5PRHbits.PWM5PRH5            // bit 5
#define PWM5PRH6                PWM5PRHbits.PWM5PRH6            // bit 6
#define PWM5PRH7                PWM5PRHbits.PWM5PRH7            // bit 7

#define PWM5PRL0                PWM5PRLbits.PWM5PRL0            // bit 0
#define PWM5PRL1                PWM5PRLbits.PWM5PRL1            // bit 1
#define PWM5PRL2                PWM5PRLbits.PWM5PRL2            // bit 2
#define PWM5PRL3                PWM5PRLbits.PWM5PRL3            // bit 3
#define PWM5PRL4                PWM5PRLbits.PWM5PRL4            // bit 4
#define PWM5PRL5                PWM5PRLbits.PWM5PRL5            // bit 5
#define PWM5PRL6                PWM5PRLbits.PWM5PRL6            // bit 6
#define PWM5PRL7                PWM5PRLbits.PWM5PRL7            // bit 7

#define PWM5TMRH0               PWM5TMRHbits.PWM5TMRH0          // bit 0
#define PWM5TMRH1               PWM5TMRHbits.PWM5TMRH1          // bit 1
#define PWM5TMRH2               PWM5TMRHbits.PWM5TMRH2          // bit 2
#define PWM5TMRH3               PWM5TMRHbits.PWM5TMRH3          // bit 3
#define PWM5TMRH4               PWM5TMRHbits.PWM5TMRH4          // bit 4
#define PWM5TMRH5               PWM5TMRHbits.PWM5TMRH5          // bit 5
#define PWM5TMRH6               PWM5TMRHbits.PWM5TMRH6          // bit 6
#define PWM5TMRH7               PWM5TMRHbits.PWM5TMRH7          // bit 7

#define PWM5TMRL0               PWM5TMRLbits.PWM5TMRL0          // bit 0
#define PWM5TMRL1               PWM5TMRLbits.PWM5TMRL1          // bit 1
#define PWM5TMRL2               PWM5TMRLbits.PWM5TMRL2          // bit 2
#define PWM5TMRL3               PWM5TMRLbits.PWM5TMRL3          // bit 3
#define PWM5TMRL4               PWM5TMRLbits.PWM5TMRL4          // bit 4
#define PWM5TMRL5               PWM5TMRLbits.PWM5TMRL5          // bit 5
#define PWM5TMRL6               PWM5TMRLbits.PWM5TMRL6          // bit 6
#define PWM5TMRL7               PWM5TMRLbits.PWM5TMRL7          // bit 7

#define PWM6DCH0                PWM6DCHbits.PWM6DCH0            // bit 0
#define PWM6DCH1                PWM6DCHbits.PWM6DCH1            // bit 1
#define PWM6DCH2                PWM6DCHbits.PWM6DCH2            // bit 2
#define PWM6DCH3                PWM6DCHbits.PWM6DCH3            // bit 3
#define PWM6DCH4                PWM6DCHbits.PWM6DCH4            // bit 4
#define PWM6DCH5                PWM6DCHbits.PWM6DCH5            // bit 5
#define PWM6DCH6                PWM6DCHbits.PWM6DCH6            // bit 6
#define PWM6DCH7                PWM6DCHbits.PWM6DCH7            // bit 7

#define PWM6DCL0                PWM6DCLbits.PWM6DCL0            // bit 0
#define PWM6DCL1                PWM6DCLbits.PWM6DCL1            // bit 1
#define PWM6DCL2                PWM6DCLbits.PWM6DCL2            // bit 2
#define PWM6DCL3                PWM6DCLbits.PWM6DCL3            // bit 3
#define PWM6DCL4                PWM6DCLbits.PWM6DCL4            // bit 4
#define PWM6DCL5                PWM6DCLbits.PWM6DCL5            // bit 5
#define PWM6DCL6                PWM6DCLbits.PWM6DCL6            // bit 6
#define PWM6DCL7                PWM6DCLbits.PWM6DCL7            // bit 7

#define PWM6OFH0                PWM6OFHbits.PWM6OFH0            // bit 0
#define PWM6OFH1                PWM6OFHbits.PWM6OFH1            // bit 1
#define PWM6OFH2                PWM6OFHbits.PWM6OFH2            // bit 2
#define PWM6OFH3                PWM6OFHbits.PWM6OFH3            // bit 3
#define PWM6OFH4                PWM6OFHbits.PWM6OFH4            // bit 4
#define PWM6OFH5                PWM6OFHbits.PWM6OFH5            // bit 5
#define PWM6OFH6                PWM6OFHbits.PWM6OFH6            // bit 6
#define PWM6OFH7                PWM6OFHbits.PWM6OFH7            // bit 7

#define PWM6OFL0                PWM6OFLbits.PWM6OFL0            // bit 0
#define PWM6OFL1                PWM6OFLbits.PWM6OFL1            // bit 1
#define PWM6OFL2                PWM6OFLbits.PWM6OFL2            // bit 2
#define PWM6OFL3                PWM6OFLbits.PWM6OFL3            // bit 3
#define PWM6OFL4                PWM6OFLbits.PWM6OFL4            // bit 4
#define PWM6OFL5                PWM6OFLbits.PWM6OFL5            // bit 5
#define PWM6OFL6                PWM6OFLbits.PWM6OFL6            // bit 6
#define PWM6OFL7                PWM6OFLbits.PWM6OFL7            // bit 7

#define PWM6PHH0                PWM6PHHbits.PWM6PHH0            // bit 0
#define PWM6PHH1                PWM6PHHbits.PWM6PHH1            // bit 1
#define PWM6PHH2                PWM6PHHbits.PWM6PHH2            // bit 2
#define PWM6PHH3                PWM6PHHbits.PWM6PHH3            // bit 3
#define PWM6PHH4                PWM6PHHbits.PWM6PHH4            // bit 4
#define PWM6PHH5                PWM6PHHbits.PWM6PHH5            // bit 5
#define PWM6PHH6                PWM6PHHbits.PWM6PHH6            // bit 6
#define PWM6PHH7                PWM6PHHbits.PWM6PHH7            // bit 7

#define PWM6PHL0                PWM6PHLbits.PWM6PHL0            // bit 0
#define PWM6PHL1                PWM6PHLbits.PWM6PHL1            // bit 1
#define PWM6PHL2                PWM6PHLbits.PWM6PHL2            // bit 2
#define PWM6PHL3                PWM6PHLbits.PWM6PHL3            // bit 3
#define PWM6PHL4                PWM6PHLbits.PWM6PHL4            // bit 4
#define PWM6PHL5                PWM6PHLbits.PWM6PHL5            // bit 5
#define PWM6PHL6                PWM6PHLbits.PWM6PHL6            // bit 6
#define PWM6PHL7                PWM6PHLbits.PWM6PHL7            // bit 7

#define PWM6PRH0                PWM6PRHbits.PWM6PRH0            // bit 0
#define PWM6PRH1                PWM6PRHbits.PWM6PRH1            // bit 1
#define PWM6PRH2                PWM6PRHbits.PWM6PRH2            // bit 2
#define PWM6PRH3                PWM6PRHbits.PWM6PRH3            // bit 3
#define PWM6PRH4                PWM6PRHbits.PWM6PRH4            // bit 4
#define PWM6PRH5                PWM6PRHbits.PWM6PRH5            // bit 5
#define PWM6PRH6                PWM6PRHbits.PWM6PRH6            // bit 6
#define PWM6PRH7                PWM6PRHbits.PWM6PRH7            // bit 7

#define PWM6PRL0                PWM6PRLbits.PWM6PRL0            // bit 0
#define PWM6PRL1                PWM6PRLbits.PWM6PRL1            // bit 1
#define PWM6PRL2                PWM6PRLbits.PWM6PRL2            // bit 2
#define PWM6PRL3                PWM6PRLbits.PWM6PRL3            // bit 3
#define PWM6PRL4                PWM6PRLbits.PWM6PRL4            // bit 4
#define PWM6PRL5                PWM6PRLbits.PWM6PRL5            // bit 5
#define PWM6PRL6                PWM6PRLbits.PWM6PRL6            // bit 6
#define PWM6PRL7                PWM6PRLbits.PWM6PRL7            // bit 7

#define PWM6TMRH0               PWM6TMRHbits.PWM6TMRH0          // bit 0
#define PWM6TMRH1               PWM6TMRHbits.PWM6TMRH1          // bit 1
#define PWM6TMRH2               PWM6TMRHbits.PWM6TMRH2          // bit 2
#define PWM6TMRH3               PWM6TMRHbits.PWM6TMRH3          // bit 3
#define PWM6TMRH4               PWM6TMRHbits.PWM6TMRH4          // bit 4
#define PWM6TMRH5               PWM6TMRHbits.PWM6TMRH5          // bit 5
#define PWM6TMRH6               PWM6TMRHbits.PWM6TMRH6          // bit 6
#define PWM6TMRH7               PWM6TMRHbits.PWM6TMRH7          // bit 7

#define PWM6TMRL0               PWM6TMRLbits.PWM6TMRL0          // bit 0
#define PWM6TMRL1               PWM6TMRLbits.PWM6TMRL1          // bit 1
#define PWM6TMRL2               PWM6TMRLbits.PWM6TMRL2          // bit 2
#define PWM6TMRL3               PWM6TMRLbits.PWM6TMRL3          // bit 3
#define PWM6TMRL4               PWM6TMRLbits.PWM6TMRL4          // bit 4
#define PWM6TMRL5               PWM6TMRLbits.PWM6TMRL5          // bit 5
#define PWM6TMRL6               PWM6TMRLbits.PWM6TMRL6          // bit 6
#define PWM6TMRL7               PWM6TMRLbits.PWM6TMRL7          // bit 7

#define PWM11DCH0               PWM11DCHbits.PWM11DCH0          // bit 0
#define PWM11DCH1               PWM11DCHbits.PWM11DCH1          // bit 1
#define PWM11DCH2               PWM11DCHbits.PWM11DCH2          // bit 2
#define PWM11DCH3               PWM11DCHbits.PWM11DCH3          // bit 3
#define PWM11DCH4               PWM11DCHbits.PWM11DCH4          // bit 4
#define PWM11DCH5               PWM11DCHbits.PWM11DCH5          // bit 5
#define PWM11DCH6               PWM11DCHbits.PWM11DCH6          // bit 6
#define PWM11DCH7               PWM11DCHbits.PWM11DCH7          // bit 7

#define PWM11DCL0               PWM11DCLbits.PWM11DCL0          // bit 0
#define PWM11DCL1               PWM11DCLbits.PWM11DCL1          // bit 1
#define PWM11DCL2               PWM11DCLbits.PWM11DCL2          // bit 2
#define PWM11DCL3               PWM11DCLbits.PWM11DCL3          // bit 3
#define PWM11DCL4               PWM11DCLbits.PWM11DCL4          // bit 4
#define PWM11DCL5               PWM11DCLbits.PWM11DCL5          // bit 5
#define PWM11DCL6               PWM11DCLbits.PWM11DCL6          // bit 6
#define PWM11DCL7               PWM11DCLbits.PWM11DCL7          // bit 7

#define PWM11OFH0               PWM11OFHbits.PWM11OFH0          // bit 0
#define PWM11OFH1               PWM11OFHbits.PWM11OFH1          // bit 1
#define PWM11OFH2               PWM11OFHbits.PWM11OFH2          // bit 2
#define PWM11OFH3               PWM11OFHbits.PWM11OFH3          // bit 3
#define PWM11OFH4               PWM11OFHbits.PWM11OFH4          // bit 4
#define PWM11OFH5               PWM11OFHbits.PWM11OFH5          // bit 5
#define PWM11OFH6               PWM11OFHbits.PWM11OFH6          // bit 6
#define PWM11OFH7               PWM11OFHbits.PWM11OFH7          // bit 7

#define PWM11OFL0               PWM11OFLbits.PWM11OFL0          // bit 0
#define PWM11OFL1               PWM11OFLbits.PWM11OFL1          // bit 1
#define PWM11OFL2               PWM11OFLbits.PWM11OFL2          // bit 2
#define PWM11OFL3               PWM11OFLbits.PWM11OFL3          // bit 3
#define PWM11OFL4               PWM11OFLbits.PWM11OFL4          // bit 4
#define PWM11OFL5               PWM11OFLbits.PWM11OFL5          // bit 5
#define PWM11OFL6               PWM11OFLbits.PWM11OFL6          // bit 6
#define PWM11OFL7               PWM11OFLbits.PWM11OFL7          // bit 7

#define PWM11PHH0               PWM11PHHbits.PWM11PHH0          // bit 0
#define PWM11PHH1               PWM11PHHbits.PWM11PHH1          // bit 1
#define PWM11PHH2               PWM11PHHbits.PWM11PHH2          // bit 2
#define PWM11PHH3               PWM11PHHbits.PWM11PHH3          // bit 3
#define PWM11PHH4               PWM11PHHbits.PWM11PHH4          // bit 4
#define PWM11PHH5               PWM11PHHbits.PWM11PHH5          // bit 5
#define PWM11PHH6               PWM11PHHbits.PWM11PHH6          // bit 6
#define PWM11PHH7               PWM11PHHbits.PWM11PHH7          // bit 7

#define PWM11PHL0               PWM11PHLbits.PWM11PHL0          // bit 0
#define PWM11PHL1               PWM11PHLbits.PWM11PHL1          // bit 1
#define PWM11PHL2               PWM11PHLbits.PWM11PHL2          // bit 2
#define PWM11PHL3               PWM11PHLbits.PWM11PHL3          // bit 3
#define PWM11PHL4               PWM11PHLbits.PWM11PHL4          // bit 4
#define PWM11PHL5               PWM11PHLbits.PWM11PHL5          // bit 5
#define PWM11PHL6               PWM11PHLbits.PWM11PHL6          // bit 6
#define PWM11PHL7               PWM11PHLbits.PWM11PHL7          // bit 7

#define PWM11PRH0               PWM11PRHbits.PWM11PRH0          // bit 0
#define PWM11PRH1               PWM11PRHbits.PWM11PRH1          // bit 1
#define PWM11PRH2               PWM11PRHbits.PWM11PRH2          // bit 2
#define PWM11PRH3               PWM11PRHbits.PWM11PRH3          // bit 3
#define PWM11PRH4               PWM11PRHbits.PWM11PRH4          // bit 4
#define PWM11PRH5               PWM11PRHbits.PWM11PRH5          // bit 5
#define PWM11PRH6               PWM11PRHbits.PWM11PRH6          // bit 6
#define PWM11PRH7               PWM11PRHbits.PWM11PRH7          // bit 7

#define PWM11PRL0               PWM11PRLbits.PWM11PRL0          // bit 0
#define PWM11PRL1               PWM11PRLbits.PWM11PRL1          // bit 1
#define PWM11PRL2               PWM11PRLbits.PWM11PRL2          // bit 2
#define PWM11PRL3               PWM11PRLbits.PWM11PRL3          // bit 3
#define PWM11PRL4               PWM11PRLbits.PWM11PRL4          // bit 4
#define PWM11PRL5               PWM11PRLbits.PWM11PRL5          // bit 5
#define PWM11PRL6               PWM11PRLbits.PWM11PRL6          // bit 6
#define PWM11PRL7               PWM11PRLbits.PWM11PRL7          // bit 7

#define PWM11TMRH0              PWM11TMRHbits.PWM11TMRH0        // bit 0
#define PWM11TMRH1              PWM11TMRHbits.PWM11TMRH1        // bit 1
#define PWM11TMRH2              PWM11TMRHbits.PWM11TMRH2        // bit 2
#define PWM11TMRH3              PWM11TMRHbits.PWM11TMRH3        // bit 3
#define PWM11TMRH4              PWM11TMRHbits.PWM11TMRH4        // bit 4
#define PWM11TMRH5              PWM11TMRHbits.PWM11TMRH5        // bit 5
#define PWM11TMRH6              PWM11TMRHbits.PWM11TMRH6        // bit 6
#define PWM11TMRH7              PWM11TMRHbits.PWM11TMRH7        // bit 7

#define PWM11TMRL0              PWM11TMRLbits.PWM11TMRL0        // bit 0
#define PWM11TMRL1              PWM11TMRLbits.PWM11TMRL1        // bit 1
#define PWM11TMRL2              PWM11TMRLbits.PWM11TMRL2        // bit 2
#define PWM11TMRL3              PWM11TMRLbits.PWM11TMRL3        // bit 3
#define PWM11TMRL4              PWM11TMRLbits.PWM11TMRL4        // bit 4
#define PWM11TMRL5              PWM11TMRLbits.PWM11TMRL5        // bit 5
#define PWM11TMRL6              PWM11TMRLbits.PWM11TMRL6        // bit 6
#define PWM11TMRL7              PWM11TMRLbits.PWM11TMRL7        // bit 7

#define MPWM5EN                 PWMENbits.MPWM5EN               // bit 0
#define MPWM6EN                 PWMENbits.MPWM6EN               // bit 1
#define MPWM11EN                PWMENbits.MPWM11EN              // bit 2

#define MPWM5LD                 PWMLDbits.MPWM5LD               // bit 0
#define MPWM6LD                 PWMLDbits.MPWM6LD               // bit 1
#define MPWM11LD                PWMLDbits.MPWM11LD              // bit 2

#define MPWM5OUT                PWMOUTbits.MPWM5OUT             // bit 0
#define MPWM6OUT                PWMOUTbits.MPWM6OUT             // bit 1
#define MPWM11OUT               PWMOUTbits.MPWM11OUT            // bit 2

#define RX9D                    RC1STAbits.RX9D                 // bit 0
#define OERR                    RC1STAbits.OERR                 // bit 1
#define FERR                    RC1STAbits.FERR                 // bit 2
#define ADDEN                   RC1STAbits.ADDEN                // bit 3
#define CREN                    RC1STAbits.CREN                 // bit 4
#define SREN                    RC1STAbits.SREN                 // bit 5
#define RX9                     RC1STAbits.RX9                  // bit 6
#define SPEN                    RC1STAbits.SPEN                 // bit 7

#define SLRA0                   SLRCONAbits.SLRA0               // bit 0
#define SLRA1                   SLRCONAbits.SLRA1               // bit 1
#define SLRA2                   SLRCONAbits.SLRA2               // bit 2
#define SLRA3                   SLRCONAbits.SLRA3               // bit 3
#define SLRA4                   SLRCONAbits.SLRA4               // bit 4
#define SLRA5                   SLRCONAbits.SLRA5               // bit 5
#define SLRA6                   SLRCONAbits.SLRA6               // bit 6
#define SLRA7                   SLRCONAbits.SLRA7               // bit 7

#define SLRB0                   SLRCONBbits.SLRB0               // bit 0
#define SLRB1                   SLRCONBbits.SLRB1               // bit 1
#define SLRB2                   SLRCONBbits.SLRB2               // bit 2
#define SLRB3                   SLRCONBbits.SLRB3               // bit 3
#define SLRB4                   SLRCONBbits.SLRB4               // bit 4
#define SLRB5                   SLRCONBbits.SLRB5               // bit 5
#define SLRB6                   SLRCONBbits.SLRB6               // bit 6
#define SLRB7                   SLRCONBbits.SLRB7               // bit 7

#define SLRC0                   SLRCONCbits.SLRC0               // bit 0
#define SLRC1                   SLRCONCbits.SLRC1               // bit 1
#define SLRC2                   SLRCONCbits.SLRC2               // bit 2
#define SLRC3                   SLRCONCbits.SLRC3               // bit 3
#define SLRC4                   SLRCONCbits.SLRC4               // bit 4
#define SLRC5                   SLRCONCbits.SLRC5               // bit 5
#define SLRC6                   SLRCONCbits.SLRC6               // bit 6
#define SLRC7                   SLRCONCbits.SLRC7               // bit 7

#define SSP1ADD0                SSP1ADDbits.SSP1ADD0            // bit 0, shadows bit in SSP1ADDbits
#define ADD0                    SSP1ADDbits.ADD0                // bit 0, shadows bit in SSP1ADDbits
#define SSP1ADD1                SSP1ADDbits.SSP1ADD1            // bit 1, shadows bit in SSP1ADDbits
#define ADD1                    SSP1ADDbits.ADD1                // bit 1, shadows bit in SSP1ADDbits
#define SSP1ADD2                SSP1ADDbits.SSP1ADD2            // bit 2, shadows bit in SSP1ADDbits
#define ADD2                    SSP1ADDbits.ADD2                // bit 2, shadows bit in SSP1ADDbits
#define SSP1ADD3                SSP1ADDbits.SSP1ADD3            // bit 3, shadows bit in SSP1ADDbits
#define ADD3                    SSP1ADDbits.ADD3                // bit 3, shadows bit in SSP1ADDbits
#define SSP1ADD4                SSP1ADDbits.SSP1ADD4            // bit 4, shadows bit in SSP1ADDbits
#define ADD4                    SSP1ADDbits.ADD4                // bit 4, shadows bit in SSP1ADDbits
#define SSP1ADD5                SSP1ADDbits.SSP1ADD5            // bit 5, shadows bit in SSP1ADDbits
#define ADD5                    SSP1ADDbits.ADD5                // bit 5, shadows bit in SSP1ADDbits
#define SSP1ADD6                SSP1ADDbits.SSP1ADD6            // bit 6, shadows bit in SSP1ADDbits
#define ADD6                    SSP1ADDbits.ADD6                // bit 6, shadows bit in SSP1ADDbits
#define SSP1ADD7                SSP1ADDbits.SSP1ADD7            // bit 7, shadows bit in SSP1ADDbits
#define ADD7                    SSP1ADDbits.ADD7                // bit 7, shadows bit in SSP1ADDbits

#define SSP1BUF0                SSP1BUFbits.SSP1BUF0            // bit 0, shadows bit in SSP1BUFbits
#define BUF0                    SSP1BUFbits.BUF0                // bit 0, shadows bit in SSP1BUFbits
#define SSP1BUF1                SSP1BUFbits.SSP1BUF1            // bit 1, shadows bit in SSP1BUFbits
#define BUF1                    SSP1BUFbits.BUF1                // bit 1, shadows bit in SSP1BUFbits
#define SSP1BUF2                SSP1BUFbits.SSP1BUF2            // bit 2, shadows bit in SSP1BUFbits
#define BUF2                    SSP1BUFbits.BUF2                // bit 2, shadows bit in SSP1BUFbits
#define SSP1BUF3                SSP1BUFbits.SSP1BUF3            // bit 3, shadows bit in SSP1BUFbits
#define BUF3                    SSP1BUFbits.BUF3                // bit 3, shadows bit in SSP1BUFbits
#define SSP1BUF4                SSP1BUFbits.SSP1BUF4            // bit 4, shadows bit in SSP1BUFbits
#define BUF4                    SSP1BUFbits.BUF4                // bit 4, shadows bit in SSP1BUFbits
#define SSP1BUF5                SSP1BUFbits.SSP1BUF5            // bit 5, shadows bit in SSP1BUFbits
#define BUF5                    SSP1BUFbits.BUF5                // bit 5, shadows bit in SSP1BUFbits
#define SSP1BUF6                SSP1BUFbits.SSP1BUF6            // bit 6, shadows bit in SSP1BUFbits
#define BUF6                    SSP1BUFbits.BUF6                // bit 6, shadows bit in SSP1BUFbits
#define SSP1BUF7                SSP1BUFbits.SSP1BUF7            // bit 7, shadows bit in SSP1BUFbits
#define BUF7                    SSP1BUFbits.BUF7                // bit 7, shadows bit in SSP1BUFbits

#define SSPM0                   SSP1CONbits.SSPM0               // bit 0
#define SSPM1                   SSP1CONbits.SSPM1               // bit 1
#define SSPM2                   SSP1CONbits.SSPM2               // bit 2
#define SSPM3                   SSP1CONbits.SSPM3               // bit 3
#define CKP                     SSP1CONbits.CKP                 // bit 4
#define SSPEN                   SSP1CONbits.SSPEN               // bit 5
#define SSPOV                   SSP1CONbits.SSPOV               // bit 6
#define WCOL                    SSP1CONbits.WCOL                // bit 7

#define SEN                     SSP1CON2bits.SEN                // bit 0
#define RSEN                    SSP1CON2bits.RSEN               // bit 1
#define PEN                     SSP1CON2bits.PEN                // bit 2
#define RCEN                    SSP1CON2bits.RCEN               // bit 3
#define ACKEN                   SSP1CON2bits.ACKEN              // bit 4
#define ACKDT                   SSP1CON2bits.ACKDT              // bit 5
#define ACKSTAT                 SSP1CON2bits.ACKSTAT            // bit 6
#define GCEN                    SSP1CON2bits.GCEN               // bit 7

#define DHEN                    SSP1CON3bits.DHEN               // bit 0
#define AHEN                    SSP1CON3bits.AHEN               // bit 1
#define SBCDE                   SSP1CON3bits.SBCDE              // bit 2
#define SDAHT                   SSP1CON3bits.SDAHT              // bit 3
#define BOEN                    SSP1CON3bits.BOEN               // bit 4
#define SCIE                    SSP1CON3bits.SCIE               // bit 5
#define PCIE                    SSP1CON3bits.PCIE               // bit 6
#define ACKTIM                  SSP1CON3bits.ACKTIM             // bit 7

#define SSP1MSK0                SSP1MSKbits.SSP1MSK0            // bit 0, shadows bit in SSP1MSKbits
#define MSK0                    SSP1MSKbits.MSK0                // bit 0, shadows bit in SSP1MSKbits
#define SSP1MSK1                SSP1MSKbits.SSP1MSK1            // bit 1, shadows bit in SSP1MSKbits
#define MSK1                    SSP1MSKbits.MSK1                // bit 1, shadows bit in SSP1MSKbits
#define SSP1MSK2                SSP1MSKbits.SSP1MSK2            // bit 2, shadows bit in SSP1MSKbits
#define MSK2                    SSP1MSKbits.MSK2                // bit 2, shadows bit in SSP1MSKbits
#define SSP1MSK3                SSP1MSKbits.SSP1MSK3            // bit 3, shadows bit in SSP1MSKbits
#define MSK3                    SSP1MSKbits.MSK3                // bit 3, shadows bit in SSP1MSKbits
#define SSP1MSK4                SSP1MSKbits.SSP1MSK4            // bit 4, shadows bit in SSP1MSKbits
#define MSK4                    SSP1MSKbits.MSK4                // bit 4, shadows bit in SSP1MSKbits
#define SSP1MSK5                SSP1MSKbits.SSP1MSK5            // bit 5, shadows bit in SSP1MSKbits
#define MSK5                    SSP1MSKbits.MSK5                // bit 5, shadows bit in SSP1MSKbits
#define SSP1MSK6                SSP1MSKbits.SSP1MSK6            // bit 6, shadows bit in SSP1MSKbits
#define MSK6                    SSP1MSKbits.MSK6                // bit 6, shadows bit in SSP1MSKbits
#define SSP1MSK7                SSP1MSKbits.SSP1MSK7            // bit 7, shadows bit in SSP1MSKbits
#define MSK7                    SSP1MSKbits.MSK7                // bit 7, shadows bit in SSP1MSKbits

#define BF                      SSP1STATbits.BF                 // bit 0
#define UA                      SSP1STATbits.UA                 // bit 1
#define R_NOT_W                 SSP1STATbits.R_NOT_W            // bit 2
#define S                       SSP1STATbits.S                  // bit 3
#define P                       SSP1STATbits.P                  // bit 4
#define D_NOT_A                 SSP1STATbits.D_NOT_A            // bit 5
#define CKE                     SSP1STATbits.CKE                // bit 6
#define SMP                     SSP1STATbits.SMP                // bit 7

#define C                       STATUSbits.C                    // bit 0
#define DC                      STATUSbits.DC                   // bit 1
#define Z                       STATUSbits.Z                    // bit 2
#define NOT_PD                  STATUSbits.NOT_PD               // bit 3
#define NOT_TO                  STATUSbits.NOT_TO               // bit 4

#define C_SHAD                  STATUS_SHADbits.C_SHAD          // bit 0
#define DC_SHAD                 STATUS_SHADbits.DC_SHAD         // bit 1
#define Z_SHAD                  STATUS_SHADbits.Z_SHAD          // bit 2

#define GSS0                    T1GCONbits.GSS0                 // bit 0, shadows bit in T1GCONbits
#define T1GSS0                  T1GCONbits.T1GSS0               // bit 0, shadows bit in T1GCONbits
#define GSS1                    T1GCONbits.GSS1                 // bit 1, shadows bit in T1GCONbits
#define T1GSS1                  T1GCONbits.T1GSS1               // bit 1, shadows bit in T1GCONbits
#define GVAL                    T1GCONbits.GVAL                 // bit 2, shadows bit in T1GCONbits
#define T1GVAL                  T1GCONbits.T1GVAL               // bit 2, shadows bit in T1GCONbits
#define GGO_NOT_DONE            T1GCONbits.GGO_NOT_DONE         // bit 3, shadows bit in T1GCONbits
#define T1GGO_NOT_DONE          T1GCONbits.T1GGO_NOT_DONE       // bit 3, shadows bit in T1GCONbits
#define GSPM                    T1GCONbits.GSPM                 // bit 4, shadows bit in T1GCONbits
#define T1GSPM                  T1GCONbits.T1GSPM               // bit 4, shadows bit in T1GCONbits
#define GTM                     T1GCONbits.GTM                  // bit 5, shadows bit in T1GCONbits
#define T1GTM                   T1GCONbits.T1GTM                // bit 5, shadows bit in T1GCONbits
#define GPOL                    T1GCONbits.GPOL                 // bit 6, shadows bit in T1GCONbits
#define T1GPOL                  T1GCONbits.T1GPOL               // bit 6, shadows bit in T1GCONbits
#define GE                      T1GCONbits.GE                   // bit 7, shadows bit in T1GCONbits
#define T1GE                    T1GCONbits.T1GE                 // bit 7, shadows bit in T1GCONbits
#define TMR1GE                  T1GCONbits.TMR1GE               // bit 7, shadows bit in T1GCONbits

#define RSEL0                   T2RSTbits.RSEL0                 // bit 0, shadows bit in T2RSTbits
#define T2RSEL0                 T2RSTbits.T2RSEL0               // bit 0, shadows bit in T2RSTbits
#define RSEL1                   T2RSTbits.RSEL1                 // bit 1, shadows bit in T2RSTbits
#define T2RSEL1                 T2RSTbits.T2RSEL1               // bit 1, shadows bit in T2RSTbits
#define RSEL2                   T2RSTbits.RSEL2                 // bit 2, shadows bit in T2RSTbits
#define T2RSEL2                 T2RSTbits.T2RSEL2               // bit 2, shadows bit in T2RSTbits
#define RSEL3                   T2RSTbits.RSEL3                 // bit 3, shadows bit in T2RSTbits
#define T2RSEL3                 T2RSTbits.T2RSEL3               // bit 3, shadows bit in T2RSTbits
#define RSEL4                   T2RSTbits.RSEL4                 // bit 4, shadows bit in T2RSTbits
#define T2RSEL4                 T2RSTbits.T2RSEL4               // bit 4, shadows bit in T2RSTbits

#define TRISA0                  TRISAbits.TRISA0                // bit 0
#define TRISA1                  TRISAbits.TRISA1                // bit 1
#define TRISA2                  TRISAbits.TRISA2                // bit 2
#define TRISA3                  TRISAbits.TRISA3                // bit 3
#define TRISA4                  TRISAbits.TRISA4                // bit 4
#define TRISA5                  TRISAbits.TRISA5                // bit 5
#define TRISA6                  TRISAbits.TRISA6                // bit 6
#define TRISA7                  TRISAbits.TRISA7                // bit 7

#define TRISB0                  TRISBbits.TRISB0                // bit 0
#define TRISB1                  TRISBbits.TRISB1                // bit 1
#define TRISB2                  TRISBbits.TRISB2                // bit 2
#define TRISB3                  TRISBbits.TRISB3                // bit 3
#define TRISB4                  TRISBbits.TRISB4                // bit 4
#define TRISB5                  TRISBbits.TRISB5                // bit 5
#define TRISB6                  TRISBbits.TRISB6                // bit 6
#define TRISB7                  TRISBbits.TRISB7                // bit 7

#define TRISC0                  TRISCbits.TRISC0                // bit 0
#define TRISC1                  TRISCbits.TRISC1                // bit 1
#define TRISC2                  TRISCbits.TRISC2                // bit 2
#define TRISC3                  TRISCbits.TRISC3                // bit 3
#define TRISC4                  TRISCbits.TRISC4                // bit 4
#define TRISC5                  TRISCbits.TRISC5                // bit 5
#define TRISC6                  TRISCbits.TRISC6                // bit 6
#define TRISC7                  TRISCbits.TRISC7                // bit 7

#define TRISE3                  TRISEbits.TRISE3                // bit 3

#define SWDTEN                  WDTCONbits.SWDTEN               // bit 0
#define WDTPS0                  WDTCONbits.WDTPS0               // bit 1
#define WDTPS1                  WDTCONbits.WDTPS1               // bit 2
#define WDTPS2                  WDTCONbits.WDTPS2               // bit 3
#define WDTPS3                  WDTCONbits.WDTPS3               // bit 4
#define WDTPS4                  WDTCONbits.WDTPS4               // bit 5

#define WPUA0                   WPUAbits.WPUA0                  // bit 0
#define WPUA1                   WPUAbits.WPUA1                  // bit 1
#define WPUA2                   WPUAbits.WPUA2                  // bit 2
#define WPUA3                   WPUAbits.WPUA3                  // bit 3
#define WPUA4                   WPUAbits.WPUA4                  // bit 4
#define WPUA5                   WPUAbits.WPUA5                  // bit 5
#define WPUA6                   WPUAbits.WPUA6                  // bit 6
#define WPUA7                   WPUAbits.WPUA7                  // bit 7

#define WPUB0                   WPUBbits.WPUB0                  // bit 0
#define WPUB1                   WPUBbits.WPUB1                  // bit 1
#define WPUB2                   WPUBbits.WPUB2                  // bit 2
#define WPUB3                   WPUBbits.WPUB3                  // bit 3
#define WPUB4                   WPUBbits.WPUB4                  // bit 4
#define WPUB5                   WPUBbits.WPUB5                  // bit 5
#define WPUB6                   WPUBbits.WPUB6                  // bit 6
#define WPUB7                   WPUBbits.WPUB7                  // bit 7

#define WPUC0                   WPUCbits.WPUC0                  // bit 0
#define WPUC1                   WPUCbits.WPUC1                  // bit 1
#define WPUC2                   WPUCbits.WPUC2                  // bit 2
#define WPUC3                   WPUCbits.WPUC3                  // bit 3
#define WPUC4                   WPUCbits.WPUC4                  // bit 4
#define WPUC5                   WPUCbits.WPUC5                  // bit 5
#define WPUC6                   WPUCbits.WPUC6                  // bit 6
#define WPUC7                   WPUCbits.WPUC7                  // bit 7

#define WPUE3                   WPUEbits.WPUE3                  // bit 3

#define ZCD1INTN                ZCD1CONbits.ZCD1INTN            // bit 0
#define ZCD1INTP                ZCD1CONbits.ZCD1INTP            // bit 1
#define ZCD1POL                 ZCD1CONbits.ZCD1POL             // bit 4
#define ZCD1OUT                 ZCD1CONbits.ZCD1OUT             // bit 5
#define ZCD1EN                  ZCD1CONbits.ZCD1EN              // bit 7

#endif // #ifndef NO_BIT_DEFINES

#endif // #ifndef __PIC16LF1773_H__
