/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.lang.invoke.MethodHandles;
import java.util.List;
import org.apache.http.HttpResponse;
import org.apache.solr.client.solrj.impl.ConcurrentUpdateSolrClient;
import org.apache.solr.common.SolrException;
import org.apache.solr.update.SolrCmdDistributor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ErrorReportingConcurrentUpdateSolrClient
extends ConcurrentUpdateSolrClient {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final SolrCmdDistributor.Req req;
    private final List<SolrCmdDistributor.Error> errors;

    public ErrorReportingConcurrentUpdateSolrClient(Builder builder) {
        super((ConcurrentUpdateSolrClient.Builder)builder);
        this.req = builder.req;
        this.errors = builder.errors;
    }

    public void handleError(Throwable ex) {
        this.req.trackRequestResult(null, false);
        log.error("error", ex);
        SolrCmdDistributor.Error error = new SolrCmdDistributor.Error();
        error.e = (Exception)ex;
        if (ex instanceof SolrException) {
            error.statusCode = ((SolrException)ex).code();
        }
        error.req = this.req;
        this.errors.add(error);
    }

    public void onSuccess(HttpResponse resp) {
        this.req.trackRequestResult(resp, true);
    }

    static class Builder
    extends ConcurrentUpdateSolrClient.Builder {
        protected SolrCmdDistributor.Req req;
        protected List<SolrCmdDistributor.Error> errors;

        public Builder(String baseSolrUrl, SolrCmdDistributor.Req req, List<SolrCmdDistributor.Error> errors) {
            super(baseSolrUrl);
            this.req = req;
            this.errors = errors;
        }

        public ErrorReportingConcurrentUpdateSolrClient build() {
            return new ErrorReportingConcurrentUpdateSolrClient(this);
        }
    }
}

