/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.blockterms;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.TermStats;
import org.apache.lucene.codecs.blockterms.TermsIndexWriterBase;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RAMOutputStream;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.packed.MonotonicBlockPackedWriter;

public class FixedGapTermsIndexWriter
extends TermsIndexWriterBase {
    protected IndexOutput out;
    static final String TERMS_INDEX_EXTENSION = "tii";
    static final String CODEC_NAME = "FixedGapTermsIndex";
    static final int VERSION_START = 4;
    static final int VERSION_CURRENT = 4;
    static final int BLOCKSIZE = 4096;
    private final int termIndexInterval;
    public static final int DEFAULT_TERM_INDEX_INTERVAL = 32;
    private final List<SimpleFieldWriter> fields = new ArrayList<SimpleFieldWriter>();

    public FixedGapTermsIndexWriter(SegmentWriteState state) throws IOException {
        this(state, 32);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FixedGapTermsIndexWriter(SegmentWriteState state, int termIndexInterval) throws IOException {
        if (termIndexInterval <= 0) {
            throw new IllegalArgumentException("invalid termIndexInterval: " + termIndexInterval);
        }
        this.termIndexInterval = termIndexInterval;
        String indexFileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)TERMS_INDEX_EXTENSION);
        this.out = state.directory.createOutput(indexFileName, state.context);
        boolean success = false;
        try {
            CodecUtil.writeIndexHeader((DataOutput)this.out, (String)CODEC_NAME, (int)4, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
            this.out.writeVInt(termIndexInterval);
            this.out.writeVInt(2);
            this.out.writeVInt(4096);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.out});
            throw throwable;
        }
    }

    @Override
    public TermsIndexWriterBase.FieldWriter addField(FieldInfo field, long termsFilePointer) {
        SimpleFieldWriter writer = new SimpleFieldWriter(field, termsFilePointer);
        this.fields.add(writer);
        return writer;
    }

    protected int indexedTermPrefixLength(BytesRef priorTerm, BytesRef indexedTerm) {
        return StringHelper.sortKeyLength((BytesRef)priorTerm, (BytesRef)indexedTerm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        block7: {
            block8: {
                block6: {
                    if (this.out == null) break block7;
                    boolean success = false;
                    try {
                        SimpleFieldWriter field;
                        int i;
                        long dirStart = this.out.getFilePointer();
                        int fieldCount = this.fields.size();
                        int nonNullFieldCount = 0;
                        for (i = 0; i < fieldCount; ++i) {
                            field = this.fields.get(i);
                            if (field.numIndexTerms <= 0) continue;
                            ++nonNullFieldCount;
                        }
                        this.out.writeVInt(nonNullFieldCount);
                        for (i = 0; i < fieldCount; ++i) {
                            field = this.fields.get(i);
                            if (field.numIndexTerms <= 0) continue;
                            this.out.writeVInt(field.fieldInfo.number);
                            this.out.writeVInt(field.numIndexTerms);
                            this.out.writeVLong(field.termsStart);
                            this.out.writeVLong(field.indexStart);
                            this.out.writeVLong(field.packedIndexStart);
                            this.out.writeVLong(field.packedOffsetsStart);
                        }
                        this.writeTrailer(dirStart);
                        CodecUtil.writeFooter((IndexOutput)this.out);
                        success = true;
                        if (!success) break block6;
                    }
                    catch (Throwable throwable) {
                        if (success) {
                            IOUtils.close((Closeable[])new Closeable[]{this.out});
                        } else {
                            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.out});
                        }
                        this.out = null;
                        throw throwable;
                    }
                    IOUtils.close((Closeable[])new Closeable[]{this.out});
                    break block8;
                }
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.out});
            }
            this.out = null;
        }
    }

    private void writeTrailer(long dirStart) throws IOException {
        this.out.writeLong(dirStart);
    }

    private class SimpleFieldWriter
    extends TermsIndexWriterBase.FieldWriter {
        final FieldInfo fieldInfo;
        int numIndexTerms;
        final long indexStart;
        final long termsStart;
        long packedIndexStart;
        long packedOffsetsStart;
        private long numTerms;
        private RAMOutputStream offsetsBuffer;
        private MonotonicBlockPackedWriter termOffsets;
        private long currentOffset;
        private RAMOutputStream addressBuffer;
        private MonotonicBlockPackedWriter termAddresses;
        private final BytesRefBuilder lastTerm;

        SimpleFieldWriter(FieldInfo fieldInfo, long termsFilePointer) {
            super(FixedGapTermsIndexWriter.this);
            this.offsetsBuffer = new RAMOutputStream();
            this.termOffsets = new MonotonicBlockPackedWriter((DataOutput)this.offsetsBuffer, 4096);
            this.addressBuffer = new RAMOutputStream();
            this.termAddresses = new MonotonicBlockPackedWriter((DataOutput)this.addressBuffer, 4096);
            this.lastTerm = new BytesRefBuilder();
            this.fieldInfo = fieldInfo;
            this.indexStart = FixedGapTermsIndexWriter.this.out.getFilePointer();
            this.termsStart = termsFilePointer;
            try {
                this.termOffsets.add(0L);
            }
            catch (IOException bogus) {
                throw new RuntimeException(bogus);
            }
        }

        @Override
        public boolean checkIndexTerm(BytesRef text, TermStats stats) throws IOException {
            if (0L == this.numTerms++ % (long)FixedGapTermsIndexWriter.this.termIndexInterval) {
                return true;
            }
            if (0L == this.numTerms % (long)FixedGapTermsIndexWriter.this.termIndexInterval) {
                this.lastTerm.copyBytes(text);
            }
            return false;
        }

        @Override
        public void add(BytesRef text, TermStats stats, long termsFilePointer) throws IOException {
            int indexedTermLength = FixedGapTermsIndexWriter.this.indexedTermPrefixLength(this.lastTerm.get(), text);
            FixedGapTermsIndexWriter.this.out.writeBytes(text.bytes, text.offset, indexedTermLength);
            this.termAddresses.add(termsFilePointer - this.termsStart);
            assert (indexedTermLength <= Short.MAX_VALUE);
            this.currentOffset += (long)indexedTermLength;
            this.termOffsets.add(this.currentOffset);
            this.lastTerm.copyBytes(text);
            ++this.numIndexTerms;
        }

        @Override
        public void finish(long termsFilePointer) throws IOException {
            this.packedIndexStart = FixedGapTermsIndexWriter.this.out.getFilePointer();
            this.termAddresses.finish();
            this.addressBuffer.writeTo((DataOutput)FixedGapTermsIndexWriter.this.out);
            this.packedOffsetsStart = FixedGapTermsIndexWriter.this.out.getFilePointer();
            this.termOffsets.finish();
            this.offsetsBuffer.writeTo((DataOutput)FixedGapTermsIndexWriter.this.out);
            this.termAddresses = null;
            this.termOffsets = null;
            this.offsetsBuffer = null;
            this.addressBuffer = null;
        }
    }
}

